/*
 * @(#)SwingConstants.java	1.4 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
package com.sun.java.swing;


/**
 * A collection of constants generally used for positioning and orienting
 * components on the screen.
 *
 * @version 1.4 01/30/98
 * @author Jeff Dinkins
 */
public interface SwingConstants {

        /** 
         * The central position in an area. Used for
         * both compass-direction constants (NORTH, etc.)
         * and box-orientation constants (TOP, etc.).
         */
        public static final int CENTER  = 0;

        /** 
         * Box-orientation constants used to specify a position.
         */
        public static final int TOP     = 1;
        public static final int LEFT    = 2;
        public static final int BOTTOM  = 3;
        public static final int RIGHT   = 4;

        /** 
         * Compass-direction constants used to specify a position.
         */
        public static final int NORTH      = 1;
        public static final int NORTH_EAST = 2;
        public static final int EAST       = 3;
        public static final int SOUTH_EAST = 4;
        public static final int SOUTH      = 5;
        public static final int SOUTH_WEST = 6;
        public static final int WEST       = 7;
        public static final int NORTH_WEST = 8;

	/**
	 * These constants specify a horizontal or 
	 * vertical orientation. For example, they are
	 * used by scrollbars and sliders.
	 */
        public static final int HORIZONTAL = 0;
        public static final int VERTICAL   = 1;	
}


