/*
 * @(#)MenuSelectionManager.java	1.7 98/02/07
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import java.awt.*;
import java.util.*;
import java.awt.event.*;

/* A MenuSelectionManager owns the selection in menu hierarchy.
 * 
 * @version 1.7 02/07/98
 * @author Arnaud Weber
 */

public class MenuSelectionManager {
    private static final MenuSelectionManager instance = 
        new MenuSelectionManager();

    Vector selection = new Vector();

    public static MenuSelectionManager defaultManager() {
        return instance;
    }
    
    /*
     * Change the selection in the menu hierarchy
     */
    public void setSelectedPath(MenuElement path[]) {
        int i,c;
        int currentSelectionCount = selection.size();
        int firstDifference = 0;

        if(path == null) {
            path = new MenuElement[0];
        }

        for(i=0,c=path.length;i<c;i++) {
            if(i < currentSelectionCount && (MenuElement)selection.elementAt(i) == path[i]) 
                firstDifference++;
            else
                break;
        }

        for(i=currentSelectionCount - 1 ; i >= firstDifference ; i--) {
            ((MenuElement)selection.elementAt(i)).menuSelectionChanged(false);
            selection.removeElementAt(i);
        }

        for(i = firstDifference, c = path.length ; i < c ; i++) {
            path[i].menuSelectionChanged(true);
            selection.addElement(path[i]);
        }

        /**
        System.out.println("Selection is (");
        for(i=0,c=selection.size();i<c;i++){
            MenuElement me = (MenuElement) selection.elementAt(i);
            if(me instanceof JMenu) 
                System.out.print(((JMenu)me).getText() + ", ");
            else if(me instanceof JMenuItem) 
                System.out.print(((JMenuItem)me).getText() + ", ");                
            else
                System.out.print("" + me + ", ");
        }
        System.out.println(")");
        **/
    }

    public MenuElement[] getSelectedPath() {
        MenuElement res[] = new MenuElement[selection.size()];
        int i,c;
        for(i=0,c=selection.size();i<c;i++) 
            res[i] = (MenuElement) selection.elementAt(i);
        return res;
    }

    /*
     * Tell the menu selection to close and unselect all the menu components. Call this method
     * when a choice has been made
     */
    public void clearSelectedPath() {
        setSelectedPath(null);
    }

    /*
     * When a MenuElement receives an event from a MouseListener, it should never process the event
     * directly. Instead all MenuElements should call this method with the event.
     */
    public void processMouseEvent(MouseEvent event) {
        int screenX,screenY;
        Point p;
        int i,c,j,d;
        Component mc;
        Rectangle r2;
        int cWidth,cHeight;
        MenuElement menuElement;
        MenuElement subElements[];
        MenuElement path[];
        Vector tmp;
        int selectionSize;
        p = event.getPoint();
	
	Component source = (Component)event.getSource();
	
	if (!source.isShowing()) {
 	    System.err.println("Received a mouse event from a non-showing Component " + source);
	    return;
	}

        SwingUtilities.convertPointToScreen(p,source);

        screenX = p.x;
        screenY = p.y;
        //System.out.println("MouseEvent is " +event + " scr loc " + new Point(screenX,screenY));
        tmp = (Vector)selection.clone();
        selectionSize = tmp.size();
        for(i=selectionSize - 1 ; i >= 0 ; i--) {
            menuElement = (MenuElement) tmp.elementAt(i);
            subElements = menuElement.getSubElements();
            
            path = null;
            for(j = 0, d = subElements.length ; j < d ; j++) {
		if (subElements[j] == null)
		    continue;
                mc = subElements[j].getComponent();
                if(!mc.isShowing())
                    continue;
                if(mc instanceof JComponent) {
                    cWidth  = ((JComponent)mc).getWidth();
                    cHeight = ((JComponent)mc).getHeight();
                } else {
                    r2 = mc.getBounds();
                    cWidth  = r2.width;
                    cHeight = r2.height;
                }
                p.x = screenX;
                p.y = screenY;
                SwingUtilities.convertPointFromScreen(p,mc);

                /** Send the event to visible menu element if menu element currently in
                 *  the selected path or contains the event location
                 */
                if((i < (selectionSize-1) && tmp.elementAt(i+1) == subElements[j]) ||
                   (p.x >= 0 && p.x < cWidth && p.y >= 0 && p.y < cHeight)) {
                    int k;
                    if(path == null) {
                        path = new MenuElement[i+2];
                        for(k=0;k<=i;k++)
                            path[k] = (MenuElement)tmp.elementAt(k);
                    }
                    path[i+1] = subElements[j];
                    subElements[j].processMouseEvent(new MouseEvent(mc,event.getID(),event.getWhen(),
                                                                    event.getModifiers(),p.x,p.y,
                                                                    event.getClickCount(),
                                                                    event.isPopupTrigger()),
                                                     path,this);
                }
            }
        }
    }

    /*
     * Returns the component in the currently selected path 
     * which contains sourcePoint.
     *
     * @param source The component in whose coordinate space sourcePoint
     * is given
     * @param sourcePoint The point which is being tested
     * @return The component in the currently selected path which
     * contains sourcePoint (relative to the source component's 
     * coordinate space.  If sourcePoint is not inside a component
     * on the currently selected path, null is returned.
     */
    public Component componentForPoint(Component source, Point sourcePoint) {
        int screenX,screenY;
        Point p = sourcePoint;
        int i,c,j,d;
        Component mc;
        Rectangle r2;
        int cWidth,cHeight;
        MenuElement menuElement;
        MenuElement subElements[];
        Vector tmp;
        int selectionSize;

        SwingUtilities.convertPointToScreen(p,source);

        screenX = p.x;
        screenY = p.y;

        tmp = (Vector)selection.clone();
        selectionSize = tmp.size();
        for(i=selectionSize - 1 ; i >= 0 ; i--) {
            menuElement = (MenuElement) tmp.elementAt(i);
            subElements = menuElement.getSubElements();
            
            for(j = 0, d = subElements.length ; j < d ; j++) {
		if (subElements[j] == null)
		    continue;
                mc = subElements[j].getComponent();
                if(!mc.isShowing())
                    continue;
                if(mc instanceof JComponent) {
                    cWidth  = ((JComponent)mc).getWidth();
                    cHeight = ((JComponent)mc).getHeight();
                } else {
                    r2 = mc.getBounds();
                    cWidth  = r2.width;
                    cHeight = r2.height;
                }
                p.x = screenX;
                p.y = screenY;
                SwingUtilities.convertPointFromScreen(p,mc);
		
                /** Return the deepest component on the selection
		 *  path in whose bounds the event's point occurs
                 */
                if (p.x >= 0 && p.x < cWidth && p.y >= 0 && p.y < cHeight) {
                    return mc;
                }
            }
        }
	return null;
    }

    /*
     * When a MenuElement receives an event from a KeyListener, it should never process the event
     * directly. Instead all MenuElements should call this method with the event.
     */
    public void processKeyEvent(KeyEvent e) {
        Vector tmp;
        int selectionSize;
        int i,j,d;
        MenuElement menuElement;
        MenuElement subElements[];
        MenuElement path[];
        Component mc;

        tmp = (Vector)selection.clone();
        selectionSize = tmp.size();
        for(i=selectionSize - 1 ; i >= 0 ; i--) {
            menuElement = (MenuElement) tmp.elementAt(i);
            subElements = menuElement.getSubElements();
            
            path = null;
            for(j = 0, d = subElements.length ; j < d ; j++) {
		if (subElements[j] == null)
		    continue;
                mc = subElements[j].getComponent();
                if(!mc.isShowing())
                    continue;
                if(path == null) {
                    int k;
                    path = new MenuElement[i+2];
                    for(k=0;k<=i;k++)
                        path[k] = (MenuElement)tmp.elementAt(k);
                    }
                path[i+1] = subElements[j];
                subElements[j].processKeyEvent(e,path,this);
                if(e.isConsumed())
                    return;
            }
        }
    }
    
    /** 
     * Return true if c is part of the currently used menu
     */
    public boolean isComponentPartOfCurrentMenu(Component c) {
        if(selection.size() > 0) {
            MenuElement me = (MenuElement)selection.elementAt(0);
            return isComponentPartOfCurrentMenu(me,c);
        } else
            return false;
    }

    private boolean isComponentPartOfCurrentMenu(MenuElement root,Component c) {
        MenuElement children[];
        int i,d;
	
	if (root == null)
	    return false;

        if(root.getComponent() == c)
            return true;
        else {
            children = root.getSubElements();
            for(i=0,d=children.length;i<d;i++) {
                if(isComponentPartOfCurrentMenu(children[i],c))
                    return true;
            }
        }
        return false;
    }
}


