/*
 * @(#)JRadioButtonMenuItem.java	1.19 98/02/27
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import java.util.EventListener;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.accessibility.*;

/**
 * An implementation of a RadioButtonMenuItem. A RadioButtonMenuItem is
 * a menu item that is part of a group of menu items in which only one
 * item in the group can be selected. The selected item displays its
 * selected state. Selecting it causes any other selected item to
 * switch to the unselected state.
 * Used with a ButtonGroup object to create a group of menu items
 * in which only one item at a time can be selected. (Create a ButtonGroup
 * object and use its <code>add</code> method to include the JRadioButtonMenuItem
 * objects in the group.)
 * <p>
 * For the keyboard keys used by this component in the standard Look and
 * Feel (L&F) renditions, see the
 * <a href="doc-files/Key-Index.html#JRadioButtonMenuItem">JRadioButtonMenuItem</a> key assignments.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @beaninfo
 *   attribute: isContainer false
 *
 * @version 1.19 02/27/98
 * @author Georges Saab
 * @author David Karlton
 * @see ButtonGroup
 */
public class JRadioButtonMenuItem extends JMenuItem implements Accessible {
    /**
     * Creates a JRadioButtonMenuItem with no set text or icon.
     */
    public JRadioButtonMenuItem() {
        this(null, null);
    }

    /**
     * Creates a JRadioButtonMenuItem with an icon.
     *
     * @param icon the Icon to display on the RadioButtonMenuItem.
     */
    public JRadioButtonMenuItem(Icon icon) {
        this(null, icon);
    }

    /**
     * Creates a JRadioButtonMenuItem with text.
     *
     * @param text the text of the RadioButtonMenuItem.
     */
    public JRadioButtonMenuItem(String text) {
        this(text, null);
    }
    
    /**
     * Creates a JRadioButtonMenuItem with the specified text
     * and Icon.
     *
     * @param text the text of the RadioButtonMenuItem
     * @param icon the icon to display on the RadioButtonMenuItem
     */
    public JRadioButtonMenuItem(String text, Icon icon) {
        setModel(new JToggleButton.ToggleButtonModel());
        init(text, icon);
        setBorderPainted(false);
        setFocusPainted(false);
        setHorizontalTextPosition(JButton.RIGHT);
        setHorizontalAlignment(JButton.LEFT);
        // setArmedPainted(false);
        updateUI();
    }

    /**
     * Initialize the JRadioButtonMenuItem with the specified text
     * and Icon.
     *
     * @param text the text to display
     * @param icon the icon to display
     */
    protected void init(String text, Icon icon) {
        setLayout(new OverlayLayout(this));

        if(text != null) {
            setText(text);
            
            if(icon != null) {
                setVerticalTextPosition(BOTTOM);
            } 
        }
        
        if(icon != null) {
            setIcon(icon);
        }
        
        // Listen for Focus events
        addFocusListener(
            new FocusListener() {
            public void focusGained(FocusEvent event) {}
            public void focusLost(FocusEvent event) {
                // When focus is lost, repaint if 
                // we focus information is painted
                if(isFocusPainted()) {
                    repaint();
                }
            }
        }
        );
    }
    
    /**
     * Sets the L&F object that renders this component.
     *
     * @param ui the RadioButtonMenuItemUI L&F object
     * @see UIDefaults#getUI
     * @beaninfo
     * description: The menu item's UI delegate
     *       bound: true
     *      expert: true
     *      hidden: true
     */
    public void setUI(RadioButtonMenuItemUI ui) {
        super.setUI(ui);
    }
    
    /**
     * Notification from the UIFactory that the L&F has changed. 
     * Called to replace the UI with the latest version from the 
     * UIFactory.
     *
     * @see JComponent#updateUI
     */
    public void updateUI() {
        setUI((RadioButtonMenuItemUI)UIManager.getUI(this));
    }


    /**
     * Returns the name of the L&F class that renders this component.
     *
     * @return "RadioButtonMenuItemUI"
     * @see JComponent#getUIClassID
     * @see UIDefaults#getUI
     */
    public String getUIClassID() {
        return "RadioButtonMenuItemUI";
    }


    /*
     * Override Component.requestFocus() to not grab focus.
     */
    public void requestFocus() {}


/////////////////                                                 
// Accessibility support
////////////////

    /**
     * Get the AccessibleContext associated with this JComponent
     *
     * @return the AccessibleContext of this JComponent
     */
    public AccessibleContext getAccessibleContext() {
        if (accessibleContext == null) {
            accessibleContext = new AccessibleJRadioButtonMenuItem();
        }
        return accessibleContext;
    }

    /**
     * The class used to obtain the accessible role for this object.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class AccessibleJRadioButtonMenuItem extends AccessibleJMenuItem {
        /**
         * Get the role of this object.
         *
         * @return an instance of AccessibleRole describing the role of the 
         * object
         */
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.RADIO_BUTTON;
        }
    } // inner class AccessibleJRadioButtonMenuItem
}

