/*
 * @(#)JPasswordField.java	1.22 98/04/09
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import com.sun.java.swing.text.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.accessibility.*;

/**
 * JPasswordField is a lightweight component that allows the editing 
 * of a single line of text where the view indicates something was
 * typed, but does not show the original characters. It is intended 
 * to be source-compatible with java.awt.TextField used with echoChar 
 * set.  It is provided seperately to make it easier to safely change 
 * the ui for the JTextField without affecting password entries.
 * <p>
 * For the keyboard keys used by this component in the standard Look and
 * Feel (L&F) renditions, see the
 * <a href="doc-files/Key-Index.html#JPasswordField">JPasswordField</a>
 * key assignments.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @beaninfo
 *  attribute: isContainer false
 *
 * @author  Timothy Prinzing
 * @version 1.22, 04/09/98
 */
public class JPasswordField extends JTextField {

    /**
     * Constructs a new JPasswordField, with a default document, null starting
     * text string, and 0 column width.
     */
    public JPasswordField() {
        this(null,null,0);
    }

    /**
     * Constructs a new JPasswordField initialized with the specified text.
     * The document model is set to the default, and the number of columns to 0.
     *
     * @param text the text to be displayed, null if none
     */
    public JPasswordField(String text) {
        this(null, text, 0);
    }

    /**
     * Constructs a new empty JPasswordField with the specified
     * number of columns.  A default model is created, and the initial string
     * is set to null.
     *
     * @param columns the number of columns >= 0
     */ 
    public JPasswordField(int columns) {
        this(null, null, columns);
    }

    /**
     * Constructs a new JPasswordField initialized with the specified text
     * and columns.  The document model is set to the default.
     *
     * @param text the text to be displayed, null if none
     * @param columns the number of columns >= 0
     */
    public JPasswordField(String text, int columns) {
        this(null, text, columns);
    }

    /**
     * Constructs a new JPasswordField that uses the given text storage
     * model and the given number of columns.  This is the constructor
     * through which the other constructors feed.  The echo character is
     * set to '*'.  If the document model is null, a default one will be
     * created.
     *
     * @param doc  the text storage to use
     * @param txt the text to be displayed, null if none
     * @param columns  the number of columns to use to calculate 
     *   the preferred width >= 0.  If columns is set to zero, the
     *   preferred width will be whatever naturally results from
     *   the component implementation.
     */
    public JPasswordField(Document doc, String txt, int columns) {
        super(doc, txt, columns);
        echoChar = '*';
    }

    /**
     * Returns the name of the L&F class that renders this component.
     *
     * @return "PasswordFieldUI"
     * @see JComponent#getUIClassID
     * @see UIDefaults#getUI
     */
    public String getUIClassID() {
        return "PasswordFieldUI";
    }


    /**
     * Returns the character to be used for echoing.  The default is '*'.
     *
     * @return the echo character, 0 if unset
     * @see #setEchoChar
     * @see #echoCharIsSet
     */
    public char getEchoChar() {
        return echoChar;
    }

    /**
     * Sets the echo character for this JPasswordField.  Note 
     * that this is largely a suggestion to the view as the
     * view that gets installed can use whatever graphic techniques
     * it desires to represent the field.  Setting a value of 0 unsets
     * the echo character.
     *
     * @param c the echo character to display
     * @see #echoCharIsSet
     * @see #getEchoChar
     * @beaninfo
     * description: character to display in place of the real characters
     */
    public void setEchoChar(char c) {
        echoChar = c;
    }

    /**
     * Returns true if this JPasswordField has a character set for
     * echoing.  A character is considered to be set if the echo character
     * is not 0.
     *
     * @return true if a character is set for echoing
     * @see #setEchoChar
     * @see #getEchoChar
     */
    public boolean echoCharIsSet() {
        return echoChar != 0;
    }

    // --- JTextComponent methods ----------------------------------

    /**
     * Normally transfers the currently selected range in the associated
     * text model to the system clipboard, removing the contents
     * from the model.  This is not a good thing for a password field
     * and is reimplemented to simply beep.
     */
    public void cut() {
	getToolkit().beep();
    }

    /**
     * Normally transfers the currently selected range in the associated
     * text model to the system clipboard, leaving the contents
     * in the text model.  This is not a good thing for a password field
     * and is reimplemented to simply beep.
     */
    public void copy() {
	getToolkit().beep();
    }

    // --- variables -----------------------------------------------

    private char echoChar;

/////////////////
// Accessibility support
////////////////


    /**
     * Gets the AccessibleContext associated with this JPasswordField.
     * A new context is created as necessary.
     *
     * @return the AccessibleContext of this JPasswordField
     */
    public AccessibleContext getAccessibleContext() {
        if (accessibleContext == null) {
            accessibleContext = new AccessibleJPasswordField();
        }
        return accessibleContext;
    }

    /**
     * The class used to obtain the accessible role for this object.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class AccessibleJPasswordField extends AccessibleJTextField {

        /**
         * Gets the role of this object.
         *
         * @return an instance of AccessibleRole describing the role of the
         *   object (AccessibleRole.PASSWORD_TEXT)
         * @see AccessibleRole
         */
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PASSWORD_TEXT;
        }
    }
}
