/*
 * @(#)JPanel.java	1.21 98/03/20
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import com.sun.java.accessibility.*;
import java.awt.*;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.UIResource;

/**
 * JPanel is a generic lightweight container.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @see <a href="http://java.sun.com/products/jfc/swingdoc-archive/mixing.html">
 * Mixing Heavy and Light Components</a>
 *
 * @beaninfo
 * description: A generic lightweight container.
 * 
 * @version 1.21 03/20/98
 * @author Arnaud Weber
 */
public class JPanel extends JComponent implements Accessible
{
    private static final FlowLayout defaultLayout = new FlowLayout();
    
    /**
     * Creates a new JPanel with the specified layout manager and buffering
     * strategy.
     *
     * @param layout  the LayoutManager to use
     * @param isDoubleBuffered  a boolean, true for double-buffering, which
     *        uses additional memory space to achieve fast, flicker-free 
     *        updates
     */
    public JPanel(LayoutManager layout, boolean isDoubleBuffered) {
        setLayout(layout);
        setDoubleBuffered(isDoubleBuffered);
        setOpaque(true);
        // PENDING(jeff) - this should be done in BasicPanelUI
        // PENDING(steve) - if such a class existed... ;-)

        Color bg = this.getBackground();
        if (bg == null || bg instanceof UIResource) {
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        Color fg = this.getForeground();
        if (fg == null || fg instanceof UIResource) {
            this.setForeground(UIManager.getColor("Panel.foreground"));
        } 

        Font font = this.getFont();
        if (font == null || font instanceof UIResource) {
            this.setFont(UIManager.getFont("Panel.font"));
        } 
    }

    /**
     * Create a new buffered JPanel with the specified layout manager
     *
     * @param layout  the LayoutManager to use
     */
    public JPanel(LayoutManager layout) {
        this(layout, true);
    }

    /**
     * Create a new JPanel with FlowLayout and the specified buffering
     * strategy. If <code>isDoubleBuffered</code> is true, the JPanel 
     * will use a double buffer.
     *
     * @param layout  the LayoutManager to use
     * @param isDoubleBuffered  a boolean, true for double-buffering, which
     *        uses additional memory space to achieve fast, flicker-free 
     *        updates
     */
    public JPanel(boolean isDoubleBuffered) {
        this(defaultLayout, isDoubleBuffered);
    }

    /**
     * Create a new JPanel with a double buffer and a flow layout
     */
    public JPanel() {
        this(defaultLayout, true);
    }

    /**
     * PENDING(jeff) - this should be done in BasicPanelUI
     */
    public void updateUI() {
        super.updateUI();
        if(getBackground() == null || getBackground() instanceof UIResource) {
            setBackground(UIManager.getColor("Panel.background"));
        }
    }

    
    /**
     * Overriden from JComponent, paint the backgroud if the component is opaque.
     * The color used is the one returned by getBackground()
     * Override this method if you want to change how the JPanel paints its background.
     *
     * @param g the Graphics context in which the painting occurs
     */
    public void paintComponent(Graphics g) {
        if(isOpaque()) {
            g.setColor(getBackground());
            g.fillRect(0,0,getWidth(),getHeight());
        } 
    }

/////////////////
// Accessibility support
////////////////

    /**
     * Get the AccessibleContext associated with this JComponent
     *
     * @return the AccessibleContext of this JComponent
     */
    public AccessibleContext getAccessibleContext() {
        if (accessibleContext == null) {
            accessibleContext = new AccessibleJPanel();
        }
        return accessibleContext;
    }

    /**
     * The class used to obtain the accessible role for this object.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class AccessibleJPanel extends AccessibleJComponent {

        /**
         * Get the role of this object.
         *
         * @return an instance of AccessibleRole describing the role of the 
         * object
         */
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

