 /*
 * @(#)JCheckBoxMenuItem.java	1.27 98/03/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import java.util.EventListener;
import java.awt.*;
import java.awt.event.*;
import java.awt.image.*;
import com.sun.java.swing.plaf.*;
import com.sun.java.accessibility.*;


/**
 * A menu item that can be selected or deselected. If selected, the menu
 * item typically appears with a checkmark next to it. If unselected or
 * deselected, the menu item appears without a checkmark. Like a regular
 * menu item, a checkbox menu item can have either text or a graphic
 * icon associated with it, or both.
 * <p>
 * Either <code>isSelected</code>/<code>setSelected</code> or 
 * <code>getState</code>/<code>setState</code> can be used
 * to determine/specify the menu item's selection state. (The
 * Swing-standard methods are <code>isSelected</code> and
 * <code>setSelected</code>. These methods work for all menus and buttons.
 * The <code>getState</code> and <code>setState</code> methods exist for
 * compatibility with other component sets.)
 * <p>
 * For the keyboard keys used by this component in the standard Look and
 * Feel (L&F) renditions, see the
 * <a href="doc-files/Key-Index.html#JCheckBoxMenuItem">JCheckBoxMenuItem</a> key assignments.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @beaninfo
 *   attribute: isContainer false
 *
 * @version 1.27 03/30/98
 * @author Georges Saab
 * @author David Karlton
 */
public class JCheckBoxMenuItem extends JMenuItem implements SwingConstants,
        Accessible {

    /**
     * Creates an initially unselected checkboxMenuItem with no set text or icon.
     */
    public JCheckBoxMenuItem() {
        this(null, null);
    }

    /**
     * Creates an initially unselected checkboxMenuItem with an icon.
     *
     * @param icon the icon of the CheckBoxMenuItem.
     */
    public JCheckBoxMenuItem(Icon icon) {
        this(null, icon);
    }

    /**
     * Creates an initially unselected checkboxMenuItem with text.
     *
     * @param text the text of the CheckBoxMenuItem
     */
    public JCheckBoxMenuItem(String text) {
        this(text, null);
    }
    
    /**
     * Creates an initially unselected checkboxMenuItem with the specified text and icon.
     *
     * @param text the text of the CheckBoxMenuItem
     * @param icon the icon of the CheckBoxMenuItem
     */
    public JCheckBoxMenuItem(String text, Icon icon) {
        setModel(new JToggleButton.ToggleButtonModel());
        init(text, icon);
        setBorderPainted(false);
        setFocusPainted(false);
        setHorizontalTextPosition(RIGHT);
        setHorizontalAlignment(LEFT);
        // setArmedPainted(false);
        updateUI();
    }

    /**
     * Creates a checkboxMenuItem with the specified text and selection state.
     *
     * @param text the text of the CheckBoxMenuItem.
     * @param b the selected state of the checkboxmenuitem
     */
    public JCheckBoxMenuItem(String text, boolean b) {
        this(text);
        setSelected(b);
    }

    /**
     * Creates a checkboxMenuItem with the specified text, icon, and selection state.
     *
     * @param text the text of the CheckBoxMenuItem
     * @param icon the icon of the CheckBoxMenuItem
     * @param b the selected state of the checkboxmenuitem
     */
    public JCheckBoxMenuItem(String text, Icon icon, boolean b) {
        this(text, icon);
        setSelected(b);
    }

    protected void init(String text, Icon icon) {
        setLayout(new OverlayLayout(this));

        if(text != null) {
            setText(text);
            
            if(icon != null) {
                setVerticalTextPosition(BOTTOM);
            } 
        }
        
        if(icon != null) {
            setIcon(icon);
        }
        
        // Listen for Focus events
        addFocusListener(
            new FocusListener() {
            public void focusGained(FocusEvent event) {}
            public void focusLost(FocusEvent event) {
                // When focus is lost, repaint if 
                // we focus information is painted
                if(isFocusPainted()) {
                    repaint();
                }
            }
        }
        );
    }
    
    /**
     * Sets L&F object that renders this component.
     *
     * @param ui the new L&F object CheckBoxMenuItemUI
     * @see UIDefaults#getUI
     * @beaninfo
     * description: The menu item's UI delegate
     *       bound: true
     *      expert: true
     *      hidden: true
     */
    public void setUI(CheckBoxMenuItemUI ui) {
        super.setUI(ui);
    }
    
    /**
     * Notification from the UIFactory that the L&F
     * has changed. 
     *
     * @see JComponent#updateUI
     */
    public void updateUI() {
        setUI((CheckBoxMenuItemUI)UIManager.getUI(this));
    }


    /**
     * Returns the name of the L&F class
     * that renders this component.
     *
     * @return "CheckBoxMenuItemUI"
     * @see JComponent#getUIClassID
     * @see UIDefaults#getUI
     */
    public String getUIClassID() {
        return "CheckBoxMenuItemUI";
    }
            
     /**
      * Returns the selected-state of the item. This method
      * exists for AWT compatibility only.  New code should
      * use isSelected() instead.
      *
      * @return true  if the item is selected
      */
    public boolean getState() {
        return isSelected();
    }
            
    /**
     * Sets the selected-state of the item. This method
     * exists for AWT compatibility only.  New code should
     * use setSelected() instead.
     *
     * @param b  a boolean value indicating the item's
     *           selected-state, where true=selected
     * @beaninfo
     * description: The selection state of the Checkbox menu item
     *      hidden: true
     */
    public synchronized void setState(boolean b) {
        setSelected(b);
    }
            
            
    /**
     * Returns an array (length 1) containing the checkbox menu item 
     * label or null if the checkbox is not selected.
     *
     * @return an array containing 1 Object -- the text of the menu item
     *         -- if the item is selected, otherwise null 
     */
    public synchronized Object[] getSelectedObjects() {
        if (isSelected() == false)
            return null;
        Object[] selectedObjects = new Object[1];
        selectedObjects[0] = getText();
        return selectedObjects;
    }

    /*
     * Override Component.requestFocus() to prevent grabbing the focus.
     */
    public void requestFocus() {}


/////////////////
// Accessibility support
////////////////

    /**
     * Get the AccessibleContext associated with this JComponent
     *
     * @return the AccessibleContext of this JComponent
     */
    public AccessibleContext getAccessibleContext() {
        if (accessibleContext == null) {
            accessibleContext = new AccessibleJCheckBoxMenuItem();
        }
        return accessibleContext;
    }

    /**
     * The class used to obtain the accessible role for this object.
     * <p>
     * Warning: serialized objects of this class will not be compatible with
     * future swing releases.  The current serialization support is appropriate
     * for short term storage or RMI between Swing1.0 applications.  It will
     * not be possible to load serialized Swing1.0 objects with future releases
     * of Swing.  The JDK1.2 release of Swing will be the compatibility
     * baseline for the serialized form of Swing objects.
     */
    protected class AccessibleJCheckBoxMenuItem extends AccessibleJMenuItem {
        /**
         * Get the role of this object.
         *
         * @return an instance of AccessibleRole describing the role of the 
         * object
         */
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.CHECK_BOX;
        }
    } // inner class AccessibleJCheckBoxMenuItem
}
