/*
 * @(#)GrayFilter.java	1.6 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;

import java.awt.*;
import java.awt.image.*;

/**
 * An image filter that "disables" an image by turning
 * it into a grayscale image, and brightening the pixels
 * in the image.
 *
 * @author      Jeff Dinkins
 * @author      Tom Ball
 * @author      Jim Graham
 * @version     1.6 01/30/98
 */
public class GrayFilter extends RGBImageFilter {
    private boolean brighter;
    private int percent;
    
    /**
     * Creates a disabled image
     */
    public static Image createDisabledImage (Image i) {
	GrayFilter filter = new GrayFilter(true, 50);
	ImageProducer prod = new FilteredImageSource(i.getSource(), filter);
	Image grayImage = Toolkit.getDefaultToolkit().createImage(prod);
	return grayImage;
    }
    
    public GrayFilter(boolean b, int p) {
        brighter = b;
        percent = p;

	// canFilterIndexColorModel indicates whether or not it is acceptable
	// to apply the color filtering of the filterRGB method to the color
	// table entries of an IndexColorModel object in lieu of pixel by pixel
     	// filtering.
        canFilterIndexColorModel = true;
    }
    
    public int filterRGB(int x, int y, int rgb) {
        // Use NTSC conversion formula.
	int gray = (int)((0.30 * ((rgb >> 16) & 0xff) + 
                         0.59 * ((rgb >> 8) & 0xff) + 
                         0.11 * (rgb & 0xff)) / 3);
	
        if (brighter) {
            gray = (255 - ((255 - gray) * (100 - percent) / 100));
        } else {
            gray = (gray * (100 - percent) / 100);
        }
	
        if (gray < 0) gray = 0;
        if (gray > 255) gray = 255;
        return (rgb & 0xff000000) | (gray << 16) | (gray << 8) | (gray << 0);
    }
}

