/*
 * @(#)DefaultListModel.java	1.13 98/02/12
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import java.util.Vector;
import java.util.Enumeration;

import com.sun.java.swing.event.*;


/**
 * This class implements the java.util.Vector API and notifies
 * the JListDataModel listeners when changes occur.  Presently
 * it delegates to a Vector, in a future release it will be
 * a real Collection implementation.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 *
 * @version 1.13 02/12/98
 * @author unknown
 */

public class DefaultListModel extends AbstractListModel
{
    private Vector delegate = new Vector();

    public int getSize() {
	return delegate.size();
    }

    public Object getElementAt(int index) {
	return delegate.elementAt(index);
    }

    public void copyInto(Object anArray[]) {
	delegate.copyInto(anArray);
    }

    public void trimToSize() {
	delegate.trimToSize();
    }

    public void ensureCapacity(int minCapacity) {
	delegate.ensureCapacity(minCapacity);
    }

    public void setSize(int newSize) {
	int oldSize = delegate.size();
	delegate.setSize(newSize);
	if (oldSize > newSize) {
	    fireIntervalRemoved(this, newSize, oldSize-1);
	}
	else if (oldSize < newSize) {
	    fireIntervalAdded(this, oldSize, newSize-1);
	}
    }

    public int capacity() {
	return delegate.capacity();
    }

    public int size() {
	return delegate.size();
    }

    public boolean isEmpty() {
	return delegate.isEmpty();
    }

    public Enumeration elements() {
	return delegate.elements();
    }

    public boolean contains(Object elem) {
	return delegate.contains(elem);
    }

    public int indexOf(Object elem) {
	return delegate.indexOf(elem);
    }

    public int indexOf(Object elem, int index) {
	return delegate.indexOf(elem, index);
    }

    public int lastIndexOf(Object elem) {
	return delegate.lastIndexOf(elem);
    }

    public int lastIndexOf(Object elem, int index) {
	return delegate.lastIndexOf(elem, index);
    }

    public Object elementAt(int index) {
	return delegate.elementAt(index);
    }

    public Object firstElement() {
	return delegate.firstElement();
    }

    public Object lastElement() {
	return delegate.lastElement();
    }

    public void setElementAt(Object obj, int index) {
	delegate.setElementAt(obj, index);
	fireContentsChanged(this, index, index);
    }

    public void removeElementAt(int index) {
	delegate.removeElementAt(index);
	fireIntervalRemoved(this, index, index);
    }

    public void insertElementAt(Object obj, int index) {
	delegate.insertElementAt(obj, index);
	fireIntervalAdded(this, index, index);
    }

    public void addElement(Object obj) {
	int index = delegate.size();
	delegate.addElement(obj);
	fireIntervalAdded(this, index, index);
    }

    public boolean removeElement(Object obj) {
	int index = indexOf(obj);
	boolean rv = delegate.removeElement(obj);
	if (index > 0) {
	    fireIntervalRemoved(this, index, index);
	}
	return rv;
    }


    public void removeAllElements() {
	int index1 = delegate.size()-1;
	delegate.removeAllElements();
	if (index1 >= 0) {
	    fireIntervalRemoved(this, 0, index1);
	}
    }


    public String toString() {
	return delegate.toString();
    }


    /* The remaining methods are included for compatibility with the
     * JDK1.2 Vector class.
     */

    public Object[] toArray() {
	Object[] rv = new Object[delegate.size()];
	delegate.copyInto(rv);
	return rv;
    }

    public Object get(int index) {
	return delegate.elementAt(index);
    }

    public Object set(int index, Object element) {
	Object rv = delegate.elementAt(index);
	delegate.setElementAt(element, index);
	fireContentsChanged(this, index, index);
	return rv;
    }

    public void add(int index, Object element) {
	delegate.insertElementAt(element, index);
	fireIntervalAdded(this, index, index);
    }

    public Object remove(int index) {
	Object rv = delegate.elementAt(index);
	delegate.removeElementAt(index);
	fireIntervalRemoved(this, index, index);
	return rv;
    }

    public void clear() {
	int index1 = delegate.size()-1;
	delegate.removeAllElements();
	if (index1 >= 0) {
	    fireIntervalRemoved(this, 0, index1);
	}
    }

    public void removeRange(int fromIndex, int toIndex) {
	for(int i = toIndex; i >= fromIndex; i--) {
	    delegate.removeElementAt(i);
	}
	fireIntervalRemoved(this, fromIndex, toIndex);
    }

    /*
    public void addAll(Collection c) {
    }

    public void addAll(int index, Collection c) {
    }
    */
}
