/*
 * @(#)ColorChooserPanel.java	1.5 98/02/02
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.swing;

import java.awt.*;

/**
 * The is the abstract superclass for color choosers.  If you want to add a new color chooser
 * panel into a JColorChooser, sublclass this class.
 * <p>
 * Warning: serialized objects of this class will not be compatible with
 * future swing releases.  The current serialization support is appropriate 
 * for short term storage or RMI between Swing1.0 applications.  It will
 * not be possible to load serialized Swing1.0 objects with future releases
 * of Swing.  The JDK1.2 release of Swing will be the compatibility
 * baseline for the serialized form of Swing objects.
 * 
 * @version 1.5 02/02/98
 * @author Tom Santos
 */
public abstract class ColorChooserPanel extends JPanel {
    public static final String COLOR_PROPERTY = 
        "ColorChooserPanel.COLOR_PROPERTY";
    protected static final Dimension preferredSize = new Dimension( 300, 200 );

    public abstract void setColor( Color newColor );
    public abstract Color getColor();

    protected void fireColorPropertyChange( Color oldColor, Color newColor ) {
        firePropertyChange( COLOR_PROPERTY, oldColor, newColor );
    }

    public Dimension getPreferredSize() {
        return preferredSize;
    }

    /**
     * This get called when the panel is added to the chooser.
     */
    public void installChooserPanel() { }

    /**
     * This get called when the panel is removed from the chooser.
     */
    public void uninstallChooserPanel() { }
}
