/*
 * @(#)ButtonModel.java	1.15 98/01/30
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */
package com.sun.java.swing;


import java.awt.event.*;
import java.awt.*;
import com.sun.java.swing.event.*;


/**
 * State Model for Buttons
 *
 * @version 1.15 01/30/98
 * @author Jeff Dinkins
 */
public interface ButtonModel extends ItemSelectable {
    
    boolean isArmed();     
    boolean isSelected();
    boolean isEnabled();
    boolean isPressed();
    boolean isRollover();

    /**
     * Marks the button as "armed". If the mouse button is
     * released while it is over this item, the button's action event
     * fires. If the mouse button is released elsewhere, the
     * event does not fire and the button is disarmed.
     * 
     * @param b true to arm the button so it can be selected
     */
    public void setArmed(boolean b);
    public void setSelected(boolean b);
    public void setEnabled(boolean b);
    public void setPressed(boolean b);
    public void setRollover(boolean b);

    public void setMnemonic(int key);
    public int  getMnemonic();

    public void setActionCommand(String s);
    public String getActionCommand();

    public void setGroup(ButtonGroup group);
    
    void addActionListener(ActionListener l);
    void removeActionListener(ActionListener l);

    void addItemListener(ItemListener l);
    void removeItemListener(ItemListener l);

    void addChangeListener(ChangeListener l);
    void removeChangeListener(ChangeListener l);

}
