/*
 * @(#)BorderFactory.java	1.9 98/01/30
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 *
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 *
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 *
 */
package com.sun.java.swing;

import java.awt.Color;
import java.awt.Font;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.border.*;

/**
 * Factory class for vending standard Border objects.  Whereever
 * possible, this factory will hand out references to shared
 * Border instances.
 *
 * @version 1.9 01/30/98
 * @author David Kloba
 */
public class BorderFactory 
{

    /** Don't let anyone instantiate this class */
    private BorderFactory() {
    }


//// LineBorder ///////////////////////////////////////////////////////////////
    public static Border createLineBorder(Color color) {
        return new LineBorder(color, 1);
    }

    public static Border createLineBorder(Color color, int thickness)  {
        return new LineBorder(color, thickness);
    }
    
//    public static Border createLineBorder(Color color, int thickness, 
//					boolean drawRounded)  {
//        return new JLineBorder(color, thickness, drawRounded);
//    }

//// BevelBorder /////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////
    static final Border sharedRaisedBevel = new BevelBorder(BevelBorder.RAISED);
    static final Border sharedLoweredBevel = new BevelBorder(BevelBorder.LOWERED);

    public static Border createRaisedBevelBorder() {
        return createSharedBevel(BevelBorder.RAISED);
    }

    public static Border createLoweredBevelBorder() {
        return createSharedBevel(BevelBorder.LOWERED);
    }

    public static Border createBevelBorder(int type) {
	return createSharedBevel(type);
    }
	
    public static Border createBevelBorder(int type, Color highlight, Color shadow) {
        return new BevelBorder(type, highlight.darker(), highlight, 
					shadow, shadow.brighter());
    }

    public static Border createBevelBorder(int type,
                        Color highlightOuter, Color highlightInner,
                        Color shadowOuter, Color shadowInner) {
        return new BevelBorder(type, highlightOuter, highlightInner, 
					shadowOuter, shadowInner);
    }

    static Border createSharedBevel(int type)	{
	if(type == BevelBorder.RAISED) {
	    return sharedRaisedBevel;
	} else if(type == BevelBorder.LOWERED) {
	    return sharedLoweredBevel;
	}
	return null;
    }
//// EtchedBorder ///////////////////////////////////////////////////////////
    static final Border sharedEtchedBorder = new EtchedBorder();

    public static Border createEtchedBorder()    {
	return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(Color highlight, Color shadow)    {
        return new EtchedBorder(highlight, shadow);
    }

//// TitledBorder ////////////////////////////////////////////////////////////
    public static TitledBorder createTitledBorder(String title)     {
        return new TitledBorder(title);
    }

    public static TitledBorder createTitledBorder(Border border)       {
        return new TitledBorder(border);
    }

    public static TitledBorder createTitledBorder(Border border, 
						   String title) {
        return new TitledBorder(border, title);
    }

    public static TitledBorder createTitledBorder(Border border, 
                        String title,
                        int titleJustification,
                        int titlePosition)      {
        return new TitledBorder(border, title, titleJustification,
                        titlePosition);
    }

    public static TitledBorder createTitledBorder(Border border,       	
                        String title,
                        int titleJustification,
                        int titlePosition,
                        Font titleFont) {
        return new TitledBorder(border, title, titleJustification,
                        titlePosition, titleFont);
    }

    public static TitledBorder createTitledBorder(Border border,                     
                        String title,
                        int titleJustification,
                        int titlePosition,
                        Font titleFont,
                        Color titleColor)       {
        return new TitledBorder(border, title, titleJustification,
                        titlePosition, titleFont, titleColor);
    }
//// EmptyBorder ///////////////////////////////////////////////////////////	
    final static Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    public static Border createEmptyBorder() {
	return emptyBorder;
    }

    public static Border createEmptyBorder(int top, int left, 
						int bottom, int right) {
	return new EmptyBorder(top, left, bottom, right);
    }

//// CompoundBorder ////////////////////////////////////////////////////////
    public static CompoundBorder createCompoundBorder() { 
	return new CompoundBorder(); 
    }

    public static CompoundBorder createCompoundBorder(Border outsideBorder, 
						Border insideBorder) { 
	return new CompoundBorder(outsideBorder, insideBorder); 
    }

//// MatteBorder ////////////////////////////////////////////////////////
    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, 
                                                Color color) {
        return new MatteBorder(top, left, bottom, right, color);
    }

    public static MatteBorder createMatteBorder(int top, int left, int bottom, int right, 
                                                Icon tileIcon) {
        return new MatteBorder(top, left, bottom, right, tileIcon);
    }
}
