/*
 * @(#)AccessibleTable.java	1.6 98/02/18
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.accessibility;

/**
 * The AccessibleTable interface is currently up for review and should
 * only be used for experimental purposes.  Interested parties should review
 * this interface and send comments to 
 * <a href="mailto:access@sun.com">access@sun.com</a>.  Based upon feedback
 * from reviewers, we may add a method to AccessibleContext (e.g., 
 * getAccessibleTable) that will return an object that implements this 
 * interface if the Accessible object is a table.
 * 
 * @see Accessible
 * @see AccessibleContext
 *
 * @version     1.6 02/18/98 14:38:34
 * @author	Peter Korn
 */
public interface AccessibleTable {

    /**
     * Returns the number of rows in the table
     *
     * @return the number of rows in the table
     */
    public int getAccessibleRowCount();

    /**
     * Returns the number of columns in the table
     *
     * @return the zero-based number of columns in the table
     */
    public int getAccessibleColumnCount();

    /**
     * Returns the row at a given index into the table
     *
     * @param i zero-based index into the table
     * @return the zero-based row at a given index
     */
    public int getAccessibleRowAtIndex(int i);

    /**
     * Returns the column at a given index into the table
     *
     * @param i zero-based index into the table
     * @return the column at a given index
     */
    public int getAccessibleColumnAtIndex(int i);

    /**
     * Returns the index at a given (row, column) in the table
     *
     * @param r zero-based row of the table
     * @param c zero-based column of the table
     * @return the index into the table
     */
    public int getAccessibleIndexAt(int r, int c);

    /**
     * Returns the Accessible at a given (row, column) in the table
     *
     * @param r zero-based row of the table
     * @param c zero-based column of the table
     * @return the Accessible at the specified (row, column)
     */
    public Accessible getAccessibleAt(int r, int c);

    /**
     * Return the header text of the specified row in the tabe
     *
     * @param r zero-based row of the table
     * @return the text header of the row
     */
    public Accessible getAccessibleRowHeader(int r);

    /**
     * Return the header text of the specified column in the table
     *
     * @param c zero-based column of the table
     * @return the text header of the column
     */
    public Accessible getAccessibleColumnHeader(int c);

}
