/*
 * @(#)AccessibleLayout.java	1.9 98/02/18
 *
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.accessibility;

import java.awt.*;

/**
 * The AccessibleLayout interface is currently up for review and should
 * only be used for experimental purposes.  Interested parties should review
 * this interface and send comments to 
 * <a href="mailto:access@sun.com">access@sun.com</a>.  Based upon feedback
 * from reviewers, we may add a method to AccessibleContext (e.g., 
 * getAccessibleLayout) that will return an object that implements this 
 * interface if the Accessible object supports the layout of its children.
 * 
 * @see Accessible
 * @see AccessibleContext
 *
 * @version     1.9 02/18/98 14:38:33
 * @author      Willie Walker
 * @author      Peter Korn
 */
public interface AccessibleLayout {
    
    /**
     * Constant used to locate the object logically previous of the 
     * object passed in.
     */
    public static final int LOGICAL_PREVIOUS  = 0x00000001;

    /**
     * Constant used to locate the object logically next of the 
     * object passed in.
     */
    public static final int LOGICAL_NEXT      = 0x00000002;

    /**
     * Constant used to locate the first logical object in the container.
     */
    public static final int LOGICAL_FIRST     = 0x00000003;

    /**
     * Constant used to locate the last logical object in the container.
     */
    public static final int LOGICAL_LAST      = 0x00000004;

    /**
     * Constant used to locate the object physically above the 
     * object passed in.
     */
    public static final int POSITION_ABOVE    = 0x00000005;

    /**
     * Constant used to locate the object physically below the 
     * object passed in.
     */
    public static final int POSITION_BELOW    = 0x00000006;

    /**
     * Constant used to locate the object physically to the left of the 
     * object passed in.
     */
    public static final int POSITION_LEFT     = 0x00000007;

    /**
     * Constant used to locate the object physically to the right of the 
     * object passed in.
     */
    public static final int POSITION_RIGHT    = 0x00000008;

    /**
     * Constant used to locate the first physical object in the Container
     */
    public static final int POSITION_FIRST    = 0x00000009;

    /**
     * Constant used to locate the last physical object in the Container
     */
    public static final int POSITION_LAST     = 0x00000010;

    /**
     * Determine the object in the given relative direction 
     * from the Component passed in.
     * @param comp the Component
     * @param direction the direction to look in
     * @return Component else null
     */
    public abstract Component locate(Component comp, int direction);

    /**
     * Determine the object in the given relative direction 
     * from the Point passed in.
     * @param p Point in screen coordinates
     * @param direction the direction to look in
     * @return Component else null
     */
    public abstract Component locate(Point p, int direction);

    /**
     * Determine the first or last object in the Container.
     * @param pos -- either POSITION_FIRST, POSITION_LAST,
     * LOGICAL_FIRST, or LOGICAL_LAST
     * @return Component else null
     */
    public abstract Component locate(int pos);

    /**
     * Determine the focusable object in the given relative focus direction 
     * from the Component passed in.  Note that this follows focus traversing
     * rules, not the physical location of the Component itself.
     * @param comp the Component
     * @param pos -- either POSITION_PREVIOUS, POSITION_NEXT,
     * LOGICAL_PREVIOUS, or LOGICAL_NEXT
     * @return Component else null
     */
    public abstract Component getFocusTraversable(Component comp, int direction);

    /**
     * Determine the first or last object in the Container that accepts focus.
     * @param pos -- either POSITION_FIRST, POSITION_LAST,
     * LOGICAL_FIRST, or LOGICAL_LAST
     * @return Component else null
     */
    public abstract Component getFocusTraversable(int pos);
}
