/*
 * @(#)Accessible.java	1.27 98/02/04
 * 
 * Copyright (c) 1997 Sun Microsystems, Inc. All Rights Reserved.
 * 
 * This software is the confidential and proprietary information of Sun
 * Microsystems, Inc. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.
 * 
 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
 * SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR ANY DAMAGES
 * SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR DISTRIBUTING
 * THIS SOFTWARE OR ITS DERIVATIVES.
 * 
 */

package com.sun.java.accessibility;

/**
 * Interface Accessible is the main interface for the accessibility package. 
 * All components that support
 * the accessibility package must implement this interface.  
 * It contains a single
 * method, <a href="#getAccessibleContext">getAccessibleContext</a>, which  
 * returns an instance of the class 
 * <a href="com.sun.java.accessibility.AccessibleContext.html">Accessible
 * Context</a>.
 *
 * @see AccessibleContext
 *
 * @version     1.1 11/24/97 20:34:48
 * @author	Peter Korn
 * @author      Hans Muller
 * @author      Willie Walker
 */
public interface Accessible {

    /**
     * Returns the AccessibleContext associated with this object.  In most
     * cases, the return value should not be null if the object implements
     * interface Accessible.  If a component developer creates a subclass
     * of an object that implements Accessible, and that subclass
     * is not Accessible, the developer should override the 
     * getAccessibleContext method to return null.
     */
    public AccessibleContext getAccessibleContext();
}
