/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.undo;

import com.sun.java.swing.undo.CannotRedoException;
import com.sun.java.swing.undo.CannotUndoException;
import com.sun.java.swing.undo.UndoableEdit;

public class AbstractUndoableEdit
implements UndoableEdit {
    protected static final String UndoName = "Undo";
    protected static final String RedoName = "Redo";
    boolean hasBeenDone = true;
    boolean alive = true;

    public void die() {
        this.alive = false;
    }

    public void undo() throws CannotUndoException {
        if (!this.canUndo()) {
            throw new CannotUndoException();
        }
        this.hasBeenDone = false;
    }

    public boolean canUndo() {
        return this.alive && this.hasBeenDone;
    }

    public void redo() throws CannotRedoException {
        if (!this.canRedo()) {
            throw new CannotRedoException();
        }
        this.hasBeenDone = true;
    }

    public boolean canRedo() {
        return this.alive && !this.hasBeenDone;
    }

    public boolean addEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean replaceEdit(UndoableEdit undoableEdit) {
        return false;
    }

    public boolean isSignificant() {
        return true;
    }

    public String getPresentationName() {
        return "";
    }

    public String getUndoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Undo " + string : UndoName;
        return string;
    }

    public String getRedoPresentationName() {
        String string = this.getPresentationName();
        string = string != "" ? "Redo " + string : RedoName;
        return string;
    }

    public String toString() {
        return String.valueOf(super.toString()) + " hasBeenDone: " + this.hasBeenDone + " alive: " + this.alive;
    }
}

