/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JMenu;
import com.sun.java.swing.JMenuBar;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.MenuElement;
import com.sun.java.swing.MenuSelectionManager;
import com.sun.java.swing.event.ChangeEvent;
import com.sun.java.swing.event.ChangeListener;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.MenuBarUI;
import com.sun.java.swing.plaf.basic.BasicMenuMouseMotionListener;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class BasicMenuBarUI
extends MenuBarUI
implements Serializable {
    protected JMenuBar menuBar;
    protected MouseListener mouseListener;
    protected MouseMotionListener dragListener;
    protected ChangeListener menuChangeListener;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicMenuBarUI();
    }

    public void installUI(JComponent jComponent) {
        this.menuBar = (JMenuBar)jComponent;
        this.initListeners();
        this.addListeners();
        jComponent.setOpaque(true);
        LookAndFeel.installBorder(jComponent, "MenuBar.border");
        LookAndFeel.installColorsAndFont(jComponent, "MenuBar.background", "MenuBar.foreground", "MenuBar.font");
    }

    public void uninstallUI(JComponent jComponent) {
        this.removeListeners();
        jComponent.resetKeyboardActions();
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void initListeners() {
        this.mouseListener = this.createMouseListener();
        this.dragListener = this.createMouseMotionListener();
        this.menuChangeListener = this.createChangeListener();
    }

    protected MouseListener createMouseListener() {
        return new MouseListener(this.menuBar);
    }

    protected MouseMotionListener createMouseMotionListener() {
        return new BasicMenuMouseMotionListener();
    }

    protected ChangeListener createChangeListener() {
        return new 1();
    }

    protected void addListeners() {
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            this.registerMenu(this.menuBar.getMenu(n));
            ++n;
        }
    }

    protected void removeListeners() {
        int n = 0;
        while (n < this.menuBar.getMenuCount()) {
            this.unregisterMenu(this.menuBar.getMenu(n));
            ++n;
        }
    }

    public void registerMenu(JMenu jMenu) {
        jMenu.getModel().addChangeListener(this.menuChangeListener);
    }

    public void unregisterMenu(JMenu jMenu) {
        jMenu.getModel().removeChangeListener(this.menuChangeListener);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return null;
    }

    private final class 1
    extends BasicMenuBarChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            int n = 0;
            int n2 = BasicMenuBarUI.this.menuBar.getMenuCount();
            while (n < n2) {
                JMenu jMenu = BasicMenuBarUI.this.menuBar.getMenu(n);
                if (jMenu != null && jMenu.isSelected()) {
                    BasicMenuBarUI.this.menuBar.getSelectionModel().setSelectedIndex(n);
                    return;
                }
                ++n;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private static abstract class BasicMenuBarChangeListener
    implements ChangeListener,
    Serializable {
        BasicMenuBarChangeListener() {
        }

        public abstract void stateChanged(ChangeEvent var1);
    }

    static class MouseListener
    extends MouseAdapter
    implements Serializable {
        JMenuBar menuBar;

        public MouseListener(JMenuBar jMenuBar) {
            this.menuBar = jMenuBar;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            MenuElement[] menuElementArray = new MenuElement[]{this.menuBar};
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseExited(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }
    }
}

