/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.basic;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.Action;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JList;
import com.sun.java.swing.JOptionPane;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.event.ListSelectionListener;
import com.sun.java.swing.plaf.FileChooserUI;
import com.sun.java.swing.plaf.basic.BasicDirectoryModel;
import com.sun.java.swing.preview.JFileChooser;
import com.sun.java.swing.preview.filechooser.FileFilter;
import com.sun.java.swing.preview.filechooser.FileSystemView;
import com.sun.java.swing.preview.filechooser.FileView;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Hashtable;

public abstract class BasicFileChooserUI
extends FileChooserUI
implements PropertyChangeListener {
    protected Icon directoryIcon;
    protected Icon fileIcon;
    protected Icon computerIcon;
    protected Icon hardDriveIcon;
    protected Icon floppyDriveIcon;
    protected Icon newFolderIcon;
    protected Icon upFolderIcon;
    protected Icon homeFolderIcon;
    protected Icon listViewIcon;
    protected Icon detailsViewIcon;
    protected String saveButtonText;
    protected String openButtonText;
    protected String cancelButtonText;
    protected String updateButtonText;
    protected String helpButtonText;
    protected static String saveButtonToolTipText = null;
    protected static String openButtonToolTipText = null;
    protected static String cancelButtonToolTipText = null;
    protected static String updateButtonToolTipText = null;
    protected static String helpButtonToolTipText = null;
    private Action approveSelectionAction = new ApproveSelectionAction();
    private Action cancelSelectionAction = new CancelSelectionAction();
    private Action updateAction = new UpdateAction();
    private Action newFolderAction = new NewFolderAction();
    private Action goHomeAction = new GoHomeAction();
    private Action changeToParentDirectoryAction = new ChangeToParentDirectoryAction();
    private JFileChooser filechooser;
    private AcceptAllFileFilter acceptAllFileFilter = new AcceptAllFileFilter();
    protected String fileDescription = "Generic File";
    protected String directoryDescription = "Directory";
    protected BasicDirectoryModel model;
    protected BasicFileView fileView = new BasicFileView();
    protected JPanel accessoryPanel;

    public abstract String getFileName();

    public abstract void setFileName(String var1);

    public abstract String getDirectoryName();

    public abstract void setDirectoryName(String var1);

    public abstract void ensureFileIsVisible(File var1);

    public abstract void rescanCurrentDirectory();

    public abstract void propertyChange(PropertyChangeEvent var1);

    public BasicFileChooserUI(JFileChooser jFileChooser) {
    }

    public void installUI(JComponent jComponent) {
        this.accessoryPanel = new JPanel(new BorderLayout());
        this.filechooser = (JFileChooser)jComponent;
        this.loadIcons();
        this.loadStrings();
        this.createModel();
        this.installComponents();
        this.addListeners();
    }

    public void uninstallUI(JComponent jComponent) {
        this.filechooser.removeAll();
        this.uninstallListeners();
        if (this.accessoryPanel != null) {
            this.accessoryPanel.removeAll();
        }
        this.filechooser = null;
        this.accessoryPanel = null;
    }

    protected void uninstallListeners() {
        if (this.getFileChooser() != null) {
            this.getFileChooser().removeAll();
            this.getFileChooser().removePropertyChangeListener(this);
            this.getFileChooser().removePropertyChangeListener(this.model);
        }
    }

    protected void loadIcons() {
        this.directoryIcon = UIManager.getIcon("FileView.directoryIcon");
        this.fileIcon = UIManager.getIcon("FileView.fileIcon");
        this.computerIcon = UIManager.getIcon("FileView.computerIcon");
        this.hardDriveIcon = UIManager.getIcon("FileView.hardDriveIcon");
        this.floppyDriveIcon = UIManager.getIcon("FileView.floppyDriveIcon");
        this.newFolderIcon = UIManager.getIcon("FileChooser.newFolderIcon");
        this.upFolderIcon = UIManager.getIcon("FileChooser.upFolderIcon");
        this.homeFolderIcon = UIManager.getIcon("FileChooser.homeFolderIcon");
        this.detailsViewIcon = UIManager.getIcon("FileChooser.detailsViewIcon");
        this.listViewIcon = UIManager.getIcon("FileChooser.listViewIcon");
    }

    protected void loadStrings() {
        this.saveButtonText = UIManager.getString("FileChooser.saveButtonText");
        this.openButtonText = UIManager.getString("FileChooser.openButtonText");
        this.cancelButtonText = UIManager.getString("FileChooser.cancelButtonText");
        this.updateButtonText = UIManager.getString("FileChooser.updateButtonText");
        this.helpButtonText = UIManager.getString("FileChooser.helpButtonText");
        saveButtonToolTipText = UIManager.getString("FileChooser.saveButtonToolTipText");
        openButtonToolTipText = UIManager.getString("FileChooser.openButtonToolTipText");
        cancelButtonToolTipText = UIManager.getString("FileChooser.cancelButtonToolTipText");
        updateButtonToolTipText = UIManager.getString("FileChooser.updateButtonToolTipText");
        helpButtonToolTipText = UIManager.getString("FileChooser.helpButtonToolTipText");
    }

    protected void createModel() {
        this.model = new BasicDirectoryModel(this.getFileChooser());
    }

    public BasicDirectoryModel getModel() {
        return this.model;
    }

    protected void addListeners() {
        this.getFileChooser().addPropertyChangeListener(this.model);
        this.getFileChooser().addPropertyChangeListener(this);
    }

    public JFileChooser getFileChooser() {
        return this.filechooser;
    }

    public JPanel getAccessoryPanel() {
        return this.accessoryPanel;
    }

    public ListSelectionListener createListSelectionListener() {
        return new SelectionListener();
    }

    protected MouseListener createDoubleClickListener(JList jList) {
        return new DoubleClickListener(jList);
    }

    public FileFilter getAcceptAllFileFilter() {
        return this.acceptAllFileFilter;
    }

    public FileView getFileView() {
        return this.fileView;
    }

    public String getDialogTitle() {
        return this.getApproveButtonText();
    }

    public abstract void installComponents();

    public String getApproveButtonText() {
        String string = this.getFileChooser().getApproveButtonText();
        if (string != null) {
            return string;
        }
        if (this.getFileChooser().getDialogType() == 0) {
            return this.openButtonText;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return this.saveButtonText;
        }
        return null;
    }

    public String getApproveButtonToolTipText() {
        String string = this.getFileChooser().getApproveButtonToolTipText();
        if (string != null) {
            return string;
        }
        if (this.getFileChooser().getDialogType() == 0) {
            return openButtonToolTipText;
        }
        if (this.getFileChooser().getDialogType() == 1) {
            return saveButtonToolTipText;
        }
        return null;
    }

    public Action getNewFolderAction() {
        return this.newFolderAction;
    }

    public Action getGoHomeAction() {
        return this.goHomeAction;
    }

    public Action getChangeToParentDirectoryAction() {
        return this.changeToParentDirectoryAction;
    }

    public Action getApproveSelectionAction() {
        return this.approveSelectionAction;
    }

    public Action getCancelSelectionAction() {
        return this.cancelSelectionAction;
    }

    public Action getUpdateAction() {
        return this.updateAction;
    }

    protected class DoubleClickListener
    extends MouseAdapter {
        JList list;

        public DoubleClickListener(JList jList) {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
            this.list = jList;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            int n;
            if (mouseEvent.getClickCount() == 2 && (n = this.list.locationToIndex(mouseEvent.getPoint())) >= 0) {
                File file = (File)this.list.getModel().getElementAt(n);
                if (BasicFileChooserUI.this.getFileChooser().isTraversable(file)) {
                    this.list.clearSelection();
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file);
                    return;
                }
                BasicFileChooserUI.this.getFileChooser().approveSelection();
            }
        }
    }

    protected class SelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList;
            File file;
            if (!(listSelectionEvent.getValueIsAdjusting() || (file = (File)(jList = (JList)listSelectionEvent.getSource()).getSelectedValue()) == null || !BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled() && BasicFileChooserUI.this.getFileChooser().isTraversable(file))) {
                BasicFileChooserUI.this.getFileChooser().setSelectedFile(file);
            }
        }

        SelectionListener() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class NewFolderAction
    extends AbstractAction {
        protected NewFolderAction() {
            super("New Folder");
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = BasicFileChooserUI.this.getFileChooser().getCurrentDirectory();
            File file2 = null;
            try {
                file2 = BasicFileChooserUI.this.getFileChooser().getFileSystemView().createNewFolder(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(BasicFileChooserUI.this.getFileChooser(), "Error creating new folder: " + iOException, "Error Creating New Folder", 0);
                return;
            }
            BasicFileChooserUI.this.getFileChooser().rescanCurrentDirectory();
            BasicFileChooserUI.this.getFileChooser().ensureFileIsVisible(file2);
        }
    }

    protected class GoHomeAction
    extends AbstractAction {
        protected GoHomeAction() {
            super("Go Home");
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(null);
        }
    }

    protected class ChangeToParentDirectoryAction
    extends AbstractAction {
        protected ChangeToParentDirectoryAction() {
            super("Go Up");
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().changeToParentDirectory();
        }
    }

    protected class ApproveSelectionAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            String string = BasicFileChooserUI.this.getFileName();
            FileSystemView fileSystemView = BasicFileChooserUI.this.getFileChooser().getFileSystemView();
            File file = BasicFileChooserUI.this.getFileChooser().getCurrentDirectory();
            if (string != null) {
                string = string.trim();
            }
            if (string != null && !string.equals("")) {
                File file2 = fileSystemView.createFileObject(string);
                if (!file2.isAbsolute()) {
                    file2 = fileSystemView.createFileObject(file, string);
                }
                if (file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isTraversable(file2) && !BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                    BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(file2);
                    return;
                }
                if (!file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isFileSelectionEnabled() || file2.isDirectory() && BasicFileChooserUI.this.getFileChooser().isDirectorySelectionEnabled()) {
                    BasicFileChooserUI.this.getFileChooser().setSelectedFile(file2);
                }
            }
            BasicFileChooserUI.this.getFileChooser().approveSelection();
        }

        ApproveSelectionAction() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class CancelSelectionAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().cancelSelection();
        }

        CancelSelectionAction() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class UpdateAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            BasicFileChooserUI.this.getFileChooser().setCurrentDirectory(BasicFileChooserUI.this.getFileChooser().getFileSystemView().createFileObject(BasicFileChooserUI.this.getDirectoryName()));
            BasicFileChooserUI.this.getFileChooser().rescanCurrentDirectory();
        }

        UpdateAction() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }
    }

    protected class AcceptAllFileFilter
    extends FileFilter {
        public AcceptAllFileFilter() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public boolean accept(File file) {
            return true;
        }

        public String getDescription() {
            return UIManager.getString("FileChooser.acceptAllFileFilterText");
        }
    }

    protected class BasicFileView
    extends FileView {
        protected Hashtable iconCache = new Hashtable();

        public BasicFileView() {
            BasicFileChooserUI.this = BasicFileChooserUI.this;
        }

        public void clearIconCache() {
            this.iconCache = new Hashtable();
        }

        public String getName(File file) {
            String string = null;
            if (file != null && (string = file.getName()).equals("")) {
                string = file.getPath();
            }
            return string;
        }

        public String getDescription(File file) {
            return file.getName();
        }

        public String getTypeDescription(File file) {
            if (file.isDirectory()) {
                return BasicFileChooserUI.this.directoryDescription;
            }
            return BasicFileChooserUI.this.fileDescription;
        }

        public Icon getCachedIcon(File file) {
            return (Icon)this.iconCache.get(file);
        }

        public void cacheIcon(File file, Icon icon) {
            if (file == null || icon == null) {
                return;
            }
            this.iconCache.put(file, icon);
        }

        public Icon getIcon(File file) {
            Icon icon = this.getCachedIcon(file);
            if (icon != null) {
                return icon;
            }
            icon = file != null && file.isDirectory() ? (BasicFileChooserUI.this.getFileChooser().getFileSystemView().isRoot(file) ? BasicFileChooserUI.this.hardDriveIcon : BasicFileChooserUI.this.directoryIcon) : BasicFileChooserUI.this.fileIcon;
            this.cacheIcon(file, icon);
            return icon;
        }

        public Boolean isTraversable(File file) {
            if (file.isDirectory()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        public Boolean isHidden(File file) {
            String string = file.getName();
            if (string != null && string.charAt(0) == '.') {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }
}

