/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import com.sun.java.swing.Icon;
import com.sun.java.swing.border.BevelBorder;
import com.sun.java.swing.border.Border;
import com.sun.java.swing.border.CompoundBorder;
import com.sun.java.swing.border.EmptyBorder;
import com.sun.java.swing.border.EtchedBorder;
import com.sun.java.swing.border.LineBorder;
import com.sun.java.swing.border.MatteBorder;
import com.sun.java.swing.border.TitledBorder;
import java.awt.Color;
import java.awt.Font;

public class BorderFactory {
    static final Border sharedRaisedBevel = new BevelBorder(0);
    static final Border sharedLoweredBevel = new BevelBorder(1);
    static final Border sharedEtchedBorder = new EtchedBorder();
    static final Border emptyBorder = new EmptyBorder(0, 0, 0, 0);

    private BorderFactory() {
    }

    public static Border createLineBorder(Color color) {
        return new LineBorder(color, 1);
    }

    public static Border createLineBorder(Color color, int n) {
        return new LineBorder(color, n);
    }

    public static Border createRaisedBevelBorder() {
        return BorderFactory.createSharedBevel(0);
    }

    public static Border createLoweredBevelBorder() {
        return BorderFactory.createSharedBevel(1);
    }

    public static Border createBevelBorder(int n) {
        return BorderFactory.createSharedBevel(n);
    }

    public static Border createBevelBorder(int n, Color color, Color color2) {
        return new BevelBorder(n, color.darker(), color, color2, color2.brighter());
    }

    public static Border createBevelBorder(int n, Color color, Color color2, Color color3, Color color4) {
        return new BevelBorder(n, color, color2, color3, color4);
    }

    static Border createSharedBevel(int n) {
        if (n == 0) {
            return sharedRaisedBevel;
        }
        if (n == 1) {
            return sharedLoweredBevel;
        }
        return null;
    }

    public static Border createEtchedBorder() {
        return sharedEtchedBorder;
    }

    public static Border createEtchedBorder(Color color, Color color2) {
        return new EtchedBorder(color, color2);
    }

    public static TitledBorder createTitledBorder(String string) {
        return new TitledBorder(string);
    }

    public static TitledBorder createTitledBorder(Border border) {
        return new TitledBorder(border);
    }

    public static TitledBorder createTitledBorder(Border border, String string) {
        return new TitledBorder(border, string);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n, int n2) {
        return new TitledBorder(border, string, n, n2);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n, int n2, Font font) {
        return new TitledBorder(border, string, n, n2, font);
    }

    public static TitledBorder createTitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        return new TitledBorder(border, string, n, n2, font, color);
    }

    public static Border createEmptyBorder() {
        return emptyBorder;
    }

    public static Border createEmptyBorder(int n, int n2, int n3, int n4) {
        return new EmptyBorder(n, n2, n3, n4);
    }

    public static CompoundBorder createCompoundBorder() {
        return new CompoundBorder();
    }

    public static CompoundBorder createCompoundBorder(Border border, Border border2) {
        return new CompoundBorder(border, border2);
    }

    public static MatteBorder createMatteBorder(int n, int n2, int n3, int n4, Color color) {
        return new MatteBorder(n, n2, n3, n4, color);
    }

    public static MatteBorder createMatteBorder(int n, int n2, int n3, int n4, Icon icon) {
        return new MatteBorder(n, n2, n3, n4, icon);
    }
}

