/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.AbstractAction;
import com.sun.java.swing.AbstractListModel;
import com.sun.java.swing.Action;
import com.sun.java.swing.BorderFactory;
import com.sun.java.swing.Box;
import com.sun.java.swing.BoxLayout;
import com.sun.java.swing.ComboBoxModel;
import com.sun.java.swing.Icon;
import com.sun.java.swing.JButton;
import com.sun.java.swing.JComboBox;
import com.sun.java.swing.JComponent;
import com.sun.java.swing.JLabel;
import com.sun.java.swing.JList;
import com.sun.java.swing.JPanel;
import com.sun.java.swing.JScrollPane;
import com.sun.java.swing.JTextField;
import com.sun.java.swing.JToggleButton;
import com.sun.java.swing.ListCellRenderer;
import com.sun.java.swing.ListModel;
import com.sun.java.swing.event.ListSelectionEvent;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicFileChooserUI;
import com.sun.java.swing.plaf.basic.BasicListCellRenderer;
import com.sun.java.swing.preview.JFileChooser;
import com.sun.java.swing.preview.filechooser.FileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Vector;

public class WindowsFileChooserUI
extends BasicFileChooserUI {
    private JPanel centerPanel;
    private JComboBox directoryComboBox;
    private DirectoryComboBoxModel directoryComboBoxModel;
    private Action directoryComboBoxAction = new DirectoryComboBoxAction();
    private FilterComboBoxModel filterComboBoxModel;
    private JTextField filenameTextField;
    private JList list;
    private JButton approveButton;
    private JButton cancelButton;
    private JComboBox filterComboBox;
    private JPanel bodyPanel;
    private static final Dimension hstrut10 = new Dimension(10, 1);
    private static final Dimension hstrut25 = new Dimension(25, 1);
    private static final Dimension vstrut10 = new Dimension(1, 10);
    private static final Insets shrinkwrap = new Insets(0, 0, 0, 0);
    private static int PREF_WIDTH = 500;
    private static int PREF_HEIGHT = 300;
    private static Dimension PREF_SIZE = new Dimension(PREF_WIDTH, PREF_HEIGHT);
    private static int MIN_WIDTH = 400;
    private static int MIN_HEIGHT = 200;
    private static Dimension MIN_SIZE = new Dimension(MIN_WIDTH, MIN_HEIGHT);
    private static int LIST_MIN_WIDTH = 400;
    private static int LIST_MIN_HEIGHT = 100;
    private static Dimension LIST_MIN_SIZE = new Dimension(LIST_MIN_WIDTH, LIST_MIN_HEIGHT);

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsFileChooserUI((JFileChooser)jComponent);
    }

    public WindowsFileChooserUI(JFileChooser jFileChooser) {
        super(jFileChooser);
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installComponents() {
        this.getFileChooser().setLayout((LayoutManager)new BoxLayout((Container)this.getFileChooser(), 1));
        this.getFileChooser().add(Box.createRigidArea((Dimension)vstrut10));
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new BoxLayout((Container)jPanel, 0));
        this.getFileChooser().add((Component)jPanel);
        this.getFileChooser().add(Box.createRigidArea((Dimension)vstrut10));
        JLabel jLabel = new JLabel("Look in:");
        jLabel.setAlignmentX(0.0f);
        jLabel.setAlignmentY(0.5f);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        jPanel.add((Component)jLabel);
        jPanel.add(Box.createRigidArea((Dimension)hstrut25));
        this.directoryComboBox = new JComboBox();
        this.directoryComboBoxModel = this.createDirectoryComboBoxModel();
        this.directoryComboBox.setModel((ComboBoxModel)this.directoryComboBoxModel);
        this.directoryComboBox.addActionListener((ActionListener)this.directoryComboBoxAction);
        this.directoryComboBox.setRenderer((ListCellRenderer)this.createDirectoryComboBoxRenderer());
        this.directoryComboBox.setAlignmentX(0.0f);
        this.directoryComboBox.setAlignmentY(0.5f);
        jPanel.add((Component)this.directoryComboBox);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        JButton jButton = new JButton(this.upFolderIcon);
        jButton.setToolTipText("Up One Level");
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener((ActionListener)this.getChangeToParentDirectoryAction());
        jPanel.add((Component)jButton);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        jButton = new JButton(this.homeFolderIcon);
        jButton.setToolTipText("Home");
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener((ActionListener)this.getGoHomeAction());
        jPanel.add((Component)jButton);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        jButton = new JButton(this.newFolderIcon);
        jButton.setToolTipText("Create New Folder");
        jButton.setAlignmentX(0.0f);
        jButton.setAlignmentY(0.5f);
        jButton.setMargin(shrinkwrap);
        jButton.setFocusPainted(false);
        jButton.addActionListener((ActionListener)this.getNewFolderAction());
        jPanel.add((Component)jButton);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        JToggleButton jToggleButton = new JToggleButton(this.listViewIcon);
        jToggleButton.setToolTipText("List");
        jToggleButton.setEnabled(false);
        jToggleButton.setFocusPainted(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add((Component)jToggleButton);
        jToggleButton = new JToggleButton(this.detailsViewIcon);
        jToggleButton.setToolTipText("Details");
        jToggleButton.setFocusPainted(false);
        jToggleButton.setSelected(true);
        jToggleButton.setEnabled(false);
        jToggleButton.setAlignmentX(0.0f);
        jToggleButton.setAlignmentY(0.5f);
        jToggleButton.setMargin(shrinkwrap);
        jPanel.add((Component)jToggleButton);
        jPanel.add(Box.createRigidArea((Dimension)hstrut10));
        this.centerPanel = new JPanel((LayoutManager)new BorderLayout());
        JPanel jPanel2 = this.createList();
        jPanel2.setMinimumSize(LIST_MIN_SIZE);
        this.centerPanel.add((Component)jPanel2, "Center");
        this.centerPanel.add((Component)this.getAccessoryPanel(), "East");
        JComponent jComponent = this.getFileChooser().getAccessory();
        if (jComponent != null) {
            this.getAccessoryPanel().add((Component)jComponent);
        }
        this.getFileChooser().add((Component)this.centerPanel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new BoxLayout((Container)jPanel3, 0));
        jPanel3.add(Box.createRigidArea((Dimension)hstrut10));
        this.getFileChooser().add(Box.createRigidArea((Dimension)vstrut10));
        this.getFileChooser().add((Component)jPanel3);
        this.getFileChooser().add(Box.createRigidArea((Dimension)vstrut10));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new BoxLayout((Container)jPanel4, 1));
        jLabel = new JLabel("File name:");
        jPanel4.add((Component)jLabel);
        jPanel4.add(Box.createRigidArea((Dimension)vstrut10));
        jLabel = new JLabel("Files of type:");
        jPanel4.add((Component)jLabel);
        jPanel3.add((Component)jPanel4);
        jPanel3.add(Box.createRigidArea((Dimension)hstrut25));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new BoxLayout((Container)jPanel5, 1));
        this.filenameTextField = new JTextField();
        this.filenameTextField.addActionListener((ActionListener)this.getApproveSelectionAction());
        File file = this.getFileChooser().getSelectedFile();
        if (file != null) {
            this.setFileName(this.getFileChooser().getName(file));
        }
        jPanel5.add((Component)this.filenameTextField);
        jPanel5.add(Box.createRigidArea((Dimension)vstrut10));
        this.filterComboBoxModel = this.createFilterComboBoxModel();
        this.getFileChooser().addPropertyChangeListener((PropertyChangeListener)this.filterComboBoxModel);
        this.filterComboBox = new JComboBox((ComboBoxModel)this.filterComboBoxModel);
        this.filterComboBox.setRenderer((ListCellRenderer)this.createFilterComboBoxRenderer());
        jPanel5.add((Component)this.filterComboBox);
        jPanel3.add((Component)jPanel5);
        jPanel3.add(Box.createRigidArea((Dimension)hstrut10));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new BoxLayout((Container)jPanel6, 1));
        this.approveButton = new 1(this.getApproveButtonText());
        this.approveButton.addActionListener((ActionListener)this.getApproveSelectionAction());
        this.approveButton.setToolTipText(this.getApproveButtonToolTipText());
        jPanel6.add((Component)this.approveButton);
        jPanel6.add(Box.createRigidArea((Dimension)vstrut10));
        this.cancelButton = new 2(this.cancelButtonText);
        this.cancelButton.setToolTipText(BasicFileChooserUI.cancelButtonToolTipText);
        this.cancelButton.addActionListener((ActionListener)this.getCancelSelectionAction());
        jPanel6.add((Component)this.cancelButton);
        jPanel3.add((Component)jPanel6);
        jPanel3.add(Box.createRigidArea((Dimension)hstrut10));
    }

    protected JPanel createList() {
        JPanel jPanel = new JPanel((LayoutManager)new BorderLayout());
        this.list = new JList();
        this.list.setCellRenderer((ListCellRenderer)new FileRenderer());
        this.list.setModel((ListModel)this.model);
        this.list.addListSelectionListener(this.createListSelectionListener());
        this.list.addMouseListener(this.createDoubleClickListener(this.list));
        JScrollPane jScrollPane = new JScrollPane((Component)this.list);
        jScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        jPanel.add((Component)jScrollPane, "Center");
        return jPanel;
    }

    public void uninstallUI(JComponent jComponent) {
        this.getFileChooser().removePropertyChangeListener((PropertyChangeListener)this.filterComboBoxModel);
        this.cancelButton.removeActionListener((ActionListener)this.getCancelSelectionAction());
        this.approveButton.removeActionListener((ActionListener)this.getApproveSelectionAction());
        this.filenameTextField.removeActionListener((ActionListener)this.getApproveSelectionAction());
        super.uninstallUI(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("ApproveSelection")) {
            File file = (File)propertyChangeEvent.getNewValue();
            if (file != null) {
                this.setFileName(this.getFileChooser().getName(file));
                if (this.model.contains((Object)file)) {
                    this.list.setSelectedIndex(this.model.indexOf(propertyChangeEvent.getNewValue()));
                    this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
                    return;
                }
            }
        } else if (string.equals("directoryChanged")) {
            this.fileView.clearIconCache();
            this.list.clearSelection();
            File file = this.getFileChooser().getCurrentDirectory();
            if (file != null) {
                this.directoryComboBoxModel.addItem(file);
                this.getNewFolderAction().setEnabled(file.canWrite());
                return;
            }
        } else {
            if (string.equals("fileSelectionChanged")) {
                this.fileView.clearIconCache();
                this.list.clearSelection();
                return;
            }
            if (string == "AccessoryChangedProperty") {
                if (this.accessoryPanel != null) {
                    JComponent jComponent;
                    if (propertyChangeEvent.getOldValue() != null) {
                        this.getAccessoryPanel().remove((Component)((JComponent)propertyChangeEvent.getOldValue()));
                    }
                    if ((jComponent = (JComponent)propertyChangeEvent.getNewValue()) != null) {
                        this.getAccessoryPanel().add((Component)jComponent, "Center");
                        return;
                    }
                }
            } else if (string == "ApproveButtonTextChangedProperty" || string == "DialogTypeChangedProperty") {
                this.approveButton.setText(this.getApproveButtonText());
                this.approveButton.setToolTipText(this.getApproveButtonToolTipText());
            }
        }
    }

    public void ensureFileIsVisible(File file) {
        if (this.model.contains((Object)file)) {
            this.list.setSelectedIndex(this.model.indexOf((Object)file));
            this.list.ensureIndexIsVisible(this.list.getSelectedIndex());
        }
    }

    public void rescanCurrentDirectory() {
        this.model.invalidateFileCache();
        this.model.validateFileCache();
    }

    public String getFileName() {
        if (this.filenameTextField != null) {
            return this.filenameTextField.getText();
        }
        return null;
    }

    public void setFileName(String string) {
        if (this.filenameTextField != null) {
            this.filenameTextField.setText(string);
        }
    }

    public String getDirectoryName() {
        return null;
    }

    public void setDirectoryName(String string) {
    }

    protected DirectoryComboBoxRenderer createDirectoryComboBoxRenderer() {
        return new DirectoryComboBoxRenderer();
    }

    protected DirectoryComboBoxModel createDirectoryComboBoxModel() {
        return new DirectoryComboBoxModel();
    }

    protected FilterComboBoxRenderer createFilterComboBoxRenderer() {
        return new FilterComboBoxRenderer();
    }

    protected FilterComboBoxModel createFilterComboBoxModel() {
        return new FilterComboBoxModel();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        File file = this.getFileChooser().getSelectedFile();
        if (!listSelectionEvent.getValueIsAdjusting() && file != null && !this.getFileChooser().isTraversable(file)) {
            this.setFileName(this.getFileChooser().getName(file));
        }
    }

    private final class 1
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        /* synthetic */ 1(String string) {
            super(string);
        }
    }

    private final class 2
    extends JButton {
        public Dimension getMaximumSize() {
            return new Dimension(Short.MAX_VALUE, Short.MAX_VALUE);
        }

        /* synthetic */ 2(String string) {
            super(string);
        }
    }

    protected class FileRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            String string = WindowsFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            return this;
        }

        FileRenderer() {
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
        }
    }

    class DirectoryComboBoxRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            File file = (File)object;
            if (file == null) {
                this.setText("");
                return this;
            }
            String string = WindowsFileChooserUI.this.getFileChooser().getName(file);
            this.setText(string);
            Icon icon = WindowsFileChooserUI.this.getFileChooser().getIcon(file);
            this.setIcon(icon);
            return this;
        }

        DirectoryComboBoxRenderer() {
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
        }
    }

    protected class DirectoryComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        Vector directories = new Vector();
        File selectedDirectory;

        public DirectoryComboBoxModel() {
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
            File[] fileArray = WindowsFileChooserUI.this.getFileChooser().getFileSystemView().getRoots();
            int n = 0;
            while (n < fileArray.length) {
                this.addItem(fileArray[n]);
                ++n;
            }
            this.addItem(WindowsFileChooserUI.this.getFileChooser().getCurrentDirectory());
        }

        public void addItem(File file) {
            if (file != null) {
                if (!this.directories.contains(file)) {
                    this.directories.addElement(file);
                }
                this.setSelectedItem(file);
            }
        }

        public void setSelectedItem(Object object) {
            this.selectedDirectory = (File)object;
            this.fireContentsChanged((Object)this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.selectedDirectory;
        }

        public int getSize() {
            return this.directories.size();
        }

        public Object getElementAt(int n) {
            return this.directories.elementAt(n);
        }
    }

    public class FilterComboBoxRenderer
    extends BasicListCellRenderer {
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent(jList, object, n, bl, bl2);
            FileFilter fileFilter = (FileFilter)object;
            if (fileFilter != null) {
                this.setText(fileFilter.getDescription());
            }
            return this;
        }

        public FilterComboBoxRenderer() {
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
        }
    }

    protected class FilterComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    PropertyChangeListener {
        protected FileFilter[] filters;

        protected FilterComboBoxModel() {
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
            this.filters = WindowsFileChooserUI.this.getFileChooser().getChoosableFileFilters();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "ChoosableFileFilterChangedProperty") {
                this.filters = (FileFilter[])propertyChangeEvent.getNewValue();
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public void setSelectedItem(Object object) {
            if (object != null) {
                WindowsFileChooserUI.this.getFileChooser().setFileFilter((FileFilter)object);
                this.fireContentsChanged(this, -1, -1);
            }
        }

        public Object getSelectedItem() {
            FileFilter fileFilter = WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            boolean bl = false;
            if (fileFilter != null) {
                int n = 0;
                while (n < this.filters.length) {
                    if (this.filters[n] == fileFilter) {
                        bl = true;
                    }
                    ++n;
                }
                if (!bl) {
                    WindowsFileChooserUI.this.getFileChooser().addChoosableFileFilter(fileFilter);
                }
            }
            return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
        }

        public int getSize() {
            if (this.filters != null) {
                return this.filters.length;
            }
            return 0;
        }

        public Object getElementAt(int n) {
            if (n > this.getSize() - 1) {
                return WindowsFileChooserUI.this.getFileChooser().getFileFilter();
            }
            if (this.filters != null) {
                return this.filters[n];
            }
            return null;
        }
    }

    protected class DirectoryComboBoxAction
    extends AbstractAction {
        protected DirectoryComboBoxAction() {
            super("DirectoryComboBoxAction");
            WindowsFileChooserUI.this = WindowsFileChooserUI.this;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            WindowsFileChooserUI.this.getFileChooser().setCurrentDirectory((File)WindowsFileChooserUI.this.directoryComboBox.getSelectedItem());
        }
    }
}

