/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.motif;

import com.sun.java.swing.JComponent;
import com.sun.java.swing.JTabbedPane;
import com.sun.java.swing.LookAndFeel;
import com.sun.java.swing.UIManager;
import com.sun.java.swing.plaf.ComponentUI;
import com.sun.java.swing.plaf.basic.BasicTabbedPaneUI;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;

public class MotifTabbedPaneUI
extends BasicTabbedPaneUI {
    protected static int spacingHeight = 1;
    protected static int spacingWidth = 3;
    protected static int selectedTabHeightPad = 4;
    protected static int selectedTabWidthPad;
    protected static Insets mContentBorderInsets;
    protected static Insets mTabsOnTopTabAreaInsets;
    protected static Insets mTabsOnLeftTabAreaInsets;
    protected static Insets mTabsOnBottomTabAreaInsets;
    protected static Insets mTabsOnRightTabAreaInsets;
    protected Color unselectedTabBackground;
    protected Color unselectedTabForeground;
    protected Color unselectedTabShadow;
    protected Color unselectedTabHighlight;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MotifTabbedPaneUI();
    }

    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        jComponent.setLayout((LayoutManager)((Object)this));
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont((JComponent)jComponent, (String)"TabbedPane.tabBackground", (String)"TabbedPane.tabForeground", (String)"TabbedPane.font");
        this.tabDarkShadow = this.tabShadow = UIManager.getColor((Object)"TabbedPane.tabShadow");
        this.tabHighlight = UIManager.getColor((Object)"TabbedPane.tabHighlight");
        this.unselectedTabBackground = UIManager.getColor((Object)"TabbedPane.unselectedTabBackground");
        this.unselectedTabForeground = UIManager.getColor((Object)"TabbedPane.unselectedTabForeground");
        this.unselectedTabShadow = UIManager.getColor((Object)"TabbedPane.unselectedTabShadow");
        this.unselectedTabHighlight = UIManager.getColor((Object)"TabbedPane.unselectedTabHighlight");
        this.focus = UIManager.getColor((Object)"TabbedPane.focus");
    }

    protected void paintContentBorderTopEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabHighlight);
        if (n != 1 || n2 < 0) {
            graphics.drawLine(n3, n4, n3 + n5 - 2, n4);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3, n4, rectangle.x - 1, n4);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.drawLine(rectangle.x + rectangle.width, n4, n3 + n5 - 2, n4);
        }
    }

    protected void paintContentBorderBottomEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabShadow);
        if (n != 3 || n2 < 0) {
            graphics.drawLine(n3 + 1, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3 + 1, n4 + n6 - 1, rectangle.x - 1, n4 + n6 - 1);
        if (rectangle.x + rectangle.width < n3 + n5 - 2) {
            graphics.drawLine(rectangle.x + rectangle.width, n4 + n6 - 1, n3 + n5 - 2, n4 + n6 - 1);
        }
    }

    protected void paintContentBorderRightEdge(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics.setColor(this.tabShadow);
        if (n != 4 || n2 < 0) {
            graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, n4 + n6 - 1);
            return;
        }
        Rectangle rectangle = this.rects[n2];
        graphics.drawLine(n3 + n5 - 1, n4 + 1, n3 + n5 - 1, rectangle.y - 1);
        if (rectangle.y + rectangle.height < n4 + n6 - 2) {
            graphics.drawLine(n3 + n5 - 1, rectangle.y + rectangle.height, n3 + n5 - 1, n4 + n6 - 2);
        }
    }

    protected void paintTabBackground(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? jTabbedPane.getBackgroundAt(n2) : this.unselectedTabBackground);
        switch (n) {
            case 2: {
                graphics.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 2);
                return;
            }
            case 4: {
                graphics.fillRect(n3, n4 + 1, n5 - 1, n6 - 2);
                return;
            }
            case 3: {
                graphics.fillRect(n3 + 1, n4, n5 - 2, n6 - 3);
                graphics.drawLine(n3 + 2, n4 + n6 - 3, n3 + n5 - 3, n4 + n6 - 3);
                graphics.drawLine(n3 + 3, n4 + n6 - 2, n3 + n5 - 4, n4 + n6 - 2);
                return;
            }
        }
        graphics.fillRect(n3 + 1, n4 + 3, n5 - 2, n6 - 3);
        graphics.drawLine(n3 + 2, n4 + 2, n3 + n5 - 3, n4 + 2);
        graphics.drawLine(n3 + 3, n4 + 1, n3 + n5 - 4, n4 + 1);
    }

    protected void paintTabBorder(Graphics graphics, JTabbedPane jTabbedPane, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        graphics.setColor(bl ? this.tabHighlight : this.unselectedTabHighlight);
        switch (n) {
            case 2: {
                graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 2);
                graphics.drawLine(n3 + 2, n4, n3 + 2, n4 + 1);
                graphics.drawLine(n3 + 3, n4, n3 + n5 - 1, n4);
                graphics.setColor(bl ? this.tabShadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 1);
                graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 1, n4 + n6 - 1);
                return;
            }
            case 4: {
                graphics.drawLine(n3, n4, n3 + n5 - 3, n4);
                graphics.setColor(bl ? this.tabShadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 3, n4 + 1);
                graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 2);
                graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 3);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3, n4 + n6 - 1, n3 + n5 - 3, n4 + n6 - 1);
                return;
            }
            case 3: {
                graphics.drawLine(n3, n4, n3, n4 + n6 - 3);
                graphics.drawLine(n3 + 1, n4 + n6 - 3, n3 + 1, n4 + n6 - 2);
                graphics.drawLine(n3 + 2, n4 + n6 - 2, n3 + 2, n4 + n6 - 1);
                graphics.setColor(bl ? this.tabShadow : this.unselectedTabShadow);
                graphics.drawLine(n3 + 3, n4 + n6 - 1, n3 + n5 - 4, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 3, n4 + n6 - 2, n3 + n5 - 3, n4 + n6 - 1);
                graphics.drawLine(n3 + n5 - 2, n4 + n6 - 3, n3 + n5 - 2, n4 + n6 - 2);
                graphics.drawLine(n3 + n5 - 1, n4, n3 + n5 - 1, n4 + n6 - 3);
                return;
            }
        }
        graphics.drawLine(n3, n4 + 2, n3, n4 + n6 - 1);
        graphics.drawLine(n3 + 1, n4 + 1, n3 + 1, n4 + 2);
        graphics.drawLine(n3 + 2, n4, n3 + 2, n4 + 1);
        graphics.drawLine(n3 + 3, n4, n3 + n5 - 4, n4);
        graphics.setColor(bl ? this.tabShadow : this.unselectedTabShadow);
        graphics.drawLine(n3 + n5 - 3, n4, n3 + n5 - 3, n4 + 1);
        graphics.drawLine(n3 + n5 - 2, n4 + 1, n3 + n5 - 2, n4 + 2);
        graphics.drawLine(n3 + n5 - 1, n4 + 2, n3 + n5 - 1, n4 + n6 - 1);
    }

    protected void paintFocusIndicator(Graphics graphics, JTabbedPane jTabbedPane, int n, Rectangle[] rectangleArray, int n2, Rectangle rectangle, Rectangle rectangle2, boolean bl) {
        Rectangle rectangle3 = rectangleArray[n2];
        if (jTabbedPane.hasFocus() && bl) {
            int n3;
            int n4;
            int n5;
            int n6;
            graphics.setColor(this.focus);
            switch (n) {
                case 2: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 4: {
                    n6 = rectangle3.x + 2;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 6;
                    n3 = rectangle3.height - 7;
                    break;
                }
                case 3: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 2;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 6;
                    break;
                }
                default: {
                    n6 = rectangle3.x + 3;
                    n5 = rectangle3.y + 3;
                    n4 = rectangle3.width - 7;
                    n3 = rectangle3.height - 6;
                }
            }
            graphics.drawRect(n6, n5, n4, n3);
        }
    }

    protected void calculateLayoutInfo(JTabbedPane jTabbedPane) {
        int n = jTabbedPane.getTabPlacement();
        Font font = jTabbedPane.getFont();
        Font font2 = new Font(font.getName(), font.getStyle() | 1, font.getSize());
        int n2 = jTabbedPane.getTabCount();
        int n3 = jTabbedPane.getSelectedIndex();
        this.assureRectsCreated(n2);
        this.arrangeTabs(jTabbedPane, n, n2, font2);
        this.padSelectedTab(jTabbedPane, n, n3);
    }

    protected int getRunIndent(JTabbedPane jTabbedPane, int n, int n2) {
        return n2 * 3;
    }

    protected int getTabOverlay(JTabbedPane jTabbedPane, int n) {
        this.overlay = n == 2 || n == 4 ? (int)Math.round((double)this.maxTabWidth * 0.1) : (int)Math.round((double)this.maxTabHeight * 0.22);
        return this.overlay;
    }

    protected Insets getTabAreaInsets(JTabbedPane jTabbedPane, int n) {
        Insets insets;
        switch (n) {
            case 2: {
                insets = mTabsOnLeftTabAreaInsets;
                break;
            }
            case 3: {
                insets = mTabsOnBottomTabAreaInsets;
                break;
            }
            case 4: {
                insets = mTabsOnRightTabAreaInsets;
                break;
            }
            default: {
                insets = mTabsOnTopTabAreaInsets;
            }
        }
        return insets;
    }

    protected Insets getContentBorderInsets(JTabbedPane jTabbedPane, int n) {
        return mContentBorderInsets;
    }

    static {
        mContentBorderInsets = new Insets(2, 2, 2, 2);
        mTabsOnTopTabAreaInsets = new Insets(4, 2, 0, 8);
        mTabsOnLeftTabAreaInsets = new Insets(2, 4, 8, 0);
        mTabsOnBottomTabAreaInsets = new Insets(0, 2, 4, 8);
        mTabsOnRightTabAreaInsets = new Insets(2, 0, 8, 4);
    }
}

