/* Linux/PowerPC native-dependent code for GDB, the GNU debugger.
   Copyright 1986, 1987, 1989, 1991, 1992, 1994 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#include "defs.h"
#include "inferior.h"
#include "target.h"
#include "gdbcore.h"
#if 0
#include "xcoffsolib.h"
#include "symfile.h"
#include "objfiles.h"
#include "libbfd.h"  /* For bfd_cache_lookup (FIXME) */
#include "bfd.h"
#include "gdb-stabs.h"
#endif

#include <sys/ptrace.h>

#include <sys/param.h>
#include <sys/dir.h>
#include <sys/user.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <assert.h>

/* Mapping from internal to Linux numbering */
static int special_registers_map[] = {
	PT_NIP, /* PC_REGNUM 64	Program counter (instruction address %iar) */
	PT_MSR, /* PS_REGNUM 65 Processor (or machine) status (%msr) */
	PT_CCR, /* CR_REGNUM 66	Condition register */
	PT_LNK, /* LR_REGNUM 67	Link register */
	PT_CTR, /* CTR_REGNUM 68 Count register */
	PT_XER, /* XER_REGNUM 69 Fixed point exception registers */
};

unsigned int
register_addr (regno, blockend)
    int regno;
    int blockend;
{
    assert(!CANNOT_FETCH_REGISTER (regno));
    if (regno < FP0_REGNUM)
	return 4 * regno;
    else {
	assert(regno >= FIRST_SP_REGNUM && regno < LAST_SP_REGNUM);
	return 4 * special_registers_map[regno - FIRST_SP_REGNUM];
    }
}

#if 0
/* Read register values into local cache. */

void
ptrace_fetch_inferior_registers (regno)
  int regno;
{
	extern char registers[];
	if (regno < 0)
	{ /* Fetch all registers */
fprintf_unfiltered(gdb_stderr, "Read all registers\n");	
	} else
	{ /* Fetch a specific register */
		if (regno < FP0_REGNUM)
		{ /* GPR0..GPR31 */
			*(int*)&registers[REGISTER_BYTE (regno)] =
				ptrace (PTRACE_PEEKUSR, inferior_pid, regno*4, 0);
		} else
		if (regno <= FPLAST_REGNUM)
		{ /* FPR0..FPR31 */
		} else
		if (regno < LAST_SP_REGNUM)
		{ /* Special register */
			*(int*)&registers[REGISTER_BYTE (regno)] =
				ptrace (PTRACE_PEEKUSR, inferior_pid,
					special_registers_map[regno-FIRST_SP_REGNUM]*4, 0);
		} else
		{
			fprintf_unfiltered (gdb_stderr, "gdb error: register no %d not implemented.\n", regno);
			return;
		}
		register_valid [regno] = 1;
	}
}

/* Store our register values back into the inferior.
   If REGNO is -1, do this for all registers.
   Otherwise, REGNO specifies which register (so we can save time).  */

void
ptrace_store_inferior_registers (regno)
     int regno;
{
	fprintf_unfiltered(gdb_stderr, "store_inferior_registers(%d)\n", regno);
	abort();
}
#endif

/* Extract the register values out of the core file and store
   them where `read_register' will find them.

   CORE_REG_SECT points to the register values themselves, read into memory.
   CORE_REG_SIZE is the size of that area.
   WHICH says which set of registers we are handling (0 = int, 2 = float
         on machines where they are discontiguous).
   REG_ADDR is the offset from u.u_ar0 to the register values relative to
            core_reg_sect.  This is used with old-fashioned core files to
	    locate the registers in a large upage-plus-stack ".reg" section.
	    Original upage address X is at location core_reg_sect+x+reg_addr.
 */

void
fetch_core_registers (core_reg_sect, core_reg_size, which, reg_addr)
     char *core_reg_sect;
     unsigned core_reg_size;
     int which;
     unsigned reg_addr;
{
	fprintf_unfiltered(gdb_stderr, "fetch_inferior_registers()\n");
	abort();
}
