/* Low level interface to I860 running mach 3.0.
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "defs.h"
#include "inferior.h"

#include <stdio.h>

#include <mach.h>
#include <mach/message.h>
#include <mach/exception.h>
#include <mach_error.h>

/*
#include <target.h>

*/
#define private static


/* Find offsets to thread states at compile time.
 * If your compiler does not grok this, calculate offsets
 * offsets yourself and use them (or get a compatible compiler :-)
 */

#define  REG_OFFSET(reg) (int)(&((struct i860_thread_state *)0)->reg)

/* at reg_offset[i] is the offset to the i860_thread_state
 * location where the gdb registers[i] is stored.
 */

#if 0	
/* this stuff doesn't work because some of the i860_thread_state registers
   are doubles and all the code assumes they are not greater than 4 and
   it assumes they are all the same size. I can't add fake half regs for
   the doubles because they are not define in i860_thread_state as used
   by REG_OFFSET.  So the offsets are defined explicitly below this.
 */

static int reg_offset[] = 
{
  REG_OFFSET(r0),  REG_OFFSET(r1), REG_OFFSET(sp), REG_OFFSET(fp),
  REG_OFFSET(r4), REG_OFFSET(r5), REG_OFFSET(r6), REG_OFFSET(r7),
  REG_OFFSET(r8),  REG_OFFSET(r9), REG_OFFSET(r10),  REG_OFFSET(r11),
  REG_OFFSET(r12),   REG_OFFSET(r13),  REG_OFFSET(r14),  REG_OFFSET(r15),
  REG_OFFSET(r16),  REG_OFFSET(r17), REG_OFFSET(r18),  REG_OFFSET(r19),
  REG_OFFSET(r20),  REG_OFFSET(r21), REG_OFFSET(r22),  REG_OFFSET(r23),
  REG_OFFSET(r24),  REG_OFFSET(r25), REG_OFFSET(r26),  REG_OFFSET(r27),
  REG_OFFSET(r28),  REG_OFFSET(r29), REG_OFFSET(r30),  REG_OFFSET(r31),
  REG_OFFSET(f0),  REG_OFFSET(f1), REG_OFFSET(f2),  REG_OFFSET(f3),
  REG_OFFSET(f4),  REG_OFFSET(f5), REG_OFFSET(f6),  REG_OFFSET(f7),
  REG_OFFSET(f8),  REG_OFFSET(f9), REG_OFFSET(f10),  REG_OFFSET(f11),
  REG_OFFSET(f12),  REG_OFFSET(f13), REG_OFFSET(f14),  REG_OFFSET(f15),
  REG_OFFSET(f16),  REG_OFFSET(f17), REG_OFFSET(f18),  REG_OFFSET(f19),
  REG_OFFSET(f20),  REG_OFFSET(f21), REG_OFFSET(f22),  REG_OFFSET(f23),
  REG_OFFSET(f24),  REG_OFFSET(f25), REG_OFFSET(f26),  REG_OFFSET(f27),
  REG_OFFSET(f28),  REG_OFFSET(f29), REG_OFFSET(f30),  REG_OFFSET(f31),
  REG_OFFSET(spc_t),  REG_OFFSET(spc_td), 
  REG_OFFSET(spc_ki), REG_OFFSET(spc_kid), 
  REG_OFFSET(spc_kr), REG_OFFSET(spc_krd),
  REG_OFFSET(spc_merge), REG_OFFSET(spc_merged), 
  REG_OFFSET(psv_l1), REG_OFFSET(psv_l1d),  
  REG_OFFSET(psv_l2), REG_OFFSET(psv_l2d),
  REG_OFFSET(psv_l3), REG_OFFSET(psv_l3d), 
  REG_OFFSET(psv_a1), REG_OFFSET(psv_a1d),  
  REG_OFFSET(psv_a2), REG_OFFSET(psv_a2d),
  REG_OFFSET(psv_a3), REG_OFFSET(psv_a3d), 
  REG_OFFSET(psv_m1), REG_OFFSET(psv_m1d),  
  REG_OFFSET(psv_m2), REG_OFFSET(psv_m2d),
  REG_OFFSET(psv_m3), REG_OFFSET(psv_m3d), 
  REG_OFFSET(psv_i1), REG_OFFSET(psv_i1d),  
  REG_OFFSET(fsr1),   REG_OFFSET(fsr2),
  REG_OFFSET(fsr), REG_OFFSET(psr),  REG_OFFSET(pc),  REG_OFFSET(dirbase),
  REG_OFFSET(db),  REG_OFFSET(epsr),  
  REG_OFFSET(fp1), REG_OFFSET(fp1d),  
  REG_OFFSET(fp2), REG_OFFSET(fp2d),
  REG_OFFSET(fp3), REG_OFFSET(fp3d), 
  REG_OFFSET(fp4), REG_OFFSET(fp4d),  
  REG_OFFSET(fpe_trapped_op), REG_OFFSET(fpe_rdest), 
  REG_OFFSET(fpe_src1),  REG_OFFSET(fpe_ieee_status)
};
#else
static int reg_offset[] = 
{
 0,4,8,12,16,20,24,28,32,26,40,44,48,52,56,60,64,68,72,76,80,84,88,92,96,
100,104,108,112,116,120,124,128,132,136,140,144,148,152,156,160,164,168,172,176,180,184,188,192,196,
200,204,208,212,216,220,224,228,232,236,240,244,248,252,256,260,264,268,272,276,280,284,288,292,296,
300,304,308,312,316,320,324,328,332,336,340,344,348,352,356,360,364,368,372,376,380,384,388,392,396,
400,404,408,412,416,420,424,428,432,436,440,444,448
};
#endif

/* Fetch COUNT contiguous registers from thread STATE starting from REGNUM
 * Caller knows that the regs handled in one transaction are of same size.
 */
#define FETCH_REGS(state, regnum, count) \
  bcopy ((char *)state+reg_offset[ regnum ], \
	 &registers[REGISTER_BYTE (regnum)], \
	 count*sizeof (REGISTER_TYPE))

/* Store COUNT contiguous registers to thread STATE starting from REGNUM */
#define STORE_REGS(state, regnum, count) \
  bcopy (&registers[REGISTER_BYTE (regnum)], \
	 (char *)state+reg_offset[ regnum ], \
	 count*sizeof (REGISTER_TYPE))

/*
 * Fetch inferiors registers for gdb.
 * REGNO specifies which (as gdb views it) register, -1 for all.
 */

void
fetch_inferior_registers (regno)
     int regno;
{
  kern_return_t ret;
  thread_state_data_t state;
  unsigned int stateCnt = i860_THREAD_STATE_COUNT;
  int index;
  
  if (! MACH_PORT_VALID (current_thread))
    error ("fetch inferior registers: Invalid thread");

  if (must_suspend_thread)
    setup_thread (current_thread, 1);

  ret = thread_get_state (current_thread,
			  i860_THREAD_STATE,
			  state,
			  &stateCnt);

  if (ret != KERN_SUCCESS)
    warning ("fetch_inferior_registers: %s ",
	     mach_error_string (ret));
#if 0
  /* It may be more effective to store validate all of them,
   * since we fetched them all anyway
   */
  else if (regno != -1)
    supply_register (regno, (char *)state+reg_offset[regno]);
#endif
  else
    {
      for (index = 0; index < NUM_REGS; index++) 
	supply_register (index, (char *)state+reg_offset[index]);
    }

  if (must_suspend_thread)
    setup_thread (current_thread, 0);
}

/* Store our register values back into the inferior.
 * If REGNO is -1, do this for all registers.
 * Otherwise, REGNO specifies which register
 *
 * On mach3 all registers are always saved in one call.
 */
void
store_inferior_registers (regno)
     int regno;
{
  kern_return_t ret;
  thread_state_data_t state;
  unsigned int stateCnt = i860_THREAD_STATE_COUNT;
  register int index;

  if (! MACH_PORT_VALID (current_thread))
    error ("store inferior registers: Invalid thread");

  if (must_suspend_thread)
    setup_thread (current_thread, 1);

  /* Fetch the state of the current thread */
  ret = thread_get_state (current_thread,
			  i860_THREAD_STATE,
			  state,
			  &stateCnt);

   if (ret != KERN_SUCCESS) 
    {
      warning ("store_inferior_registers (get): %s",
	       mach_error_string (ret));
      if (must_suspend_thread)
	setup_thread (current_thread, 0);
      return;
    }

  /* move gdb's registers to thread's state
   *
   * Since we save all registers anyway, save the ones
   * that gdb thinks are valid (e.g. ignore the regno
   * parameter)
   */
#if 0
  if (regno != -1)
    STORE_REGS (state, regno, 1);
  else
#endif
    {
      for (index = 0; index < NUM_REGS; index++) 
	STORE_REGS (state, index, 1);
    }
  
  /* Write gdb's current view of register to the thread
   */
  ret = thread_set_state (current_thread,
			  i860_THREAD_STATE,
			  state,
			  i860_THREAD_STATE_COUNT);
  
  if (ret != KERN_SUCCESS)
    warning ("store_inferior_registers (set): %s",
	     mach_error_string (ret));

  if (must_suspend_thread)
    setup_thread (current_thread, 0);
}

