/* Macro definitions for Power PC running embedded ABI.
   Copyright 1995 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

#ifndef TM_PPC_EABI_H
#define TM_PPC_EABI_H

/* Use generic RS6000 definitions. */
#include "rs6000/tm-rs6000.h"

/* Include common definitions for Mach3 systems */
#include "nm-m3.h"

#undef CONVERT_FROM_FUNC_PTR_ADDR/* Not relevant to Linux */

#undef NO_SINGLE_STEP		/* Linux can handle this! */

#undef	DEFAULT_LR_SAVE
#define	DEFAULT_LR_SAVE 4	/* eabi saves LR at 4 off of SP */

#define GDB_TARGET_POWERPC

#undef PC_LOAD_SEGMENT
#undef PROCESS_LINENUMBER_HOOK

#undef TEXT_SEGMENT_BASE
#define TEXT_SEGMENT_BASE 1

#define M3_DONT_SIGNAL		/* Signals produce undesirable interactions
				   because gdb uses thread_abort() and not
				   thread_abort_safely(). */

/* We don't define FETCH_INFERIOR_REGISTERS, but we need to supply some
   definitions for the default ptrace code in infptrace.c. */
#define PT_TRACE_ME	PTRACE_TRACEME
#define PT_READ_I	PTRACE_PEEKTEXT
#define PT_READ_D	PTRACE_PEEKDATA
#define PT_READ_U	PTRACE_PEEKUSR
#define PT_WRITE_I	PTRACE_POKETEXT
#define PT_WRITE_D	PTRACE_POKEDATA
#define PT_WRITE_U	PTRACE_POKEUSR
#define PT_CONTINUE	PTRACE_CONT
#define PT_KILL		PTRACE_KILL
#define PT_STEP		PTRACE_SINGLESTEP
#define U_REGS_OFFSET	0
/* All registers can be fetched and stored. */
#define CANNOT_FETCH_REGISTER(regno) 0
#define CANNOT_STORE_REGISTER(regno) CANNOT_FETCH_REGISTER(regno)

#define M3_THREAD_STATE_FOR_REGISTER(regno) \
	(((unsigned)((regno) - FP0_REGNUM) <= \
		(unsigned)(FPLAST_REGNUM - FP0_REGNUM)) ? \
	    PPC_FLOAT_STATE : \
	    PPC_THREAD_STATE)
#define M3_THREAD_STATE_OFFSET_FOR_REGISTER(regno) \
	ppc_thread_state_offset (regno)
extern int ppc_thread_state_offset PARAMS ((int));
#define M3_SUPPLY_THREAD_STATE_REGISTERS(flavor, state) \
	ppc_supply_thread_state_registers(flavor, state)
extern void ppc_supply_thread_state_registers PARAMS ((thread_state_flavor_t,
						       thread_state_t));
#define M3_STORE_ALL_REGISTERS() ppc_store_all_registers()
extern void ppc_store_all_registers PARAMS ((void));
#define M3_MAKE_THREAD_STATE(flavor, state) ppc_make_thread_state(flavor, state)
extern int ppc_make_thread_state PARAMS ((thread_state_flavor_t,
					  thread_state_t));

#define MSR_SE			(1<<10)

#define TRACE_FLAVOR		PPC_THREAD_STATE
#define TRACE_FLAVOR_SIZE	PPC_THREAD_STATE_COUNT
#define TRACE_SET(x, state) \
	(((struct ppc_thread_state *)(state))->srr1 |= MSR_SE)
#define TRACE_CLEAR(x, state) \
	((((struct ppc_thread_state *)(state))->srr1 &= ~MSR_SE), 1)

/* Special case when it's the current thread -- we probably already have
   its state so avoid redundant wasteful thread_get_state() calls.  We
   would like to do just read_register_gen, modify, write_register_gen,
   but the problem is that write_register_gen calls target_prepare_to_store
   which wants *all* register values to be valid, including the floating-point
   registers.  Since we don't usually have those on hand, we'd end up doing
   a futile thread_get_state anyway.  So we excerpt the bits of
   write_register_gen we need.  The correct solution would probably be for
   target_prepare_to_store to take an argument saying which register is about
   to be stored.  */
#define M3_TRACE_CURRENT_THREAD(set) \
	do { \
	  int *msrp = (int *) &registers[REGISTER_BYTE (PS_REGNUM)]; \
	  read_register_gen (PS_REGNUM, (char *) msrp); \
	  if (set) \
	    *msrp |= MSR_SE; \
	  else \
	    *msrp &= ~MSR_SE; \
	  target_store_registers (PS_REGNUM); \
	} while (0)

#define FLUSH_INFERIOR_CACHE	1

#endif /* TM_PPC_EABI_H */
