/*
 * This file contains changes from the Open Software Foundation.
 * The RCS history log will appear at the end of this file.
 * @(#)swap.h	$Revision: 1.1.2.4 $ $Date: 1995/05/12 15:39:45 $ $Locker:  $
 */

/*** compile-time swapping code for bfd libraries */

/* We can tell at compile-time whether swapping will be required by
   backend code.  So there's no reason not to optimise that.
   Front-end and user code still has to decide at run time of course

   The "swapin" macros swap IN data, from target to host.
   The "swapout" macros swap OUT data, from host to target.

   There is currently no difference between them, but at some future
   point (e.g. if we ever have to convert floating point formats,
   or ASCII/EBCDIC fer HAL's sake), there might be.  */


#ifndef TARGET_BYTE_ORDER
Target byte order must be defined at compile time;
#endif

#ifndef HOST_BYTE_ORDER
Host byte order must be defined at compile time;
#endif

#if TARGET_BYTE_ORDER == HOST_BYTE_ORDER
#define swapinlong(dat) 
#define swapinshort(dat) 
#define swapoutlong(dat, ptr) (*(ptr) = (dat))
#define swapoutshort(dat, ptr) (*(ptr) = (dat))
#else

#if TARGET_BYTE_ORDER == BIG_ENDIAN
/* Big-endian target machine */
#define swapinlong(dat) ((dat) = bfd_getb32 ((unsigned char *) &dat))
#define swapinshort(dat) ((dat) = bfd_getb16 ((unsigned char *) &dat))
#define swapoutlong(dat, ptr) (bfd_putb32 (dat, (unsigned char *) &ptr))
#define swapoutshort(dat, ptr) (bfd_putb16 (dat, (unsigned char *) &ptr))
#else
/* Little-endian target machine */
#define swapinlong(dat) ((dat) = bfd_getl32 ((unsigned char *) &dat))
#define swapinshort(dat) ((dat) = bfd_getl16 ((unsigned char *) &dat))
#define swapoutlong(dat, ptr) (bfd_putl32 (dat, (unsigned char *) &ptr))
#define swapoutshort(dat, ptr) (bfd_putl16 (dat, (unsigned char *) &ptr))
#endif

#endif
/*
 * COPYRIGHT NOTICE
 * 
 * OSF/1
 */

/*
 * HISTORY
 * $Log: swap.h,v $
 * Revision 1.1.2.4  1995/05/12  15:39:45  duthie
 * 	Fix some byte swapping problems.
 * 	[1995/01/25  18:22:01  duthie]
 *
 * Revision 1.1.2.3  1994/03/12  00:48:09  chasb
 * 	Expand Copyrights
 * 	[1994/03/09  19:51:34  chasb]
 * 
 * Revision 1.1.2.2  1993/03/02  15:09:13  smk
 * 	gdb-4.8
 * 	[1993/03/02  15:07:11  smk]
 * 
 * Revision 3.0  1993/01/01  04:35:38  ede
 * 	Initial revision for OSF/1 R1.3
 * 
 * Revision 1.1.2.2  1992/08/28  15:58:34  smk
 * 	Initial 1.2 checkin
 * 	[1992/08/27  18:53:56  smk]
 * 
 * Revision 1.1.2.3  91/06/25  17:28:37  boot
 * 	Changes/fixes for 1.1
 * 	[91/06/25  09:35:50  boot]
 * 
 * $EndLog$
 */

/*
 * HISTORY
 * $Log: swap.h,v $
 * Revision 1.1.2.4  1995/05/12  15:39:45  duthie
 * 	Fix some byte swapping problems.
 * 	[1995/01/25  18:22:01  duthie]
 *
 * Revision 1.1.5.2  1995/01/25  18:22:01  duthie
 * 	Fix some byte swapping problems.
 *
 * Revision 1.1.2.3  1994/03/12  00:48:09  chasb
 * 	Expand Copyrights
 * 	[1994/03/09  19:51:34  chasb]
 *
 * Revision 1.1.4.2  1994/03/09  19:51:34  chasb
 * 	Expand Copyrights
 *
 * Revision 1.1.2.2  1993/03/02  15:09:13  smk
 * 	gdb-4.8
 * 	[1993/03/02  15:07:11  smk]
 *
 * Revision 1.1.1.2  1993/03/02  15:07:11  smk
 * 	gdb-4.8
 *
 * Revision 3.0  1993/01/01  04:35:38  ede
 * 	Initial revision for OSF/1 R1.3
 *
 * Revision 1.1.2.2  1992/08/28  15:58:34  smk
 * 	Initial 1.2 checkin
 * 	[1992/08/27  18:53:56  smk]
 *
 * Revision 1.1.1.2  1992/08/27  18:53:56  smk
 * 	Initial 1.2 checkin
 *
 * $EndLog$
 */

