/*
 * This file contains changes from the Open Software Foundation.
 * The RCS history log will appear at the end of this file.
 * @(#)osfrose.h	$Revision: 1.1.2.4 $ $Date: 1994/03/11 23:34:21 $ $Locker:  $
 */

/*
 * COPYRIGHT NOTICE
 * 
 * OSF/1
 */

/* BFD back-end data structures for OSF/Rose (and similar) files.

   We try to encapsulate the differences in a few routines, and otherwise
   share large masses of code.  This means we only have to fix bugs in
   one place, most of the time.  */

/** OSF/Rose files */

#include <stddef.h>
#include <mach_o_header.h>
#include <mach_o_format.h>

#if ARCH_SIZE==64
#define GET_WORD bfd_h_get_64
#define GET_SWORD (int64_type)GET_WORD
#define PUT_WORD bfd_h_put_64
#define NAME(x,y) CAT3(x,_64_,y)
#define JNAME(x) CAT(x,_64)
#define BYTES_IN_WORD 8
#else
#define GET_WORD bfd_h_get_32
#define GET_SWORD (int32_type)GET_WORD
#define PUT_WORD bfd_h_put_32
#define NAME(x,y) CAT3(x,_32_,y)
#define JNAME(x) CAT(x,_32)
#define BYTES_IN_WORD 4
#endif

#define obj_hdr(bfd)      (((struct rosexdata *) ((bfd)->tdata.rose_data))->hdr)
#define obj_cmds(bfd)     (((struct rosexdata *) ((bfd)->tdata.rose_data))->cmds)

#define obj_textsec(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->textsec)
#define obj_rdatasec(bfd) (((struct rosexdata *) ((bfd)->tdata.rose_data))->rdatasec)
#define obj_datasec(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->datasec)
#define obj_sdatasec(bfd) (((struct rosexdata *) ((bfd)->tdata.rose_data))->sdatasec)
#define obj_bsssec(bfd)   (((struct rosexdata *) ((bfd)->tdata.rose_data))->bsssec)
#define obj_sbsssec(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->sbsssec)
#define obj_gluesec(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->gluesec)

#define obj_sym_filepos(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->sym_filepos)
#define obj_sym_size(bfd)     (((struct rosexdata *) ((bfd)->tdata.rose_data))->sym_size)
#define obj_str_filepos(bfd)  (((struct rosexdata *) ((bfd)->tdata.rose_data))->str_filepos)
#define obj_str_size(bfd)     (((struct rosexdata *) ((bfd)->tdata.rose_data))->str_size)


#if 1
typedef struct {
  asymbol symbol;
  short desc;
  char other;
#if 1 /* smk - to make compatible with gdb-4.5/libaout.h */
  unsigned char type;
#endif
} aout_symbol_type;
#endif

#if 0
typedef struct aout_symbol_type;
#endif


struct rosexdata {
  mo_header_t              *hdr;           /* OSF/Rose file header */
  ldc_header_t             *cmds;          /* load commands (including map) */
  
  aout_symbol_type         *symbols; 	   /* symtab for input bfd */

  /* For ease, we do this */

  asection *textsec;
  asection *rdatasec;
  asection *datasec;
  asection *sdatasec;
  asection *bsssec;
  asection *sbsssec;
  asection *gluesec;

  file_ptr       sym_filepos;
  bfd_size_type  sym_size;
  file_ptr       str_filepos;
  bfd_size_type  str_size;
};


#define obj_outsymbols(bfd) ((void *)(((struct rosexdata *) ((bfd)->tdata.rose_data))->outsymbols))



/* We case the address of the first element of a asymbol to ensure that the
 * macro is only every applied to an asymbol
 */
#define aout_symbol(asymbol) ((aout_symbol_type *)(&(asymbol)->the_bfd))

/*#define obj_symbols(bfd) ((((struct rosexdata *) ((bfd)->tdata.rose_data))->symbols))*/
#define obj_aout_symbols(bfd) ((((struct rosexdata *) (bfd)->tdata.rose_data))->symbols)
#define obj_arch_flags(bfd) ((((struct rosexdata *) (bfd)->tdata.rose_data))->arch_flags)

#if 0  /* smk - changes inc. into 4.5 */
#define get_tdata(x)  ((struct rosexdata *)((x)->tdata.rose_data))
#define set_tdata(x,y)  ((struct rosexdata *)((x)->tdata.rose_data))=y
#endif


/* 
 * Because Mach doesn't have a true U-area, we have to play some games.
 */

#include <sys/param.h>
#ifdef multimax
#include <sys/ptrace.h>
typedef struct ptrace_user our_user;
#define DATA_SIZE(X)  (X.pt_dsize)
#define STACK_SIZE(X) (X.pt_ssize)
#define DATAPTR(X) (sizeof(struct ptrace_user) + X.pt_dsize)
#define DATA_START(X) (X.pt_aouthdr.data_start)
#else
#include <sys/user.h>
typedef struct user our_user;
#define DATA_SIZE(X)  (ctob(X.u_dsize))
#define STACK_SIZE(X) (ctob(X.u_ssize))
#define DATAPTR(X) (ctob(UPAGES) + ctob(X.u_dsize))
#define DATA_START(X) (X.u_data_start)
#endif


union {
  our_user U;
  char UU[ctob(UPAGES)];
} udot;

#define u udot.U
enum machine_type {
  M_UNKNOWN = 0,
  M_68010 = 1,
  M_68020 = 2,
  M_SPARC = 3,
  /* skip a bunch so we don't run into any of suns numbers */
  /* make these up for the ns32k*/
  M_NS32032 = (64),		/* ns32032 running ? */
  M_NS32532 = (64 + 5),		/* ns32532 running mach */

  M_386 = 100,
  M_29K = 101,          /* AMD 29000 */
  M_386_DYNIX = 102,	/* Sequent running dynix */
  M_ARM = 103,		/* Advanced Risc Machines ARM */
  M_386_NETBSD = 134,	/* NetBSD/i386 binary */
  M_68K_NETBSD = 135,	/* NetBSD/m68k binary */
  M_532_NETBSD = 137,	/* NetBSD/ns32k binary */
  M_SPARC_NETBSD = 138,	/* NetBSD/sparc binary */
  M_MIPS1 = 151,        /* MIPS R2000/R3000 binary */
  M_MIPS2 = 152,        /* MIPS R4000/R6000 binary */
  M_HP200 = 200,	/* HP 200 (68010) BSD binary */
  M_HP300 = (300 % 256), /* HP 300 (68020+68881) BSD binary */
  M_HPUX = (0x20c % 256)/* HP 200/300 HPUX binary */
};

/*
 * HISTORY
 * $Log: osfrose.h,v $
 * Revision 1.1.2.4  1994/03/11  23:34:21  chasb
 * 	Expand Copyrights
 * 	[1994/03/09  19:52:44  chasb]
 *
 * Revision 1.1.2.3  1993/03/02  15:28:07  smk
 * 	Get rid of OSF_COPYRIGHT
 * 	[1993/03/02  15:27:00  smk]
 * 
 * Revision 1.1.2.2  1993/03/02  14:46:04  smk
 * 	gdb-4.8 upgrade
 * 	[1993/03/02  14:43:52  smk]
 * 
 * Revision 3.0  1993/01/01  06:57:13  ede
 * 	Initial revision for OSF/1 R1.3
 * 
 * Revision 1.1.2.2  1992/08/28  14:39:38  smk
 * 	Initial 1.2 checkin
 * 	[1992/08/27  18:09:25  smk]
 * 
 * Revision 1.4.6.2  1992/01/31  18:39:43  boot
 * 	Change include of mmax_ptrace.h to use the new name (sys/ptrace.h>
 * 	instead.
 * 	[1992/01/31  18:38:41  boot]
 * 
 * Revision 1.4  1991/09/24  09:30:24  devrcs
 * 	Source merge for osc1.1b15
 * 
 * Revision 1.3.1.2  91/08/27  10:26:33  boot
 * 	Accomodate u-area changes, switch to new core format
 * 	[91/08/27  10:22:49  boot]
 * 
 * Revision 1.2.2.2  91/08/07  09:13:11  boot
 * 	Changed <machine/mmax_ptrace.h> to <mmax/mmax_ptrace.h>
 * 	[91/08/07  09:11:55  boot]
 * 
 * Revision 1.2  91/07/09  10:24:23  devrcs
 * 	Changes/fixes for 1.1
 * 	[91/06/25  09:57:21  boot]
 * 
 * $EndLog$
 */

/*
 * HISTORY
 * $Log: osfrose.h,v $
 * Revision 1.1.2.4  1994/03/11  23:34:21  chasb
 * 	Expand Copyrights
 * 	[1994/03/09  19:52:44  chasb]
 *
 * Revision 1.1.4.2  1994/03/09  19:52:44  chasb
 * 	Expand Copyrights
 *
 * Revision 1.1.2.3  1993/03/02  15:28:07  smk
 * 	Get rid of OSF_COPYRIGHT
 * 	[1993/03/02  15:27:00  smk]
 *
 * Revision 1.1.3.2  1993/03/02  15:27:00  smk
 * 	Get rid of OSF_COPYRIGHT
 *
 * Revision 1.1.2.2  1993/03/02  14:46:04  smk
 * 	gdb-4.8 upgrade
 * 	[1993/03/02  14:43:52  smk]
 *
 * Revision 1.1.1.2  1993/03/02  14:43:52  smk
 * 	gdb-4.8 upgrade
 *
 * Revision 3.0  1993/01/01  06:57:13  ede
 * 	Initial revision for OSF/1 R1.3
 *
 * Revision 1.1.2.2  1992/08/28  14:39:38  smk
 * 	Initial 1.2 checkin
 * 	[1992/08/27  18:09:25  smk]
 *
 * Revision 1.1.1.2  1992/08/27  18:09:25  smk
 * 	Initial 1.2 checkin
 *
 * $EndLog$
 */
