/*
 * @OSF_COPYRIGHT@
 * 
 */
/*
 * HISTORY
 * $Log: i386osf-tdep.c,v $
 * Revision 1.1.2.1  1996/03/08  21:58:16  nikolay
 * 	OSF: initial reelase; some code moved
 * 	[1996/03/08  21:58:09  nikolay]
 *
 * $EndLog$
 */
#include <stdio.h>
#include "defs.h"
#include "frame.h"
#include "inferior.h"
#include "gdbcore.h"

#ifdef USG
#include <sys/types.h>
#endif

#include <sys/param.h>
#include <sys/dir.h>
#include <signal.h>
#include <sys/user.h>
#include <sys/ioctl.h>
#include <fcntl.h>

#include <sys/file.h>
#include <sys/stat.h>

#if defined (USE_MACHINE_REG_H)
#include <machine/reg.h>
#else
#include <sys/reg.h>
#endif

#include <mach/thread_status.h>
#include <mach/machine/thread_status.h>
#include "target.h"

struct env387 
{
  unsigned short control;
  unsigned short r0;
  unsigned short status;
  unsigned short r1;
  unsigned short tag;
  unsigned short r2;
  unsigned long eip;
  unsigned short code_seg;
  unsigned short opcode;
  unsigned long operand;
  unsigned short operand_seg;
  unsigned short r3;
  unsigned char regs[8][10];
};



/* this table must line up with REGISTER_NAMES in m-i386.h */
/* symbols like 'EAX' come from <sys/reg.h> */
static int regmap[] = 
{
  EAX, ECX, EDX, EBX,
  UESP, EBP, ESI, EDI,
  EIP, EFL, CS, SS,
  DS, ES, FS, GS,
};

/* blockend is the value of u.u_ar0, and points to the
 * place where GS is stored
 */
i386_register_u_addr (blockend, regnum)
{
#if 0
  /* this will be needed if fp registers are reinstated */
  /* for now, you can look at them with 'info float'
   * sys5 wont let you change them with ptrace anyway
   */
  if (regnum >= FP0_REGNUM && regnum <= FP7_REGNUM) 
    {
      int ubase, fpstate;
      struct user u;
      ubase = blockend + 4 * (SS + 1) - KSTKSZ;
      fpstate = ubase + ((char *)&u.u_fpstate - (char *)&u);
      return (fpstate + 0x1c + 10 * (regnum - FP0_REGNUM));
    } 
  else
#endif
    return (U_REGS_OFFSET + 4 * regmap[regnum]);
  
}

/* This is broken for cross debugging.  Possible solutions are:

1.  Don't worry about whether the thing compiles for cross-debugging.
Go ahead and call them from i386-tdep.c.
1a.  Same thing but use some macros in xm-i386.h so that gdb will
compile for cross-debugging but just give an error (or some such behavior)
when you attempt to convert floats.

2.  Write a portable (in the sense of running on any machine; it would
always be for i387 floating-point formats) extended<->double converter
(which just deals with the values as arrays of char).

3.  Assume the host machine has *some* IEEE chip.  However, IEEE does
not standardize formats for extended floats (387 is 10 bytes, 68881 is
12 bytes), so this won't work.  */

i387_to_double (from, to)
     char *from;
     char *to;
{
  long *lp;
  /* push extended mode on 387 stack, then pop in double mode
   *
   * first, set exception masks so no error is generated -
   * number will be rounded to inf or 0, if necessary 
   */
  asm ("pushl %eax"); 		/* grab a stack slot */
  asm ("fstcw (%esp)");		/* get 387 control word */
  asm ("movl (%esp),%eax");	/* save old value */
  asm ("orl $0x3f,%eax");		/* mask all exceptions */
  asm ("pushl %eax");
  asm ("fldcw (%esp)");		/* load new value into 387 */
  
  asm ("movl 8(%ebp),%eax");
  asm ("fldt (%eax)");		/* push extended number on 387 stack */
  asm ("fwait");
  asm ("movl 12(%ebp),%eax");
  asm ("fstpl (%eax)");		/* pop double */
  asm ("fwait");
  
  asm ("popl %eax");		/* flush modified control word */
  asm ("fnclex");			/* clear exceptions */
  asm ("fldcw (%esp)");		/* restore original control word */
  asm ("popl %eax");		/* flush saved copy */
}

double_to_i387 (from, to)
     char *from;
     char *to;
{
  /* push double mode on 387 stack, then pop in extended mode
   * no errors are possible because every 64-bit pattern
   * can be converted to an extended
   */
  asm ("movl 8(%ebp),%eax");
  asm ("fldl (%eax)");
  asm ("fwait");
  asm ("movl 12(%ebp),%eax");
  asm ("fstpt (%eax)");
  asm ("fwait");
}

static
print_387_control_word (control)
unsigned short control;
{
  printf ("control 0x%04x: ", control);
  printf ("compute to ");
  switch ((control >> 8) & 3) 
    {
    case 0: printf ("24 bits; "); break;
    case 1: printf ("(bad); "); break;
    case 2: printf ("53 bits; "); break;
    case 3: printf ("64 bits; "); break;
    }
  printf ("round ");
  switch ((control >> 10) & 3) 
    {
    case 0: printf ("NEAREST; "); break;
    case 1: printf ("DOWN; "); break;
    case 2: printf ("UP; "); break;
    case 3: printf ("CHOP; "); break;
    }
  if (control & 0x3f) 
    {
      printf ("mask:");
      if (control & 0x0001) printf (" INVALID");
      if (control & 0x0002) printf (" DENORM");
      if (control & 0x0004) printf (" DIVZ");
      if (control & 0x0008) printf (" OVERF");
      if (control & 0x0010) printf (" UNDERF");
      if (control & 0x0020) printf (" LOS");
      printf (";");
    }
  printf ("\n");
  if (control & 0xe080) printf ("warning: reserved bits on 0x%x\n",
				control & 0xe080);
}

static
print_387_status_word (status)
     unsigned short status;
{
  printf ("status 0x%04x: ", status);
  if (status & 0xff) 
    {
      printf ("exceptions:");
      if (status & 0x0001) printf (" INVALID");
      if (status & 0x0002) printf (" DENORM");
      if (status & 0x0004) printf (" DIVZ");
      if (status & 0x0008) printf (" OVERF");
      if (status & 0x0010) printf (" UNDERF");
      if (status & 0x0020) printf (" LOS");
      if (status & 0x0040) printf (" FPSTACK");
      printf ("; ");
    }
  printf ("flags: %d%d%d%d; ",
	  (status & 0x4000) != 0,
	  (status & 0x0400) != 0,
	  (status & 0x0200) != 0,
	  (status & 0x0100) != 0);
  
  printf ("top %d\n", (status >> 11) & 7);
}

static
print_387_status (status, ep)
     unsigned short status;
     struct env387 *ep;
{
  int i;
  int bothstatus;
  int top;
  int fpreg;
  unsigned char *p;
  
  bothstatus = ((status != 0) && (ep->status != 0));
  if (status != 0) 
  {
      if (bothstatus)
	  printf ("u: ");
      print_387_status_word (status);
  }
  
  if (ep->status != 0) 
  {
      if (bothstatus)
	  printf ("e: ");
      print_387_status_word (ep->status);
  }
  
  print_387_control_word (ep->control);
  printf ("last exception: ");
  printf ("opcode 0x%x; ", ep->opcode);
  printf ("pc 0x%x:0x%x; ", ep->code_seg, ep->eip);
  printf ("operand 0x%x:0x%x\n", ep->operand_seg, ep->operand);
  
  top = (ep->status >> 11) & 7;
  
  printf ("stack  regno  tag  msb              lsb  value\n");
  for (fpreg = 0; fpreg <8; fpreg++) 
  {
      double val;
      
      
      printf ("ST(%d)   %d     ", fpreg, top);
      
      switch ((ep->tag >> (top * 2)) & 3) 
      {
	case 0: printf ("valid "); break;
	case 1: printf ("zero  "); break;
	case 2: printf ("trap  "); break;
	case 3: printf ("empty "); break;
      }

      for (i = 9; i >= 0; i--)
	printf ("%02x", ep->regs[fpreg][i]);
      
      i387_to_double (ep->regs[fpreg], (char *)&val);
      printf ("  %g\n", val);


      top = (top + 1) % 8;

    }
  if (ep->r0)
    printf ("warning: reserved0 is 0x%x\n", ep->r0);
  if (ep->r1)
    printf ("warning: reserved1 is 0x%x\n", ep->r1);
  if (ep->r2)
    printf ("warning: reserved2 is 0x%x\n", ep->r2);
  if (ep->r3)
    printf ("warning: reserved3 is 0x%x\n", ep->r3);
}

#define CHECK1(s) if (ret != KERN_SUCCESS) {err = s; goto error_exit1;}

i386_float_info ()
{
    unsigned size;
    sec_ptr reg_sec;
    struct i386_float_state  osf1_i386_float_state;

    if (target_has_execution) {
        error ("Not supported yet!\n");
	return;
    } else {
	reg_sec = bfd_get_section_by_name (core_bfd, ".reg2");
	if (!reg_sec) {
		goto bad;
	}
	size = bfd_section_size (core_bfd, reg_sec);
	if (size != sizeof(struct i386_float_state)) {
		goto bad;
	}
	if (bfd_get_section_contents (core_bfd, reg_sec, &osf1_i386_float_state,
			(file_ptr)0, size))
		print_387_status(&osf1_i386_float_state.exc_status,
			&osf1_i386_float_state.hw_state);
		return;
    }
bad:
    error ("Can't get float info from core file\n");
    return;

}


void
fetch_core_registers (core_reg_sect, core_reg_size, which, reg_addr)
     char    *core_reg_sect;
     unsigned core_reg_size;
     int which;
     unsigned int reg_addr;	/* not used */
{

  struct i386_float_state  *fpuregs;

  fpuregs = (struct i386_float_state *) (core_reg_sect + sizeof(struct i386_thread_state));


  if (which == 0) {
      struct i386_thread_state *gregs;
      gregs   = (struct i386_thread_state *) core_reg_sect;
      *(int *)&registers[REGISTER_BYTE(0)]         = gregs->eax;
      *(int *)&registers[REGISTER_BYTE(1)]         = gregs->ecx;
      *(int *)&registers[REGISTER_BYTE(2)]         = gregs->edx;
      *(int *)&registers[REGISTER_BYTE(3)]         = gregs->ebx;
      *(int *)&registers[REGISTER_BYTE(SP_REGNUM)] = gregs->uesp;
      *(int *)&registers[REGISTER_BYTE(FP_REGNUM)] = gregs->ebp;
      *(int *)&registers[REGISTER_BYTE(6)]         = gregs->esi;
      *(int *)&registers[REGISTER_BYTE(7)]         = gregs->edi;
      *(int *)&registers[REGISTER_BYTE(PC_REGNUM)] = gregs->eip;
      *(int *)&registers[REGISTER_BYTE(PS_REGNUM)] = gregs->efl;
      *(int *)&registers[REGISTER_BYTE(10)]        = gregs->cs;
      *(int *)&registers[REGISTER_BYTE(11)]        = gregs->ss;
      *(int *)&registers[REGISTER_BYTE(12)]        = gregs->ds;
      *(int *)&registers[REGISTER_BYTE(13)]        = gregs->es;
      *(int *)&registers[REGISTER_BYTE(14)]        = gregs->fs;
      *(int *)&registers[REGISTER_BYTE(15)]        = gregs->gs;
  }

#if 0
  bcopy (fpuregs->hw_state,
	 &registers[REGISTER_BYTE (FP0_REGNUM)],
	FP_STATE_BYTES);

  /* Handle special FP regs */
  *(int *)&registers[REGISTER_BYTE (FCRCS_REGNUM)] = fpuregs->fpu_fsr;
  *(int *)&registers[REGISTER_BYTE (FCRIR_REGNUM)] = fpuregs->fpu_fir;
#endif
}

/* Return the address in the core dump or inferior of register REGNO.
   BLOCKEND is the address of the end of the user structure.  */

unsigned int
register_addr (regno, blockend)
     int regno;
     int blockend;
{
  int addr;

  if (regno < 0 || regno >= ARCH_NUM_REGS)
    error ("Invalid register number %d.", regno);

  REGISTER_U_ADDR (addr, blockend, regno);

  return addr;
}

