
/*
 * From cthread_internals.h
 *
 *
 * Private definitions for the C Threads implementation.
 *
 * The cproc structure is used for different implementations
 * of the basic schedulable units that execute cthreads.
 *
 */

extern cthread_t get_cthreads();

struct cthread_dlq_entry {
	struct cthread_dlq_entry	*next;		/* next element */
	struct cthread_dlq_entry	*prev;		/* previous element */
};

/*
 * Low-level thread implementation.
 */
struct cthread {
    struct cthread 	*next;		/* Used to queue cthreads on lists. */
    int			status;		/* The thread's status (see below). */
    cthread_fn_t	func;		/* The thread's initial function. */
    void		*arg;		/* The thread's initial argument. */
    void		*result;	/* Return result from func() */
    const char		*name;		/* The thread's name. */
    void 		*data;		/* Thread data set by set_data(). */
					/* In the server this is used to */
					/* keep track of the cpu number. */
    struct cthread	*joiner;	/* Who are we joining with (from */
					/* cthread_join_real). */
    cthread_context_t	context;	/* Pointer to cthread's context. */
    struct cthread 	*list;		/* List of all cthreads. */
    mutex_t		cond_mutex;	/* Event the thread is waiting for. */
#ifdef	WAIT_DEBUG
	int waiting_for;
#endif	/* WAIT_DEBUG */
    volatile int	state;		/* The current state (see below). */
    volatile int	flags;		/* The thread's flags (see below). */
    volatile boolean_t	undepress;	/* Is the thread's priority */
					/* depressed */
    mach_port_t		wired;		/* is cthread wired to kernel thread */
    int			busy;		/* used with cthread_msg calls */
    mach_port_t		reply_port;	/* for mig_get_reply_port() */
    struct cthread_dlq_entry dlq;
    vm_offset_t		stack_base; 	/* Base of the cthread's stack. */
    vm_size_t		stack_size;	/* Size of the cthread's stack. */
    struct cthread_status_struct *cthread_status;
    volatile int	sleep_count;	/* for waker wakee synchronization */
};

typedef struct cthread_status_struct {
    int version;
    struct cthread_queue cthreads;
    int cthread_cthreads;
    int alloc_cthreads;
    cthread_t cthread_list;	/* list of all cthreads */
    vm_size_t stack_size;	/* size of user stacks */
    vm_offset_t stack_mask;	/* mask to begining */
    int lock_spin_count;	/* how long to spin trying for spin lock w/o
				   thread_switch ing */
    int processors;		/* actual number of processors in PS */
    vm_size_t wait_stack_size;	/* stack size for idle threads */
    int max_kernel_threads;	/* max kernel threads */
    int kernel_threads;		/* current kernel threads */
    int waiter_spin_count;	/* amount of busy spin on idle thread */
    int mutex_spin_count;       /* amount of busy spin in mutex_lock_solid */
    spin_lock_t run_lock;	/* the spin lock for all context switches */
    struct cthread_queue run_queue;/* run queue */
    struct cthread_dlq_entry waiting_dlq;
    struct cthread_queue waiters;/* queue of cthreads to run as idle */
    cthread_t exit_thread;	/* for when T_MAIN exits */
} *cthread_status_t;

#define CPROC_RUNNING	0x1
#define CPROC_RUNNABLE	0x2
#define CPROC_BLOCKED	0x4

/* Not available in OSF cthreads ?? */
/* #define CPROC_SWITCHING */
/* #define CPROC_CONDWAIT */


#define CTHREAD_STATUS_LIST_OFFSET (offsetof(struct cthread_status_struct,  cthread_list))
#define CTHREAD_STATUS_LIST_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)


/* entire size of cthread structure */
#define CPROC_SIZE sizeof(struct cthread)

#define CPROC_BASE_OFFSET (offsetof(struct cthread, stack_base))
#define CPROC_BASE_SIZE (TARGET_INT_BIT / HOST_CHAR_BIT)

#define CPROC_SIZE_OFFSET (offsetof(struct cthread, stack_size))
#define CPROC_SIZE_SIZE (TARGET_INT_BIT / HOST_CHAR_BIT)

/* The cthread list is gotten off the cthread_status structure */
#define CPROC_LIST_OFFSET (offsetof(struct cthread,  list))
#define CPROC_LIST_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)

/* #define CPROC_INCARNATION_OFFSET 0*/
#define CPROC_INCARNATION_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)

#define CPROC_CONTEXT_OFFSET (offsetof(struct cthread, context))
#define CPROC_CONTEXT_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)

#define CPROC_STATE_OFFSET (offsetof(struct cthread, state))
#define CPROC_STATE_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)

#define CPROC_WIRED_OFFSET (offsetof(struct cthread, wired))
#define CPROC_WIRED_SIZE (TARGET_PTR_BIT / HOST_CHAR_BIT)

#define CPROC_IS_CTHREAD 1
