/* Macro definitions for i386, Mach 3.0
   Copyright (C) 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* Include common definitions for Mach3 systems */
#include "nm-m3.h"

/* Define offsets to access CPROC stack when it does not have
 * a kernel thread.
 */
#define MACHINE_CPROC_SP_OFFSET 20
#define MACHINE_CPROC_PC_OFFSET 16
#define MACHINE_CPROC_FP_OFFSET 12

/* Thread flavors used in re-setting the T bit.
 * @@ this is also bad for cross debugging.
 */
#define TRACE_FLAVOR		i386_THREAD_STATE
#define TRACE_FLAVOR_SIZE	i386_THREAD_STATE_COUNT
#define TRACE_SET(x,state) \
  	((struct i386_thread_state *)state)->efl |= 0x100
#define TRACE_CLEAR(x,state) \
  	((((struct i386_thread_state *)state)->efl &= ~0x100), 1)

/* we can do it *removed for ptrace */
/*#define ATTACH_DETACH 1*/
/* added for ptrace */
#define USE_MACHINE_REG_H

/* Define this if the C compiler puts an underscore at the front
   of external names before giving them to the linker.  */

#define NAMES_HAVE_UNDERSCORE

/* Sigh. There should be a file for i386 but no sysv stuff in it */
#include "i386/tm-i386.h"

/* I want to test this float info code. See comment in tm-i386v.h */
#undef FLOAT_INFO
#define FLOAT_INFO { i386_mach3_float_info (); }

/* Address of end of stack space.
 * for MACH, see <machine/vmparam.h>
 * @@@ I don't know what is in the 5 ints...
 */
#undef  STACK_END_ADDR
#define STACK_END_ADDR (0xc0000000-sizeof(int [5]))

#if defined(__linux__)
#define SIGCONTEXT_PC_OFFSET (14 * 4)
#elif defined(__OSF1__)
#define SIGCONTEXT_PC_OFFSET (16 * 4)
#endif

/* Disable the code that attempts to transform Mach exceptions into signals.  */
#define M3_DONT_SIGNAL 1

#define M3_THREAD_STATE_FOR_REGISTER(regno) \
	(((regno) < FP0_REGNUM) ? i386_THREAD_STATE : i386_FLOAT_STATE)
#define M3_THREAD_STATE_OFFSET_FOR_REGISTER(regno) \
	i386_thread_state_offset (regno)
extern int i386_thread_state_offset PARAMS ((int));
#define M3_SUPPLY_THREAD_STATE_REGISTERS(flavor, state) \
	i386_supply_thread_state_registers(flavor, state)
extern void i386_supply_thread_state_registers PARAMS ((thread_state_flavor_t,
							thread_state_t));
#define M3_STORE_ALL_REGISTERS() i386_store_all_registers()
extern void ppc_store_all_registers PARAMS ((void));
#define M3_MAKE_THREAD_STATE(flavor, state) \
	i386_make_thread_state(flavor, state)
extern int i386_make_thread_state PARAMS ((thread_state_flavor_t,
					   thread_state_t));

/* Special case when it's the current thread -- we probably already have
   its state so avoid redundant wasteful thread_get_state() calls.  We
   would like to do just read_register_gen, modify, write_register_gen,
   but the problem is that write_register_gen calls target_prepare_to_store
   which wants *all* register values to be valid, including the floating-point
   registers.  Since we don't usually have those on hand, we'd end up doing
   a futile thread_get_state anyway.  So we excerpt the bits of
   write_register_gen we need.  The correct solution would probably be for
   target_prepare_to_store to take an argument saying which register is about
   to be stored.  */
#define M3_TRACE_CURRENT_THREAD(set) \
	do { \
	  int *msrp = (int *) &registers[REGISTER_BYTE (PS_REGNUM)]; \
	  read_register_gen (PS_REGNUM, (char *) msrp); \
	  if (set) \
	    *msrp |= 0x100; \
	  else \
	    *msrp &= ~0x100; \
	  target_store_registers (PS_REGNUM); \
	} while (0)
