/* Native-dependent definitions for Intel 386 running OSF/1, for GDB.
   Copyright 1986, 1987, 1989, 1992 Free Software Foundation, Inc.

This file is part of GDB.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#ifndef NM_I386OSF_H
#define NM_I386OSF_H

/* This is the amount to subtract from u.u_ar0
   to get the offset in the core file of the register values.  */

#include <machine/vmparam.h>
#define KERNEL_U_ADDR USRSTACK

#undef FLOAT_INFO	/* No float info yet */

#define REGISTER_U_ADDR(addr, blockend, regno) \
	(addr) = i386_register_u_addr ((blockend),(regno));

extern int
i386_register_u_addr PARAMS ((int, int));

#define PTRACE_ARG3_TYPE int

/* use the static shell on OSF/1 */
#define SHELL_FILE "/sbin/sh"
#define USE_DEFAULT_SHELL

/* SHARED LIBRARY support definitions */
#include "solib.h"
#define SVR4_SHARED_LIBS

#define SOLIB_DEBUG_BASE_SYMBOL "_r_debug"
#define USER_SPACE_LOADER "/sbin/rtld"
#define IGNORE_FIRST_LINK_MAP_ENTRY(x) (0)

/* On OSF/1, the ELF sections have been pre-linked to live at a 
   preferred address.  The solib support assumes for SVR4 libraries
   that the sections contain an offset in the addr field */
#define CONVERT_SECTION_ADDR_TO_OFFSET

/* OSF does not currently have a separate .debug sections for
   stabs.  They are just thrown in with the ELF symbols.  This
   will be fixed once they go to the latest binutils (gas and ld).
*/
#define STABS_IN_ELF_SYMS 

/* Use the static shell */
#define SHELL_FILE "/sbin/sh"

#endif /* NM_I386OSF_H */
