/*
 * This file contains changes from the Open Software Foundation.
 * The RCS history log will appear at the end of this file.
 * @(#)osfrose.c	$Revision: 1.1.2.4 $ $Date: 1995/05/12 15:41:24 $ $Locker:  $
 */

/*** bfd backend for OSF/Rose format binaries */

#include <machine/endian.h>
#include <stdio.h>
#include <assert.h>

#include "bfd.h"
#include "libbfd.h"

typedef void generic_symbol_type;
#define BYTES_IN_WORD 4
#include "aout/aout64.h"
#include "aout/stab_gnu.h"
#include "ar.h"

#include "osfrose.h"           /* BFD OSF/Rose internal data structures */
/*#include "../gdb/defs.h"*/

/* #include "a.out.sun4.h" */

#include <mach_o_format.h>
#include <mach_o_header.h>
#include <sys/user.h>
#include <sys/core.h>

#define TARGET_BYTE_ORDER LITTLE_ENDIAN
#define HOST_BYTE_ORDER LITTLE_ENDIAN

#include "swap.h"

#define PROTOX(a,b,c) PROTO(a,b,c)

/** a.out files */

PROTOX (void , rose_write_syms, ());
PROTOX (static boolean,rose_squirt_out_relocs,(bfd *abfd, asection *section));
PROTOX (static symvalue, compute_symbol_value, (symbol_info_t *symp));

PROTOX (static void, swapcore, (our_user *core));
PROTOX (void, rose_swap_symbol, (symbol_info_t **sym));
PROTOX (void, rose_swap_load_command, (ldc_header_t **lc));

static boolean
DEFUN (rose_find_nearest_line,(abfd,
			      section,
			      symbols,
			      offset,
			      filename_ptr,
			      functionname_ptr,
			      line_ptr),
      bfd            *abfd AND
      asection       *section AND
      asymbol       **symbols AND
      bfd_vma         offset AND
      CONST char      **filename_ptr AND
      CONST char       **functionname_ptr AND
      unsigned int   *line_ptr)
{
  fprintf (stderr, "rose_find_nearest_line unimplemented\n");
  fflush (stderr);
  abort ();
  return (false);
}

static int 
DEFUN (rose_sizeof_headers, (abfd, reloc),
      bfd *abfd AND
      boolean reloc)
{
  fprintf (stderr, "rose_sizeof_headers unimplemented\n");
  fflush (stderr);
  abort ();
  return (0);
}


static void 
unimp(s)
     char *s;
{
  fprintf(stderr, "*** Unimplemented routine '%s' has been called\n", s);
}

typedef struct reg_info_struct {
  mo_short_t     reg_type;    /* region usage type */
  char *         reg_name;    /* name for it */
  flagword       reg_flags;   /* applicable flags */
} reg_info_struct;

/*
 * The order of these is the order the regions will
 * normally appear in the output.
 */

static reg_info_struct reg_infos[] =
{
  {REG_TEXT_T,  ".text",   (SEC_HAS_CONTENTS|SEC_LOAD|SEC_ALLOC) },
#ifdef REG_RDATA_T
  {REG_RDATA_T, ".rdata",  (SEC_HAS_CONTENTS|SEC_LOAD|SEC_ALLOC) },
#endif
  {REG_DATA_T,  ".data",   (SEC_HAS_CONTENTS|SEC_LOAD|SEC_ALLOC) },
#ifdef REG_SDATA_T
  {REG_SDATA_T, ".sdata",  (SEC_HAS_CONTENTS|SEC_LOAD|SEC_ALLOC) },
#endif
  {REG_BSS_T,   ".bss",    SEC_ALLOC },                /* allocated, but not loaded from file */
#ifdef REG_SBSS_T
  {REG_SBSS_T,  ".sbss",   SEC_ALLOC },                /* ditto */
#endif
  {REG_GLUE_T,  ".glue",   (SEC_HAS_CONTENTS|SEC_LOAD|SEC_ALLOC) },
  {0,           NULL,      NO_FLAGS }                  /* sentinel (we key off null name field) */
};

reg_info_struct
region_info(rp)
     region_command_t *rp;
{
  int i;

  for (i=0; reg_infos[i].reg_name; i++)
    if (reg_infos[i].reg_type == rp->regc_usage_type)
      return reg_infos[i];
}

#ifndef zalloc
char *
DEFUN(zalloc,(size),
      bfd_size_type size)
{
  char *ptr = (char *) malloc ((int)size);

  if ((ptr != NULL) && (size != 0))
   memset(ptr,0, size);

  return ptr;
}
#endif

const bfd_target *
rose_object_p (abfd)
     bfd *abfd;
{
  mo_header_t mo_header;
  void *rawptr;
  char *comical_header, *cp; 
  ldc_header_t     **ldc_map;            /* load command map */
  ldc_header_t      *h;
  int i;
  sec_ptr secp;

  /*bfd_set_error (bfd_error_no_error);*/
  bfd_set_error (bfd_error_wrong_format);

  rawptr = zalloc(MO_SIZEOF_RAW_HDR);

  if (bfd_read (rawptr, 1, MO_SIZEOF_RAW_HDR, abfd) != MO_SIZEOF_RAW_HDR)
    return 0;

  if (decode_mach_o_hdr (rawptr,
			 MO_SIZEOF_RAW_HDR ,
			 MOH_HEADER_VERSION,
			 &mo_header) != 0)
    return 0;

  /* Check for byte-order mismatches */
  if (mo_header.moh_byte_order == BO_MSB && /* big endian header, little endian vec */
      (bfd_big_endian (abfd))) {
    bfd_set_error (bfd_error_wrong_format);
    return 0;
  } else if (mo_header.moh_byte_order == BO_LSB && /* little endian header, big endian vec */
	     bfd_big_endian (abfd)) {
    bfd_set_error (bfd_error_wrong_format);
    return 0;
  }

  rawptr = (void *) zalloc(sizeof(struct rosexdata) + sizeof(mo_header_t));
  if (rawptr == NULL) {
    bfd_set_error (bfd_error_no_memory);
    return 0;
  }
 
  abfd->tdata.rose_data = (void *) ( (struct rosexdata *) rawptr); /* smk */
  obj_hdr (abfd) =
    (mo_header_t *) ((char *) rawptr + sizeof(struct rosexdata));

  memcpy(obj_hdr(abfd), &mo_header, sizeof(mo_header_t));

  /* Set the file flags */
  abfd->flags = NO_FLAGS;

  /*
   * These flags are pretty tricky, and I may well have gotten this
   * wrong...
   */

  if (mo_header.moh_flags & (MOH_RELOCATABLE_F | MOH_LINKABLE_F))
    abfd->flags |= HAS_RELOC;
  if (mo_header.moh_flags & (MOH_EXECUTABLE_F | MOH_EXECABLE_F))
    abfd->flags |= EXEC_P;
  if (mo_header.moh_flags & MOH_UNRESOLVED_F &&
      mo_header.moh_flags & (MOH_EXECUTABLE_F | MOH_EXECABLE_F))
    abfd->flags |= DYNAMIC;

  
  /* Determine the architecture and machine type of the object file.  */
#if 0   /* smk */
  abfd->obj_arch = bfd_arch_unknown;	/* Default values */
  abfd->obj_machine = 0;

  switch (mo_header.moh_cpu_type) {
    
  case M_UNKNOWN:
    break;
    
  case MO_CPU_TYPE_MIPS:
    abfd->obj_arch = bfd_arch_mips;
    break;

#if 0
  case MO_CPU_TYPE_NS32000:
    abfd->obj_arch = bfd_arch_ns32k;
    break;
#endif

  case MO_CPU_TYPE_I386:
    abfd->obj_arch = bfd_arch_i386;
    break;

  case MO_CPU_TYPE_M68000:
    abfd->obj_arch = bfd_arch_m68k;
    break;

  default:
	abfd->obj_arch = bfd_arch_obscure;
	break;
  }
#endif

  obj_aout_symbols (abfd) = (aout_symbol_type *) NULL;

  /* Allocate space for load commands & map, read commands */

  obj_cmds(abfd) = (ldc_header_t *)  zalloc (mo_header.moh_sizeofcmds);
  
  if (obj_cmds(abfd) == NULL) {
    bfd_set_error (bfd_error_no_memory);
    return 0;
  }

  ldc_map = 
    (ldc_header_t **) zalloc(mo_header.moh_n_load_cmds * sizeof(*ldc_map));

  if (ldc_map == NULL) {
     bfd_set_error (bfd_error_no_memory);
    return 0;
  }
  if (bfd_seek (abfd, (long) mo_header.moh_first_cmd_off, false) < 0) return 0;
  if (bfd_read ((char *) obj_cmds(abfd), 1,  mo_header.moh_sizeofcmds, abfd)
      !=  mo_header.moh_sizeofcmds) {
    bfd_set_error (bfd_error_wrong_format);
    return 0;
  }

  /* Loop over load commands, filling in map */   

  cp = (char *) obj_cmds(abfd);
  for (i = 0; i < mo_header.moh_n_load_cmds; i++) {
    h = (ldc_header_t *)cp;
    rose_swap_load_command(&h);
    ldc_map[i] = h;
    cp += h->ldci_cmd_size;
  }

  /* Loop over map, dealing with all the load commands */
  for (i = 0; i < mo_header.moh_n_load_cmds; i++) {
    h = ldc_map[i];
    switch (h->ldci_cmd_type) {
    case LDC_REGION:
      {

	region_command_t *regp = (region_command_t *) h;
	reg_info_struct ri;

	ri = region_info(regp);
	secp = bfd_make_section_old_way(abfd, ri.reg_name);
	secp->filepos = h->ldci_section_off;  /* offset of section in file */
	secp->_raw_size = regp->regc_vm_size; /* length (in bytes) of it */
	secp->flags   = ri.reg_flags;
	secp->vma     = (bfd_vma) regp->regc_vm_addr; /* flags for section */

	/* If region has relocation, deal with it */
	if (regp->regc_reloc_addr != MO_INVALID_LCID) {
	  secp->rel_filepos = ldc_map[regp->regc_reloc_addr]->ldci_section_off;
	  secp->flags |= SEC_RELOC;
	};

	/* If section can be byte-aligned, so indicate */
	if (regp->regc_addralign == 1)
	  secp->flags |= SEC_BALIGN;

	switch (regp->regc_usage_type) {
	case REG_TEXT_T:
	  if (regp->regc_initprot & MO_PROT_WRITE)
	    abfd->flags |= (WP_TEXT | D_PAGED);
	  obj_textsec(abfd) = secp;
	  break;
	case REG_DATA_T:
	  obj_datasec(abfd) = secp;
	  break;
#ifdef REG_RDATA_T
	case REG_RDATA_T:
	  obj_rdatasec(abfd) = secp;
	  break;
#endif
#ifdef REG_SDATA_T
	case REG_SDATA_T:  /* "small" data (not currently supported) */
	  obj_sdatasec(abfd) = secp;
	  break;
#endif
	case REG_BSS_T:
	  obj_bsssec(abfd) = secp;
	  break;
#ifdef REG_SBSS_T
	case REG_SBSS_T:   /* "small" bss (not currently supported) */
	  obj_sbsssec(abfd) = secp;
	  break;
#endif
	case REG_GLUE_T:   /* part of OSF shared library format */
	default:
	  /* nothing special to do */
	  break;
	}
      }
    case LDC_ENTRY:
      {
	entry_command_t *e = (entry_command_t *) h;
	if (e->entc_flags & ENT_VALID_ABSADDR_F) {
	  bfd_get_start_address (abfd) = (bfd_vma) e->entc_absaddr;
	}
	break;
      }
    case LDC_STRINGS:
      obj_str_filepos (abfd) = (file_ptr) h->ldci_section_off;
      obj_str_size(abfd)     = h->ldci_section_len;
      break;
    case LDC_RELOC:
      {
	reloc_command_t *r = (reloc_command_t *) h;
	if (r->relc_nentries != 0)
	  abfd->flags |= HAS_RELOC; /* relocation entries exist */
	break;
      }
    case LDC_SYMBOLS:
      { 
	/* FIXME assumes symbol sections contiguous */
	symbols_command_t *s = (symbols_command_t *) h;
	switch (s->symc_kind) {
	case SYMC_DEFINED_SYMBOLS: /* assume locals */
	  obj_sym_size(abfd) += (s->symc_nentries * sizeof(symbol_info_t));
	  bfd_get_symcount (abfd) = obj_sym_size(abfd)/sizeof(symbol_info_t);

	  if (h->ldci_section_len > 0) {
	    abfd->flags |= (HAS_SYMS | HAS_LOCALS);
	    if (obj_sym_filepos(abfd) == 0 ||
		obj_sym_filepos(abfd) > (file_ptr) h->ldci_section_off)
	      obj_sym_filepos(abfd) =  (file_ptr) h->ldci_section_off;
	  }
	  break;
	case SYMC_STABS: /* assume line numbers, debugging, and locals */
	  obj_sym_size(abfd) += (s->symc_nentries * sizeof(symbol_info_t));
	  bfd_get_symcount (abfd) = obj_sym_size(abfd)/sizeof(symbol_info_t);
	  if (h->ldci_section_len > 0) {
	    abfd->flags |= (HAS_LINENO | HAS_DEBUG | HAS_SYMS | HAS_LOCALS);
	    if (obj_sym_filepos(abfd) == 0 ||
		obj_sym_filepos(abfd) > (file_ptr) h->ldci_section_off)
	      obj_sym_filepos(abfd) =  (file_ptr) h->ldci_section_off;
	  }
	  break;

	  /*
	   * We don't treat imports as symbols, we get them from the 
	   * shared object which exports the symbol. When exported,
	   * the symbol is contained in the defined symbol section. 
	   */
	   
	case SYMC_IMPORTS:
	  if (h->ldci_section_len > 0) {
	    abfd->flags |= DYNAMIC; /* yes? */
	  }
	  break;
	default:
	  break; /* should never happen? */
	}
      }
      break;
    default:
      /* We don't do anything for these load commands */
      break;
    }
  }
  return abfd->xvec;
}


boolean
rose_mkobject (abfd)
     bfd *abfd;
{
  char *rawptr;

  bfd_set_error (bfd_error_no_error);

  /* Use an intermediate variable for clarity */
  rawptr =  zalloc (sizeof (struct rosexdata) + sizeof (mo_header_t));

  if (rawptr == NULL) {
    bfd_set_error (bfd_error_no_memory);
    return false;
  }

  abfd->tdata.rose_data = (struct rosexdata *) rawptr;
  obj_hdr (abfd) = (mo_header_t *) ((char *)rawptr + sizeof(mo_header_t));
  return true;
}

/* Keep track of machine architecture and machine type for a.out's.
   Return the machine_type for a particular arch&machine, or M_UNKNOWN
   if that exact arch&machine can't be represented in a.out format.

   If the architecture is understood, machine type 0 (default) should
   always be understood.  */

static enum machine_type
aout_machine_type (arch, machine)
     enum bfd_architecture arch;
     unsigned long machine;
{
  enum machine_type arch_flags;

  arch_flags = M_UNKNOWN;

  switch (arch) {
  case bfd_arch_sparc:
    if (machine == 0)	arch_flags = M_SPARC;
    break;

  case bfd_arch_m68k:
    switch (machine) {
    case 0:			arch_flags = M_UNKNOWN; break;
    case 68000:		arch_flags = M_UNKNOWN;	break;
    case 68010:		arch_flags = M_68010; break;
    case 68020:		arch_flags = M_68020; break;
    default:		arch_flags = M_UNKNOWN; break;
    }
    break;
    
  case bfd_arch_i386:
    if (machine == 0)	arch_flags = M_386;
    break;

  case bfd_arch_a29k:
    if (machine == 0)	arch_flags = M_29K;
    break;
    
#if 0
  case bfd_arch_ns32k:
    if (machine == 0)	arch_flags = M_32K;
    break;

  case bfd_arch_mips:
    if (machine == 0)	arch_flags = M_MIPS;
    break;
#endif
	
  default:
	arch_flags = M_UNKNOWN;
	break;
  }
  return arch_flags;
}

boolean
rose_set_arch_mach (abfd, arch, machine)
     bfd *abfd;
     enum bfd_architecture arch;
     unsigned long machine;
{
#if 0  /* smk - these fields removed from structure */
  abfd->obj_arch = arch;
  abfd->obj_machine = machine;
#endif
  if (arch != bfd_arch_unknown &&
      aout_machine_type (arch, machine) == M_UNKNOWN)
    return false;		/* We can't represent this type */
  return true;			/* We're easy ... */
}

static void
rose_init_header(abfd)
     bfd        *abfd;
{
  obj_hdr(abfd)->moh_magic            = MOH_MAGIC;
  obj_hdr(abfd)->moh_major_version    = MOH_MAJOR_VERSION;
  obj_hdr(abfd)->moh_minor_version    = MOH_MINOR_VERSION;
  obj_hdr(abfd)->moh_header_version   = MOH_HEADER_VERSION;
  obj_hdr(abfd)->moh_max_page_size    = getpagesize();
  obj_hdr(abfd)->moh_byte_order       = OUR_BYTE_ORDER;
  obj_hdr(abfd)->moh_data_rep_id      = OUR_DATA_REP_ID;
  obj_hdr(abfd)->moh_cpu_type         = OUR_CPU_TYPE;
  obj_hdr(abfd)->moh_cpu_subtype      = OUR_CPU_SUBTYPE;
  obj_hdr(abfd)->moh_vendor_type      = OUR_VENDOR_TYPE;
  obj_hdr(abfd)->moh_load_map_cmd_off = MO_SIZEOF_RAW_HDR;
  obj_hdr(abfd)->moh_first_cmd_off    = MO_SIZEOF_RAW_HDR;
  obj_hdr(abfd)->moh_reserved[0]      = 0;
  obj_hdr(abfd)->moh_reserved[1]      = 0;

  obj_hdr(abfd)->moh_flags = NO_FLAGS;
  if (abfd->flags & DYNAMIC)
    obj_hdr(abfd)->moh_flags |=
      (MOH_EXECABLE_F | MOH_EXECUTABLE_F | MOH_UNRESOLVED_F);

  if (abfd->flags & HAS_RELOC)
    obj_hdr(abfd)->moh_flags |= (MOH_UNRESOLVED_F | MOH_LINKABLE_F);

  if (abfd->flags & EXEC_P) {
    obj_hdr(abfd)->moh_flags |= (MOH_EXECABLE_F | MOH_EXECUTABLE_F);
    obj_hdr(abfd)->moh_flags &= ~(MOH_LINKABLE_F);
  }
  /* On output, we always put the map first, and the other load
     commands in the order they were seen on input */
  obj_hdr(abfd)->moh_load_map_cmd_off = 0;
  obj_hdr(abfd)->moh_first_cmd_off    = 0;
  obj_hdr(abfd)->moh_n_load_cmds = bfd_count_sections(abfd);
}

boolean
rose_write_object_contents (abfd)
     bfd *abfd;
{
  void *comical_header;
  
  /*
   * This header stuff is a crock!
   */
  rose_init_header(abfd);
  comical_header = zalloc(MO_SIZEOF_RAW_HDR);
#if 0 /* 05.30.96 * ?? */
  if (encode_mach_o_hdr(obj_hdr(abfd), comical_header, MO_SIZEOF_RAW_HDR) !=
      MO_HDR_CONV_SUCCESS)
    return false;
#endif
  bfd_seek(abfd, 0L, false);
  bfd_write(comical_header, 1, MO_SIZEOF_RAW_HDR, abfd);

}

/* need this cast b/c ptr is really void * */
#define core_hdr(bfd) (((struct cordata *) (bfd->tdata.rose_data))->core_header)
#define core_secs(bfd) (((struct cordata *) (bfd->tdata.rose_data))->core_sections)
struct cordata {
  struct core_hdr core_header;     /* core file header */
  asection        *core_sections;
};


/*
 * This implements support for the new (OSF/1.1 core file format).
 * It is incompatible with the OSF/1.0 core file format.
 * See sys/core.h for more particulars.
 */
 
const bfd_target *
rose_core_file_p (abfd)
     bfd *abfd;
{
#if defined (MACH) || !defined (__i386__) /* incompatible with osfosf1core.c */
  int   core_size;
  void *rawptr;
  asection *cur_sec, *prev_sec, *first_sec;
  struct core_hdr hdr;
  struct core_region_desc *regions, *regp;
  struct thread_info *threads, *threadp;
  int nregions, nthreads, nsections;
  char *sec_name;
  long int filepos;

  bfd_set_error (bfd_error_no_error);
  cur_sec = prev_sec = first_sec = NULL;
  rawptr = NULL;
  threads = (struct thread_info *) NULL;
  regions = (struct core_region_desc *) NULL;
  nsections = 0;

  if (bfd_seek (abfd, 0L, false) < 0) return 0;

  if (bfd_read(&hdr, 1, sizeof(struct core_hdr), abfd) != sizeof(struct core_hdr)) {
    /* file too small to be a valid core file */
    bfd_set_error (bfd_error_wrong_format);
    return 0;
  }

  if (hdr.c_magic != CORE_MAGIC) {
    /* Either not a core file, or old core file format */
    bfd_set_error (bfd_error_wrong_format);
    return 0;
  }

  if (bfd_big_endian (abfd)) {
    /* wrong byte order */
    bfd_set_error (bfd_error_wrong_format);
    return 0;
    }


  /* allocate all the strucures in one chunk so they can be deallocated
     via a single free */

  rawptr = zalloc(sizeof(struct core_hdr) + 
		  (hdr.c_nregions * sizeof(struct core_region_desc)) +
		  (hdr.c_nthreads * sizeof(struct thread_info)));
		  
  if (rawptr == NULL) {
    bfd_set_error (bfd_error_no_memory);
    return 0;
  }

  regions = (struct core_region_desc *) (rawptr + sizeof(struct core_hdr));

  threads = (struct thread_info *) (rawptr + sizeof(struct core_hdr) +
    (hdr.c_nregions * sizeof(struct core_region_desc)));


  if (bfd_read(regions, hdr.c_nregions, sizeof(struct core_region_desc), abfd) !=
      hdr.c_nregions * sizeof(struct core_region_desc)) {
    bfd_set_error (bfd_error_wrong_format);
    goto deallocate;
  }

  if (bfd_read(threads, hdr.c_nthreads, sizeof(struct thread_info), abfd) !=
      hdr.c_nthreads * sizeof(struct thread_info)) {
    bfd_set_error (bfd_error_wrong_format);
    goto deallocate;
  }
    
  /*
   * Create the sections 
   */

  for (regp = regions, nregions = hdr.c_nregions;
       nregions > 0;
       regp++, nregions--) {

    switch (regp->r_prot) {
    default:
      /* The kernel doesn't dump things with the execute bit turned on */
      /* FIXME - this should probably be an error */
      continue;
    case VM_PROT_READ | VM_PROT_WRITE:
    case VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE:
      /* this could also be the stack, no easy way to tell... */
      sec_name = ".data";
      break;
    }

    cur_sec = (asection *) zalloc(sizeof(asection));
    if (!cur_sec) goto deallocate;

    if (! first_sec)
      first_sec = cur_sec;

    /* Fill in some section attributes */

    cur_sec->name            = sec_name;
#if 0 /* smk */
    cur_sec->size            = regp->r_size;
#else
    cur_sec->_raw_size       = regp->r_size;
#endif
    cur_sec->vma             = (bfd_vma) regp->r_vaddr;
    cur_sec->filepos         = regp->r_offset;
#if 0 /* smk */
    cur_sec->flags           = SEC_ALLOC + SEC_LOAD;
#else
    cur_sec->flags           = SEC_HAS_CONTENTS + SEC_ALLOC + SEC_LOAD;
#endif
    cur_sec->alignment_power = 2;
    /* Chain sections together (in order) */
    if (prev_sec)
      prev_sec->next = cur_sec;
    cur_sec->next = NULL;
    prev_sec = cur_sec;
    nsections++;
  }

  for (nthreads = hdr.c_nthreads, threadp = threads, filepos = hdr.c_firstthread;
       nthreads > 0;
       nthreads--, threadp++, filepos += sizeof(struct thread_info)) {
    
    cur_sec = (asection *) zalloc(sizeof(asection));

    if (! cur_sec) {
      bfd_set_error (bfd_error_no_memory);
      goto deallocate;
    }

    if (! first_sec)
      first_sec = cur_sec;

    cur_sec->name    = ".thread";
    cur_sec->flags   = SEC_ALLOC;
#if 0
    cur_sec->size    = sizeof(struct thread_info);
#else
    cur_sec->_raw_size = sizeof(struct thread_info);
#endif
    cur_sec->vma     = 0;
    cur_sec->filepos = filepos;

    /* Chain sections together (in order) */
    if (prev_sec)
      prev_sec->next = cur_sec;
    cur_sec->next = NULL;
    prev_sec = cur_sec;
    nsections++;
  }

  abfd->tdata.rose_data = rawptr;
  core_hdr(abfd) = hdr;
  core_secs(abfd) = first_sec;
	
  abfd->sections = first_sec;
  abfd->section_count = nsections;
  return abfd->xvec;

deallocate:
    /* free up all allocated memory and report failure */
    if (rawptr)
      free(rawptr);

    for (cur_sec = abfd->sections;
	 cur_sec; 
	 cur_sec = cur_sec->next)
      free (cur_sec);
#endif /* 0 */
    return 0;
}

char *
rose_core_file_failing_command (abfd)
     bfd *abfd;
{
  return core_hdr(abfd).c_cmdname;
}

int
rose_core_file_failing_signal (abfd)
     bfd *abfd;
{
  return core_hdr(abfd).c_signo;
}

boolean
rose_core_file_matches_executable_p  (core_bfd, exec_bfd)
     bfd *core_bfd, *exec_bfd;
{

  if (core_bfd->xvec != exec_bfd->xvec) {
    bfd_set_error (bfd_error_no_error);
    return false;
  }

  /* FIXME: we need to fix this for new core file format */
  return true;
}


boolean
rose_new_section_hook (abfd, newsect)
     bfd *abfd;
     asection *newsect;
{
  /* nothing to do! */
  return true;
}

boolean
rose_set_section_contents (abfd, section, location, offset, count)
     bfd *abfd;
     sec_ptr section;
     unsigned char *location;
     file_ptr offset;
      int count;
{
  bfd_seek(abfd, section->filepos + offset, false);
  if (count)
    return (bfd_write((void *) location, 1, count, abfd) == count) ? true : false;
}

/* Classify stabs symbols */


#define sym_in_text_section(sym) \
     (((sym)->si_sc_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_TEXT)

#define sym_in_data_section(sym) \
     (((sym)->si_sc_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_DATA)

#define sym_in_bss_section(sym) \
     (((sym)->si_sc_type  & (N_ABS | N_TEXT | N_DATA | N_BSS))== N_BSS)

/* Symbol is undefined if type is N_UNDF|N_EXT and if it has
   zero in the "value" field.  Nonzeroes there are fortrancommon
   symbols.  */
#define sym_is_undefined(sym) \
        ((sym)->si_sc_type == (N_UNDF | N_EXT) && compute_symbol_value(sym) == 0)

/* Symbol is a global definition if N_EXT is on and if it has
   a nonzero type field.  */
#define sym_is_global_defn(sym) \
        (((sym)->si_sc_type & N_EXT) && (sym)->si_sc_type & N_TYPE)

/* Symbol is debugger info if any bits outside N_TYPE or N_EXT
   are on.  */
#define sym_is_debugger_info(sym) \
        ((sym)->si_sc_type & ~(N_EXT | N_TYPE))

#define sym_is_fortrancommon(sym)       \
        (((sym)->si_sc_type == (N_EXT)) && compute_symbol_value(sym) != 0)


/* Symbol is absolute if it has N_ABS set */
#define sym_is_absolute(sym) \
	       (((sym)->si_sc_type  & N_ABS)== N_ABS)


#define sym_is_indirect(sym) \
	       (((sym)->si_sc_type  & N_ABS)== N_ABS)

/* Only in their own functions for ease of debugging; when sym flags have
   stabilised these should be inlined into their (single) caller */

static void
translate_from_native_sym_flags (sym_pointer, cache_ptr, abfd)
     symbol_info_t    *sym_pointer; /* native format */
     aout_symbol_type *cache_ptr;   /* "generic" format */
     bfd *abfd;
{

  if (sym_is_debugger_info (sym_pointer)) {
    cache_ptr->symbol.flags = BSF_DEBUGGING | (sym_pointer->si_sc_type << 8);
    /* Work out the section correct for this symbol */
    switch (sym_pointer->si_sc_type) 
      {
      case N_FNAME:		/* procedure name (f77 kludge): name,,0 */
      case N_FUN:		/* procedure: name,,0,linenumber,address */  
      case N_SLINE:		/* src line: 0,,0,linenumber,address */
      case N_SO:		/* source file name: name,,0,0,address */
      case N_SOL:		/* #included file name: name,,0,0,address */

	cache_ptr->symbol.section = obj_textsec (abfd);
	break;
      case N_STSYM:		/* static symbol: name,,0,type,address */  
	cache_ptr->symbol.section = obj_datasec (abfd);
	break;
      case N_LCSYM:		/* .lcomm symbol: name,,0,type,address */  
	cache_ptr->symbol.section = obj_bsssec (abfd);
	break;
      case N_GSYM:		/* global symbol: name,,0,type,0 */
      case N_LSYM:		/* local sym: name,,0,type,offset */
      case N_LBRAC:		/* left bracket: 0,,0,nesting level,address */
      case N_RBRAC:		/* right bracket: 0,,0,nesting level,address */
      case N_RSYM:		/* register sym: name,,0,type,register */
      case N_PSYM:		/* parameter: name,,0,type,offset */
      case N_BINCL:		/* header file: name,,0,0,0 */
      case N_EINCL:		/* end of include file */
      case N_EXCL:		/* excluded include file */
	/* ??? The following two are ignored for the moment */
      case 0xc4:                /* MIPS-only register mask */
      case 0xd4:                /* MIPS-only virtual frame pointer */
	cache_ptr->symbol.section = 0;

	break;
      case N_MAIN :		/* name of main routine : name,,0,0,0 */

      case N_SSYM:		/* structure elt: name,,0,type,struct_offset */
      case N_ENTRY:		/* alternate entry: name,linenumber,address */

      case N_BCOMM:		/* begin common: name,, */
      case N_ECOMM:		/* end common: name,, */
      case N_ECOML:		/* end common (local name): ,,address */
      case N_LENG:		/* second stab entry with length information */
      case N_PC:		/* global pascal symbol:name,,0,subtype,line */
      case N_M2C:		/* compilation unit stab */
      default:
	printf("Unrecognized stab type %x\n", sym_pointer->si_sc_type);
	cache_ptr->symbol.section = 0;
	break;
      }
  }
  else {
#if 0 /* 05.30.96 * Obsolete */
    if (sym_is_fortrancommon (sym_pointer))
      {
	cache_ptr->symbol.flags = BSF_FORT_COMM_OBS;
	cache_ptr->symbol.section = (asection *)NULL;
      }
    else {
      if (sym_is_undefined (sym_pointer)) {
	cache_ptr->symbol.flags = BSF_UNDEFINED_OBS;
      }
      else 
#endif /* 0 */
	{
	if (sym_is_global_defn (sym_pointer)) {
	cache_ptr->symbol.flags = BSF_GLOBAL | BSF_EXPORT;
      }
#if 0 /* 05.30.96 * Obsolete */
      else if (sym_is_absolute (sym_pointer)) {
	cache_ptr->symbol.flags = BSF_ABSOLUTE;
      }
#endif
      else {
	cache_ptr->symbol.flags = BSF_LOCAL;
      }

      /* In a.out, the value of a symbol is always relative to the 
       * start of the file, if this is a data symbol we'll subtract
       * the size of the text section to get the section relative
       * value. If this is a bss symbol (which would be strange)
       * we'll subtract the size of the previous two sections
       * to find the section relative address.
       */

      if (sym_in_text_section (sym_pointer))   {
	cache_ptr->symbol.section = obj_textsec (abfd);
      }
      else if (sym_in_data_section (sym_pointer)){
	cache_ptr->symbol.section = obj_datasec (abfd);
      }
      else if (sym_in_bss_section(sym_pointer)) {
	cache_ptr->symbol.section = obj_bsssec (abfd);
      }
      else {
#if 0 /* 05.30.96 * Obsolete */
	cache_ptr->symbol.section = (asection *)NULL;
	cache_ptr->symbol.flags |= BSF_ABSOLUTE;
#endif
      }
    }
  }
}

static void
translate_to_native_sym_flags (sym_pointer, cache_ptr_g, abfd)
     symbol_info_t *sym_pointer;
     generic_symbol_type *cache_ptr_g;
     bfd *abfd;
{
  asymbol *cache_ptr = (asymbol *)cache_ptr_g;

/* FIXME check for wrigin bss */
  if (bfd_get_section(cache_ptr)) {
    if (bfd_get_output_section(cache_ptr) == obj_bsssec (abfd)) {
      sym_pointer->si_sc_type |= N_BSS;
    }
    else if (bfd_get_output_section(cache_ptr) == obj_datasec (abfd)) {
      sym_pointer->si_sc_type |= N_DATA;
    }
    else  if (bfd_get_output_section(cache_ptr) == obj_textsec (abfd)) {
      sym_pointer->si_sc_type |= N_TEXT;
    }
    else {
      BFD_ASSERT(0);
    }
#if 0
   sym_pointer->n_value +=
     cache_ptr->section->output_section->vma +cache_ptr->section->output_offset + cache_ptr->section->vma;
#endif
  }
  else {
    sym_pointer->si_sc_type |= N_ABS;
  }

#if 0 /* 05.30.96 * Obsolete */
  if (cache_ptr->flags & (BSF_FORT_COMM_OBS | BSF_UNDEFINED_OBS)) {
    sym_pointer->si_sc_type = (N_UNDF | N_EXT);
    return;
  }

  if (cache_ptr->flags & BSF_ABSOLUTE) {
    sym_pointer->si_sc_type |= N_ABS;
  }
#endif
  if (cache_ptr->flags & (BSF_GLOBAL | BSF_EXPORT)) {
    sym_pointer->si_sc_type |= N_EXT;
  }
  if (cache_ptr->flags & BSF_DEBUGGING) {
    sym_pointer->si_sc_type = ( cache_ptr->flags >> 8) & 0xff;
  }
  
}

/* Native-level interface to symbols. */

/* We read the symbols into a buffer, which is discarded when this
   function exits.  We read the strings into a buffer large enough to
   hold them all plus all the cached symbol entries. */

asymbol *
rose_make_empty_symbol (abfd)
bfd *abfd;
{
  aout_symbol_type  *new =
    (aout_symbol_type *)zalloc (sizeof (aout_symbol_type));
  new->symbol.the_bfd = abfd;

  return &new->symbol;
}

#define si_common_size si_abs_val /* should be added to mach_o_format.h someday... */

static symvalue
compute_symbol_value(symp)
symbol_info_t *symp;
{

  mo_short_t flags = symp->si_flags;

  /*
   * In OSF/Rose, translating the value is a little bit
   * tricky. If the symbol has certain flags set, the value is
   * absolute. Otherwise, it has an offset within a load command,
   * but no absolute value yet...
   */

  flags &= ~(SI_LOCAL_F | SI_EXPORT_F | SI_IMPORT_F); /* We don't care about these */
  flags &= ~(SI_CODE_F | SI_DATA_F);                  /* or these... */

  switch (flags) {
  case SI_ABSOLUTE_VALUE_F:
    return (symvalue) symp->si_abs_val;     /* absolute value */
  case SI_LITERAL_F:
    return (symvalue) symp->si_lit_val;     /* literal */
  case SI_COMMON_F:
  case SI_COMMON_F | SI_ABSOLUTE_VALUE_F:   /* this is STUPID - fixme */
    return (symvalue) symp->si_common_size; /* common */
  default:
     /* This is a def_val, so return the offset */
    return (symvalue) symp->si_def_val.adr_sctoff;
  }
}  

boolean
rose_slurp_symbol_table (abfd)
     bfd *abfd;
{
  unsigned int symbol_count;
  size_t symbol_size;
  symbol_info_t *syms;
  char *strings;
  aout_symbol_type *cached;

  /* If there's no work to be done, don't do any */
  if (obj_aout_symbols(abfd) != (aout_symbol_type *) NULL) return true;

  symbol_size = obj_sym_size(abfd);
  if (symbol_size == 0) {
    bfd_set_error (bfd_error_no_symbols);
    return false;
  }

  symbol_count = symbol_size / sizeof (symbol_info_t);


  /* Malloc (should alloca) space for native symbols, and
     malloc space for string table and symbol cache. */

  syms = (symbol_info_t *) zalloc (symbol_size);
  if (syms == NULL) {
    bfd_set_error (bfd_error_no_memory);
    return false;
  }

  cached = (aout_symbol_type *) zalloc (obj_str_size(abfd) + 1 +
                               (symbol_count * sizeof (aout_symbol_type))); 
  if (cached == NULL) {
    bfd_set_error (bfd_error_no_memory);
    free ((void *)syms);
    return false;
  }

  strings = ((char *) cached) + (symbol_count * sizeof (aout_symbol_type));

  /* Read defined symbol section */

  bfd_seek (abfd, obj_sym_filepos (abfd), false);
  if (bfd_read ((void *)syms, 1, obj_sym_size(abfd), abfd) !=
      obj_sym_size(abfd)) {
  bailout:
    free ((void *)cached);
    free ((void*)syms);
    return false;
  }

  bfd_seek (abfd, obj_str_filepos (abfd), false);
  if (bfd_read ((void *)strings, 1, obj_str_size(abfd), abfd) !=
      obj_str_size(abfd)) {
    goto bailout;
  }

  /* OK, now walk the new symtable, cacheing symbol properties */
  {
    symbol_info_t *sym_pointer;
    symbol_info_t *sym_end = syms + symbol_count;
    aout_symbol_type *cache_ptr = cached;


    /* Run through table and copy values */
    for (sym_pointer = syms, cache_ptr = cached;
	 sym_pointer < sym_end; sym_pointer++, cache_ptr++) 
      {
	cache_ptr->symbol.the_bfd = abfd;
	if (sym_pointer->si_symbol_nameP)
	  cache_ptr->symbol.name = strings + (int) sym_pointer->si_symbol_nameP;
	else
	  cache_ptr->symbol.name = (char *)NULL;
	cache_ptr->symbol.value  = compute_symbol_value(sym_pointer);
	cache_ptr->desc          = sym_pointer->si_type;
	cache_ptr->other         = 0; /* ??? Not used */
	cache_ptr->symbol.udata.p = 0;
	translate_from_native_sym_flags (sym_pointer, cache_ptr, abfd);

      }
  }

  obj_aout_symbols (abfd) =  cached;
  bfd_get_symcount (abfd) = symbol_count;
  free ((void *)syms);

  return true;
}



void
rose_write_syms (abfd)
     bfd *abfd;
{
  unimp("rose_write_syms");
}


void
rose_reclaim_symbol_table (abfd)
     bfd *abfd;
{
  asection *section;

  if (!bfd_get_symcount (abfd)) return;

  for (section = abfd->sections; section != NULL; section = section->next)
    if (section->relocation) {
      free ((void *)section->relocation);
      section->relocation = NULL;
      section->reloc_count = 0;
    }

  bfd_get_symcount (abfd) = 0;
  free ((void *)obj_aout_symbols (abfd));
  obj_aout_symbols (abfd) = (aout_symbol_type *)NULL;
}

/*unsigned int*/ long
rose_get_symtab_upper_bound (abfd)
     bfd *abfd;
{
  if (!rose_slurp_symbol_table (abfd)) return 0;

  return (bfd_get_symcount (abfd)+1) * (sizeof (aout_symbol_type *));
}

/*unsigned int*/ long
rose_get_symtab (abfd, location)
     bfd *abfd;
     asymbol **location;
{
  unsigned int counter = 0;
  aout_symbol_type *symbase;

  if (!rose_slurp_symbol_table (abfd)) return 0;

  for (symbase = obj_aout_symbols(abfd); counter++ < bfd_get_symcount (abfd);)
    *(location++) = (asymbol *)( symbase++);
  *location++ =0;
  return bfd_get_symcount(abfd);
}


/* Obsolete procedural interface; better to look at the cache directly */

/* User should have checked the file flags; perhaps we should return
   BFD_NO_MORE_SYMBOLS if there are none? */

int
rose_get_symcount_upper_bound (abfd)
     bfd *abfd;
{
  /* In case we're doing an output file or something...?  */
  if (bfd_get_symcount (abfd)) return bfd_get_symcount (abfd);

  return obj_sym_size(abfd) / sizeof (symbol_info_t);
}

symindex
rose_get_first_symbol (ignore_abfd)
     bfd * ignore_abfd;
{
  return 0;
}

symindex
rose_get_next_symbol (abfd, oidx)
     bfd *abfd;
     symindex oidx;
{
  if (oidx == BFD_NO_MORE_SYMBOLS) return BFD_NO_MORE_SYMBOLS;
  return ++oidx >= bfd_get_symcount (abfd) ? BFD_NO_MORE_SYMBOLS : oidx;
}

const char *
rose_symbol_name (abfd, idx)
     bfd *abfd;
     symindex idx;
{
  return (obj_aout_symbols (abfd) + idx)->symbol.name;
}

long
rose_symbol_value (abfd, idx)
     bfd *abfd;
     symindex idx;
{
  aout_symbol_type *sym = obj_aout_symbols (abfd) + idx;
  return (sym)->symbol.value;
  /*return (obj_aout_symbols (abfd) + idx)->symbol.value;*/
}

typedef enum bfd_symclass {
	      bfd_symclass_unknown = 0,
	      bfd_symclass_fcommon, /* fortran common symbols */
	      bfd_symclass_global, /* global symbol, what a surprise */
	      bfd_symclass_debugger, /* some debugger symbol */
	      bfd_symclass_undefined /* none known */
	    } symclass;

symclass
rose_classify_symbol (abfd, idx)
     bfd *abfd;
     symindex idx;
{
  aout_symbol_type *sym = obj_aout_symbols (abfd) + idx;
#if 0 /* 05.30.96 * Obsolete */
  if ((sym->symbol.flags & BSF_FORT_COMM_OBS) != 0)   return bfd_symclass_fcommon;
  if ((sym->symbol.flags & BSF_UNDEFINED_OBS) != 0) return bfd_symclass_undefined;
#endif
  if ((sym->symbol.flags & BSF_GLOBAL) != 0)    return bfd_symclass_global;
  if ((sym->symbol.flags & BSF_DEBUGGING) != 0)  return bfd_symclass_debugger;
  return bfd_symclass_unknown;
}

boolean
rose_symbol_hasclass (abfd, idx, class)
     bfd *abfd;
     symindex idx;
     symclass class;
{
  aout_symbol_type *sym = obj_aout_symbols (abfd) + idx;
  switch (class) {
#if 0 /* 05.30.96 * Obsolete */
  case bfd_symclass_fcommon:
    return (sym->symbol.flags & BSF_FORT_COMM_OBS) ? true :false;
  case bfd_symclass_global:
    return (sym->symbol.flags & BSF_GLOBAL) ? true:false;
  case bfd_symclass_debugger:
    return (sym->symbol.flags & BSF_DEBUGGING) ? true:false;;
  case bfd_symclass_undefined:
    return (sym->symbol.flags & BSF_UNDEFINED_OBS) ? true:false;;
#endif
  default: return false;
  }
}

/** Some reloc hackery */

static  reloc_howto_type howto_table[] = 
{
  /* type                   rs   size bsz  pcrel bitpos ovrf sf name*/
{ (unsigned int) RELOC_8,      0,  0,  	8,  false, 0,   true,0,"8"},
{ (unsigned int) RELOC_16,     0,  1, 	16, false, 0,   true,0,"16"},
{ (unsigned int) RELOC_32,     0,  2, 	32, false, 0,   true,0,"32"},
{ (unsigned int) RELOC_DISP8,  0,  0, 	8,  true,  0,   true,0,"DISP8"},
{ (unsigned int) RELOC_DISP16, 0,  1, 	16, true,  0,   true,0,"DISP16"},
{ (unsigned int) RELOC_DISP32, 0,  2, 	32, true,  0,   true,0,"DISP32"},
{ (unsigned int) RELOC_WDISP30,2,  2, 	30, true,  0,   true,0,"WDISP30"},
{ (unsigned int) RELOC_WDISP22,2,  2, 	22, true,  0,   true,0,"WDISP22"},
{ (unsigned int) RELOC_HI22,   10, 2, 	22, false, 0,   true,0,"HI22"},
{ (unsigned int) RELOC_22,      0, 2, 	22, false, 0,   true,0,"22"},
{ (unsigned int) RELOC_13, 	0, 2, 	13, false, 0,   true,0,"13"},
{ (unsigned int) RELOC_LO10, 	0, 2, 	10, false, 0,   true,0,"LO10"},
{ (unsigned int) RELOC_SFA_BASE,0, 2, 	32, false, 0,   true,0,"SFA_BASE"},
{ (unsigned int) RELOC_SFA_OFF13,0,2, 	32, false, 0,   true,0,"SFA_OFF13"},
{ (unsigned int) RELOC_BASE10, 0,  2, 	16, false, 0,   true,0,"BASE10"},
{ (unsigned int) RELOC_BASE13, 0,  2,	0,  false, 0,   true,0,"BASE13"},
{ (unsigned int) RELOC_BASE22, 0,  2,	0,  false, 0,   true,0,"BASE22"},
{ (unsigned int) RELOC_PC10,   0,  2,	0,  false, 0,   true,0,"PC10"},
{ (unsigned int) RELOC_PC22,   0,  2,	0,  false, 0,   true,0,"PC22"},
{ (unsigned int) RELOC_JMP_TBL,0,  2,	0,  false, 0,   true,0,"JMP_TBL"},
{ (unsigned int) RELOC_SEGOFF16,0, 2,	0,  false, 0,   true,0,"SEGOFF16"},
{ (unsigned int) RELOC_GLOB_DAT,0, 2,	0,  false, 0,   true,0,"GLOB_DAT"},
{ (unsigned int) RELOC_JMP_SLOT,0, 2,	0,  false, 0,   true,0,"JMP_SLOT"},
{ (unsigned int) RELOC_RELATIVE,0, 2,	0,  false, 0,   true,0,"RELATIVE"},
{ (unsigned int) RELOC_JUMPTARG,2, 13,	16, true,  0,   true,0,"JUMPTARG"},
{ (unsigned int) RELOC_CONST,	0, 13,	16, false, 0,   true,0,"CONST"},
{ (unsigned int) RELOC_CONSTH, 16, 13,	16, false, 0,   true,0,"CONSTH"},
};

boolean
rose_slurp_reloc_table (abfd, asect, symbols)
     bfd *abfd;
     sec_ptr asect;
     asymbol **symbols;
{
  unsigned int count;
  size_t reloc_size;
  struct reloc_info_extended *relocs;
  arelent *reloc_cache;

  if (asect->relocation) return true;

#if 0
  if (asect == obj_datasec (abfd)) {
    reloc_size = obj_hdr(abfd)->a_drsize;
    goto doit;
  }

  if (asect == obj_textsec (abfd)) {
    reloc_size = obj_hdr(abfd)->a_trsize;
    goto doit;
  }
#endif

  bfd_set_error (bfd_error_invalid_operation);
  return false;

#if 0
 doit:
  bfd_seek (abfd, asect->rel_filepos, false);
  count = reloc_size / sizeof (struct reloc_info_extended);

  relocs = (struct reloc_info_extended *) malloc (reloc_size);
  if (!relocs) {
    bfd_set_error (bfd_error_no_memory);
    return false;
  }
  reloc_cache = (arelent *) zalloc ((size_t)(count * sizeof (arelent)));
  if (reloc_cache == (arelent *)NULL) {
    free ((void *)relocs);
    bfd_set_error (bfd_error_no_memory);
    return false;
  }

  if (bfd_read ((void*) relocs, 1, reloc_size, abfd) != reloc_size) {
    bfd_set_error (bfd_error_no_error);
    free (reloc_cache);
    free (relocs);
    return false;
  }

  {
    register struct reloc_info_extended *rptr = relocs;
    unsigned int counter = 0;
    arelent *cache_ptr = reloc_cache;

    for (; counter < count; counter++, rptr++, cache_ptr++) {
      /* john's old swap_reloc was a hell of a lot hairier... */
      /* FIXME, it needs to be!!! */
      swapinlong  (rptr->r_address);
      swapinlong  (rptr->r_index);
      swapinlong  (rptr->r_addend);
      if (rptr->r_extern) {
	/* If this bit is set then the r_index is a index into the symbol table
	 * if the bit is not set then r_index contains a section map.
	 * We either fill in the sym entry with a pointer to the symbol,
	 * or point to the correct section
	 */
	
	cache_ptr->sym_ptr_ptr = symbols + rptr->r_index;
	cache_ptr->addend =  rptr->r_addend;
	cache_ptr->section = (asection *)NULL;
      }
      else 
	{
	  /* Remember that in a.out symbols are relative to the
	 beginning of the file rather than sections ? (look in
	 translate_from_native_sym_flags) The reloc entry addend
	 has added to it the offset into the  file of the data, so
	 subtract the base to make the reloc section relative */

	  cache_ptr->sym_ptr_ptr = (asymbol **)NULL;
	  switch (rptr->r_index) {
	  case N_TEXT:
	  case N_TEXT | N_EXT:
	    cache_ptr->section = obj_textsec(abfd);
	    cache_ptr->addend = rptr->r_addend -  obj_textsec(abfd)->vma  ;
	    break;
	  case N_DATA:
	  case N_DATA | N_EXT:
	    cache_ptr->section = obj_datasec(abfd);
	    cache_ptr->addend = rptr->r_addend -  obj_datasec(abfd)->vma  ;
	    break;
	  case N_BSS:
	  case N_BSS | N_EXT:
	    cache_ptr->section = obj_bsssec(abfd);
	    cache_ptr->addend = rptr->r_addend - obj_bsssec(abfd)->vma;
	    break;
	  case N_ABS:
	  case N_ABS | N_EXT:
	    BFD_ASSERT(1);
	    break;
	  default:
	    BFD_ASSERT(1);
	    break;
	  }
	
	}

      cache_ptr->address = rptr->r_address;
      cache_ptr->howto =  howto_table + (unsigned int)( rptr->r_type);
    }
  }

  free (relocs);
  asect->relocation = reloc_cache;
  asect->reloc_count = count;
  return true;
#endif
}

/*
 * The following enum and struct were borrowed from
 * sunOS  /usr/include/sun4/a.out.h  and extended to handle
 * other machines.  It is currently used on SPARC and AMD 29000.
 */

struct reloc_info_extended
{
  unsigned long r_address;
  unsigned int  r_index:24;
# define	r_symbolnum  r_index
  unsigned	r_extern:1;
  unsigned	:2;
  enum reloc_type r_type:5;
  long int	r_addend;
};
static boolean
rose_squirt_out_relocs (abfd, section)
     bfd *abfd;
     asection *section;
{
  arelent **generic;

  unsigned int count = section->reloc_count;
  struct reloc_info_extended *native, *natptr;
  size_t natsize = count * sizeof (struct reloc_info_extended);

  if (count == 0) return true;
  generic   = section->orelocation;
  native = ((struct reloc_info_extended *) zalloc (natsize));
  if (!native) {
    bfd_set_error (bfd_error_no_memory);
    return false;
  }

  for (natptr = native; count != 0; --count, ++natptr, ++generic) 
    {
      arelent *g = *generic;

      natptr->r_address = g->address;
      /* Find a type in the output format which matches the input howto - 
       * at the moment we assume input format == output format FIXME!!
       */
      natptr->r_type = (enum reloc_type) g->howto->type;
      /* name clobbered by sunos4_write_syms to be symbol index*/

      if (g->sym_ptr_ptr != (asymbol **)NULL) 
	{
	  if ((*(g->sym_ptr_ptr))->section) {
	    /* replace the section offset into the addent */
	    g->addend += (*(g->sym_ptr_ptr))->section->vma;
	  }

	  natptr->r_index = stoi((*(g->sym_ptr_ptr))->name);
	  natptr->r_extern = 1;
	  natptr->r_addend = g->addend;
	}
      else {
	natptr->r_extern = 0;
	if (g->section == (asection *)NULL) {
	  BFD_ASSERT(0);
	  natptr->r_index = N_ABS | N_EXT;
	  natptr->r_addend = g->addend;
	}
	else  if(g->section == obj_textsec(abfd)) {
	  natptr->r_index = N_TEXT | N_EXT;
	  natptr->r_addend = g->addend + obj_textsec(abfd)->vma;
	}
	else if (g->section == obj_datasec(abfd)) {
	  natptr->r_index = N_DATA | N_EXT;
	  natptr->r_addend = g->addend + obj_datasec(abfd)->vma;
	}
	else if (g->section == obj_bsssec(abfd)) {
	  natptr->r_index = N_BSS | N_EXT ;
	  natptr->r_addend = g->addend + obj_bsssec(abfd)->vma;

	}
	else {
	  BFD_ASSERT(0);
	}
      }
  
#if 0
      /* john's old swap_reloc was a hell of a lot hairier... and needed to be! */
      swapoutlong  (natptr->r_address);
      swapoutlong  (natptr->r_index);
      swapoutlong  (natptr->r_addend);
#endif
    }

  if ( bfd_write ((void *) native, 1, natsize, abfd) != natsize) {
    free(native);
    return false;
  }
  free (native);

  return true;
}

/* This is stupid.  This function should be a boolean predicate */
/*unsigned int*/ long
rose_canonicalize_reloc (abfd, section, relptr, symbols)
     bfd *abfd;
     sec_ptr section;
     arelent **relptr;
     asymbol **symbols;
{
  arelent *tblptr = section->relocation;
  unsigned int count;

 if (!(tblptr || rose_slurp_reloc_table (abfd, section, symbols))) return 0;
  tblptr = section->relocation;
 if (!tblptr) return 0;

  for (count = 0; count++ < section->reloc_count;) 
    {
    *relptr++ = tblptr++;
  }

  *relptr = 0;

  return section->reloc_count;
}

/*unsigned int*/ long
rose_get_reloc_upper_bound (abfd, asect)
     bfd *abfd;
     sec_ptr asect;
{
  if (bfd_get_format (abfd) != bfd_object) {
    bfd_set_error (bfd_error_invalid_operation);
    return 0;
  }

#if 0
  if (asect == obj_datasec (abfd))
    return (sizeof (arelent *) *
            ((obj_hdr(abfd)->a_drsize / sizeof (struct reloc_info_extended))
             +1));

  if (asect == obj_textsec (abfd))
    return (sizeof (arelent *) *
            ((obj_hdr(abfd)->a_trsize / sizeof (struct reloc_info_extended))
             +1));
#endif

  bfd_set_error (bfd_error_invalid_operation);
  return 0;
}

void
rose_reclaim_reloc (ignore_abfd, section)
     bfd *ignore_abfd;
     sec_ptr section;
{
  if (section->relocation) {
    free (section->relocation);
    section->relocation = NULL;
    section->reloc_count = 0;
    }
}


alent *
rose_get_lineno(ignore_abfd, ignore_symbol)
bfd *ignore_abfd;
generic_symbol_type *ignore_symbol;
{
return (alent *)NULL;
}

#ifdef __OSF1__ /* brought along from the 3.94 bfd.h */
 typedef enum 
 { 
   bfd_print_symbol_name_enum,
   bfd_print_symbol_type_enum,
   bfd_print_symbol_all_enum,
 }  bfd_print_symbol_enum_type;
#endif
void 
rose_print_symbol(ignore_abfd, file,  symbol, how)
bfd *ignore_abfd;
FILE *file;
asymbol *symbol;
bfd_print_symbol_enum_type how;
{
  switch (how) {
  case bfd_print_symbol_name_enum:
    fprintf(file,"%s", symbol->name);
    break;
  case bfd_print_symbol_type_enum:
    fprintf(file,"%4x %2x",aout_symbol(symbol)->desc & 0xffff,
	    aout_symbol(symbol)->other  & 0xff);
    break;
  case bfd_print_symbol_all_enum:
    {
      const char *section_name = symbol->section == (asection *)NULL ?
	"*abs" : symbol->section->name;

      bfd_print_symbol_vandf(file,symbol);

      fprintf(file," %-5s %04x %02x %s",
	      section_name,
	      aout_symbol(symbol)->desc & 0xffff,
	      aout_symbol(symbol)->other  & 0xff,
	      symbol->name);
    }
    break;
  }
}
/* Once we know all the stuff that could be consed, we know how to clean
   it up.  So why don't we? */

boolean
rose_close_and_cleanup (abfd)
     bfd *abfd;
{
  if (!bfd_read_p (abfd))
    switch (abfd->format) {
    case bfd_archive:
      if (!_bfd_write_archive_contents (abfd)) return false; break;
    case bfd_object:
      if (!rose_write_object_contents (abfd))  return false; break;
    default: bfd_set_error (bfd_error_invalid_operation); return false;
    }

#if 0  /* smk - remove for now - fix later */

#define cleaner(ptr) if (abfd->ptr) free (abfd->ptr)
  cleaner (tdata);

  if (abfd->my_archive)
    cleaner (filename);
#endif

#undef cleaner
  return true;
}


/* Archives are generic or unimplemented.  */
#define rose_slurp_armap			bfd_false
#define rose_slurp_extended_name_table	_bfd_slurp_extended_name_table
#define rose_truncate_arname		bfd_dont_truncate_arname
#define rose_openr_next_archived_file	bfd_generic_openr_next_archived_file
#define rose_generic_stat_arch_elt	bfd_generic_stat_arch_elt
#define	rose_write_armap			(PROTO (boolean, (*),		\
     (bfd *arch, unsigned int elength, struct orl *map, unsigned int orl_count,	\
      int stridx))) bfd_false

/* Ordinary section reading and writing */
#define	rose_get_section_contents	_bfd_generic_get_section_contents

#define rose_bfd_debug_info_start	bfd_void
#define rose_bfd_debug_info_end		bfd_void
#define rose_bfd_debug_info_accumulate	(PROTO(void,(*),(bfd*, struct sec *))) bfd_void
#define rose_bfd_get_relocated_section_contents \
 bfd_generic_get_relocated_section_contents
#define rose_bfd_relax_section bfd_generic_relax_section

#if 1 /* smk - needed for 4.8 sources */
#define rose_bfd_seclet_link bfd_generic_seclet_link
#endif

#if 1 /* 05.30.96 */
#define rose_bfd_free_cached_info _bfd_generic_bfd_free_cached_info
#define rose_bfd_copy_private_bfd_data bfd_empty_bfd_copy_private_bfd_data
#define rose_bfd_merge_private_bfd_data bfd_empty_bfd_copy_private_bfd_data
#define rose_bfd_copy_private_section_data bfd_empty_copy_private_section_data
#define rose_bfd_copy_private_symbol_data bfd_empty_copy_private_symbol_data
#define rose_bfd_set_private_flags bfd_empty_bfd_set_private_flags
#define rose_construct_extended_name_table bfd_empty_bfd_construct_extended_name_table
#define rose_update_armap_timestamp bfd_empty_bfd_update_armap_timestamp
#define rose_get_symbol_info bfd_empty_bfd_get_symbol_info
#define rose_bfd_is_local_label bfd_empty_bfd_is_local_label
#define rose_bfd_make_debug_symbol bfd_empty_bfd_make_debug_symbol
#define rose_read_minisymbols bfd_empty_read_minisymbols
#define rose_minisymbol_to_symbol bfd_empty_minisymbol_to_symbol
#define rose_bfd_reloc_type_lookup bfd_empty_reloc_type_lookup
#define rose_bfd_link_hash_table_create bfd_empty_bfd_link_hash_table_create
#define rose_bfd_link_add_symbols bfd_empty_bfd_link_add_symbols
#define rose_bfd_final_link bfd_empty_bfd_final_link
#define rose_bfd_link_split_section bfd_empty_bfd_link_split_section
#define rose_get_dynamic_symtab_upper_bound bfd_empty_bfd_get_dynamic_symtab_upper_bound
#define rose_canonicalize_dynamic_symtab bfd_empty_bfd_canonicalize_dynamic_symtab
#define rose_get_dynamic_reloc_upper_bound bfd_empty_bfd_get_dynamic_reloc_upper_bound
#define rose_canonicalize_dynamic_reloc bfd_empty_bfd_canonicalize_dynamic_reloc

/* added for gdb-4.16 */
#define	rose_get_section_contents_in_window _bfd_generic_get_section_contents_in_window
#define rose_bfd_print_private_bfd_data _bfd_generic_bfd_print_private_bfd_data
#define rose_read_ar_hdr _bfd_generic_read_ar_hdr
#define rose_get_elt_at_index _bfd_generic_get_elt_at_index

boolean bfd_empty_bfd_copy_private_bfd_data (bfd *in, bfd *out){ return true;}
boolean bfd_empty_copy_private_section_data(bfd *ibfd, asection *isec, bfd *obfd, asection *osec){  return true;}
boolean bfd_empty_copy_private_symbol_data(bfd *ibfd, asymbol *isym, bfd *obfd, asymbol *osym){  return true;}
boolean bfd_empty_bfd_set_private_flags(bfd *abfd, flagword flags){ return true;}
boolean bfd_empty_bfd_construct_extended_name_table (bfd *p1, char **p2, bfd_size_type *p3, const char **p4){  return true;}
boolean  bfd_empty_bfd_update_armap_timestamp (bfd *p1){  return true;}
void bfd_empty_bfd_get_symbol_info (bfd *p1, struct symbol_cache_entry *p2, symbol_info *p3){}
boolean	bfd_empty_bfd_is_local_label (bfd *p1, asymbol *p2) {return true;}
asymbol * bfd_empty_bfd_make_debug_symbol (bfd *abfd, void *ptr, unsigned long size) {return (asymbol *)0;}
long bfd_empty_read_minisymbols (bfd *p1, boolean p2, PTR *p3, unsigned int *p4) {return 0;}
asymbol *bfd_empty_minisymbol_to_symbol (bfd *p1, boolean p2, const PTR p3, asymbol *p4) {return (asymbol *)0;}
reloc_howto_type *bfd_empty_reloc_type_lookup (bfd *abfd, bfd_reloc_code_real_type code)  {return (reloc_howto_type *)0;}
struct bfd_link_hash_table *bfd_empty_bfd_link_hash_table_create (bfd *p1) {return (struct bfd_link_hash_table *)0;}
boolean bfd_empty_bfd_link_add_symbols (bfd *p1, struct bfd_link_info *p2) {  return true;}
boolean bfd_empty_bfd_final_link (bfd *p1, struct bfd_link_info *p2) {  return true;}
boolean bfd_empty_bfd_link_split_section (bfd *p1, struct sec *p2) {  return true;}
long bfd_empty_bfd_get_dynamic_symtab_upper_bound (bfd *p1) {return 0;}
long  bfd_empty_bfd_canonicalize_dynamic_symtab (bfd *p1, struct symbol_cache_entry **p2){return 0;}
long bfd_empty_bfd_get_dynamic_reloc_upper_bound (bfd *p1) {return 0;}
long  bfd_empty_bfd_canonicalize_dynamic_reloc (bfd *p1, arelent **p2, struct symbol_cache_entry **p3) {return 0;}

#endif

bfd_target rose_little_vec =
    {"OSF/Rose-little",                           /* name */
#if 0
       bfd_target_aout_flavour,                   /* sorta like a.out */
#else
       bfd_target_rose_flavour,                   /* sorta like a.out */
#endif
       BFD_ENDIAN_LITTLE,                         /* data byte order is big */
       BFD_ENDIAN_LITTLE,                         /* header byte order is big */
       (HAS_RELOC | EXEC_P |                      /* object flags */
	HAS_LINENO | HAS_DEBUG |
	HAS_SYMS | HAS_LOCALS | DYNAMIC | WP_TEXT | D_PAGED),
       (SEC_ALLOC | SEC_HAS_CONTENTS|SEC_LOAD | SEC_RELOC),        /* section flags */
      '_',				          /* leading underscore */
      '/',				          /* ar_pad_char */
      15,				          /* ar_max_namelen */
      /*2, *removed in gdb-4.16*/                 /* minimum alignment power */
     bfd_getl64, bfd_getl_signed_64, bfd_putl64,  bfd_getl32, bfd_getl_signed_32,
     bfd_putl32, bfd_getl16, bfd_getl_signed_16, bfd_putl16,          /* data */
     bfd_getl64, bfd_getl_signed_64, bfd_putl64,  bfd_getl32, bfd_getl_signed_32,
     bfd_putl32, bfd_getl16, bfd_getl_signed_16, bfd_putl16,   /* hdrs - try little ? */
#if 1
      {_bfd_dummy_target, rose_object_p,	     /* bfd_check_format */
          bfd_generic_archive_p, rose_core_file_p},
      {bfd_false, rose_mkobject,           /* bfd_set_format */
          _bfd_generic_mkarchive, bfd_false},
      {bfd_false, rose_write_object_contents,	/* bfd_write_contents */
       _bfd_write_archive_contents, bfd_false},
#else
      rose_object_p,	     /* bfd_check_format */
      rose_mkobject,           /* bfd_set_format */
      rose_write_object_contents,	/* bfd_write_contents */
#endif
       BFD_JUMP_TABLE_GENERIC(rose),
       BFD_JUMP_TABLE_COPY(rose),
       BFD_JUMP_TABLE_CORE(rose),
       BFD_JUMP_TABLE_ARCHIVE(rose),
       BFD_JUMP_TABLE_SYMBOLS(rose),
       BFD_JUMP_TABLE_RELOCS(rose),
       BFD_JUMP_TABLE_WRITE(rose),
       BFD_JUMP_TABLE_LINK(rose),
       BFD_JUMP_TABLE_DYNAMIC(rose),
};

bfd_target rose_big_vec =
    {"OSF/Rose-big",                              /* name */
       bfd_target_aout_flavour,                   /* sorta like a.out */
       BFD_ENDIAN_BIG,                            /* data byte order is big */
       BFD_ENDIAN_BIG,                            /* header byte order is big */
       (HAS_RELOC | EXEC_P |                      /* object flags */
	HAS_LINENO | HAS_DEBUG |
	HAS_SYMS | HAS_LOCALS | DYNAMIC | WP_TEXT | D_PAGED),
	                                          /* section flags */
       (SEC_ALLOC | SEC_HAS_CONTENTS|SEC_LOAD | SEC_RELOC), 
      '_',				          /* leading underscore */
      '/',				          /* ar_pad_char */
      15,				          /* ar_max_namelen */
      /*2,* removed in gdb-4.16*/                 /* minimum alignment power */
     bfd_getl64, bfd_getl_signed_64, bfd_putl64,  bfd_getl32, bfd_getl_signed_32,
     bfd_putl32, bfd_getl16, bfd_getl_signed_16, bfd_putl16,          /* data */
     bfd_getb64, bfd_getb_signed_64, bfd_putb64,  bfd_getb32,bfd_getb_signed_32, 
     bfd_putb32, bfd_getb16, bfd_getb_signed_16, bfd_putb16,          /* hdrs */
#if 1
      {_bfd_dummy_target, rose_object_p,	     /* bfd_check_format */
          bfd_generic_archive_p, rose_core_file_p},
      {bfd_false, rose_mkobject,           /* bfd_set_format */
          _bfd_generic_mkarchive, bfd_false},
      {bfd_false, rose_write_object_contents,	/* bfd_write_contents */
       _bfd_write_archive_contents, bfd_false},
#else
      rose_object_p,	     /* bfd_check_format */
      rose_mkobject,           /* bfd_set_format */
      rose_write_object_contents,	/* bfd_write_contents */
#endif
#if 0 /* 05.30.96 */
      JUMP_TABLE(rose),
#else
       BFD_JUMP_TABLE_GENERIC(rose),
       BFD_JUMP_TABLE_COPY(rose),
       BFD_JUMP_TABLE_CORE(rose),
       BFD_JUMP_TABLE_ARCHIVE(rose),
       BFD_JUMP_TABLE_SYMBOLS(rose),
       BFD_JUMP_TABLE_RELOCS(rose),
       BFD_JUMP_TABLE_WRITE(rose),
       BFD_JUMP_TABLE_LINK(rose),
       BFD_JUMP_TABLE_DYNAMIC(rose),
#endif
};


static void
swapcore(core)
our_user *core;
{
  /* FIXME: do nothing for now... */
  ;
}

void
rose_swap_symbol(symbol_info_t **sym)
{
    symbol_info_t *symp = *sym;
 
    swapinlong(symp->si_name.symbol_name);
    swapinshort(symp->si_package_index);
    swapinshort(symp->si_type);
    swapinshort(symp->si_flags);
    swapinlong(symp->si_value.def_val.adr_lcid);
    swapinlong(symp->si_value.def_val.adr_sctoff);
}

void
rose_swap_load_command(ldc_header_t **lc)
{

    ldc_header_t *lcmd = *lc;

    /* first the header */
    swapinlong(lcmd->ldci_cmd_type);
    swapinlong(lcmd->ldci_cmd_size);
    swapinlong(lcmd->ldci_section_off);
    swapinlong(lcmd->ldci_section_len);

    switch (lcmd->ldci_cmd_type) {
    
        case LDC_CMD_MAP:
	  {
	      int i;
	      load_cmd_map_command_t *p = (load_cmd_map_command_t *)lcmd;

	      swapinlong(p->lcm_ld_cmd_strings);
	      swapinlong(p->lcm_nentries);
	      for (i=0; i<p->lcm_nentries; i++) {
		  swapinlong(p->lcm_map[i]);
	      }
	      break;
	  }
        case LDC_REGION:
	  {
	      region_command_t *p = (region_command_t *)lcmd;
	      
	      swapinlong(p->regc_region_name.adr_lcid);
	      swapinlong(p->regc_region_name.adr_sctoff);

	      swapinlong(p->regc_addr.vm_addr);
	      swapinlong(p->regc_vm_size);
	      swapinlong(p->regc_flags);
	      swapinlong(p->regc_reloc_addr);
	      swapinlong(p->regc_addralign);
	      swapinshort(p->regc_usage_type);
	      swapinshort(p->regc_initprot);
	      break;
	  }
        case LDC_ENTRY:
	  {
	      entry_command_t *p = (entry_command_t *)lcmd;

	      swapinshort(p->entc_flags);
	      swapinshort(p->entc_short_reserved);
	      swapinlong(p->entc_absaddr);
	      swapinlong(p->entc_entry_pt.adr_lcid);
	      swapinlong(p->entc_entry_pt.adr_sctoff);
	      break;
	  }
        case LDC_STRINGS:
	  {
	      strings_command_t *p = (strings_command_t *)lcmd;

	      swapinlong(p->strc_flags);
	      break;
	  }
        case LDC_RELOC:
	  {
	      reloc_command_t *p = (reloc_command_t *)lcmd;
 
	      swapinlong(p->relc_nentries);
	      swapinlong(p->relc_owner_section);
	      swapinlong(p->relc_reserved);
	      break;
	  }
        case LDC_SYMBOLS:
	  { 
	      symbols_command_t *p = (symbols_command_t *)lcmd;

	      swapinshort(p->symc_kind);
	      swapinshort(p->symc_short_reserved);
	      swapinlong(p->symc_nentries);
	      swapinlong(p->symc_pkg_list);
	      swapinlong(p->symc_strings_section);
	      swapinlong(p->symc_reloc_addr);
	      swapinshort(p->symc_other.n_exported_symb);
	      break;
	  }
        case LDC_FUNC_TABLE:
	  {
	      int i;
	      func_table_command_t *p = (func_table_command_t *)lcmd;

	      swapinshort(p->fntc_type);
	      swapinshort(p->fntc_nentries);
	      swapinlong(p->fntc_table_name.adr_lcid);
	      swapinlong(p->fntc_table_name.adr_sctoff);
	      swapinlong(p->fntc_reserved);
	      for (i=0; i<p->fntc_nentries; i++) {
		  swapinlong(p->fntc_entry_loc[i].adr_lcid);
		  swapinlong(p->fntc_entry_loc[i].adr_sctoff);
	      }
	      break;
	  }
        case LDC_GEN_INFO:
	  {
	      gen_info_command_t *p = (gen_info_command_t *)lcmd;

	      swapinlong(p->genc_obj_create_time);

	      swapinlong(p->genc_creator_name.adr_lcid);
	      swapinlong(p->genc_creator_name.adr_sctoff);
	      swapinlong(p->genc_creator_version.adr_lcid);
	      swapinlong(p->genc_creator_version.adr_sctoff);
	      swapinlong(p->genc_creator_time);
	      swapinlong(p->genc_options_to_creator.adr_lcid);
	      swapinlong(p->genc_options_to_creator.adr_sctoff);
	      break;
	  }
        default:
	  break;
    }
}
#if !defined(__SABER__) && !defined(lint) && !defined(NO_WHAT_STRINGS)
static char *what_string = "@(#)osfrose.c\t$Revision: 1.1.2.4 $ $Date: 1995/05/12 15:41:24 $ $Locker:  $";
#endif

/*
 * COPYRIGHT NOTICE
 * 
 * OSF/1
 */

/*
 * HISTORY
 * $Log: osfrose.c,v $
 * Revision 1.1.2.4  1995/05/12  15:41:24  duthie
 * 	Add some swapping code to support diffent endian HOST and TARGET.
 * 	[1995/05/12  15:39:11  duthie]
 *
 * 	Add support to deal with endian differences between host
 * 	and target.
 * 	[1995/01/25  18:21:55  duthie]
 *
 * Revision 1.1.2.3  1994/03/12  00:47:48  chasb
 * 	Expand Copyrights
 * 	[1994/03/09  19:51:30  chasb]
 * 
 * Revision 1.1.2.2  1993/03/02  15:09:19  smk
 * 	gdb-4.8 upgrade
 * 	[1993/03/02  15:08:29  smk]
 * 
 * Revision 3.0  1993/01/01  04:35:14  ede
 * 	Initial revision for OSF/1 R1.3
 * 
 * Revision 1.1.2.3  1992/10/27  20:45:12  meissner
 * 	CR 7875: #if 0 out dead code in rose_slurp_reloc_table that causes a compiler crash.
 * 	[1992/10/27  20:44:52  meissner]
 * 
 * Revision 1.1.2.2  1992/08/28  15:57:11  smk
 * 	Initial 1.2 checkin
 * 	[1992/08/27  18:52:28  smk]
 * 
 * Revision 1.2.2.3  91/09/10  10:51:09  boot
 * 	Added casts to get rid of compiler warnings
 * 	[91/09/10  10:48:43  boot]
 * 
 * Revision 1.2.2.2  91/08/27  10:26:24  boot
 * 	Accomodate u-area changes, switch to new core format
 * 	[91/08/27  10:22:42  boot]
 * 
 * Revision 1.2  91/07/09  10:24:19  devrcs
 * 	Changes/fixes for 1.1
 * 	[91/06/25  09:57:14  boot]
 * 
 * $EndLog$
 */
