/* This file is derived from osf-core.c */

/* BFD back-end for OSF/1 core files.
   Copyright 1993, 1994 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  */

/* This file can only be compiled on systems which use OSF/1 style
   core files.  In the config/XXXXXX.mh file for such a system add
      HDEFINES=-DOSF_CORE
      HDEPFILES=osf-core.o
   */

#if defined (__OSF__) && defined (__i386__)
#include "bfd.h"
#include "sysdep.h"
#include "libbfd.h"

#include <sys/user.h>
#include <sys/core.h>

/* forward declarations */

static asection *
make_bfd_asection PARAMS ((bfd *, CONST char *, flagword, bfd_size_type,
			   bfd_vma, file_ptr));
static asymbol *
osf_core_make_empty_symbol PARAMS ((bfd *));
static const bfd_target *
osf_core_core_file_p PARAMS ((bfd *));
static char *
osf_core_core_file_failing_command PARAMS ((bfd *));
static int
osf_core_core_file_failing_signal PARAMS ((bfd *));
static boolean
osf_core_core_file_matches_executable_p PARAMS ((bfd *, bfd *));
static void
swap_abort PARAMS ((void));

/* These are stored in the bfd's tdata */

struct osf_core_struct 
{
  struct core_hdr core_header;     /* core file header */
};

#define core_hdr(bfd) (((bfd->tdata.osf_core_data))->core_header)

static asection *
make_bfd_asection (abfd, name, flags, _raw_size, vma, filepos)
     bfd *abfd;
     CONST char *name;
     flagword flags;
     bfd_size_type _raw_size;
     bfd_vma vma;
     file_ptr filepos;
{
  asection *asect;

  asect = bfd_make_section_anyway (abfd, name);
  if (!asect)
    return NULL;

  asect->flags = flags;
  asect->_raw_size = _raw_size;
  asect->vma = vma;
  asect->filepos = filepos;
  asect->alignment_power = 2;

  return asect;
}

static asymbol *
osf_core_make_empty_symbol (abfd)
     bfd *abfd;
{
  asymbol *new = (asymbol *) bfd_zalloc (abfd, sizeof (asymbol));
  if (new)
    new->the_bfd = abfd;
  return new;
}

static const bfd_target *
osf_core_core_file_p (abfd)
     bfd *abfd;
{
  int val;
  int   core_size;
  void *rawptr;
  asection *cur_sec, *prev_sec, *first_sec;
  struct core_hdr core_header;
  struct core_region_desc *regions, *regp;
  struct thread_info *threads, *threadp;
  int nregions, nthreads, nsections;
  long int filepos;

  bfd_set_error (bfd_error_no_error);
  cur_sec = prev_sec = first_sec = NULL;
  rawptr = NULL;
  threads = (struct thread_info *) NULL;
  regions = (struct core_region_desc *) NULL;
  nsections = 0;

  if (bfd_seek (abfd, 0L, false) < 0) 
    return NULL;

  val = bfd_read ((PTR)&core_header, 1, sizeof core_header, abfd);
  if (val != sizeof core_header)
    { /* file too small to be a valid core file */
      bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  if (core_header.c_magic != CORE_MAGIC) 
    { /* Either not a core file, or old core file format */
      bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  if (core_header.c_version > CORE_VERSION) 
    {
      /* core file format is too new */
      bfd_set_error (bfd_error_wrong_format);
      return NULL;
    }

  rawptr = bfd_zalloc (abfd, sizeof(struct core_hdr) + 
		       (core_header.c_nregions * sizeof(struct core_region_desc)) +
		       (core_header.c_nthreads * sizeof(struct thread_info)));
		  
  if (rawptr == NULL) 
    {
      bfd_set_error (bfd_error_no_memory);
      return NULL;
    }

  regions = (struct core_region_desc *) (rawptr + sizeof(struct core_hdr));

  threads = (struct thread_info *) (rawptr + sizeof (struct core_hdr) +
    (core_header.c_nregions * sizeof (struct core_region_desc)));


  if (bfd_read (regions, core_header.c_nregions, sizeof (struct core_region_desc), abfd) !=
      core_header.c_nregions * sizeof (struct core_region_desc)) 
    {
      bfd_set_error (bfd_error_wrong_format);
      free (rawptr);
      return NULL;
    }

  if (bfd_read (threads, core_header.c_nthreads, sizeof(struct thread_info), abfd) !=
      core_header.c_nthreads * sizeof (struct thread_info)) 
    {
      bfd_set_error (bfd_error_wrong_format);
      free (rawptr);
      return NULL;
    }
    
  /*
   * Create the sections 
   */

  for (regp = regions, nregions = core_header.c_nregions;
       nregions > 0;
       regp++, nregions--) 
    {
      switch (regp->r_prot) {
      default:
	/* The kernel doesn't dump things with the execute bit turned on */
	/* FIXME - this should probably be an error */
	continue;
      case VM_PROT_READ | VM_PROT_WRITE:
      case VM_PROT_READ | VM_PROT_WRITE | VM_PROT_EXECUTE:
	/* this could also be the stack, no easy way to tell... */
	break;
      }

      if (!make_bfd_asection (abfd, ".data", 
			      SEC_HAS_CONTENTS + SEC_ALLOC + SEC_LOAD,
			      regp->r_size,
			      (bfd_vma) regp->r_vaddr,
			      regp->r_offset))
	{
	  free(rawptr);
	  return NULL;
	}
    }

  for (nthreads = core_header.c_nthreads, threadp = threads, filepos = core_header.c_firstthread;
       nthreads > 0;
       nthreads--, threadp++, filepos += sizeof(struct thread_info)) {
    
    /* It should be given .reg\# to indicate regster of thread #
       See get_core_registers code for detail.
     */
    cur_sec = make_bfd_asection (abfd, ".reg", SEC_ALLOC + SEC_HAS_CONTENTS, 
				 sizeof(struct i386_thread_state), 0, filepos);
    if (! cur_sec) 
      {
	free (rawptr);
	return (0);
      }
    cur_sec = make_bfd_asection (abfd, ".reg2", SEC_ALLOC + SEC_HAS_CONTENTS, 
				 sizeof(struct i386_float_state), 0,
				 filepos+sizeof(struct i386_thread_state));

  }

  abfd->tdata = rawptr;
  core_hdr (abfd) = core_header;
	
  return abfd->xvec;
}

static char *
osf_core_core_file_failing_command (abfd)
     bfd *abfd;
{
  return core_hdr(abfd).c_cmdname;
}

/* ARGSUSED */
static int
osf_core_core_file_failing_signal (abfd)
     bfd *abfd;
{
  return core_hdr(abfd).c_signo;
}

/* ARGSUSED */
static boolean
osf_core_core_file_matches_executable_p (core_bfd, exec_bfd)
     bfd *core_bfd, *exec_bfd;
{
  return true;		/* FIXME, We have no way of telling at this point */
}


#define osf_core_get_symtab_upper_bound _bfd_nosymbols_get_symtab_upper_bound
#define osf_core_get_symtab _bfd_nosymbols_get_symtab
#define osf_core_print_symbol _bfd_nosymbols_print_symbol
#define osf_core_get_symbol_info _bfd_nosymbols_get_symbol_info
#define osf_core_bfd_is_local_label _bfd_nosymbols_bfd_is_local_label
#define osf_core_get_lineno _bfd_nosymbols_get_lineno
#define osf_core_find_nearest_line _bfd_nosymbols_find_nearest_line
#define osf_core_bfd_make_debug_symbol _bfd_nosymbols_bfd_make_debug_symbol
#define osf_core_read_minisymbols _bfd_nosymbols_read_minisymbols
#define osf_core_minisymbol_to_symbol _bfd_nosymbols_minisymbol_to_symbol

/* If somebody calls any byte-swapping routines, shoot them.  */
static void
swap_abort()
{
  abort(); /* This way doesn't require any declaration for ANSI to fuck up */
}
#define	NO_GET	((bfd_vma (*) PARAMS ((   const bfd_byte *))) swap_abort )
#define	NO_PUT	((void    (*) PARAMS ((bfd_vma, bfd_byte *))) swap_abort )
#define	NO_SIGNED_GET \
  ((bfd_signed_vma (*) PARAMS ((const bfd_byte *))) swap_abort )

const bfd_target osfosf1_core_vec =
  {
    "osfosf1-core",
    bfd_target_unknown_flavour,
    BFD_ENDIAN_BIG,			/* target byte order */
    BFD_ENDIAN_BIG,			/* target headers byte order */
    (HAS_RELOC | EXEC_P |	/* object flags */
     HAS_LINENO | HAS_DEBUG |
     HAS_SYMS | HAS_LOCALS | WP_TEXT | D_PAGED),
    (SEC_HAS_CONTENTS | SEC_ALLOC | SEC_LOAD | SEC_RELOC), /* section flags */
    0,			                                   /* symbol prefix */
    ' ',						   /* ar_pad_char */
    16,							   /* ar_max_namelen */
   /* 3, * removed in gdb-4.16*/			   /* minimum alignment power */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 64 bit data */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 32 bit data */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 16 bit data */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 64 bit hdrs */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 32 bit hdrs */
    NO_GET, NO_SIGNED_GET, NO_PUT,	/* 16 bit hdrs */

    {				/* bfd_check_format */
     _bfd_dummy_target,		/* unknown format */
     _bfd_dummy_target,		/* object file */
     _bfd_dummy_target,		/* archive */
     osf_core_core_file_p	/* a core file */
    },
    {				/* bfd_set_format */
     bfd_false, bfd_false,
     bfd_false, bfd_false
    },
    {				/* bfd_write_contents */
     bfd_false, bfd_false,
     bfd_false, bfd_false
    },
    
       BFD_JUMP_TABLE_GENERIC (_bfd_generic),
       BFD_JUMP_TABLE_COPY (_bfd_generic),
       BFD_JUMP_TABLE_CORE (osf_core),
       BFD_JUMP_TABLE_ARCHIVE (_bfd_noarchive),
       BFD_JUMP_TABLE_SYMBOLS (osf_core),
       BFD_JUMP_TABLE_RELOCS (_bfd_norelocs),
       BFD_JUMP_TABLE_WRITE (_bfd_generic),
       BFD_JUMP_TABLE_LINK (_bfd_nolink),
       BFD_JUMP_TABLE_DYNAMIC (_bfd_nodynamic),

    (PTR) 0			/* backend_data */
};
#endif 
/*
 * COPYRIGHT NOTICE
 * 
 * OSF/1
 */
/*
 * HISTORY
 * $Log: osfosf1core.c,v $
 * Revision 1.1.2.1  1996/03/08  21:10:30  nikolay
 * 	OSF: new file to handle core
 * 	[1996/03/08  21:09:46  nikolay]
 *
 * $EndLog$
 */
