/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 * 
 */
/*
 * cmk1.1
 */
/* 
 * rrx_i.h
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1993,1991,1990  Arizona Board of Regents
 *
 *
 * Revision: 1.10
 * Date: 1993/02/01 22:35:00
 */
/* 
 * Mach Receive Right Transfer protocol (RRX)
 */

#ifndef rrx_i_h
#define rrx_i_h

#include <xkern/include/prot/bidctl.h>
#include <s_xkern/include/prot/xfer.h>
#include <s_xkern/include/prot/rrx.h>

/* ZZZ : these header file will be devided into global one and local one */
#include <s_xkern/include/prot/machripc.h>
#include <s_xkern/include/prot/machripc_xfer.h>

extern	int	tracerrxp;

/* 
 * request codes
 */
typedef enum {
    RECEIVE_LOCK_REQ = 1,
    RECEIVE_UNLOCK_REQ,
    RECEIVE_RIGHT_TRANSFER
} RrxMsgType;

#define rrxMsgTypeStr(_t) 					\
  ((_t) == RECEIVE_LOCK_REQ ? "RECEIVE LOCK" :			\
   (_t) == RECEIVE_UNLOCK_REQ ? "RECEIVE UNLOCK" :		\
   (_t) == RECEIVE_RIGHT_TRANSFER ? "RECEIVE TRANSFER" :	\
   "UNKNOWN")

/* 
 * reply codes
 */
typedef enum {
    RRX_SUCCESS	= 1,
    RRX_FAILURE,
    RRX_REJECTED
} RrxReplyCode;

typedef struct {
    XferHost	xh;
    int		sendCount;
} RrxSendHost;

/* 
 * Used to temporarily represent a list of sending hosts and relevant
 * information.  
 */
typedef struct listElement {
    struct listElement	*next;
    struct listElement	*prev;
    RrxSendHost		sh;
    boolean_t		valid;
    XObj		lls;
} ListElement;

/* 
 * This represents an incoming RRX request, generated by rrxLoadRequest.
 */
typedef struct {
    RrxMsgType		type;
    NetPortNumber	portNumber;
    mn_arch_tag_t	archTag;
    union {
	struct {
	    XferHost	nrr;
	} unlock;
	struct {
	    MsgId	msgId;
	    u_short	numSenders;
	    RrxSendHost	*senders;
	    XferHost	orr;
	} transfer;
    } u;
} RrxReqMsg;

/* 
 * This structure is used to form an outgoing RRX request, passed to
 * rrxStoreRequest. 
 */
typedef struct {
    RrxMsgType		type;
    mnetport		*port;
    union {
	struct {
	    XferHost	nrr;
	} unlock;
	struct {
	    XferHost	orr;
	    ListElement	*senders;
	    MsgId	msgId;
	} transfer;
    } u;
} RrxReqOutgoing;

/* 
 * Both incoming and outgoing reply messges
 */
typedef struct {
    RrxMsgType		type;
    RrxReplyCode	replyCode;
} RrxRepMsg;

#define RRX_REPMSG_NETLEN	4

long 	rrxLoadReply( void *, char *, long, void * );

void 	rrxStoreReply( void *, char *, long, void * );

xkern_return_t
	rrxLoadRequest( RrxReqMsg *, Msg * );

void 	rrxStoreRequest( RrxReqOutgoing *, Msg * );

/* 
 * Headers loaded with rrxLoadRequest include dynamically allocated
 * storage.  rrxReqDispose should be called for each of these
 * headers. 
 */
void 	rrxReqDispose( RrxReqMsg * );

#endif	/* !rrx_i_h */
