/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 * 
 */
/*
 * cmk1.1
 */
/* 
 * initrom.c,v
 *
 * x-kernel v3.2
 *
 * Copyright (c) 1993,1991,1990  Arizona Board of Regents
 *
 *
 * initrom.c,v
 * Revision 1.3.1.2  1994/09/01  18:50:18  menze
 * Meta-data allocations now use Allocators and Paths
 * Subsystem initialization functions can fail
 *
 * Revision 1.3  1994/08/05  00:16:30  menze
 *   [ 1994/06/08          menze ]
 *   Protected file-accesses with ! XK_KERNEL, so even in-kernel
 *   implementations can use this to get at the compose-generated rom
 *   entries.
 *
 *   [ 1994/05/05          menze ]
 *   savestr wasn't copying last char
 *   Fixed problem in support for compose-generated rom entries
 *
 *   [ 1994/03/10          menze ]
 *   Added support for rom entries generated by compose
 *
 * Revision 1.2  1994/02/05  00:09:14  menze
 *   [ 1994/01/14          menze ]
 *   Added inclusion of xk_debug.h
 *
 * Revision 1.1  1994/01/13  03:53:29  menze
 * Initial revision
 *
 */

#include <ctype.h>
#include <xkern/include/xk_debug.h>
#include <xkern/include/platform.h>
#include <xkern/include/romopt.h>



xkern_return_t
initRom()
{
    FILE 		*f;
    char 		buf[ROM_OPT_MAX_LEN + 2];
    xkern_return_t	xkr = XK_SUCCESS;

    if ((f = fopen("rom", "r")) == NULL) {
	xTrace0(init, TR_MAJOR_EVENTS, "not loading ROM file");
    } else {
	xTrace0(init, TR_MAJOR_EVENTS, "loading ROM file");
	while ( fgets(buf, ROM_OPT_MAX_LEN + 2, f) ) {
	    if ( addRomOpt(buf) != XK_SUCCESS ) {
		xkr = XK_FAILURE;
		break;
	    }
	}
	fclose(f);
    }
    return xkr;
}
