/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 * 
 */
/*
 * cmk1.1
 */
/*
 * This header file contains the definitions for use with the generic
 * SkipList package.
 *
 *      -- THIS CODE IS UNDER THE GNU COPYLEFT --
 *
 *    Dominic Giampaolo (nick@maxine.wpi.edu) 
 */

#ifndef _ETAP_SKIPLIST_H_
#define _ETAP_SKIPLIST_H_


/*
 * RAND_MAX should be defined if you are using an ANSI compiler system,
 * but alas it isn't always.  You should define it to be the correct
 * value for whatever your library rand() function returns.
 *
 * Under unix (mach, bsd, etc), that's 2^31 - 1.  On my Amiga at home 
 * it's 2^15 - 1.  It would be wise to verify what your compiler uses
 * for RAND_MAX (the maximum value returned from rand()) because otherwise
 * the code will _not_ work.
 */
#ifndef RAND_MAX
#define RAND_MAX (2147483648 - 1)
#endif


#define ALLOW_DUPLICATES  1   /* allow or disallow duplicates in a list */
#define NO_DUPLICATES     0
#define DUPLICATE_ITEM   -1   /* ret val from InsertSL if dups not allowed */


/* typedef's */
typedef struct SLNodeStruct *SLNode;

struct SLNodeStruct
{
  void   *key;
  SLNode  forward[1]; /* variable sized array of forward pointers */
};

typedef struct _SkipList
{
  struct SLNodeStruct *header;     /* pointer to header */

  int  (*compare)();
  void (*freeitem)();

  int flags;
  int level;                       /* max index+1 of the forward array */

} *SkipList;



/* protos */
SkipList   NewSL(int (*compare)(), void (*freeitem)(), int flags);
void       FreeSL(SkipList l);
int        InsertSL(SkipList l, void *key);
int        DeleteSL(SkipList l, void *key);
void      *SearchSL(SkipList l, void *key);
void       DoForSL(SkipList  l, int (*function)(), void *arg);

#endif  /* _ETAP_SKIPLIST_H_ */
