/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 * 
 */
/*
 * MkLinux
 */
/*-
 * Copyright (c) 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)bcopy.c	8.1 (Berkeley) 6/11/93
 */

/*
 * This is designed to be small, not fast.
 */
void
bcopy(s1, s2, n)
	const void *s1;
	void *s2;
	unsigned n;
{
	register const char *f = s1;
	register char *t = s2;

	while (n != 0) {
		*t++ = *f++;
		n--;
	}
}


int
bcmp(
        const char s1[], 
        const char s2[],
        int len
) {
        const char *sp1 = s1;
        const char *sp2 = s2;
        register int val;

        while ( len-- )
                if (val = *sp1++ - *sp2++) 
                        return(val);

        return (0);
}

int
strlen(s)
const char *s;
{
        register int n;

        n = 0;
        while (*s++)
                n++;
        return(n);
}

int
strcmp(s1, s2)
const char *s1;
const char *s2;
{

        while (*s1 == *s2++)
                if (*s1++=='\0')
                        return(0);
        return(*s1 - *--s2);
}

int
strncmp(const char *s1, const char *s2, int n)
{
        int i;

        if(s1 == s2)
                return(0);
        for(i = 0; i < n && *s1 == *s2++; i++)
                if(*s1++ == '\0')
                        return(0);
        return((i == n)? 0: (*(unsigned char *)s1 - *(unsigned char *)--s2));
}

char *
strcpy(
        char s1[], 
        const char s2[]
) {
        register char *sp1 = s1;
        register const char *sp2 = s2;

        if (sp2 == 0) {
                *sp1 = 0;
                return (sp1);
        }

        while ( (*sp1++ = *sp2++) )
                ;

        return (s1);
}

