/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 * 
 */
/*
 * MkLinux
 */

#include <ppc/asm.h>

ENTRY2(__start_mach,_start,TAG_NO_FRAME_USED)

	/*
	 * save our arguments before jumping to some C with our
	 * own stack frame
	 */

	lwz	r3,	0(r1)
	addi	r4,	r1,	4
	mr	r5,	r4
0:	lwz	r0,	4(r5)
	addi	r5,	r5,	4
	cmpwi	r0,	0
	bne	0b
	addi	r5,	r5,	4
	addi	r1,	r1,	-64
	
	b	EXT(__c_start_mach)

	/*
	 * never returns
	 */
	BREAKPOINT_TRAP

/* This entry ONLY works when linking static, non-relocatable servers,
 * it avoids the need for a .got2 section in the executable file such
 * as that generated by libgcc.a
 */
	
ENTRY(__eabi,TAG_NO_FRAME_USED)
	blr

