/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 */
/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 * MkLinux
 */
/*
 * 	File: 	exp_malloc.c
 *	Author: Francois Barbou des Places, Open Software Foundation
 *	Date:	February, 1993
 *
 * 	Standard interface to the internal memory allocation package
 * 	in malloc.c.
 */

#include <cthreads.h>
#include "cthread_internals.h"
#include <stdlib.h>

extern void malloc_fork_prepare(void);
extern void malloc_fork_parent(void);
extern void malloc_fork_child(void);


void *
malloc(size_t size)
{
	return cthread_malloc(size);
}

void
free(void *base)
{
	cthread_free(base);
}

void *realloc(void *old_base, size_t new_size);	/* forward */

void *
realloc(void *old_base, size_t new_size)
{
	return cthread_realloc(old_base, new_size);
}

#ifdef	DEBUG
void print_malloc_free_list(void);

void
print_malloc_free_list(void)
{
	cthread_print_malloc_free_list();
}
#endif	/* DEBUG */

void 
malloc_fork_prepare()
/*
 * Prepare the malloc module for a fork by insuring that no thread is in a
 * malloc critical section.
 */
{
	cthread_malloc_fork_prepare();
}

void 
malloc_fork_parent()
/*
 * Called in the parent process after a fork() to resume normal operation.
 */
{
	cthread_malloc_fork_parent();
}

void 
malloc_fork_child()
/*
 * Called in the child process after a fork() to resume normal operation.
 */
{
	cthread_malloc_fork_child();
}
