/*
 * Copyright 1991-1998 by Open Software Foundation, Inc. 
 *              All Rights Reserved 
 *  
 * Permission to use, copy, modify, and distribute this software and 
 * its documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appears in all copies and 
 * that both the copyright notice and this permission notice appear in 
 * supporting documentation. 
 *  
 * OSF DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE 
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS 
 * FOR A PARTICULAR PURPOSE. 
 *  
 * IN NO EVENT SHALL OSF BE LIABLE FOR ANY SPECIAL, INDIRECT, OR 
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM 
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN ACTION OF CONTRACT, 
 * NEGLIGENCE, OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION 
 * WITH THE USE OR PERFORMANCE OF THIS SOFTWARE. 
 */
/*
 * MkLinux
 */
/*
 * File     :  etap_events.h
 *
 * 	       Kernel trace event definitions
 *
 * Notes    :  If new trace event or subsystem definitions are added
 *	       to this file, the appropriate tables in kern/etap.c MUST be
 *	       updated for the ETAP package to recognize them.
 *
 */

#ifndef _MACH_ETAP_EVENTS_H_
#define _MACH_ETAP_EVENTS_H_


#define STATIC                  0


/* ============================
 *  ETAP Subsystem Definitions 
 * ============================
 */

#define ETAP_SUBS_PROBE		0x0000		/* must be zero	*/ 

#define ETAP_SUBS_LOCK_VM	0x0100
#define ETAP_SUBS_LOCK_IPC	0x0200
#define ETAP_SUBS_LOCK_IO	0x0300
#define ETAP_SUBS_LOCK_THREAD	0x0400
#define ETAP_SUBS_LOCK_NET	0x0500
#define ETAP_SUBS_LOCK_NORMA	0x0600
#define ETAP_SUBS_LOCK_DIPC	0x0700
#define ETAP_SUBS_LOCK_KKT	0x0800
#define ETAP_SUBS_LOCK_XKERNEL	0x0900
#define ETAP_SUBS_LOCK_MISC	0x0a00

#define ETAP_NO_TRACE		0x0fff    	/* never traced */


/* =======================
 *  Lock Event Definitions
 * =======================
 */

#define ETAP_VM_BUCKET			(ETAP_SUBS_LOCK_VM +  1)
#define ETAP_VM_HIMEM			(ETAP_SUBS_LOCK_VM +  2)
#define ETAP_VM_MAP			(ETAP_SUBS_LOCK_VM +  3)
#define ETAP_VM_MAP_I			(ETAP_SUBS_LOCK_VM +  4)
#define ETAP_VM_MEMMAN			(ETAP_SUBS_LOCK_VM +  5)
#define ETAP_VM_MSYNC			(ETAP_SUBS_LOCK_VM +  6)
#define ETAP_VM_OBJ			(ETAP_SUBS_LOCK_VM +  7)
#define ETAP_VM_OBJ_CACHE		(ETAP_SUBS_LOCK_VM +  8)
#define ETAP_VM_PAGE_ALLOC              (ETAP_SUBS_LOCK_VM +  9)
#define ETAP_VM_PAGEOUT			(ETAP_SUBS_LOCK_VM + 10)
#define ETAP_VM_PAGEQ			(ETAP_SUBS_LOCK_VM + 11)
#define ETAP_VM_PAGEQ_FREE		(ETAP_SUBS_LOCK_VM + 12)
#define ETAP_VM_PMAP			(ETAP_SUBS_LOCK_VM + 13)
#define ETAP_VM_PMAP_CACHE		(ETAP_SUBS_LOCK_VM + 14)
#define ETAP_VM_PMAP_FREE		(ETAP_SUBS_LOCK_VM + 15)
#define ETAP_VM_PMAP_KERNEL		(ETAP_SUBS_LOCK_VM + 16)
#define ETAP_VM_PMAP_SYS		(ETAP_SUBS_LOCK_VM + 17)
#define ETAP_VM_PMAP_SYS_I		(ETAP_SUBS_LOCK_VM + 18)
#define ETAP_VM_PMAP_UPDATE		(ETAP_SUBS_LOCK_VM + 19)
#define	ETAP_VM_PREPPIN			(ETAP_SUBS_LOCK_VM + 20)
#define ETAP_VM_RESULT			(ETAP_SUBS_LOCK_VM + 21)
#define	ETAP_VM_TEST			(ETAP_SUBS_LOCK_VM + 22)
#define ETAP_VM_PMAP_PHYSENTRIES	(ETAP_SUBS_LOCK_VM + 23)
#define ETAP_VM_PMAP_SID		(ETAP_SUBS_LOCK_VM + 24)
#define ETAP_VM_PMAP_PTE		(ETAP_SUBS_LOCK_VM + 25)
#define ETAP_VM_PMAP_PTE_OVFLW		(ETAP_SUBS_LOCK_VM + 26)
#define ETAP_VM_PMAP_TLB		(ETAP_SUBS_LOCK_VM + 27)

#define ETAP_IPC_IHGB			(ETAP_SUBS_LOCK_IPC +  1)
#define ETAP_IPC_IS			(ETAP_SUBS_LOCK_IPC +  2)
#define ETAP_IPC_IS_REF			(ETAP_SUBS_LOCK_IPC +  3)
#define	ETAP_IPC_MQUEUE			(ETAP_SUBS_LOCK_IPC +  4)
#define	ETAP_IPC_OBJECT			(ETAP_SUBS_LOCK_IPC +  5)
#define ETAP_IPC_PORT_MULT		(ETAP_SUBS_LOCK_IPC +  6)
#define ETAP_IPC_PORT_TIME		(ETAP_SUBS_LOCK_IPC +  7)
#define ETAP_IPC_RPC			(ETAP_SUBS_LOCK_IPC +  8)
#define ETAP_IPC_PORT_ALLOCQ		(ETAP_SUBS_LOCK_IPC +  9)

#define ETAP_IO_AHA			(ETAP_SUBS_LOCK_IO +  1)
#define ETAP_IO_CHIP			(ETAP_SUBS_LOCK_IO +  2)
#define ETAP_IO_DEV			(ETAP_SUBS_LOCK_IO +  3)
#define ETAP_IO_DEV_NUM			(ETAP_SUBS_LOCK_IO +  4)
#define ETAP_IO_DEV_PAGEH		(ETAP_SUBS_LOCK_IO +  5)
#define ETAP_IO_DEV_PAGER		(ETAP_SUBS_LOCK_IO +  6)
#define ETAP_IO_DEV_PORT		(ETAP_SUBS_LOCK_IO +  7)
#define ETAP_IO_DEV_REF			(ETAP_SUBS_LOCK_IO +  8)
#define ETAP_IO_DEVINS			(ETAP_SUBS_LOCK_IO +  9)
#define ETAP_IO_DONE_LIST		(ETAP_SUBS_LOCK_IO + 10)
#define ETAP_IO_DONE_Q			(ETAP_SUBS_LOCK_IO + 11)
#define ETAP_IO_DONE_REF		(ETAP_SUBS_LOCK_IO + 12)
#define ETAP_IO_EAHA			(ETAP_SUBS_LOCK_IO + 13)
#define ETAP_IO_HD_PROBE		(ETAP_SUBS_LOCK_IO + 14)
#define ETAP_IO_IHGB			(ETAP_SUBS_LOCK_IO + 15)
#define ETAP_IO_IOPB			(ETAP_SUBS_LOCK_IO + 16)
#define ETAP_IO_KDQ			(ETAP_SUBS_LOCK_IO + 17)
#define ETAP_IO_KDTTY			(ETAP_SUBS_LOCK_IO + 18)
#define ETAP_IO_REQ			(ETAP_SUBS_LOCK_IO + 19)
#define ETAP_IO_TARGET			(ETAP_SUBS_LOCK_IO + 20)
#define ETAP_IO_TTY			(ETAP_SUBS_LOCK_IO + 21)
#define ETAP_IO_IOP_LOCK		(ETAP_SUBS_LOCK_IO + 22)
#define ETAP_IO_DEV_NAME		(ETAP_SUBS_LOCK_IO + 23)
#define ETAP_IO_CDLI			(ETAP_SUBS_LOCK_IO + 24)
#define ETAP_IO_HIPPI_FILTER		(ETAP_SUBS_LOCK_IO + 25)
#define ETAP_IO_HIPPI_SRC		(ETAP_SUBS_LOCK_IO + 26)
#define ETAP_IO_HIPPI_DST		(ETAP_SUBS_LOCK_IO + 27)
#define ETAP_IO_HIPPI_PKT		(ETAP_SUBS_LOCK_IO + 28)
#define ETAP_IO_NOTIFY			(ETAP_SUBS_LOCK_IO + 29)
#define ETAP_IO_DATADEV			(ETAP_SUBS_LOCK_IO + 30)

#define ETAP_THREAD_ACT			(ETAP_SUBS_LOCK_THREAD +  1)
#define ETAP_THREAD_ACTION		(ETAP_SUBS_LOCK_THREAD +  2)
#define ETAP_THREAD_LOCK		(ETAP_SUBS_LOCK_THREAD +  3)
#define ETAP_THREAD_LOCK_SET		(ETAP_SUBS_LOCK_THREAD +  4)
#define ETAP_THREAD_NEW			(ETAP_SUBS_LOCK_THREAD +  5)
#define ETAP_THREAD_PSET		(ETAP_SUBS_LOCK_THREAD +  6)
#define ETAP_THREAD_PSET_ALL		(ETAP_SUBS_LOCK_THREAD +  7)
#define ETAP_THREAD_PSET_RUNQ		(ETAP_SUBS_LOCK_THREAD +  8)
#define ETAP_THREAD_PSET_IDLE		(ETAP_SUBS_LOCK_THREAD +  9)
#define ETAP_THREAD_PSET_QUANT		(ETAP_SUBS_LOCK_THREAD + 10)
#define ETAP_THREAD_PROC		(ETAP_SUBS_LOCK_THREAD + 11)
#define ETAP_THREAD_PROC_RUNQ		(ETAP_SUBS_LOCK_THREAD + 12)
#define ETAP_THREAD_REAPER		(ETAP_SUBS_LOCK_THREAD + 13)
#define ETAP_THREAD_RPC 		(ETAP_SUBS_LOCK_THREAD + 14)
#define ETAP_THREAD_SEMA		(ETAP_SUBS_LOCK_THREAD + 15)
#define ETAP_THREAD_STACK		(ETAP_SUBS_LOCK_THREAD + 16)
#define ETAP_THREAD_STACK_USAGE		(ETAP_SUBS_LOCK_THREAD + 17)
#define ETAP_THREAD_TASK_NEW		(ETAP_SUBS_LOCK_THREAD + 18)
#define ETAP_THREAD_TASK_ITK		(ETAP_SUBS_LOCK_THREAD + 19)
#define ETAP_THREAD_ULOCK		(ETAP_SUBS_LOCK_THREAD + 20)
#define ETAP_THREAD_WAIT		(ETAP_SUBS_LOCK_THREAD + 21)
#define ETAP_THREAD_WAKE		(ETAP_SUBS_LOCK_THREAD + 22)
#define ETAP_THREAD_ACT_LIST		(ETAP_SUBS_LOCK_THREAD + 23)
#define ETAP_THREAD_TASK_SWAP		(ETAP_SUBS_LOCK_THREAD + 24)
#define ETAP_THREAD_TASK_SWAPOUT	(ETAP_SUBS_LOCK_THREAD + 25)
#define ETAP_THREAD_SWAPPER		(ETAP_SUBS_LOCK_THREAD + 26)

#define ETAP_NET_IFQ			(ETAP_SUBS_LOCK_NET +  1)
#define ETAP_NET_KMSG			(ETAP_SUBS_LOCK_NET +  2)
#define ETAP_NET_MBUF			(ETAP_SUBS_LOCK_NET +  3)
#define ETAP_NET_POOL			(ETAP_SUBS_LOCK_NET +  4)
#define ETAP_NET_Q			(ETAP_SUBS_LOCK_NET +  5)
#define ETAP_NET_QFREE			(ETAP_SUBS_LOCK_NET +  6)
#define ETAP_NET_RCV			(ETAP_SUBS_LOCK_NET +  7)
#define ETAP_NET_RCV_PLIST		(ETAP_SUBS_LOCK_NET +  8)
#define ETAP_NET_THREAD			(ETAP_SUBS_LOCK_NET +  9)

#define ETAP_NORMA_XMM			(ETAP_SUBS_LOCK_NORMA + 1)
#define ETAP_NORMA_XMMOBJ		(ETAP_SUBS_LOCK_NORMA + 2)
#define ETAP_NORMA_XMMCACHE		(ETAP_SUBS_LOCK_NORMA + 3)
#define ETAP_NORMA_MP			(ETAP_SUBS_LOCK_NORMA + 4)
#define ETAP_NORMA_VOR			(ETAP_SUBS_LOCK_NORMA + 5)
#define ETAP_NORMA_TASK			(ETAP_SUBS_LOCK_NORMA + 6)

#define ETAP_DIPC_CLEANUP		(ETAP_SUBS_LOCK_DIPC + 1)
#define ETAP_DIPC_MSG_PROG		(ETAP_SUBS_LOCK_DIPC + 2)
#define ETAP_DIPC_PREP_QUEUE		(ETAP_SUBS_LOCK_DIPC + 3)
#define ETAP_DIPC_PREP_FILL		(ETAP_SUBS_LOCK_DIPC + 4)
#define ETAP_DIPC_MIGRATE		(ETAP_SUBS_LOCK_DIPC + 5)
#define ETAP_DIPC_DELIVER		(ETAP_SUBS_LOCK_DIPC + 6)
#define ETAP_DIPC_RECV_SYNC		(ETAP_SUBS_LOCK_DIPC + 7)
#define ETAP_DIPC_RPC			(ETAP_SUBS_LOCK_DIPC + 8)
#define ETAP_DIPC_MSG_REQ		(ETAP_SUBS_LOCK_DIPC + 9)
#define ETAP_DIPC_MSG_ORDER		(ETAP_SUBS_LOCK_DIPC + 10)
#define ETAP_DIPC_MSG_PREPQ		(ETAP_SUBS_LOCK_DIPC + 11)
#define ETAP_DIPC_MSG_FREE		(ETAP_SUBS_LOCK_DIPC + 12)
#define ETAP_DIPC_KMSG_AST		(ETAP_SUBS_LOCK_DIPC + 13)
#define ETAP_DIPC_TEST_LOCK		(ETAP_SUBS_LOCK_DIPC + 14)
#define ETAP_DIPC_SPINLOCK		(ETAP_SUBS_LOCK_DIPC + 15)
#define ETAP_DIPC_TRACE			(ETAP_SUBS_LOCK_DIPC + 16)
#define	ETAP_DIPC_REQ_CALLBACK		(ETAP_SUBS_LOCK_DIPC + 17)
#define ETAP_DIPC_PORT_NAME		(ETAP_SUBS_LOCK_DIPC + 18)
#define ETAP_DIPC_RESTART_PORT		(ETAP_SUBS_LOCK_DIPC + 19)
#define ETAP_DIPC_ZERO_PAGE		(ETAP_SUBS_LOCK_DIPC + 20)
#define ETAP_DIPC_BLOCKED_NODE		(ETAP_SUBS_LOCK_DIPC + 21)
#define ETAP_DIPC_TIMER			(ETAP_SUBS_LOCK_DIPC + 22)
#define ETAP_DIPC_SPECIAL_PORT		(ETAP_SUBS_LOCK_DIPC + 23)

#define ETAP_KKT_TEST_WORK		(ETAP_SUBS_LOCK_KKT + 1)
#define ETAP_KKT_TEST_MP		(ETAP_SUBS_LOCK_KKT + 2)
#define ETAP_KKT_NODE			(ETAP_SUBS_LOCK_KKT + 3)
#define ETAP_KKT_CHANNEL_LIST		(ETAP_SUBS_LOCK_KKT + 4)
#define ETAP_KKT_CHANNEL		(ETAP_SUBS_LOCK_KKT + 5)
#define ETAP_KKT_HANDLE 		(ETAP_SUBS_LOCK_KKT + 6)
#define ETAP_KKT_MAP	 		(ETAP_SUBS_LOCK_KKT + 7)
#define ETAP_KKT_RESOURCE 		(ETAP_SUBS_LOCK_KKT + 8)

#define ETAP_XKERNEL_MASTER             (ETAP_SUBS_LOCK_XKERNEL + 1)
#define ETAP_XKERNEL_EVENT              (ETAP_SUBS_LOCK_XKERNEL + 2)
#define ETAP_XKERNEL_ETHINPUT           (ETAP_SUBS_LOCK_XKERNEL + 3)

#define ETAP_MISC_AST			(ETAP_SUBS_LOCK_MISC +  1)
#define ETAP_MISC_CLOCK			(ETAP_SUBS_LOCK_MISC +  2)
#define ETAP_MISC_EMULATE		(ETAP_SUBS_LOCK_MISC +  3)
#define ETAP_MISC_EVENT			(ETAP_SUBS_LOCK_MISC +  4)
#define ETAP_MISC_KDB			(ETAP_SUBS_LOCK_MISC +  5)
#define ETAP_MISC_PCB			(ETAP_SUBS_LOCK_MISC +  6)
#define ETAP_MISC_PRINTF		(ETAP_SUBS_LOCK_MISC +  7)
#define ETAP_MISC_Q			(ETAP_SUBS_LOCK_MISC +  8)
#define ETAP_MISC_RPC_SUBSYS		(ETAP_SUBS_LOCK_MISC +  9)
#define ETAP_MISC_RT_CLOCK		(ETAP_SUBS_LOCK_MISC + 10)
#define ETAP_MISC_SD_POOL		(ETAP_SUBS_LOCK_MISC + 11)
#define ETAP_MISC_TIMER			(ETAP_SUBS_LOCK_MISC + 12)
#define ETAP_MISC_UTIME			(ETAP_SUBS_LOCK_MISC + 13)
#define ETAP_MISC_XPR			(ETAP_SUBS_LOCK_MISC + 14)
#define ETAP_MISC_ZONE			(ETAP_SUBS_LOCK_MISC + 15)
#define ETAP_MISC_ZONE_ALL		(ETAP_SUBS_LOCK_MISC + 16)
#define ETAP_MISC_ZONE_GET		(ETAP_SUBS_LOCK_MISC + 17)
#define ETAP_MISC_ZONE_PTABLE		(ETAP_SUBS_LOCK_MISC + 18)
#define ETAP_MISC_LEDGER		(ETAP_SUBS_LOCK_MISC + 19)
#define ETAP_MISC_SCSIT_TGT		(ETAP_SUBS_LOCK_MISC + 20)
#define ETAP_MISC_SCSIT_SELF		(ETAP_SUBS_LOCK_MISC + 21)
#define ETAP_MISC_SPL			(ETAP_SUBS_LOCK_MISC + 22) /* i860 */
#define ETAP_MISC_MASTER		(ETAP_SUBS_LOCK_MISC + 23) /* i860 */
#define ETAP_MISC_FLOAT			(ETAP_SUBS_LOCK_MISC + 24) /* i860 */
#define ETAP_MISC_GROUP			(ETAP_SUBS_LOCK_MISC + 25) /* i860 */
#define ETAP_MISC_FLIPC			(ETAP_SUBS_LOCK_MISC + 26)
#define ETAP_MISC_MP_IO			(ETAP_SUBS_LOCK_MISC + 27)
#define ETAP_MISC_KERNEL_TEST		(ETAP_SUBS_LOCK_MISC + 28)
#define ETAP_MISC_TIMER_LOCK		(ETAP_SUBS_LOCK_MISC + 29)
#define ETAP_MISC_POST			(ETAP_SUBS_LOCK_MISC + 30) /* i860 */
#define ETAP_MISC_KERNLOG		(ETAP_SUBS_LOCK_MISC + 31) /* Alpha */
#define ETAP_MISC_RT_CLOCK_PRIV		(ETAP_SUBS_LOCK_MISC + 32)

/* ==========================
 *  System Probe Definitions
 * ==========================
 */

#define ETAP_P_USER_EVENTS		(ETAP_SUBS_PROBE +  0)
#define ETAP_P_SYSCALL_MACH		(ETAP_SUBS_PROBE +  1)
#define ETAP_P_SYSCALL_UNIX		(ETAP_SUBS_PROBE +  2)
#define ETAP_P_THREAD_LIFE		(ETAP_SUBS_PROBE +  3)
#define ETAP_P_THREAD_CTX		(ETAP_SUBS_PROBE +  4)
#define ETAP_P_RPC			(ETAP_SUBS_PROBE +  5)
#define ETAP_P_INTERRUPT		(ETAP_SUBS_PROBE +  6)
#define ETAP_P_ACT_ABORT		(ETAP_SUBS_PROBE +  7)
#define ETAP_P_PRIORITY			(ETAP_SUBS_PROBE +  8)
#define ETAP_P_EXCEPTION		(ETAP_SUBS_PROBE +  9)
#define ETAP_P_DEPRESSION		(ETAP_SUBS_PROBE +  10)
#define ETAP_P_MISC			(ETAP_SUBS_PROBE +  11)

/* ===========================
 *  ETAP Thread block reasons
 * ===========================
 */

#define BLOCKED_ON_UNDEFINED		0
#define BLOCKED_ON_CLEAR		0

#define BLOCKED_ON_SEMAPHORE		1
#define BLOCKED_ON_LOCK			2
#define BLOCKED_ON_LOCK_HANDOFF		3
#define BLOCKED_ON_MUTEX_LOCK		4
#define BLOCKED_ON_COMPLEX_LOCK		5
#define BLOCKED_ON_PORT_RCV		6
#define BLOCKED_ON_REAPER_DONE		7
#define BLOCKED_ON_IDLE_DONE		8
#define BLOCKED_ON_TERMINATION		9
 
#endif  /* _MACH_ETAP_EVENTS_H_ */
