/*
 * @OSF_COPYRIGHT@
 */
/*
 * HISTORY
 * $Log: vm_inherit.h,v $
 * Revision 1.2.9.1  1994/09/23  02:44:12  ezf
 * 	change marker to not FREE
 * 	[1994/09/22  21:43:38  ezf]
 *
 * Revision 1.2.6.1  1994/02/17  16:25:09  rwd
 * 	Add VM_INHERIT_LAST_VALID
 * 	[94/02/16            rwd]
 * 
 * Revision 1.2.2.2  1993/06/09  02:44:13  gm
 * 	Added to OSF/1 R1.3 from NMK15.0.
 * 	[1993/06/02  21:18:44  jeffc]
 * 
 * Revision 1.2  1993/04/19  16:40:30  devrcs
 * 	ansi C conformance changes
 * 	[1993/02/02  18:55:45  david]
 * 
 * Revision 1.1  1992/09/30  02:32:24  robert
 * 	Initial revision
 * 
 * $EndLog$
 */
/* CMU_HIST */
/*
 * Revision 2.3  91/05/14  17:02:47  mrt
 * 	Correcting copyright
 * 
 * Revision 2.2  91/02/05  17:37:31  mrt
 * 	Changed to new Mach copyright
 * 	[91/02/01  17:22:24  mrt]
 * 
 * Revision 2.1  89/08/03  16:06:30  rwd
 * Created.
 * 
 * Revision 2.3  89/02/25  18:42:18  gm0w
 * 	Changes for cleanup.
 * 
 * 16-Sep-85  Avadis Tevanian (avie) at Carnegie-Mellon University
 *	Created.
 *
 */
/* CMU_ENDHIST */
/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989,1988,1987 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 */
/*
 *	File:	mach/vm_inherit.h
 *	Author:	Avadis Tevanian, Jr., Michael Wayne Young
 *
 *	Virtual memory map inheritance definitions.
 *
 */

#ifndef	VM_INHERIT_H_
#define	VM_INHERIT_H_

/*
 *	Types defined:
 *
 *	vm_inherit_t	inheritance codes.
 */

typedef unsigned int		vm_inherit_t;	/* might want to change this */

/*
 *	Enumeration of valid values for vm_inherit_t.
 */

#define	VM_INHERIT_SHARE	((vm_inherit_t) 0)	/* share with child */
#define	VM_INHERIT_COPY		((vm_inherit_t) 1)	/* copy into child */
#define VM_INHERIT_NONE		((vm_inherit_t) 2)	/* absent from child */
#define	VM_INHERIT_DONATE_COPY	((vm_inherit_t) 3)	/* copy and delete */

#define VM_INHERIT_DEFAULT	VM_INHERIT_COPY
#define VM_INHERIT_LAST_VALID VM_INHERIT_NONE

#endif	/* VM_INHERIT_H_ */
