/* The following constants are used to identify menus and their items. The menu IDs
   have an "m" prefix and the item numbers within each menu have an "i" prefix. */

#define	mApple			1000		/* Apple menu */
#define	iAbout			1

#define	mFile			1001		/* File menu */
#define iProgramMgr		1
#define iSound			3
#define iQuit			5

#define	mEdit			1002		/* Edit menu */
#define	iUndo			1
#define	iCut			3
#define	iCopy			4
#define	iPaste			5
#define	iClear			6


#define	mControl		2000
#define iRestore		1
#define iMove			2
#define iWinSize		3
#define iMinimize		4
#define iMaximize		5
#define iWinClose		7
#define iSwitchTo		8

#define	mWinFile		2001		/* Window's File menu */
#define iWinNew			1
#define iWinOpen		2
#define iWinMove		3
#define iWinCopy		4
#define iWinDelete		5
#define iProperties		6
#define iRun			8
#define iLogout			10

#define	mOptions		2002		/* Options menu */
#define iAutoArrange	1
#define iMinimizeOnUse	2
#define iSaveOnExit		3

#define	mWindow			2003		/* Window menu */
#define iCascade		1
#define iTile			2
#define iArrange		3
#define iMain			5
#define iAccessories	6
#define iApplications	7
#define iGames			8
#define iMaxChild		9

#define	mHelp			2004		/* Help menu */
#define iIndex			1
#define iKeyboard		2
#define iCommands		3
#define iProcedures		4
#define iGlossary		5
#define iUsingHelp		6
#define iAboutHelp		8

#define mMines			2005	/*	Minesweeper menu */
#define iNew			1		/* New game. */
#define iBeginner		3		/* Game size. */
#define iIntermediate	4
#define iExpert			5
#define iCustom			6
#define iMarks			8		/* Allow question marks */
#define iTimes			10		/* Show best times */

#define mMineHelp		2006
#define iHowToPlay		1
#define iGameCommands	2
#define iGameHelp		3
#define iAboutMines		5

#define	mAppleInx			0		/* Apple menu index */
#define	mFileInx			1		/* File menu index */
#define	mEditInx			2		/* Edit menu index */
#define	mControlInx			3		/* Control popup index */
#define menuCount			4

#define rWindow				1000	/* Resource ID for main window */
#define rAboutMines			1000	/* Resource ID for About Mines box dialog. */
#define	rUserAlert			1001	/* Resource ID for error user alert */
#define rCustom 			1002	/* Resource ID for custom bounds dialog. */
#define rBestTimes 			1003	/* Resource ID for best times dialog. */
#define rAbout 				1004	/* Resource ID for About Windows box dialog. */

//	Windows Errors
#define	rTitleStr			128
#define	rTextStr			129
#define	kNoErr				0
#define	kBadPath			1
#define	kBadDir				2
#define	kLostPath			3
#define	kAppClockErr		4
#define	kUAEError			5
#define	kAssocError			6
#define	kNoMem				7
#define	kNot3Error			8
#define	kNoComm				9
#define	kDrWatson			10
#define	kHelpMsg			11
#define	kExitMsg			12

/*	1.01 - kTopLeft - This is for positioning the Disk Initialization dialogs. */

#define kDITop					0x0050
#define kDILeft					0x0070

/*	1.01 - kMinHeap - This is the minimum result from the following
	equation:
		
		ORD(GetApplLimit) - ORD(ApplicZone)
		
	for the application to run. It will insure that enough memory will
	be around for reasonable-sized scraps, FKEYs, etc. to exist with the
	application, and still give the application some 'breathing room'.
	To derive this number, we ran under a MultiFinder partition that was
	our requested minimum size, as given in the 'SIZE' resource. */
	 
#define kMinHeap				21 * 1024
	
/*	1.01 - kMinSpace - This is the minimum result from PurgeSpace, when called
	at initialization time, for the application to run. This number acts
	as a double-check to insure that there really is enough memory for the
	application to run, including what has been taken up already by
	pre-loaded resources, the scrap, code, and other sundry memory blocks. */
	 
#define kMinSpace				400 * 1024

#define kMinSize	512				/* application's minimum size (in K) */
#define kPrefSize	718				/* application's preferred size (in K) */

/* kSysEnvironsVersion is passed to SysEnvirons to tell it which version of the
   SysEnvRec we understand. */

#define	kSysEnvironsVersion		1

/* kOSEvent is the event number of the suspend/resume and mouse-moved events sent
   by MultiFinder. Once we determine that an event is an osEvent, we look at the
   high byte of the message sent to determine which kind it is. To differentiate
   suspend and resume events we check the resumeMask bit. */

#define	kOSEvent				app4Evt	/* event used by MultiFinder */
#define	kSuspendResumeMessage	1		/* high byte of suspend/resume event message */
#define	kResumeMask				1		/* bit of message field for resume vs. suspend */
#define	kMouseMovedMessage		0xFA	/* high byte of mouse-moved event message */
#define	kNoEvents				0		/* no events mask */

/* kExtremeNeg and kExtremePos are used to set up wide open rectangles and regions. */

#define kExtremeNeg				-32768
#define kExtremePos				32767 - 1 /* required to address an old region bug */

/* these #defines are used to set enable/disable flags of a menu */

#define AllItems	0b1111111111111111111111111111111	/* 31 flags */
#define NoItems		0b0000000000000000000000000000000
#define MenuItem1	0b0000000000000000000000000000001
#define MenuItem2	0b0000000000000000000000000000010
#define MenuItem3	0b0000000000000000000000000000100
#define MenuItem4	0b0000000000000000000000000001000
#define MenuItem5	0b0000000000000000000000000010000
#define MenuItem6	0b0000000000000000000000000100000
#define MenuItem7	0b0000000000000000000000001000000
#define MenuItem8	0b0000000000000000000000010000000
#define MenuItem9	0b0000000000000000000000100000000
#define MenuItem10	0b0000000000000000000001000000000
#define MenuItem11	0b0000000000000000000010000000000
#define MenuItem12	0b0000000000000000000100000000000
