
#include "Types.r"
#include "SysTypes.r"

#include "Resource.h"

resource 'vers' (1, "Windows") {
	0x03, 0x00, release, 0x0,
	verUs,
	"3.0",
	"3.0 by Bob Spence"
};

resource 'vers' (2, "Windows") {
	0x03, 0x00, release, 0x0,
	verUs,
	"3.0",
	"  for the Macintosh"
};

resource 'BNDL' (128) {
	'MsWn',
	0,
	{
		'FREF', { 0, 128 },
		'ICN#', { 0, 128 }
	}
};

resource 'FREF' (128) {
	'APPL',
	0,
	""
};

data 'MsWn' (0, "Owner resource") {
	"3.0 by Bob Spence"
};


resource 'MENU' (mApple, "Apple", preload) {
	mApple, textMenuProc,
	AllItems & ~MenuItem2,	/* Disable dashed line, enable About and DAs */
	enabled, apple,
	{
		"About Windows",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (mFile, "File", preload) {
	mFile, textMenuProc,
	AllItems,				/* everything */
	enabled, "File",
	{
		"Program Manager",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Soft SoundBlaster",
			noicon, nokey, check, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Quit",
			noicon, "Q", nomark, plain;
	}
};

resource 'MENU' (mEdit, "Edit", preload) {
	mEdit, textMenuProc,
	NoItems,				/* disable everything, program does the enabling */
	enabled, "Edit",
	 {
		"Undo",
			noicon, "Z", nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Cut",
			noicon, "X", nomark, plain;
		"Copy",
			noicon, "C", nomark, plain;
		"Paste",
			noicon, "V", nomark, plain;
		"Clear",
			noicon, nokey, nomark, plain
	}
};

resource 'MENU' (mWinFile, "File", preload) {
	mWinFile, textMenuProc,
	NoItems + MenuItem10,	/* just logout */
	enabled, "File",
	{
		"New",
			noicon, nokey, nomark, plain;
		"Open",
			noicon, nokey, nomark, plain;
		"Move",
			noicon, nokey, nomark, plain;
		"Copy",
			noicon, nokey, nomark, plain;
		"Delete",
			noicon, nokey, nomark, plain;
		"Properties",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Run",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Logoff	Alt+F4",
			noicon, nokey, nomark, plain;
	}
};

resource 'MENU' (mOptions, "Options", preload) {
	mOptions, textMenuProc,
	AllItems,	/* Disabled separators */
	enabled, "Options",
	{
		"Auto Arrange",
			noicon, nokey, check, plain;
		"Minimize on Use",
			noicon, nokey, nomark, plain;
		"Save Settings on Exit",
			noicon, nokey, check, plain;
	}
};

resource 'MENU' (mWindow, "Window", preload) {
	mWindow, textMenuProc,
	AllItems,	/* and Disabled separators */
	enabled, "Window",
	{
		"Cascade	Shift+F5",
			noicon, nokey, nomark, plain;
		"Tile",
			noicon, nokey, nomark, plain;
		"Arrange Icons",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"1 Main",
			noicon, nokey, nomark, plain;
		"2 Accessories",
			noicon, nokey, nomark, plain;
		"3 Applications",
			noicon, nokey, nomark, plain;
		"4 Games",
			noicon, nokey, nomark, plain;
	}
};

resource 'MENU' (mHelp, "Help", preload) {
	mHelp, textMenuProc,
	AllItems,	/* and Disabled separators */
	enabled, "Help",
	{
		"Index",
			noicon, nokey, nomark, plain;
		"Keyboard",
			noicon, nokey, nomark, plain;
		"Commands",
			noicon, nokey, nomark, plain;
		"Procedures",
			noicon, nokey, nomark, plain;
		"Glossary",
			noicon, nokey, nomark, plain;
		"Using Help",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"About",
			noicon, nokey, nomark, plain;
	}
};

resource 'MENU' (mMines, "Game", preload) {
	mMines, textMenuProc,
	AllItems & ~(MenuItem6 + MenuItem10),	/* and Disabled separators */
	enabled, "Game",
	{
		"New Game",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Beginner",
			noicon, nokey, nomark, plain;
		"Intermediate",
			noicon, nokey, check, plain;
		"Expert",
			noicon, nokey, nomark, plain;
		"Custom",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Marks",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Best Times",
			noicon, nokey, nomark, plain;
	}
};

resource 'MENU' (mMineHelp, "Help", preload) {
	mMineHelp, textMenuProc,
	AllItems,	/* Disabled separators */
	enabled, "Help",
	{
		"How to Play",
			noicon, nokey, nomark, plain;
		"Commands",
			noicon, nokey, nomark, plain;
		"Using Help",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"About WinMines",
			noicon, nokey, nomark, plain;
	}
};

resource 'MENU' (mControl, "Control", preload) {
	mControl, textMenuProc,
	AllItems & ~(MenuItem2 + MenuItem3 + MenuItem9),	/* Disabled separators */
	enabled, "Control",
	{
		"Restore",
			noicon, nokey, nomark, plain;
		"Move",
			noicon, nokey, nomark, plain;
		"Size",
			noicon, nokey, nomark, plain;
		"Minimize",
			noicon, nokey, nomark, plain;
		"Maximize",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Close",
			noicon, nokey, nomark, plain;
		"-",
			noicon, nokey, nomark, plain;
		"Switch To	Ctrl+Esc",
			noicon, nokey, nomark, plain;
	}
};


resource 'WIND' (rWindow, "Windows") {
	{50, 80, 50, 80},
	plainDBox, invisible, noGoAway, 0x0, "Windows"
};


/* this ALRT and DITL are used as an error screen */

resource 'ALRT' (rUserAlert, purgeable) {
	{40, 20, 120, 260},
	rUserAlert,
	{ /* array: 4 elements */
		/* [1] */
		OK, visible, silent,
		/* [2] */
		OK, visible, silent,
		/* [3] */
		OK, visible, silent,
		/* [4] */
		OK, visible, silent
	}
};


resource 'DITL' (rUserAlert, purgeable) {
	{ /* array DITLarray: 3 elements */
		/* [1] */
		{50, 150, 70, 230},
		Button {
			enabled,
			"OK"
		},
		/* [2] */
		{10, 60, 30, 230},
		StaticText {
			disabled,
			"Microsoft Windows - Error occurred!"
		},
		/* [3] */
		{8, 8, 40, 40},
		Icon {
			disabled,
			2
		}
	}
};

resource 'STR#' (rTitleStr, "Title") {
	{
		"Invalid Path",
		"Invalid Path",
		"Invalid Path",
		"Application Execution Error",
		"Application Execution Error",
		"Application Execution Error",
		"Application Execution Error",
		"Cannot Run Program",
		"Terminal - Error",
		"Dr. Watson",
		"Windows Help",
		"Exit Windows",
		".",
		".",
	}
};

resource 'STR#' (rTextStr, "Text") {
	{
		"\nThe path C:\\BIN\\ROOTGDI.PIF is invalid.",
		"\nThe working directory is invalid.",
		"Cannot find file (or one of its components).\n\n"
			"Make sure the path and filenames are correct\n"
			"and that all required libraries are available.",
		"Application Error.\n\n"
			"CLOCK caused a General Protection Fault in\n"
			"module CLOCK.EXE at 0001:0D8E.",
		"Unanticipated Application Exception.\n\n"
			"Faults of this type have been renamed\n"
			"for Windows 3.1.",
		"No application is associated with this file.\n\n"
			"Choose associate from the File menu to\n"
			"create an association.",
		"Insufficient memory to run this application.\n\n"
			"Quit one or more Windows applications and\n"
			"then try again.",
		"The application you are about to run was \n"
			"designed to run with Windows 2.0\n\n"
			"Obtain an updated version for Windows 3.0",
		"The selected COM port is either not supported\n"
			"or is being used by another device.\n\n"
			"Select another port.",
		"Your 'Dr. Watson' log file 'c:\\drwatson.log'\n"
			" is getting quite large.",
		"Incompatable Help file.\n\n"
			"Obtain an updated version for Windows 3.0",
		"\nThis will end your windows session.",
		"\n.",
		"\n.",
	}
};

resource 'DLOG' (rCustom, "Custom") {
	{90, 100, 180, 410},
	dBoxProc, invisible, noGoAway, 0x0, rCustom, "Custom"
};


resource 'DITL' (rCustom) {
	 {
/* 1 */ {60, 167, 81, 244},
		button {
			enabled,
			"OK"
		};
/* 2 */ {5, 10, 60, 300},
		staticText {
			disabled,
			"Custom\n"
			"Bounds."
		}
	}
};

resource 'DLOG' (rBestTimes, "Best Times") {
	{90, 100, 180, 410},
	dBoxProc, invisible, noGoAway, 0x0, rBestTimes, "Best Times"
};


resource 'DITL' (rBestTimes) {
	 {
/* 1 */ {60, 167, 81, 244},
		button {
			enabled,
			"OK"
		};
/* 2 */ {5, 10, 60, 300},
		staticText {
			disabled,
			"Best \n"
			"Times."
		}
	}
};


/* here is the quintessential MultiFinder friendliness device, the SIZE resource */

resource 'SIZE' (-1) {
	dontSaveScreen,
	acceptSuspendResumeEvents,
	enableOptionSwitch,
	canBackground,				/* we can background; we don't currently, but our sleep value */
								/* guarantees we don't hog the Mac while we are in the background */
	multiFinderAware,			/* this says we do our own activate/deactivate; don't fake us out */
	backgroundAndForeground,	/* this is definitely not a background-only application! */
	getFrontClicks,				/* change this is if you want "do first click" behavior like the Finder */
	ignoreChildDiedEvents,		/* essentially, I'm not a debugger (sub-launching) */
	not32BitCompatible,			/* this app should not be run in 32-bit address space */
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	reserved,
	kPrefSize * 1024,
	kMinSize * 1024	
};

