#include <Types.h>
#include <Resources.h>
#include <Quickdraw.h>
#include <QDOffscreen.h>
#include <Palette.h>
#include <Fonts.h>
#include <Events.h>
#include <Windows.h>
#include <Menus.h>
#include <TextEdit.h>
#include <Dialogs.h>
#include <Desk.h>
#include <ToolUtils.h>
#include <Memory.h>
#include <SegLoad.h>
#include <Files.h>
#include <OSUtils.h>
#include <OSEvents.h>
#include <DiskInit.h>
#include <Packages.h>
#include <Traps.h>
#include "Resource.h"

/* Define HiWrd and LoWrd macros for efficiency. */
#define HiWrd(aLong)	(((aLong) >> 16) & 0xFFFF)
#define LoWrd(aLong)	((aLong) & 0xFFFF)

/* Define TopLeft and BotRight macros for convenience. Notice the implicit
   dependency on the ordering of fields within a Rect */
#define TopLeft(aRect)	(* (Point *) &(aRect).top)
#define BotRight(aRect)	(* (Point *) &(aRect).bottom)


#define kMaxMasters	8		// MoreMasters() Blocks

struct MSIconRecord {
	struct MSIconRecord *next;
	struct MSChildRecord *group;
	struct MSChildRecord *restore;
	struct MSWindowRecord *app;
	short		id;
	short		selected;
	short		action;
	Rect		iconBox;
	Rect		textBox;
};
typedef struct MSIconRecord MSIconRecord;
typedef MSIconRecord *MSIconPtr;

struct MSMenuRecord {
	struct MSMenuRecord *next;
	MenuHandle	menu;
	Rect		box;
	Str31		text;
};
typedef struct MSMenuRecord MSMenuRecord;
typedef MSMenuRecord *MSMenuPtr;

struct MSChildRecord {
	struct MSChildRecord *next;
	struct MSWindowRecord *window;
	MSMenuPtr	menu;
	MSIconPtr	icon;
	MSIconPtr	iconList;
	Rect		portRect;
	Point		origin;
	Rect		restoreRect;
	Point		restoreOrigin;
	short		active;
	short		minmax;
	short		maximized;
	short		growBorder;
	Rect		controlMenuRect;
	Rect		menuBarRect;
	Rect 		controlMenuBox;
	Rect 		maximizeBox;
	Rect		minimizeBox;
	Str31		title;
};
typedef struct MSChildRecord MSChildRecord;
typedef MSChildRecord *MSChildPtr;

struct MSWindowRecord {
	WindowRecord window;
	MSChildPtr	child;
	MSIconPtr	icon;
};
typedef struct MSWindowRecord MSWindowRecord;
typedef MSWindowRecord *MSWindowPtr;

#define MSWindow	((MSWindowPtr)window)

/* Constants */

#define kOffscreenOffset	0x4000

#define kNoMinMax			0
#define kMinMax				1

#define vWHITE				0x0FFFF
#define vLTGRAY				0x0C000
#define vGRAY				0x08000
#define vDKGRAY				0x04000
#define vBLACK				0x00000

//	Minesweeper Picts
#define kButtonPict				128		// Unpressed button
#define kEmptyPict				129		// Pressed button
#define kNumPict				140		// Microsoft numbers
#define kNum2Pict				130		// More numbers
#define kFlagPict				150		// Flagged mine
#define kBombPict				151		// Unexploded mine
#define kBoomPict				152		// The hit mine
#define kBadPict				153		// Wrong flag guess
#define kMarkPict				154		// Unknown flag
#define kLCDPict				160		// LCD numbers
#define kHappyFace				170		// Smile face
#define kPressedFace			171		// Smile face, pressed
#define kOwFace					172		// Smile face, owww 
#define kSadFace				173		// Sad face

//	Windows Application Icons
#define	kProgramManager			300		// windows icon ??

#define	kMain					300
#define	kControlPanel			201
#define	kFileManager			202
#define	kDosPrompt				203
#define	kClipboard				204
#define	kPrintManager			205

#define	kAccessories			301
#define	kNotepad				210
#define	kCalendar				211
#define	kPaintbrush				212
#define	kCalculator				213
#define	kCardfile				214
#define	kClock					215

#define	kGames					302
#define kMinesweeper			241
#define kSolitare				242
#define kReversi				243

#define	kApplications			303
#define	kTerminal				216

#define	kCautionIcon			250
#define	kErrorIcon				251
#define	kInfoIcon				252

#define kOKButton				259		// OK button

//	Windows Cursors
#define	kHoriCursor				128
#define	kVertCursor				129
#define	kDRightCursor			130
#define	kURightCursor			131
#define	kArrowCursor			132
#define	kMoveCursor				133

#define kMaxPict				400

//	Window actions
#define vMaximize		1
#define vMinimize		2
#define vRestore		3

//	Window definition
#define kGrowBorder		4
#define kIconSize		32
#define kIconLineHeight	12
#define kIconHdr		12
#define kIconStepH		100
#define kIconStepV		60
#define kIconXOffset (kGrowBorder + (kIconStepH - kIconSize) / 2)

#define kOKBoxW			64
#define kOKBoxH			32

//	Window Icons
#define kMenuHeight				19
#define kPictHeight		(kMenuHeight + kGrowBorder)
#define kPictWidth				22
#define kPictWidth2				18
#define	kMenuBox				220
#define	kMaximizeBox			221
#define	kMinimizeBox			222
#define	kRestoreBox				225
#define kNoBox					223
#define	kPressOffset			10
#define	kInactiveOffset			100
#define	kTop					224
#define	kBottomLeft				226
#define	kBottomRight			227

//	Game window border definition
#define kBox			16
#define kBorderTop	(kPictHeight + kMenuHeight + 1)
#define kBorder1		3
#define kBorder2		6
#define kBorder3		3
#define kBorder		(kBorder1 + kBorder2 + kBorder3)
#define kBorder3h	(kBorder3 - 1)
#define kBorderLCD		4
#define kHeightLCD		32
#define kWidthLCD		18
#define kInsetLCD	((kBorder - 1) + kBorderLCD)
#define kHdrSize	(kBorderTop + kInsetLCD + kHeightLCD + kBorderLCD + kBorder3h + kBorder2 + kBorder3)

//	Game table values
#define minefield(r,c) 	pMineField[(r) * cols + (c)]
#define mineview(r,c) 	pMineView[(r) * cols + (c)]
#define	kNumMask		0x0F
#define	kMine			0x10
#define	kFlag			0x20
#define	kNoFlag			0x40

/* Prototypes */

//	Application routines called from the shell
Boolean InitializeApp(void);
void InstallMenus(WindowPtr window);
void SetUpMenus(void);
void DoMenuCommand(MSChildPtr MSChild,MenuHandle hMenu,long mResult);
Boolean PtInGame(Point where);
Boolean ContentClick(EventRecord *event,WindowPtr window);
void DrawPict(short id,short *x,short *y);
void DrawCell(short id,Rect *box);
void DrawIcon(MSIconPtr icon,short active);
void DrawWindow(WindowPtr window);
void GameTime(void);
void GetDragRect(WindowPtr window,Rect *dragRect);
Boolean DragChild(WindowPtr window,Point where);

//	Shell routines called from the application
Boolean IsAppWindow( WindowPtr window );
Boolean IsDAWindow( WindowPtr window );
void CountClicks(EventRecord *macEvent);
MSChildPtr GetFirstChild(MSWindowPtr window);
void BringChildFront(WindowPtr window,Point where,Boolean doUpdate);
void SetCursorRgns();
void SizeMSWindow(MSChildPtr MSChild);
Boolean DoCloseWindow( WindowPtr window );
void Terminate(void);

//	Application routines called within the application
void Initialize(void);
void EventLoop(void);
void CreateGWorld(Rect *bounds);
void DrawGame(BitMap *pixMap);
void SaveBits(WindowPtr window);
void DrawMSWindow(WindowPtr	window);
void DrawAlertWindow(WindowPtr	window);
void DrawMineWindow(WindowPtr window);
void NewGame(Boolean resize);
unsigned char minechar(short r,short c);
void InitGame(short rx,short cx);
void DrawFrame(void);
void DrawHdr(void);
void DrawMap(void);
void DrawNewMap(BitMap *pixMap);
void DrawCell(short id,Rect *box);
void ClickCell(Point where,short modifiers);
void ClickGame(Point where,short modifiers);
void ShowDialog(short dialogID);

//void DoCommand(long int mResult);
void DoMSCommand(MSChildPtr MSChild,short command);
void DoControlMenu(MSChildPtr MSChild,Point where);
void DoMenuBar(MSChildPtr MSChild,Point where);
void DoubleClickIcon(MSChildPtr MSChild,MSIconPtr icon);

void	PositionWindow( WindowPtr w );
Point	CenterWithin( Rect *r, Rect *within );
