#!/usr/local/bin/perl

# Copyright: 1993 University of Nevada
#
#  veronica server script version 0.6b  ;;  July 30, 1993.
#  Most of this code by Fred Barrie (barrie@unr.edu).
#  EDIT the paths below to reflect the locations of data files and
#      locking  ( tmp ) directory.
#  check the perl path above for conformance with your system.
#   the following comments are from the "how-to-install" file:

###################################################################
#Installing the veronica server and data  - June 24, 1993
#This installation doc applies to veronica server script version 0.5 only.
#
#This distribution:
#
#    This veronica server script is intended to be run with the
#    veronica data set obtainable by anonymous ftp from
#    veronica.scs.unr.edu, in folder veronica-data.
#
#    The data in that folder includes the cleaned and prepared veronica
#    database, and five files comprising the pre-built indexes.
#
#    This distribution supports AND, OR, NOT, and parens.
#
#    This distribution includes support for the -tX flag in 
#    veronica queries.  This flag stipulates that the search should
#    return only items whose gopher-item-type is X.
#
#    Support for the -l flag.  When specified the veronica server
#    will create a gopher readable gopher file.  The veronica server
#    acts like a gopher server when the link file needs to be returned.
#
#    Support for the -m flag.  This specifies how many gopher items to
#    return.  The format of the flag is -mX where X specifies a number.
#    If there is no number specified then there is no limit to the
#    number of hits.
#
#    This code uses a dbm file to index the letters of query words.
#    This distribution does not use the WAIS indexes.  This code
#    is considerable faster than the previous WAIS-indexed distribution.
#    
#
#This server::
#
#    Runs on most flavors of unix.
#    Needs about 300 MB online data storage  ( for May 18 dataset )
#    Needs perl v4, patch level 35 or above with dbm support 
#
#    Is intended to be run under inetd.  Most machines will be able
#    to run 5 to 15 concurrent searches.  Edit the script to limit
#    concurrent searches.
#    
#
#to install:
#
#1.  install the perl script "ver-server-0.6b.pl" in some convenient
#    directory on your system.    You can get this script via anonymous
#    ftp from veronica.scs.unr.edu, in folder "veronica-code".
#
#2.  edit your "/etc/inetd.conf" and "/etc/services"  files,
#    or equivalent, so the script will run under inetd.  use
#    port 2347; it seems to becoming the veronica default port.
#
#    Add a line like this to the inetd.conf file:
#
#  veronica  stream  tcp  nowait root  /usr/local/veronica/bin/ver-search-0.5-pl
#    
#    ...using the proper path for your installation.
#
#    And add a line like this to the services file:
#
#  veronica    2347/tcp    
#
#   NOTE that the # at the start of these two lines should not be
#   included in the inetd.conf and services files!  ;^)
#
#   Note that the script does not have to be run as root, and you may want
#   to run it as some other user.  that will be reflected in the
#   inetd.conf line ...  if you run as a non-privileged user, be sure
#   to check the read permissions on the data files and directory.
#
#3. Install the data in some directory on your system.  Get the dataset
#   by anonymous ftp from veronica.scs.unr.edu   ...  get all the files
#   from directory "veronica-data".  Most of these files have names
#   that look like IP numbers;  in addition there are five other files
#   which are the index files.  DO NOT change the names of any of these
#   files.
#
#4. Edit the script to specify the location of data directory, the 
#   "stoplist" file  ( which is in the data directory as ftp-ed ),
#   the log file, and the directory to be used for the lock files.
#
#5. Kick the inet daemon to make it read the new inetd.conf file.
#   This is usually done with "kill -HUP XXXXX", where XXXXX is the 
#   process ID of the inetd process.
#
#6. Edit the make-dbm file to specify where you placed the veronica files
#   and where you want the dbm files.
#
#7. Run the make-dbm file.  This will create the dbm files.  Everytime
#   You update the files from veronica.scs.unr.edu you will have to
#   run this program.
#
#8. It should work.  Test it by telnet to port 2347.  Enter a search query
#   and wait for the result.
#
#9. Register your server so it can be advertised.  Send mail to 
#   veronica@veronica.scs.unr.edu ; give us your Hostname and port
#   number and we will put it on the menus of gophers which advertise
#   veronica searches.
#
#  If you have *ANY* problem please email veronica@comics.scs.unr.edu or
#  call (702) 784-4294

sub Initialize
{
    alarm ('30');
    # Total number on concurrent veronica users
    $MaxConnections = 2;
    
    # The default value for number of gopher items to be returned
    $MaxHits        = 200;

    # Message returned if there are too many concurrent users
    $Bummer = "0*** Too many connections - Try again soon. ***\terror\terror\t0\r\n.\r\n";

    # Root level for the veronica software. 
###$veronicaPort
    # Directory where the veronica data files live
###$DataDir
    # Directory where the veronica dbm files are kept 
###$EtcDir

    # Where the Stop List exists
###$StopList

    # Where do I log the queries?   Undefine if you don't want to log
    # queries.
###$Log
    # Actually the minimum time to keep .link files.  This number is
    # the fraction of one day (10 minutes)
    $MaxTime        = '6.944e-3';

    # Directory to store the lock files
    $LockDir        = '/tmp';

    # Directory to store the link files
    $LinkDir        = "/tmp";
    
    # This machines name:
###$veronicaServer

    # The port the script is running at
###$veronicaPort 

    #
    # End of editable options
    #

    $Version = '0.6b';
    $SIG{'PIPE'}    = '&Cleanup';
    select (STDERR); $| = 1;
    select (STDOUT); $| = 1;
    chdir ("$DataDir") || die "Unable to change to Data Directory: $!\n";
    %WordList = (    "and", "and",
                     "or",  "or",
                     "not", "not");
    if ($LinkDir)
    {    
        chop (@LinkFiles = grep (/^link/, `ls $LinkDir`));
        foreach (@LinkFiles)
        {
            $LinkTime = (-M "$LinkDir/$_");
            if ($LinkTime > $MaxTime)
            {
                unlink "$LinkDir/$_";
            }
        }
    }
}


#
# Start of the real work
#

    &Initialize;                           # Initialize veronica

    $Input = &ReadQuery;                   # Read in query from user

    &CLock('+');                           # Make lock file and check number
                                           #  of users

    &ReadStop;                             # Read in %Stop 

    &ReadData;                             # Read in %FileNum and %LetterOffset
 
    alarm ('60');
    &SplitWords($Input);                   # Split the input and look up
                                           #  the gopher items for each
                                           #  word

    $InWord = &ParseInput($Input);         # Read each character of the $Input
                                           #  and deceide the logic of the
                                           #  query.  $InWord would be true
                                           #  if the last character of the
                                           #  $Input is in a word.

    if ($InWord)                           # If $InWord then push the last
    {                                      #  word in the $Input onto the
        &PushWord ($QueryWord);            #  queue
    }

    &PushBack;                             # Function to combine words in
                                           #  $Input via "and" "or" or "not"

    alarm ('0');
    &PrintItems;                           # Print gopher items

    if ($Log)
    {
        &LogData ($Input);                 # Log veronica query
    }

    &Cleanup;                              # Close connections and exit

    exit;                                  # Should never get here


# Subfunction ReadQuery 
#
# Purpose:    Read the query from the user and determines what flags are
#             set.
#
# Variables:  $Input     - The input from the user
#             $StartDate - The time when the search started
#             $RawQuery  - The tmp line used to determine the set flags
#             $GTypes    - The gopher type reguested from -t flag
#             $TypeFlag  - True if -t set
#             $MaxHits   - Total number of hits defined by -m flag
#             $OverRideMaxHits - True if user wants unlimited hits
#             $Link      - True if -l set

sub ReadQuery
{
    local ($Input, $Host);
    chop ($StartDate = `date`);
    chop ($Input = <STDIN>);
    chop ($Input);
    $Input =~ s/^\t//;
    print FirstLog "$$ $Input\n";
    $RawQuery = $Input;
    if ($RawQuery =~ /^-r (.*)/)
    {
        &ReadLink($1);
        &Cleanup;
    }
    if ($RawQuery =~ /-u\s*(.*)$/)
    {
        $Host = $1;
        $Host =~ s/\s+$//;
        &LastUpdate($Host);
        exit;
    }
    if ($RawQuery =~ /-v(.*)/)
    {
        &VFlag($1);
        exit;
    }
    if ($RawQuery =~ /(.*)\s?-t([^ ]*)\s*(.*)/)
    {
        $GTypes = $2;
        $Input = "$1$3";
        if (defined ($GTypes)) { $TypeFlag = 1;}
        $RawQuery = $Input;
    }
    if ($RawQuery =~ /(.*)\s?-D([^ ]*)\s*(.*)/)
    {
        $NotDomain = $2;
        $Input = "$1$3";
        if ($NotDomain) {$NotDomainFlag = 1;}
        $RawQuery = $Input;
    }
    if ($RawQuery =~ /(.*)\s?-d([^ ]*)\s*(.*)/)
    {
        $Domain = $2;
        $Input = "$1$3";
        if ($Domain) {$DomainFlag = 1;}
        $RawQuery = $Input;
    }
    if ($RawQuery =~ /(.*)\s?-n([^ ]*)\s*(.*)/)
    {
        $NotTypes = $2;
        $Input = "$1$3";
        if (defined ($NotTypes)) {$NotFlag = 1;}
        $RawQuery = $Input;
    }
    if ($RawQuery =~ /(.*)\s?-m([^ ]*)\s*(.*)/)
    {
        $MaxHit = $2;
        $Input = "$1$3";
        if (!$MaxHit) { $OverRideMaxHits = 1;}
        if ($MaxHit =~ /^\?$/)
        {
            print "0*** Default Max Hits is: $MaxHits ***\terror\terror\t0\r\n";
        }
        else
        {
            $MaxHits = $MaxHit;
        }
        $RawQuery = $Input;
    }
    if ($RawQuery =~ /(.*)\s?-l\s*(.*)/)
    {
        $Input = "$1$2";
        if ($LinkDir)
        {
            $Link = 1;
        }
        else
        {
            print "0*** This server does not provide link files ***\terror\terror\t0\r\n";
        }
    }
    $Input =~ tr/\///;
    $Input =~ s/^\s+//;
    $Input =~ tr/A-Z/a-z/;
    return ($Input);
}

# Subfunction ReadLink
#
# Purpose:    Returns a link file
#
# Variables:  $Link    - File to be returned
#             $LinkDir - Directory where link files are created

sub ReadLink
{
    local ($Link) = @_;
    open (LINK, "$LinkDir/$Link");
    while (<LINK>)
    {
        print $_;
    }
    print ".\r\n";
}


# Subfunction ReadStop 
#
# Purpose:    Read in %Stop from disk
#
# Variables:  %Stop - A global variable for quick look up of words in the
#                     stop list

sub ReadStop
{
        open (STOP, "$StopList");
        while (<STOP>)
        {
                chop;
                $Stop{$_} = 1;
        }
        close (STOP);
}

# Subfunction ReadData 
#
# Purpose:    Read in %FileNum and %LetterOffset
#
# Variables:  $veronicaRoot - location of root of veronica info

sub ReadData
{
    dbmopen (FileNum, "$EtcDir/FileNum", "undef");
    dbmopen (LetterOffset, "$EtcDir/Offset", "undef");
}

# Subfunction SplitWords 
#
# Purpose:    Split the $Input into the individual words and look up the
#             hits for each word 
#
# Variables:  $Input    - The string entered by the user
#             @Words    - An array of the words in the $Input
#             %WordList - A list of all hits for each word

sub SplitWords
{
    local ($Input) = @_;
    local (@Words);
    @Words = split (/[^a-zA-Z0-9_\*]/, $Input);
    foreach (@Words)
    {
        if (($_ !~ /^$/) && ($_ !~ /^(and|or|not)$/) && (!$WordList{$_}))
        {
            if ($_ =~ /(.*)\*/)
            {
                $WordList{$1} = &Lookup($_);
            }
            else
            {
                $WordList{$_} = &Lookup($_);
            }
        }
    }
}

# Subfunction Lookup 
#
# Purpose:    Given a word look up the list of gopher items from the
#             Data file
#
# Variables:  $Word     - The first list
#             $Stemming - True if word is followed by an *
#             $Letters  - The first five letters of the word
#             $Offset   - The offset into the Data file
#             $TMPLine  - A temp line from the Data file
#             $TmpWord  - A temp word for stemming purposes
#             $Itmes    - A list of gopher items for a word
#             $BigItems - A list of gopher items for a stemming word

sub Lookup
{
    local ($Word) = @_;
    local ($Stemming, $Letters, $Offset, $TMPLine);
    local ($TmpWord, $Items, $BigItems);
    if ($Word =~ /(.*)\*$/)
    {
        $Word = $1;
        $Stemming = 1;
    }
    else
    {
        if ($Stop{$Word})
        {
            print "0*** The word \"$Word\" is too common a word and is not indexed ***\terror\terror\t0\r\n";
            return ('stop');
        }
    }
    $Letters = substr ($Word, 0, 5);
    $Offset = $LetterOffset{$Letters};    
    open (DATA, "Data");
    seek (DATA, $Offset, 0);
    $TMPLine = <DATA>;
    if ($Stemming)
    {
        while (($TMPLine =~ /^$Letters/) && ($TMPLine !~ /^$Word/))
        {
            $TMPLine = <DATA>;
        }
        return ('') unless ($TMPLine =~ /^$Word/);
        chop $TMPLine;
        ($TmpWord, $Items) = split (/:/, $TMPLine);
        $BigItems .= $Items;
        while (($TMPLine = <DATA>) =~ /^$Word/)
        {
            chop $TMPLine;
            ($TmpWord, $Items) = split (/:/, $TMPLine);
            $BigItems .= $Items;
        }
        return ($BigItems);
    }
    else
    {
        while (($TMPLine =~ /^$Letters/) && ($TMPLine !~ /^$Word/))
        {
            $TMPLine = <DATA>;
        }
        if ($TMPLine !~ /^$Word:/) { return ('');}
        chop $TMPLine;
        ($Word, $Items) = split (/:/, $TMPLine);
        close (DATA);
        return ($Items);
    }
}

# Subfunction ParseInput 
#
# Purpose:    Reads every letter and deceides the logic of the query
#
# Variables:  $Input  - The input from the user
#             $Letter - A letter in the $Input
#             $InWord - True if the $Letter is in a "word"
#             @Queue  - Queue for intermedite results

sub ParseInput
{
    local ($Input) = @_;
    local ($Letter);
    local ($InWord);
    for ($i = 0; $Letter = substr ($Input, $i, 1); $i++)
    {
        if (($InQuote) && ($Letter !~ /\"/))
        {
            $QuoteString .= $Letter;
        }
        if ($Letter =~ /\(/)
        {
            push (@Queue, '(');
        }
        elsif ($Letter =~ /\"/)
        {
            if ($InQuote)
            {
                push (@Quote, $QuoteString);
                undef ($QuoteString);
                &PushWord($QueryWord);
                $InWord = 0;
                &PushBack;
                $InQuote = 0;
            }
            else
            {
                push (@Queue, '(');
                $InQuote = 1;
                $Quote = 1;
            }
        }
        elsif ($Letter =~ /[\s\-\_\.\?]/)
        {
            &PushWord($QueryWord);
            $InWord = 0;
        }
        elsif ($Letter =~ /\)/)
        {
            &PushWord($QueryWord);
            $InWord = 0;
            &PushBack;
        }    
        elsif ($Letter =~ /\*/)
        {
            next;
        }
        else
        {
            if (!$InWord)
            {
                $QueryWord = $Letter;
                $InWord = 1;
            }
            else 
            {
                $QueryWord .= $Letter;
            }
        }
    }
    return ($InWord);
}

# Subfunction PushWord 
#
# Purpose:    Given two lists, "List1" and "List2", the subfunction will
#
# Variables:  $List1 - The first list

sub PushWord
{
    local ($QueryWord) = @_;
    if (($QueryWord) && ($InWord))
    {
        push (@Queue, $WordList{$QueryWord});
    }
}

# Subfunction Not 
#
# Purpose:    Given two lists, "List1" and "List2", the subfunction will
#
# Variables:  $List1 - The first list

sub PushBack
{
    $LastIn = pop (@Queue);
    $NexttoLast = pop (@Queue);
    if ($NexttoLast =~ /^\n?$/)
    {
        push (@Queue, $LastIn); return;
    }
    if (($NexttoLast !~ /^(and|or|not)$/))
    {
        if ($LastIn eq 'stop') {push (@Queue, $NexttoLast); &PushBack; return;}
        if ($NexttoLast eq 'stop') {push (@Queue, $LastIn); &PushBack; return;}
        $Result = &And ($NexttoLast, $LastIn);
    }
    else
    {
        $ThirdfromLast = pop (@Queue);
        if ($NexttoLast =~ /^and/)
        {
            if ($LastIn eq 'stop') {push (@Queue, $ThirdfromLast); &PushBack;}
            if ($ThirdfromLast eq 'stop') {push (@Queue, $LastIn); &PushBack;}
            $Result = &And ($ThirdfromLast, $LastIn);
        }    
        elsif ($NexttoLast =~ /^or/)
        {
            $Result = &Or ($ThirdfromLast, $LastIn);
        }    
        elsif ($NexttoLast =~ /^not/)
        {
            $Result = &Not ($ThirdfromLast, $LastIn);
        }    
    }
    $IsitRight = pop (@Queue);
    if (($IsitRight !~ /\(/) && ($IsitRight !~ /^$/))
    {
        push (@Queue, $IsitRight); 
        push (@Queue, $Result);
        &PushBack;
    }
    else 
    {
        push (@Queue, $Result);
    }
}

# Subfunction PrintItems 
#
# Purpose:    Print the gopher items

sub PrintItems
{
    local (@PrintableItems, $NumberofItems);
    if ($Link) 
    {
        open (LINK, "> $LinkDir/link.$$");
        print "0*** Link info for $Input ***\t-r link.$$\t$veronicaServer\t$veronicaPort\r\n";
    }
    $Items = pop (@Queue);
    if ($Items eq '') { print "0*** Your search on \"$Input\" returned nothing***\terror\terror\t0\r\n";}
    @PrintableItems = split (/\|/, $Items);
    $NumberofItems = @PrintableItems;
    foreach (@PrintableItems)
    {
        if (($NumberofHits < $MaxHits) || $OverRideMaxHits)
        {
            ($FileNumber, $Length, $Offset) = split (/\s+/);
            if ($FileNumber != $OpenFile)
            {
                open (FILE, "$FileNum{$FileNumber}");
                $OpenFile = $FileNumber;
            }
            seek (FILE, int ($Offset), 0);
            read (FILE, $GopherItem, int ($Length));
            next unless ($GopherItem);
            if ($Quote)
            {
                ($First, $Remainder) = split(/\t/, $GopherItem);
                $Title = substr($First, 1);
                foreach (@Quote)
                {
                    if ($Title !~ /$_/i)
                    {
                        $BadItem = 1;
                        last;
                    }
                }
            }
            if ($BadItem)
            {
                $BadItem = 0;
                next;
            }    
            if ($TypeFlag)
            {
                if ($GopherItem !~ /^[$GTypes]/)
                {
                    next;
                }
            }
            if ($NotDomainFlag)
            {
                if ($GopherItem =~ /$NotDomain\t/i)
                {
                    next;
                }
            }
            if ($DomainFlag)
            {
                if ($GopherItem !~ /$Domain\t/i)
                {
                    next;
                }
            }
            if ($NotFlag)
            {
                if ($GopherItem =~ /^[$NotTypes]/)    
                {
                    next;
                }
            }
            if (! print "$GopherItem\r\n") { &Cleanup; }
            $NumberofHits++;
            if ($Link)
            {
                ($Desc, $Path, $Host, $Port) = split (/\t/, $GopherItem);
                $Type = substr ($Desc, 0, 1);
                $Name = substr ($Desc, 1);
                print LINK "Type=$Type\n";
                print LINK "Name=$Name\n";
                print LINK "Path=$Path\n";
                print LINK "Host=$Host\n";
                print LINK "Port=$Port\n";
                print LINK "#\n";
            }    
            undef ($GopherItem);
        }
        else
        {
            $RemainingItems = $NumberofItems - $MaxHits;
            print "0** There are $RemainingItems more items matching the query \"$Input\" available **\terror\terror\t0\r\n";
            last;
        }
    }
    print ".\r\n";
}

# Subfunction LogData 
#
# Purpose:    Log veronica queries
#
# Variables:  $Log          - Log file
#             $EndDate      - Time when query ended
#             $RawQuery     - Query user entered originally
#             $StartDate    - Time when query started
#             $NumberofHits - Total number of hits

sub LogData
{
    if (!$NumberofHits) {$NumberofHits = 0; }
    open (LOG, ">> $Log");
    chop ($EndDate = `date`);
    print LOG "$RawQuery\t$StartDate\t$EndDate\t$NumberofHits\r\n";
    close LOG;
}

# Subfunction CLock 
#
# Purpose:    Locking algorithm

sub CLock
{
    local ($Operator) = @_;
    local ($ConnectionCounter);
    &Wait_CLock;
    &CalcLoad;
    $HowOldCounter = (-M "$LockDir/connect-counter.testing");
    if ((-e "$LockDir/connect-counter.testing") && ($HowOldCounter < $MaxTime))
    {
        open (Counter, "$LockDir/connect-counter.testing");
        chop ($ConnectionCounter = <Counter>);
        close (Counter);
        if (($ConnectionCounter < $MaxConnections) &&
            ($Operator eq '+'))
        {
            $ConnectionCounter++;
        }
        elsif (($ConnectionCounter > 0) &&
                ($Operator eq '-'))
        {
            $ConnectionCounter--;
        }
        else
        {
            print $Bummer;
            close (STDOUT);
            unlink "$LockDir/connect-lock.testing";
            exit;
        }
        open (Counter, "> $LockDir/connect-counter.testing");
        print Counter "$ConnectionCounter\n";
        close (Counter);
    }
    else
    {
        open (Counter, "> $LockDir/connect-counter.testing");
        if ($Operator eq '+')
        {
            print Counter "1\n";
        }
        else
        {
            print Counter "0\n";
        }
        close (Counter);
    }
    unlink "$LockDir/connect-lock.testing";
}

# Subfunction Wait_Clock 
#
# Purpose:    Creates a lock file
#
# Variables:  $Conlock -
#             $ConPID  - PID of process
#             $LockDir - Directory of lock file
#

sub Wait_CLock    
{
    local ($Conlock, $ConPID);
    WAIT:
    {
        while ( -e "$LockDir/connect-lock.testing")
        {
            sleep 1;
        }
        `touch $LockDir/connect-lock.testing`;
        open (Conlock, "$LockDir/connect-lock.testing");
        chop ($ConPID = <Conlock>);
        close (Conlock);
        if (($ConPID) && ($ConPID ne $$))
        {
            redo WAIT;
        }
    }
    open (Conlock, "> $LockDir/connect-lock.testing");
    print Conlock "$$\n";
    close (Conlock);
}

sub CalcLoad
{
    1;
}
# Subfunction Cleanup 
#
# Purpose:    Close connection and exit
#
# Variables:  $LockDir - Directory of the lock file 

sub Cleanup
{
    shutdown (STDIN, 2);
    close (STDIN);
    shutdown (STDOUT, 2);
    close (STDOUT);
    &CLock ('-');
    undef &CLock;
    unlink "$LockDir/connect-lock.testing";
    exit;
}

# Subfunction VFlag 
#
# Purpose:    Return information when the -v flag is set
#
# Variables:  $Input - The options set after the v flag.
#             $Question - -v? return version and variables
#             $MaxCons  - -vc return max connections
#             $ShowMaxHits  - -vm return max hits
#             $Load     - -vl return version and load
#             $ShowVer  - -vv return version
#             $Servers  - -vs return known servers
#             $ShowLog  - -vo return Logs

sub VFlag
{
    local ($Input) = @_;
    local ($Question, $MaxCons, $ShowMaxHits, $Load);
    local ( $ShowVer, $Servers, $ShowLog);
    
    if ($Input =~ /\?/)
    {
        $Question = 1;
    }
    if ($Input =~ /c/)
    {
        $MaxCons = 1;
    }
    if ($Input =~ /m/)
    {
        $ShowMaxHits = 1;
    }
    if ($Input =~ /l/)
    {
        $Load = 1; $ShowVer = 1;
    }
    if ($Input =~ /v/)
    {
        $ShowVer = 1;
    }
    if ($Input =~ /s/)
    {
        $Servers = 1;
    }
    if ($Input =~ /o/)
    {
        $ShowLog = 1;
    }
    
    if ($ShowVer)
    {
        print "$Version\n";
    }
    if ($Question)
    {
        &PrintVariable ("Version", $Version);
        &PrintVariable ("MaxConnections", $MaxConnections);
        &PrintVariable ("MaxHits", $MaxHits);
        &PrintVariable ("veronicaRoot", $veronicaRoot);
        &Check ("veronicaRoot", $veronicaRoot, 'DIR');
        &PrintVariable ("DataDir", $DataDir);
        &Check ("DataDir", $DataDir, 'DIR');
        &PrintVariable ("StopList", $StopList);
        &Check ("StopList", $StopList, 'FILE');
        &PrintVariable ("Log", $Log);
        &Check ("Log", $Log, 'FILE');
        &PrintVariable ("MaxTime", $MaxTime);
        &PrintVariable ("LockDir", $LockDir);
        &Check ("LockDir", $LockDir, 'DIR');
        &PrintVariable ("LinkDir", $LinkDir);
        &Check ("LinkDir", $LinkDir, 'DIR');
        &PrintVariable ("veronicaServer", $veronicaServer);
        &PrintVariable ("veronicaPort", $veronicaPort);
    }
    if ($MaxCons)
    {
        print "$MaxConnections\n";        
    }
    if ($ShowMaxHits)
    {
        print "$MaxHits\n";    
    }
    if ($ShowLog)
    {
        open (LOG, "$Log");
        while (<LOG>)
        {
            print $_;
        }
        close LOG;
    }
    print ".\r\n";
}

sub PrintVariable
{
    local ($VarName, $VarValue) = @_;
    print "0$VarName equals $VarValue\terror\terror\t0\r\n";
}

sub Check
{
    local ($VarName, $VarValue, $Operator) = @_;
    local ($Exist);
    if ($Operator eq 'FILE')
    {
        if  (-e $VarValue) 
        {
            $Exist = 'Exists';
        }
        else
        {
            $Exist = 'Does Not Exist';
        }
    }
    if ($Operator eq 'DIR')
    {
        if (-d $VarValue)
        {
            $Exist = 'Exists';
        }
        else
        {
            $Exist = 'Does not Exist';
        }
    }
    print "0   $VarName $Exist\terror\terror\t0\r\n";
}

# Subfunction LastUpdate
#
sub LastUpdate
{
    require ("sys/socket.ph");
    local ($Host) = @_;
    local ($name, $aliases, $type, $len, $thisaddr);
    local ($A, $B, $C, $D);
    if ($Host !~ /^\d+\.\d+\.\d+\.\d+/)
    {
        ($name,$aliases,$type,$len,$thisaddr) = gethostbyname($Host);    
        ($A, $B, $C, $D) = unpack ('C4', $thisaddr);
        $HostIP = "$A.$B.$C.$D";
    }
    else 
    {
        $HostIP = $Host;
    }
    local ($Time) = (-M "$DataDir/$HostIP"); 
    $Time =~ s/\.(.*)//;
    if ($Time)
    {
        print "0$Host was last updated $Time days ago\terror\terror\t0\r\n";
    }
    else
    {
        print "0$Host has not been indexed\terror\terror\t0\r\n";
    }
    print ".\r\n";
}

# Description:  Three boolean operators for "and", "or", and "not".  
#               all three functions work on string lists in the 
#               format "value1|value2|value3|".

# Subfunction And
#
# Purpose:    Given two lists, "List1" and "List2", the subfunction will
#             perform the boolean "and" operator on the values in the
#             two lists.  The "and" operator will list only values that
#             are in both lists.
#
# Variables:  $List1 - The first list
#             $List2 - The second list
#             %Hit   - A list of all values in List1.  It is used for
#                      quick lookup when trying to deceide if a value
#                      from List2 is in List1.
#             $And   - A list of all values in both List1 and List2.

sub And
{
    local ($List1, $List2) = @_;
    local (%Hit, $And);
    foreach (split (/\|/, $List1))
    {
        $Hit{$_} = '1';
    }
    undef ($List1);
    foreach (split (/\|/, $List2))
    {
        if ($Hit{$_})
        {
            $And .= "$_|";
        }
    }
    undef ($List2);
    undef (%Hit);
    return ($And);
}

# Subfunction Or
#
# Purpose:    Given two lists, "List1" and "List2", the subfunction will
#             perform the boolean "or" operator on the values in the
#             two lists.  The "or" operator will list values that
#             are in both lists.
#
# Variables:  $List1 - The first list
#             $List2 - The second list
#             %Hit   - A temporaty list of all values from List1 and List2.
#                      %Hit makes it possible to return only one value if
#                      the value is in both lists.
#             $Or   - A list of all unique values in both List1 and List2.

sub Or
{
    local ($List1, $List2) = @_;
    local (%Hit, $Or);
    foreach (split (/\|/, $List1))
    {
        $Hit{$_} = '1';
    }
    undef ($List1);
    foreach (split (/\|/, $List2))
    {
        $Hit{$_} = '1';
    }
    undef ($List2);
    foreach (keys %Hit)
    {
        $Or .= "$_|";
    }
    undef (%Hit);
    return ($Or);
}

# Subfunction Not 
#
# Purpose:    Given two lists, "List1" and "List2", the subfunction will
#             perform the boolean "not" operator on the values in the
#             two lists.  The "not" operator will list values that
#             are in List1 but not in List2.  This function is the only
#             one where order of the Lists is important.
#
# Variables:  $List1 - The first list
#             $List2 - The second list
#             %Hit   - A temporaty list of all values from List1 with each 
#                      value receiving and value of '1'.  Values from List2
#                      receive a value of '0'.   
#             $Or   - A list of all values in List1 but not in List2.

sub Not
{
    local ($List1, $List2) = @_;
    local (%Hit, $Or);
    foreach (split (/\|/, $List1))
    {
        $Hit{$_} = '1';
    }
    undef ($List1);
    foreach (split (/\|/, $List2))
    {
        $Hit{$_} = '0';
    }
    undef ($List2);
    foreach (keys %Hit)
    {
        if ($Hit{$_})
        {
            $Not .= "$_|";
        }
    }
    undef (%Hit);
    return ($Not);
}
