/*
 * CT keyboard codes
 *
 * Copyright 2012 {list of individual authors and e-mail addresses}
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file LICENSE.txt.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA (or visit https://www.gnu.org/licenses/).
 *
 * As a special exception, the Harbour Project gives permission for
 * additional uses of the text contained in its release of Harbour.
 *
 * The exception is that, if you link the Harbour libraries with other
 * files to produce an executable, this does not by itself cause the
 * resulting executable to be covered by the GNU General Public License.
 * Your use of that executable is in no way restricted on account of
 * linking the Harbour library code into it.
 *
 * This exception does not however invalidate any other reasons why
 * the executable file might be covered by the GNU General Public License.
 *
 * This exception applies only to the code released by the Harbour
 * Project under the name Harbour.  If you copy code from other
 * Harbour Project or Free Software Foundation releases into a copy of
 * Harbour, as the General Public License permits, the exception does
 * not apply to the code that you add in this way.  To avoid misleading
 * anyone as to the status of such modified files, you must delete
 * this exception notice from them.
 *
 * If you write modifications of your own for Harbour, it is your choice
 * whether to permit this exception to apply to your modifications.
 * If you do not wish that, delete this exception notice.
 *
 */

#define KS_DISABLE          hb_BChar( 255 ) + hb_BChar( 255 )

#define KS_A                hb_BChar( 65 )  + hb_BChar( 16 )
#define KS_B                hb_BChar( 66 )  + hb_BChar( 48 )
#define KS_C                hb_BChar( 67 )  + hb_BChar( 46 )
#define KS_D                hb_BChar( 68 )  + hb_BChar( 32 )
#define KS_E                hb_BChar( 69 )  + hb_BChar( 18 )
#define KS_F                hb_BChar( 70 )  + hb_BChar( 33 )
#define KS_G                hb_BChar( 71 )  + hb_BChar( 34 )
#define KS_H                hb_BChar( 72 )  + hb_BChar( 35 )
#define KS_I                hb_BChar( 73 )  + hb_BChar( 23 )
#define KS_J                hb_BChar( 74 )  + hb_BChar( 36 )
#define KS_K                hb_BChar( 75 )  + hb_BChar( 37 )
#define KS_L                hb_BChar( 76 )  + hb_BChar( 38 )
#define KS_M                hb_BChar( 77 )  + hb_BChar( 39 )
#define KS_N                hb_BChar( 78 )  + hb_BChar( 49 )
#define KS_O                hb_BChar( 79 )  + hb_BChar( 24 )
#define KS_P                hb_BChar( 80 )  + hb_BChar( 25 )
#define KS_Q                hb_BChar( 81 )  + hb_BChar( 30 )
#define KS_R                hb_BChar( 82 )  + hb_BChar( 19 )
#define KS_S                hb_BChar( 83 )  + hb_BChar( 31 )
#define KS_T                hb_BChar( 84 )  + hb_BChar( 20 )
#define KS_U                hb_BChar( 85 )  + hb_BChar( 22 )
#define KS_V                hb_BChar( 86 )  + hb_BChar( 47 )
#define KS_W                hb_BChar( 87 )  + hb_BChar( 44 )
#define KS_X                hb_BChar( 88 )  + hb_BChar( 45 )
#define KS_Y                hb_BChar( 89 )  + hb_BChar( 21 )
#define KS_Z                hb_BChar( 90 )  + hb_BChar( 17 )

#define KS_a                hb_BChar( 97 )  + hb_BChar( 16 )
#define KS_b                hb_BChar( 98 )  + hb_BChar( 48 )
#define KS_c                hb_BChar( 99 )  + hb_BChar( 46 )
#define KS_d                hb_BChar( 100 ) + hb_BChar( 32 )
#define KS_e                hb_BChar( 101 ) + hb_BChar( 18 )
#define KS_f                hb_BChar( 102 ) + hb_BChar( 33 )
#define KS_g                hb_BChar( 103 ) + hb_BChar( 34 )
#define KS_h                hb_BChar( 104 ) + hb_BChar( 35 )
#define KS_i                hb_BChar( 105 ) + hb_BChar( 23 )
#define KS_j                hb_BChar( 106 ) + hb_BChar( 36 )
#define KS_k                hb_BChar( 107 ) + hb_BChar( 37 )
#define KS_l                hb_BChar( 108 ) + hb_BChar( 38 )
#define KS_m                hb_BChar( 109 ) + hb_BChar( 39 )
#define KS_n                hb_BChar( 110 ) + hb_BChar( 49 )
#define KS_o                hb_BChar( 111 ) + hb_BChar( 24 )
#define KS_p                hb_BChar( 112 ) + hb_BChar( 25 )
#define KS_q                hb_BChar( 113 ) + hb_BChar( 30 )
#define KS_r                hb_BChar( 114 ) + hb_BChar( 19 )
#define KS_s                hb_BChar( 115 ) + hb_BChar( 31 )
#define KS_t                hb_BChar( 116 ) + hb_BChar( 20 )
#define KS_u                hb_BChar( 117 ) + hb_BChar( 22 )
#define KS_v                hb_BChar( 118 ) + hb_BChar( 47 )
#define KS_w                hb_BChar( 119 ) + hb_BChar( 44 )
#define KS_x                hb_BChar( 120 ) + hb_BChar( 45 )
#define KS_y                hb_BChar( 121 ) + hb_BChar( 21 )
#define KS_z                hb_BChar( 122 ) + hb_BChar( 17 )

#define KS_1                hb_BChar( 49 )  + hb_BChar( 2 )
#define KS_2                hb_BChar( 50 )  + hb_BChar( 3 )
#define KS_3                hb_BChar( 51 )  + hb_BChar( 4 )
#define KS_4                hb_BChar( 52 )  + hb_BChar( 5 )
#define KS_5                hb_BChar( 53 )  + hb_BChar( 6 )
#define KS_6                hb_BChar( 54 )  + hb_BChar( 7 )
#define KS_7                hb_BChar( 55 )  + hb_BChar( 8 )
#define KS_8                hb_BChar( 56 )  + hb_BChar( 9 )
#define KS_9                hb_BChar( 57 )  + hb_BChar( 10 )
#define KS_0                hb_BChar( 48 )  + hb_BChar( 11 )

#define KS_DOT              hb_BChar( 46 )  + hb_BChar( 52 )
#define KS_COMMA            hb_BChar( 44 )  + hb_BChar( 51 )

#define KS_CTRL_A           hb_BChar( 1 )   + hb_BChar( 30 )
#define KS_CTRL_B           hb_BChar( 2 )   + hb_BChar( 48 )
#define KS_CTRL_C           hb_BChar( 3 )   + hb_BChar( 46 )
#define KS_CTRL_D           hb_BChar( 4 )   + hb_BChar( 32 )
#define KS_CTRL_E           hb_BChar( 5 )   + hb_BChar( 18 )
#define KS_CTRL_F           hb_BChar( 6 )   + hb_BChar( 33 )
#define KS_CTRL_G           hb_BChar( 7 )   + hb_BChar( 34 )
#define KS_CTRL_H           hb_BChar( 8 )   + hb_BChar( 35 )
#define KS_CTRL_I           hb_BChar( 9 )   + hb_BChar( 23 )
#define KS_CTRL_M           hb_BChar( 13 )  + hb_BChar( 50 )
#define KS_CTRL_N           hb_BChar( 14 )  + hb_BChar( 49 )
#define KS_CTRL_R           hb_BChar( 18 )  + hb_BChar( 19 )
#define KS_CTRL_S           hb_BChar( 19 )  + hb_BChar( 31 )
#define KS_CTRL_T           hb_BChar( 20 )  + hb_BChar( 20 )
#define KS_CTRL_U           hb_BChar( 21 )  + hb_BChar( 22 )
#define KS_CTRL_V           hb_BChar( 22 )  + hb_BChar( 47 )
#define KS_CTRL_W           hb_BChar( 23 )  + hb_BChar( 17 )
#define KS_CTRL_X           hb_BChar( 24 )  + hb_BChar( 45 )
#define KS_CTRL_Y           hb_BChar( 25 )  + hb_BChar( 21 )
#define KS_CTRL_Z           hb_BChar( 26 )  + hb_BChar( 44 )

#define KS_ALT_A            hb_BChar( 0 )   + hb_BChar( 30 )
#define KS_ALT_B            hb_BChar( 0 )   + hb_BChar( 48 )
#define KS_ALT_C            hb_BChar( 0 )   + hb_BChar( 46 )
#define KS_ALT_D            hb_BChar( 0 )   + hb_BChar( 32 )
#define KS_ALT_E            hb_BChar( 0 )   + hb_BChar( 18 )
#define KS_ALT_F            hb_BChar( 0 )   + hb_BChar( 33 )
#define KS_ALT_G            hb_BChar( 0 )   + hb_BChar( 34 )
#define KS_ALT_H            hb_BChar( 0 )   + hb_BChar( 35 )
#define KS_ALT_I            hb_BChar( 0 )   + hb_BChar( 23 )
#define KS_ALT_J            hb_BChar( 0 )   + hb_BChar( 36 )
#define KS_ALT_K            hb_BChar( 0 )   + hb_BChar( 37 )
#define KS_ALT_L            hb_BChar( 0 )   + hb_BChar( 38 )
#define KS_ALT_M            hb_BChar( 0 )   + hb_BChar( 50 )
#define KS_ALT_N            hb_BChar( 0 )   + hb_BChar( 49 )
#define KS_ALT_O            hb_BChar( 0 )   + hb_BChar( 24 )
#define KS_ALT_P            hb_BChar( 0 )   + hb_BChar( 25 )
#define KS_ALT_Q            hb_BChar( 0 )   + hb_BChar( 16 )
#define KS_ALT_R            hb_BChar( 0 )   + hb_BChar( 19 )
#define KS_ALT_S            hb_BChar( 0 )   + hb_BChar( 31 )
#define KS_ALT_T            hb_BChar( 0 )   + hb_BChar( 20 )
#define KS_ALT_U            hb_BChar( 0 )   + hb_BChar( 22 )
#define KS_ALT_V            hb_BChar( 0 )   + hb_BChar( 47 )
#define KS_ALT_W            hb_BChar( 0 )   + hb_BChar( 17 )
#define KS_ALT_X            hb_BChar( 0 )   + hb_BChar( 45 )
#define KS_ALT_Y            hb_BChar( 0 )   + hb_BChar( 21 )
#define KS_ALT_Z            hb_BChar( 0 )   + hb_BChar( 44 )

#define KS_ALT_1            hb_BChar( 0 )   + hb_BChar( 120 )
#define KS_ALT_2            hb_BChar( 0 )   + hb_BChar( 121 )
#define KS_ALT_3            hb_BChar( 0 )   + hb_BChar( 122 )
#define KS_ALT_4            hb_BChar( 0 )   + hb_BChar( 123 )
#define KS_ALT_5            hb_BChar( 0 )   + hb_BChar( 124 )
#define KS_ALT_6            hb_BChar( 0 )   + hb_BChar( 125 )
#define KS_ALT_7            hb_BChar( 0 )   + hb_BChar( 126 )
#define KS_ALT_8            hb_BChar( 0 )   + hb_BChar( 127 )
#define KS_ALT_9            hb_BChar( 0 )   + hb_BChar( 128 )
#define KS_ALT_0            hb_BChar( 0 )   + hb_BChar( 129 )

#define KS_F1               hb_BChar( 0 )   + hb_BChar( 59 )
#define KS_F2               hb_BChar( 0 )   + hb_BChar( 60 )
#define KS_F3               hb_BChar( 0 )   + hb_BChar( 61 )
#define KS_F4               hb_BChar( 0 )   + hb_BChar( 62 )
#define KS_F5               hb_BChar( 0 )   + hb_BChar( 63 )
#define KS_F6               hb_BChar( 0 )   + hb_BChar( 64 )
#define KS_F7               hb_BChar( 0 )   + hb_BChar( 65 )
#define KS_F8               hb_BChar( 0 )   + hb_BChar( 66 )
#define KS_F9               hb_BChar( 0 )   + hb_BChar( 67 )
#define KS_F10              hb_BChar( 0 )   + hb_BChar( 68 )
#define KS_F11              hb_BChar( 0 )   + hb_BChar( 133 )
#define KS_F12              hb_BChar( 0 )   + hb_BChar( 134 )

#define KS_SH_F1            hb_BChar( 0 )   + hb_BChar( 84 )
#define KS_SH_F2            hb_BChar( 0 )   + hb_BChar( 85 )
#define KS_SH_F3            hb_BChar( 0 )   + hb_BChar( 86 )
#define KS_SH_F4            hb_BChar( 0 )   + hb_BChar( 87 )
#define KS_SH_F5            hb_BChar( 0 )   + hb_BChar( 88 )
#define KS_SH_F6            hb_BChar( 0 )   + hb_BChar( 89 )
#define KS_SH_F7            hb_BChar( 0 )   + hb_BChar( 90 )
#define KS_SH_F8            hb_BChar( 0 )   + hb_BChar( 91 )
#define KS_SH_F9            hb_BChar( 0 )   + hb_BChar( 92 )
#define KS_SH_F10           hb_BChar( 0 )   + hb_BChar( 93 )
#define KS_SH_F11           hb_BChar( 0 )   + hb_BChar( 135 )
#define KS_SH_F12           hb_BChar( 0 )   + hb_BChar( 136 )

#define KS_CTRL_F1          hb_BChar( 0 )   + hb_BChar( 94 )
#define KS_CTRL_F2          hb_BChar( 0 )   + hb_BChar( 95 )
#define KS_CTRL_F3          hb_BChar( 0 )   + hb_BChar( 96 )
#define KS_CTRL_F4          hb_BChar( 0 )   + hb_BChar( 97 )
#define KS_CTRL_F5          hb_BChar( 0 )   + hb_BChar( 98 )
#define KS_CTRL_F6          hb_BChar( 0 )   + hb_BChar( 99 )
#define KS_CTRL_F7          hb_BChar( 0 )   + hb_BChar( 100 )
#define KS_CTRL_F8          hb_BChar( 0 )   + hb_BChar( 101 )
#define KS_CTRL_F9          hb_BChar( 0 )   + hb_BChar( 102 )
#define KS_CTRL_F10         hb_BChar( 0 )   + hb_BChar( 103 )
#define KS_CTRL_F11         hb_BChar( 0 )   + hb_BChar( 137 )
#define KS_CTRL_F12         hb_BChar( 0 )   + hb_BChar( 138 )

#define KS_ALT_F1           hb_BChar( 0 )   + hb_BChar( 104 )
#define KS_ALT_F2           hb_BChar( 0 )   + hb_BChar( 105 )
#define KS_ALT_F3           hb_BChar( 0 )   + hb_BChar( 106 )
#define KS_ALT_F4           hb_BChar( 0 )   + hb_BChar( 107 )
#define KS_ALT_F5           hb_BChar( 0 )   + hb_BChar( 108 )
#define KS_ALT_F6           hb_BChar( 0 )   + hb_BChar( 109 )
#define KS_ALT_F7           hb_BChar( 0 )   + hb_BChar( 110 )
#define KS_ALT_F8           hb_BChar( 0 )   + hb_BChar( 111 )
#define KS_ALT_F9           hb_BChar( 0 )   + hb_BChar( 112 )
#define KS_ALT_F10          hb_BChar( 0 )   + hb_BChar( 113 )
#define KS_ALT_F11          hb_BChar( 0 )   + hb_BChar( 139 )
#define KS_ALT_F12          hb_BChar( 0 )   + hb_BChar( 140 )

#define KS_BS               hb_BChar( 8 )   + hb_BChar( 14 )
#define KS_ESC              hb_BChar( 27 )  + hb_BChar( 1 )
#define KS_TAB              hb_BChar( 9 )   + hb_BChar( 15 )
#define KS_SH_TAB           hb_BChar( 0 )   + hb_BChar( 15 )

#define KS_ALT_BS           hb_BChar( 0 )   + hb_BChar( 14 )
#define KS_ALT_ESC          hb_BChar( 0 )   + hb_BChar( 1 )
#define KS_ALT_TAB          hb_BChar( 0 )   + hb_BChar( 165 )

#define KS_ENTER            hb_BChar( 13 )  + hb_BChar( 28 )
#define KS_CTRL_ENTER       hb_BChar( 10 )  + hb_BChar( 28 )
#define KS_ALT_ENTER        hb_BChar( 0 )   + hb_BChar( 28 )
#define KS_PAD_ENTER        hb_BChar( 13 )  + hb_BChar( 224 )
#define KS_PAD_CTRL_ENTER   hb_BChar( 10 )  + hb_BChar( 224 )
#define KS_PAD_ALT_ENTER    hb_BChar( 0 )   + hb_BChar( 166 )

#define KS_INS              hb_BChar( 224 ) + hb_BChar( 82 )
#define KS_DEL              hb_BChar( 224 ) + hb_BChar( 83 )
#define KS_HOME             hb_BChar( 224 ) + hb_BChar( 71 )
#define KS_END              hb_BChar( 224 ) + hb_BChar( 79 )
#define KS_PGUP             hb_BChar( 224 ) + hb_BChar( 73 )
#define KS_PGDN             hb_BChar( 224 ) + hb_BChar( 81 )
#define KS_UP               hb_BChar( 224 ) + hb_BChar( 72 )
#define KS_LEFT             hb_BChar( 224 ) + hb_BChar( 75 )
#define KS_DOWN             hb_BChar( 224 ) + hb_BChar( 80 )
#define KS_RIGHT            hb_BChar( 224 ) + hb_BChar( 77 )

#define KS_CTRL_INS         hb_BChar( 224 ) + hb_BChar( 146 )
#define KS_CTRL_DEL         hb_BChar( 224 ) + hb_BChar( 147 )
#define KS_CTRL_HOME        hb_BChar( 224 ) + hb_BChar( 119 )
#define KS_CTRL_END         hb_BChar( 224 ) + hb_BChar( 117 )
#define KS_CTRL_PGUP        hb_BChar( 224 ) + hb_BChar( 132 )
#define KS_CTRL_PGDN        hb_BChar( 224 ) + hb_BChar( 118 )
#define KS_CTRL_UP          hb_BChar( 224 ) + hb_BChar( 141 )
#define KS_CTRL_LEFT        hb_BChar( 224 ) + hb_BChar( 115 )
#define KS_CTRL_DOWN        hb_BChar( 224 ) + hb_BChar( 145 )
#define KS_CTRL_RIGHT       hb_BChar( 224 ) + hb_BChar( 116 )

#define KS_ALT_INS          hb_BChar( 0 )   + hb_BChar( 162 )
#define KS_ALT_DEL          hb_BChar( 0 )   + hb_BChar( 163 )
#define KS_ALT_HOME         hb_BChar( 0 )   + hb_BChar( 151 )
#define KS_ALT_END          hb_BChar( 0 )   + hb_BChar( 159 )
#define KS_ALT_PGUP         hb_BChar( 0 )   + hb_BChar( 153 )
#define KS_ALT_PGDN         hb_BChar( 0 )   + hb_BChar( 161 )
#define KS_ALT_UP           hb_BChar( 0 )   + hb_BChar( 152 )
#define KS_ALT_LEFT         hb_BChar( 0 )   + hb_BChar( 155 )
#define KS_ALT_DOWN         hb_BChar( 0 )   + hb_BChar( 160 )
#define KS_ALT_RIGHT        hb_BChar( 0 )   + hb_BChar( 157 )

#define KS_PAD_INS          hb_BChar( 0 )   + hb_BChar( 82 )
#define KS_PAD_DEL          hb_BChar( 0 )   + hb_BChar( 83 )
#define KS_PAD_HOME         hb_BChar( 0 )   + hb_BChar( 71 )
#define KS_PAD_END          hb_BChar( 0 )   + hb_BChar( 79 )
#define KS_PAD_PGUP         hb_BChar( 0 )   + hb_BChar( 73 )
#define KS_PAD_PGDN         hb_BChar( 0 )   + hb_BChar( 81 )
#define KS_PAD_UP           hb_BChar( 0 )   + hb_BChar( 72 )
#define KS_PAD_LEFT         hb_BChar( 0 )   + hb_BChar( 75 )
#define KS_PAD_DOWN         hb_BChar( 0 )   + hb_BChar( 80 )
#define KS_PAD_RIGHT        hb_BChar( 0 )   + hb_BChar( 77 )

#define KS_CTRL_PAD_INS     hb_BChar( 0 )   + hb_BChar( 146 )
#define KS_CTRL_PAD_DEL     hb_BChar( 0 )   + hb_BChar( 147 )
#define KS_CTRL_PAD_HOME    hb_BChar( 0 )   + hb_BChar( 119 )
#define KS_CTRL_PAD_END     hb_BChar( 0 )   + hb_BChar( 117 )
#define KS_CTRL_PAD_PGUP    hb_BChar( 0 )   + hb_BChar( 132 )
#define KS_CTRL_PAD_PGDN    hb_BChar( 0 )   + hb_BChar( 118 )
#define KS_CTRL_PAD_UP      hb_BChar( 0 )   + hb_BChar( 141 )
#define KS_CTRL_PAD_LEFT    hb_BChar( 0 )   + hb_BChar( 115 )
#define KS_CTRL_PAD_DOWN    hb_BChar( 0 )   + hb_BChar( 145 )
#define KS_CTRL_PAD_RIGHT   hb_BChar( 0 )   + hb_BChar( 116 )

#define KS_PAD_DIV          hb_BChar( 47 )  + hb_BChar( 224 )
#define KS_PAD_MUL          hb_BChar( 42 )  + hb_BChar( 55 )
#define KS_PAD_MINUS        hb_BChar( 45 )  + hb_BChar( 74 )
#define KS_PAD_PLUS         hb_BChar( 43 )  + hb_BChar( 78 )

#define KS_CTRL_PAD_DIV     hb_BChar( 0 )   + hb_BChar( 149 )
#define KS_CTRL_PAD_MUL     hb_BChar( 0 )   + hb_BChar( 150 )
#define KS_CTRL_PAD_MINUS   hb_BChar( 0 )   + hb_BChar( 142 )
#define KS_CTRL_PAD_PLUS    hb_BChar( 0 )   + hb_BChar( 144 )

#define KS_ALT_PAD_DIV      hb_BChar( 0 )   + hb_BChar( 164 )
#define KS_ALT_PAD_MUL      hb_BChar( 0 )   + hb_BChar( 55 )
#define KS_ALT_PAD_MINUS    hb_BChar( 0 )   + hb_BChar( 74 )
#define KS_ALT_PAD_PLUS     hb_BChar( 0 )   + hb_BChar( 78 )

#define KS_PAD_1            hb_BChar( 49 )  + hb_BChar( 79 )
#define KS_PAD_2            hb_BChar( 50 )  + hb_BChar( 80 )
#define KS_PAD_3            hb_BChar( 51 )  + hb_BChar( 81 )
#define KS_PAD_4            hb_BChar( 52 )  + hb_BChar( 75 )
#define KS_PAD_5            hb_BChar( 53 )  + hb_BChar( 76 )
#define KS_PAD_6            hb_BChar( 54 )  + hb_BChar( 77 )
#define KS_PAD_7            hb_BChar( 55 )  + hb_BChar( 71 )
#define KS_PAD_8            hb_BChar( 56 )  + hb_BChar( 72 )
#define KS_PAD_9            hb_BChar( 57 )  + hb_BChar( 73 )
#define KS_PAD_0            hb_BChar( 48 )  + hb_BChar( 82 )

#define KS_PAD_DECIMAL      hb_BChar( 46 )  + hb_BChar( 83 )
