/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlShareP_h
#define _XmNlShareP_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

#ifdef	USE_XFT
#include "XmRenderTI.h"
#endif


#define IS_UNKNOWN_FONT_TYPE 0
#define IS_FONT 1
#define IS_FONTSET 2
#define IS_XFT_FONT 3 

#define MULTIBYTE_TEXT 1
#define WIDECHAR_TEXT 2
#define LOCALE_TEXT 3


typedef struct _IconInfo {
	Pixmap pix;
	Pixmap mask;
	Pixmap parent;
	Pixmap highlighted;
	unsigned int width, height;
	int use_counter;
	struct _IconInfo * next;
} IconInfo;

typedef struct _CacheBufElement {
	Pixmap id;
	int ht;
	int wd;
//	XmNlItBoxInfo * cell;
	void * cell; /* Pointer to XmNlItBoxInfo cell or XmNlRCL_Cell cell */
	struct _CacheBufElement * next;
	struct _CacheBufElement * prev;
} CacheBufElement;




typedef struct _SimpleXmStringSegment
{
	char textType;
	char * text;
	wchar_t * wctext;
	size_t textLen; /*bytes for multi byte or single byte text, wide-character symbols for wctext without \0 symbol*/
	XmStringDirection  direction;
	int width;
	int height;
	int ascent;
	int descent;
} SimpleXmStringSegment;

typedef struct _RenderXmStringSegment
{
	SimpleXmStringSegment ** simpleSegment;
	char * renditionTag;
	short rendIdx;
	int simpleSegmentCount;
} RenderXmStringSegment;

typedef struct _SegmentedXmString
{
	RenderXmStringSegment ** segment;
	int segmentCount;
	int maxAscent;
	int maxDescent;
} SegmentedXmString;

typedef struct _RenderRec
{
	XmStringTag tag;
	int renderType;
	char * fontsetString;
#ifdef	USE_XFT
	XFontSet fontset;
	XftFont *xftFont;
	char * xftString;
#endif
} RenderRec;

typedef struct _RenderProp
{
	RenderRec ** record;
	int recordCount;
} RenderProp;










void RefreshIconsColor(Widget w);

IconInfo * AddIconToList(Widget w, Pixmap pix, Pixmap mask);

void DelIconFromList(Widget w, IconInfo * icon);

CacheBufElement * PreparePixBuf(Widget w, CacheBufElement * CacheBufIndex, int * CacheBufNum, int CacheBufLimit);

CacheBufElement * PreparePixBufNew(Widget w, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
									CacheBufElement ** FirstFreeNode, CacheBufElement * PrevNode, CacheBufElement * NextNode, 
									int * CacheBufNumUsed, int * CacheBufNumFree, 
									int CacheBufLimit, int direction);

void	CacheNodeToFreeList(CacheBufElement * Node, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
							CacheBufElement ** FirstFreeNode, int * UsedBufNum, int * FreeBufNum);


void CleanPixBufNew(Widget w, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
									CacheBufElement ** FirstFreeNode, int * CacheBufNumUsed, int * CacheBufNumFree);


int AppendSimpleSegment(RenderXmStringSegment * );

int AppendRenderSegment(SegmentedXmString * , char * );

SegmentedXmString * CreateSegmentedXmString(XmString );

void DestroySegmentedXmString(SegmentedXmString * );

void SegmentedXmStringExtent2(Display * , XmRenderTable , SegmentedXmString *, Dimension * , Dimension * );

void SegmentedXmStringExtent3(Display * display, XmRenderTable table, SegmentedXmString * string, 
								Dimension * width, Dimension * height, short indxDefaultFont);

void DrawComplexString2(Display *, Drawable , GC , XmRenderTable , 
		SegmentedXmString * , int , int , XRectangle *);

void DrawComplexString3(Display *display, Drawable d, GC gc, XmRenderTable table, 
		SegmentedXmString * string, 
#ifdef	USE_XFT
		XftDraw * xftdrawExternal,
#endif
		int x, int y,
		short idxDefaultFont, Pixel fgGC, XRectangle *clip);


#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlShareP_h */
