/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


/************************************************************
*	INCLUDE FILES
*************************************************************/

#ifdef HAVE_CONFIG_H
//#include <config.h>
#endif

#include <stdlib.h>
#include <Xm/XmP.h>
#include "XmNlResColListP.h"
#include "XmNlItemBoxP.h"

#ifdef	USE_XFT
#include "XmRenderTI.h"
#endif

#include <wchar.h>

//#define DEBUG_FAST_RENDITION 1

#define RESCOL_WIDGET 1
#define ICONBOX_WIDGET 2

#define PIX_FOUND(value) ((value <= XmUNSPECIFIED_PIXMAP) ? 0 : 1)


static char CheckClass(Widget w)
{
	WidgetClass class;
	CoreClassPart core;

	class = XtClass(w);
	core = (CoreClassPart) class->core_class;

	if (strcmp("XmNlResColList", core.class_name) ==  0)
		return RESCOL_WIDGET;
	else 
		return ICONBOX_WIDGET;
}


void RefreshIconsColor(Widget w)
{
	IconInfo * ptr;
	XmNlResColListWidget rcol;

	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;

	char widget_is;

	widget_is = CheckClass(w);	

	if (widget_is == RESCOL_WIDGET)
	{	
//		printf("In widget xmNlResColListClass\n");
		rcol = (XmNlResColListWidget) w;

		background_color = w->core.background_pixel;
//		background_color = rcol->rescol.background_pixel;
		foreground_color = rcol->rescol.foreground_pixel;
		sel_fg_color = rcol->rescol.select_foreground_pixel;

		if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color = rcol->primitive.foreground;
		else
			sel_bg_color = rcol->rescol.select_background_pixel;

		ptr = rcol->rescol.IconList;

		while (ptr)
		{


			if (PIX_FOUND(ptr->mask))
			{
				XSetForeground(XtDisplay(w), rcol->rescol.drawGC, sel_bg_color);
				XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, ptr->mask);
				XFillRectangle(XtDisplay(w), ptr->highlighted, rcol->rescol.drawGC, 0, 0, ptr->width, ptr->height);
//			printf("hi\n");

				XSetForeground(XtDisplay(w), rcol->rescol.drawGC, background_color);
				XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, ptr->mask);
				XFillRectangle(XtDisplay(w), ptr->pix, rcol->rescol.drawGC, 0, 0, ptr->width, ptr->height);
//			printf("not hi\n");
			}

			ptr = ptr->next;
		}

/* Restore normalGC */
		XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
		XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
		XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);
	}
}

IconInfo * AddIconToList(Widget w, Pixmap pix, Pixmap mask)
{
	IconInfo * ptr1, * ptr2 = NULL;
	IconInfo * IconList;
	XmNlResColListWidget rcol;
	XmNlItemBoxWidget it;

	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	
	XGCValues values;
	unsigned long valuesmask;
	unsigned int width, height, bw, depth;
	Window root;
	GC mask_gc;
	int x, y;
	char widget_is;
	
	widget_is = CheckClass(w);	
	
	if (widget_is == RESCOL_WIDGET)
	{	
//		printf("In widget xmNlResColListClass\n");
		rcol = (XmNlResColListWidget) w;

		background_color=w->core.background_pixel;
		foreground_color=rcol->rescol.foreground_pixel;
		sel_fg_color=rcol->rescol.select_foreground_pixel;

		if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=rcol->primitive.foreground;
		else
			sel_bg_color=rcol->rescol.select_background_pixel;
			
		IconList = rcol->rescol.IconList;
//		printf("In widget xmNlResColListClass IconList %p\n", IconList);
//		fflush(stdout);
	}
	else
	{
//		printf("In widget xmNlItemBoxClass\n");
		it = (XmNlItemBoxWidget) w;
//		widget_is = ICONBOX_WIDGET;

		background_color = it->itbox.background_pixel;
		foreground_color = it->itbox.foreground_pixel;
		sel_fg_color = it->itbox.select_foreground_pixel;

		if (it->itbox.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color = it->primitive.foreground;
		else
			sel_bg_color = it->itbox.select_background_pixel;
			
		IconList = it->itbox.IconList;
	}
	
	if (!IconList)
	{
//		printf("IconList not found\n");
		IconList = calloc(sizeof(IconInfo), sizeof(char));
		if (!IconList) return NULL;
		ptr1 = IconList;
		ptr1->next = NULL;

		if (widget_is == RESCOL_WIDGET)
		{	
				rcol->rescol.IconList = IconList;
//				printf("In widget xmNlResColListClass IconList created %p\n", rcol->rescol.IconList);
		}
		if (widget_is == ICONBOX_WIDGET)
		{	
				it->itbox.IconList = IconList;
//				printf("In widget xmNlItemBoxClass IconList created %p\n", it->itbox.IconList);
		}
		
	}
	else
	{
		ptr1 = IconList;
		while (ptr1)
		{
			if (ptr1->parent == pix)
			{
//				printf("Finded icon\n");
				return ptr1;
			}
			else 
			{
//				printf("Checked icon\n");
				ptr2 = ptr1;
				ptr1 = ptr1->next;
			}
		}
		ptr1 = calloc(sizeof(IconInfo), sizeof(char));
		if (!ptr1) return NULL;
		ptr1->next = NULL;
		ptr2->next = ptr1;
	}

//	printf("Pointer getted %p \n", ptr1);

	XGetGeometry(XtDisplay(w), pix, &root, &x, &y, &width, &height, &bw, &depth);

//	printf("w = %d h = %d %lx\n", width, height, pix);

	ptr1->pix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 
									width, height, depth);

//	printf("cr1 %lx\n", ptr1->pix);
	ptr1->highlighted = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 
									width, height, depth);
//	printf("cr2 %lx\n", ptr1->highlighted);

	ptr1->parent = pix;
	if (!PIX_FOUND(ptr1->pix))
	{
//		printf("cr !!!!!\n");
		free((void *) ptr1);
		if (ptr2) ptr2->next = NULL;
		return NULL;
	}
//	printf("cr3\n");

	ptr1->width = width;
	ptr1->height = height;
//	printf("cr4\n");

	if (widget_is == RESCOL_WIDGET) 
	{
//	printf("cr5\n");
		XCopyArea(XtDisplay(w), pix, ptr1->pix, rcol->rescol.drawGC,
					0, 0, width, height, 0, 0);
//	printf("cr6\n");
		XCopyArea(XtDisplay(w), pix, ptr1->highlighted, rcol->rescol.drawGC,
					0, 0, width, height, 0, 0);
//					printf("copy\n");
	}
	if (widget_is == ICONBOX_WIDGET) 
	{
		XCopyArea(XtDisplay(w), pix, ptr1->pix, it->itbox.normalGC,
					0, 0, width, height, 0, 0);
		XCopyArea(XtDisplay(w), pix, ptr1->highlighted, it->itbox.normalGC,
					0, 0, width, height, 0, 0);
	}

	if (PIX_FOUND(mask))
	{
		ptr1->mask = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)), 
								width, height, 1);
/* Copy inverted mask for icon */
		valuesmask = GCFunction;
		values.function = GXcopyInverted;
		mask_gc = XCreateGC(XtDisplay(w), ptr1->mask, valuesmask, &values);

		XCopyArea(XtDisplay(w), mask, ptr1->mask, mask_gc,
							0, 0, width, height, 0, 0);
		XFreeGC(XtDisplay(w), mask_gc);

//		printf("mask\n");
/* Fill icon pixmp with background color */
		if (widget_is == ICONBOX_WIDGET)
		{
			XSetForeground(XtDisplay(w), it->itbox.normalGC, sel_bg_color);
			XSetClipOrigin(XtDisplay(w), it->itbox.normalGC, 0, 0);
			XSetClipMask(XtDisplay(w), it->itbox.normalGC, ptr1->mask);
			XFillRectangle(XtDisplay(w), ptr1->highlighted, it->itbox.normalGC, 0, 0, width, height);
			XFillRectangle(XtDisplay(w), ptr1->highlighted, it->itbox.normalGC, 0, 0, width, height);
		}
		if (widget_is == RESCOL_WIDGET)
		{
			XSetForeground(XtDisplay(w), rcol->rescol.drawGC, sel_bg_color);
			XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
			XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, ptr1->mask);
			XFillRectangle(XtDisplay(w), ptr1->highlighted, rcol->rescol.drawGC, 0, 0, width, height);
//			printf("hi\n");
		}

/* Fill highlighted icon pixmp with highlighted color */
		if (widget_is == ICONBOX_WIDGET)
		{
			XSetForeground(XtDisplay(w), it->itbox.normalGC, background_color);
			XSetClipOrigin(XtDisplay(w), it->itbox.normalGC, 0, 0);
			XSetClipMask(XtDisplay(w), it->itbox.normalGC, ptr1->mask);
			XFillRectangle(XtDisplay(w), ptr1->pix, it->itbox.normalGC, 0, 0, width, height);
		}
		if (widget_is == RESCOL_WIDGET)
		{
			XSetForeground(XtDisplay(w), rcol->rescol.drawGC, background_color);
			XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
			XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, ptr1->mask);
			XFillRectangle(XtDisplay(w), ptr1->pix, rcol->rescol.drawGC, 0, 0, width, height);
//			printf("not hi\n");
		}

/* Restore normalGC */
		if (widget_is == ICONBOX_WIDGET)
		{
			XSetForeground(XtDisplay(w), it->itbox.normalGC, foreground_color);
			XSetClipOrigin(XtDisplay(w), it->itbox.normalGC, 0, 0);
			XSetClipMask(XtDisplay(w), it->itbox.normalGC, None);
		}
		if (widget_is == RESCOL_WIDGET)
		{
			XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
			XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
			XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);
		}
	}
	else ptr1->mask = XmUNSPECIFIED_PIXMAP;
	return ptr1;
}

void DelIconFromList(Widget w, IconInfo * icon)
{
	IconInfo * ptr1, * ptr2;
//	XmNlItemBoxWidget it;
/** Clear icon **/
	if (icon)
	{
		ptr1 = icon;
		if ((--(ptr1->use_counter)) <= 0)
		{
			if (PIX_FOUND(ptr1->pix))
				XFreePixmap(XtDisplay(w), ptr1->pix);
			if (PIX_FOUND(ptr1->mask))
				XFreePixmap(XtDisplay(w), ptr1->mask);
			if (ICONBOX_WIDGET == CheckClass(w)) 
					ptr1 = ((XmNlItemBoxWidget) w)->itbox.IconList;
			else
					ptr1 = ((XmNlResColListWidget) w)->rescol.IconList;
			ptr2 = ptr1;
			while(ptr1)
			{
				if (ptr1 == icon) break;
				else
				{
					ptr2 = ptr1;
					ptr1 = ptr1->next;
				}
			}
			if (!ptr1) 
			{
				return ;
			}
			if (ptr1 == ptr2)
			{
				if (ICONBOX_WIDGET == CheckClass(w)) 
								((XmNlItemBoxWidget) w)->itbox.IconList = ptr1->next;
				else
								((XmNlResColListWidget) w)->rescol.IconList = ptr1->next;
				free(ptr1);
				return ;
			}
			ptr2->next = ptr1->next;
			free(ptr1);
		}
	}
}

void CacheNodeToFreeList(CacheBufElement * Node, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
							CacheBufElement ** FirstFreeNode, int * UsedBufNum, int * FreeBufNum)
{
	CacheBufElement * ptr1;
	
	if (!Node)
		return ;
//printf("CacheNodeToFreeList\n");	
	if (*FirstUsedNode == Node)
	{
		*FirstUsedNode = Node->next;
		if (*FirstUsedNode != NULL)
			(*FirstUsedNode)->prev = NULL;
		else
			*LastUsedNode = NULL;
	}
	else
	{
		if (*LastUsedNode == Node)
		{
			*LastUsedNode = Node->prev;
			(*LastUsedNode)->next = NULL;
		}
		else
		{
			ptr1 = Node->prev;
			ptr1->next = Node->next;
			ptr1 = Node->next;
			ptr1->prev = Node->prev;
		}
	}
		
	if (!(*FirstFreeNode))
	{
		*FirstFreeNode = Node;
		Node->next = NULL;
		Node->prev = NULL;
	}
	else
	{
		Node->next = *FirstFreeNode;
		*FirstFreeNode = Node;
	}
	
	*UsedBufNum = *UsedBufNum - 1;
	*FreeBufNum = *FreeBufNum + 1;

//printf("CacheNodeToFreeList used %d free %d\n", *UsedBufNum, *FreeBufNum);	
	
	return ;
}


static void CleanNode(Widget w, CacheBufElement * Node)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlItBoxInfo * cell_1;
	XmNlRCL_Cell * cell_2;

	if (Node->cell)
	{
		if (ICONBOX_WIDGET == CheckClass(w))
		{
			cell_1 = (XmNlItBoxInfo *) Node->cell;
			cell_1->buf = NULL;
		}
		else
		{
			cell_2 = (XmNlRCL_Cell *) Node->cell;
			cell_2->buf = NULL;
		}
	}
}

void CleanPixBufNew(Widget w, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
									CacheBufElement ** FirstFreeNode, int * CacheBufNumUsed, int * CacheBufNumFree)
{
	CacheBufElement * ptr1, * ptr2;
	int i;

//printf("CleanPixBufNew\n");

	ptr1 = *FirstUsedNode;

	for (i = 0; i < *CacheBufNumUsed; i++)
	{
		if (ptr1)
		{
			if (PIX_FOUND(ptr1->id))
			{
//				printf("Free pixmap %lx\n", ptr1->id);

				XFreePixmap(XtDisplay(w), ptr1->id);
			}
				
			ptr2 = ptr1->next;
			XtFree((char *)ptr1);
			ptr1 = ptr2;
		}
	}
	*CacheBufNumUsed = 0;
	*LastUsedNode = NULL;
	
//	printf("Cleaned %d used node cache\n", i);
	
	ptr1 = *FirstFreeNode;

	for (i = 0; i < *CacheBufNumFree; i++)
	{
		if (ptr1)
		{
			if (PIX_FOUND(ptr1->id))
			{
//				printf("Free pixmap %lx\n", ptr1->id);
				XFreePixmap(XtDisplay(w), ptr1->id);
			}	
			ptr2 = ptr1->next;
			XtFree((char *)ptr1);
			ptr1 = ptr2;
		}
	}
	*CacheBufNumFree = 0;

//	printf("Cleaned %d free node cache\n", i);
	
//printf("CleanPixBufNew ok used %d free %d \n", *CacheBufNumUsed, *CacheBufNumFree);
}

CacheBufElement * PreparePixBufNew(Widget w, CacheBufElement ** FirstUsedNode, CacheBufElement ** LastUsedNode, 
									CacheBufElement ** FirstFreeNode, CacheBufElement * PrevNode, CacheBufElement * NextNode,
									int * CacheBufNumUsed, int * CacheBufNumFree, 
									int CacheBufLimit, int direction)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	int i, n;
	XmNlItBoxInfo * cell_1;
	XmNlRCL_Cell * cell_2;

//printf("PreparePixBufNew %p %p %p %d %d %d\n", *FirstUsedNode, *LastUsedNode, *FirstFreeNode, *CacheBufNumUsed, *CacheBufNumFree, CacheBufLimit);	

	if ((*CacheBufNumUsed + *CacheBufNumFree) < CacheBufLimit)
	{
//printf("PreparePixBufNew added new node to free list\n");	
		n = CacheBufLimit - *CacheBufNumUsed - *CacheBufNumFree;

		if (!*FirstFreeNode)
		{
			ptr1 = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
			*FirstFreeNode = ptr1;
			n--;
			*CacheBufNumFree = *CacheBufNumFree + 1;
		}

		for (i = 0; i < n; i++)
		{
			ptr1 = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
			ptr1->next = *FirstFreeNode;
			*FirstFreeNode = ptr1;
			*CacheBufNumFree = *CacheBufNumFree + 1;
		}
//printf("PreparePixBufNew added new node to free list - ok\n");	
	}

/***********************************************************************/
	
/** Used nodes not found **/
	if (*CacheBufNumUsed == 0)
	{
//printf("PreparePixBufNew used nodes list not found\n");	
		if (FirstFreeNode)
		{
			*FirstUsedNode = *FirstFreeNode;
			*LastUsedNode = *FirstUsedNode;
			*FirstFreeNode = (*FirstFreeNode)->next;
			(*FirstUsedNode)->next = NULL;
			(*FirstUsedNode)->prev = NULL;
			*CacheBufNumFree = *CacheBufNumFree - 1;
			*CacheBufNumUsed = *CacheBufNumUsed + 1;
		}
//printf("PreparePixBufNew used nodes list not found - ok %p %p\n", *FirstUsedNode, *LastUsedNode);	
		return *FirstUsedNode;
	}

/***********************************************************************/
	
/** Used nodes found **/
	if (*CacheBufNumFree > 0)
	{
/** Free node found **/
//printf("PreparePixBufNew used nodes list found\n");	
		if (PrevNode)
		{
/** Move first free node to position after PrevNode **/
//printf("PreparePixBufNew used nodes list found PrevNode found & Free node found\n");	
			ptr1 = *FirstFreeNode;
			*FirstFreeNode = (*FirstFreeNode)->next;
			ptr1->prev = PrevNode;
			ptr1->next = PrevNode->next;
			if (*LastUsedNode == PrevNode)
				*LastUsedNode = ptr1;
			else
				PrevNode->next->prev = ptr1;
			PrevNode->next = ptr1;
			*CacheBufNumFree = *CacheBufNumFree - 1;
			*CacheBufNumUsed = *CacheBufNumUsed + 1;
//printf("PreparePixBufNew used nodes list found PrevNode found & Free node found - ok\n");	
			return ptr1;
		}
		else
		{
//printf("PreparePixBufNew used nodes list found PrevNode not found & Free node found\n");	
			if (direction == 1)
			{
/** Move first free node to end of used list **/
				ptr1 = *FirstFreeNode;
				*FirstFreeNode = (*FirstFreeNode)->next;
//printf("PreparePixBufNew used nodes list found - last %p connected %p\n", *LastUsedNode, ptr1);	
				ptr1->next = NULL;
				ptr1->prev = *LastUsedNode;
				(*LastUsedNode)->next = ptr1;
				*CacheBufNumFree = *CacheBufNumFree - 1;
				*LastUsedNode = ptr1;
				*CacheBufNumUsed = *CacheBufNumUsed + 1;
//printf("PreparePixBufNew used nodes list found PrevNode not found & Free node found - ok 1\n");	
				return ptr1;
			}
			if (direction == 0)
			{
					ptr1 = *FirstFreeNode;
					*FirstFreeNode = (*FirstFreeNode)->next;
//printf("PreparePixBufNew used nodes list found - last %p connected %p\n", *LastUsedNode, ptr1);	
					if (NextNode)
					{
/** Insert free node at position before NextNode **/ 
//						printf("ek\n");
						ptr1->next = NextNode;
						ptr1->prev = NextNode->prev;
						if (*FirstUsedNode == NextNode)
							*FirstUsedNode = ptr1;
						else
							NextNode->prev->next = ptr1;
						NextNode->prev = ptr1;
					}
					else
					{
/** Add free node to end of used list **/
//						printf("not ek\n");
						ptr1->next = NULL;
						ptr1->prev = *LastUsedNode;
						(*LastUsedNode)->next = ptr1;
						*LastUsedNode = ptr1;
					}
					*CacheBufNumFree = *CacheBufNumFree - 1;
					*CacheBufNumUsed = *CacheBufNumUsed + 1;
//printf("PreparePixBufNew used nodes list found PrevNode not found & Free node found - ok 0\n");	
					return ptr1;
			}
			if (direction == -1)
			{
				ptr1 = *FirstFreeNode;
				*FirstFreeNode = (*FirstFreeNode)->next;
				if (NextNode)
				{
/** Insert free node before NextNode **/
					ptr1->prev = NextNode->prev;
					ptr1->next = NextNode;
					if (*(FirstUsedNode) == NextNode)
						*(FirstUsedNode) = ptr1;
					else
						NextNode->prev->next = ptr1;
					NextNode->prev = ptr1;
				}
				else
				{
/** Insert free node before FirstUsedNode **/
					ptr1->prev = NULL;
					ptr1->next = *FirstUsedNode;
					(*FirstUsedNode)->prev = ptr1;
					*FirstUsedNode = ptr1;
				}
				*CacheBufNumFree = *CacheBufNumFree - 1;
				*CacheBufNumUsed = *CacheBufNumUsed + 1;
//printf("PreparePixBufNew used nodes list found PrevNode not found & Free node found - ok -1\n");
				return ptr1;
			}
		}
	}
	else
	{
/** Not found free node **/
		if (PrevNode)
		{
			if (direction == 0 || direction == 1)
			{
				if (PrevNode != *FirstUsedNode)
				{
/** Move FirstUsedNode to position after PrevNode **/
//					printf("FFFFFFFFFFFFFFFFFFFFFF\n");
					ptr1 = *FirstUsedNode;
					*FirstUsedNode = (*FirstUsedNode)->next;
					(*FirstUsedNode)->prev = NULL;
					ptr1->prev = PrevNode;
					ptr1->next = PrevNode->next;
					if (*LastUsedNode == PrevNode)
						*LastUsedNode = ptr1;
					else
						PrevNode->next->prev = ptr1;
					PrevNode->next = ptr1;
				}
				else
				{
/** Use node after PrevNode **/
//					printf("GGGGGGGGGGG\n");
					ptr1 = PrevNode->next;
				}
				CleanNode(w, ptr1);
				return ptr1;
			}
			if (direction == -1)
			{
				if (PrevNode != *LastUsedNode)
				{
/** Move LastUsedNode to position after PrevNode **/
//					printf("IIIIIIIIIIIIIIII\n");
					ptr1 = *LastUsedNode;
					CleanNode(w, ptr1);
					if (PrevNode->next == ptr1)
						return ptr1;
					*LastUsedNode = (*LastUsedNode)->prev;
					(*LastUsedNode)->next = NULL;
					ptr1->prev = PrevNode;
					ptr1->next = PrevNode->next;
					PrevNode->next->prev = ptr1;
					PrevNode->next = ptr1;
				}
				else
				{
/** Move FirstUsedNode to position after PrevNode **/
//					printf("JJJJJJJJJJJJJJ\n");
					ptr1 = *FirstUsedNode;
					*FirstUsedNode = (*FirstUsedNode)->next;
					(*FirstUsedNode)->prev = NULL;
					ptr1->next = NULL;
					ptr1->prev = *LastUsedNode;
					CleanNode(w, ptr1);
					(*LastUsedNode)->next = ptr1;
					*LastUsedNode = ptr1;
				}
				return ptr1;
			}
		}
/** Prev node not found **/
		else
		{
			switch (direction)
			{
				case 0:
					if (NextNode)
					{
						if (NextNode == *FirstUsedNode)
						{
//							printf("AAAAAAAAAAAAAAA\n");
							ptr1 = *LastUsedNode;
							*LastUsedNode = (*LastUsedNode)->prev;
							(*LastUsedNode)->next = NULL;
							ptr1->prev = NULL;
							ptr1->next = *FirstUsedNode;
							(*FirstUsedNode)->prev = ptr1;
							*FirstUsedNode = ptr1;
							break ;
						}
						else
						{
							if (NextNode != *LastUsedNode)
							{
//								printf("DDDDDDDDDDDDDDDDDD\n");
								ptr1 = *LastUsedNode;
								*LastUsedNode = (*LastUsedNode)->prev;
								(*LastUsedNode)->next = NULL;
								ptr1->prev = NextNode->prev;
								ptr1->next = NextNode;
								NextNode->prev = ptr1;
								ptr1->prev->next = ptr1;
								break ;
							}
						}
					}
//					printf("EEEEEEEEEEEEEEEEEEEE\n");
					ptr1 = *FirstUsedNode;
					break;
				case 1:
//					printf("CCCCCCCCCCCCCCC\n");
					ptr1 = *FirstUsedNode;
					*FirstUsedNode = (*FirstUsedNode)->next;
					(*FirstUsedNode)->prev = NULL;
					ptr1->next = NULL;
					ptr1->prev = *LastUsedNode;
					(*LastUsedNode)->next = ptr1;
					*LastUsedNode = ptr1;
					break;
				case -1:
//					printf("BBBBBBBBBBBBBBBB\n");
					ptr1 = *LastUsedNode;
					*LastUsedNode = ptr1->prev;
					(*LastUsedNode)->next = NULL;
					ptr1->prev = NULL;
					ptr1->next = *FirstUsedNode;
					(*FirstUsedNode)->prev = ptr1;
					*FirstUsedNode = ptr1;
					break;
			}

			CleanNode(w, ptr1);
			return ptr1;
		}
	}
}

CacheBufElement * PreparePixBuf(Widget w, CacheBufElement * CacheBufIndex, int * CacheBufNum, int CacheBufLimit)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	int i;
	XmNlItBoxInfo * cell_1;
	XmNlRCL_Cell * cell_2;
//printf("Enter to PreparePixBuf -> pointer %p, num %d\n", CacheBufIndex, * CacheBufNum);
/* Cache line not found */
	if (*CacheBufNum == 0)
	{
		if (CacheBufLimit == 0) return NULL;
		CacheBufIndex = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
		if (!CacheBufIndex) return NULL;
//		CacheBufIndex->n = ++nm;
		ptr1 = CacheBufIndex;
		for (i = 0; i < CacheBufLimit; i++)
		{
			ptr2 = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
//			ptr2->n = ++nm;
			ptr1->next = ptr2;
			ptr1 = ptr2;
		}
		ptr1->next = CacheBufIndex;

		*CacheBufNum = CacheBufLimit;
//printf("Exit from PreparePixBuf -> pointer %p, num %d\n", CacheBufIndex, * CacheBufNum);
		return CacheBufIndex;
	}
	else
/* Cache line found*/
	{
		if (*CacheBufNum < CacheBufLimit)
		{
			ptr1 = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
			if (!ptr1) return NULL;
//			ptr1->n = ++nm;
			ptr3 = ptr1;
			for (i = 0; i < CacheBufLimit - *CacheBufNum; i++)
			{
				ptr2 = (CacheBufElement *) XtCalloc(1, sizeof(CacheBufElement));
//				ptr2->n = ++nm;
				ptr3->next = ptr2;
				ptr3 = ptr2;
			}
			ptr3->next = CacheBufIndex->next;
			CacheBufIndex->next = ptr1;
			*CacheBufNum = CacheBufLimit;

			CacheBufIndex = CacheBufIndex->next;
		}
		else
		{
			int i;
			ptr2 = CacheBufIndex;
			for(i = 0; i < *CacheBufNum; i++)
			{
				if (!ptr2->cell)
				{
					CacheBufIndex = ptr2;
//					printf("Found empty buf\n");
					break;
				}
				ptr2 = ptr2->next;
			}
			if (CacheBufIndex->cell)
			{
//				printf("Not Found empty buf -> goto next buf\n");
				CacheBufIndex = CacheBufIndex->next;
				CacheBufIndex = CacheBufIndex->next;
			}
		}

		if (CacheBufIndex->cell)
		{
			if (ICONBOX_WIDGET == CheckClass(w))
			{
				cell_1 = (XmNlItBoxInfo *) CacheBufIndex->cell;
				cell_1->buf = NULL;
			}
			else
			{
				cell_2 = (XmNlRCL_Cell *) CacheBufIndex->cell;
				cell_2->buf = NULL;
			}
		}
		return CacheBufIndex;
	}
}

void CleanCacheBuf(Widget w, CacheBufElement * CacheBufIndex, int * CacheBufNum, int CacheBufLimit)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlItBoxInfo * cell_1;
	XmNlRCL_Cell * cell_2;
	
	while (*CacheBufNum > CacheBufLimit)
	{
		ptr1 = CacheBufIndex->next;
		if (ptr1 != CacheBufIndex)
		{
			ptr2 = ptr1->next;
			CacheBufIndex->next = ptr2;
			if (ptr1->cell)
			{
				if (ICONBOX_WIDGET == CheckClass(w))
				{
					cell_1 = (XmNlItBoxInfo *) ptr1->cell;
					cell_1->buf = NULL;
				}
				else
				{
					cell_2 = (XmNlRCL_Cell *) ptr1->cell;
					cell_2->buf = NULL;
				}
			}
			if (PIX_FOUND(ptr1->id))
				XFreePixmap(XtDisplay(w), ptr1->id);
			XtFree((char *)ptr1);
			(*CacheBufNum)--;
			if (*CacheBufNum < 3) return ;
		}
	}
}







char * ReverseMbString(char * string)
{
	char * revstring, * ptr;
	int i, n, l;
	
	n = strlen(string);
	printf("ReverseMbString: source string with len=%d ->[%s]\n", n, string);
	
	revstring = calloc(n + 1, sizeof(char));
	if (!revstring)
		return NULL;

	ptr = string;
	i = n;

//	printf("ReverseMbString: start write to %d\n", i);

	l = mblen(ptr, n);

	while(l != 0 || n > 0)
	{
		if (l == -1)
		{
//			printf("incorrect multybyte symbol\n");
			ptr++;
			n--;
			l = mblen(ptr, n);
			continue;
		}
		if (l == 0)
		{
//			printf("NULL symbol\n");
			break;
		}
		if (l > 0)
		{
			n = n - l;
			i = i - l;
//			printf("multybyte symbol len = %d -> %d symbol:%s\n", l, i, ptr);
			memcpy(revstring + i, ptr, l);
			ptr = ptr + l;
			l = mblen(ptr, n);
			continue;
		}
		
	}

	printf("ReverseMbString: reversed string:[%s]\n", revstring);
	return revstring;
}

int AppendSimpleSegment(RenderXmStringSegment * seg)
{
	SimpleXmStringSegment ** simpleSeg;

#ifdef DEBUG_FAST_RENDITION
	printf("AppendSimpleSegment start in render segment:%s\n", seg->renditionTag);
#endif
	if (seg->simpleSegment)
		simpleSeg = realloc(seg->simpleSegment, sizeof(SimpleXmStringSegment *) * (seg->simpleSegmentCount + 1));
	else
		simpleSeg = calloc(sizeof(SimpleXmStringSegment *), 1);
	if (!simpleSeg)
		return 0;

	simpleSeg[seg->simpleSegmentCount] = calloc(sizeof(SimpleXmStringSegment), 1);

	if (!simpleSeg[seg->simpleSegmentCount])
		return 0;

	seg->simpleSegment = simpleSeg;
	seg->simpleSegmentCount++;
	
	return 1;
}


int AppendRenderSegment(SegmentedXmString * foundedSegment, char * rendTag)
{
	RenderXmStringSegment ** newSegment;
	
#ifdef DEBUG_FAST_RENDITION
	printf("AppendRenderSegment start\n");
#endif
	if (foundedSegment->segment)
	{ 
		newSegment = realloc(foundedSegment->segment, sizeof(RenderXmStringSegment *) * (foundedSegment->segmentCount + 1));
#ifdef DEBUG_FAST_RENDITION
		printf("AppendRenderSegment reallocated for %d segment\n", foundedSegment->segmentCount + 1);
#endif
	}
	else
	{
		newSegment = calloc(sizeof(RenderXmStringSegment *), 1);
#ifdef DEBUG_FAST_RENDITION
		printf("AppendRenderSegment allocated for 1 segment\n");
#endif
	}
	if (!newSegment)
		return 0;
	
	foundedSegment->segment = newSegment;
	newSegment[foundedSegment->segmentCount] = calloc(sizeof(RenderXmStringSegment), 1);
	if (!newSegment[foundedSegment->segmentCount])
		return 0;

	newSegment[foundedSegment->segmentCount]->renditionTag = strdup(rendTag);
		
	foundedSegment->segmentCount++;
	
#ifdef DEBUG_FAST_RENDITION
	printf("AppendRenderSegment ok\n");
#endif
	return 1;
}



SegmentedXmString * CreateSegmentedXmString(XmString xmstring)
{
	XmStringContext	context;
	XmStringComponentType xm_type;
	unsigned int triple_length;
	XtPointer pt_value;
	SegmentedXmString *	segString = NULL;
	RenderXmStringSegment * currentRendSegment = NULL;
	int pos = 0;
	XmStringDirection currentDirection;
	char * text = NULL;
	wchar_t * wctext = NULL; 
	
	currentDirection = XmSTRING_DIRECTION_L_TO_R;

#ifdef DEBUG_FAST_RENDITION
	printf("==========Start CreateSegmentedXmString\n");
#endif

	if (XmStringInitContext(&context, xmstring))
	{
		segString = calloc(1, sizeof(SegmentedXmString));
		if (!segString)
			return NULL;
			
		while((xm_type = XmStringGetNextTriple(context, &triple_length, &pt_value)) != XmSTRING_COMPONENT_END)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tNext triple\n");
#endif
			switch (xm_type)
			{
				case XmSTRING_COMPONENT_RENDITION_BEGIN:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent begin rendition:[%s]\n", (char *) pt_value);
#endif
					if (AppendRenderSegment(segString, (char *) pt_value))
					{
						pos++;
						currentRendSegment = segString->segment[pos-1];
					}
					break;
				case XmSTRING_COMPONENT_RENDITION_END:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent rendition end:[%s]\n", (char *) pt_value);
#endif
					break;
				case XmSTRING_COMPONENT_LOCALE_TEXT:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text:[%s]\n", (char *) pt_value);
#endif
					if (currentRendSegment && triple_length)
					{
						if (AppendSimpleSegment(currentRendSegment))
						{
							if (currentDirection == XmSTRING_DIRECTION_L_TO_R || currentDirection == XmSTRING_DIRECTION_DEFAULT)
							{
								text = XtCalloc(triple_length + 1, sizeof(char));
								strncpy(text, (char *) pt_value, triple_length);
							}
							else
							{
								text = ReverseMbString((char *) pt_value);
							}
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->text = text;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textType = MULTIBYTE_TEXT;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->direction = currentDirection;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textLen = triple_length;
						}
					}
					break;
					
				case XmSTRING_COMPONENT_TEXT:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tCharset text:[%s]\n", (char *) pt_value);
#endif
					if (currentRendSegment)
					{
						if (AppendSimpleSegment(currentRendSegment))
						{
							text = XtCalloc(triple_length + 1, sizeof(char));
							strncpy(text, (char *) pt_value, triple_length);
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->text = text;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textType = LOCALE_TEXT;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->direction = currentDirection;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textLen = triple_length;
						}
					}
					break;
				case XmSTRING_COMPONENT_SEPARATOR:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent separator from XmString\n");
#endif
					break;
				case XmSTRING_COMPONENT_DIRECTION:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent direction\n");
					if (*((XmDirection *) pt_value) == XmSTRING_DIRECTION_L_TO_R)
						printf("\t\tDirection: L_TO_R\n");
					if (*((XmDirection *) pt_value) == XmSTRING_DIRECTION_R_TO_L)
						printf("\t\tDirection: R_TO_L\n");
					if (*((XmDirection *) pt_value) == XmSTRING_DIRECTION_DEFAULT)
						printf("\t\tDirection: DEFAULT\n");
					if ((*((XmDirection *) pt_value) != XmSTRING_DIRECTION_DEFAULT) && 
							(*((XmDirection *) pt_value) != XmSTRING_DIRECTION_R_TO_L) &&
							(*((XmDirection *) pt_value) != XmSTRING_DIRECTION_L_TO_R))
						printf("\t\tUnknown direction:%hhd\n", *((char *) pt_value));
#endif
					currentDirection = *((XmDirection *) pt_value);
					break;
				case XmSTRING_COMPONENT_WIDECHAR_TEXT:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text from XmString with lenght %d\n", triple_length);
#endif
					if (currentRendSegment)
					{
						if (AppendSimpleSegment(currentRendSegment))
						{
							wctext = (wchar_t *) XtCalloc(triple_length + sizeof(wchar_t), sizeof(char));
							memcpy((void *) wctext, pt_value, triple_length);
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->wctext = wctext;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textType = WIDECHAR_TEXT;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->direction = currentDirection;
							currentRendSegment->simpleSegment[currentRendSegment->simpleSegmentCount - 1]->textLen = triple_length;
						}
					}
					break;
				case XmSTRING_COMPONENT_UNKNOWN:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent unknown from XmString\n");
#endif
					break;
				case XmSTRING_COMPONENT_LOCALE:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent locale from XmString\n");
#endif
					break;
				case XmSTRING_COMPONENT_TAG:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tComponent tag from XmString:%s\n", (char *) pt_value);
#endif
					if (AppendRenderSegment(segString, (char *) pt_value))
					{
						pos++;
						currentRendSegment = segString->segment[pos-1];
					}
					break;
				default:
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tOther\n");
#endif
					XmeWarning(NULL, "Unknown string component");
			}
		}
#ifdef DEBUG_FAST_RENDITION
		printf("==========CreateSegmentedXmString end\n");
#endif
		return segString;
	}
	else
	{
#ifdef DEBUG_FAST_RENDITION
		printf("==========CreateSegmentedXmString end\n");
#endif
		return NULL;
	}
}

void SegmentedXmStringExtent2(Display * display, XmRenderTable table, SegmentedXmString * string, Dimension * width, Dimension * height)
{
	int i, k;
	RenderXmStringSegment * rendSeg;
	XmRendition rend, old_rend = NULL;
	XRectangle r1, r2;
#ifdef	USE_XFT
	XGlyphInfo extents;
#endif
	int fullWidth = 0;
	int maxAscent = 0;
	int maxDescent = 0;
	XtPointer	font;
	Arg rend_args[10];
	Cardinal rend_n;
	int direction_return, font_ascent_return, font_descent_return;
	XCharStruct overall_return;


	XmStringTag *tag_list;

	printf("=======================Start SegmentedXmStringExtent2\n");
	printf("Render segment %d\n", string->segmentCount);

	k = XmRenderTableGetTags(table, &tag_list);
	
	if (k)
	{
		printf("RenderTag in render table %d\n", k);
		for (i = 0; i < k; i++)
		{
			printf("\tRendition tag:%s\n", tag_list[i]);
		}
	}

	for (i = 0; i < string->segmentCount; i++)
	{
		rendSeg = string->segment[i];
		printf("\tRendition segment with tag:%s\n", rendSeg->renditionTag);
		
		rend = XmRenderTableGetRendition(table, rendSeg->renditionTag);
		
		if (rend)
			printf("\tRendition for segment with tag:%s found\n", rendSeg->renditionTag);
		else
		{
			rend = XmRenderTableGetRendition(table, XmFONTLIST_DEFAULT_TAG);
			if (rend)
				printf("\tUsed default rendition record for segment with tag:%s found\n", rendSeg->renditionTag);
		}
		
		if (!rend)
		{
			printf("!!! Not found rendition for segment with tag:%s found\n", rendSeg->renditionTag);
			return ;
		}


/* This is need for loading fonts */

		rend_n = 0;
		XtSetArg(rend_args[rend_n], XmNfont, &font); rend_n++;

		XmRenditionRetrieve(rend, rend_args, rend_n);

		if (_XmRendFontType(rend) != XmFONT_IS_FONTSET 
#ifdef	USE_XFT
			&& _XmRendFontType(rend) != XmFONT_IS_XFT 
#endif
			&& _XmRendFontType(rend) != XmFONT_IS_FONT)
		{
			printf("!!! Uknown font or font missing\n");

			if (old_rend && (old_rend != rend))
			{
				printf("!!! Used old rendition\n");
				XmRenditionFree(rend);
				rend = old_rend;
			}
			else
				continue ;
		}


		if (_XmRendFontType(rend) == XmFONT_IS_FONTSET)
		{
			printf("\tUsed rendition type: FONTSET\n");
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
					if (_XmRendFont(rend))
					{
						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen, &r1, &r2);
//						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
						printf("\t\tSegment wide = %d ascent = %d descent = %d height = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, r2.height);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
					if (_XmRendFont(rend))
					{
						XwcTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->wctext, rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text\n");
					if (_XmRendFont(rend))
					{
						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen, &r1, &r2);
//						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
						printf("\t\tSegment wide = %d ascent = %d descent = %d height = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, r2.height);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
			}
			if (_XmRendFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT_SET\n");
			}
		}
/**********************************************************************/
#ifdef	USE_XFT
		if (_XmRendFontType(rend) == XmFONT_IS_XFT)
		{
			printf("\tUsed rendition type: XFT FONT\n");
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
					if (_XmRendXftFont(rend))
					{
						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen, &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
//						rendSeg->simpleSegment[k]->width = extents.width;
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
					if (_XmRendXftFont(rend))
					{
						XftTextExtents32(display, _XmRendXftFont(rend), (FcChar32 *) rendSeg->simpleSegment[k]->wctext, 
											rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t), &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text\n");
					if (_XmRendXftFont(rend))
					{
						XftTextExtents8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen, &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
			}
			if (_XmRendXftFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT_XFT\n");
			}
		}
#endif
/**********************************************************************/
		if (_XmRendFontType(rend) == XmFONT_IS_FONT)
		{
			printf("\tUsed rendition type: FONT\n");
			printf("\t\tFontStruct at:%p\n", _XmRendFont(rend));
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
					if (_XmRendFont(rend))
					{
						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									rendSeg->simpleSegment[k]->textLen, &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);
/*						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									strlen(rendSeg->simpleSegment[k]->text), &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);*/
						rendSeg->simpleSegment[k]->width = overall_return.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = font_ascent_return + font_descent_return;
						rendSeg->simpleSegment[k]->ascent = font_ascent_return;
						rendSeg->simpleSegment[k]->descent = font_descent_return;
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text\n");
					if (_XmRendFont(rend))
					{
						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									rendSeg->simpleSegment[k]->textLen, &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);
/*						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									strlen(rendSeg->simpleSegment[k]->text), &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);*/
						rendSeg->simpleSegment[k]->width = overall_return.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = font_ascent_return + font_descent_return;
						rendSeg->simpleSegment[k]->ascent = font_ascent_return;
						rendSeg->simpleSegment[k]->descent = font_descent_return;
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
			}
			if (_XmRendFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT\n");
			}
		}
/**********************************************************************/
		if (old_rend != rend)
			XmRenditionFree(rend);
	}
	*width = fullWidth;
	string->maxAscent = maxAscent;
	string->maxDescent = maxDescent;
	*height = maxAscent + maxDescent;
	printf("=======================End SegmentedXmStringExtent2\n");
	return ;
}

void SegmentedXmStringExtent3(Display * display, XmRenderTable table, SegmentedXmString * string, 
								Dimension * width, Dimension * height, short indxDefaultFont)
{
	int i, k;
	RenderXmStringSegment * rendSeg;
	XmRendition rend, old_rend = NULL;
	XRectangle r1, r2;
#ifdef	USE_XFT
	XGlyphInfo extents;
#endif
	Dimension fullWidth = 0;
	int maxAscent = 0;
	int maxDescent = 0;
	XtPointer	font;
	Arg rend_args[10];
	Cardinal rend_n;
	int direction_return, font_ascent_return, font_descent_return;
	XCharStruct overall_return;
	short index;

	XmStringTag *tag_list;

	if (!string)
		return ;

#ifdef DEBUG_FAST_RENDITION
	printf("=======================Start SegmentedXmStringExtent3\n");
	printf("Found render segment %d\n", string->segmentCount);
#endif

	k = XmRenderTableGetTags(table, &tag_list);
	
#ifdef DEBUG_FAST_RENDITION
	if (k)
	{
		printf("RenderTag in render table %d\n", k);
		for (i = 0; i < k; i++)
		{
			printf("\tRendition tag:%s\n", tag_list[i]);
		}
	}
#endif

	for (i = 0; i < string->segmentCount; i++)
	{
		rendSeg = string->segment[i];
#ifdef DEBUG_FAST_RENDITION
		printf("\tRendition segment with tag:%s\n", rendSeg->renditionTag);
#endif
		
//		rend = XmRenderTableGetRendition(table, rendSeg->renditionTag);
		rend = _XmRenderTableFindRendition(table, rendSeg->renditionTag, 0, 1, 0, &index);
		
		if (rend)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tRendition for segment with tag:%s found\n", rendSeg->renditionTag);
#endif
			rendSeg->rendIdx = index;
		}
		else
		{
//			rend = XmRenderTableGetRendition(table, XmFONTLIST_DEFAULT_TAG);
			rend = _XmRenderTableFindRendition(table, XmFONTLIST_DEFAULT_TAG, 0, 1, 0, &index);
			if (rend)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\tUsed default rendition record for segment with tag:%s found\n", rendSeg->renditionTag);
#endif
				rendSeg->rendIdx = index;
			}
		}
		
		if (!rend)
		{
			if (indxDefaultFont < 0)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("!!! Not found rendition for segment with tag:%s found\n", rendSeg->renditionTag);
#endif
				rendSeg->rendIdx = -1;
				return ;
			}
			else
			{
				rend = _XmRTRenditions(table)[indxDefaultFont];
				rendSeg->rendIdx = -1;
			}
		}


/* This is need for loading fonts */

//		rend_n = 0;
//		XtSetArg(rend_args[rend_n], XmNfont, &font); rend_n++;

//		XmRenditionRetrieve(rend, rend_args, rend_n);

		if (_XmRendFontType(rend) != XmFONT_IS_FONTSET 
#ifdef	USE_XFT
			&& _XmRendFontType(rend) != XmFONT_IS_XFT 
#endif
			&& _XmRendFontType(rend) != XmFONT_IS_FONT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("!!! Uknown font or font missing\n");
#endif

			if (indxDefaultFont >= 0)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Using default rend witch valid font\n");
#endif
				rend = _XmRTRenditions(table)[indxDefaultFont];
//				rendSeg->rendIdx = -1;
			}
			else
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Error: font not found, goto next segment\n");
#endif
				continue ;
			}
		}


		if (_XmRendFontType(rend) == XmFONT_IS_FONTSET)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed rendition type: FONTSET\n");
#endif
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
					if (_XmRendFont(rend))
					{
						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen, &r1, &r2);
//						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d height = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, r2.height);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
					if (_XmRendFont(rend))
					{
						XwcTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->wctext, rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text\n");
#endif
					if (_XmRendFont(rend))
					{
						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen, &r1, &r2);
//						XmbTextExtents((XFontSet) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r2.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = r2.height;
						rendSeg->simpleSegment[k]->ascent = - r2.y;
						rendSeg->simpleSegment[k]->descent = r2.height + r2.y;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d height = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, r2.height);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
			}
		}
/**********************************************************************/
#ifdef	USE_XFT
		if (_XmRendFontType(rend) == XmFONT_IS_XFT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed rendition type: XFT FONT\n");
#endif
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
					if (_XmRendXftFont(rend))
					{
						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen, &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
//						rendSeg->simpleSegment[k]->width = extents.width;
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
					if (_XmRendXftFont(rend))
					{
						XftTextExtents32(display, _XmRendXftFont(rend), (FcChar32 *) rendSeg->simpleSegment[k]->wctext, 
											rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t), &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text\n");
#endif
					if (_XmRendXftFont(rend))
					{
						XftTextExtents8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen, &extents );
//						XftTextExtentsUtf8(display, _XmRendXftFont(rend), (FcChar8 *) rendSeg->simpleSegment[k]->text, 
//											strlen(rendSeg->simpleSegment[k]->text), &extents );
						rendSeg->simpleSegment[k]->width = extents.xOff;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
//						rendSeg->simpleSegment[k]->height = extents.height;
//						rendSeg->simpleSegment[k]->ascent = extents.y;
//						rendSeg->simpleSegment[k]->descent = extents.height - extents.y;
						rendSeg->simpleSegment[k]->ascent = _XmRendXftFont(rend)->ascent;
						rendSeg->simpleSegment[k]->descent = _XmRendXftFont(rend)->descent;
						rendSeg->simpleSegment[k]->height = _XmRendXftFont(rend)->ascent + _XmRendXftFont(rend)->descent;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d x = %hd xof = %hd\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent, extents.x, extents.xOff);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
			}
		}
#endif
/**********************************************************************/
		if (_XmRendFontType(rend) == XmFONT_IS_FONT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed rendition type: FONT\n");
			printf("\t\tFontStruct at:%p\n", _XmRendFont(rend));
#endif
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
					if (_XmRendFont(rend))
					{
						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									rendSeg->simpleSegment[k]->textLen, &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);
/*						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									strlen(rendSeg->simpleSegment[k]->text), &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);*/
						rendSeg->simpleSegment[k]->width = overall_return.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = font_ascent_return + font_descent_return;
						rendSeg->simpleSegment[k]->ascent = font_ascent_return;
						rendSeg->simpleSegment[k]->descent = font_descent_return;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text\n");
#endif
					if (_XmRendFont(rend))
					{
						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									rendSeg->simpleSegment[k]->textLen, &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);
/*						XTextExtents((XFontStruct *) _XmRendFont(rend), rendSeg->simpleSegment[k]->text, 
									strlen(rendSeg->simpleSegment[k]->text), &direction_return, &font_ascent_return, 
									&font_descent_return, &overall_return);*/
						rendSeg->simpleSegment[k]->width = overall_return.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width;
						rendSeg->simpleSegment[k]->height = font_ascent_return + font_descent_return;
						rendSeg->simpleSegment[k]->ascent = font_ascent_return;
						rendSeg->simpleSegment[k]->descent = font_descent_return;
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tSegment wide = %d ascent = %d descent = %d\n", 
								rendSeg->simpleSegment[k]->width, rendSeg->simpleSegment[k]->ascent,
								rendSeg->simpleSegment[k]->descent);
#endif
						if (maxAscent < rendSeg->simpleSegment[k]->ascent)
							maxAscent = rendSeg->simpleSegment[k]->ascent;
						if (maxDescent < rendSeg->simpleSegment[k]->descent)
							maxDescent = rendSeg->simpleSegment[k]->descent;
					}
				}
			}
		}
/**********************************************************************/
	}
	*width = fullWidth;
	string->maxAscent = maxAscent;
	string->maxDescent = maxDescent;
	*height = maxAscent + maxDescent;
#ifdef DEBUG_FAST_RENDITION
	printf("=======================End SegmentedXmStringExtent3\n");
#endif
	return ;
}





static XftColor *
GetCachedXftColor(Display *display, Pixel color)
{
  static XftColor *color_cache = NULL;
  static int colors_count = 0;

  XftColor * xftcol;
  XColor xcol;
  Boolean color_exist = FALSE;
  int i;

  if (color_cache != NULL)
  {
    for (i = 0; i < colors_count; ++i)
    {
      if (color_cache[i].pixel == color)
      {
        xftcol = &(color_cache[i]);
        color_exist = TRUE;
        break;
      }
    }
  }

  if (!color_exist)
  {
    color_cache = (XftColor *) XtRealloc((char *) color_cache,
      (Cardinal) (sizeof(XftColor) * (colors_count + 1)));
    if (color_cache != NULL)
    {
      xftcol = &(color_cache[colors_count]) ;
		colors_count++;

    xcol.pixel = color;
    XQueryColor(display, DefaultColormap(display,
      DefaultScreen(display)), &xcol);
    xftcol->pixel = color;
    xftcol->color.red = xcol.red;
    xftcol->color.blue = xcol.blue;
    xftcol->color.green = xcol.green;
    xftcol->color.alpha = 0xFFFF;
	}
  }

  return xftcol;
}




void DrawComplexString2(Display *display, Drawable d, GC gc, XmRenderTable table, 
		SegmentedXmString * string, int x, int y, XRectangle *clip)
{
	int i, k;
	RenderXmStringSegment * rendSeg;
	XmRendition rend, old_rend = NULL;
	XRectangle r1, r2;
	int fullWidth = 0;
	int delta = 0;
	int maxAscent = string->maxAscent;
	int maxDescent = string->maxDescent;
	Bool colr;
#ifdef	USE_XFT
	XftDraw *xftdraw = NULL;
	XftColor xftcol;
	XColor xcol;
#endif
	XGCValues gcvalues, current_gcvalues;
	unsigned long mask;
	Pixel fg, old_fg, current_fg;
	int restore_fg_need = 0;
	int restore_font_need = 0;
	Font old_font, current_font;

	printf("=======================Start DrawComplexString2 at x=%d y=%d\n", x, y);
	printf("Render segment %d\n", string->segmentCount);

	mask = GCForeground | GCFont;
	XGetGCValues(display, gc, mask, &current_gcvalues);
	old_fg = current_gcvalues.foreground;
	current_fg = old_fg;
	old_font = current_gcvalues.font;
	current_font = old_font;

	for (i = 0; i < string->segmentCount; i++)
	{
		rendSeg = string->segment[i];
		printf("\tRendition segment with tag:%s\n", rendSeg->renditionTag);
		
		rend = XmRenderTableGetRendition(table, rendSeg->renditionTag);
		
		if (rend)
			printf("\tRendition for segment with tag:%s found\n", rendSeg->renditionTag);
		else
		{
			rend = XmRenderTableGetRendition(table, XmFONTLIST_DEFAULT_TAG);
			if (rend)
				printf("\tUsed default rendition for segment with tag:%s found\n", rendSeg->renditionTag);
		}
		
		if (!rend)
		{
			printf("!!! Not found rendition for segment with tag:%s found\n", rendSeg->renditionTag);
				continue ;
		}

		fg = _XmRendFG(rend);
		
		if (_XmRendFontType(rend) != XmFONT_IS_FONTSET 
#ifdef	USE_XFT
			&& _XmRendFontType(rend) != XmFONT_IS_XFT 
#endif
			&& _XmRendFontType(rend) != XmFONT_IS_FONT)
		{
			printf("!!! Uknown font or font missing\n");
/*			if (old_rend)
			{
				_XmRendFG(old_rend) = _XmRendFG(rend);
				_XmRendBG(old_rend) = _XmRendBG(rend);
				XmRenditionFree(rend);
				rend = old_rend;
			}*/

			if (old_rend && (old_rend != rend))
			{
				printf("!!! Used old rendition\n");
				_XmRendFG(old_rend) = _XmRendFG(rend);
				_XmRendBG(old_rend) = _XmRendBG(rend);
				XmRenditionFree(rend);
				rend = old_rend;
			}
			else
				continue ;

		}

		if (_XmRendFontType(rend) == XmFONT_IS_FONTSET)
		{
			printf("\tUsed rendition type: FONTSET\n");

			XGetGCValues(display, gc, GCForeground, &current_gcvalues);
			if (fg != XmUNSPECIFIED_PIXEL)
			{
				if (fg != current_fg)
				{
					gcvalues.foreground = fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					printf("\tSet fg from rendition \n");
					current_fg = fg;
					if (current_fg != old_fg)
						restore_fg_need = 1;
				}
			}
			else
			{
				printf("!!!!!!! Unspecified pixel in rendition!!!!!!!!\n");
				if (old_fg != current_fg)
				{
					gcvalues.foreground = old_fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					current_fg = old_fg;
					restore_fg_need = 0;
				}
			}

			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
					if (_XmRendFont(rend))
					{
					
						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
					if (_XmRendFont(rend))
					{
						XwcDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->wctext, rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t));
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text\n");
					if (_XmRendFont(rend))
					{
					
						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
			}

			if (_XmRendFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT_SET\n");
			}
/*			if (_XmRendFont(rend))
			{
				if (!old_rend)
					old_rend = XmRenditionCreate(NULL, XmS, NULL, 0);
					
				_XmRendFontType(old_rend) = _XmRendFontType(rend);
					_XmRendFont(old_rend) = _XmRendFont(rend);
				_XmRendDisplay(old_rend) = display;
				_XmRendGC(old_rend) = gc;
				_XmRendTags(old_rend) = NULL;
				_XmRendTagCount(old_rend) = 0;
					printf("Old rend created FONT_SET\n");
			}*/
		}
/**********************************************************************/
#ifdef	USE_XFT
		if (_XmRendFontType(rend) == XmFONT_IS_XFT)
		{
			printf("\tUsed render record type: XFT FONT\n");


/* Xft draw context */
			if (!xftdraw)
				xftdraw = XftDrawCreate(display, d, 
										DefaultVisual(display, DefaultScreen(display)),
										DefaultColormap(display, DefaultScreen(display)));
							
			if (xftdraw)
				printf("xftdraw created\n");
			else
			{
				printf("xftdraw not created\n");
				goto xft_error;
			}

			if (clip)
			{
				XftDrawSetClipRectangles(xftdraw, 0, 0, clip, 1);
				printf("Clip added\n");
			}
	
/* Xft text color */
			xcol.pixel = _XmRendFG(rend);
			printf("xftdraw color pixel ok\n");
			XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &xcol);
			xftcol.color.red = xcol.red;
			xftcol.color.green = xcol.green;
			xftcol.color.blue = xcol.blue;
//			xftcol.color.red = 200;
//			xftcol.color.green = 2;
//			xftcol.color.blue = 2;
			xftcol.color.alpha = 0xffff;

			printf("xftdraw XQueryColor ok\n");

			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);

				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
					if (_XmRendXftFont(rend))
					{
						XftDrawStringUtf8(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
					if (_XmRendXftFont(rend))
					{
						XftDrawString32(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar32 *)rendSeg->simpleSegment[k]->wctext, 
											wcslen(rendSeg->simpleSegment[k]->wctext));
//											rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t));
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text:%s\n", rendSeg->simpleSegment[k]->text);
					if (_XmRendXftFont(rend))
					{
						XftDrawString8(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
			}
xft_error:
			if (_XmRendXftFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT_XFT\n");
			}

/*			if (_XmRendXftFont(rend))
			{
				if (!old_rend)
					old_rend = XmRenditionCreate(NULL, XmS, NULL, 0);
					
				_XmRendFontType(old_rend) = _XmRendFontType(rend);
				_XmRendXftFont(old_rend) = _XmRendXftFont(rend);
				_XmRendDisplay(old_rend) = display;
				_XmRendGC(old_rend) = gc;
				_XmRendTags(old_rend) = NULL;
				_XmRendTagCount(old_rend) = 0;
				printf("Old rend created FONT_XFT\n");
			}*/
		}
#endif
/**********************************************************************/
		if (_XmRendFontType(rend) == XmFONT_IS_FONT)
		{
			printf("\tUsed rendition type: FONT\n");
			mask = GCForeground | GCFont;
			XGetGCValues(display, gc, mask, &current_gcvalues);
			current_fg = current_gcvalues.foreground;
			current_font = current_gcvalues.font;
			if (fg != XmUNSPECIFIED_PIXEL)
			{
				if (fg != current_fg)
				{
					gcvalues.foreground = fg;
//					mask = mask | GCForeground;
					current_fg = fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					if (current_fg != old_fg)
						restore_fg_need = 1;
				}
			}
			else
			{
				printf("!!!!!!! Unspecified pixel in rendition!!!!!!!!\n");
				if (old_fg != current_fg)
				{
					gcvalues.foreground = old_fg;
//					mask = mask | GCForeground;
					current_fg = old_fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					restore_fg_need = 0;
				}
			}

			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);

				if (_XmRendFont(rend))
				{
					if (current_font != ((XFontStruct *) _XmRendFont(rend))->fid)
					{
						gcvalues.font = ((XFontStruct *) _XmRendFont(rend))->fid;
						XChangeGC(display, gc, GCFont, &gcvalues);
						current_font = ((XFontStruct *) _XmRendFont(rend))->fid;
						if (current_font != old_font)
							restore_font_need = 1;
					}
				}
				else
				{
					printf("!!!!!!! Unspecified font in rendition!!!!!!!!\n");
					if (old_font != current_font)
					{
						gcvalues.font = old_font;
//					mask = mask | GCForeground;
						current_font = old_font;
						XChangeGC(display, gc, GCFont, &gcvalues);
						restore_font_need = 0;
					}
				}

				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
					printf("\t\tMultibyte text\n");
						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
					printf("\t\tWide char text\n");
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
					printf("\t\tLocale text\n");
//					if (_XmRendFont(rend))
//					{
//						gcvalues.font = ((XFontStruct *) _XmRendFont(rend))->fid;
//						gcvalues.foreground =	_XmRendFG(rend);
//						mask = GCFont | GCForeground;
//						XChangeGC(display, gc, mask, &gcvalues);
						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
						delta = delta + rendSeg->simpleSegment[k]->width;
//					}
				}
			}

			if (_XmRendFont(rend) && (old_rend != rend))
			{
				old_rend = rend;
				printf("Old rend created FONT\n");
			}

/*			if (_XmRendFont(rend))
			{
				if (!old_rend)
					old_rend = XmRenditionCreate(NULL, XmS, NULL, 0);
					
				_XmRendFontType(old_rend) = _XmRendFontType(rend);

				_XmRendFont(old_rend) = _XmRendFont(rend);
				_XmRendDisplay(old_rend) = display;
				_XmRendGC(old_rend) = gc;
				_XmRendTags(old_rend) = NULL;
				_XmRendTagCount(old_rend) = 0;
				printf("Old rend created FONT\n");
			}*/
		}
/**********************************************************************/
		if (rend != old_rend)
			XmRenditionFree(rend);
	}
	mask = 0;
	
	if (restore_fg_need)
	{
		mask = mask | GCForeground;
		gcvalues.foreground = old_fg;
	}
	
	if (restore_font_need)
	{
		mask = mask | GCFont;
		gcvalues.font = old_font;
	}
	
	if (mask)
		XChangeGC(display, gc, mask, &gcvalues);

#ifdef	USE_XFT
	if (xftdraw)
	{
		XftDrawDestroy(xftdraw);
		printf("xftdraw destroyed\n");
	}
#endif

	printf("=======================End DrawComplexString2\n");
	return ;
}




void DrawComplexString3(Display *display, Drawable d, GC gc, XmRenderTable table, 
		SegmentedXmString * string, 
#ifdef	USE_XFT
		XftDraw * xftdrawExternal,
#endif
		int x, int y,
		short idxDefaultFont, Pixel fgGC, XRectangle *clip)
{
	int i, k;
	RenderXmStringSegment * rendSeg;
	XmRendition rend, old_rend = NULL;
	XRectangle r1, r2;
	int fullWidth = 0;
	int delta = 0;
	int maxAscent = string->maxAscent;
	int maxDescent = string->maxDescent;
	Bool colr;
#ifdef	USE_XFT
	XftDraw * xftdraw = NULL;
	XftColor * xftcol;
	XColor xcol;
	Boolean internalXftdraw = False;
#endif
	XGCValues gcvalues, current_gcvalues;
	unsigned long mask;
	Pixel fg, old_fg, current_fg;
	int restore_fg_need = 0;
	int restore_font_need = 0;
	Font old_font, current_font;

	if (!string)
		return ;

#ifdef DEBUG_FAST_RENDITION
	printf("=======================Start DrawComplexString2 at x=%d y=%d\n", x, y);
	printf("CompString at %p\n", string);
	printf("Render segment %d\n", string->segmentCount);
#endif

/* !!!!!!!!!!!!!!! */
	mask = GCFont;
	XGetGCValues(display, gc, mask, &current_gcvalues);
/* !!!!!!!!!!!!!!! */

	old_fg = fgGC;
	current_fg = old_fg;
	old_font = current_gcvalues.font;
	current_font = old_font;

	for (i = 0; i < string->segmentCount; i++)
	{
		rend = NULL;
		rendSeg = string->segment[i];
#ifdef DEBUG_FAST_RENDITION
		printf("\tRendition segment with tag:%s\n", rendSeg->renditionTag);
#endif

		if (rendSeg->rendIdx >=0)
			rend = _XmRTRenditions(table)[rendSeg->rendIdx];
		
		if (rend)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tRendition for segment with tag:%s found at %d\n", rendSeg->renditionTag, rendSeg->rendIdx);
#endif
		}
		else
		{
			if (idxDefaultFont >= 0)
				rend = _XmRTRenditions(table)[idxDefaultFont];

#ifdef DEBUG_FAST_RENDITION
			if (rend)
				printf("\tUsed default rendition for segment with tag:%s at %d\n", rendSeg->renditionTag, idxDefaultFont);
#endif
		}
		
		if (!rend)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("!!! Not found rendition for segment with tag:%s found\n", rendSeg->renditionTag);
#endif
			continue ;
		}

		fg = _XmRendFG(rend);
		
		if (_XmRendFontType(rend) != XmFONT_IS_FONTSET 
#ifdef	USE_XFT
			&& _XmRendFontType(rend) != XmFONT_IS_XFT 
#endif
			&& _XmRendFontType(rend) != XmFONT_IS_FONT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("!!! Uknown font or font missing\n");
#endif

			if (idxDefaultFont >= 0)
				rend = _XmRTRenditions(table)[idxDefaultFont];
			else
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Critical: no font go to next segment\n");
#endif
				continue ;
			}
		}

		if (_XmRendFontType(rend) == XmFONT_IS_FONTSET)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed rendition type: FONTSET\n");
#endif

			if (fg != XmUNSPECIFIED_PIXEL)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\tForeground from rendition found\n");
#endif
				if (fg != current_fg)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\tSet fg from rendition \n");
#endif
					gcvalues.foreground = fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					current_fg = fg;
					if (current_fg != old_fg)
						restore_fg_need = 1;
				}
			}
			else
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t!!!!!!! Unspecified pixel in rendition!!!!!!!!\n");
#endif
				if (old_fg != current_fg)
				{
					gcvalues.foreground = old_fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					current_fg = old_fg;
					restore_fg_need = 0;
				}
			}

			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif
				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
					if (_XmRendFont(rend))
					{
					
						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
					if (_XmRendFont(rend))
					{
						XwcDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->wctext, rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t));
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text\n");
#endif
					if (_XmRendFont(rend))
					{
					
						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XmbDrawString(display, d, (XFontSet) _XmRendFont(rend), gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
			}
		}
		else
/**********************************************************************/
#ifdef	USE_XFT
		if (_XmRendFontType(rend) == XmFONT_IS_XFT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed render record type: XFT FONT\n");
#endif

/* Xft draw context */
			xftdraw = xftdrawExternal;
			if (!xftdraw)
			{
				xftdraw = XftDrawCreate(display, d, 
										DefaultVisual(display, DefaultScreen(display)),
										DefaultColormap(display, DefaultScreen(display)));
				if (xftdraw)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("xftdraw created\n");
#endif
					internalXftdraw = True;
					if (clip)
					{
						XftDrawSetClipRectangles(xftdraw, 0, 0, clip, 1);
#ifdef DEBUG_FAST_RENDITION
						printf("Clip added\n");
#endif
					}
				}
				else
				{
#ifdef DEBUG_FAST_RENDITION
					printf("Error: xftdraw not created\n");
#endif
					continue ;
				}
			}				


			if (!xftdraw)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Error: xftdraw not created or not found\n");
#endif
				continue ;
			}

	
/* Xft text color */
			if (fg == XmUNSPECIFIED_PIXEL)
				fg = fgGC;

			if (fg == XmUNSPECIFIED_PIXEL)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Error: foreground color not found in rendition/gc\n");
#endif
				continue ;
			}

			xftcol = GetCachedXftColor(display, fg);
			
			if (!xftcol)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("Error: foreground color not retrieved from cache/X server\n");
#endif
				continue ;
			}
/*			if (_XmRendXftFG(rend).pixel != fg)
			{
				_XmRendXftFG(rend).pixel = fg;
				xcol.pixel = fg;
				XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &xcol);
				_XmRendXftFG(rend).color.red = xcol.red;
				_XmRendXftFG(rend).color.green = xcol.green;
				_XmRendXftFG(rend).color.blue = xcol.blue;
				_XmRendXftFG(rend).color.alpha = 0xffff;
			}
*/			
/*			xcol.pixel = fg;
#ifdef DEBUG_FAST_RENDITION
			printf("xftdraw color pixel ok\n");
#endif
			XQueryColor(display, DefaultColormap(display, DefaultScreen(display)), &xcol);
			xftcol.color.red = xcol.red;
			xftcol.color.green = xcol.green;
			xftcol.color.blue = xcol.blue;
			xftcol.color.alpha = 0xffff;

#ifdef DEBUG_FAST_RENDITION
			printf("xftdraw XQueryColor ok\n");
#endif
*/
			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif

				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
					if (_XmRendXftFont(rend) && xftcol)
					{
/*						XftDrawStringUtf8(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);*/
//						XftDrawStringUtf8(xftdraw, GetCachedXftColor(display, fg), _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
//											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
//											rendSeg->simpleSegment[k]->textLen);
						XftDrawStringUtf8(xftdraw, xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
					if (_XmRendXftFont(rend))
					{
/*						XftDrawString32(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar32 *)rendSeg->simpleSegment[k]->wctext, 
											wcslen(rendSeg->simpleSegment[k]->wctext));*/
						XftDrawString32(xftdraw, xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar32 *)rendSeg->simpleSegment[k]->wctext, 
											wcslen(rendSeg->simpleSegment[k]->wctext));
//											rendSeg->simpleSegment[k]->textLen/sizeof(wchar_t));
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text:%s\n", rendSeg->simpleSegment[k]->text);
#endif
					if (_XmRendXftFont(rend))
					{
/*						XftDrawString8(xftdraw, &xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);*/
						XftDrawString8(xftdraw, xftcol, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											rendSeg->simpleSegment[k]->text, 
											rendSeg->simpleSegment[k]->textLen);
/*						XftDrawStringUtf8(xftdraw, &xftcolor, _XmRendXftFont(rend), x + delta, y + string->maxAscent, 
											(FcChar8 *)rendSeg->simpleSegment[k]->text, 
											strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
					}
				}
			}
		}
		else
#endif
/**********************************************************************/
		if (_XmRendFontType(rend) == XmFONT_IS_FONT)
		{
#ifdef DEBUG_FAST_RENDITION
			printf("\tUsed rendition type: FONT\n");
#endif
			if (fg != XmUNSPECIFIED_PIXEL)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\tForeground from rendition found\n");
#endif
				if (fg != current_fg)
				{
					gcvalues.foreground = fg;
//					mask = mask | GCForeground;
					current_fg = fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					if (current_fg != old_fg)
						restore_fg_need = 1;
				}
			}
			else
			{
#ifdef DEBUG_FAST_RENDITION
				printf("!!!!!!! Unspecified pixel in rendition!!!!!!!!\n");
#endif
				if (old_fg != current_fg)
				{
					gcvalues.foreground = old_fg;
//					mask = mask | GCForeground;
					current_fg = old_fg;
					XChangeGC(display, gc, GCForeground, &gcvalues);
					restore_fg_need = 0;
				}
			}

			for (k = 0; k < rendSeg->simpleSegmentCount; k++)
			{
#ifdef DEBUG_FAST_RENDITION
				printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif

				if (_XmRendFont(rend) && (~current_font))
				{
					if (current_font != ((XFontStruct *) _XmRendFont(rend))->fid)
					{
						gcvalues.font = ((XFontStruct *) _XmRendFont(rend))->fid;
						XChangeGC(display, gc, GCFont, &gcvalues);
						current_font = ((XFontStruct *) _XmRendFont(rend))->fid;
						if (current_font != old_font)
							restore_font_need = 1;
					}
				}
				else
				{
#ifdef DEBUG_FAST_RENDITION
					printf("!!!!!!! Unspecified font in rendition!!!!!!!!\n");
#endif
					if (old_font != current_font && (~old_font))
					{
						gcvalues.font = old_font;
//					mask = mask | GCForeground;
						current_font = old_font;
						XChangeGC(display, gc, GCFont, &gcvalues);
						restore_font_need = 0;
					}
				}

				if (rendSeg->simpleSegment[k]->textType == MULTIBYTE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tMultibyte text\n");
#endif
						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == WIDECHAR_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tWide char text\n");
#endif
/*					if (record->fontset)
					{
						XmbTextExtents(record->fontset, text, strlen(text), &r1, &r2);
						rendSeg->simpleSegment[k]->width = r1.width;
						fullWidth = fullWidth + rendSeg->simpleSegment[k]->width
					}*/
				}
				else
/*******************************************/
				if (rendSeg->simpleSegment[k]->textType == LOCALE_TEXT)
				{
#ifdef DEBUG_FAST_RENDITION
					printf("\t\tLocale text\n");
#endif
//					if (_XmRendFont(rend))
//					{
//						gcvalues.font = ((XFontStruct *) _XmRendFont(rend))->fid;
//						gcvalues.foreground =	_XmRendFG(rend);
//						mask = GCFont | GCForeground;
//						XChangeGC(display, gc, mask, &gcvalues);
						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, rendSeg->simpleSegment[k]->textLen);
/*						XDrawString(display, d, gc, x + delta, y + string->maxAscent,
										rendSeg->simpleSegment[k]->text, strlen(rendSeg->simpleSegment[k]->text));*/
#ifdef DEBUG_FAST_RENDITION
						printf("\t\tDraw segment at x = %d y = %d\n", x + delta, y + string->maxAscent);
#endif
						delta = delta + rendSeg->simpleSegment[k]->width;
//					}
				}
			}
		}
/**********************************************************************/
	}
	mask = 0;
	
	if (restore_fg_need)
	{
#ifdef DEBUG_FAST_RENDITION
		printf("Restore fg\n");
#endif
		mask = mask | GCForeground;
		gcvalues.foreground = old_fg;
	}
	
	if (restore_font_need && (~old_font))
	{
#ifdef DEBUG_FAST_RENDITION
		printf("Restore font\n");
#endif
		mask = mask | GCFont;
		gcvalues.font = old_font;
	}
	
	if (mask)
	{
#ifdef DEBUG_FAST_RENDITION
		printf("Restore gc\n");
#endif
		XChangeGC(display, gc, mask, &gcvalues);
	}
	
#ifdef	USE_XFT
	if (xftdraw && internalXftdraw)
	{
		XftDrawDestroy(xftdraw);
#ifdef DEBUG_FAST_RENDITION
		printf("xftdraw destroyed\n");
#endif
	}
#endif

#ifdef DEBUG_FAST_RENDITION
	printf("=======================End DrawComplexString3\n");
#endif
	return ;
}

void DestroySegmentedXmString(SegmentedXmString * string)
{
	int i, k;
	RenderXmStringSegment * rendSeg;

#ifdef DEBUG_FAST_RENDITION
	printf("=======================DestroySegmentedXmString start\n");
	printf("CompString at %p\n", string);
	if (!string)
	{
		printf("String not found\n");
		return ;
	}
	printf("Render segment %d\n", string->segmentCount);
#endif

	for (i = 0; i < string->segmentCount; i++)
	{
		rendSeg = string->segment[i];
#ifdef DEBUG_FAST_RENDITION
		printf("Rendition segment with tag:%s\n", rendSeg->renditionTag);
#endif
		if (rendSeg->renditionTag)
			free(rendSeg->renditionTag);
		
		for (k = 0; k < rendSeg->simpleSegmentCount; k++)
		{
#ifdef DEBUG_FAST_RENDITION
			if (rendSeg->simpleSegment[k]->direction == XmSTRING_DIRECTION_L_TO_R)
				printf("\tDirection: L_TO_R\n");
			if (rendSeg->simpleSegment[k]->direction == XmSTRING_DIRECTION_R_TO_L)
				printf("\tDirection: R_TO_L\n");
			if (rendSeg->simpleSegment[k]->direction == XmSTRING_DIRECTION_DEFAULT)
				printf("\tDirection: DEFAULT\n");
			printf("\t\tText:[%s]\n", rendSeg->simpleSegment[k]->text);
#endif
			if (rendSeg->simpleSegment[k]->text)
				XtFree(rendSeg->simpleSegment[k]->text);
				
			if (rendSeg->simpleSegment[k]->wctext)
				XtFree((char *) rendSeg->simpleSegment[k]->wctext);
		}
		
//		free(string->segment);
	}
	free(string->segment);
#ifdef DEBUG_FAST_RENDITION
	printf("=======================DestroySegmentedXmString end\n");
#endif	
}

