/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlResColListP_h
#define _XmNlResColListP_h

/************************************************************
*	INCLUDE FILES
*************************************************************/
#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif


#ifdef FAST_XMSTRING_RENDERING
#ifdef	USE_XFT
#include <X11/Xft/Xft.h>
#endif
#endif

#include <Xm/PrimitiveP.h>

#include "XmNlResColList.h"
#include "XmNlShareP.h"
/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

/*
 * ResColList Stuff.
 */

#define XmNlResColList (XmPrimitiveIndex + 1)
#define RtoL_render 1
#define LtoR_render 2



/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/

/*
 * ResColList widget definitions.
 */


typedef struct _XmNlRCL_Cell {
	Pixmap pixmap;
	Pixmap mask;
	//Dimension pix_w;
	//Dimension pix_h;
	String text;
	XmString xmlabel;
#ifdef FAST_XMSTRING_RENDERING
	SegmentedXmString * complabel;
#endif
	Dimension label_w;
	Dimension label_h;
	Pixmap textbuf;
	unsigned char selected;
	void * UserDataPointer;
	unsigned char alignment;
	XmNlListTreeItem * node;
	void * buf; /* Pointer to cache buf node */
	IconInfo * icon;
} XmNlRCL_Cell;


typedef struct {
	  Pixmap bitmap;
	  Pixmap pix;
	  Pixmap mask;
	  int width, height;
	  int xoff;
} Pixinfo;



typedef struct _VisibleItem {
    int x, y, width, height, num, row;
    XmNlRCL_Cell * element;
} VisibleItem;


typedef struct _XmNlRCL_Property_Row {
	char * column_tag;
	Dimension real_width; /* Width is equal to width of cell info with 2 horizontal margin*/
	Dimension current_width; /* Current width of column */
	Dimension drawable_width;
	Dimension new_real_width;
	int info_type;
	Pixmap pix_buf;
	Boolean drawable_width_changed;
	Boolean resizible;
	Boolean autoresize;
	Boolean redraw_need;
	int align_type;
	Boolean col_displayed; /* If true column in view area (partial or full)*/
	Boolean clip_displayed; /* If true info area of column (column width without horizontal margin) in view area (partial or full)*/
	XRectangle clip; /* Clipped area of column */
	int x; /* X coordinate of left edge of column without horizontal shift*/
	int xx1;  /* X coordinate of left edge of column with horizontal shift & horizontal margin*/
	int xx2;  /* X coordinate of right edge of column with horizontal shift & horizontal margin*/
	GC gc;
#ifdef	USE_XFT
	XftDraw * xftdraw;
#endif
	CacheBufElement * CacheBufIndex;
	CacheBufElement * FirstBuf;
	CacheBufElement * LastBuf;
	CacheBufElement * FirstFreeBuf;
	int UsedBufNum;
	int FreeBufNum;
	int CacheBufNum;
	int CacheBufPosition;
	Pixel foreground;
	Pixel background;
} XmNlRCL_Property_Row;

typedef struct _ResColListClassPart {
    XtPointer extension;	/* Just in case we need it later. */
} ResColListClassPart;

typedef struct _XmNlResColListClassRec {
    CoreClassPart		core_class;
    XmPrimitiveClassPart	primitive;
    ResColListClassPart		rescol_class;
} XmNlResColListClassRec;



typedef struct _XmNlResColListPart {
    /*
     * Resources
     */
	XFontStruct *font;
	XmFontList font_list;	/* This widget's font list. */
	Boolean xft; /*If true then render table use XFT font */

	short idxRend;
	XmRendition defaultFont;
	Pixinfo Open;
	Pixinfo Closed;
	Pixinfo Leaf;
	Pixinfo LeafOpen;

	Pixinfo OpenSelected;
	Pixinfo ClosedSelected;
	Pixinfo LeafSelected;
	Pixinfo LeafOpenSelected;

	Pixinfo ControlExpanded;
	Pixinfo ControlCollapsed;
	Pixinfo ControlExpandedSelected;
	Pixinfo ControlCollapsedSelected;
	Pixinfo ItemPix;              /* temporary storage for GetItemPix */

	int VisibilityState;

	IconInfo * IconList;
	
	Time VScrollTime;
	int VScrollCount;

	int PublicRowCount;
	int PublicColCount;
//	int PublicSelectedCount;
//	int * PublicSelectedPositions;
	int * PublicPreciseColSize;
	int CurrentColPosition;
	
	Pixmap IconOpen;
	Pixmap IconClosed;
	Pixmap IconLeaf;
	Pixmap IconOpenLeaf;

	Pixmap IconOpenMask;
	Pixmap IconClosedMask;
	Pixmap IconLeafMask;
	Pixmap IconOpenLeafMask;


	Pixmap CtExpanded;
	Pixmap CtCollapsed;
	Pixmap CtExpandedMask;
	Pixmap CtCollapsedMask;

	Boolean ControlCollapsedBuiltin;
	Boolean ControlExpandedBuiltin;

	Boolean PropConsistency;

	Pixmap Ipix;
	Pixmap Lpix;
	Pixmap Epix;
	Pixmap SelIpix;
	Pixmap SelLpix;
	Pixmap SelEpix;

	int pixWidth;
	int ctrlWidth;
	int ctrlHeight;
	Dimension maxPixHeight;
	Dimension viewX;
	Dimension viewY;
	Dimension viewWidth;
	Dimension viewHeight;
	Dimension lastViewWidth;
	Dimension lastViewHeight;
	Dimension margin_h;
	Dimension margin_w;
	Dimension select_line_w;
	Dimension select_line_margin;
	Dimension full_margin_h;
	Dimension full_margin_w;
	Dimension full_pl_margin;
	Dimension full_selection_w;
	Boolean default_mode;               /* Leaves are open/closed by default */
	Boolean NoRedisplay;
	Boolean Refresh;
	Boolean AllRedraw;
	Boolean recount;
	unsigned char select_line_style;
	GC copyGC;
	GC pixGC;
	GC drawGC;
	GC eraseGC;
	GC eorGC;
	GC highlightGC;
	GC tdrawGC;

	int CacheBufLimit;
	XmNlRCL_Property_Row * prop_data;
	int * col_map;
	/* Pointer to pointers to all rows in tree mode */
	/* Указатель на массив указателей на все строки в режиме дерева*/
	XmNlRCL_Cell ** TreeRows;

/* Pointer to pointers to all rows in plain list mode or to displayed rows in tree mode */
/* Указатель на массив указателей на все строки в режиме плоского списка или на отображаемые */
/* строки в режиме дерева */
	XmNlRCL_Cell ** ItemData;

	XmNlListTreeItem *first;		/* top level entry for tree*/

	XmNlListTreeItem *topItem;        /* first visible item on screen */
/* Number of top visible row */
	int TopLine;
/* Number of botom visible row */
	int BotomLine;
/*!!! Remove need */
//  XmNlRCL_Cell * item_data;
	XmNlCell * selected_item;
	int num_items;
	int num_rows; /* number of rows in the list. */
	int num_cols;
//  int allocatedCols;
//  int allocatedRows;
	unsigned char default_align; /* deafault column alignement, automatic assigned to all columns if num_cols changed */
	unsigned char default_type; /* deafault column type, automatic assigned to all columns if num_cols changed */
	int *col_sharp_width;  /* Full size of column */
	int *col_cur_width;  /* Current size of colmn */
	int *col_new_width;  /* New size of column */
	int LastWSize;
	unsigned char render_order;
	VisibleItem * VisibleElement;
	XRectangle * DrawRect;
	int VisibleCount;
	int autoresize_col;
	int drawable_height;
	Boolean buffering;
	Boolean AutoDropScrollEvent;
	Boolean TreeMode;
	Boolean treeColAutoResize;
	Boolean * selected_rows;
	Boolean HasFocus;
	Boolean FocusFound;
	Boolean MouseMoved;
	Boolean ClickPixmapToOpen;
	Boolean DestroyPhase;
	int *selectedPositions;
	int selectedPositionsCount;
	int current_row;
	XmNlRCL_Cell * currentItem;
	XmNlListTreeItem * currentTreeNode;
	XmNlListTreeItem * currentVisibleParentTreeNode;
	Pixmap pix;		/* Off screen pixmap bufer		*/
	unsigned int cell_width;
	unsigned int cell_height;
	Boolean drawable_height_changed;
	Boolean drawable_width_changed;
	Boolean drawable_need_shift_only;
	Boolean LayoutFrozen;
	Boolean ChangeInFrozen;
	Boolean ColumnSeparatorOn;
	int separator_position;
	int pix_buf_w;		/* Off screen pixmap bufer width	*/
	int pix_buf_h;		/* Off screen pixmap bufer height	*/
	int col_num;		/* Column number in file view win	*/
	int row_num;		/* Row number in file view win		*/
	int max_icon_height;
	int max_icon_width;
	int full_height;
	int full_width;
	int scroll_height;
	int scroll_width;
	int pix_buf_row;
	int pix_shift;
	int last_pix_shift;
	int global_v_shift;
	int global_h_shift;
	int last_scroll_value;
	int vs_counter;
/***********************************************/
	int new_global_h_shift;
	int v_shift_in_pix;
	Time sm_tm;
	int multiclick;
	Boolean DblClicked;
	Boolean AutoResCol;
	int clicked_item;
/* !!!!! */
	unsigned char selection_policy; /* selection mode */
	short num_columns;		/* number of columns in the list. */

	Widget v_bar, h_bar;	/* Scrollbars that may be used
					   to scroll this widget. */

	Widget title_bar;		/* XmPartResWidget for resize columns  */

	XtCallbackList double_click; /* The double click callback list. */
	XtCallbackList highlightCallback; /* The highlight callback list. */
	XtCallbackList resizeCallback; /* Resize widget or column callback list */
	XtCallbackList BranchActionCallback;

	unsigned char string_direction;
	unsigned char alignment;

/*
* Private State
*/

	short * column_widths;	/* Width of each column. */
	XtIntervalId timeout;	/* The mulit - click timout. */

	Time time;			/*The server time of the last button click. */

/*****************************************/
/** Scroll Acceleration ******************/

	int firstInterleavedRow;
	int lastInterleavedRow;

	XtIntervalId scrollIntervalId;
	Boolean scrollRefreshTimeoutFound;


	Pixel background_pixel;
	Pixel foreground_pixel;
	Pixel select_background_pixel;
	Pixel select_foreground_pixel;
	int 	old_sel_count;
	int *	old_sel_massiv;
	int	cur_sel_count;
	int *	cur_sel_massiv;

} XmNlResColListPart;

typedef struct _XmNlResColListRec {
    CorePart		core;
    XmPrimitivePart	primitive;
    XmNlResColListPart	rescol;
} XmNlResColListRec;


/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/





extern XmNlResColListClassRec xmNlResColListClassRec;
extern WidgetClass xmNlResColListWidgetClass;


extern void _XmBackgroundColorDefault(
        	Widget widget,
        	int offset,
        	XrmValue *value );

#if defined(__cplusplus)
}
#endif

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlResColListP_h */
