/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


#ifndef _XmNlResColList_h
#define _XmNlResColList_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

/************************************************************
*	INCLUDE FILES
*************************************************************/

#include "XmNl.h"
#include "XmNlCompResource.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif

#define XmANY_COLUMN	-1

#define XmNlBRANCH	1
#define XmNlLEAF	2
#define XmNlMENU	3
#define XmNlDESTROY	4


#define XmCTitleBar		"TitleBar"
#define XmNTitleBar		"titleBar"

#define XmNlTreeMode	"treeMode"
#define XmCTreeMode		"TreeMode"

#define XmNlTreeColAutoRes	"treeAutoRes"
#define XmCtreeColAutoRes 	"TreeAutoRes"

#define XmNautoAccelScroll	"autoAccelScroll"
#define XmCAutoAccelScroll 	"AutoAccelScroll"

#define XmNcurrentColPosition	"currentColPosition"
#define XmCCurrentColPosition	"CurrentColPosition"

#define	XmNpreciseColSize	"preciseColSize"
#define XmCPreciseColSize	"PreciseColSize"

#define	XmNlNdefaultMode				"defaultMode"
#define XmNlCDefaultMode				"DefaultMode"

#define XmNlrcResizeCallback	"rcResizeCallback"
#define XtNhighlightCallback	"highlightCallback"
#define XmNlltResizeCallback	"ltResizeCallback"
#define XmNlNbranchActionCallback "branchActionCallback"

#define XmNpropConsistency	"propConsistency"
#define XmCPropConsistency	"PropConsistency"

//#define XtNmargin		"margin"
//#define XtNindent		"indent"
//#define XtNspacing		"spacing"
//#define XtNhorizontalSpacing	"horizontalSpacing"
//#define XtNverticalSpacing	"verticalSpacing"
//#define XtNlineWidth		"lineWidth"
//#define XtNhighlightPath	"highlightPath"
#define XtNclickPixmapToOpen	"clickPixmapToOpen"
//#define XtNdoIncrementalHighlightCallback	"incCallback"
#define XtNctrlOpenPixmap	"ctrlOpenPixmap"
#define XtNctrlOpenPixmapMask		"ctrlOpenPixmapMask" 
#define XtNctrlClosedPixmap		"ctrlClosedPixmap"
#define XtNctrlClosedPixmapMask		"ctrlClosedPixmapMask"
#define XtNbranchPixmap		"branchPixmap"
#define XtNbranchPixmapMask			"branchPixmapMask"
#define XtNbranchOpenPixmap	"branchOpenPixmap"
#define XtNbranchOpenPixmapMask			"branchOpenPixmapMask"
#define XtNleafPixmap		"leafPixmap"
#define XtNleafPixmapMask				"leafPixmapMask"
#define XtNleafOpenPixmap	"leafOpenPixmap"
#define XtNleafOpenPixmapMask			"leafOpenPixmapMask"
//#define XtNactivateCallback	"activateCallback"
//#define XtNhighlightCallback	"highlightCallback"
//#define XtNmenuCallback		"menuCallback"
//#define XtNdestroyItemCallback	"destroyItemCallback"

//#define XmNlNhighlightPath			"highlightPath"
#define XmNlNhorizontalSpacing			"horizontalSpacing"
#define XmNlNverticalSpacing			"verticalSpacing"
//#define XmNlNactivateCallback			"activateCallback"
//#define XmNlNhighlightCallback			"highlightCallback"
//#define XmNlNmenuCallback			"menuCallback"
//#define XmNlNdestroyItemCallback	"destroyItemCallback"




/************************************************************
*	MACROS
*************************************************************/

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/


typedef struct _XmNlResColListClassRec	*XmNlResColListWidgetClass;
typedef struct _XmNlResColListRec	*XmNlResColListWidget;


typedef struct _RCStructureElement {
	unsigned char column_type;
	unsigned char column_alignement;
} RCStructureElement;


typedef enum _XmNRClListTreeItemType {
    RCItemDetermineType = 0,
    RCItemBranchType = XmNlBRANCH,
    RCItemLeafType = XmNlLEAF
} XmNlRCListTreeItemType;


typedef struct _XmNlListTreeItem XmNlListTreeItem;

struct _XmNlListTreeItem {
	Boolean	open;
	Boolean	highlighted;
	char		*text;
	int		length;
	int		x,y,ytext;
	int		count;
	Dimension	height;
	XmNlRCListTreeItemType type;
	XmNlListTreeItem 	*parent, *firstchild, *prevsibling, *nextsibling, *lastchild;
	Pixmap	openPixmap, closedPixmap, openMask, closedMask;
//  XmNlCell *cell;
	XtPointer cell; /* pointer to cells row of this item */
	XtPointer	user_data;
	int row; /* number of displayed row for this item */
	int sequence; /* sequence number of in branche, start from 0 */
	int level;
	char * lines;
};

/************************************************************
* Public function declarations
*************************************************************/

int XmNlResColAddRows(Widget w, XmNlCell * data, int row_count, unsigned char valuemask);

int XmNlResColInsertRow(Widget w, XmNlCell * data, int row_pos, unsigned char valuemask);

void XmNlResColDeleteRows(Widget w, int position, int rows_num);

void XmNlResColDeleteAllRows(Widget w);

Boolean XmNlResColGetCell(Widget w, XmNlCell *cell, unsigned char valuemask, int col, int row);

Boolean XmNlResColGetItem(Widget w, XmNlCell *cell, unsigned char valuemask, int position);

void XmNlResColSetCell(Widget w, XmNlCell *cell, unsigned char valuemask, int col, int row);

Boolean XmNlResColGetCellAtPointer(Widget w, XmNlCell *cell, unsigned char valuemask, const void * pointer, int col);
void XmNlResColSort(Widget w, int start, int lenght, int (*comparer)(const void *, const void *));

void RCSetPropertyRow(Widget w, int * data);
//void RCSetCell(Widget w, int row, int col, XmNlCell * cell_data);
void RCSetAutoresCol(Widget w, int n);
void RCSetColSize(Widget w, Dimension * size);
int RCGetHorShift(Widget w);
void RCGetColsWidth(Widget w, Dimension * size);
void RCSetSelectedItems(Widget w, int num, int* data);
void RCSetStructure(Widget w, int col_count, RCStructureElement * data);
XmNlCell * RCGetSelectedCells(Widget w, int *count);
int RCXYtoRow(Widget w, unsigned long x, unsigned long y);
void RCSetColSeparator(Widget w, int pos);
void RCMoveColSeparator(Widget w, int pos);
void RCEraseColSeparator(Widget w);

/**** new ***/
void XmNlresColGetSelectedRows(Widget w, int * count, int ** select_numbers);
/************/

XmNlListTreeItem * XmNlRCTreeAdd(Widget , XmNlListTreeItem *, XmNlCell *, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeInsert(Widget , XmNlListTreeItem *, XmNlCell *, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeAddType(Widget , XmNlListTreeItem *, XmNlRCListTreeItemType , XmNlCell *, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeAddBranch(Widget , XmNlListTreeItem *, XmNlCell *, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeAddLeaf(Widget , XmNlListTreeItem *,  XmNlCell *, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeInsertBeforeItem(Widget w, XmNlListTreeItem * item, XmNlCell * data, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeAddAfterItem(Widget w, XmNlListTreeItem * item, XmNlCell * data, unsigned char valuemask);

XmNlListTreeItem * XmNlRCTreeDeleteItem(Widget w, XmNlListTreeItem * item);

void XmNlRCTreeDeleteAllItems(Widget w);

void XmNlRCTreeRefreshOff(Widget);

void XmNlRCTreeRefreshOn(Widget );

void XmNlRCTreeRefresh(Widget );

void XmNlTreeSetItemPixmaps (Widget w, XmNlListTreeItem *item,
                        Pixmap openPixmap, Pixmap closedPixmap, Pixmap openMask, Pixmap closedMask);

void RCSetListStructure(Widget w, RCStructureElement * data);

XmNlListTreeItem * XmNlRCTreeGetItemByRow (Widget w, int row);
int XmNlResColAppendColumn(Widget w, XmNlColSpecRec * csrec);
int XmNlResColSetColumn(Widget w, XmNlColSpecRec * csrec, int col_num);
int XmNlResColCleanAllColumns(Widget w);
void XmNlResColMoveColumnTo(Widget w, int col, int position);
int XmNlResColSetCol(Widget w, XmNlCell * data, int col, unsigned char valuemask);
int XmNlResColDeleteColumn(Widget w, int column);
char * XmNlResColGetColumnTag(Widget w, int column);
int XmNlResColGetColumnNum(Widget w, char * tag);

/* This is private function, used only from XmNlList widget */
void _XmNlResColAddScrolls(Widget );
void XmNlResColSetProperty(Widget w, int col_count, RCStructureElement * data);

/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/

extern WidgetClass xmNlResColListWidgetClass;

#if defined(__cplusplus)
}
#endif

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmNlResColList_h */
