/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */


/************************************************************
*	INCLUDE FILES                                           *
*************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <sys/time.h>

#include <Xm/XmP.h>
#if (XmVERSION >= 2)
#include <Xm/DrawP.h>
#endif


#include <Xm/ScrollBar.h>
//#include <Xm/ExtP.h>
#include <Xm/RepType.h>
//#include <Xm/XmStrDefs.h>
#include "XmNlResColListP.h"
#include "XmNlPartRes.h"
#include "XmNlList.h"
#include "XmNl.h"
//#include "XmNlCompResource.h"
#include <stdlib.h>
#include <X11/Xregion.h>


/* XPM */


#define VerticalScroll 		0x0001
#define HorizontalScroll	0x0002
#define AllScroll			0x0003

#define folder_width 16
#define folder_height 12

#define ClickInBody 1
#define ClickInControl 2

#define ScrollStep 10


static unsigned char folder_icon[] = {
   0x00, 0x1f, 0x80, 0x20, 0x7c, 0x5f, 0x02, 0x40, 0x92, 0x64, 0x02, 0x40,
   0x4a, 0x52, 0x02, 0x40, 0x26, 0x49, 0x02, 0x40, 0x92, 0x64, 0xfc, 0x3f ,

   0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0xfc, 0x3f, 0x6c, 0x1b, 0xfc, 0x3f,
   0xb4, 0x2d, 0xfc, 0x3f, 0xd8, 0x36, 0xfc, 0x3f, 0x6c, 0x1b, 0x00, 0x00 };

static unsigned char folder_mask_bits[] = {
   0x00, 0x1f, 0x80, 0x3f, 0xfc, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f,
   0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfe, 0x7f, 0xfc, 0x3f};

static char * folder_color[] = {
"black",
"yellow"};

static char * file_color[] = {
"black",
"white"};


#define folderopen_width 16
#define folderopen_height 12

static unsigned char folderopen_icon[] =
{
  0x00, 0x3e, 0x00, 0x41, 0xf8, 0xd5, 0xac, 0xaa, 0x54, 0xd5, 0xfe, 0xaf,
  0x01, 0xd0, 0x02, 0xa0, 0x02, 0xe0, 0x04, 0xc0, 0x04, 0xc0, 0xf8, 0x7f,

  0x00, 0x00, 0x00, 0x3e, 0x00, 0x2a, 0x50, 0x55, 0xa8, 0x2a, 0x00, 0x50,
  0xfe, 0x2f, 0xfc, 0x5f, 0xfc, 0x1f, 0xf8, 0x3f, 0xf8, 0x3f, 0x00, 0x00,
};


#define document_width 9
#define document_height 14

static unsigned char document_icon[] =
{
  0x1f, 0x00, 0x31, 0x00, 0x51, 0x00, 0x91, 0x00, 0xf1, 0x01, 0x01, 0x01,
  0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x01,
  0x01, 0x01, 0xff, 0x01,

  0x00, 0x00, 0x0e, 0x00, 0x2e, 0x00, 0x6e, 0x00, 0x0e, 0x00, 0xfe, 0x00,
  0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00,
  0xfe, 0x00, 0x00, 0x00 };



/************************************************************
*	TYPEDEFS AND DEFINES                                    *
*************************************************************/
//#define DEBUG 1
#define DEBUG_RENDITION 1
//#define CalcColParamDEBUG 1
//#define TreeManagementDEBUG 1

#define CHECK_CLIP_CORRECT (XmVERSION >= 2 && XmREVISION >= 3 && XmUPDATE_LEVEL >= 4)

#define SUPERCLASS ((WidgetClass) &xmPrimitiveClassRec)

#define SM_H_MARGIN 3
#define SM_V_MARGIN 3
#define SM_F_SPACE 2
#define SM_SCROLLING_SHIFT 4


#define NO_ACTION_NEEDED 0
#define FULL_REDRAW_NEEDED 1
#define OFFSCREEN_REDRAW_NEEDED 2
#define SCREEN_REDRAW_NEEDED 3
#define COMPLEX_REDRAW_NEEDED 3

#define DEFAULT_EMPTY_WIDTH 4
#define MAXIMUM_ROW_SHIFT_MODE 250
/************************************************************
*	MACROS                                                  *
*************************************************************/
#define Max(x, y) (((x) > (y)) ? (x) : (y))
#define Min(x, y) (((x) < (y)) ? (x) : (y))
#define streq(a, b) (((a) != NULL) && ((b) != NULL) && (strcmp((a), (b)) == 0))
#define PIX_FOUND(value) ((value <= XmUNSPECIFIED_PIXMAP) ? 0 : 1)
#define COL_MAPPED(value) rcol->rescol.col_map[value]


extern void _XmSelectColorDefault(Widget widget, int offset, XrmValue *value);

/************************************************************
*	GLOBAL DECLARATIONS                                     *
*************************************************************/


/************************************************************
*	STATIC FUNCTION DECLARATIONS                            *
*************************************************************/

/******************************
 * Exported Widget Functions  *
 ******************************/

static void ClassPartInitialize(WidgetClass wc);
static void ClassInitialize();
static void Initialize(Widget, Widget, ArgList, Cardinal *);
static void Realize(Widget, Mask *, XSetWindowAttributes *);
static void Resize(Widget), Redisplay(Widget, XEvent *, Region);
static void Destroy(Widget);
static Boolean SetValues(Widget, Widget, Widget, ArgList, Cardinal *);
static void DestroyGC(XmNlResColListWidget);

/***********************************
 * Internal routines.              *
 ***********************************/

int RCAppendColumn(XmNlResColListWidget rcol);
static void RCDeleteAllRows(Widget w);
static void	RCTreeDeleteAllItems(Widget w);
//void RefreshTitleBar(XmNlResColListWidget rcol);
static void ResizeStuff(XmNlResColListWidget w);
static void RecalcParam( Widget w, int start, int end, Boolean font_change, Boolean * h_change, Boolean * col_change);
//Boolean SuperCalcGeom( Widget w);
//static Boolean CalcGeom( Widget w);
static Boolean CalcGeomInit( Widget w);
static Boolean CalcGeomPostInit( Widget w);
static Boolean CalcGeomAfterChangeCells( Widget w);
static Boolean CalcGeomAfterResize( Widget w);
static void ResizeSliders(Widget w, int mask);
static void AdjustGlobalShift(Widget w);
static void AdjustGlobalHorShift(Widget w);
//static void RCInternRedisplay (Widget w);
static void DoubleClickDoCallback(Widget w, int number);
static void HighlightDoCallback(Widget w);
static Boolean SelectChanged(XmNlResColListWidget it);
static void RefreshPixmap(XmNlResColListWidget rcol, Pixinfo * pix, Boolean selected);
static void CurrentFrameDraw(Widget w);
static int CheckCurrentVisible(Widget w);
static void CheckSetRenderTable(Widget wid, int offset, XrmValue *value);
static void RCDeleteChildren(XmNlResColListWidget rcol, XmNlListTreeItem *item);
static Pixinfo * RCGetItemPix(XmNlResColListWidget rcol, XmNlListTreeItem *item, Boolean selected);
static void UnselectBranch(XmNlResColListWidget rcol, XmNlListTreeItem *item);
static void UnselectAllItem(XmNlResColListWidget);
void CreateLinePix(XmNlResColListWidget );
void RCRedrawAllWindow(Widget);
static void CalcColParam(Widget);
static CacheBufElement * RCGetPixBuf(Widget, XmNlRCL_Cell *, XmNlRCL_Property_Row *, int, int);
static CacheBufElement * RCGetPixBufNew(Widget, XmNlRCL_Cell *, XmNlRCL_Property_Row *, int, int, int);
void RCSetCacheBufLimit(Widget );
void RCCountAll(XmNlResColListWidget );
static void RCFreePixBufNew(Widget );
static void CurrentFrameRemoveDraw(Widget );
void RCRedrawWindowRtoL( Widget , XEvent * , Region );

//static void GetValues_XmNselectedItemCount(Widget w, int n, XtArgVal *value);
//static void GetValues_XmNselectedPositions(Widget w, int n, XtArgVal *value);
static void GetValues_XmNitemCount(Widget w, int n, XtArgVal *value);
static void GetValues_XmNnumCols(Widget w, int n, XtArgVal *value);
static void GetValues_XmNpreciseColSize(Widget w, int n, XtArgVal *value);

void RCCreateDeafaultCols(XmNlResColListWidget rcol);
static void CleanPropertyRow(Widget w);

static Boolean ChekParentIsList(Widget w);
static void CopySelectedPositions(XmNlResColListWidget rcol);
static void ClearSelectedPositions(XmNlResColListWidget rcol);

static Boolean FoundCurrentInBranch(XmNlResColListWidget rcol, XmNlListTreeItem * branch);
static int FindCurrentTreeNodeInRowList(XmNlResColListWidget rcol);
static void ExpandFromCurrentToParent(XmNlResColListWidget rcol, XmNlListTreeItem * parent);
static XmNlListTreeItem * FindFirstVisibleParentForCurrentTreeNode(XmNlResColListWidget rcol, int * row_num);

static void RefreshCachePix(Widget w, int row, Boolean selected);


/***********************************
 * Actions and Callback function defs.
 ***********************************/

static void VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data);
static void HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data);
static void ButtonDownAction(Widget, XEvent *, String *, Cardinal *);
static void ButtonDownActionExtended(Widget, XEvent *, String *, Cardinal *);
static void ButtonUpAction(Widget, XEvent *, String *, Cardinal *);
static void MotionAction(Widget, XEvent *, String *, Cardinal *);
static void ScrollAction(Widget, XEvent *, String *, Cardinal *);
static void PressUp(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressDown(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressLeft(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressRight(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressSpace(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressEnter(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressPrevTab(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void PressNextTab(Widget w, XEvent *event, String *params, Cardinal *num_params);


static void Focus_In(Widget w, XEvent *event, String *params, Cardinal *num_params);
static void Focus_Out(Widget w, XEvent *event, String *params, Cardinal *num_params);

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/



static char defaultTranslations[] =
	"<FocusIn>:				Focus_In()\n\
	<FocusOut>:				Focus_Out()\n\
	c ~m ~s ~a <Btn1Down>:	ButtonDownExtended()\n\
	<Btn1Down>:				ButtonDown()\n\
	Button1 <Motion>:		Motion()\n\
	<Key>Return:			PressEnter()\n\
	<Key>osfUp:				PressUp()\n\
	<Key>osfDown:			PressDown()\n\
	<Key>osfLeft:			PressLeft()\n\
	<Key>osfRight:			PressRight()\n\
	<Key>space:				PressSpace()\n\
	s ~m ~a <Key>Tab:		PressPrevTab()\n\
	~m ~a <Key>Tab:			PressNextTab()\n\
	<Btn4Up>:				Scroll(Up)\n\
	<Btn5Up>:				Scroll(Down)\n\
	<Btn1Up>:				ButtonUp()";

static XtActionsRec actionsList[] =
{
	{"ButtonDown",			ButtonDownAction},
	{"ButtonUp",			ButtonUpAction},
	{"ButtonDownExtended",	ButtonDownActionExtended},
	{"Scroll",				ScrollAction},
	{"Motion",				MotionAction},
	{"PressEnter",			PressEnter},
	{"PressUp",				PressUp},
	{"PressDown",			PressDown},
	{"PressLeft",			PressLeft},
	{"PressRight",			PressRight},
	{"PressSpace",			PressSpace},
	{"PressPrevTab",		PressPrevTab},
	{"PressNextTab",		PressNextTab},
	{"Focus_In",			Focus_In},
	{"Focus_Out",			Focus_Out},
};


/* ARGSUSED */

static XtResource resources[] = {
#define offset(field) XtOffsetOf(XmNlResColListRec, rescol.field)
	{XmNitemCount, XmCItemCount, XmRInt, sizeof(int),
		offset(PublicRowCount), XmRImmediate, (XtPointer) 0},

/*	{XmNselectedItemCount, XmCSelectedItemCount, XmRInt, sizeof(int),
		offset(PublicSelectedCount), XmRImmediate, (XtPointer) 0},

	{XmNselectedPositions, XmCSelectedPositions, XmRPointer, sizeof(XtPointer),
		offset(PublicSelectedPositions), XmRImmediate, (XtPointer) 0},
*/
	{XmNselectedPositions, XmCSelectedPositions, XmRPointer, sizeof(XtPointer),
		offset(selectedPositions), XmRImmediate, (XtPointer) NULL},

	{XmNselectedPositionCount, XmCSelectedPositionCount, XmRInt, sizeof(int),
		offset(selectedPositionsCount), XmRImmediate, (XtPointer) 0},

	{XmNcurrentColPosition, XmCCurrentColPosition, XmRInt, sizeof(int),
		offset(CurrentColPosition), XmRImmediate, (XtPointer) 0},

	{XmNpreciseColSize, XmCPreciseColSize, XmRPointer, sizeof(XtPointer),
		offset(PublicPreciseColSize), XmRImmediate, (XtPointer) 0},

/*	{XmNnumCols, XmCNumCols, XmRInt, sizeof(int),
		offset(PublicColCount), XmRImmediate, (XtPointer) 0},*/

	{XmNnumCols, XmCNumCols, XmRInt, sizeof(int),
		offset(num_cols), XmRImmediate, (XtPointer) 1},

	{XmNlabelType, XmCLabelType, XmRLabelType, sizeof(unsigned char),
		offset(default_type), XmRImmediate, (XtPointer) XmSTRING},

	{XmNalignment, XmCAlignment, XmRAlignment, sizeof(unsigned char), 
		offset(default_align), XmRImmediate, (XtPointer) XmALIGNMENT_BEGINNING},

	{"pri.vate", "Pri.vate", XmRBoolean, sizeof(Boolean),
		offset(MouseMoved), XmRImmediate, (XtPointer)False},

	{XmNfontList,	XmCFontList, XmRFontList, sizeof (XmFontList),
		offset(font_list), XmRCallProc, (XtPointer)CheckSetRenderTable},

	{XmNrenderTable, XmCRenderTable, XmRRenderTable, sizeof(XmRenderTable),
		offset(font_list), XmRCallProc, (XtPointer)CheckSetRenderTable},

	{XmNverticalScrollBar, XmCVerticalScrollBar, XmRWidget, sizeof (Widget),
		offset(v_bar), XmRImmediate, (XtPointer) NULL},

	{XmNhorizontalScrollBar, XmCHorizontalScrollBar, XmRWidget, sizeof (Widget),
		offset(h_bar), XmRImmediate, (XtPointer) NULL},

	{XmNTitleBar, XmCTitleBar, XmRWidget, sizeof (Widget),
		offset(title_bar), XmRImmediate, (XtPointer) NULL},

	{XmNselectColor, XmCSelectColor, XmRSelectColor, sizeof(Pixel),
		offset(select_background_pixel), XmRImmediate, (XtPointer)XmREVERSED_GROUND_COLORS},

	{XmNselectForeground, XmCSelectForeground, XtRPixel, sizeof(Pixel),
		offset(select_foreground_pixel), XmRCallProc, (XtPointer) _XmBackgroundColorDefault},

	{XmNlayoutFrozen, XmCLayoutFrozen, XmRBoolean, sizeof(Boolean),
		offset(LayoutFrozen), XmRImmediate, (XtPointer) NULL},

	{XmNpropConsistency, XmCPropConsistency, XmRBoolean, sizeof(Boolean),
		offset(PropConsistency), XmRImmediate, (XtPointer) NULL},

	{XmNautoResCol, XmCAutoResCol, XmRInt, sizeof(int),
		offset(autoresize_col), XmRImmediate, (XtPointer) XmNlastColumn},
 
    {XmNlistMarginHeight, XmCListMarginHeight, XmRVerticalDimension, sizeof(Dimension),
		offset(margin_h), XmRImmediate, (XtPointer) SM_V_MARGIN},

    {XmNlistMarginWidth, XmCListMarginWidth, XmRHorizontalDimension, sizeof(Dimension),
		offset(margin_w), XmRImmediate, (XtPointer) SM_H_MARGIN},

    {XmNselectLineStyle, XmCLineStyle, XmRLineStyle, sizeof(unsigned char),
		offset(select_line_style), XmRImmediate, (XtPointer) XmSINGLE},

    {XmNselectLineWidth, XmCSelectLineWidth, XmRHorizontalDimension, sizeof(Dimension),
		offset(select_line_w), XmRImmediate, (XtPointer) 2},

    {XmNselectLineMargin, XmCSelectLineMargin, XmRHorizontalDimension, sizeof(Dimension),
		offset(select_line_margin), XmRImmediate, (XtPointer) 2},

	{XtNclickPixmapToOpen, XtCBoolean, XtRBoolean, sizeof(Boolean),
		offset(ClickPixmapToOpen), XtRImmediate, (XtPointer) True},

	{XmNlNbranchActionCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
		offset(BranchActionCallback), XmRImmediate, (XtPointer) False},

	{XtNctrlOpenPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(CtExpanded), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNctrlOpenPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(CtExpandedMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNctrlClosedPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(CtCollapsed), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNctrlClosedPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(CtCollapsedMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNbranchPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconClosed), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNbranchPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconClosedMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNbranchOpenPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconOpen), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNbranchOpenPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconOpenMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNleafPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconLeaf), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNleafPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconLeafMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNleafOpenPixmap, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconOpenLeaf), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XtNleafOpenPixmapMask, XtCPixmap, XtRBitmap, sizeof(Pixmap),
		offset(IconOpenLeafMask), XtRImmediate, (XtPointer) XmUNSPECIFIED_PIXMAP},

	{XmNlNdefaultMode, XmNlCDefaultMode, XtRBoolean, sizeof(Boolean),
		offset(default_mode), XtRImmediate, 0},

	{XtNhighlightCallback, XmCCallback, XmRCallback,sizeof(XtCallbackList),
		offset(highlightCallback), XmRImmediate, (XtPointer) NULL},

	{XmNdoubleClickCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
		offset(double_click), XmRImmediate, (XtPointer) NULL},

	{XmNlrcResizeCallback, XmCCallback, XmRCallback, sizeof(XtCallbackList),
		offset(resizeCallback), XmRImmediate, (XtPointer) NULL},

	{XmNlBufferingOn, XmCbufferingOn, XmRBoolean, sizeof(Boolean), 
		offset(buffering), XmRImmediate, (XtPointer) False},

	{XmNautoAccelScroll, XmCAutoAccelScroll, XmRBoolean, sizeof(Boolean), 
		offset(AutoDropScrollEvent), XmRImmediate, (XtPointer) False},

	{XmNlTreeMode, XmCTreeMode, XmRBoolean, sizeof(Boolean), 
		offset(TreeMode), XmRImmediate, (XtPointer) False},

	{XmNlTreeColAutoRes, XmCtreeColAutoRes, XmRBoolean, sizeof(Boolean), 
		offset(treeColAutoResize), XmRImmediate, (XtPointer) True},

	{XmNdoubleClickInterval, XmCDoubleClickInterval, XmRInt, sizeof(int), 
		offset(multiclick), XmRImmediate, (XtPointer) (-1)},

//	{XmNcolDescriptorTable, XmCColDescriptorTable, XmRColDescriptorTable, sizeof(XtPointer), 
//		offset(colDesc), XmRImmediate, (XtPointer) NULL}
#undef offset
};

#define offset(field) XtOffsetOf(XmNlResColListRec, rescol.field)
static XmSyntheticResource syn_resources[] = {
/*	{
		XmNselectedItemCount,
		sizeof(int),
		offset(PublicSelectedCount),
		GetValues_XmNselectedItemCount,
		NULL
	},
	{
		XmNselectedPositions,
		sizeof(XtPointer),
		offset(PublicSelectedPositions),
		GetValues_XmNselectedPositions,
		NULL
	},*/
	{
		XmNpreciseColSize,
		sizeof(XtPointer),
		offset(PublicPreciseColSize),
		GetValues_XmNpreciseColSize,
		NULL
	},
	{
		XmNitemCount,
		sizeof(int),
		offset(PublicRowCount),
		GetValues_XmNitemCount,
		NULL
	},
/*	{
		XmNnumCols,
		sizeof(int),
		offset(PublicColCount),
		GetValues_XmNnumCols,
		NULL
	},*/
	{
		XmNlistMarginHeight, 
		sizeof(Dimension),
		offset(margin_h), 
		XmeFromVerticalPixels,
		XmeToVerticalPixels
	},
	{
		XmNlistMarginWidth,
		sizeof (Dimension),
		offset(margin_w),
		XmeFromHorizontalPixels,
		XmeToHorizontalPixels
	},
    {
		XmNselectLineWidth, 
		sizeof(Dimension),
		offset(select_line_w), 
		XmeFromHorizontalPixels,
		XmeToHorizontalPixels
	},
    {
		XmNselectLineMargin, 
		sizeof(Dimension),
		offset(select_line_margin), 
		XmeFromHorizontalPixels,
		XmeToHorizontalPixels
	},
};
#undef offset


XmNlResColListClassRec xmNlResColListClassRec = {
	{	/* core fields */
		/* superclass	*/			SUPERCLASS,
		/* class_name	*/			"XmNlResColList",
		/* widget_size	*/			sizeof(XmNlResColListPart),
		/* class_initialize	*/		ClassInitialize,
		/* class_part_initialize */	ClassPartInitialize,
		/* class_inited	*/			FALSE,
		/* initialize */			Initialize,
		/* initialize_hook */		NULL,
		/* realize */				Realize,
		/* actions */				actionsList,
		/* num_actions */			XtNumber(actionsList),
		/* resources */				(XtResource *) resources,
		/* num_resources */			XtNumber(resources),
		/* xrm_class */				NULLQUARK,
		/* compress_motion */		TRUE,
		/* compress_exposure */		XtExposeCompressMultiple,
		/* compress_enterleave */	TRUE,
		/* visible_interest	*/		FALSE,
		/* destroy			*/		Destroy,
		/* resize			*/		Resize,
		/* expose			*/		Redisplay,
		/* set_values		*/		SetValues,
		/* set_values_hook	*/		NULL,
		/* set_values_almost */		XtInheritSetValuesAlmost,
		/* get_values_hook	*/		NULL,
		/* accept_focus		*/		NULL,
		/* version			*/		XtVersion,
		/* callback_private	*/		NULL,
		/* tm_table			*/		defaultTranslations,
		/* query_geometry	*/		XtInheritQueryGeometry,
		/* display_accelerator */	NULL, /*XtInheritDisplayAccelerator,*/
		/* extension		*/		NULL
	},
	{ /* Xmprimitive fields */
		NULL, /*XmInheritBorderHighlight,*/			/* border_highlight   */
		NULL, /*XmInheritBorderUnhighlight,*/			/* border_unhighlight */
		NULL,   /*XtInheritTranslations,*/    /* translations       */
		NULL,                     		/* arm_and_activate   */
		syn_resources,   				/* syn resources      */
		XtNumber(syn_resources),		/* num syn_resources  */
		NULL                    		/* extension          */
	},
	{ /* ICS List fields */
		NULL                      		/* extension          */
	}
};


WidgetClass xmNlResColListWidgetClass = (WidgetClass)&xmNlResColListClassRec;

XmOffsetPtr XmNlResColList_offsets;

static XtConvertArgRec selfConvertArgs[] = {
    { XtBaseOffset, (XtPointer) 0, sizeof(int) }
};


/************************************************************
*	STATIC (EXPORTED) CODE
*************************************************************/


static void CheckRenderOrder(XmNlResColListWidget rcol)
{
	XmDirection direction = ((XmPrimitiveWidget)(rcol))->primitive.layout_direction;

	if (direction == XmRIGHT_TO_LEFT_TOP_TO_BOTTOM || direction == XmRIGHT_TO_LEFT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_RIGHT_TO_LEFT
		|| direction == XmBOTTOM_TO_TOP_RIGHT_TO_LEFT || direction == XmRIGHT_TO_LEFT)
	{
		rcol->rescol.render_order = RtoL_render;
		return ;
	}

	if (direction == XmLEFT_TO_RIGHT_TOP_TO_BOTTOM || direction == XmLEFT_TO_RIGHT_BOTTOM_TO_TOP || direction == XmTOP_TO_BOTTOM_LEFT_TO_RIGHT
		|| direction == XmBOTTOM_TO_TOP_LEFT_TO_RIGHT || direction == XmLEFT_TO_RIGHT)
	{
		rcol->rescol.render_order = LtoR_render;
		return ;
	}

	rcol->rescol.render_order = LtoR_render;
	return ;
}



static void
MakeInternColorPixmap(XmNlResColListWidget rcol, Pixinfo * pix, unsigned char * data,
	unsigned int width, unsigned int height, char ** color, int count, Boolean selected)
{
	GC gc;
	XGCValues values;
	unsigned long valuemask;


//	Window root;
	int x, y, i, delta, n;
	unsigned int width1, height1;
	unsigned int bw, depth;
	unsigned char *tmp_bitmap;
	Pixmap mask1, mask2, pix1, pix2/*, ypix*/;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	Colormap colmap;
	XColor col_1, col_2;

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;

	delta = width/8;
	if (delta * 8 < width)
	{
		delta = (delta + 1) * height;
	}
	else
	{
		delta = delta * height;
	}
	tmp_bitmap = calloc(delta, sizeof(unsigned char));
	pix->width = (int) width;
	pix->height = (int) height;
	if (pix->height>rcol->rescol.maxPixHeight)
		rcol->rescol.maxPixHeight = pix->height;

	if (pix->mask != XmUNSPECIFIED_PIXMAP)
		XFreePixmap(XtDisplay((Widget) rcol), pix->mask);

	if (pix->pix != XmUNSPECIFIED_PIXMAP)
		XFreePixmap(XtDisplay((Widget) rcol), pix->mask);

	pix->pix = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, rcol->core.depth);

	pix2 = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, rcol->core.depth);

/*	if (selected)
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
	else
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, background_color);
	XFillRectangle(XtDisplay((Widget) rcol), pix->pix, rcol->rescol.pixGC, 0, 0, width, height);
*/


	colmap=DefaultColormapOfScreen(XtScreen((Widget) rcol));

/*	XSetForeground(XtDisplay((Widget) rcol), gc, ((XmPrimitiveWidget)rcol)->core.background_pixel);
		XFillRectangle(XtDisplay((Widget) rcol), pix->pix, gc, 0,0, width, height);
	XSetForeground(XtDisplay((Widget) rcol), gc, rcol->rescol.foreground_pixel);*/

	for (i = 0; i < count; i++)
	{
		for (n = 0; n < delta; n++)
		{
			tmp_bitmap[n] = tmp_bitmap[n] | data[i * delta + n];
		}
		XAllocNamedColor(XtDisplay((Widget) rcol), colmap, &(color[i][0]), &col_1, &col_2);

		pix1 = XCreatePixmapFromBitmapData(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
										&(data[i*delta]), width, height,
										col_2.pixel, rcol->core.background_pixel,
										rcol->core.depth);

		mask1 = XCreateBitmapFromData(XtDisplay((Widget) rcol),
									RootWindowOfScreen(XtScreen((Widget) rcol)),
									&(data[i*delta]), width, height);

		XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, mask1);
		XCopyArea(XtDisplay((Widget) rcol), pix1, pix2, rcol->rescol.pixGC,
				0, 0, width, height, 0, 0);

		XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
		XFreePixmap(XtDisplay((Widget) rcol), mask1);
		XFreePixmap(XtDisplay((Widget) rcol), pix1);
	}

	pix->mask = XCreateBitmapFromData(XtDisplay((Widget) rcol),
									RootWindowOfScreen(XtScreen((Widget) rcol)),
									tmp_bitmap, width, height);

	valuemask = GCFunction;
	values.function = GXcopyInverted;
	gc = XCreateGC(XtDisplay((Widget) rcol), pix->mask, valuemask, &values);

	XCopyArea(XtDisplay((Widget) rcol), pix->mask, pix->mask, gc, 0, 0, width, height, 0, 0);
	XFreeGC(XtDisplay((Widget) rcol), gc);

	XCopyArea(XtDisplay((Widget) rcol), pix2, pix->pix, rcol->rescol.pixGC,
			0, 0, width, height, 0, 0);

	XSetClipOrigin(XtDisplay((Widget) rcol), rcol->rescol.pixGC, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, pix->mask);
	if (selected)
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
	else
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, background_color);
	XFillRectangle(XtDisplay((Widget) rcol), pix->pix, rcol->rescol.pixGC, 0, 0, width, height);


	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
	XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.foreground_pixel);


/*	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, pix->mask);
	XCopyArea(XtDisplay((Widget) rcol), pix2, pix->pix, rcol->rescol.pixGC,
			0, 0, width, height, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);*/
	XFreePixmap (XtDisplay((Widget) rcol), pix2);

	free(tmp_bitmap);
}

static void
MakeControlPixmap(XmNlResColListWidget rcol, Pixinfo * pix)
{
  Window root;
  int x, y;
  unsigned int width, height, bw, depth;

  if (PIX_FOUND(pix->pix) && XGetGeometry(XtDisplay((Widget) rcol), pix->pix,
      &root, &x, &y, &width, &height, &bw, &depth)) {
    pix->width = (int) width;
    pix->height = (int) height;
    if (pix->height>rcol->rescol.maxPixHeight)
      rcol->rescol.maxPixHeight=pix->height;
    if (pix->height>rcol->rescol.ctrlHeight)
      rcol->rescol.ctrlHeight=pix->height;
    if (pix->width>rcol->rescol.ctrlWidth)
      rcol->rescol.ctrlWidth=pix->width;

  }
  else {
    pix->width = pix->height = 0;
    pix->pix = (Pixmap) NULL;
  }
}


static void
FreePixmap(XmNlResColListWidget rcol, Pixinfo * pix)
{
	if (pix->pix != XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay((Widget) rcol), pix->pix);
		pix->pix = XmUNSPECIFIED_PIXMAP;
	}
	if (pix->mask != XmUNSPECIFIED_PIXMAP)
	{
		XFreePixmap(XtDisplay((Widget) rcol), pix->mask);
		pix->mask = XmUNSPECIFIED_PIXMAP;
	}
}

Pixmap GetBuiltinMask(XmNlResColListWidget rcol, char * name)
{
	Window root;
	Pixmap tmppix, workpix;
	int x, y;
	unsigned int width, height;
	unsigned int bw, depth;

	tmppix = XmGetPixmapByDepth( XtScreen((Widget) rcol), name,
							WhitePixelOfScreen(XtScreen((Widget)rcol)),
							BlackPixelOfScreen(XtScreen((Widget)rcol)),
							1);
	if (tmppix != XmUNSPECIFIED_PIXMAP)
	{
		XGetGeometry(XtDisplay((Widget) rcol), tmppix,
				&root, &x, &y, &width, &height, &bw, &depth);

		workpix=XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, 1);
		XGetGeometry(XtDisplay((Widget) rcol), workpix,
				&root, &x, &y, &width, &height, &bw, &depth);

//		XCopyArea(XtDisplay((Widget) rcol), tmppix, workpix, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);

//		XmDestroyPixmap(XtScreen((Widget) rcol), tmppix);

		return tmppix;
	}
	else
		return XmUNSPECIFIED_PIXMAP;
}


Pixmap GetBuiltinPix(XmNlResColListWidget rcol, char * name, Boolean selected)
{
	Window root;
	Pixmap tmppix, workpix;
	int x, y;
	unsigned int width, height;
	unsigned int bw, depth;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;

	sel_fg_color=rcol->rescol.select_foreground_pixel;

	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;

	if (selected)
		tmppix = XmGetPixmap(XtScreen((Widget) rcol), name,
							sel_fg_color,
							sel_bg_color);
	else
		tmppix=XmGetPixmap(XtScreen((Widget) rcol), name,
							rcol->rescol.foreground_pixel,
							rcol->core.background_pixel);

	if (tmppix != XmUNSPECIFIED_PIXMAP)
	{
		XGetGeometry(XtDisplay((Widget) rcol), tmppix,
				&root, &x, &y, &width, &height, &bw, &depth);

		workpix=XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, depth);
		XCopyArea(XtDisplay((Widget) rcol), tmppix, workpix, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);

//		XmDestroyPixmap(XtScreen((Widget) rcol), tmppix);

		return workpix;
	}
	else
		return XmUNSPECIFIED_PIXMAP;
}


static void
RefreshCtlPixInfo(XmNlResColListWidget rcol, Pixinfo * pix, Boolean selected)
{
	unsigned long sel_bg_color;

	if (PIX_FOUND(pix->pix) && PIX_FOUND(pix->mask))
	{
		XSetClipOrigin(XtDisplay((Widget) rcol), rcol->rescol.pixGC, 0, 0);
		XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, pix->mask);

		if (selected)
		{
			if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
				sel_bg_color = rcol->primitive.foreground;
			else
				sel_bg_color = rcol->rescol.select_background_pixel;

			XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
		}
		else
		{
			XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.background_pixel);
		}
	
		XFillRectangle(XtDisplay((Widget) rcol), pix->pix, rcol->rescol.pixGC, 0, 0, pix->width, pix->height);

		XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.foreground_pixel);
	} 
}


static void
RefreshAllPixmaps(XmNlResColListWidget rcol)
{

	RefreshCtlPixInfo(rcol, &rcol->rescol.Closed, False);

	RefreshCtlPixInfo(rcol, &rcol->rescol.Open, False);

	RefreshCtlPixInfo(rcol, &rcol->rescol.Leaf, False);

	RefreshCtlPixInfo(rcol, &rcol->rescol.LeafOpen, False);


	RefreshCtlPixInfo(rcol, &rcol->rescol.ClosedSelected, True);

	RefreshCtlPixInfo(rcol, &rcol->rescol.OpenSelected, True);

	RefreshCtlPixInfo(rcol, &rcol->rescol.LeafSelected, True);

	RefreshCtlPixInfo(rcol, &rcol->rescol.LeafOpenSelected, True);
	
	if (!rcol->rescol.ControlCollapsedBuiltin)
	{
		RefreshCtlPixInfo(rcol, &rcol->rescol.ControlCollapsed, False);
		RefreshCtlPixInfo(rcol, &rcol->rescol.ControlCollapsedSelected, True);
	}
	else
	{
		if (PIX_FOUND(rcol->rescol.ControlCollapsed.pix))
			XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlCollapsed.pix);

		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlCollapsed.pix = GetBuiltinPix(rcol, "collapsed", False);
		else
			rcol->rescol.ControlCollapsed.pix = GetBuiltinPix(rcol, "collapsed_rtol", False);


		if (PIX_FOUND(rcol->rescol.ControlCollapsedSelected.pix))
			XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlCollapsedSelected.pix);

		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlCollapsedSelected.pix = GetBuiltinPix(rcol, "collapsed", True);
		else
			rcol->rescol.ControlCollapsedSelected.pix = GetBuiltinPix(rcol, "collapsed_rtol", True);
	}
	
	if (!rcol->rescol.ControlExpandedBuiltin)
	{
		RefreshCtlPixInfo(rcol, &rcol->rescol.ControlExpanded, False);
		RefreshCtlPixInfo(rcol, &rcol->rescol.ControlExpandedSelected, True);
	}
	else
	{
		if (PIX_FOUND(rcol->rescol.ControlExpanded.pix))
			XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlExpanded.pix);

		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlExpanded.pix = GetBuiltinPix(rcol, "expanded", False);
		else
			rcol->rescol.ControlExpanded.pix = GetBuiltinPix(rcol, "expanded_rtol", False);


		if (PIX_FOUND(rcol->rescol.ControlExpandedSelected.pix))
			XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlExpandedSelected.pix);

		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlExpandedSelected.pix = GetBuiltinPix(rcol, "expanded", True);
		else
			rcol->rescol.ControlExpandedSelected.pix = GetBuiltinPix(rcol, "expanded_rtol", True);
	}

	/************* !!!!!!!!!!!!!! ****************/
	return ;
//	if (rcol->rescol.ControlClosed.mask != NULL && rcol->rescol.ControlClosed.pix != NULL) RefreshPixmap(lt, &rcol->rescol.ControlClosed);
//	if (rcol->rescol.ControlOpen.mask != NULL && rcol->rescol.ControlOpen.pix != NULL) RefreshPixmap(lt, &rcol->rescol.ControlOpen);

}




static void
RefreshCtlPixmap(XmNlResColListWidget rcol, Pixmap srcpix, Pixmap mask, Pixinfo * pix, Boolean selected)
{
	Pixmap mbuf;
	GC gc;
	XGCValues values;
	unsigned long valuemask;


/*	Colormap colmap;
	XColor col_1, col_2;*/
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;



	XGetGeometry(XtDisplay((Widget) rcol), srcpix, &root,
		&x, &y, &width, &height, &bw, &depth);

	pix->width = width;
	pix->height = height;


	if (PIX_FOUND(pix->pix)) 
		XFreePixmap(XtDisplay((Widget) rcol), pix->pix);

	pix->pix = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, depth);


	if (PIX_FOUND(pix->mask)) 
		XFreePixmap(XtDisplay((Widget) rcol), pix->mask);

	pix->mask = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, 1);


	valuemask = GCFunction;
	values.function = GXcopyInverted;
	gc = XCreateGC(XtDisplay((Widget) rcol), mask, valuemask, &values);

	XCopyArea(XtDisplay((Widget) rcol), mask, pix->mask, gc, 0, 0, width, height, 0, 0);
	XFreeGC(XtDisplay((Widget) rcol), gc);

	XCopyArea(XtDisplay((Widget) rcol), srcpix, pix->pix, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);

	XSetClipOrigin(XtDisplay((Widget) rcol), rcol->rescol.pixGC, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, pix->mask);
	if (selected)
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
	else
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, background_color);
	XFillRectangle(XtDisplay((Widget) rcol), pix->pix, rcol->rescol.pixGC, 0, 0, width, height);


	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
	XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.foreground_pixel);
}





static void
RefreshCtlPixmapBack(XmNlResColListWidget rcol, Pixmap srcpix, Pixmap mask, Pixinfo * pix, Boolean selected)
{
	Pixmap mbuf;
	GC gc;
	XGCValues gcv;
	Colormap colmap;
	XColor col_1, col_2;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color=rcol->primitive.foreground;
	else
		sel_bg_color=rcol->rescol.select_background_pixel;



	XGetGeometry(XtDisplay((Widget) rcol), srcpix, &root,
		&x, &y, &width, &height, &bw, &depth);

	pix->width = width;
	pix->height = height;


	if (PIX_FOUND(pix->pix)) XFreePixmap(XtDisplay((Widget) rcol), pix->pix);

	pix->pix = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, depth);
	pix->mask = mask;
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
	if (selected)
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
	else
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, background_color);
	XFillRectangle(XtDisplay((Widget) rcol), pix->pix, rcol->rescol.pixGC, 0, 0, width, height);

	XSetClipOrigin(XtDisplay((Widget) rcol), rcol->rescol.pixGC, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, mask);

	XCopyArea(XtDisplay((Widget) rcol), srcpix, pix->pix, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
	XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.foreground_pixel);
}


static void
RefreshPixmap(XmNlResColListWidget rcol, Pixinfo * pix, Boolean selected)
{
	Pixmap mbuf;
	GC gc;
	XGCValues gcv;
	Colormap colmap;
	XColor col_1, col_2;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
	Window root;
	int x, y;
	unsigned int width, height, bw, depth;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color=rcol->primitive.foreground;
	else
		sel_bg_color=rcol->rescol.select_background_pixel;



      gcv.background = rcol->core.background_pixel;
      gcv.foreground = rcol->rescol.foreground_pixel;
      gcv.function = GXcopyInverted;
//      gcv.function = GXinvert;
      gc = XCreateGC(XtDisplay((Widget) rcol),
        RootWindowOfScreen(XtScreen((Widget) rcol)),
        GCForeground | GCBackground | GCFunction, &gcv);
//        GCFunction, &gcv);
//	colmap=DefaultColormapOfScreen(XtScreen((Widget) lt));
	XGetGeometry(XtDisplay((Widget) rcol), pix->pix, &root,
		&x, &y, &width, &height, &bw, &depth);
//	printf("w=%i h=%i\n", width1, height1);
//	fflush(stdout);

	mbuf = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
				width, height, depth);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
	if (selected)
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_fg_color);
	else
		XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, sel_bg_color);
	XFillRectangle(XtDisplay((Widget) rcol), mbuf, rcol->rescol.pixGC, 0, 0, width, height);
//	XCopyArea(XtDisplay((Widget) lt), pix->pix, pix->mask, gc, 0, 0, width1, height1, 0, 0);
//	XCopyArea(XtDisplay((Widget) lt), NULL, pix->mask, gc, 0, 0, width1, height1, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, pix->mask);
//	XSetClipMask(XtDisplay((Widget) lt), rcol->rescol.copyGC, pix->mask);
	XCopyArea(XtDisplay((Widget) rcol), pix->pix, mbuf, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);
	XSetClipMask(XtDisplay((Widget) rcol), rcol->rescol.pixGC, None);
//	XSetForeground(XtDisplay((Widget) lt), rcol->rescol.copyGC, lt->core.background_pixel);
//	XFillRectangle(XtDisplay((Widget) lt), pix->pix, gc, 0,0, width1, height1);
	XSetForeground(XtDisplay((Widget) rcol), rcol->rescol.pixGC, rcol->rescol.foreground_pixel);
	XCopyArea(XtDisplay((Widget) rcol), mbuf, pix->pix, rcol->rescol.pixGC, 0, 0, width, height, 0, 0);
    XFreePixmap(XtDisplay((Widget) rcol), mbuf);
}


static void
InitializePixmaps(XmNlResColListWidget rcol)
{
	Window root;
	Pixmap tmppix;
	int x, y;
	unsigned int width, height;
	unsigned int bw, depth;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
//	Pixmap mask1, mask2, pix1, ypix;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color=rcol->primitive.foreground;
	else
		sel_bg_color=rcol->rescol.select_background_pixel;

	rcol->rescol.maxPixHeight=0;

	if (rcol->rescol.IconClosed == XmUNSPECIFIED_PIXMAP)
	{
		MakeInternColorPixmap(rcol, &rcol->rescol.Closed,
							folder_icon, folder_width, folder_height, folder_color, 2, False);
		MakeInternColorPixmap(rcol, &rcol->rescol.ClosedSelected,
							folder_icon, folder_width, folder_height, folder_color, 2, True);
		if (folder_width > rcol->rescol.pixWidth) rcol->rescol.pixWidth = folder_width;
		if (folder_height > rcol->rescol.maxPixHeight) rcol->rescol.maxPixHeight = folder_height;
	}
	else
	{
		RefreshCtlPixmap(rcol, rcol->rescol.IconClosed, rcol->rescol.IconClosedMask,
						&rcol->rescol.Closed, False);
		RefreshCtlPixmap(rcol, rcol->rescol.IconClosed, rcol->rescol.IconClosedMask,
						&rcol->rescol.ClosedSelected, True);
//		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.Closed.pix,
//      		&root, &x, &y, &width, &height, &bw, &depth);
//    rcol->rescol.Closed.width = (int) width;
//    rcol->rescol.Closed.height = (int) height;
		if (rcol->rescol.Closed.height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=rcol->rescol.Closed.height;
		if (rcol->rescol.Closed.width>rcol->rescol.pixWidth)
			rcol->rescol.pixWidth=rcol->rescol.Closed.width;
//	if (rcol->rescol.Closed.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.Closed, False);
	}

	if (rcol->rescol.IconOpen == XmUNSPECIFIED_PIXMAP)
	{
		MakeInternColorPixmap(rcol, &rcol->rescol.Open,
							folderopen_icon, folderopen_width, folderopen_height, folder_color, 2, False);
		MakeInternColorPixmap(rcol, &rcol->rescol.OpenSelected,
							folderopen_icon, folderopen_width, folderopen_height, folder_color, 2, True);
		if (folderopen_width > rcol->rescol.pixWidth) rcol->rescol.pixWidth = folderopen_width;
		if (folderopen_height > rcol->rescol.maxPixHeight) rcol->rescol.maxPixHeight = folderopen_height;
	}
	else
	{
//		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.Open.pix,
//      		&root, &x, &y, &width, &height, &bw, &depth);
//    rcol->rescol.Open.width = (int) width;
//    rcol->rescol.Open.height = (int) height;
		RefreshCtlPixmap(rcol, rcol->rescol.IconOpen, rcol->rescol.IconOpenMask,
						&rcol->rescol.Open, False);
		RefreshCtlPixmap(rcol, rcol->rescol.IconOpen, rcol->rescol.IconOpenMask,
						&rcol->rescol.OpenSelected, True);
		if (rcol->rescol.Open.height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=rcol->rescol.Open.height;
		if (rcol->rescol.Open.width>rcol->rescol.pixWidth)
			rcol->rescol.pixWidth=rcol->rescol.Open.width;
//	if (rcol->rescol.Open.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.Open, False);
	}

	if (rcol->rescol.IconLeaf == XmUNSPECIFIED_PIXMAP)
	{
		MakeInternColorPixmap(rcol, &rcol->rescol.Leaf,
					document_icon, document_width, document_height, file_color, 2, False);
		MakeInternColorPixmap(rcol, &rcol->rescol.LeafSelected,
					document_icon, document_width, document_height, file_color, 2, True);
		if (document_width > rcol->rescol.pixWidth) rcol->rescol.pixWidth = document_width;
		if (document_height > rcol->rescol.maxPixHeight) rcol->rescol.maxPixHeight = document_height;
	}
	else
	{
/*		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.Leaf.pix,
      		&root, &x, &y, &width, &height, &bw, &depth);
    rcol->rescol.Leaf.width = (int) width;
    rcol->rescol.Leaf.height = (int) height;*/
		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.IconLeaf,
      		&root, &x, &y, &width, &height, &bw, &depth);
		RefreshCtlPixmap(rcol, rcol->rescol.IconLeaf, rcol->rescol.IconLeafMask,
						&rcol->rescol.Leaf, False);
		RefreshCtlPixmap(rcol, rcol->rescol.IconLeaf, rcol->rescol.IconLeafMask,
						&rcol->rescol.LeafSelected, True);
		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.Leaf.pix,
      		&root, &x, &y, &width, &height, &bw, &depth);

		if (rcol->rescol.Leaf.height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=rcol->rescol.Leaf.height;
		if (rcol->rescol.Leaf.width>rcol->rescol.pixWidth)
			rcol->rescol.pixWidth=rcol->rescol.Leaf.width;
//	if (rcol->rescol.Leaf.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.Leaf, False);
	}

	if (rcol->rescol.IconOpenLeaf == XmUNSPECIFIED_PIXMAP)
	{
		MakeInternColorPixmap(rcol, &rcol->rescol.LeafOpen,
						document_icon, document_width, document_height, file_color, 2, False);
		MakeInternColorPixmap(rcol, &rcol->rescol.LeafOpenSelected,
						document_icon, document_width, document_height, file_color, 2, True);
		if (document_width > rcol->rescol.pixWidth) rcol->rescol.pixWidth = document_width;
		if (document_height > rcol->rescol.maxPixHeight) rcol->rescol.maxPixHeight = document_height;
	}
	else
	{
/*		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.LeafOpen.pix,
      		&root, &x, &y, &width, &height, &bw, &depth);
    rcol->rescol.LeafOpen.width = (int) width;
    rcol->rescol.LeafOpen.height = (int) height;*/
		RefreshCtlPixmap(rcol, rcol->rescol.IconOpenLeaf, rcol->rescol.IconOpenLeafMask,
						&rcol->rescol.LeafOpen, False);
		RefreshCtlPixmap(rcol, rcol->rescol.IconOpenLeaf, rcol->rescol.IconOpenLeafMask,
						&rcol->rescol.LeafOpenSelected, True);
		if (rcol->rescol.LeafOpen.height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=rcol->rescol.LeafOpen.height;
		if (rcol->rescol.LeafOpen.width>rcol->rescol.pixWidth)
			rcol->rescol.pixWidth=rcol->rescol.LeafOpen.width;
//	if (rcol->rescol.LeafOpen.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.LeafOpen, False);
	}


/****** Control pixmap ******/


	if (rcol->rescol.CtCollapsed == XmUNSPECIFIED_PIXMAP)
	{
		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlCollapsed.pix = GetBuiltinPix(rcol, "collapsed", False);
		else
			rcol->rescol.ControlCollapsed.pix = GetBuiltinPix(rcol, "collapsed_rtol", False);

		MakeControlPixmap(rcol, &rcol->rescol.ControlCollapsed);
		rcol->rescol.ControlCollapsedBuiltin = True;

		if (rcol->rescol.render_order == LtoR_render)
			rcol->rescol.ControlCollapsedSelected.pix = GetBuiltinPix(rcol, "collapsed", True);
		else
			rcol->rescol.ControlCollapsedSelected.pix = GetBuiltinPix(rcol, "collapsed_rtol", True);

		MakeControlPixmap(rcol, &rcol->rescol.ControlCollapsedSelected);
	}
	else
	{
		RefreshCtlPixmap(rcol, rcol->rescol.CtCollapsed, rcol->rescol.CtCollapsedMask, &rcol->rescol.ControlCollapsed, False);
		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.ControlCollapsed.pix,
      		&root, &x, &y, &width, &height, &bw, &depth);
		rcol->rescol.ControlCollapsed.width = (int) width;
		rcol->rescol.ControlCollapsed.height = (int) height;
		if (height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=height;
		if (height>rcol->rescol.ctrlHeight)
			rcol->rescol.ctrlHeight=height;
		if (width>rcol->rescol.ctrlWidth)
			rcol->rescol.ctrlWidth=width;
//		if (rcol->rescol.ControlClosed.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.ControlClosed, False);

		if (width > 0 && height > 0)
		{
/*			if (rcol->rescol.ControlClosedSelected.pix != XmUNSPECIFIED_PIXMAP)
						XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlClosedSelected.pix);

			rcol->rescol.ControlClosedSelected.pix = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, depth);
			XCopyArea(XtDisplay((Widget) rcol), rcol->rescol.ControlClosed.pix, rcol->rescol.ControlClosedSelected.pix,
					rcol->rescol.pixGC, 0, 0, width, height, 0, 0);

			if (rcol->rescol.ControlClosedSelected.mask != XmUNSPECIFIED_PIXMAP)
						XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlClosedSelected.mask);

			rcol->rescol.ControlClosedSelected.mask = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, 1);
			XCopyArea(XtDisplay((Widget) rcol), rcol->rescol.ControlClosed.mask, rcol->rescol.ControlClosedSelected.mask,
					rcol->rescol.pixGC, 0, 0, width, height, 0, 0);*/
			RefreshCtlPixmap(rcol, rcol->rescol.CtCollapsed, rcol->rescol.CtCollapsedMask, &rcol->rescol.ControlCollapsedSelected, True);

			rcol->rescol.ControlCollapsedSelected.width = (int) width;
			rcol->rescol.ControlCollapsedSelected.height = (int) height;

		}

		rcol->rescol.ControlCollapsedBuiltin = False;
	}

	if (rcol->rescol.CtExpanded == XmUNSPECIFIED_PIXMAP)
	{
		rcol->rescol.ControlExpanded.pix = GetBuiltinPix(rcol, "expanded", False);

/*		if (rcol->rescol.ControlOpen.mask == XtUnspecifiedPixmap)
			rcol->rescol.ControlOpen.mask = GetBuiltinMask(rcol, "expanded");*/

		MakeControlPixmap(rcol, &rcol->rescol.ControlExpanded);

		rcol->rescol.ControlExpandedBuiltin = True;

		rcol->rescol.ControlExpandedSelected.pix = GetBuiltinPix(rcol, "expanded", True);

/*		if (rcol->rescol.ControlOpenSelected.mask == XtUnspecifiedPixmap)
			rcol->rescol.ControlOpenSelected.mask = GetBuiltinMask(rcol, "expanded");*/

		MakeControlPixmap(rcol, &rcol->rescol.ControlExpandedSelected);
	}
	else
	{
		RefreshCtlPixmap(rcol, rcol->rescol.CtExpanded, rcol->rescol.CtExpandedMask, &rcol->rescol.ControlExpanded, False);
		XGetGeometry(XtDisplay((Widget) rcol), rcol->rescol.ControlExpanded.pix,
				&root, &x, &y, &width, &height, &bw, &depth);
		rcol->rescol.ControlExpanded.width = (int) width;
		rcol->rescol.ControlExpanded.height = (int) height;
		if (height>rcol->rescol.maxPixHeight)
			rcol->rescol.maxPixHeight=height;
		if (height>rcol->rescol.ctrlHeight)
			rcol->rescol.ctrlHeight=height;
		if (width>rcol->rescol.ctrlWidth)
			rcol->rescol.ctrlWidth=width;
//		if (rcol->rescol.ControlOpen.mask != XtUnspecifiedPixmap) RefreshPixmap(rcol, &rcol->rescol.ControlOpen, False);

		if (width > 0 && height > 0)
		{
/*			if (rcol->rescol.ControlOpenSelected.pix != XmUNSPECIFIED_PIXMAP)
						XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlOpenSelected.pix);

			rcol->rescol.ControlOpenSelected.pix = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, depth);
			XCopyArea(XtDisplay((Widget) rcol), rcol->rescol.ControlOpen.pix, rcol->rescol.ControlOpenSelected.pix,
					rcol->rescol.pixGC, 0, 0, width, height, 0, 0);

			if (rcol->rescol.ControlOpenSelected.mask != XmUNSPECIFIED_PIXMAP)
						XFreePixmap(XtDisplay((Widget) rcol), rcol->rescol.ControlOpenSelected.mask);

			rcol->rescol.ControlOpenSelected.mask = XCreatePixmap(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
					width, height, 1);
			XCopyArea(XtDisplay((Widget) rcol), rcol->rescol.ControlOpen.mask, rcol->rescol.ControlOpenSelected.mask,
					rcol->rescol.pixGC, 0, 0, width, height, 0, 0);*/

			RefreshCtlPixmap(rcol, rcol->rescol.CtExpanded, rcol->rescol.CtExpandedMask, &rcol->rescol.ControlExpandedSelected, True);

			rcol->rescol.ControlExpandedSelected.width = (int) width;
			rcol->rescol.ControlExpandedSelected.height = (int) height;

		}

		rcol->rescol.ControlExpandedBuiltin = False;


	}

return ;
  rcol->rescol.pixWidth = rcol->rescol.Closed.width;
  if (rcol->rescol.Open.width > rcol->rescol.pixWidth)
    rcol->rescol.pixWidth = rcol->rescol.Open.width;
  if (rcol->rescol.Leaf.width > rcol->rescol.pixWidth)
    rcol->rescol.pixWidth = rcol->rescol.Leaf.width;
  if (rcol->rescol.LeafOpen.width > rcol->rescol.pixWidth)
    rcol->rescol.pixWidth = rcol->rescol.LeafOpen.width;
  rcol->rescol.Closed.xoff = (rcol->rescol.pixWidth - rcol->rescol.Closed.width) / 2;
  rcol->rescol.Open.xoff = (rcol->rescol.pixWidth - rcol->rescol.Open.width) / 2;
  rcol->rescol.Leaf.xoff = (rcol->rescol.pixWidth - rcol->rescol.Leaf.width) / 2;
  rcol->rescol.LeafOpen.xoff = (rcol->rescol.pixWidth - rcol->rescol.LeafOpen.width) / 2;

  rcol->rescol.ctrlWidth = rcol->rescol.ControlCollapsed.width;
  if (rcol->rescol.ControlExpanded.width > rcol->rescol.ctrlWidth)
    rcol->rescol.ctrlWidth = rcol->rescol.ControlExpanded.width;
  rcol->rescol.ControlCollapsed.xoff = (rcol->rescol.ctrlWidth - rcol->rescol.ControlCollapsed.width) / 2;
  rcol->rescol.ControlExpanded.xoff = (rcol->rescol.ctrlWidth - rcol->rescol.ControlExpanded.width) / 2;
}


static void
DestroyGC(XmNlResColListWidget w)
{
	XFreeGC(XtDisplay((Widget) w), w->rescol.drawGC);
	XFreeGC(XtDisplay((Widget) w), w->rescol.tdrawGC);
	XFreeGC(XtDisplay((Widget) w), w->rescol.pixGC);
	XFreeGC(XtDisplay((Widget) w), w->rescol.eorGC);
	XFreeGC(XtDisplay((Widget) w), w->rescol.highlightGC);

/*
	XtReleaseGC((Widget) w, w->rescol.drawGC);
	XtReleaseGC((Widget) w, w->rescol.tdrawGC);
	XtReleaseGC((Widget) w, w->rescol.pixGC);
	XtReleaseGC((Widget) w, w->rescol.eorGC);
	XtReleaseGC((Widget) w, w->rescol.highlightGC);*/
}

static void
InitializeGC(XmNlResColListWidget w)
{
	XGCValues values;
	unsigned long mask;


	values.line_style = LineSolid;
	values.line_width = 1;
	values.fill_style = FillSolid;
	values.background = w->rescol.background_pixel;
	values.foreground = w->rescol.foreground_pixel;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->rescol.drawGC = XCreateGC(XtDisplay((Widget) w), XRootWindowOfScreen(XtScreen((Widget) w)), mask, &values);


	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;
	w->rescol.tdrawGC = XCreateGC(XtDisplay((Widget) w), XRootWindowOfScreen(XtScreen((Widget) w)), mask, &values);
//  w->rescol.tdrawGC = XCreateGC(XtDisplay((Widget) w),XtWindow((Widget) w), mask, &values);


	values.function = GXcopy;
	mask = GCFunction;
	w->rescol.pixGC = XCreateGC(XtDisplay((Widget) w), XRootWindowOfScreen(XtScreen((Widget) w)), mask, &values);

	values.function = GXinvert;
//  mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFont | GCFunction;

	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFunction;

	w->rescol.eorGC = XCreateGC(XtDisplay((Widget) w), XRootWindowOfScreen(XtScreen((Widget) w)), mask, &values);

	values.background = (Pixel)XtDefaultForeground;
	values.foreground = w->core.background_pixel;
//  mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground | GCFont;
	mask = GCLineStyle | GCLineWidth | GCFillStyle | GCForeground | GCBackground;


	w->rescol.highlightGC = XCreateGC(XtDisplay((Widget) w), XRootWindowOfScreen(XtScreen((Widget) w)), mask, &values);
}


/*      Function Name: ClassInitialize
 *      Description:   Inits class-specific data (offsets)
 *      Arguments:     none
 *      Returns:       nothing
 */
static void
ClassInitialize()
{
    XmResolveAllPartOffsets(xmNlResColListWidgetClass,
			    &XmNlResColList_offsets,
			    NULL);
//	XtSetTypeConverter(XmRString, XmRColDescriptorTable, ColDescriptorConverter, 
//						selfConvertArgs, XtNumber(selfConvertArgs), (XtCacheNone | XtCacheRefCount), ColDescriptorDestroy);
}


static void
CheckSetRenderTable(Widget wid, int offset, XrmValue *value)
{

	XmNlResColListWidget rcol = (XmNlResColListWidget) wid;

	if (rcol->rescol.MouseMoved)
		value->addr = NULL;
	else
	{
		value->addr = (char*)&(rcol->rescol.font_list);
		rcol->rescol.MouseMoved = True;
	}
}

static void
ClassPartInitialize(WidgetClass wc)
{
  char *xlats;

//  _XmFastSubclassInit (wc, XmLIST_BIT);

  xlats = (char *)malloc(strlen(defaultTranslations) + 1);
  strcpy(xlats, defaultTranslations);
  wc->core_class.tm_table =(String) XtParseTranslationTable(xlats);
  free((char *)xlats);

  /* Install transfer trait */
//  XmeTraitSet((XtPointer)wc, XmQTtransfer, (XtPointer) &ListTransfer);
}


/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */
/* !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!! */

static void
InitializeGeometry(Widget w)
{
/*  XmNlListTreeWidget lt = (XmNlListTreeWidget) w;
	lt->list.XOffset = 0;

  if (XtHeight(w) < 10) {
    int working;

    working = FontHeight(lt->list.font);
    if (lt->list.maxPixHeight>working) working=lt->list.maxPixHeight;
    working+=lt->list.VSpacing;

    if (lt->list.visibleCount==0)
      lt->list.visibleCount=1;

    lt->list.preferredHeight=working*lt->list.visibleCount;
    lt->list.preferredWidth=200;
    XtWidth(w)=lt->list.preferredWidth + 2*lt->primitive.shadow_thickness
      + 2*lt->primitive.highlight_thickness;
    XtHeight(w)=lt->list.preferredHeight + 2*lt->primitive.shadow_thickness
      + 2*lt->primitive.highlight_thickness;
  }
  else {
    lt->list.preferredWidth = XtWidth(w) - 2*lt->primitive.shadow_thickness
      - 2*lt->primitive.highlight_thickness;
    lt->list.preferredHeight = XtHeight(w) - 2*lt->primitive.shadow_thickness
      - 2*lt->primitive.highlight_thickness;
  }*/
}


static void VisibilityChangeProc(Widget w, XtPointer client_data, XEvent* event, Boolean* cont)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XVisibilityEvent * vevent = (XVisibilityEvent *) event;


	rcol->rescol.VisibilityState=vevent->state;

#ifdef DEBUG
	printf("vvvvv state = %d vvvvvv\n", vevent->state);
#endif

}

void CheckRendition(XmRenderTable table, Boolean * xft)
{
	int count, i, n;
	XmStringTag *tags;
	XmRendition rendition;
	Arg args[5];
	XmFontType fontType;
	
	
	count = XmRenderTableGetTags(table, &tags);
	
	*xft = False;

	for (i = 0; i < count; i++) {
		rendition = XmRenderTableGetRendition(table, tags[i]);
		if (rendition)
		{
			n = 0;
			XtSetArg (args[n], XmNfontType, &fontType); n++;
			XmRenditionRetrieve(rendition, args, n);

#ifdef DEBUG
			if (fontType == XmFONT_IS_FONTSET)
				printf("font is XmFONT_IS_FONTSET\n");
			if (fontType == XmFONT_IS_FONT)
				printf("font is XmFONT_IS_FONT\n");
#ifdef	USE_XFT
			if (fontType == XmFONT_IS_XFT)
				printf("font is XmFONT_IS_XFT\n");
#endif
#endif

			if (fontType != XmFONT_IS_FONTSET && fontType != XmFONT_IS_FONT)
				*xft = True;
			XmRenditionFree(rendition);
		}
		XtFree (tags[i]);
	}
	XtFree ((char *) tags);
}

/*	Function Name: Initialize
 *	Description:   Called to initialize information specific
 *                     to this widget.
 *	Arguments:     req - what was originally requested.
 *                     set - what will be created (our superclassed have
 *                           already mucked with this)
 *                     args, num_args - The arguments passed to
 *                                      the creation call.
 *	Returns:       none.
 */

/*ARGSUSED*/
static void Initialize(Widget req, Widget set,
		       ArgList args, Cardinal * num_args)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) set;
	XrmValue val;
	Boolean success;


#ifdef DEBUG
	printf("\n RescolList Initialize \n");
	fflush(stdout);
#endif

//	rcol->rescol.font = XLoadQueryFont(XtDisplay(set), "fixed");
	EventMask event_mask;
/*                           *
 * Get default Font.         *
 *                           */

//	if (rcol->rescol.font_list == NULL)
//		{
//		    XmFontList	defaultFont = NULL;
//
//		    defaultFont = XmeGetDefaultRenderTable(set, XmTEXT_FONTLIST);
//		    rcol->rescol.font_list = XmFontListCopy(defaultFont);
//		}
//	else
//		rcol->rescol.font_list = XmFontListCopy(rcol->rescol.font_list);


#ifdef DEBUG
	if (CHECK_CLIP_CORRECT)
		printf("Clipping ERROR free\n");
	else
		printf("Clipping ERROR found\n");
#endif

//#ifdef DEBUG
//	if (rcol->rescol.colDesc)
//	{
//		_XmNlColDescriptorTablePrint(rcol->rescol.colDesc->descriptors_count, rcol->rescol.colDesc);
//	}
//#endif


	if (rcol->rescol.font_list == NULL)
		rcol->rescol.font_list = XmeGetDefaultRenderTable(set, XmTEXT_FONTLIST);
	rcol->rescol.font_list = XmFontListCopy(rcol->rescol.font_list);

	success = _XmRenderTableFindFirstFont(rcol->rescol.font_list, &(rcol->rescol.idxRend),
				&(rcol->rescol.defaultFont));

	CheckRendition(rcol->rescol.font_list, &(rcol->rescol.xft));

	rcol->rescol.DestroyPhase = False;

	rcol->rescol.VisibilityState = VisibilityFullyObscured;

	rcol->rescol.CacheBufLimit = 0;
	rcol->rescol.VScrollTime = 0;
	rcol->rescol.VScrollCount = 0;

	rcol->rescol.first = NULL;
	rcol->rescol.ItemData = NULL;
	rcol->rescol.TreeRows = NULL;
	rcol->rescol.TopLine = 0;
	rcol->rescol.BotomLine = 0;
	rcol->rescol.selected_item = NULL;
	rcol->rescol.LayoutFrozen = False;
	rcol->rescol.ChangeInFrozen = False;
	rcol->rescol.num_items = 0;
	rcol->rescol.selectedPositions = NULL;
	rcol->rescol.selectedPositionsCount = 0;
	rcol->rescol.currentItem = NULL;
	rcol->rescol.currentTreeNode = NULL;
	rcol->rescol.currentVisibleParentTreeNode = NULL;

	rcol->rescol.col_sharp_width = NULL;
	rcol->rescol.col_cur_width = NULL;
	rcol->rescol.col_new_width = NULL;
	rcol->rescol.prop_data = NULL;

	rcol->rescol.num_cols = 0;


	rcol->rescol.scrollIntervalId = 0;
	rcol->rescol.scrollRefreshTimeoutFound = False;
/*
	if (rcol->rescol.num_cols > 0)
	{
		RCCreateDeafaultCols(rcol);
	}
*/
	rcol->rescol.DrawRect = NULL;

	rcol->rescol.PublicColCount = 0;
	rcol->rescol.PublicRowCount = 0;
/*	rcol->rescol.PublicSelectedCount = 0;
	rcol->rescol.PublicSelectedPositions = NULL;*/
	rcol->rescol.PublicPreciseColSize = NULL;

	rcol->rescol.selected_rows = NULL;
	rcol->rescol.current_row = -1;
	rcol->rescol.FocusFound = False;
	rcol->rescol.cell_width = 0;
	rcol->rescol.cell_height = 0;
	rcol->rescol.drawable_height_changed = True;
	rcol->rescol.drawable_width_changed = True;
	rcol->rescol.drawable_need_shift_only = False;
	rcol->rescol.drawable_height = 0;

	rcol->rescol.VisibleElement = NULL;
	rcol->rescol.VisibleCount = 0;

	rcol->rescol.IconList = NULL;

	rcol->rescol.Ipix = XmUNSPECIFIED_PIXMAP;
	rcol->rescol.Lpix = XmUNSPECIFIED_PIXMAP;
	rcol->rescol.Epix = XmUNSPECIFIED_PIXMAP;

	rcol->rescol.SelIpix = XmUNSPECIFIED_PIXMAP;
	rcol->rescol.SelLpix = XmUNSPECIFIED_PIXMAP;
	rcol->rescol.SelEpix = XmUNSPECIFIED_PIXMAP;

	rcol->rescol.pix_buf_w = 0;
	rcol->rescol.pix_buf_h = 0;
	rcol->rescol.col_num = 0;
	rcol->rescol.row_num = 0;
	rcol->rescol.separator_position = -1;
	rcol->rescol.ColumnSeparatorOn = FALSE;
	rcol->rescol.max_icon_height = 0;
	rcol->rescol.max_icon_width = 0;
	rcol->rescol.pix = XmUNSPECIFIED_PIXMAP;
	rcol->rescol.full_height = 0;
	rcol->rescol.full_width = 0;
	rcol->rescol.scroll_height = 0;
	rcol->rescol.pix_buf_row = 0;
	rcol->rescol.pix_shift = 0;
	rcol->rescol.global_v_shift = 0;
	rcol->rescol.global_h_shift = 0;
	
	
	rcol->rescol.last_scroll_value = 0;
	rcol->rescol.vs_counter = 0;
	
	
	rcol->rescol.new_global_h_shift = 0;
	rcol->rescol.v_shift_in_pix = 0;
//	rcol->rescol.multiclick = 500000;
	if (rcol->rescol.multiclick < 0)
		rcol->rescol.multiclick = XtGetMultiClickTime(XtDisplay(set));

	rcol->rescol.sm_tm = 0;
/*	rcol->rescol.auto_scroll = 0;*/

	rcol->rescol.viewX = 0;
	rcol->rescol.viewY = 0;
	rcol->rescol.viewWidth = 0;
	rcol->rescol.viewHeight = 0;
	rcol->rescol.lastViewWidth = 0;
	rcol->rescol.lastViewHeight = 0;
	rcol->rescol.NoRedisplay = False;

/*	rcol->rescol.m_select = 0;
	rcol->rescol.m_x1 = 0;
	rcol->rescol.m_x2 = 0;
	rcol->rescol.m_y1 = 0;
	rcol->rescol.m_y2 = 0;
	rcol->rescol.m_last_x1 = 0;
	rcol->rescol.m_last_x2 = 0;
	rcol->rescol.m_last_y1 = 0;
	rcol->rescol.m_last_y2 = 0;
	rcol->rescol.m_cur_x = 0;
	rcol->rescol.m_cur_y = 0;
*/

	rcol->rescol.cur_sel_count = 0;
	rcol->rescol.old_sel_count = 0;
	rcol->rescol.cur_sel_massiv = NULL;
	rcol->rescol.old_sel_massiv = NULL;
	rcol->rescol.DblClicked = False;
	rcol->rescol.clicked_item = -1;
//	rcol->rescol.HasFocus=False;

	rcol->rescol.num_items = 0;
    rcol->rescol.background_pixel = ((XmPrimitiveWidget)req)->core.background_pixel;
    rcol->rescol.foreground_pixel = ((XmPrimitiveWidget)req)->primitive.foreground;

#ifdef DEBUG
    printf("\n RescolList Initialize fg bg\n");
	fflush(stdout);
#endif


	if (rcol->rescol.select_background_pixel == XmDEFAULT_SELECT_COLOR)
	{
		_XmSelectColorDefault(set, 0, &val);
		rcol->rescol.select_background_pixel = *((Pixel*) val.addr);
	}
	else if (rcol->rescol.select_background_pixel == XmHIGHLIGHT_COLOR)
	{
		rcol->rescol.select_background_pixel = rcol->primitive.highlight_color;
	}

    rcol->rescol.ControlCollapsedBuiltin = True;
    rcol->rescol.ControlExpandedBuiltin = True;

    rcol->rescol.Closed.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.Closed.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.Open.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.Open.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.Leaf.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.Leaf.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.LeafOpen.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.LeafOpen.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.ClosedSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.ClosedSelected.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.OpenSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.OpenSelected.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.LeafSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.LeafSelected.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.LeafOpenSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.LeafOpenSelected.mask = XmUNSPECIFIED_PIXMAP;
/***************************************************************/
    rcol->rescol.ControlCollapsed.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.ControlCollapsed.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.ControlExpanded.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.ControlExpanded.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.ControlCollapsedSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.ControlCollapsedSelected.mask = XmUNSPECIFIED_PIXMAP;

    rcol->rescol.ControlExpandedSelected.pix = XmUNSPECIFIED_PIXMAP;
    rcol->rescol.ControlExpandedSelected.mask = XmUNSPECIFIED_PIXMAP;

#ifdef DEBUG
      printf("\n RescolList Initialize sfg sbg\n");
	fflush(stdout);
#endif

	InitializeGC(rcol);
	InitializePixmaps(rcol);
	rcol->rescol.ItemPix.pix = XmUNSPECIFIED_PIXMAP;

#ifdef DEBUG
      printf("\n RescolList InitializeGC OK\n");
	fflush(stdout);
#endif

	if (rcol->rescol.v_bar != NULL) {
		XtAddCallback(rcol->rescol.v_bar, XmNvalueChangedCallback,
						VScrollCallback, (XtPointer) set);
		XtAddCallback(rcol->rescol.v_bar, XmNdragCallback,
						VScrollCallback, (XtPointer) set);
	}

	if (rcol->rescol.h_bar != NULL) {
		XtAddCallback(rcol->rescol.h_bar, XmNvalueChangedCallback,
						HScrollCallback, (XtPointer) set);
		XtAddCallback(rcol->rescol.h_bar, XmNdragCallback,
						HScrollCallback, (XtPointer) set);
	}

#ifdef DEMO
    _XmInitialIzeConverters(req);
#endif


	InitializeGeometry(set);

	event_mask = VisibilityChangeMask;
	XtAddEventHandler(set, event_mask, False, VisibilityChangeProc, NULL);


    if (XtHeight(req) == 0)
    {
		XFontStruct *font;
		Boolean fontFound;
		Dimension height;
		
		fontFound = XmeRenderTableGetDefaultFont(rcol->rescol.font_list, &font);
		if (fontFound)
			height = (font->ascent + font->descent) * 10;
		else
			height = 200;
		
		rcol->core.height = height;
    }

    if (XtWidth(req) == 0)
    {
		rcol->core.width = 120;
    }
    
    {
		XtWidgetProc resize;
//	_XmProcessLock();
		resize = set->core.widget_class->core_class.resize;
//	_XmProcessUnlock();

		(* (resize)) ((Widget) set);
	}
    
#ifdef DEBUG
	printf("\n RescolList Initialize OK num cols %d %d %d\n", rcol->rescol.num_cols, rcol->core.width, rcol->core.height);
	fflush(stdout);
#endif

}

/*	Function Name: Realize
 *	Description:   Called to realize this widget.
 *	Arguments:     w - RC List Widget to realize.
 *                     valueMask, attributes - attributes to use when creating
 *                     this widget's window.
 *	Returns:       none.
 *
 *      This overrides the Manager's frobbing with various values.
 */

static void
Realize(Widget w, Mask *valueMask, XSetWindowAttributes * attributes)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget)w;

//    attributes->bit_gravity = ForgetGravity;
//		*valueMask |= CWBitGravity;

#ifdef DEBUG
	printf("\n ResCol: Realize: start w = %d h = %d\n", w->core.width, w->core.height);
#endif

	CheckRenderOrder(rcol);

    if (rcol->rescol.render_order == LtoR_render)
    {
		attributes->bit_gravity = NorthWestGravity;
		*valueMask |= CWBitGravity;
	}
	else
	{
		attributes->bit_gravity = NorthEastGravity;
		*valueMask |= CWBitGravity;
	}

#ifdef DEBUG
	printf("\n Realize: stage 1 \n");
	fflush(stdout);
#endif


    (*xmNlResColListWidgetClass->core_class.superclass->core_class.realize)
	(w, valueMask, attributes);
#ifdef DEBUG
	printf("\n Realize: stage 2 \n");
	fflush(stdout);
#endif
//#define	superclass	(&xmPrimitiveClassRec)
//  (*superclass->core_class.realize) (w, valueMask, attributes);
//#undef	superclass

	(*xmNlResColListWidgetClass->core_class.resize)(w);
#ifdef DEBUG
	printf("\n ResCol: Realize: complte \n");
	fflush(stdout);
#endif
}


static void ResizeDoCallback(Widget, char mode, int source);

/*	Function Name: SetValues
 *	Description:   Called when some widget data needs to be modified on-
 *                     the-fly.
 *	Arguments:     current - the current (old) widget values.
 *                     request - before superclassed have changed things.
 *                     set - what will acutally be the new values.
 *                     args, num_args - the arguments in the list.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static Boolean SetValues(Widget current, Widget request, Widget set,
			 ArgList args, Cardinal * num_args)
{
    XmNlResColListWidget 	l_old = (XmNlResColListWidget)current;
    XmNlResColListWidget	l_set = (XmNlResColListWidget)set;
	XmNlRCL_Property_Row * prop;
    register int i;
    Boolean 	redisplay = False;
    Boolean		recalculateFull = False;
    Boolean		recalculateGeom = False;
    Boolean		resort = False;
    Boolean		refreshGC = False;
    Boolean		readjust = False;
    Boolean		check_pos = False;
    Boolean		copyTitles = False;
    Boolean 	resizeDo = False;
    Boolean		fontChange = False;
    Boolean		h_change = False;
    Boolean		calcColParam = False;
    Boolean		recalcParam = False;
    Boolean		refreshColor = False;
    Boolean		resetSelectedList = False;
    Boolean 	rebuildSelectedList = False;
    Boolean		success;
	XrmValue val;
	String name;
	XGCValues gcv;

#ifdef DEBUG
	printf("\n XmNlResColList SetValues: stage 1 \n");
	fflush(stdout);
#endif


    for (i = 0; i < *num_args; i++)
    {
		name = args[i].name;

		if (streq(XmNhorizontalScrollBar, name))
		{
			XtAddCallback(l_set->rescol.h_bar, XmNvalueChangedCallback,
					  HScrollCallback, (XtPointer) set);
			XtAddCallback(l_set->rescol.h_bar, XmNdragCallback,
					  HScrollCallback, (XtPointer) set);
			continue ;
		}

		if (streq(XmNverticalScrollBar, name))
		{
			XtAddCallback(l_set->rescol.v_bar, XmNvalueChangedCallback,
					  VScrollCallback, (XtPointer) set);
			XtAddCallback(l_set->rescol.v_bar, XmNdragCallback,
					  VScrollCallback, (XtPointer) set);
		}
	}

/*	if ((l_set->rescol.v_bar != l_old->rescol.v_bar) ||
		(l_set->rescol.h_bar != l_old->rescol.h_bar))
    {
		XtAddCallback(l_set->rescol.v_bar, XmNvalueChangedCallback,
				  VScrollCallback, (XtPointer) set);
		XtAddCallback(l_set->rescol.v_bar, XmNdragCallback,
				  VScrollCallback, (XtPointer) set);

		XtAddCallback(l_set->rescol.h_bar, XmNvalueChangedCallback,
				  HScrollCallback, (XtPointer) set);
		XtAddCallback(l_set->rescol.h_bar, XmNdragCallback,
				  HScrollCallback, (XtPointer) set);
    }*/


/* Color section */

	if (l_set->rescol.select_background_pixel != l_old->rescol.select_background_pixel)
	{
		if (l_set->rescol.select_background_pixel == XmDEFAULT_SELECT_COLOR)
		{
			_XmSelectColorDefault((Widget)l_set,
							XtOffsetOf(XmNlResColListRec, rescol.select_background_pixel),
							&val);
			l_set->rescol.select_background_pixel = *((Pixel*) val.addr);
		}
		else if (l_set->rescol.select_background_pixel == XmHIGHLIGHT_COLOR)
		{
			l_set->rescol.select_background_pixel = l_set->primitive.highlight_color;
		}

		if (l_set->rescol.select_background_pixel != l_old->rescol.select_background_pixel)
		{
			redisplay = TRUE;
			refreshColor = True;
//			refreshBuf = TRUE;
		}
    }


	if (((XmPrimitiveWidget)set)->core.background_pixel != ((XmPrimitiveWidget)current)->core.background_pixel)
	{
		l_set->rescol.background_pixel = ((XmPrimitiveWidget)set)->core.background_pixel;
//	    refreshBuf = True;
		refreshColor = True;
	    redisplay = True;
	}

	if (((XmPrimitiveWidget)set)->primitive.foreground != ((XmPrimitiveWidget)current)->primitive.foreground)
	{
		l_set->rescol.foreground_pixel = ((XmPrimitiveWidget)set)->primitive.foreground;
//	    refreshBuf = True;
		refreshColor = True;
	    redisplay = True;
	}

	if (l_set->rescol.select_foreground_pixel != l_old->rescol.select_foreground_pixel)
	{
	    redisplay = True;
	}


/*	if ((((XmPrimitiveWidget)set)->primitive.shadow_thickness != ((XmPrimitiveWidget)current)->primitive.shadow_thickness) ||
			(((XmPrimitiveWidget)set)->primitive.highlight_thickness != ((XmPrimitiveWidget)current)->primitive.highlight_thickness))
	{
	    recalculateGeom = True;
	    redisplay = True;
	}*/


/*
	if (l_old->rescol.num_cols != l_set->rescol.num_cols)
	{
		Widget parent;
		Boolean consistency = l_set->rescol.PropConsistency;
//			recalculateFull = True;
		redisplay = True;
		resizeDo = True;
//#ifdef DEBUG
		printf("\n [[[[[[[[[[[[[[[[[[[[[[[[[[       ResCol SetValues: number of old cols=%d new cols=%d\n", l_old->rescol.num_cols, l_set->rescol.num_cols );
		fflush(stdout);
//#endif



		if (l_old->rescol.num_cols != 0 && l_old->rescol.ItemData)
		{
			if (l_old->rescol.TreeMode)
			{
				XmNlRCTreeDeleteAllItems(current);
				l_set->rescol.first = NULL;
			}
			else
			{
//				printf("++++++++BEFORE ALL ROWS DELETE IconList %p+++++++++\n", l_set->rescol.IconList);
//				printf("++++++++BEFORE ALL ROWS DELETE IconList %p+++++++++\n", l_old->rescol.IconList);
				XmNlResColDeleteAllRows(current);
				l_set->rescol.IconList = l_old->rescol.IconList;
//				printf("++++++++AFTER ALL ROWS DELETE IconList %p+++++++++\n", l_set->rescol.IconList);
			}
		}
//		RCFreePixBuf(current);
		RCFreePixBufNew(current);

		l_set->rescol.ItemData = NULL;
		l_set->rescol.selected_rows = NULL;
		l_set->rescol.cur_sel_massiv = NULL;

		l_set->rescol.num_rows = 0;
		l_set->rescol.num_items = 0;
		l_set->rescol.PublicRowCount = 0;
		l_set->rescol.PublicSelectedCount = 0;
		l_set->rescol.global_v_shift = 0;
		l_set->rescol.v_shift_in_pix = 0;
		l_set->rescol.pix_shift = 0;
		l_set->rescol.cell_height = 0;
		l_set->rescol.full_height = 0;



		if (l_old->rescol.prop_data != NULL)
		{
			XmNlRCL_Property_Row * prop;
			prop = l_old->rescol.prop_data;
			for (i = 0; i < l_old->rescol.num_cols; i++)
			{
				if (prop[i].gc)
					XFreeGC(XtDisplay((Widget) l_old), prop[i].gc);
				prop[i].gc = NULL;
			}
			XtFree((char*) l_old->rescol.prop_data);
			l_old->rescol.prop_data = NULL;
		}

		l_set->rescol.prop_data = NULL;
		l_set->rescol.num_rows = 0;
		
		l_set->rescol.PublicColCount = l_set->rescol.num_cols;
		l_set->rescol.PublicRowCount = 0;
		l_set->rescol.num_items = 0;
		l_set->rescol.cell_height = 0;

		if (l_old->rescol.col_sharp_width) 
			XtFree((char*) l_old->rescol.col_sharp_width);
		if (l_old->rescol.col_cur_width) 
			XtFree((char*) l_old->rescol.col_cur_width);
		if (l_old->rescol.col_new_width) 
			XtFree((char*) l_old->rescol.col_new_width);

		if (l_old->rescol.PublicPreciseColSize)
			free(l_old->rescol.PublicPreciseColSize);


		l_set->rescol.col_sharp_width = NULL; 
		l_set->rescol.col_cur_width = NULL;
		l_set->rescol.col_new_width = NULL;
		l_set->rescol.PublicPreciseColSize = NULL;

		RCCreateDeafaultCols(l_set);

		parent = XtParent(set);
		if (ChekParentIsList(parent))
		{
			int col_num;
			
			XtVaGetValues(parent, XmNnumCols, &col_num, NULL);
			
			if (col_num == l_set->rescol.num_cols)
			{
				l_set->rescol.PropConsistency = True;
				
				printf("ResColListWidget consistency changed to True\n");
			}
		}

		if ((consistency != l_set->rescol.PropConsistency) && (l_set->rescol.PropConsistency == True))
		{
			if (l_set->rescol.resizeCallback)
				ResizeDoCallback(set, XmNlPropertyConsistency, XmNlConsistencyChange);
		}
	}
*/


	if (l_old->rescol.font_list != l_set->rescol.font_list)
	{
			recalcParam = True;
			fontChange = True;
			calcColParam = True;
			redisplay = True;

			success = _XmRenderTableFindFirstFont(l_set->rescol.font_list, &(l_set->rescol.idxRend),
				&(l_set->rescol.defaultFont));
	}

	if ((l_old->rescol.margin_h != l_set->rescol.margin_h) ||
		(l_old->rescol.margin_w != l_set->rescol.margin_w))
	{
			recalcParam = True;
			calcColParam = True;
			redisplay = True;
	}


	if ((l_old->rescol.select_line_w != l_set->rescol.select_line_w) ||
		(l_old->rescol.select_line_margin != l_set->rescol.select_line_margin) ||
		(l_old->rescol.select_line_style != l_set->rescol.select_line_style))
	{
			redisplay = True;
	}


/**********************************************************************/

	if ((l_set->rescol.selectedPositions != l_old->rescol.selectedPositions) ||
		(l_set->rescol.selectedPositionsCount != l_old->rescol.selectedPositionsCount))
	{
		if (l_set->rescol.selectedPositions && (l_set->rescol.selectedPositionsCount > 0))
        {
			ClearSelectedPositions(l_old);
			CopySelectedPositions(l_set);
			redisplay = True;
			resetSelectedList = True;
			rebuildSelectedList = True;
		}
		else if (l_set->rescol.selectedPositionsCount == 0)
		{
			ClearSelectedPositions(l_old);
			l_set->rescol.selectedPositions = NULL;
			redisplay = True;
			resetSelectedList = True;
		}
		else if ((l_set->rescol.selectedPositionsCount > 0) && (l_set->rescol.selectedPositions == NULL))
			{
				XmeWarning((Widget) l_set, "SetValues: selectedPositions not found\n");
				l_set->rescol.selectedPositions = l_old->rescol.selectedPositions;
				l_set->rescol.selectedPositionsCount = l_old->rescol.selectedPositionsCount;
			}
			else
			{
				XmeWarning((Widget) l_set, "SetValues: selectedPositions not found\n");
				l_set->rescol.selectedPositions = l_old->rescol.selectedPositions;
				l_set->rescol.selectedPositionsCount = l_old->rescol.selectedPositionsCount;
			}
	}

/**********************************************************************/

	if (l_old->rescol.TreeMode != l_set->rescol.TreeMode)
	{
		if (l_old->rescol.TreeMode && l_set->rescol.first)
		{
			XmNlRCTreeDeleteAllItems(set);
		}
		
		if (!l_old->rescol.TreeMode && l_set->rescol.ItemData)
		{
			XmNlResColDeleteAllRows(set);
		}

		RCFreePixBufNew(set);

		if (l_old->rescol.prop_data != NULL)
		{
			CleanPropertyRow(set);
			l_set->rescol.prop_data = NULL;
		}

		if (l_old->rescol.col_sharp_width) 
		{
			XtFree((char*)l_old->rescol.col_sharp_width);
			l_set->rescol.col_sharp_width = NULL;
		}
		if (l_old->rescol.col_cur_width) 
		{
			XtFree((char*)l_old->rescol.col_cur_width);
			l_set->rescol.col_cur_width = NULL;
		}
		if (l_old->rescol.col_new_width) 
		{
			XtFree((char*)l_old->rescol.col_new_width);
			l_set->rescol.col_new_width = NULL;
		}
		if (l_old->rescol.selectedPositions) 
		{
			XtFree((char*)l_old->rescol.selectedPositions);
			l_set->rescol.selectedPositions = NULL;
		}

		l_set->rescol.selectedPositionsCount = 0;
		
		l_set->rescol.num_cols = 0;

/*		if (l_set->rescol.TreeMode)
		{
			l_set->rescol.num_cols = 1;
			l_set->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(l_set->rescol.num_cols, sizeof (XmNlRCL_Property_Row));
			prop = l_set->rescol.prop_data;

			l_set->rescol.col_sharp_width=(int *) XtCalloc(l_set->rescol.num_cols, sizeof (int));
			l_set->rescol.col_cur_width=(int *) XtCalloc(l_set->rescol.num_cols, sizeof (int));
			l_set->rescol.col_new_width=(int *) XtCalloc(l_set->rescol.num_cols, sizeof (int));

			gcv.background = l_set->core.background_pixel;
			gcv.foreground = l_set->rescol.foreground_pixel;
			gcv.function = GXcopy;

			prop->info_type = XmSTRING;
			prop->align_type = XmALIGNMENT_BEGINNING;
			prop->pix_buf = XmUNSPECIFIED_PIXMAP;
			prop->current_width = 0;
			prop->drawable_width = 0;
			prop->real_width = 0;
			prop->drawable_width_changed = True;
			prop->redraw_need = False;
			prop->gc = XCreateGC(XtDisplay(set), RootWindowOfScreen(XtScreen(set)),
									GCForeground | GCBackground | GCFunction, &gcv);

			prop->CacheBufIndex = NULL;
			prop->CacheBufNum = 0;
			prop->CacheBufPosition = -1;
		}

*/
		l_set->rescol.num_rows = 0;

		l_set->rescol.PublicRowCount = 0;


		l_set->rescol.num_items = 0;
		l_set->rescol.cell_height = 0;
		redisplay = True;
	}
/*    if ((l_set->rescol.LayoutFrozen != l_old->rescol.LayoutFrozen) &&
	(l_set->rescol.LayoutFrozen == False))
    {
		if (l_old->rescol.ChangeInFrozen == True || l_set->rescol.ChangeInFrozen == True)
		{
			l_old->rescol.ChangeInFrozen = False;
			l_set->rescol.ChangeInFrozen = False;
			recalculateFull = True;
			recalculateGeom = True;
			refreshBuf = True;
			redisplay = True;
		}
	}*/


/*	if (refreshGC)
    {
		DestroyGC(l_set);
		InitializeGC(l_set);
    }
*/
#ifdef DEBUG
		printf("\n SetValue: stage 2 \n");
		fflush(stdout);

    if (resizeDo) printf(">>>>>>>>>>> SetValues resizeDo\n");
    if (fontChange) printf(">>>>>>>>>>> SetValues fontChange\n");
    if (h_change) printf(">>>>>>>>>>> SetValues h_change\n");
    if (calcColParam) printf(">>>>>>>>>>> SetValues calcColParam\n");
    if (recalcParam) printf(">>>>>>>>>>> SetValues recalcParam\n");
#endif



	if (refreshColor)
	{
		RefreshAllPixmaps(l_set);
		CreateLinePix(l_set);
		RefreshIconsColor(set);
	}

	if (resizeDo && l_set->rescol.resizeCallback)
	{
		int delta = 0;
		int old_full_width = l_set->rescol.full_width;
		XmNlRCL_Property_Row * prow = l_set->rescol.prop_data;
		
		ResizeDoCallback(set, XmNlEmpty, XmNlContentChange);
		for (i = 0; i < l_set->rescol.num_cols; i++)
		{
			prow[i].current_width = l_set->rescol.col_new_width[i];
			prow[i].x = delta;
			delta = delta + prow[i].current_width;
		}
		if (l_set->rescol.new_global_h_shift != l_set->rescol.global_h_shift ||
			old_full_width != l_set->rescol.full_width)
		{
			l_set->rescol.global_h_shift = l_set->rescol.new_global_h_shift;
			ResizeSliders(set, HorizontalScroll);
		}
	}


	if (recalcParam)
    	RecalcParam(set, 0, l_set->rescol.num_rows, fontChange, &h_change, NULL);
		

/*    if (recalculateFull)
    {
    	RecalcParam( set, 0, l_set->rescol.num_rows, False, NULL, NULL);
	l_set->rescol.global_v_shift=0;
	l_set->rescol.global_h_shift=0;
	l_set->rescol.v_shift_in_pix=0;
	l_set->rescol.pix_shift=0;
    }
*/
#ifdef DEBUG
		printf("\n SetValue: stage 3 cell height %d\n", l_set->rescol.cell_height);
		fflush(stdout);
#endif

	if (calcColParam || resizeDo)
		CalcColParam(set);

/*    if (recalculateFull || recalculateGeom)
    {
		ResizeStuff(l_set);
#ifdef DEBUG
		printf("\n SetValue: stage 4 \n");
		fflush(stdout);
#endif
    	refreshBuf = CalcGeomAfterChangeCells(set);
    }*/
//    if (recalculateFull || recalculateGeom || refreshBuf) PutToOffScreenPix( set );

#ifdef DEBUG
	printf("\n SetValue: stage 5 \n");
		fflush(stdout);
#endif

	if (h_change && l_set->rescol.TreeMode) 
		CreateLinePix(l_set);

	if (resetSelectedList)
	{
		for (i = 0; i < l_set->rescol.num_rows; i++)
		{
			if (l_set->rescol.buffering && l_set->rescol.ItemData[i]->selected == True) 
				RefreshCachePix(set, i, False);
			l_set->rescol.ItemData[i]->selected = False;
			if (l_set->rescol.selected_rows)
				l_set->rescol.selected_rows[i] = False;
		}
	}
	if (rebuildSelectedList)
	{
		for (i = 0; i < l_set->rescol.selectedPositionsCount; i++)
		{
			if ((l_set->rescol.selectedPositions[i] >= 0) && (l_set->rescol.selectedPositions[i] < l_set->rescol.num_rows))
			{
				if (l_set->rescol.buffering && l_set->rescol.ItemData[l_set->rescol.selectedPositions[i]]->selected == False) 
					RefreshCachePix(set, l_set->rescol.selectedPositions[i], True);
				l_set->rescol.ItemData[l_set->rescol.selectedPositions[i]]->selected = True;
				if (l_set->rescol.selected_rows)
					l_set->rescol.selected_rows[l_set->rescol.selectedPositions[i]] = True;
			}
		}
	}
	
	if (resetSelectedList || rebuildSelectedList)
		HighlightDoCallback(set);

//	if (redisplay) CreateLinePix(l_set);
	if (!XtIsRealized(current))
		return False;

#ifdef DEBUG
	printf("\n SetValue: stage 6 \n");
		fflush(stdout);
#endif
	return redisplay;
}


static void
GetValues_XmNpreciseColSize(Widget w, int n, XtArgVal *value)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Property_Row * prow;
    int i;

    prow = rcol->rescol.prop_data;
    
    if (!rcol->rescol.PublicPreciseColSize)
		rcol->rescol.PublicPreciseColSize = calloc(rcol->rescol.num_cols, sizeof(int));
    
    if (rcol->rescol.PublicPreciseColSize)
    {
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			*(rcol->rescol.PublicPreciseColSize + i) = (prow + i)->real_width;
		}
	}

	(*value) = (XtArgVal) rcol->rescol.PublicPreciseColSize;
}

static void 
GetValues_XmNitemCount(Widget w, int n, XtArgVal *value)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	(*value)= (XtArgVal) rcol->rescol.num_rows;
}

static void 
GetValues_XmNnumCols(Widget w, int n, XtArgVal *value)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	(*value)= (XtArgVal) rcol->rescol.num_cols;
}


static void ResizeStuff(XmNlResColListWidget w)
{
	XRectangle clip;
/*
  w->rescol.lastViewWidth = w->rescol.viewWidth;
  w->rescol.lastViewHeight = w->rescol.viewHeight;

  w->rescol.viewWidth = w->core.width - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->rescol.viewHeight = w->core.height - 2*((XmPrimitiveWidget)(w))->primitive.shadow_thickness
    - 2*((XmPrimitiveWidget)(w))->primitive.highlight_thickness;

  w->rescol.viewX=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
  w->rescol.viewY=((XmPrimitiveWidget)(w))->primitive.shadow_thickness+((XmPrimitiveWidget)(w))->primitive.highlight_thickness;
*/


//  w->rescol.lastViewWidth = w->rescol.viewWidth;
//  w->rescol.lastViewHeight = w->rescol.viewHeight;


	w->rescol.viewWidth = w->core.width;
	w->rescol.viewHeight = w->core.height;

	w->rescol.viewX = 0;
	w->rescol.viewY = 0;

  /*******   Temp hack**********/

	if (w->rescol.viewWidth > 65000) 
		w->rescol.viewWidth = 0;

	return ;

	clip.x = w->rescol.viewX;
	clip.y = w->rescol.viewY;
	clip.width = w->rescol.viewWidth;
	clip.height = w->rescol.viewHeight;
#ifdef DEBUG
	printf("\nResizeStuff: Stage 1\n");
	fflush(stdout);
#endif
	XSetClipRectangles(XtDisplay((Widget) w), w->rescol.drawGC,
							0, 0, &clip, 1, Unsorted);
	XSetClipRectangles(XtDisplay((Widget) w), w->rescol.eorGC,
							0, 0, &clip, 1, Unsorted);
	XSetClipRectangles(XtDisplay((Widget) w), w->rescol.highlightGC,
							0, 0, &clip, 1, Unsorted);
//    ResizeSliders((Widget) w);
#ifdef DEBUG
	printf("\nResizeStuff: v_h=%d v_w=%d\n", w->rescol.viewHeight, w->rescol.viewWidth);
	fflush(stdout);
#endif
	return ;

}

void RCRedrawWindow( Widget w, XEvent * event, Region region );


/*	Function Name: Redisplay
 *	Description:   This function redraws the list contents.
 *	Arguments:     w - RC List widget.
 *                     event - event that caused the exposure.
 *                     region - the region containing all the exposures.
 *	Returns:       none
 *
 */

/*ARGSUSED*/
static void
Redisplay(Widget w, XEvent * event, Region region)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Property_Row * rw;
#ifdef notdef
    XExposeEvent * exp_event = (XExposeEvent *) &(event->xexpose);
#endif

#ifdef DEBUG
	printf("\n ResCol Redisplay: stage 1 \n");
	fflush(stdout);
#endif

	if (rcol->rescol.num_cols==0 || rcol->rescol.num_rows==0) return;

#ifdef DEBUG
	printf("\n Redisplay: stage 2 \n");
	fflush(stdout);
#endif

#ifdef DEBUG
	if (region)
	{
		REGION DReg = *region;
		BOX *bx;
		int i;
		for(i=0; i < DReg.numRects; i++)
		{
			bx=DReg.rects;
			bx=bx+i;
			printf("-----Redisplay: region x1= %d y1= %d x2= %d y2= %d\n", bx->x1, bx->y1, bx->x2, bx->y2 );
		}
		if (event) printf("-----Redisplay: expose x= %d w= %d y= %d h= %d\n", event->xexpose.x, event->xexpose.width,
					event->xexpose.y, event->xexpose.height);
		printf("End\n");
	}
#endif

	if (rcol->rescol.drawGC && XtWindow(w))
	{
		if (rcol->rescol.AllRedraw == True)
		{
//			rcol->rescol.AllRedraw == False;
#ifdef DEBUG
			printf("\n Redisplay: in all redraw branch \n");
			fflush(stdout);
#endif
			RCRedrawAllWindow(w);
			rcol->rescol.AllRedraw == False;
			CurrentFrameDraw(w);
			return ;
		}
		else
		{
		if (rcol->rescol.render_order == LtoR_render)
			RCRedrawWindow(w, event, region);
		else
			RCRedrawWindowRtoL(w, event, region);
		}
	}
#ifdef DEBUG
	printf("\n Redisplay: stage 3 \n");
	fflush(stdout);
#endif

	CurrentFrameDraw(w);
#ifdef DEBUG
	printf("\n Redisplay: stage 4, all ok \n");
	fflush(stdout);
#endif

}

void CreateLinePix(XmNlResColListWidget rcol)
{
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	int height;
	Widget w = (Widget) rcol;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;

	height = rcol->rescol.cell_height;

	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color=rcol->primitive.foreground;
	else
		sel_bg_color=rcol->rescol.select_background_pixel;


	CheckRenderOrder(rcol);


	if (PIX_FOUND(rcol->rescol.Ipix))
		XFreePixmap(XtDisplay(w), rcol->rescol.Ipix);

	rcol->rescol.Ipix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));

	if (PIX_FOUND(rcol->rescol.Lpix))
		XFreePixmap(XtDisplay(w), rcol->rescol.Lpix);

	rcol->rescol.Lpix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));
	if (PIX_FOUND(rcol->rescol.Epix))
		XFreePixmap(XtDisplay(w), rcol->rescol.Epix);

	rcol->rescol.Epix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));




	if (PIX_FOUND(rcol->rescol.SelIpix))
		XFreePixmap(XtDisplay(w), rcol->rescol.SelIpix);

	rcol->rescol.SelIpix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));

	if (PIX_FOUND(rcol->rescol.SelLpix))
		XFreePixmap(XtDisplay(w), rcol->rescol.SelLpix);

	rcol->rescol.SelLpix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));
	if (PIX_FOUND(rcol->rescol.SelEpix))
		XFreePixmap(XtDisplay(w), rcol->rescol.SelEpix);

	rcol->rescol.SelEpix = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
											rcol->rescol.ControlExpanded.width + 1,
											height + 1, DefaultDepthOfScreen(XtScreen(w)));


	XSetForeground(XtDisplay(w), rcol->rescol.pixGC, background_color);
//	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);

	XFillRectangle(XtDisplay(w), rcol->rescol.Ipix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);
	XFillRectangle(XtDisplay(w), rcol->rescol.Lpix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);
	XFillRectangle(XtDisplay(w), rcol->rescol.Epix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);


	XFillRectangle(XtDisplay(w), rcol->rescol.SelIpix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);
	XFillRectangle(XtDisplay(w), rcol->rescol.SelLpix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);
	XFillRectangle(XtDisplay(w), rcol->rescol.SelEpix, rcol->rescol.pixGC, 0, 0,
					rcol->rescol.ControlExpanded.width + 1, height + 1);


	XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);


	XFillRectangle(XtDisplay(w), rcol->rescol.SelIpix, rcol->rescol.pixGC, 0, rcol->rescol.margin_h,
					rcol->rescol.ControlExpanded.width + 1, height - 2*rcol->rescol.margin_h);
	XFillRectangle(XtDisplay(w), rcol->rescol.SelLpix, rcol->rescol.pixGC, 0, rcol->rescol.margin_h,
					rcol->rescol.ControlExpanded.width + 1, height - 2*rcol->rescol.margin_h);
	XFillRectangle(XtDisplay(w), rcol->rescol.SelEpix, rcol->rescol.pixGC, 0, rcol->rescol.margin_h,
					rcol->rescol.ControlExpanded.width + 1, height - 2*rcol->rescol.margin_h);


	XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
	XSetBackground(XtDisplay(w), rcol->rescol.pixGC, background_color);

	XDrawLine(XtDisplay(w), rcol->rescol.Ipix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height);

	XDrawLine(XtDisplay(w), rcol->rescol.Lpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height/2);

	if (rcol->rescol.render_order == LtoR_render)
		XDrawLine(XtDisplay(w), rcol->rescol.Lpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, rcol->rescol.ControlExpanded.width, height/2);
	else
		XDrawLine(XtDisplay(w), rcol->rescol.Lpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, 0, height/2);


	XDrawLine(XtDisplay(w), rcol->rescol.Epix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height);
	if (rcol->rescol.render_order == LtoR_render)
		XDrawLine(XtDisplay(w), rcol->rescol.Epix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, rcol->rescol.ControlExpanded.width, height/2);
	else
		XDrawLine(XtDisplay(w), rcol->rescol.Epix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, 0, height/2);




/*	XSetForeground(XtDisplay(w), rcol->rescol.eorGC, foreground_color);
	XSetBackground(XtDisplay(w), rcol->rescol.eorGC, background_color);


	XDrawLine(XtDisplay(w), rcol->rescol.SelIpix,
					rcol->rescol.eorGC,
					rcol->rescol.ControlOpen.width/2, 0, rcol->rescol.ControlOpen.width/2, height);

	XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.eorGC,
					rcol->rescol.ControlOpen.width/2, 0, rcol->rescol.ControlOpen.width/2, height/2);
	XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.eorGC,
					rcol->rescol.ControlOpen.width/2, height/2, rcol->rescol.ControlOpen.width, height/2);

	XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.eorGC,
					rcol->rescol.ControlOpen.width/2, 0, rcol->rescol.ControlOpen.width/2, height);
	XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.eorGC,
					rcol->rescol.ControlOpen.width/2, height/2, rcol->rescol.ControlOpen.width, height/2);

*/

	XDrawLine(XtDisplay(w), rcol->rescol.SelIpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height);

	XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height/2);

	XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, 0, rcol->rescol.ControlExpanded.width/2, height);

	XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_fg_color);
	XSetBackground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);

	XDrawLine(XtDisplay(w), rcol->rescol.SelIpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, rcol->rescol.margin_h, rcol->rescol.ControlExpanded.width/2, height - rcol->rescol.margin_h - 1);

	XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, rcol->rescol.margin_h, rcol->rescol.ControlExpanded.width/2, height/2);

	if (rcol->rescol.render_order == LtoR_render)
		XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, rcol->rescol.ControlExpanded.width, height/2);
	else
		XDrawLine(XtDisplay(w), rcol->rescol.SelLpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, 0, height/2);

	XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, rcol->rescol.margin_h, rcol->rescol.ControlExpanded.width/2, height - rcol->rescol.margin_h - 1);

	if (rcol->rescol.render_order == LtoR_render)
		XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, rcol->rescol.ControlExpanded.width, height/2);
	else
		XDrawLine(XtDisplay(w), rcol->rescol.SelEpix,
					rcol->rescol.pixGC,
					rcol->rescol.ControlExpanded.width/2, height/2, 0, height/2);


	XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
	XSetBackground(XtDisplay(w), rcol->rescol.pixGC, background_color);

}

void _XmNlResColAddScrolls(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	
	if (rcol->rescol.v_bar)
	{
		XtAddCallback(rcol->rescol.v_bar, XmNvalueChangedCallback,
				  VScrollCallback, (XtPointer) w);
		XtAddCallback(rcol->rescol.v_bar, XmNdragCallback,
				  VScrollCallback, (XtPointer) w);
	}
	
	if (rcol->rescol.h_bar)
	{
		XtAddCallback(rcol->rescol.h_bar, XmNvalueChangedCallback,
				  HScrollCallback, (XtPointer) w);
		XtAddCallback(rcol->rescol.h_bar, XmNdragCallback,
				  HScrollCallback, (XtPointer) w);
	}
}


void RCDrawItemTreeSelected(Widget w, VisibleItem * Element, Boolean filling)
{
	int height, width, xpix, ypix, xtext, ytext, yline;
	Pixinfo *pix;
	XmNlListTreeItem * item;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Cell * cell = Element->element;
    XmNlRCL_Property_Row * prow;
	XRectangle * clip;
	int yc1, yc2, xc1, xc2, ys, xs;
	int y, x, row;
	int sel_delta, sel_delta2, sel_wd, col;
	GC gc;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	CacheBufElement *CachePtr;
	Pixmap pbuf;
	Dimension string_w, string_h;

#ifdef DEBUG
	printf("Enter to RCDrawItemTreeSelected\n");
#endif

	if (cell == NULL) 
		return;

	string_w = XmStringWidth(rcol->rescol.font_list, cell->xmlabel);

	string_h = XmStringHeight(rcol->rescol.font_list, cell->xmlabel);

#ifdef FAST_XMSTRING_RENDERING
/*	SegmentedXmStringExtent2(XtDisplay(w), rcol->rescol.font_list, 
										cell->complabel, 
										&(string_w), &(string_h));*/
	SegmentedXmStringExtent3(XtDisplay(w), rcol->rescol.font_list, 
										cell->complabel, 
										&(string_w), &(string_h), rcol->rescol.idxRend);
#endif

    row = Element->num/rcol->rescol.num_cols;

    col = Element->num - row * rcol->rescol.num_cols;

	item = cell->node;

	prow = rcol->rescol.prop_data + col;
	clip = &(prow->clip);

 	pix = RCGetItemPix(rcol, item, True);

/* Calc position and width of selection rectagle */

/*	if (rcol->rescol.num_cols == 1)
	{
		sel_delta = rcol->rescol.margin_w - rcol->rescol.global_h_shift;
		sel_wd = prow->current_width - 2 * rcol->rescol.margin_w;
	}
	else
		if (col == 0)
		{
			if (rcol->rescol.render_order == LtoR_render)
				sel_delta = rcol->rescol.margin_w;
			else
				sel_delta = 0;
			sel_wd = -rcol->rescol.margin_w;
		}
		else
			if (col == rcol->rescol.num_cols -1)
			{
				if (rcol->rescol.render_order == LtoR_render)
					sel_delta = 0;
				else
					sel_delta = rcol->rescol.margin_w;
				sel_wd = -rcol->rescol.margin_w;
			}
			else
			{
				sel_delta = 0;
				sel_wd = 0;
			}*/

	if (rcol->rescol.num_cols == 1)
	{
		if (rcol->rescol.render_order == LtoR_render)
		{
			sel_delta = rcol->rescol.margin_w - rcol->rescol.global_h_shift;
			sel_delta2 = prow->current_width - rcol->rescol.global_h_shift - rcol->rescol.margin_w;
		}
		else
		{
			sel_delta2 = rcol->rescol.viewWidth - rcol->rescol.margin_w + rcol->rescol.global_h_shift;
			sel_delta = rcol->rescol.viewWidth - prow->current_width + rcol->rescol.global_h_shift + rcol->rescol.margin_w;
		}
	}
	else
	{
		if (rcol->rescol.render_order == LtoR_render)
		{
			sel_delta = rcol->rescol.margin_w - rcol->rescol.global_h_shift;
			sel_delta2 = prow->current_width - rcol->rescol.global_h_shift;
		}
		else
		{
			sel_delta2 = rcol->rescol.viewWidth - rcol->rescol.margin_w + rcol->rescol.global_h_shift;
			sel_delta = rcol->rescol.viewWidth - prow->current_width + rcol->rescol.global_h_shift;
		}
	}


	if (sel_delta < 0)
		sel_delta = 0;
	if (sel_delta2 > rcol->rescol.viewWidth)
		sel_delta2 = rcol->rescol.viewWidth;
	sel_wd = sel_delta2 - sel_delta;


	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;
	highlight_color = ((XmPrimitiveWidget)rcol)->primitive.highlight_color;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;



	y = Element->y;

	if (rcol->rescol.render_order == LtoR_render)
		x = item->x - rcol->rescol.global_h_shift;
	else
		x = rcol->rescol.viewWidth - (item->x - rcol->rescol.global_h_shift);

	width = Element->width;

	height = rcol->rescol.cell_height;


	if (item->firstchild)
	{
		if (rcol->rescol.render_order == LtoR_render)
			xtext = x + rcol->rescol.ctrlWidth + 2 * ((int) rcol->rescol.margin_w) +
			pix->width;
		else
			xtext = x - rcol->rescol.ctrlWidth - 2 * ((int) rcol->rescol.margin_w) -
			pix->width - cell->label_w;
	}
	else
	{
		if (rcol->rescol.render_order == LtoR_render)
			xtext = x + (int) rcol->rescol.margin_w + rcol->rescol.pixWidth;
		else
			xtext = x - (int) rcol->rescol.margin_w - rcol->rescol.pixWidth - cell->label_w;
	}



	if (rcol->rescol.render_order == LtoR_render)
		xpix = xtext - (int) rcol->rescol.margin_w - pix->width;
	else
		xpix = xtext + (int) rcol->rescol.margin_w + cell->label_w;

	ytext = y + ((rcol->rescol.cell_height - string_h) / 2);
#ifdef DEBUG
	printf("RCDrawItemTree: xtext =%d xpix =%d ytext = %d\n", xtext, xpix, ytext);
#endif


	gc = prow->gc;

	if (filling)
	{
		XSetForeground(XtDisplay(w), rcol->rescol.drawGC, sel_bg_color);
		XFillRectangle(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC, sel_delta, y + rcol->rescol.margin_h,
						sel_wd, height - 2 * rcol->rescol.margin_h);

		XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
	}

	XSetForeground(XtDisplay(w), gc, sel_fg_color);
	XSetBackground(XtDisplay(w), gc, sel_bg_color);


	if (xtext <= (rcol->rescol.viewX + rcol->rescol.viewWidth))
	{
		if (rcol->rescol.buffering)
		{
			if (cell->buf)
			{
				pbuf = (((CacheBufElement*) (cell->buf))->id);
			}
			else
			{
				if (rcol->rescol.AllRedraw) 
					CachePtr = RCGetPixBufNew((Widget) w, cell, prow, row, col, -1);
				else
					CachePtr = RCGetPixBufNew((Widget) w, cell, prow, row, col, 0);

//				CachePtr = RCGetPixBuf((Widget) w, cell, prow, row, col);
				if (!CachePtr)
				{
					return ;
				}
				pbuf = CachePtr->id;
				cell->buf = CachePtr;
			}
			XCopyArea(XtDisplay(w), pbuf, XtWindow(w), gc,
						0, 0, string_w, string_h, xtext, ytext);
		}
		else
		{

//			XSetForeground(XtDisplay(w), rcol->rescol.drawGC, sel_fg_color);
//			XSetBackground(XtDisplay(w), rcol->rescol.drawGC, sel_bg_color);
/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/
			if (rcol->rescol.xft)
			{
				XmStringDraw(XtDisplay(w), XtWindow(w), rcol->rescol.font_list, cell->xmlabel, gc,
					xtext, ytext, string_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
/******************************************************************/
/** If used clip in XmStringDraw() need restore clip area in GC  **/
/******************************************************************/

				if (!CHECK_CLIP_CORRECT)
					XSetClipRectangles(XtDisplay(w), gc,
									0, 0, clip, 1, Unsorted);
			}
			else
				XmStringDraw(XtDisplay(w), XtWindow(w), rcol->rescol.font_list, cell->xmlabel, gc,
					xtext, ytext, string_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
			
//			XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
//			XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);
		}
	}

#ifdef DEBUG
	printf("RCDrawItemTree: string drawed\n");
#endif


	if (pix) {
		ypix = y + ((height - pix->height) / 2);
		if (pix->pix && ypix + pix->height > rcol->rescol.viewY && ypix < rcol->rescol.viewY+rcol->rescol.viewHeight &&
			xpix < clip->x + clip->width && xpix + pix->width > clip->x)
		{
			if (ypix < rcol->rescol.viewY)
			{
				yc1 = rcol->rescol.viewY;
				ys = rcol->rescol.viewY - ypix;
			}
			else
			{
				yc1 = ypix;
				ys = 0;
			}

			if (ypix + pix->height > rcol->rescol.viewY + rcol->rescol.viewHeight)
			{
				yc2 = rcol->rescol.viewY + rcol->rescol.viewHeight;
			}
			else 
				yc2 = ypix + pix->height;

			if (xpix < clip->x)
			{
				xc1 = clip->x;
				xs = clip->x - xpix;
			}
			else
			{
				xc1 = xpix;
				xs = 0;
			}

			if (xpix + pix->width > clip->x + clip->width)
			{
				xc2 = clip->x + clip->width;
			}
			else 
				xc2 = xpix + pix->width;


/*			if (ypix < rcol->rescol.viewY)
			{
				rectangles.y=rcol->rescol.viewY - ypix;
				rectangles.height=pix->height - rectangles.y;
			}
			else
			{
				rectangles.y=0;
				rectangles.height=pix->height;
			}
			rectangles.x=0;
			rectangles.width=pix->width;*/

			if ((item->open && PIX_FOUND(item->openPixmap)) || (!item->open  && PIX_FOUND(item->closedPixmap)))
			{
//				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, pix->mask);
				XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, xpix, ypix);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, pix->mask);
				XCopyArea(XtDisplay(w), pix->pix, XtWindow(w),
						rcol->rescol.drawGC, xs, ys, xc2-xc1, yc2-yc1,
						xc1, yc1);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);
//				XSetClipRectangles(XtDisplay(w), rcol->rescol.drawGC,
//									0, 0, &clip, 1, Unsorted);
			}
			else
				XCopyArea(XtDisplay(w), pix->pix, XtWindow(w),
							gc, xs, ys, xc2 - xc1, yc2 - yc1,
							xc1, yc1);
		}
	}
#ifdef DEBUG
	printf("RCDrawItemTree: pix1 drawed\n");
#endif
	if (item->firstchild && !item->open)
	{
		ypix = y + ((height - rcol->rescol.ControlCollapsed.height) / 2);
		if (rcol->rescol.render_order == LtoR_render)
			XCopyArea(XtDisplay(w), rcol->rescol.ControlCollapsedSelected.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlCollapsedSelected.width,
					rcol->rescol.ControlCollapsedSelected.height,
					x, ypix);
		else
			XCopyArea(XtDisplay(w), rcol->rescol.ControlCollapsedSelected.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlCollapsedSelected.width,
					rcol->rescol.ControlCollapsedSelected.height,
					x - rcol->rescol.ControlCollapsedSelected.width, ypix);
	}

	if (item->firstchild && item->open)
	{
		ypix = y + ((height - rcol->rescol.ControlExpanded.height) / 2);

		if (rcol->rescol.render_order == LtoR_render)
			XCopyArea(XtDisplay(w), rcol->rescol.ControlExpandedSelected.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlExpandedSelected.width,
					rcol->rescol.ControlExpandedSelected.height,
					x, ypix);
		else
			XCopyArea(XtDisplay(w), rcol->rescol.ControlExpandedSelected.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlExpandedSelected.width,
					rcol->rescol.ControlExpandedSelected.height,
					x - rcol->rescol.ControlExpandedSelected.width, ypix);
	}
#ifdef DEBUG
	printf("RCDrawItemTree: pix2 drawed\n");
#endif

		yline = y + ((height - pix->height) / 2) + (pix->height / 2);
/*		XDrawLine(XtDisplay(w), XtWindow(w),
				rcol->rescol.drawGC,
				x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2,
				yline, x -(int) rcol->rescol.margin_w, yline);	*/
#ifdef DEBUG
	printf("RCDrawItemTree: line1 drawed\n");
#endif

	if (item->parent)
	{
		int i;
		yline = y;
		if (item->nextsibling)
		{
			if (rcol->rescol.render_order == LtoR_render)
				XCopyArea(XtDisplay(w), rcol->rescol.SelEpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x - rcol->rescol.ControlExpanded.width - rcol->rescol.margin_w, y);
			else
				XCopyArea(XtDisplay(w), rcol->rescol.SelEpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x + rcol->rescol.margin_w, y);
		}
		else
		{
			if (rcol->rescol.render_order == LtoR_render)
				XCopyArea(XtDisplay(w), rcol->rescol.SelLpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x - rcol->rescol.ControlExpanded.width - rcol->rescol.margin_w, y);
			else
				XCopyArea(XtDisplay(w), rcol->rescol.SelLpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x + rcol->rescol.margin_w, y);
		}

/*		ys = y + height;
		else
		ys = y + height/2;

		XDrawLine(XtDisplay(w), XtWindow(w),
					rcol->rescol.drawGC,
					x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2,
					yline, x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2, ys);	*/


//		x = x - 2 * (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2 - rcol->rescol.ControlOpen.width;
		if (rcol->rescol.render_order == LtoR_render)
			x = x - (int) rcol->rescol.margin_w - 2 * rcol->rescol.ControlExpanded.width;
		else
			x = x + (int) rcol->rescol.margin_w + rcol->rescol.ControlExpanded.width;
		for (i=0; i<item->level; i++)
		{
			if (item->lines[i])
			{
/*				XDrawLine(XtDisplay(w), XtWindow(w),
					rcol->rescol.drawGC,
					x, y, x, y+height);	*/
				if (rcol->rescol.render_order == LtoR_render)
					XCopyArea(XtDisplay(w), rcol->rescol.SelIpix, XtWindow(w),
								gc, 0, 0, rcol->rescol.ControlExpanded.width,
								height,
								x - rcol->rescol.margin_w, y);
				else
					XCopyArea(XtDisplay(w), rcol->rescol.SelIpix, XtWindow(w),
								gc, 0, 0, rcol->rescol.ControlExpanded.width,
								height,
								x + rcol->rescol.margin_w, y);
			}
//			x = x - (int) rcol->rescol.margin_w - rcol->rescol.ControlExpanded.width;
			if (rcol->rescol.render_order == LtoR_render)
				x = x - (int) rcol->rescol.margin_w - rcol->rescol.ControlExpanded.width;
			else
				x = x + (int) rcol->rescol.margin_w + rcol->rescol.ControlExpanded.width;
		}

	}

#ifdef DEBUG
	printf("RCDrawItemTree: line2 drawed\n");
#endif

}



void RCDrawItemTree(Widget w, VisibleItem * Element)
{
	int height, width, xpix, ypix, xtext, ytext, yline;
	Pixinfo *pix;
	XmNlListTreeItem * item;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Cell * cell = Element->element;
    XmNlRCL_Property_Row * prow;
	XRectangle * clip;
	int yc1, yc2, xc1, xc2, ys, xs;
	int y, x, row;
	int sel_delta, sel_wd, col;
	GC gc;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	CacheBufElement *CachePtr;
	Pixmap pbuf;
	Dimension string_w, string_h;

#ifdef DEBUG
	printf("Enter to RCDrawItemTree\n");
#endif

	if (cell == NULL) 
		return;

	string_w = XmStringWidth(rcol->rescol.font_list, cell->xmlabel);

	string_h = XmStringHeight(rcol->rescol.font_list, cell->xmlabel);

#ifdef FAST_XMSTRING_RENDERING
/*	SegmentedXmStringExtent2(XtDisplay(w), rcol->rescol.font_list, 
							cell->complabel, 
							&(string_w), &(string_h));*/
							
	SegmentedXmStringExtent3(XtDisplay(w), rcol->rescol.font_list, 
										cell->complabel, 
										&(string_w), &(string_h), rcol->rescol.idxRend);

#endif

    row = Element->num/rcol->rescol.num_cols;

    col = Element->num - row * rcol->rescol.num_cols;

	item = cell->node;

	prow = rcol->rescol.prop_data + col;
	clip = &(prow->clip);
	
#ifdef DEBUG
	printf("Enter to RCDrawItemTree col %d clipX %d clipW %d\n", col, clip->x, clip->width);
#endif
	if (clip->x == 0 && clip->width == 0)
		return ;

#ifdef DEBUG
	printf("RCDrawItemTree continue\n");
#endif

 	pix = RCGetItemPix(rcol, item, False);

/* Calc position and width of selection rectagle */

	if (rcol->rescol.num_cols == 1)
	{
		sel_delta = rcol->rescol.margin_w - rcol->rescol.global_h_shift;
		sel_wd = prow->current_width - 2 * rcol->rescol.margin_w;
	}
	else
		if (col == 0)
		{
			if (rcol->rescol.render_order == LtoR_render)
				sel_delta = rcol->rescol.margin_w;
			else
				sel_delta = 0;
			sel_wd = -rcol->rescol.margin_w;
		}
		else
			if (col == rcol->rescol.num_cols -1)
			{
				if (rcol->rescol.render_order == LtoR_render)
					sel_delta = 0;
				else
					sel_delta = rcol->rescol.margin_w;
				sel_wd = -rcol->rescol.margin_w;
			}
			else
			{
				sel_delta = 0;
				sel_wd = 0;
			}

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;
	highlight_color = ((XmPrimitiveWidget)rcol)->primitive.highlight_color;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;

	y = Element->y;
	if (rcol->rescol.render_order == LtoR_render)
		x = item->x - rcol->rescol.global_h_shift;
	else
		x = rcol->rescol.viewWidth - (item->x - rcol->rescol.global_h_shift);

	width = Element->width;
	height = Element->height;

	height = rcol->rescol.cell_height;


	if (item->firstchild)
	{
		if (rcol->rescol.render_order == LtoR_render)
			xtext = x + rcol->rescol.ctrlWidth + 2 * ((int) rcol->rescol.margin_w) +
			pix->width;
		else
			xtext = x - rcol->rescol.ctrlWidth - 2 * ((int) rcol->rescol.margin_w) -
			pix->width - string_w;
	}
	else
	{
		if (rcol->rescol.render_order == LtoR_render)
			xtext = x + (int) rcol->rescol.margin_w + rcol->rescol.pixWidth;
		else
			xtext = x - (int) rcol->rescol.margin_w - rcol->rescol.pixWidth - string_w;
	}



	if (rcol->rescol.render_order == LtoR_render)
		xpix = xtext - (int) rcol->rescol.margin_w - pix->width;
	else
		xpix = xtext + (int) rcol->rescol.margin_w + string_w;

	ytext = y + ((rcol->rescol.cell_height - string_h) / 2);
#ifdef DEBUG
	printf("RCDrawItemTree: xtext =%d xpix =%d ytext = %d w1 %d w2 %d w3 %d\n", xtext, xpix, ytext, pix->width, rcol->rescol.pixWidth, rcol->rescol.margin_w);
#endif


	gc = prow->gc;

	XSetForeground(XtDisplay(w), gc, foreground_color);
	XSetBackground(XtDisplay(w), gc, background_color);


//	XSetClipRectangles(XtDisplay(w), gc,
//				0, 0, &clip, 1, Unsorted);


	if (xtext <= (rcol->rescol.viewX + rcol->rescol.viewWidth))
//	if (xtext < (prow[col].clip.x + prow[col].clip.width) && (xtext + string_w) > prow[col].clip.x)
	{
		if (rcol->rescol.buffering)
		{
			if (cell->buf)
			{
//				printf("Draw buf found row = %d col = %d\n", row, col);
				pbuf = (((CacheBufElement*) (cell->buf))->id);
			}
			else
			{
//				printf("Draw buf not found row = %d col = %d\n", row, col);

				if (rcol->rescol.AllRedraw) 
					CachePtr = RCGetPixBufNew((Widget) w, cell, prow, row, col, -1);
				else
					CachePtr = RCGetPixBufNew((Widget) w, cell, prow, row, col, 0);
//				CachePtr = RCGetPixBuf((Widget) w, cell, prow, row, col);
				if (!CachePtr)
				{
//					printf("XXxxx\n");
					return ;
				}
				pbuf = CachePtr->id;
				cell->buf = CachePtr;
			}
			XCopyArea(XtDisplay(w), pbuf, XtWindow(w), gc,
						0, 0, string_w, string_h, xtext, ytext);
		}
		else
		{
#ifdef DEBUG
	printf("RCDrawItemTree: x %d w %d\n", clip->x, clip->width);
#endif

/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/
			if (rcol->rescol.xft)
			{
				XmStringDraw(XtDisplay(w), XtWindow(w), rcol->rescol.font_list, cell->xmlabel, gc,
						xtext, ytext, string_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);

/******************************************************************/
/** If used clip in XmStringDraw() need restore clip area in GC  **/
/******************************************************************/

				if (!CHECK_CLIP_CORRECT)
					XSetClipRectangles(XtDisplay(w), gc,
									0, 0, clip, 1, Unsorted);
			}
			else
				XmStringDraw(XtDisplay(w), XtWindow(w), rcol->rescol.font_list, cell->xmlabel, gc,
						xtext, ytext, string_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
		}
	}

#ifdef DEBUG
	printf("RCDrawItemTree: string drawed\n");
#endif

	if (pix) {
		ypix = y + ((height - pix->height) / 2);
		if (pix->pix && ypix + pix->height > rcol->rescol.viewY && ypix < rcol->rescol.viewY + rcol->rescol.viewHeight &&
			xpix < clip->x + clip->width && xpix + pix->width > clip->x)
		{
			if (ypix < rcol->rescol.viewY)
			{
				yc1 = rcol->rescol.viewY;
				ys = rcol->rescol.viewY - ypix;
			}
			else
			{
				yc1 = ypix;
				ys = 0;
			}

			if (ypix + pix->height > rcol->rescol.viewY + rcol->rescol.viewHeight)
				yc2 = rcol->rescol.viewY + rcol->rescol.viewHeight;
			else 
				yc2 = ypix + pix->height;

			if (xpix < clip->x)
			{
				xc1 = clip->x;
				xs = clip->x - xpix;
			}
			else
			{
				xc1 = xpix;
				xs = 0;
			}

			if (xpix + pix->width > clip->x + clip->width)
			{
				xc2 = clip->x + clip->width;
			}
			else 
				xc2 = xpix + pix->width;

			if ((item->open && PIX_FOUND(item->openPixmap)) || (!item->open  && PIX_FOUND(item->closedPixmap)))
			{
//				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, pix->mask);
#ifdef DEBUG
						printf("]]]]]]]]]]]]] xc1 = %d xc2 = %d\n", xc1, xc2);
#endif
				XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, xpix, ypix);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, pix->mask);
				XCopyArea(XtDisplay(w), pix->pix, XtWindow(w),
						rcol->rescol.drawGC, xs, ys, xc2-xc1, yc2-yc1,
						xc1, yc1);
//						printf("xc1 = %d\n", xc1);
				XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);
//				XSetClipRectangles(XtDisplay(w), rcol->rescol.drawGC,
//									0, 0, &clip, 1, Unsorted);
			}
			else
			{
//	XSetClipRectangles(XtDisplay(w), gc,
//				0, 0, &clip, 1, Unsorted);
			XCopyArea(XtDisplay(w), pix->pix, XtWindow(w),
						gc, xs, ys, xc2 - xc1, yc2 - yc1,
						xc1, yc1);
#ifdef DEBUG
						printf("[[[[[[[[[[[[[[[[[[[[[[[[[[ xc1 = %d xc2 = %d\n", xc1, xc2);
#endif
			}
		}
	}

#ifdef DEBUG
	printf("RCDrawItemTree: pix1 drawed\n");
#endif
	if (item->firstchild && !item->open)
	{
		ypix = y + ((height - rcol->rescol.ControlCollapsed.height) / 2);
		if (rcol->rescol.render_order == LtoR_render)
			XCopyArea(XtDisplay(w), rcol->rescol.ControlCollapsed.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlCollapsed.width,
					rcol->rescol.ControlCollapsed.height,
					x, ypix);
		else
			XCopyArea(XtDisplay(w), rcol->rescol.ControlCollapsed.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlCollapsed.width,
					rcol->rescol.ControlCollapsed.height,
					x - rcol->rescol.ControlCollapsed.width, ypix);
	}

	if (item->firstchild && item->open)
	{
		ypix = y + ((height - rcol->rescol.ControlExpanded.height) / 2);
		if (rcol->rescol.render_order == LtoR_render)
			XCopyArea(XtDisplay(w), rcol->rescol.ControlExpanded.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlExpanded.width,
					rcol->rescol.ControlExpanded.height,
					x, ypix);
		else
			XCopyArea(XtDisplay(w), rcol->rescol.ControlExpanded.pix, XtWindow(w),
					gc, 0, 0, rcol->rescol.ControlExpanded.width,
					rcol->rescol.ControlExpanded.height,
					x - rcol->rescol.ControlExpanded.width, ypix);
	}
#ifdef DEBUG
	printf("RCDrawItemTree: pix2 drawed\n");
#endif

	yline = y + ((height - pix->height) / 2) + (pix->height / 2);
/*		XDrawLine(XtDisplay(w), XtWindow(w),
				rcol->rescol.drawGC,
				x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2,
				yline, x -(int) rcol->rescol.margin_w, yline);	*/
#ifdef DEBUG
	printf("RCDrawItemTree: line1 drawed\n");
#endif

	if (item->parent)
	{
		int i;
		yline = y;
		if (item->nextsibling)
		{
			if (rcol->rescol.render_order == LtoR_render)
				XCopyArea(XtDisplay(w), rcol->rescol.Epix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x - rcol->rescol.ControlExpanded.width - rcol->rescol.margin_w, y);
			else
				XCopyArea(XtDisplay(w), rcol->rescol.Epix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x + rcol->rescol.margin_w, y);
		}
		else
		{
			if (rcol->rescol.render_order == LtoR_render)
				XCopyArea(XtDisplay(w), rcol->rescol.Lpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x - rcol->rescol.ControlExpanded.width - rcol->rescol.margin_w, y);
			else
				XCopyArea(XtDisplay(w), rcol->rescol.Lpix, XtWindow(w),
							gc, 0, 0, rcol->rescol.ControlExpanded.width,
							height,
							x + rcol->rescol.margin_w, y);
		}
/*		ys = y + height;
		else
		ys = y + height/2;

		XDrawLine(XtDisplay(w), XtWindow(w),
					rcol->rescol.drawGC,
					x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2,
					yline, x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2, ys);	*/


//		x = x - 2 * (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width/2 - rcol->rescol.ControlOpen.width;
		if (rcol->rescol.render_order == LtoR_render)
			x = x - (int) rcol->rescol.margin_w - 2 * rcol->rescol.ControlExpanded.width;
		else
			x = x + (int) rcol->rescol.margin_w + rcol->rescol.ControlExpanded.width;

		for (i = 0; i < item->level; i++)
		{
			if (item->lines[i])
			{
/*				XDrawLine(XtDisplay(w), XtWindow(w),
					rcol->rescol.drawGC,
					x, y, x, y+height);	*/
				if (rcol->rescol.render_order == LtoR_render)
					XCopyArea(XtDisplay(w), rcol->rescol.Ipix, XtWindow(w),
								gc, 0, 0, rcol->rescol.ControlExpanded.width,
								height,
								x - rcol->rescol.margin_w, y);
				else
					XCopyArea(XtDisplay(w), rcol->rescol.Ipix, XtWindow(w),
								gc, 0, 0, rcol->rescol.ControlExpanded.width,
								height,
								x + rcol->rescol.margin_w, y);
			}
//			x = x - (int) rcol->rescol.margin_w - rcol->rescol.ControlOpen.width;
			if (rcol->rescol.render_order == LtoR_render)
				x = x - (int) rcol->rescol.margin_w - rcol->rescol.ControlExpanded.width;
			else
				x = x + (int) rcol->rescol.margin_w + rcol->rescol.ControlExpanded.width;
		}
	}

#ifdef DEBUG
	printf("RCDrawItemTree: line2 drawed\n");
#endif

}


void RefreshCachePixItemTree(Widget w, XmNlRCL_Cell * cell_ptr, Boolean selected)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col;
    XmNlRCL_Cell * cell;
	Pixmap pbuf;
	CacheBufElement * CachePtr;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=rcol->primitive.foreground;
	else
			sel_bg_color=rcol->rescol.select_background_pixel;

	for (col = 0; col < rcol->rescol.num_cols; col++)
	{
		cell = cell_ptr + col;
		if (cell->buf)
		{
			CachePtr = (CacheBufElement *) cell->buf;
			pbuf = CachePtr->id;
			if(selected)
			{
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
				XFillRectangle(XtDisplay(w), pbuf, rcol->rescol.pixGC, 0,0, CachePtr->wd, CachePtr->ht);
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_fg_color);
				XSetBackground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
				XmStringDraw(XtDisplay(w), pbuf, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
								0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
			}
			else
			{
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, background_color);
				XFillRectangle(XtDisplay(w), pbuf, rcol->rescol.pixGC, 0, 0, CachePtr->wd, CachePtr->ht);
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
				XmStringDraw(XtDisplay(w), pbuf, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
							0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
			}
		}
	}
}


static void RefreshCachePix(Widget w, int row, Boolean selected)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col;
    XmNlRCL_Cell * cell;
	Pixmap pbuf;
	CacheBufElement * CachePtr;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=rcol->primitive.foreground;
	else
			sel_bg_color=rcol->rescol.select_background_pixel;

	for (col = 0; col < rcol->rescol.num_cols; col++)
	{
		cell = *(rcol->rescol.ItemData + row) + col;
		if (cell->buf)
		{
			CachePtr = (CacheBufElement *) cell->buf;
			pbuf = CachePtr->id;
			if(selected)
			{
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
				XFillRectangle(XtDisplay(w), pbuf, rcol->rescol.pixGC, 0,0, CachePtr->wd, CachePtr->ht);
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_fg_color);
				XSetBackground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
#ifdef FAST_XMSTRING_RENDERING
				if (cell->complabel)
					DrawComplexString3(XtDisplay(w), pbuf, rcol->rescol.pixGC, 
								rcol->rescol.font_list, cell->complabel, 
#ifdef	USE_XFT
								NULL, 
#endif
								0, 0, rcol->rescol.idxRend, sel_fg_color, NULL);
#else
				XmStringDraw(XtDisplay(w), pbuf, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
								0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
			}
			else
			{
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, background_color);
				XFillRectangle(XtDisplay(w), pbuf, rcol->rescol.pixGC, 0, 0, CachePtr->wd, CachePtr->ht);
				XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
#ifdef FAST_XMSTRING_RENDERING
				if (cell->complabel)
					DrawComplexString3(XtDisplay(w), pbuf, rcol->rescol.pixGC, 
									rcol->rescol.font_list, cell->complabel, 
#ifdef	USE_XFT
									NULL, 
#endif
									0, 0, rcol->rescol.idxRend, foreground_color, NULL);
#else
				XmStringDraw(XtDisplay(w), pbuf, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
							0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
			}
		}
	}
}

#ifdef DEBUG
static void CheckCacheChunk(XmNlRCL_Property_Row * );
#endif

static void RCDrawItem(Widget w, VisibleItem * Element)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Cell * cell;
    XmNlRCL_Property_Row * prw;
    Pixmap pixmap, mask;
    int row, x, y, col, h_margin, sel_delta, sel_wd;
    int height, width, y1, l_width, l_height;
	Dimension wd, ht;
	Display *dpy;
	Screen *scrn;
	Window win;
    GC gc;
    XRectangle * clip;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
    XmString label;
#ifdef FAST_XMSTRING_RENDERING
	SegmentedXmString * complabel;
#endif
	CacheBufElement* CachePtr;
	IconInfo * icon;

	Pixmap pbuf;

    int x1; /* left coordinate of text with margin_w if XmALIGNMENT_BEGINNING */
    int x2; /* right coordinate of text with margin_w if XmALIGNMENT_END */
    int x3; /* left coordinate of text with margin_w if XmALIGNMENT_END */
    int xsrc; /* shift in source pixmap buf */
    int xdst; /* shift in destination drawable */
    int cw; /* clipped width of copying pixmap */
	int col_w; /* Column width without margin*/

	if (Element->element == NULL) 
		return;

	cell = Element->element;

    row = Element->num/rcol->rescol.num_cols;

	if (row <= 0 ) 
		col = Element->num;
	else
	{
		col = Element->num - row * rcol->rescol.num_cols;
	}
#ifdef DEBUG
	printf("RCDrawItem col=%d number=%d\n", col, Element->num);
#endif

	prw = rcol->rescol.prop_data + COL_MAPPED(col);

	if (!prw->clip_displayed)
		return ;

	if (rcol->rescol.TreeMode && col == 0)
	{
		if(rcol->rescol.selected_rows[row] == True) 
			RCDrawItemTreeSelected(w, Element, True);
		else
			RCDrawItemTree(w, Element);
		return ;
	}

	clip = &(prw->clip);

	gc = prw->gc;

#ifdef DEBUG
	printf("RCDrawItem  col = %d clip w = %d\n", col, clip->width);
#endif

	l_width = cell->label_w;
	l_height = cell->label_h;
	h_margin = rcol->rescol.margin_w;

	col_w = prw->current_width - 2 * rcol->rescol.margin_w;

	if (rcol->rescol.render_order == LtoR_render)
	{
		x = Element->x;
		x2 = Element->x + h_margin;
		if (prw->align_type == XmALIGNMENT_BEGINNING)
			x1 = Element->x + h_margin;
		else
			x1 = Element->x + prw->current_width - h_margin - l_width;
	}
	else
	{
		x = rcol->rescol.viewWidth - Element->x - prw->current_width;
		x2 = rcol->rescol.viewWidth - Element->x - prw->current_width + h_margin;
		if (prw->align_type == XmALIGNMENT_BEGINNING)
			x1 = rcol->rescol.viewWidth - Element->x - h_margin - l_width;
		else
			x1 = rcol->rescol.viewWidth - Element->x - prw->current_width + h_margin;
	}

#ifdef DEBUG
	printf("RCDrawItem start \n");
#endif
	dpy = XtDisplay(w);
	scrn = XtScreen(w);
	win = XtWindow(w);
#ifdef DEBUG
	printf("RCDrawItem element found \n");
#endif

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color = rcol->primitive.foreground;
	else
			sel_bg_color = rcol->rescol.select_background_pixel;

	y = Element->y;
	height = Element->height;
	width = Element->width;



#ifdef DEBUG
	printf("RCDrawItem row=%d \n", row);
#endif

	if (x + width < rcol->rescol.viewX) return;


	if(rcol->rescol.selected_rows[row] == True)  goto l1; /* This row is selected */


/********** This row is not selected **********************************************/

/********** This is pixmap ********************************************************/
	if(prw->info_type == XmPIXMAP)
	{
		if (cell->icon)
		{
			icon = cell->icon;
			y1 = y + (rcol->rescol.cell_height - icon->height)/2;
			if (PIX_FOUND(icon->pix))
			{
				int pix_x, pix_w;
				if (col_w < icon->width)
				{
					pix_x = (icon->width - col_w) / 2;
					pix_w = icon->width - pix_x - pix_x;
					XCopyArea(dpy, icon->pix, win, gc,
						pix_x, 0, pix_w, icon->height, x2,
						y1);
				}
				else
				{
//			XSetClipOrigin(dpy, rcol->rescol.drawGC, 0, 0);
//			XSetClipMask(dpy, rcol->rescol.drawGC, None);
					XCopyArea(dpy, icon->pix, win, gc,
						0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2,
						y1);
				}
			}
		}

#ifdef DEBUG_SHIFTING
		printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
	}


/********* This is text **********************************************************/
	if(prw->info_type == XmSTRING)
	{
		label = cell->xmlabel;
		if (!label)
			return ;

#ifdef FAST_XMSTRING_RENDERING
		complabel = cell->complabel;
		if (!complabel)
			return ;
#endif

#ifdef DEBUG
		printf("RCDrawItem: label %s\n", cell->text);
#endif

/*		XSetClipRectangles(XtDisplay(w), prw->gc,
				0, 0, clip, 1, Unsorted);*/

		if (rcol->rescol.buffering)
		{
			if (cell->buf)
			{
				pbuf = (((CacheBufElement*) (cell->buf))->id);
			}
			else
			{
				if (rcol->rescol.AllRedraw) 
					CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), -1);
				else
					CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), 0);
				if (!CachePtr)
				{
					return ;
				}
				pbuf = CachePtr->id;
				cell->buf = CachePtr;
			}
		}

		y1 = y + (rcol->rescol.cell_height - l_height)/2;


		XSetForeground(dpy, gc, foreground_color);
		XSetBackground(dpy, gc, background_color);

		if (rcol->rescol.buffering)
		{
			XCopyArea(dpy, pbuf, win, gc,
						0, 0, l_width, l_height,
						x1, y1);

#ifdef DEBUG
			if (col == 1)
			{
				printf("=== row %d l_width %d label_w %d clip_w %d\n", row, l_width, cell->label_w, clip->width);
				CheckCacheChunk(prw);
			}
#endif
		}
		else
		{
			if (rcol->rescol.xft)
			{
/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/
#ifdef FAST_XMSTRING_RENDERING
/*				DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
									complabel, x1, y1, clip);*/
				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
									prw->xftdraw, 
#endif
									x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//									complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
				XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
							y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif

/******************************************************************/
/** If used clip in XmStringDraw() need restore clip area in GC  **/
/******************************************************************/
				if (!CHECK_CLIP_CORRECT)
					XSetClipRectangles(XtDisplay(w), gc,
									0, 0, clip, 1, Unsorted);
			}
			else
#ifdef FAST_XMSTRING_RENDERING
/*				DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
									complabel, x1, y1, clip);*/
				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
									prw->xftdraw, 
#endif
									x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//									complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
				XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
							y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
		}

/*		XSetClipMask(dpy, rcol->rescol.drawGC, None);	*/
	}

	return ;


l1:

/*********** This row is selected *********************************************/

	if (col == 0)
	{
		if (rcol->rescol.render_order == LtoR_render)
			sel_delta = rcol->rescol.margin_w;
		else
			sel_delta = 0;
		sel_wd = -rcol->rescol.margin_w;
	}
	else
	if (col == rcol->rescol.num_cols -1)
	{
		if (rcol->rescol.render_order == LtoR_render)
			sel_delta = 0;
		else
			sel_delta = rcol->rescol.margin_w;
		sel_wd = -rcol->rescol.margin_w;
	}
	else
	{
		sel_delta = 0;
		sel_wd = 0;
	}


	XSetForeground(dpy, rcol->rescol.drawGC, sel_bg_color);

	XFillRectangle(dpy, win, rcol->rescol.drawGC, x + sel_delta, y + rcol->rescol.margin_h,
					width + sel_wd, height - 2* rcol->rescol.margin_h);

	XSetForeground(dpy, rcol->rescol.drawGC, foreground_color);


	XSetForeground(dpy, gc, sel_fg_color);
	XSetBackground(dpy, gc, sel_bg_color);



/************ This is pixmap **********************************************/
	if(prw->info_type == XmPIXMAP)
	{
		if (cell->icon)
		{
			icon = cell->icon;
			y1 = y + (rcol->rescol.cell_height - icon->height)/2;
			if (PIX_FOUND(icon->highlighted))
			{
				int pix_x, pix_w;
				if (col_w < icon->width)
				{
					pix_x = (icon->width - col_w) / 2;
					pix_w = icon->width - pix_x - pix_x;
					XCopyArea(dpy, icon->highlighted, win, gc,
						pix_x, 0, pix_w, icon->height, x2,
						y1);
				}
				else
				{
					XCopyArea(dpy, icon->highlighted, win, gc,
						0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2,
						y1);
				}
			}
		}

#ifdef DEBUG_SHIFTING
		printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
	}

/**************** This is text ******************************************/
	if(prw->info_type == XmSTRING)
	{
		label = cell->xmlabel;
		if (!label)
			goto l2;

#ifdef FAST_XMSTRING_RENDERING
		complabel = cell->complabel;
		if (!complabel)
			goto l2;
#endif

		if (rcol->rescol.buffering)
		{
			if (cell->buf)
			{
				pbuf = (((CacheBufElement*) (cell->buf))->id);
			}
			else
			{

				if (rcol->rescol.AllRedraw) 
					CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), -1);
				else
					CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), 0);

				if (!CachePtr)
				{
					return ;
				}
				pbuf = CachePtr->id;
				cell->buf = CachePtr;
			}
		}

#ifdef DEBUG
		printf("==================RCDrawItem: label %s at %d\n", cell->text, x1);
#endif


		y1 = y + (rcol->rescol.cell_height - l_height)/2;

		if (rcol->rescol.buffering)
		{
			XCopyArea(dpy, pbuf, win, gc,
						0, 0, l_width, l_height,
						x1, y1);
		}
		else
		{
			if (rcol->rescol.xft)
			{
/*******************************************************************************/
/** If used XFT rendering need use clip in XmStringDraw(), otherwise not need **/
/*******************************************************************************/
#ifdef FAST_XMSTRING_RENDERING
/*				DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
									complabel, x1, y1, clip);*/
				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
									prw->xftdraw, 
#endif
									x1, y1, rcol->rescol.idxRend, sel_fg_color, clip);
//				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//									complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
				XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
						y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif

/******************************************************************/
/** If used clip in XmStringDraw() need restore clip area in GC  **/
/******************************************************************/
				if (!CHECK_CLIP_CORRECT)
					XSetClipRectangles(XtDisplay(w), gc,
									0, 0, clip, 1, Unsorted);
			}
			else
#ifdef FAST_XMSTRING_RENDERING
/*				DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
									complabel, x1, y1, clip);*/
				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
									prw->xftdraw, 
#endif
									x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//				DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//									complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
				XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
						y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
		}
	}

l2:

	XSetForeground(dpy, gc, foreground_color);
	XSetBackground(dpy, gc, background_color);
#ifdef DEBUG
	printf("RCDrawItem complet \n");
#endif
	return ;
}


static void ScrollTimeout(XtPointer client_data, XtIntervalId *timer);

void RCDrawRows(Widget w, int start_row, int end_row, int direction)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XmNlRCL_Cell * cell;
    XmNlRCL_Property_Row * prw;
    Pixmap pixmap, mask;
    register int col;
    int row;
    int y, h_margin, sel_x1, sel_x2, sel_delta, sel_wd;
    int height, width, y1, l_width, l_height;
    int col_w;
	Display *dpy;
	Screen *scrn;
	Window win;
    GC gc;
    XRectangle * clip;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
    XmString label;
#ifdef FAST_XMSTRING_RENDERING
	SegmentedXmString * complabel;
#endif
	CacheBufElement* CachePtr;
	VisibleItem Element;
	Pixmap pbuf;
	IconInfo * icon;
	int delta_row = 1;



    int x1; /* left coordinate of text with margin_w if XmALIGNMENT_BEGINNING */
    int x2; /* right coordinate of text with margin_w if XmALIGNMENT_END */
//    int xsrc; /* shift in source pixmap buf */
//    int xdst; /* shift in destination drawable */

	dpy = XtDisplay(w);
	scrn = XtScreen(w);
	win = XtWindow(w);

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;


	height = rcol->rescol.cell_height;
	h_margin = rcol->rescol.margin_w;

	if (rcol->rescol.AutoDropScrollEvent)
	{
		if (((end_row - start_row +1) * height) > rcol->rescol.viewHeight)
		{
			delta_row = 2;
		}
	}

	if (delta_row > 1) 
		rcol->rescol.firstInterleavedRow = start_row;

	for (row = start_row; row < end_row; row = row + delta_row)
	{
		if (delta_row > 1) 
			rcol->rescol.lastInterleavedRow = row;

		y = row * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

		if(rcol->rescol.selected_rows[row] == True)
		{
			sel_x1 = rcol->rescol.margin_w;
			if (sel_x1 - rcol->rescol.global_h_shift < 0) sel_x1 = 0;

			sel_x2 = rcol->rescol.full_width - rcol->rescol.margin_w;
			if (sel_x2 - rcol->rescol.global_h_shift > rcol->rescol.viewWidth) sel_x2 = rcol->rescol.viewWidth;

			sel_wd = sel_x2 - sel_x1;

			XSetForeground(dpy, rcol->rescol.drawGC, sel_bg_color);
			XFillRectangle(dpy, win, rcol->rescol.drawGC, sel_x1, y + rcol->rescol.margin_h,
							sel_wd, height - 2* rcol->rescol.margin_h);
		}

		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
			prw = rcol->rescol.prop_data + COL_MAPPED(col);
			if (!prw->clip_displayed)
							continue ;

			if (rcol->rescol.TreeMode && col == 0)
			{
				Element.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
				Element.y = y + rcol->rescol.viewY;
				Element.x = prw->x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				Element.width = prw->current_width;
				Element.height = rcol->rescol.cell_height;
				Element.num = row * rcol->rescol.num_cols + col;
				if(rcol->rescol.selected_rows[row] == True) 
					RCDrawItemTreeSelected(w, &Element, False);
				else
					RCDrawItemTree(w, &Element);
				continue ;
			}

			cell = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);

			gc = prw->gc;
			
			clip = &(prw->clip);

			width = prw->current_width;
			l_width = cell->label_w;
			l_height = cell->label_h;
			col_w = prw->current_width - 2 * rcol->rescol.margin_w;


			if (rcol->rescol.render_order == LtoR_render)
			{
				x2 = prw->xx1;
				if (prw->align_type == XmALIGNMENT_BEGINNING)
					x1 = prw->xx1;
				else
					x1 = prw->xx2 - l_width;
			}
			else
			{
				x2 =  prw->xx1;

				if (prw->align_type == XmALIGNMENT_BEGINNING)
					x1 = prw->xx2 - l_width;
				else
					x1 = prw->xx1;
			}


			if(rcol->rescol.selected_rows[row] == True)  
				goto l1; /* This row is selected */


/********** This row is not selected **********************************************/

/********** This is pixmap ********************************************************/
			if(prw->info_type == XmPIXMAP)
			{
				if (cell->icon)
				{
					icon = cell->icon;
//					pixmap = icon->pix;
//					mask = icon->mask;
					y1 = y + (rcol->rescol.cell_height - icon->height)/2;
					if (PIX_FOUND(icon->pix))
					{
						int pix_x, pix_w;
						if (col_w < icon->width)
						{
							pix_x = (icon->width - col_w) / 2;
							pix_w = icon->width - pix_x - pix_x;
							XCopyArea(dpy, icon->pix, win, gc,
									pix_x, 0, pix_w, icon->height, x2, y1);
						}
						else
						{
							XCopyArea(dpy, icon->pix, win, gc,
									0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2, y1);
						}
					}
				}
#ifdef DEBUG_SHIFTING
					printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
			}


/********* This is text **********************************************************/
			if(prw->info_type == XmSTRING)
			{
				label = cell->xmlabel;
				if (!label)
					continue ;

#ifdef FAST_XMSTRING_RENDERING
				complabel = cell->complabel;
				if (!complabel)
					continue ;
#endif
				
#ifdef DEBUG
				printf("RCDrawItem: label %s\n", cell->text);
#endif

				if (rcol->rescol.buffering)
				{
					if (cell->buf)
					{
						pbuf = (((CacheBufElement*) (cell->buf))->id);
					}
					else
					{

						CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), direction);
						if (!CachePtr)
						{
							return ;
						}
						pbuf = CachePtr->id;
						cell->buf = CachePtr;
					}
				}

				y1 = y + (rcol->rescol.cell_height - l_height)/2;


//				XSetForeground(dpy, gc, foreground_color);
//				XSetBackground(dpy, gc, background_color);

				if (rcol->rescol.buffering)
				{
					XCopyArea(dpy, pbuf, win, gc,
									0, 0, l_width, l_height,
									x1, y1);
				}
				else
				{
					if (rcol->rescol.xft)
					{
/*						if (!CHECK_CLIP_CORRECT)
						{
							XSetClipRectangles(XtDisplay(w), gc,
											0, 0, clip, 1, Unsorted);
											
						printf(">>>>>>>> Clip %d %d\n", clip->y, clip->height);
					}	*/

#ifdef FAST_XMSTRING_RENDERING
/*						DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
											complabel, x1, y1, clip);*/
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//										complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
								y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif
/*						if (!CHECK_CLIP_CORRECT)*/
#if XmVERSION < 2 && XmREVISION < 3 && XmUPDATE_LEVEL < 4
							XSetClipRectangles(XtDisplay(w), gc, 0, 0, clip, 1, Unsorted);
#endif
					}
					else
#ifdef FAST_XMSTRING_RENDERING
/*						DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
											complabel, x1, y1, clip);*/
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//											complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
								y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
				}
			}

			continue ;


l1:

/*********** This row is selected *********************************************/


/************ This is pixmap **********************************************/
			if(prw->info_type == XmPIXMAP)
			{
//				pixmap=cell->pixmap;
//				mask=cell->mask;
				if (cell->icon)
				{
					icon = cell->icon;
//					pixmap = icon->pix;
//					mask = icon->mask;
					y1 = y + (rcol->rescol.cell_height - icon->height)/2;
					if (PIX_FOUND(icon->highlighted))
					{
						int pix_x, pix_w;
						if (col_w < icon->width)
						{
							pix_x = (icon->width - col_w) / 2;
							pix_w = icon->width - pix_x - pix_x;
							XCopyArea(dpy, icon->highlighted, win, gc,
									pix_x, 0, pix_w, icon->height, x2, y1);
						}
						else
						{
							XCopyArea(dpy, icon->highlighted, win, gc,
									0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2, y1);
						}
					}
#ifdef DEBUG_SHIFTING
					printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
				}
			}

/**************** This is text ******************************************/
			if(prw->info_type == XmSTRING)
			{
#ifdef DEBUG_SHIFTING
				printf("Draw cell %d XmSTRING w = %d %p\n", col, prw->current_width, cell->xmlabel);
#endif

				label = cell->xmlabel;
				if (!label)
					continue ;

#ifdef FAST_XMSTRING_RENDERING
				complabel = cell->complabel;
				if (!complabel)
					continue ;
#endif

				if (rcol->rescol.buffering)
				{
					if (cell->buf)
					{
						pbuf = (((CacheBufElement*) (cell->buf))->id);
					}
					else
					{
						CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), direction);
						if (!CachePtr)
						{
							return ;
						}
						pbuf = CachePtr->id;
						cell->buf = CachePtr;
					}
				}

				XSetForeground(dpy, gc, sel_fg_color);
				XSetBackground(dpy, gc, sel_bg_color);

#ifdef DEBUG
				printf("RCDrawItem: label %s\n", cell->text);
#endif


				y1 = y + (rcol->rescol.cell_height - l_height)/2;

				if (rcol->rescol.buffering)
				{
#ifdef DEBUG
					if (col == 6)
					{
						CheckCacheChunk(prw);
					}
#endif
					XCopyArea(dpy, pbuf, win, gc,
								0, 0, l_width, l_height,
								x1, y1);
				}
				else
				{
					if (rcol->rescol.xft)
					{
#ifdef FAST_XMSTRING_RENDERING
/*						DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
										complabel, x1, y1, clip);*/
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, sel_fg_color, clip);
//						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//										complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
									y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif
/*						if (!CHECK_CLIP_CORRECT)*/
#if XmVERSION < 2 && XmREVISION < 3 && XmUPDATE_LEVEL < 4
							XSetClipRectangles(XtDisplay(w), gc, 0, 0, clip, 1, Unsorted);
#endif
					}
					else
#ifdef FAST_XMSTRING_RENDERING
/*						DrawComplexString2(dpy, win, gc, rcol->rescol.font_list, 
										complabel, x1, y1, clip);*/
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, foreground_color, clip);
//						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, 
//										complabel, NULL, x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
									y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
				}
				XSetForeground(dpy, gc, foreground_color);
				XSetBackground(dpy, gc, background_color);
			}
		}

		if (row == rcol->rescol.current_row)
			CurrentFrameDraw(w);
	}
	
	if (rcol->rescol.AutoDropScrollEvent && delta_row > 1)
	{
		if (!rcol->rescol.scrollRefreshTimeoutFound)
		{
			rcol->rescol.scrollIntervalId = XtAppAddTimeOut(XtWidgetToApplicationContext(w), 250, ScrollTimeout, (XtPointer) rcol);
			rcol->rescol.scrollRefreshTimeoutFound = True;
#ifdef DEBUG
			printf("Refresh after fast scroll timeout added\n");
#endif
		}
	}	
	return ;
}

void RCRedrawElement(Widget w, VisibleItem * Element, Boolean ClearOn)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
//	int i, j,k=0;
	int x, y;
//	int shift;
//	int x1, x2, x3, y1, y2, y3;
	XmNlRCL_Cell * data;


	x = Element->x;
	y = Element->y;
	data = Element->element;


//	if (/*data==NULL || */rcol->rescol.num_items==0) return;
//	dpy=XtDisplay(w);

#ifdef DEBUG
	printf("Redraw Element\n");
#endif

	if (ClearOn)
	{
		if (rcol->rescol.render_order == LtoR_render)
				XClearArea(XtDisplay(w), XtWindow(w), Element->x, Element->y,
							Element->width, Element->height, False);
		else
				XClearArea(XtDisplay(w), XtWindow(w), rcol->rescol.viewWidth - Element->x - Element->width, Element->y,
							Element->width, Element->height, False);
	}

	if (data == NULL) 
		return;

	RCDrawItem(w, Element);

	return ;
}


void RCRedrawAllWindow(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i, j, y, k;
	VisibleItem El;
	XmNlRCL_Cell *cell;
    XmNlRCL_Property_Row * rw;
	XRectangle clip;
    if (!XtIsRealized(w)) return ;

    rw = rcol->rescol.prop_data;

	XClearArea(XtDisplay(w), XtWindow(w), rcol->rescol.viewX, rcol->rescol.viewY,
				rcol->rescol.viewWidth, rcol->rescol.viewHeight, False);

	if (!rcol->rescol.ItemData) return ;

#ifdef DEBUG
	printf("RCRedrawAllWindow  topline = %d botomline = %d row = %d w = %d h = %d\n", 
			rcol->rescol.TopLine, rcol->rescol.BotomLine, rcol->rescol.num_rows, w->core.width, w->core.height);
#endif


	clip.y = rcol->rescol.viewY;
	clip.height = rcol->rescol.viewHeight;
	y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;
	El.height = rcol->rescol.cell_height;
	for (j = rcol->rescol.TopLine; j < rcol->rescol.BotomLine; j++)
	{
		El.y = y + rcol->rescol.viewY;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
//			if (rw[i].x - rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
//				|| rw[i].x - rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)
			if (rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
				|| rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rw[COL_MAPPED(i)].current_width < rcol->rescol.viewX)
						continue ;

			El.x = rw[COL_MAPPED(i)].x-rcol->rescol.global_h_shift + rcol->rescol.viewX;
			El.width = rw[COL_MAPPED(i)].current_width;
//			El.x = rw[i].x-rcol->rescol.global_h_shift + rcol->rescol.viewX;
//			El.width = rw[i].current_width;

/*			if (El.x + rcol->rescol.margin_w > rcol->rescol.viewX) clip.x = El.x;
			else clip.x=rcol->rescol.viewX;
			if ((clip.x+El.width) < (rcol->rescol.viewX+rcol->rescol.viewWidth)) clip.width = El.width;
			else clip.width=rcol->rescol.viewX+rcol->rescol.viewWidth-clip.x;
			if (El.x + El.width < clip.x + clip.width) clip.width = El.x + El.width - clip.x - rcol->rescol.margin_w;

			XSetClipRectangles(XtDisplay(w), rcol->rescol.tdrawGC,
								0, 0, &clip, 1, Unsorted);
*/


			El.num = j*rcol->rescol.num_cols + i;
			if (j < rcol->rescol.num_rows)
			{
#ifdef DEBUG
			printf("RCRedrawAllWindow  element init\n");
#endif
				cell = rcol->rescol.ItemData[j];
				El.element = cell + COL_MAPPED(i);
//				El.element = cell + i;
			}
			else
				El.element = NULL;
#ifdef DEBUG
			printf("RCRedrawAllWindow  i = %d j = %d num = %d el.x = %d el.y = %d el.w = %d el.h = %d\n", i, j, El.num, El.x, El.y, El.width, El.height);
#endif
			RCDrawItem(w, &El);
		}
		y = y + rcol->rescol.cell_height;
	}

#ifdef DEBUG
	printf("RedrawWindow=OK\n");
#endif

	return ;
}


void RCRedrawRowRegion(Widget w, int yr, int hr, int direction)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int j;
	int b_row, e_row, y;
	int y1, y2, y3;
	Display *dpy = XtDisplay(w);

#ifdef DEBUG
	printf("RCRedrawWindow  cols = %d rows = %d top = %d bot = %d\n", rcol->rescol.num_cols, rcol->rescol.num_rows, rcol->rescol.TopLine, rcol->rescol.BotomLine);
#endif
	if (!rcol->rescol.ItemData) return ;

	b_row = (yr + rcol->rescol.global_v_shift) / rcol->rescol.cell_height;

	if(b_row >= rcol->rescol.num_rows) return ;

	e_row = (yr + hr + rcol->rescol.global_v_shift) / rcol->rescol.cell_height;
	if (e_row * rcol->rescol.cell_height < yr + rcol->rescol.global_v_shift + hr) e_row++;
	if (e_row > rcol->rescol.num_rows) e_row = rcol->rescol.num_rows;

	y = b_row * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

	y1 = (y >= 0) ? y : 0;
	y2 = e_row * rcol->rescol.cell_height - rcol->rescol.global_v_shift;
	y3 = (y2 <= rcol->rescol.viewHeight) ? y2 : rcol->rescol.viewHeight;

	XClearArea(dpy, XtWindow(w), rcol->rescol.viewX, y1, rcol->rescol.viewWidth, y3 - y1, FALSE);

	RCDrawRows(w, b_row, e_row, direction);
/*	for(j = b_row; j < e_row; j++)
	{
		RCDrawRow(w, j);
	}
*/
	return ;
}

void RCRedrawColRegion(Widget w, int xc, int wc)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i, j;
	int y;
    XmNlRCL_Property_Row * rw;
	VisibleItem El;

#ifdef DEBUG
	printf("RCRedrawWindow  cols = %d rows = %d top = %d bot = %d\n", rcol->rescol.num_cols, rcol->rescol.num_rows, rcol->rescol.TopLine, rcol->rescol.BotomLine);
#endif
	if (!rcol->rescol.ItemData) return ;

    rw = rcol->rescol.prop_data;


	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
//		if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
//			|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)
		if (rw[COL_MAPPED(i)].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
			|| rw[COL_MAPPED(i)].x-rcol->rescol.global_h_shift + rw[COL_MAPPED(i)].current_width < rcol->rescol.viewX)
						continue ;

		y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

		El.x = rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
		El.width = rw[COL_MAPPED(i)].current_width;
//		El.x = rw[i].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//		El.width = rw[i].current_width;
		El.height = rcol->rescol.cell_height;

		if (El.x < xc + wc && El.x + El.width > xc)
		{
			for (j = rcol->rescol.TopLine; j < rcol->rescol.BotomLine; j++)
			{
				El.y = y + rcol->rescol.viewY;
				El.num = j*rcol->rescol.num_cols + i;
#ifdef DEBUG
				printf("RCRedrawWindow  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif
				if (j < rcol->rescol.num_rows)
					El.element=*(rcol->rescol.ItemData + j) + COL_MAPPED(i);
//					El.element=*(rcol->rescol.ItemData + j) + i;
				else
					El.element = NULL;

						RCRedrawElement(w, &El, True);
	//	       			_XmProcessUnlock();

				y = y + rcol->rescol.cell_height;
			}
		}
	}
	return ;
}


void RCRedrawWindow( Widget w, XEvent * event, Region region )
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col, row;
	int y, c;
    XmNlRCL_Property_Row * rw;
	VisibleItem El;

#ifdef DEBUG
	printf("RCRedrawWindow  cols = %d rows = %d top = %d bot = %d\n", rcol->rescol.num_cols, rcol->rescol.num_rows, rcol->rescol.TopLine, rcol->rescol.BotomLine);
#endif
	if (!rcol->rescol.ItemData) return ;

    rw = rcol->rescol.prop_data;

	El.height = rcol->rescol.cell_height;

	if (region)
	{
		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
/*			if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
				|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)*/
//			if (!rw[col].col_displayed)
			if (!rw[COL_MAPPED(col)].col_displayed)
				continue ;

			y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

			El.x = rw[COL_MAPPED(col)].x-rcol->rescol.global_h_shift + rcol->rescol.viewX;
			El.width = rw[COL_MAPPED(col)].current_width;
//			El.x = rw[col].x-rcol->rescol.global_h_shift + rcol->rescol.viewX;
//			El.width = rw[col].current_width;

//			if (rw[col].redraw_need)
			if (rw[COL_MAPPED(col)].redraw_need)
			{
				for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
				{
					El.y = y + rcol->rescol.viewY;
					El.num = row * rcol->rescol.num_cols + col;
					El.row = row;
#ifdef DEBUG
					printf("RCRedrawWindow1  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif
					if (row < rcol->rescol.num_rows)
						El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//						El.element = *(rcol->rescol.ItemData + row) + col;
					else
						El.element = NULL;

//	       			_XmProcessLock();
					RCRedrawElement(w, &El, True);
//	       			_XmProcessUnlock();
					y = y + rcol->rescol.cell_height;
				}
				rw[COL_MAPPED(col)].redraw_need = FALSE;
//				rw[col].redraw_need = FALSE;
				continue ;
			}
			for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
			{
				El.y = y + rcol->rescol.viewY;
#ifdef DEBUG
				printf("RCRedrawWindow  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif


//				c = XRectInRegion (region, El.x, El.y,
//								El.width, El.height);
//printf("++++++++++++++++++++++++++++++++Region not NULL %d\n", c);
				if (XRectInRegion(region, El.x, El.y, El.width, El.height))
				{
//					printf("Redraw region %d %d\n", col, row);
					El.num = row * rcol->rescol.num_cols + col;
					El.row = row;
					if (row < rcol->rescol.num_rows)
						El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//						El.element = *(rcol->rescol.ItemData + row) + col;
					else
						El.element = NULL;
// 	      			_XmProcessLock();
					RCRedrawElement(w, &El, True);
//	      			_XmProcessUnlock();
				}
				y = y + rcol->rescol.cell_height;
			}
		}
	}
	else
	{
		if (event)
		{
			for (col = 0; col < rcol->rescol.num_cols; col++)
			{
/*				if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
					|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)*/
//				if (!rw[col].col_displayed)
				if (!rw[COL_MAPPED(col)].col_displayed)
					continue ;
					
				y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

				El.x = rw[COL_MAPPED(col)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				El.width = rw[COL_MAPPED(col)].current_width;
//				El.x = rw[col].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//				El.width = rw[col].current_width;

//				if (rw[col].redraw_need)
				if (rw[COL_MAPPED(col)].redraw_need)
				{
					for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
					{
						El.y = y + rcol->rescol.viewY;
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
#ifdef DEBUG
						printf("RCRedrawWindow2  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;

	//	       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
	//	       			_XmProcessUnlock();
						y = y + rcol->rescol.cell_height;
					}
					rw[COL_MAPPED(col)].redraw_need = FALSE;
//					rw[col].redraw_need = FALSE;
					continue ;
				}
				for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
				{
					El.y = y + rcol->rescol.viewY;
#ifdef DEBUG
					printf("RCRedrawWindow  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif

					if (El.x < event->xexpose.x + event->xexpose.width &&
						El.x + El.width > event->xexpose.x &&
						El.y < event->xexpose.y + event->xexpose.height &&
						El.y + El.height > event->xexpose.y)
					{
//					printf("Redraw xexpose %d %d\n", col, row);
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;
//		       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
//		       			_XmProcessUnlock();

					}
					y = y + rcol->rescol.cell_height;
				}
			}
		}
		else
		{
			for (col = 0; col < rcol->rescol.num_cols; col++)
			{
/*				if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
					|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)*/
//				if (!rw[col].col_displayed)
				if (!rw[COL_MAPPED(col)].col_displayed)
					continue ;

				y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

				El.x = rw[COL_MAPPED(col)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				El.width = rw[COL_MAPPED(col)].current_width;

//				El.x = rw[col].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//				El.width = rw[col].current_width;
//				if (rw[col].redraw_need)
				if (rw[COL_MAPPED(col)].redraw_need)
				{
					for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
					{
						El.y = y + rcol->rescol.viewY;
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
#ifdef DEBUG
						printf("RCRedrawWindow3  el.x = %d el.y = %d el.w = %d el.h = %d\n", El.x, El.y, El.width, El.height);
#endif
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;

//		       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
//		       			_XmProcessUnlock();
						y = y + rcol->rescol.cell_height;
					}
					rw[COL_MAPPED(col)].redraw_need = FALSE;
//					rw[col].redraw_need = FALSE;
				}
			}
		}
	}


#ifdef DEBUG
	printf("RedrawWindow=OK\n");
#endif
	return ;
}


void RCRedrawWindowRtoL( Widget w, XEvent * event, Region region )
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col, row;
	int y, x1;
    XmNlRCL_Property_Row * rw;
	VisibleItem El;

#ifdef DEBUG
	printf("RCRedrawWindowRtoL  cols = %d rows = %d top = %d bot = %d\n", rcol->rescol.num_cols, rcol->rescol.num_rows, rcol->rescol.TopLine, rcol->rescol.BotomLine);
#endif
	if (!rcol->rescol.ItemData) return ;

    rw = rcol->rescol.prop_data;

	El.height = rcol->rescol.cell_height;

	if (region)
	{
		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
//			if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
//				|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)
//							continue ;

#ifdef DEBUG
//			if (rw[col].col_displayed)
			if (rw[COL_MAPPED(col)].col_displayed)
				printf("Col r %d displayed\n", col);
			else
				printf("Col r %d not displayed\n", col);
#endif

//			if (!rw[col].col_displayed)
			if (!rw[COL_MAPPED(col)].col_displayed)
				continue;
				
			El.x = rw[COL_MAPPED(col)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
			x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[COL_MAPPED(col)].current_width;

//			El.x = rw[col].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//			x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[col].current_width;
/*			if (x1 > rcol->rescol.viewX + rcol->rescol.viewWidth
				|| x1 + rw[i].current_width < rcol->rescol.viewX)
							continue ;
*/
			y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

//			El.width = rw[col].current_width;
			El.width = rw[COL_MAPPED(col)].current_width;


//			if (rw[col].redraw_need)
			if (rw[COL_MAPPED(col)].redraw_need)
			{
				rw[col].redraw_need = FALSE;
				for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
				{
					El.y = y + rcol->rescol.viewY;
					El.num = row * rcol->rescol.num_cols + col;
					El.row = row;
#ifdef DEBUG
					printf("RCRedrawWindowRtoL  col = %d el.x = %d x1 = %d el.y = %d el.w = %d el.h = %d\n", col, El.x, x1, El.y, El.width, El.height);
#endif
					if (row < rcol->rescol.num_rows)
						El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//						El.element = *(rcol->rescol.ItemData + row) + col;
					else
						El.element = NULL;

//	       			_XmProcessLock();
					RCRedrawElement(w, &El, True);
//	       			_XmProcessUnlock();
					y = y + rcol->rescol.cell_height;
				}
				continue ;
			}
			for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
			{
				El.y = y + rcol->rescol.viewY;
#ifdef DEBUG
					printf("RCRedrawWindowRtoL  col = %d el.x = %d x1 = %d el.y = %d el.w = %d el.h = %d\n", col, El.x, x1, El.y, El.width, El.height);
#endif


//				c = XRectInRegion (region, El.x, El.y,
//								El.width, El.height);
				if (XRectInRegion(region, x1, El.y, El.width, El.height))
				{
					El.num = row * rcol->rescol.num_cols + col;
					El.row = row;
					if (row < rcol->rescol.num_rows)
						El.element=*(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//						El.element=*(rcol->rescol.ItemData + row) + col;
					else
						El.element = NULL;
// 	      			_XmProcessLock();
					RCRedrawElement(w, &El, True);
//	      			_XmProcessUnlock();
				}
				y = y + rcol->rescol.cell_height;
			}
		}
	}
	else
	{
		if (event)
		{
			for (col = 0; col < rcol->rescol.num_cols; col++)
			{
//				if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
//					|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)
//

#ifdef DEBUG
//			if (rw[col].col_displayed)
			if (rw[COL_MAPPED(col)].col_displayed)
				printf("Col e %d displayed\n", col);
			else
				printf("Col e %d not displayed\n", col);
#endif

//				if (!rw[col].col_displayed) 
				if (!rw[COL_MAPPED(col)].col_displayed) 
					continue ;

				El.x = rw[COL_MAPPED(col)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[COL_MAPPED(col)].current_width;

//				El.x = rw[col].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//				x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[col].current_width;
/*				if (x1 > rcol->rescol.viewX + rcol->rescol.viewWidth
					|| x1 + rw[i].current_width < rcol->rescol.viewX)
								continue ;
*/
				y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

				El.width = rw[COL_MAPPED(col)].current_width;
//				El.width = rw[col].current_width;


//				if (rw[col].redraw_need)
				if (rw[COL_MAPPED(col)].redraw_need)
				{
					rw[COL_MAPPED(col)].redraw_need = FALSE;
//					rw[col].redraw_need = FALSE;
					for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
					{
						El.y = y + rcol->rescol.viewY;
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
#ifdef DEBUG
					printf("RCRedrawWindowRtoL  col = %d el.x = %d x1 = %d el.y = %d el.w = %d el.h = %d\n", col, El.x, x1, El.y, El.width, El.height);
#endif
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;

	//	       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
	//	       			_XmProcessUnlock();
						y = y + rcol->rescol.cell_height;
					}
					continue ;
				}
				for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
				{
					El.y = y + rcol->rescol.viewY;
#ifdef DEBUG
					printf("RCRedrawWindowRtoL  col = %d el.x = %d x1 = %d el.y = %d el.w = %d el.h = %d\n", row, El.x, x1, El.y, El.width, El.height);
#endif

					if (x1 < event->xexpose.x + event->xexpose.width &&
						x1 + El.width > event->xexpose.x &&
						El.y < event->xexpose.y + event->xexpose.height &&
						El.y + El.height > event->xexpose.y)
					{
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;
//		       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
//		       			_XmProcessUnlock();

					}
					y = y + rcol->rescol.cell_height;
				}
			}
		}
		else
		{
			for (col = 0; col < rcol->rescol.num_cols; col++)
			{
//				if (rw[i].x-rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
//					|| rw[i].x-rcol->rescol.global_h_shift + rw[i].current_width < rcol->rescol.viewX)
//								continue ;

#ifdef DEBUG
//			if (rw[col].col_displayed)
			if (rw[COL_MAPPED(col)].col_displayed)
				printf("Col %d displayed\n", col);
			else
				printf("Col %d not displayed\n", col);
#endif

//				if (!rw[col].col_displayed)
				if (!rw[COL_MAPPED(col)].col_displayed)
					continue ;
					
				El.x = rw[COL_MAPPED(col)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[COL_MAPPED(col)].current_width;

//				El.x = rw[col].x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
//				x1 = rcol->rescol.viewWidth - El.x + rcol->rescol.margin_w - rw[col].current_width;
/*				if (x1 > rcol->rescol.viewX + rcol->rescol.viewWidth
					|| x1 + rw[i].current_width < rcol->rescol.viewX)
								continue ;
*/
				y = rcol->rescol.TopLine * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

//				El.width = rw[col].current_width;
				El.width = rw[COL_MAPPED(col)].current_width;

//				if (rw[col].redraw_need)
				if (rw[COL_MAPPED(col)].redraw_need)
				{
					rw[col].redraw_need = FALSE;
					for (row = rcol->rescol.TopLine; row < rcol->rescol.BotomLine; row++)
					{
						El.y = y + rcol->rescol.viewY;
						El.num = row * rcol->rescol.num_cols + col;
						El.row = row;
#ifdef DEBUG
					printf("RCRedrawWindowRtoL  col = %d el.x = %d x1 = %d el.y = %d el.w = %d el.h = %d\n", col, El.x, x1, El.y, El.width, El.height);
#endif
						if (row < rcol->rescol.num_rows)
							El.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
//							El.element = *(rcol->rescol.ItemData + row) + col;
						else
							El.element = NULL;

//		       			_XmProcessLock();
						RCRedrawElement(w, &El, True);
//		       			_XmProcessUnlock();
						y = y + rcol->rescol.cell_height;
					}
				}
			}
		}
	}


#ifdef DEBUG
	printf("RedrawWindowRtoL=OK\n");
#endif
	return ;
}


void MakeResizeCallbackStruct(XmNlResColListWidget rcol, ListResizeReturnStruct *ret);


/* Проверяем изменения вертикальной геометрии */
/* Return values                              */
/* true - need recreate array */
/* false -  no need recreate array */

static Boolean
check_v_geom(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    VisibleItem * El;
    int num, row, startel;

    rw=rcol->rescol.prop_data;
#ifdef DEBUG
	printf("Check vertical geometry start \n");
#endif
	if (!rcol->rescol.ItemData) return False;

#ifdef DEBUG
	printf("Check vertical geometry ... \n");
#endif
//	if (rcol->rescol.VisibleCount == 0 && rcol->rescol.num_items > 0) return True;
//	if (rcol->rescol.num_items == 0) return False;

	num = (rcol->rescol.viewHeight/rcol->rescol.cell_height + 2);

	row = rcol->rescol.global_v_shift/rcol->rescol.cell_height;

//	startel = row*rcol->rescol.num_cols;

//	El=rcol->rescol.VisibleElement;

	if (rcol->rescol.TopLine == row && rcol->rescol.BotomLine == row + num ) return False;

	else
	{
		rcol->rescol.TopLine = row;
		rcol->rescol.BotomLine = row + num;
		return True;
	}
}

/* Проверяем изменения вертикального сдвига */
/* Check change of vertical shift           */
/* Return values                            */
/* true - vertical shift changed            */
/* false -  vertical shift not changed      */

static Boolean
check_v_shift(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    VisibleItem * El;
    int newshift = rcol->rescol.global_v_shift;

#ifdef DEBUG
	printf("Check vertical shift start \n");
#endif
	if (!rcol->rescol.ItemData) return False;

    if ((rcol->rescol.global_v_shift + rcol->rescol.viewHeight) > rcol->rescol.full_height)
		newshift = rcol->rescol.full_height - rcol->rescol.viewHeight;

	if (newshift < 0) newshift = 0;

	if (newshift != rcol->rescol.global_v_shift)
	{
		rcol->rescol.global_v_shift = newshift;
#ifdef DEBUG
		printf("Check vertical shift end \n");
#endif
		return True;
	}
	else return False;
}


/* Проверяем изменения горизонтального сдвига */
/* Check change of horizontal shift           */
/* Return values                              */
/* true - horizontal shift changed            */
/* false -  horizontal shift not changed      */

static Boolean
check_h_shift(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    VisibleItem * El;
    int newshift = rcol->rescol.global_h_shift;

#ifdef DEBUG
	printf("Check horizontal shift start \n");
#endif
	if (!rcol->rescol.ItemData) return False;

    if ((rcol->rescol.global_h_shift + rcol->rescol.viewWidth) > rcol->rescol.full_width)
		newshift = rcol->rescol.full_width - rcol->rescol.viewWidth;

	if (newshift < 0) newshift = 0;

	if (newshift != rcol->rescol.global_h_shift)
	{
		rcol->rescol.global_h_shift = newshift;
#ifdef DEBUG
		printf("Check horizontal shift end \n");
#endif
		return True;
	}
	else return False;
}

static Boolean
check_h_geom_tree_only(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    int newshift, autores, real_w, cur_w, delta, i;
    Boolean shift_changed, col_changed;
	rw=rcol->rescol.prop_data;

    if (rw->current_width != rcol->rescol.viewWidth)
    {
		rw->current_width = rw->real_width;
		if (rw->current_width < rcol->rescol.viewWidth) rw->current_width = rcol->rescol.viewWidth;
		rcol->rescol.full_width = rw->current_width;
		return True;
	}
	else return False;
}

/* Проверяем изменения горизонтальной геометрии */
/* Return values                              */
/* -1 - horizontal shift changed */
/* 0 -  columns sizes not changed and shift not changed */
/* 1 - autores column changed */

static int
check_h_geom(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    VisibleItem * El;
    int newshift, autores, real_w, cur_w, delta, i;
    Boolean shift_changed, col_changed;

#ifdef DEBUG
	printf("Start check horizontal fw = %d vw =%d\n",rcol->rescol.full_width,  rcol->rescol.viewWidth);
#endif
	if (!rcol->rescol.ItemData) return 0;

	rw = rcol->rescol.prop_data;
	autores = rcol->rescol.autoresize_col;
	if (rcol->rescol.TreeMode) autores = 0;
/*	if (rcol->rescol.TreeMode && rcol->rescol.num_cols == 1)
	{
		col_changed = check_h_geom_tree_only(w);
		shift_changed = check_h_shift(w);
		if (shift_changed) return -1;
		else
		{
			if (col_changed) return 1;
			else return 0;
		}
	}*/
	real_w = rw[COL_MAPPED(autores)].real_width;
	cur_w = rw[COL_MAPPED(autores)].current_width;
//	real_w = rw[autores].real_width;
//	cur_w = rw[autores].current_width;

	if (rcol->rescol.full_width != rcol->rescol.viewWidth)
	{
#ifdef DEBUG
		printf("view=%d width=%d cw=%d rw=%d\n",rcol->rescol.viewWidth, rcol->rescol.full_width, cur_w, real_w);
#endif
		cur_w = cur_w + (rcol->rescol.viewWidth - rcol->rescol.full_width);
		if (cur_w < real_w) cur_w = real_w;
//		if (cur_w != rw[autores].current_width)
		if (cur_w != rw[COL_MAPPED(autores)].current_width)
		{
//			delta = rw[autores].current_width - cur_w;
			delta = rw[COL_MAPPED(autores)].current_width - cur_w;
#ifdef DEBUG
			printf("delta=%d\n", delta);
#endif
			rcol->rescol.full_width = rcol->rescol.full_width - delta;
//			rw[autores].current_width = cur_w;
			rw[COL_MAPPED(autores)].current_width = cur_w;
			shift_changed = check_h_shift(w);

			delta = 0;

			for (i = 0; i < rcol->rescol.num_cols; i++)
			{
				if (i >= autores)
					rw[COL_MAPPED(i)].redraw_need = True;
				rw[COL_MAPPED(i)].x=delta;
				delta=delta+rw[COL_MAPPED(i)].current_width;

				rw[COL_MAPPED(i)].col_displayed = False;
				if (rw[COL_MAPPED(i)].x < rcol->rescol.viewX+rcol->rescol.viewWidth &&
					rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width > rcol->rescol.viewX)
				{
					rw[COL_MAPPED(i)].col_displayed = True;
					if (rw[COL_MAPPED(i)].x + rcol->rescol.margin_w > rcol->rescol.viewX) 
						rw[COL_MAPPED(i)].clip.x = rw[COL_MAPPED(i)].x;
					else rw[COL_MAPPED(i)].clip.x = rcol->rescol.viewX;
						rw[COL_MAPPED(i)].clip.y = rcol->rescol.viewY;
					if ((rw[COL_MAPPED(i)].clip.x+rw[COL_MAPPED(i)].current_width) < (rcol->rescol.viewX+rcol->rescol.viewWidth))
						rw[COL_MAPPED(i)].clip.width = rw[COL_MAPPED(i)].current_width;
					else rw[COL_MAPPED(i)].clip.width = rcol->rescol.viewX + rcol->rescol.viewWidth - rw[COL_MAPPED(i)].clip.x;
					if (rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width < rw[COL_MAPPED(i)].clip.x + rw[COL_MAPPED(i)].clip.width)
						rw[COL_MAPPED(i)].clip.width = rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width - rw[COL_MAPPED(i)].clip.x - rcol->rescol.margin_w;
					rw[COL_MAPPED(i)].clip.height = rcol->rescol.viewHeight;
				}
			}
			if (shift_changed) return -1;
			else return 1;

		}
		else
		{
			shift_changed = check_h_shift(w);
			if (shift_changed) return -1;
			else return 0;
		}
	}

	else return 0;

}


static void
ResizeEmpty(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Boolean recalc=False;
    int v_resize, h_resize, i, delta;
    Boolean recreatemassiv, v_shift_changed, h_shift_changed;
    Boolean RedrawNeed = False;


    if (!XtIsRealized(w))
		return;

	rw = rcol->rescol.prop_data;

#ifdef DEBUG
	printf("\nXmNlResColList ResizeEmpty\n");
	fflush(stdout);
#endif

	if (!rcol->rescol.resizeCallback || rcol->rescol.num_cols == 0)
		return ;


	ResizeDoCallback(w, XmNlEmpty, XmNlSizeChange);

	delta = 0;
	h_resize = 0;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (rw[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[COL_MAPPED(i)])
			h_resize = 1;
		rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
		rw[COL_MAPPED(i)].x = delta;
#ifdef DEBUG
		printf("Empty x%d = %d w = %d\n", i, rw[COL_MAPPED(i)].x, rw[COL_MAPPED(i)].current_width);
#endif
		delta = delta + rw[COL_MAPPED(i)].current_width;
	}

	if (rcol->rescol.global_h_shift != rcol->rescol.new_global_h_shift)
	{
		rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
//		ResizeSliders(w, VerticalScroll);
//		if (rcol->rescol.title_bar != NULL)
//			RefreshTitleBar(rcol);
	}
		ResizeSliders(w, AllScroll);

	return ;
}

/*	Function Name: Resize
 *	Description:   Called when this widget has been resized.
 *	Arguments:     w - RC List Widget to realize.
 *	Returns:       none.
 */

static void
Resize(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    XRectangle * Rect;
    Boolean recalc = False;
    int v_resize, h_resize, i, delta;
    Boolean recreatemassiv, v_shift_changed, h_shift_changed;
    Boolean RedrawNeed = False;

#ifdef DEBUG
 	printf("\n++++++++++++++++ RClist start Resize\n");
	printf("\n RescolList resize w %d h %d\n", rcol->core.width, rcol->core.height);
	fflush(stdout);
#endif
   if (!XtIsRealized(w))
		return;

#ifdef DEBUG
	printf("\n++++++++++++++++ RClist start Resize col = %d\n", rcol->rescol.num_cols);
	fflush(stdout);
#endif
	rw = rcol->rescol.prop_data;

	rcol->rescol.lastViewWidth = rcol->rescol.viewWidth;
	rcol->rescol.lastViewHeight = rcol->rescol.viewHeight;

	ResizeStuff(rcol);

	if (rcol->rescol.num_rows == 0)
	{
		if (rcol->rescol.lastViewWidth != rcol->rescol.viewWidth) 
			ResizeEmpty(w);
		return ;
	}
	Rect = rcol->rescol.DrawRect;
	v_shift_changed = check_v_shift(w);

	recreatemassiv = check_v_geom(w);


#ifdef DEBUG
	if (recreatemassiv)
		printf("\t\tResize: vert geom changed\n");
	if (v_shift_changed)
		printf("\t\tResize: vert shift changed\n");
#endif

//	rcol->rescol.global_h_shift = 0;
//	rcol->rescol.full_width = rcol->rescol.viewWidth;

	if (rcol->rescol.resizeCallback)
	{
		if ((rcol->rescol.lastViewWidth != rcol->rescol.viewWidth) && rcol->rescol.num_cols) 
		{
			ResizeDoCallback(w, XmNlItemsFound, XmNlSizeChange);

//		h_shift_changed = check_h_shift(w);

//		if (h_shift_changed)
//			printf("\t\tResize: horiz shift changed\n");

			delta = 0;
			h_resize = 0;

			if (rcol->rescol.global_h_shift != rcol->rescol.new_global_h_shift)
			{
				rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
				h_resize = -1;
			}
			for (i=0; i<rcol->rescol.num_cols; i++)
			{
	//			if(rw[i].current_width==0) rw[i].current_width=rw[i].real_width;
	//			tmp_w=tmp_w+rw[i].current_width;
				rw[COL_MAPPED(i)].x = delta;
				if (rw[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
				{
					if (h_resize != -1)
					{
						h_resize = 1;
					}
				}
				rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
				delta = delta + rw[COL_MAPPED(i)].current_width;
				if (h_resize == 1)
					rw[COL_MAPPED(i)].redraw_need = True;
			}
		}
	}
	else 
	{
		h_shift_changed = check_h_shift(w);
		h_resize = check_h_geom(w);
	}

#ifdef DEBUG

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("\t Col %d width %d\n", i, rw[COL_MAPPED(i)].current_width);
	}
	printf("\n");

	if (h_resize < 0)
		printf("Resize: all columns shifted \n");
	if (h_resize == 0)
		printf("Resize: all columns not resized and not shifted\n");
	if (h_resize > 0)
		printf("Resize: autores column resized and columns after autores column shifted\n");
#endif

//	if ((rcol->rescol.VisibleElement || rcol->rescol.VisibleCount) && recreatemassiv) FreeVisibleElement(w);
//	if (recreatemassiv) CreateVisibleElementMassiv(w);

/*	if (!recreatemassiv)
	{
		if (rcol->rescol.VisibleElement)
		{
			if (h_resize != 0 || v_shift_changed) RecalcVisibleElementMassiv(w);
		}
	}
*/
//	if (h_shift_changed || v_shift_changed) ResizeSliders(w);
	ResizeSliders(w, AllScroll);

/*	if (rcol->rescol.viewWidth < rcol->rescol.lastViewWidth)
	{
		if (recreatemassiv || v_shift_changed || h_resize != 0) RCRedrawAllWindow(w);
	}

	if (rcol->rescol.viewWidth >= rcol->rescol.lastViewWidth)
	{
		if (recreatemassiv || v_shift_changed || h_resize != 0) RCRedrawAllWindow(w);
	}
*/

	CalcColParam(w);
	RCSetCacheBufLimit(w);


//	if (recreatemassiv || v_shift_changed || h_resize != 0) RedrawNeed = True;
	if (v_shift_changed || h_resize == -1) RedrawNeed = True;

	if (RedrawNeed && (rcol->rescol.viewWidth > rcol->rescol.lastViewWidth ||
		rcol->rescol.viewHeight > rcol->rescol.lastViewHeight))
		{
			rcol->rescol.AllRedraw = True;
		}

	if (RedrawNeed && rcol->rescol.viewWidth <= rcol->rescol.lastViewWidth &&
		rcol->rescol.viewHeight <= rcol->rescol.lastViewHeight)
	{
		RCRedrawAllWindow(w);
		CurrentFrameDraw(w);
	}

	if (h_resize == 1 && rcol->rescol.viewWidth <= rcol->rescol.lastViewWidth &&
		rcol->rescol.viewHeight <= rcol->rescol.lastViewHeight)
	{
		if (rcol->rescol.render_order == LtoR_render)
			RCRedrawWindow(w, NULL, NULL);
		else
			RCRedrawWindowRtoL(w, NULL, NULL);
		CurrentFrameDraw(w);
	}
/*	if (rcol->rescol.viewWidth < rcol->rescol.lastViewWidth)
	{
		if (recreatemassiv || v_shift_changed || h_resize != 0)
		{
			RCRedrawAllWindow(w);
			rcol->rescol.NoRedisplay = True;
		}
	}

	if (rcol->rescol.viewWidth >= rcol->rescol.lastViewWidth)
	{
		if (recreatemassiv || v_shift_changed || h_resize != 0)
		{
			RCRedrawAllWindow(w);
			rcol->rescol.NoRedisplay = True;
		}
	}
*/

	rcol->rescol.lastViewWidth = rcol->rescol.viewWidth;
	rcol->rescol.lastViewHeight = rcol->rescol.viewHeight;

	if (rw)
#ifdef DEBUG
	printf("+++Resize: rx=%d rw=%d lx=%d lw=%d fw=%d vw=%d\n",rw[COL_MAPPED(rcol->rescol.autoresize_col)].x,
			rw[COL_MAPPED(rcol->rescol.autoresize_col)].current_width, rw[COL_MAPPED(rcol->rescol.num_cols-1)].x,
			rw[COL_MAPPED(rcol->rescol.num_cols-1)].current_width, rcol->rescol.full_width, rcol->rescol.viewWidth);
#endif
/*	if (rcol->rescol.title_bar != NULL && h_resize != 0 && !rcol->rescol.resizeCallback)
	{
	RefreshTitleBar(rcol);
	}*/
//	printf("\t\t\t\t--------------Resize ok\n");
//	RCSetCacheBufLimit(w);
#ifdef DEBUG
	printf("\n RescolList resize ok w %d h %d\n", rcol->core.width, rcol->core.height);
	fflush(stdout);
#endif

	return ;
}




static void DeleteCell(XmNlResColListWidget , XmNlRCL_Cell *);


/*	Function Name: Destroy
 *	Description:   Cleans up after the widget.
 *	Arguments:     w - the widget.
 *	Returns:       none.
 */

static void
Destroy(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlListTreeItem *item, *sibling;
	XmNlRCL_Cell * cell;
    XmNlRCL_Property_Row * prw;
	int i;
	Display *dpy;

	dpy = XtDisplay(w);

	rcol->rescol.DestroyPhase = True;

	prw = rcol->rescol.prop_data;

	if (rcol->rescol.PublicPreciseColSize)
		free(rcol->rescol.PublicPreciseColSize);

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (prw[i].gc)
			XFreeGC(XtDisplay(w), prw[i].gc);
		prw[i].gc = NULL;
		
		if (prw[i].column_tag)
			XtFree(prw[i].column_tag);
		prw[i].column_tag = NULL;
		
#ifdef USE_XFT
		if (prw[i].xftdraw)
			XftDrawDestroy(prw[i].xftdraw);
		prw[i].xftdraw = NULL;
#endif
	}

    if (rcol->rescol.TreeMode)
 		RCTreeDeleteAllItems(w);
	else
		RCDeleteAllRows(w);

	FreePixmap(rcol, &rcol->rescol.Closed);
	FreePixmap(rcol, &rcol->rescol.Open);
	FreePixmap(rcol, &rcol->rescol.Leaf);
	FreePixmap(rcol, &rcol->rescol.LeafOpen);

	RCFreePixBufNew(w);

    XtFree((char*)rcol->rescol.prop_data);

    if (rcol->rescol.col_sharp_width) XtFree((char*)rcol->rescol.col_sharp_width);
    if (rcol->rescol.col_cur_width) XtFree((char*)rcol->rescol.col_cur_width);
    if (rcol->rescol.col_new_width) XtFree((char*)rcol->rescol.col_new_width);


	if (PIX_FOUND(rcol->rescol.Ipix)) 
		XFreePixmap(dpy, rcol->rescol.Ipix);
	if (PIX_FOUND(rcol->rescol.SelIpix)) 
		XFreePixmap(dpy, rcol->rescol.SelIpix);

	if (PIX_FOUND(rcol->rescol.Lpix)) 
		XFreePixmap(dpy, rcol->rescol.Lpix);
	if (PIX_FOUND(rcol->rescol.SelLpix)) 
		XFreePixmap(dpy, rcol->rescol.SelLpix);

	if (PIX_FOUND(rcol->rescol.Epix)) 
		XFreePixmap(dpy, rcol->rescol.Epix);
	if (PIX_FOUND(rcol->rescol.SelEpix)) 
		XFreePixmap(dpy, rcol->rescol.SelEpix);


	if (rcol->rescol.selected_rows != NULL) 
		XtFree((char *)rcol->rescol.selected_rows);
	rcol->rescol.selected_rows = NULL;

	if (rcol->rescol.selectedPositions)
		XtFree ((char *)rcol->rescol.selectedPositions);
	rcol->rescol.selectedPositionsCount = 0;

	if (rcol->rescol.cur_sel_massiv) 
		XtFree((char *) rcol->rescol.cur_sel_massiv);

	rcol->rescol.num_cols = 0;
	rcol->rescol.num_rows = 0;
	rcol->rescol.num_items = 0;
 
    if (rcol->rescol.font_list)
		XmFontListFree(rcol->rescol.font_list);

	if (rcol->rescol.col_map)
		XtFree((char *) rcol->rescol.col_map);
		
	DestroyGC(rcol);

    return ;
}

static int
GetCtrlHeight(XmNlResColListWidget rcol)
{
	/*** !!!!! This is tmp hack !!!!!! ***/

	return rcol->rescol.ControlExpanded.height;
}




static XmNlRCL_Cell * RCgetCell(Widget w, int row, int col)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * cell;

	if (col > rcol->rescol.num_cols || row > rcol->rescol.num_rows) return NULL;
	cell = *(rcol->rescol.ItemData + row);
	cell = cell + COL_MAPPED(col);
	return cell;

}

/************************************/
/** Free all PixBuf in widget *******/
/************************************/

static void RCFreePixBufNew(Widget w)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prw;
	CacheBufElement * ptr1, * ptr2, * ptr3;
	int index, limit, col;
	XmNlRCL_Cell * cell;


	prw = rcol->rescol.prop_data;

	for (col = 0; col < rcol->rescol.num_cols; col++)
	{
		if (prw[col].FirstBuf || prw[col].FirstFreeBuf)
		{
			CleanPixBufNew(w, &(prw[col].FirstBuf), &(prw[col].LastBuf), &(prw[col].FirstFreeBuf), 
							&(prw[col].UsedBufNum), &(prw[col].FreeBufNum));
		}
	}

	return ;
}

static void RCFreeCacheNode(XmNlResColListWidget rcol, XmNlRCL_Cell * cell, int col)
{
	XmNlRCL_Property_Row * pr = rcol->rescol.prop_data;

	pr = pr + col;

	CacheNodeToFreeList((CacheBufElement *) cell->buf, &(pr->FirstBuf), &(pr->LastBuf), &(pr->FirstFreeBuf), 
					&(pr->UsedBufNum), &(pr->FreeBufNum));
					
	return ;
}

/***************************************************************/
/*
static CacheBufElement * RCGetPixBuf(Widget w, XmNlRCL_Cell * cell, XmNlRCL_Property_Row * pr, int row, int col)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	CacheBufElement * ptr1, * ptr2, * ptr3;
	int index, limit;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=rcol->primitive.foreground;
	else
			sel_bg_color=rcol->rescol.select_background_pixel;




	pr->CacheBufIndex = PreparePixBuf(w, pr->CacheBufIndex, &(pr->CacheBufNum), rcol->rescol.CacheBufLimit);
	if (!pr->CacheBufIndex) return NULL;

	if (pr->CacheBufIndex->cell)
	{
		pr->CacheBufIndex->cell = NULL;
		if (PIX_FOUND(pr->CacheBufIndex->id))
		{
			if (pr->CacheBufIndex->ht < cell->label_h || pr->CacheBufIndex->wd < cell->label_w)
			{
				XFreePixmap(XtDisplay(w), pr->CacheBufIndex->id);
				pr->CacheBufIndex->id = XmUNSPECIFIED_PIXMAP;
				pr->CacheBufIndex->wd = 0;
				pr->CacheBufIndex->ht = 0;
			}
		}
	}

	if (!PIX_FOUND(pr->CacheBufIndex->id))
	{
		pr->CacheBufIndex->id = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
						cell->label_w, cell->label_h, rcol->core.depth);
		pr->CacheBufIndex->wd = cell->label_w;
		pr->CacheBufIndex->ht = cell->label_h;
	}




	if(rcol->rescol.selected_rows[row]==True)
	{
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
		XFillRectangle(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 0,0, pr->CacheBufIndex->wd, pr->CacheBufIndex->ht);

		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_fg_color);
		XSetBackground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
		XmStringDraw(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
								0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
	}
	else
	{
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, background_color);
		XFillRectangle(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 0, 0, pr->CacheBufIndex->wd, pr->CacheBufIndex->ht);
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
		XmStringDraw(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
							0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
	}

	pr->CacheBufIndex->cell = (void *) cell;
	return pr->CacheBufIndex;
}
*/

#ifdef DEBUG
static void CheckCacheChunk(XmNlRCL_Property_Row * pr)
{
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlRCL_Cell * cell, * cell2;
	printf ("---------------\n");
	ptr1 = pr->FirstBuf;
	ptr3 = pr->FirstFreeBuf;
	while (ptr1 || ptr3)
	{
		if (ptr1)
		{
			cell = ptr1->cell;
			printf("-- %s width %d\t", cell->text, ptr1->wd);
			ptr2 = ptr1;
			ptr1 = ptr1->next;
			if (ptr2 != pr->LastBuf)
				if (ptr1->prev != ptr2)
					printf("!!!!!!!! not valid pointer\n");
		}
		else 
			printf("\t\t\t\t");
		
		if (ptr3)
		{
			printf("FreeNode\n");
			ptr3 = ptr3->next;
		}
		else
			printf("\n");
	}
	if (pr->FirstBuf && pr->LastBuf)
	{ 
		cell = (XmNlRCL_Cell *) pr->FirstBuf->cell;
		cell2 = (XmNlRCL_Cell *) pr->LastBuf->cell;
		printf("First %s Last %s\n", cell->text, cell2->text);
	}
	else
		printf("First and Last not found\n");
}

#endif

/***************************************************************/
static CacheBufElement * RCGetPixBufNew(Widget w, XmNlRCL_Cell * cell, XmNlRCL_Property_Row * pr, int row, int col, int direction)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color, highlight_color;
	CacheBufElement * ptr1, * ptr2, * ptr3;
	XmNlRCL_Cell * prev_cell;
	int index, limit;

	background_color=rcol->rescol.background_pixel;
	foreground_color=rcol->rescol.foreground_pixel;
	sel_fg_color=rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
			sel_bg_color=rcol->primitive.foreground;
	else
			sel_bg_color=rcol->rescol.select_background_pixel;


	if (row > 0)
	{
		prev_cell = *(rcol->rescol.ItemData + row - 1) + col;
		ptr1 = (CacheBufElement *) prev_cell->buf;
	}
	else
		ptr1 = NULL;

	if (row < rcol->rescol.num_rows -1)
	{
		prev_cell = *(rcol->rescol.ItemData + row + 1) + col;
		ptr2 = (CacheBufElement *) prev_cell->buf;
	}
	else
		ptr2 = NULL;

//	if (col == 1 && row != 0 && row != rcol->rescol.num_rows -1)
//	{
//		printf("Current row %d Current Node %s\n Next node %s %p\n", row, cell->text, prev_cell->text, ptr2);
//		fflush(stdout);
//	}
		
	pr->CacheBufIndex = PreparePixBufNew(w, &pr->FirstBuf, &pr->LastBuf, &pr->FirstFreeBuf, ptr1, ptr2, &(pr->UsedBufNum), 
										&(pr->FreeBufNum), rcol->rescol.CacheBufLimit, direction);
										
	if (!pr->CacheBufIndex) return NULL;

//	if (pr->CacheBufIndex->cell)
//	{
//		printf("Element not empty\n");
//		pr->CacheBufIndex->cell = NULL;
		if (PIX_FOUND(pr->CacheBufIndex->id))
		{
			if (pr->CacheBufIndex->ht < cell->label_h || pr->CacheBufIndex->wd < cell->label_w)
			{
				XFreePixmap(XtDisplay(w), pr->CacheBufIndex->id);
//				printf("Free pixmap for resize %lx\n", pr->CacheBufIndex->id);
				pr->CacheBufIndex->id = XmUNSPECIFIED_PIXMAP;
				pr->CacheBufIndex->wd = 0;
				pr->CacheBufIndex->ht = 0;
			}
		}
//	}

	if (!PIX_FOUND(pr->CacheBufIndex->id))
	{
//		printf("Create pixmap\n");
		pr->CacheBufIndex->id = XCreatePixmap(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
						cell->label_w, cell->label_h, rcol->core.depth);
//		printf("create pixmap %lx\n", pr->CacheBufIndex->id);
		pr->CacheBufIndex->wd = cell->label_w;
		pr->CacheBufIndex->ht = cell->label_h;

#ifdef DEBUG
		if (col == 1)
			printf("+++ Created pixmap with width %d for row %d - %d name %s\n", cell->label_w, row, pr->CacheBufIndex->wd, cell->text);
#endif

	}


	if(rcol->rescol.selected_rows[row]==True)
	{
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
		XFillRectangle(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 0,0, pr->CacheBufIndex->wd, pr->CacheBufIndex->ht);

		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, sel_fg_color);
		XSetBackground(XtDisplay(w), rcol->rescol.pixGC, sel_bg_color);
#ifdef FAST_XMSTRING_RENDERING
		if (cell->complabel)
			DrawComplexString3(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 
								rcol->rescol.font_list, cell->complabel, 
#ifdef	USE_XFT
								NULL, 
#endif
								0, 0, rcol->rescol.idxRend, sel_fg_color, NULL);
#else
		XmStringDraw(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
								0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
	}
	else
	{
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, background_color);
		XFillRectangle(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 0, 0, pr->CacheBufIndex->wd, pr->CacheBufIndex->ht);
		XSetForeground(XtDisplay(w), rcol->rescol.pixGC, foreground_color);
#ifdef FAST_XMSTRING_RENDERING
		if (cell->complabel)
			DrawComplexString3(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.pixGC, 
								rcol->rescol.font_list, cell->complabel, 
#ifdef	USE_XFT
								NULL, 
#endif
								0, 0, rcol->rescol.idxRend, foreground_color, NULL);
#else
		XmStringDraw(XtDisplay(w), pr->CacheBufIndex->id, rcol->rescol.font_list, cell->xmlabel, rcol->rescol.pixGC,
							0, 0, cell->label_w, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
	}

	pr->CacheBufIndex->cell = (void *) cell;
	
#ifdef DEBUG
	if (col == 1)
		CheckCacheChunk(pr);
#endif

	return pr->CacheBufIndex;
}


void RCSetCacheBufLimit(Widget w)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	if (rcol->rescol.cell_height == 0) return ;

	rcol->rescol.CacheBufLimit = rcol->core.height / rcol->rescol.cell_height + 10;
//	rcol->rescol.CacheBufLimit = (rcol->core.height / rcol->rescol.cell_height + 1000) * rcol->rescol.num_cols;
//	if (rcol->rescol.CacheBufLimit > rcol->rescol.row_num) rcol->rescol.CacheBufLimit = rcol->rescol.row_num;
}


static void RebuildSelectedRows(XmNlResColListWidget rcol, Boolean rebuild_positions)
{
	int i, k = 0, last_count;
	XmNlRCL_Cell * cell;

	last_count = rcol->rescol.selectedPositionsCount;
	
	if (rebuild_positions)
		rcol->rescol.selectedPositionsCount = 0;
	
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = rcol->rescol.ItemData[i];
		if (cell->selected)
		{
			rcol->rescol.selected_rows[i] = True;
			if (rebuild_positions)
				rcol->rescol.selectedPositionsCount++;
		}
		else
		{
			rcol->rescol.selected_rows[i] = False;
		}
	}
	
	if (rebuild_positions)
	{
		if (rcol->rescol.selectedPositionsCount != last_count && rcol->rescol.selectedPositions)
		{
			XtFree((char *)rcol->rescol.selectedPositions);
			rcol->rescol.selectedPositions = NULL;
		}

		if (!rcol->rescol.selectedPositions)
			rcol->rescol.selectedPositions = (int *) XtMalloc(sizeof(int) * rcol->rescol.selectedPositionsCount);

		for (i = 0; i < rcol->rescol.num_rows; i++)
		{
			if (rcol->rescol.selected_rows[i])
			{	
				rcol->rescol.selectedPositions[k] = i;
				k++;
			}
		}
	}
}



static void RebuildSelectedPositionsOnly(XmNlResColListWidget rcol)
{
	int i, k = 0, last_count;
	XmNlRCL_Cell * cell;

	last_count = rcol->rescol.selectedPositionsCount;
	
	rcol->rescol.selectedPositionsCount = 0;
	
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = rcol->rescol.ItemData[i];
		if (cell->selected)
		{
			rcol->rescol.selectedPositionsCount++;
		}
	}

	if (rcol->rescol.selectedPositionsCount != last_count && rcol->rescol.selectedPositions)
	{
		XtFree((char *)rcol->rescol.selectedPositions);
		rcol->rescol.selectedPositions = NULL;
	}
	
	if (!rcol->rescol.selectedPositions)
		rcol->rescol.selectedPositions = (int *) XtMalloc(sizeof(int) * rcol->rescol.selectedPositionsCount);

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i])
		{	
			rcol->rescol.selectedPositions[k] = i;
			k++;
		}
	}
}


/***************************************************************/

int XmNlResColCleanAllColumns(Widget w)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop, * last_prop;
	XmNlRCL_Cell  * cell;
	Widget parent;
	int i;
	Boolean consistency = rcol->rescol.PropConsistency;

	if (rcol->rescol.num_cols != 0 && (rcol->rescol.ItemData || rcol->rescol.first))
	{
	    if (rcol->rescol.TreeMode)
		{
			XmNlRCTreeDeleteAllItems(w);
		}
		else
			XmNlResColDeleteAllRows(w);
	}

	RCFreePixBufNew(w);
	CleanPropertyRow(w);

	rcol->rescol.num_cols = 0;
	rcol->rescol.num_rows = 0;

	rcol->rescol.PublicColCount = 0;
	rcol->rescol.PublicRowCount = 0;
	
	if (rcol->rescol.selectedPositions)
	{
		XtFree((char *) rcol->rescol.selectedPositions);
		rcol->rescol.selectedPositions = NULL;
	}
	
	rcol->rescol.selectedPositionsCount = 0;

	if (rcol->rescol.col_sharp_width) 
	{
		XtFree((char*)rcol->rescol.col_sharp_width);
		rcol->rescol.col_sharp_width = NULL;
	}
	if (rcol->rescol.col_cur_width) 
	{
		XtFree((char*)rcol->rescol.col_cur_width);
		rcol->rescol.col_cur_width = NULL;
	}
	if (rcol->rescol.col_new_width) 
	{
		XtFree((char*)rcol->rescol.col_new_width);
		rcol->rescol.col_new_width = NULL;
	}

	if (ChekParentIsList(XtParent(w)))
		XmNlListCleanAllColumn(XtParent(w));
	
	return 1;
}

extern void XmNlListMoveColumnTo(Widget w, int col, int position);

void XmNlResColMoveColumnTo(Widget w, int col, int position)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	int num, i;
	Widget parent;
	
	if (col == position || col >= rcol->rescol.num_cols || position >= rcol->rescol.num_cols)
		return ;
	
	num = COL_MAPPED(col);
	
	if (col > position)
		memmove((void *)(rcol->rescol.col_map + position + 1), (void *)(rcol->rescol.col_map + position), sizeof(int) * (col - position));
	else
		memmove((void *)(rcol->rescol.col_map + col), (void *)(rcol->rescol.col_map + col + 1), sizeof(int) * (position - col));
		
	rcol->rescol.col_map[position] = num;

	parent = XtParent(w);
	if (ChekParentIsList(parent))
		XmNlListMoveColumnTo(parent, col, position);
	
	if (rcol->rescol.num_rows == 0)
		return ;
	
	CalcGeomPostInit(w);

	prow = rcol->rescol.prop_data;

	if (rcol->rescol.resizeCallback)
	{
		int delta = 0;
		ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
//				prow[i].x = delta;
//				delta = delta + prow[i].current_width;
			}
			prow[COL_MAPPED(i)].x = delta;
			delta = delta + prow[COL_MAPPED(i)].current_width;
			prow[COL_MAPPED(i)].redraw_need = True;
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}
	
	CalcColParam(w);
	
	RCRedrawAllWindow(w);
	return ;
}

int XmNlResColAppendColumn(Widget w, XmNlColSpecRec * csrec)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop, * last_prop;
	XmNlRCL_Cell  * cell;
	Widget parent;
	XGCValues gcv;
	Boolean consistency = rcol->rescol.PropConsistency;
	Boolean h_change, col_change, ActionStatus, RedrawNeed;	
	int i;

#ifdef DEBUG
	printf("\n XmNlResColAddColumn started cols = %d colspec = %p\n", rcol->rescol.num_cols, csrec);
//	_XmNlColSpecPrint(csrec);
#endif

	if (rcol->rescol.prop_data == NULL)
	{
#ifdef DEBUG
	printf("\n XmNlResColAddColumn: prop data not found\n");
#endif
		rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(1, sizeof(XmNlRCL_Property_Row));
		rcol->rescol.num_cols++;
		prop = rcol->rescol.prop_data;
		rcol->rescol.col_map = (int *) XtCalloc(1, sizeof(int));
		rcol->rescol.col_map[0] = 0;
#ifdef DEBUG
	printf("\n XmNlResColAddColumn: prop data allocated col = %d\n", rcol->rescol.num_cols);
#endif
	}
	else
	{
#ifdef DEBUG
	printf("\n XmNlResColAddColumn: prop data found\n");
#endif
		last_prop = rcol->rescol.prop_data;
		rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(rcol->rescol.num_cols + 1, sizeof (XmNlRCL_Property_Row));
		memcpy(rcol->rescol.prop_data, last_prop, sizeof (XmNlRCL_Property_Row) * rcol->rescol.num_cols);
		prop = rcol->rescol.prop_data + rcol->rescol.num_cols;
		rcol->rescol.num_cols++;
		XtFree((char *) last_prop);
		rcol->rescol.col_map = (int *) XtRealloc((char *) rcol->rescol.col_map, sizeof(int) * rcol->rescol.num_cols);
		rcol->rescol.col_map[rcol->rescol.num_cols - 1] = rcol->rescol.num_cols - 1;
#ifdef DEBUG
	printf("\n XmNlResColAddColumn: prop data reallocated, cols = %d \n", rcol->rescol.num_cols);
#endif
	}

/*
	if (rcol->rescol.num_cols !=0 && (rcol->rescol.ItemData || rcol->rescol.first))
	{
	    if (rcol->rescol.TreeMode)
		{
			XmNlRCTreeDeleteAllItems(w);
		}
		else
			XmNlResColDeleteAllRows(w);
	}

	RCFreePixBuf(w);

	if (rcol->rescol.prop_data != NULL)
	{
		prop = rcol->rescol.prop_data;
		for (i=0; i<rcol->rescol.num_cols; i++)
		{
			if (prop[i].gc)
				XFreeGC(XtDisplay(w), prop[i].gc);
			prop[i].gc = NULL;
		}
		XtFree((char*)rcol->rescol.prop_data);
		rcol->rescol.prop_data = NULL;
	}

	rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(col_count, sizeof (XmNlRCL_Property_Row));

	prop=rcol->rescol.prop_data;
	rcol->rescol.num_cols = col_count;
	rcol->rescol.num_rows = 0;

	rcol->rescol.PublicColCount = col_count;
	rcol->rescol.PublicRowCount = 0;*/

	if (rcol->rescol.col_sharp_width) XtFree((char*)rcol->rescol.col_sharp_width);
	if (rcol->rescol.col_cur_width) XtFree((char*)rcol->rescol.col_cur_width);
	if (rcol->rescol.col_new_width) XtFree((char*)rcol->rescol.col_new_width);

	rcol->rescol.col_sharp_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_cur_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_new_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));

	gcv.background = rcol->core.background_pixel;
	gcv.foreground = rcol->rescol.foreground_pixel;
	gcv.function = GXcopy;
//	gcv.font = rcol->rescol.font->fid;

	prop->info_type = csrec->typeCol;
	if (prop->info_type == XmPIXMAP_AND_STRING)
		prop->info_type = XmSTRING;
	prop->align_type = csrec->alignmentCol;
	prop->pix_buf = XmUNSPECIFIED_PIXMAP;
	prop->current_width = 0;
	prop->drawable_width = 0;
	prop->real_width = 0;
	prop->drawable_width_changed = True;
	prop->redraw_need = False;
	if (csrec->tag)
	{
		prop->column_tag = XtCalloc(strlen(csrec->tag) + 1, sizeof(char));
		if (prop->column_tag)
			strcpy(prop->column_tag, csrec->tag);
	}
	prop->gc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
									GCForeground | GCBackground | GCFunction, &gcv);

#ifdef USE_XFT
	if (XtIsRealized(w))
		prop->xftdraw = XftDrawCreate(XtDisplay(w), XtWindow(w), 
										DefaultVisual(XtDisplay(w), DefaultScreen(XtDisplay(w))),
										DefaultColormap(XtDisplay(w), DefaultScreen(XtDisplay(w))));
	else
		prop->xftdraw = NULL;
#endif

	prop->CacheBufIndex = NULL;
	prop->CacheBufNum = 0;
	prop->CacheBufPosition = -1;

	if (rcol->rescol.num_rows == 0)
	{
		rcol->rescol.num_items=0;
		rcol->rescol.cell_height=0;
	}


	parent = XtParent(w);


	if (ChekParentIsList(parent))
	{
		int col_num;
		
		XmNlListAppendColumn(parent, csrec);

		XtVaGetValues(parent, XmNnumCols, &col_num, NULL);

		
		if (col_num == rcol->rescol.num_cols)
		{
			rcol->rescol.PropConsistency = True;
			
		}
	}
	
	if (rcol->rescol.ItemData && rcol->rescol.num_rows)
	{
		RCAppendColumn(rcol);
		h_change = False;
		col_change = True;	
		RecalcParam(w, 0, rcol->rescol.num_rows, False, &h_change, &col_change);
	}
	
	prop = rcol->rescol.prop_data;
	
	if (/*(consistency != rcol->rescol.PropConsistency) &&*/ (rcol->rescol.PropConsistency == True))
	{
		int delta = 0;

		if (!rcol->rescol.resizeCallback)
		{
			return 0;
		}

		ResizeDoCallback(w, XmNlPropertyConsistency, XmNlConsistencyChange);


		if (rcol->rescol.ItemData && rcol->rescol.num_rows)
			ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prop[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prop[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
//				prow[i].x = delta;
//				delta = delta + prow[i].current_width;
			}
			prop[COL_MAPPED(i)].x = delta;
			delta = delta + prop[COL_MAPPED(i)].current_width;
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}

	AdjustGlobalShift(w);
	CalcColParam(w);

//if (RedrawNeed) printf("RedrawNeed row = %d\n", StartRow);
//if (HeightChanged) printf("HeightChanged\n");



	if (rcol->rescol.current_row >= rcol->rescol.num_rows)
	{
		rcol->rescol.current_row = 0;
		rcol->rescol.currentItem = rcol->rescol.ItemData[0];
	}

//	RCSetCacheBufLimit(w);

	if (ActionStatus || RedrawNeed)
	{
#ifdef DEBUG
		printf("\n RCAddRows SCREEN_REDRAW_NEEDED branch");
		fflush(stdout);
#endif
		if (XtIsRealized(w) )
		{
			RCRedrawAllWindow(w);
		}
//		if (ActionStatus) RefreshTitleBar(rcol);
	}

	ResizeSliders(w, HorizontalScroll);

	
#ifdef DEBUG
	printf("\n XmNlResColAppendColumn complet\n");
#endif
	return 0;
}


int XmNlResColDeleteColumn(Widget w, int column)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop, * last_prop;
	XmNlRCL_Cell  * cell;
	Widget parent;
	XGCValues gcv;
	Boolean consistency = rcol->rescol.PropConsistency;
	Boolean h_change, col_change, ActionStatus, RedrawNeed;	
	int i, col, * col_map;

#ifdef DEBUG
	printf("\n XmNlResColDeleteColumn started col = %d\n", column);
#endif

	if (rcol->rescol.prop_data == NULL)
		return -1;

	if (!rcol->rescol.ItemData || rcol->rescol.num_rows == 0 || rcol->rescol.num_cols == 0)
		return -1;
		
	if (rcol->rescol.num_cols == 1)
		return -1;

	if (column > rcol->rescol.num_cols - 1)
		return -1;

#ifdef DEBUG
	printf("Before deleting\n");
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("%d\t", i);
	}
	printf("\n");
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("%d\t", COL_MAPPED(i));
	}
	printf("\n");
#endif
		
	col = COL_MAPPED(column);

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = RCgetCell(w, i, column);
		DeleteCell(rcol, cell);
		if (cell->buf) 
		{
			RCFreeCacheNode(rcol, cell, col);
#ifdef DEBUG
			if (col == 1) 
			{
				printf("---AFTER DELETING\n");
				fflush(stdout);
				CheckCacheChunk(rcol->rescol.prop_data + col);
			}
#endif
		}
		cell = (XmNlRCL_Cell *) XtCalloc(rcol->rescol.num_cols - 1, sizeof(XmNlRCL_Cell));
		memcpy((void *) cell, (void *) rcol->rescol.ItemData[i], sizeof(XmNlRCL_Cell) * col);
		memcpy((void *) (cell + col), (void *) (rcol->rescol.ItemData[i] + col + 1), sizeof(XmNlRCL_Cell) * (rcol->rescol.num_cols - col - 1));
		XtFree((char *) rcol->rescol.ItemData[i]);
		rcol->rescol.ItemData[i] = cell;
	}

	prop = rcol->rescol.prop_data + col;
	if (prop->gc)
		XFreeGC(XtDisplay(w), prop->gc);
	prop->gc = NULL;

	if (prop->column_tag)
		XtFree(prop->column_tag);
	prop->column_tag = NULL;

#ifdef USE_XFT
	if (prop->xftdraw)
		XftDrawDestroy(prop->xftdraw);
	prop->xftdraw = NULL;
#endif

	last_prop = rcol->rescol.prop_data;
	rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(rcol->rescol.num_cols - 1, sizeof(XmNlRCL_Property_Row));
	memcpy((void *) rcol->rescol.prop_data, (void *) last_prop, sizeof(XmNlRCL_Property_Row) * col);
	memcpy((void *) (rcol->rescol.prop_data + col), (void *) (last_prop + col + 1), sizeof(XmNlRCL_Property_Row) * (rcol->rescol.num_cols - col - 1));
	XtFree((char *) last_prop);


/*** !!!!!!!!!!!! Clean prop[co] !!!!!!!!!!!!! **********/


	col_map = (int *) XtCalloc(rcol->rescol.num_cols - 1, sizeof(int));
/*	memcpy((void *) col_map, (void *) rcol->rescol.col_map, sizeof(int) * col);
	memcpy((void *) (col_map + col), (void *) (rcol->rescol.col_map + col + 1), sizeof(int) * (rcol->rescol.num_cols - col - 1));
	XtFree((char *) rcol->rescol.col_map);
	rcol->rescol.col_map = col_map;*/

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (i < column)
		{
			if (rcol->rescol.col_map[i] < col)
				col_map[i] = rcol->rescol.col_map[i];
			else
				col_map[i] = rcol->rescol.col_map[i] - 1;
		}
		else
			if (i == column)
				continue;
			else
				if (i > column)
				{
					if (rcol->rescol.col_map[i] < col)
						col_map[i-1] = rcol->rescol.col_map[i];
					else
						col_map[i-1] = rcol->rescol.col_map[i] - 1;
				}
	}

	XtFree((char *) rcol->rescol.col_map);
	rcol->rescol.col_map = col_map;
	rcol->rescol.num_cols--;

#ifdef DEBUG
	printf("After deleting\n");
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("%d\t", i);
	}
	printf("\n");
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("%d\t", COL_MAPPED(i));
	}
	printf("\n");
#endif

/*

	RCFreePixBuf(w);

	rcol->rescol.PublicColCount = col_count;
	rcol->rescol.PublicRowCount = 0;*/

	if (rcol->rescol.col_sharp_width) XtFree((char*)rcol->rescol.col_sharp_width);
	if (rcol->rescol.col_cur_width) XtFree((char*)rcol->rescol.col_cur_width);
	if (rcol->rescol.col_new_width) XtFree((char*)rcol->rescol.col_new_width);

	rcol->rescol.col_sharp_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_cur_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_new_width=(int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));

	parent = XtParent(w);

	if (ChekParentIsList(parent))
	{
		int col_num;
		
		XmNlListDeleteColumn(parent, column);
		XtVaGetValues(parent, XmNnumCols, &col_num, NULL);
		
		if (col_num == rcol->rescol.num_cols)
		{
			rcol->rescol.PropConsistency = True;
		}
	}

	if (rcol->rescol.ItemData && rcol->rescol.num_rows)
	{
		h_change = False;
		col_change = True;	
		RecalcParam(w, 0, rcol->rescol.num_rows, False, &h_change, &col_change);
	}
	
	prop = rcol->rescol.prop_data;
	
	if (/*(consistency != rcol->rescol.PropConsistency) &&*/ (rcol->rescol.PropConsistency == True))
	{
		int delta = 0;

		if (!rcol->rescol.resizeCallback)
		{
			return 0;
		}

		ResizeDoCallback(w, XmNlPropertyConsistency, XmNlConsistencyChange);


		if (rcol->rescol.ItemData && rcol->rescol.num_rows)
			ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prop[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prop[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
//				prow[i].x = delta;
//				delta = delta + prow[i].current_width;
			}
			prop[COL_MAPPED(i)].x = delta;
			delta = delta + prop[COL_MAPPED(i)].current_width;
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}

	AdjustGlobalShift(w);
	CalcColParam(w);

//if (RedrawNeed) printf("RedrawNeed row = %d\n", StartRow);
//if (HeightChanged) printf("HeightChanged\n");

	if (rcol->rescol.current_row >= rcol->rescol.num_rows)
	{
		rcol->rescol.current_row = 0;
		rcol->rescol.currentItem = rcol->rescol.ItemData[0];
	}

//	RCSetCacheBufLimit(w);

	if (ActionStatus || RedrawNeed)
	{
#ifdef DEBUG
		printf("\n RCAddRows SCREEN_REDRAW_NEEDED branch");
		fflush(stdout);
#endif
		if (XtIsRealized(w) )
		{
			RCRedrawAllWindow(w);
		}
//		if (ActionStatus) RefreshTitleBar(rcol);
	}

	ResizeSliders(w, HorizontalScroll);
	
#ifdef DEBUG
	printf("\n XmNlResColAppendColumn complet\n");
#endif
	return 0;
}




int XmNlResColSetColumn(Widget w, XmNlColSpecRec * csrec, int col_num)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop, * last_prop;
	XmNlRCL_Cell  * cell;
	Widget parent;
	XGCValues gcv;
	Boolean consistency = rcol->rescol.PropConsistency;


#ifdef DEBUG
	printf("\n XmNlResColSetColumn started cols = %d colspec = %p\n", rcol->rescol.num_cols, csrec);
//	_XmNlColSpecPrint(csrec);
#endif


	if (rcol->rescol.prop_data == NULL)
	{
#ifdef DEBUG
		printf("\n XmNlResColAddColumn: prop data not found\n");
#endif
		return 1;
	}

	if (col_num >= rcol->rescol.num_cols)
	{
#ifdef DEBUG
		printf("\n XmNlResColAddColumn: col num is too big\n");
#endif
		return 1;
	}


	parent = XtParent(w);
	if (ChekParentIsList(parent))
	{
		XmNlListSetColumn(parent, csrec, col_num);
	}
	
	
#ifdef DEBUG
	printf("\n XmNlResColSetColumn complet\n");
#endif
	return 0;
}

int XmNlResColSetCol(Widget w, XmNlCell * data, int col, unsigned char valuemask)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int k, i;
	int x, y;
	Boolean AddToFoundedMassiv = False;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean HeightChanged = False;
	Boolean ColChanged = False;
	int new_cell_h=0;
	unsigned int width, height, bw, depth;
	Window root;
	Display *dpy = XtDisplay(w);
	Boolean ActionStatus = False;
	IconInfo * icon;

	if (rcol->rescol.TreeMode) 
		return -1;

	if (rcol->rescol.num_rows == 0 || !rcol->rescol.ItemData)
		return -1;

	if (col >= rcol->rescol.num_cols)
		return -1;

	prow = rcol->rescol.prop_data;

#ifdef DEBUG
	printf("\n XmNlResColSetCol started");
	fflush(stdout);
#endif


	k = 0;
/*** k - index for internal data massiv ***/
	for (k = 0; k < rcol->rescol.num_rows; k++)
	{
		cell = rcol->rescol.ItemData[k];
/*************** In column pixmaps *******************/
		if (prow[COL_MAPPED(col)].info_type == XmPIXMAP)
		{
			cell[COL_MAPPED(col)].text = NULL;
			cell[COL_MAPPED(col)].xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
			cell[COL_MAPPED(col)].complabel = NULL;
#endif

			if ((valuemask & CellPixmap) && PIX_FOUND(data[k].pixmap))
			{
				if (PIX_FOUND(data[k].mask)) icon = AddIconToList(w, data[k].pixmap, data[k].mask);
				else icon = AddIconToList(w, data[k].pixmap, XmUNSPECIFIED_PIXMAP);
				if (icon)
				{
					cell[COL_MAPPED(col)].icon = icon;
					icon->use_counter ++;
				}
				else cell[COL_MAPPED(col)].icon = NULL;
			}
			else cell[COL_MAPPED(col)].icon = NULL;
		}
/*************** In column text   ***************/
		if (prow[COL_MAPPED(col)].info_type == XmSTRING)
		{
			cell[COL_MAPPED(col)].icon = NULL;
			if (valuemask & CellCharString) cell[COL_MAPPED(col)].text = data[k].text;
			else cell[COL_MAPPED(col)].text = NULL;
			if (valuemask & CellXmString)
			{
				cell[COL_MAPPED(col)].xmlabel = XmStringCopy(data[k].xmlabel);
				cell[COL_MAPPED(col)].label_h = XmStringHeight(rcol->rescol.font_list, cell[COL_MAPPED(col)].xmlabel);
				cell[COL_MAPPED(col)].label_w = XmStringWidth(rcol->rescol.font_list, cell[COL_MAPPED(col)].xmlabel);
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(col)].complabel = CreateSegmentedXmString(data[k].xmlabel);
/*					SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[j].complabel, 
										&(cell[j].label_w), &(cell[j].label_h));*/
				SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[COL_MAPPED(col)].complabel, 
										&(cell[COL_MAPPED(col)].label_w), &(cell[COL_MAPPED(col)].label_h), rcol->rescol.idxRend);
#endif
			}
			else
			{
				cell[COL_MAPPED(col)].xmlabel = NULL;
				cell[COL_MAPPED(col)].label_h = 0;
				cell[COL_MAPPED(col)].label_w = 0;
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(col)].complabel = NULL;
#endif
			}
		}

		if (valuemask & CellSelection)
		{
			cell[COL_MAPPED(col)].selected = data[k].selected;
		}
		else
			cell[COL_MAPPED(col)].selected = 0;

		if (valuemask & CellAlignment)
			cell[COL_MAPPED(col)].alignment = data[k].alignment;
		else
			cell[COL_MAPPED(col)].alignment = XmALIGNMENT_UNSPECIFIED;

		if (valuemask & CellUserData)
			cell[COL_MAPPED(col)].UserDataPointer = data[k].UserDataPointer;
		else
			cell[COL_MAPPED(col)].UserDataPointer = NULL;
	}

	RebuildSelectedPositionsOnly(rcol);


	RecalcParam(w, 0, rcol->rescol.num_rows, False, &HeightChanged, &ColChanged);

#ifdef DEBUG
	printf("\n RCAddRows complete\n");
	fflush(stdout);

	for (i = 0; j < rcol->rescol.num_cols; j++)
	{
		printf("ResCol: Real col size: %d\n", prow[COL_MAPPED(i)].real_width);
	}
	printf("\n");
#endif

	if (rcol->rescol.resizeCallback)
	{
		int delta = 0;
		ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
//				prow[i].x = delta;
//				delta = delta + prow[i].current_width;
			}
			prow[COL_MAPPED(i)].x = delta;
			delta = delta + prow[COL_MAPPED(i)].current_width;
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}
	else
	{
		if (!AddToFoundedMassiv)
			ActionStatus = CalcGeomInit(w);
		else
			if (ColChanged) ActionStatus = CalcGeomPostInit(w);
	}

	rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;

	rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;

	rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;

	rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;

//if (ActionStatus) printf("ActionStatus row = %d top = %d bottom = %d\n", StartRow, rcol->rescol.TopLine, rcol->rescol.BotomLine);

	RedrawNeed = True;

	AdjustGlobalShift(w);
	CalcColParam(w);

//if (RedrawNeed) printf("RedrawNeed row = %d\n", StartRow);
//if (HeightChanged) printf("HeightChanged\n");



	if (rcol->rescol.current_row >= rcol->rescol.num_rows)
	{
		rcol->rescol.current_row = 0;
		rcol->rescol.currentItem = rcol->rescol.ItemData[0];
	}

	RCSetCacheBufLimit(w);

	if (ActionStatus || RedrawNeed || HeightChanged)
	{
#ifdef DEBUG
		printf("\n RCAddRows SCREEN_REDRAW_NEEDED branch");
		fflush(stdout);
#endif
		if (XtIsRealized(w) )
		{
			RCRedrawAllWindow(w);
		}
//		if (ActionStatus) RefreshTitleBar(rcol);
	}

	ResizeSliders(w, AllScroll);

//		CheckCacheChunk(prow);
	return 0;
}



int XmNlResColAddRows(Widget w, XmNlCell * data, int row_count, unsigned char valuemask)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int i, j, StartRow=0, b_row, end_row, l, k;
	int x, y;
	Boolean AddToFoundedMassiv = False;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean HeightChanged = False;
	Boolean ColChanged = False;
	int new_cell_h=0;
	unsigned int width, height, bw, depth;
	Window root;
	Display *dpy = XtDisplay(w);
	Boolean ActionStatus = False;
	IconInfo * icon;

	if (rcol->rescol.TreeMode) return -1;

	prow = rcol->rescol.prop_data;

#ifdef DEBUG
	printf("\n RCAddRows started");
	fflush(stdout);
#endif

	cell = (XmNlRCL_Cell *) XtMalloc((rcol->rescol.num_rows + row_count) * sizeof (XmNlRCL_Cell *));

	if (rcol->rescol.num_rows != 0 /*rcol->rescol.item_data!=NULL*/)
	{
		AddToFoundedMassiv = True;
		StartRow = rcol->rescol.num_rows;
		memcpy(cell, rcol->rescol.ItemData, rcol->rescol.num_rows * sizeof (XmNlRCL_Cell *));
		XtFree((char *) (rcol->rescol.ItemData));
#ifdef DEBUG
		printf("\n RCAddRows item_data reallocated succefull");
		fflush(stdout);
#endif
		rcol->rescol.selected_rows = (Boolean *) XtRealloc((char *) rcol->rescol.selected_rows,
			(rcol->rescol.num_rows + row_count) * sizeof (Boolean));

#ifdef DEBUG
		printf("\n RCAddRows selected_rows reallocated succefull");
		fflush(stdout);
#endif
	}
	else
	{
		rcol->rescol.selected_rows = (Boolean *) XtMalloc(row_count * sizeof (Boolean));

#ifdef DEBUG
		printf("\n RCAddRows selected_rows allocated succefull");
		fflush(stdout);
#endif
	}

	rcol->rescol.ItemData = (XmNlRCL_Cell **) cell;
	rcol->rescol.num_rows = rcol->rescol.num_rows + row_count;
	rcol->rescol.num_items = rcol->rescol.num_items + row_count*rcol->rescol.num_cols;

#ifdef DEBUG
	printf("\n RCAddRows col=%i row=%i, item=%i\n", rcol->rescol.num_cols, rcol->rescol.num_rows, rcol->rescol.num_items);
	fflush(stdout);
#endif

/*	for (j=StartRow; j < rcol->rescol.num_rows; j++)
	{

		rcol->rescol.selected_rows[j] = False;
	}*/

/*** l - index for external data massiv ****/
	l = 0;
	k = StartRow;
/*** k - index for internal data massiv ***/
/*** i - additional row number 			***/
/*** j - col number						***/
	for (i = 0; i < row_count; i++, k++)
	{
		cell = (XmNlRCL_Cell *) XtMalloc(rcol->rescol.num_cols * sizeof (XmNlRCL_Cell));
		rcol->rescol.ItemData[k] = cell;
		for (j = 0; j < rcol->rescol.num_cols; j++, l++)
		{
			cell[COL_MAPPED(j)].buf = NULL;

/*************** In column pixmaps *******************/
			if (prow[COL_MAPPED(j)].info_type == XmPIXMAP)
			{
				cell[COL_MAPPED(j)].text = NULL;
				cell[COL_MAPPED(j)].xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(j)].complabel = NULL;
#endif

				if ((valuemask & CellPixmap) && PIX_FOUND(data[l].pixmap))
				{
					if (PIX_FOUND(data[l].mask)) icon = AddIconToList(w, data[l].pixmap, data[l].mask);
					else icon = AddIconToList(w, data[l].pixmap, XmUNSPECIFIED_PIXMAP);
					if (icon)
					{
						cell[COL_MAPPED(j)].icon = icon;
						icon->use_counter ++;
					}
					else cell[COL_MAPPED(j)].icon = NULL;
				}
				else cell[COL_MAPPED(j)].icon = NULL;
			}
/*************** In column text   ***************/
			if (prow[COL_MAPPED(j)].info_type == XmSTRING)
			{
				cell[COL_MAPPED(j)].icon = NULL;
				if (valuemask & CellCharString) cell[COL_MAPPED(j)].text = data[l].text;
				else cell[COL_MAPPED(j)].text = NULL;
				if (valuemask & CellXmString)
				{
					cell[COL_MAPPED(j)].xmlabel = XmStringCopy(data[l].xmlabel);
					cell[COL_MAPPED(j)].label_h = XmStringHeight(rcol->rescol.font_list, cell[COL_MAPPED(j)].xmlabel);
					cell[COL_MAPPED(j)].label_w = XmStringWidth(rcol->rescol.font_list, cell[COL_MAPPED(j)].xmlabel);
#ifdef FAST_XMSTRING_RENDERING
					cell[COL_MAPPED(j)].complabel = CreateSegmentedXmString(data[l].xmlabel);
/*					SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[j].complabel, 
										&(cell[j].label_w), &(cell[j].label_h));*/
					SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[COL_MAPPED(j)].complabel, 
										&(cell[COL_MAPPED(j)].label_w), &(cell[COL_MAPPED(j)].label_h), rcol->rescol.idxRend);
#endif
				}
				else
				{
					cell[COL_MAPPED(j)].xmlabel = NULL;
					cell[COL_MAPPED(j)].label_h = 0;
					cell[COL_MAPPED(j)].label_w = 0;
#ifdef FAST_XMSTRING_RENDERING
					cell[COL_MAPPED(j)].complabel = NULL;
#endif
				}
			}

			if (valuemask & CellSelection)
			{
				cell[COL_MAPPED(j)].selected = data[i].selected;
			}
			else
				cell[COL_MAPPED(j)].selected = 0;

			if (valuemask & CellAlignment)
				cell[COL_MAPPED(j)].alignment = data[l].alignment;
			else
				cell[COL_MAPPED(j)].alignment = XmALIGNMENT_UNSPECIFIED;

			if (valuemask & CellUserData)
				cell[COL_MAPPED(j)].UserDataPointer = data[l].UserDataPointer;
			else
				cell[COL_MAPPED(j)].UserDataPointer = NULL;
		}
		if (cell[COL_MAPPED(0)].selected)
			rcol->rescol.selected_rows[k] = True;
		else
			rcol->rescol.selected_rows[k] = False;
	}

	RebuildSelectedPositionsOnly(rcol);


	RecalcParam(w, StartRow, StartRow + row_count, False, &HeightChanged, &ColChanged);

#ifdef DEBUG
	printf("\n RCAddRows complete\n");
	fflush(stdout);

		for (j=0; j<rcol->rescol.num_cols; j++)
		{
			printf("ResCol: Real col size: %d\n", prow[COL_MAPPED(j)].real_width);
		}
		printf("\n");
#endif

	if (rcol->rescol.resizeCallback)
	{
		int delta = 0;
		ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
//				prow[i].x = delta;
//				delta = delta + prow[i].current_width;
			}
			prow[COL_MAPPED(i)].x = delta;
			delta = delta + prow[COL_MAPPED(i)].current_width;
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}
	else
	{
		if (!AddToFoundedMassiv)
			ActionStatus = CalcGeomInit(w);
		else
			if (ColChanged) ActionStatus = CalcGeomPostInit(w);
	}

	rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;

	rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;

	rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;

	rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;

	l = StartRow + row_count;
//if (ActionStatus) printf("ActionStatus row = %d top = %d bottom = %d\n", StartRow, rcol->rescol.TopLine, rcol->rescol.BotomLine);

	if ((StartRow >= rcol->rescol.TopLine && StartRow <= rcol->rescol.BotomLine)
		|| (l >=  rcol->rescol.TopLine && l <= rcol->rescol.BotomLine)
		|| (StartRow < rcol->rescol.TopLine && l > rcol->rescol.BotomLine))
					RedrawNeed = True;

	AdjustGlobalShift(w);
	CalcColParam(w);

//if (RedrawNeed) printf("RedrawNeed row = %d\n", StartRow);
//if (HeightChanged) printf("HeightChanged\n");



	if (rcol->rescol.current_row >= rcol->rescol.num_rows)
	{
		rcol->rescol.current_row = 0;
		rcol->rescol.currentItem = rcol->rescol.ItemData[0];
	}

	RCSetCacheBufLimit(w);

	if (ActionStatus || RedrawNeed || HeightChanged)
	{
#ifdef DEBUG
		printf("\n RCAddRows SCREEN_REDRAW_NEEDED branch");
		fflush(stdout);
#endif
		if (XtIsRealized(w) )
		{
			RCRedrawAllWindow(w);
		}
//		if (ActionStatus) RefreshTitleBar(rcol);
	}

	ResizeSliders(w, AllScroll);

//		CheckCacheChunk(prow);
	return 0;
}


/***************************************************************/

int XmNlResColInsertRow(Widget w, XmNlCell * data, int row_pos, unsigned char valuemask)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int i, j, StartRow=0, b_row, end_row, l, k;
	int x, y;
	Boolean AddToFoundedMassiv = False;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean HeightChange;
	Boolean ColChange;
	int new_cell_h=0;
	unsigned int width, height, bw, depth;
	Window root;
	Display *dpy;
	dpy=XtDisplay(w);
	int ActionStatus;
	IconInfo * icon;

	prow=rcol->rescol.prop_data;

#ifdef DEBUG
	printf("\n RCInsertRow started");
	fflush(stdout);
#endif
	if (rcol->rescol.num_rows == 0 || row_pos >= rcol->rescol.num_rows)
	{
	  /* If list is empty, use RCAddRows */
		XmNlResColAddRows(w, data, 1, valuemask);
		return 0;
	}

	StartRow = rcol->rescol.num_rows;
	rcol->rescol.ItemData = (XmNlRCL_Cell **) XtRealloc((char *) rcol->rescol.ItemData,
														(rcol->rescol.num_rows + 1) * sizeof (XmNlRCL_Cell *));
	memmove(rcol->rescol.ItemData + row_pos + 1, rcol->rescol.ItemData + row_pos,
			(rcol->rescol.num_rows - row_pos) * sizeof(XmNlRCL_Cell *));

	cell = (XmNlRCL_Cell *) XtMalloc(rcol->rescol.num_cols * sizeof(XmNlRCL_Cell));

	rcol->rescol.ItemData[row_pos] = cell;

/*	memmove(&(cell[(row_pos+1)*rcol->rescol.num_cols]), &(cell[row_pos*rcol->rescol.num_cols]),
			(rcol->rescol.num_items-row_pos*rcol->rescol.num_cols)*sizeof(XmNlRCL_Cell));*/

#ifdef DEBUG
	printf("\n RCInsertRow item_data reallocated succefull");
	fflush(stdout);
#endif
	rcol->rescol.num_rows = rcol->rescol.num_rows + 1;
	rcol->rescol.num_items = rcol->rescol.num_items + rcol->rescol.num_cols;

	rcol->rescol.selected_rows = (Boolean *) XtRealloc((char *) rcol->rescol.selected_rows,
			rcol->rescol.num_rows * sizeof (Boolean));

	memmove(rcol->rescol.selected_rows + row_pos + 1, rcol->rescol.selected_rows + row_pos,
			(rcol->rescol.num_rows - row_pos)*sizeof(Boolean));

#ifdef DEBUG
	printf("\n RCInsertRow selected_rows reallocated succefull");
	fflush(stdout);
#endif



	for (i = 0; i < rcol->rescol.num_cols; i++, k++)
	{
		cell[COL_MAPPED(i)].text = NULL;
		cell[COL_MAPPED(i)].xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
		cell[COL_MAPPED(i)].complabel = NULL;
#endif
		cell[COL_MAPPED(i)].UserDataPointer = NULL;
		cell[COL_MAPPED(i)].buf = NULL;


/********* In column pixmaps ***********/

		if (prow[COL_MAPPED(i)].info_type == XmPIXMAP)
		{
			if ((valuemask & CellPixmap) && PIX_FOUND(data[i].pixmap))
				{
					if (PIX_FOUND(data[i].mask)) icon = AddIconToList(w, data[i].pixmap, data[i].mask);
					else icon = AddIconToList(w, data[i].pixmap, XmUNSPECIFIED_PIXMAP);
					if (icon)
					{
						cell[COL_MAPPED(i)].icon = icon;
						icon->use_counter ++;
					}
					else cell[COL_MAPPED(i)].icon = NULL;
				}
				else cell[COL_MAPPED(i)].icon = NULL;
		}
/************ In column text ****************/
		if (prow[COL_MAPPED(i)].info_type == XmSTRING)
		{
			cell[COL_MAPPED(i)].icon = NULL;

			if (valuemask & CellCharString) cell[COL_MAPPED(i)].text = data[i].text;
			else cell[COL_MAPPED(i)].text = NULL;
			if (valuemask & CellXmString)
			{
				cell[COL_MAPPED(i)].xmlabel = XmStringCopy(data[i].xmlabel);
				cell[COL_MAPPED(i)].label_h = XmStringHeight(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
				cell[COL_MAPPED(i)].label_w = XmStringWidth(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = CreateSegmentedXmString(data[i].xmlabel);
/*				SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[i].complabel, 
										&(cell[i].label_w), &(cell[i].label_h));*/
				SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[COL_MAPPED(i)].complabel, 
										&(cell[COL_MAPPED(i)].label_w), &(cell[COL_MAPPED(i)].label_h), rcol->rescol.idxRend);
#endif
			}
			else
			{
				cell[COL_MAPPED(i)].xmlabel = NULL;
				cell[COL_MAPPED(i)].label_h = 0;
				cell[COL_MAPPED(i)].label_w = 0;
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = NULL;
#endif
			}
		}

		if (valuemask & CellSelection)
		{
			cell[COL_MAPPED(i)].selected = data[i].selected;
		}
		else
			cell[COL_MAPPED(i)].selected = 0;

		cell[COL_MAPPED(i)].buf = NULL;

		if (valuemask & CellAlignment) cell[COL_MAPPED(i)].alignment = data[i].alignment;
		else cell[COL_MAPPED(i)].alignment = XmALIGNMENT_UNSPECIFIED;

		if (valuemask & CellUserData) cell[COL_MAPPED(i)].UserDataPointer = data[i].UserDataPointer;
		else cell[COL_MAPPED(i)].UserDataPointer = NULL;
	}

	if (cell[COL_MAPPED(0)].selected)
		rcol->rescol.selected_rows[row_pos] = True;
	else
		rcol->rescol.selected_rows[row_pos] = False;


	RebuildSelectedPositionsOnly(rcol);

#ifdef DEBUG
	printf("\n RCInsertRow complet");
	fflush(stdout);
#endif

	RecalcParam(w, row_pos, row_pos + 1, False, &HeightChange, &ColChange);

	if (rcol->rescol.resizeCallback)
	{
		int delta = 0;
		ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[COL_MAPPED(i)])
			{
				ActionStatus = True;
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[COL_MAPPED(i)];
			}
			prow[COL_MAPPED(i)].x = delta;
			delta = delta + prow[COL_MAPPED(i)].current_width;

		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}
	else
	{
		if (ColChange)
			ActionStatus=CalcGeomPostInit(w);
	}

	rcol->rescol.TopLine=rcol->rescol.global_v_shift/rcol->rescol.cell_height;

	rcol->rescol.BotomLine=rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;

	if (row_pos >= rcol->rescol.TopLine && row_pos <= rcol->rescol.BotomLine)
					ActionStatus = True;

	AdjustGlobalShift(w);

	CalcColParam(w);

	if (ActionStatus || HeightChange)
	{
#ifdef DEBUG
		printf("\n RCInserRow SCREEN_REDRAW_NEEDED branch");
		fflush(stdout);
#endif
		if (XtIsRealized(w) )
		{
			RCRedrawAllWindow(w);
		}
//		RefreshTitleBar(rcol);
	}

	ResizeSliders(w, AllScroll);

	return 0;
}

void XmNlResColSort(Widget w, int start, int lenght, int (*comparer)(const void *, const void *))
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * cell, * current_cell;
//	Boolean * tmp_current;
	int i;
	
		
	if (!rcol->rescol.ItemData)
		return ;
	if (start >= rcol->rescol.num_rows || (start + lenght) > rcol->rescol.num_rows)
		return ;
	
	if (rcol->rescol.current_row >= 0 && rcol->rescol.current_row < rcol->rescol.num_rows)
	{
		current_cell = rcol->rescol.ItemData[rcol->rescol.current_row];
	}
	
//	tmp_current = (Boolean *) XtCalloc(rcol->rescol.num_rows, sizeof(Boolean));
	
		
	qsort(rcol->rescol.ItemData + start, lenght, sizeof(XmNlRCL_Cell *), comparer);
//	RebuildSelectedPositions(rcol);
	RebuildSelectedRows(rcol, 1);
	
/*	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = rcol->rescol.ItemData[i];
		if (cell->selected)
			rcol->rescol.selected_rows[i] = True;
		else
			rcol->rescol.selected_rows[i] = False;
		
		if (cell == current_cell)
			rcol->rescol.current_row = i;
	}*/

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.ItemData[i] == current_cell)
			rcol->rescol.current_row = i;
	}

	RCRedrawAllWindow(w);
	CurrentFrameDraw(w);
}

void RCSetCell(Widget , int , int , XmNlCell * , unsigned char );


void XmNlResColSetCell(Widget w, XmNlCell *cell, unsigned char valuemask, int col, int row)
{
	RCSetCell(w, row, col, cell, valuemask);
}

Boolean XmNlResColGetCellAtPointer(Widget w, XmNlCell *cell, unsigned char valuemask, const void * pointer, int col)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * RCcell;

	if (!rcol->rescol.ItemData)
		return False;

	if (col >= rcol->rescol.num_cols)
		return False;

	RCcell = *((XmNlRCL_Cell **) pointer);

	RCcell = RCcell + COL_MAPPED(col);
 
	if (valuemask & CellCharString) cell->text = RCcell->text;
	if (valuemask & CellXmString)
	{
		if (RCcell->xmlabel)
			cell->xmlabel = XmStringCopy(RCcell->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		cell->selected = RCcell->selected;
	}

	if (valuemask & CellAlignment) cell->alignment = RCcell->alignment;

	if (valuemask & CellUserData) cell->UserDataPointer = RCcell->UserDataPointer;

	return True;
}

int XmNlResColGetColumnNum(Widget w, char * tag)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	int i, ret = -1;
	
	if (rcol->rescol.num_cols == 0)
		return ret;
		
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		prow = rcol->rescol.prop_data + COL_MAPPED(i);
		if (prow->column_tag)
		{
			if (0 == strcmp(prow->column_tag, tag))
			{
				ret = i;
				return ret;
			}
		}
	}

	return ret;
}

char * XmNlResColGetColumnTag(Widget w, int column)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	char * ret = NULL;
	
	if (column >= rcol->rescol.num_cols)
		return ret;
		
	prow = rcol->rescol.prop_data + COL_MAPPED(column);
	
	if (!prow->column_tag)
		return ret;
		
	ret = calloc(strlen(prow->column_tag) + 1, sizeof(char));

	if (ret)
		strcpy(ret, prow->column_tag);
		
	return ret;
}

Boolean XmNlResColGetCell(Widget w, XmNlCell *cell, unsigned char valuemask, int col, int row)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * RCcell;

	RCcell = RCgetCell(w, row, col);

	if (!RCcell)
		return False;

	if (valuemask & CellCharString) cell->text = RCcell->text;
	if (valuemask & CellXmString)
	{
		if (RCcell->xmlabel)
			cell->xmlabel = XmStringCopy(RCcell->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		cell->selected = RCcell->selected;
	}

	if (valuemask & CellAlignment) cell->alignment = RCcell->alignment;

	if (valuemask & CellUserData) cell->UserDataPointer = RCcell->UserDataPointer;

	return True;
}


Boolean XmNlResColGetItem(Widget w, XmNlCell *cell, unsigned char valuemask, int position)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * RCcell;

	RCcell = RCgetCell(w, position, rcol->rescol.CurrentColPosition);

	if (!RCcell)
		return False;

	if (valuemask & CellCharString) cell->text = RCcell->text;
	if (valuemask & CellXmString)
	{
		if (RCcell->xmlabel)
			cell->xmlabel = XmStringCopy(RCcell->xmlabel);
	}

	if (valuemask & CellSelection)
	{
		cell->selected = RCcell->selected;
	}

	if (valuemask & CellAlignment) cell->alignment = RCcell->alignment;

	if (valuemask & CellUserData) cell->UserDataPointer = RCcell->UserDataPointer;

	return True;
}

/*
void RCCreateDeafaultCols(XmNlResColListWidget rcol)
{
	int i;
	XmNlRCL_Property_Row * prop;
	XmNlColDescriptorTable cdt;
	XmNlColDescriptorRec * rec;
	XGCValues gcv;

#ifdef DEBUG
	printf("\n RCCreateDefaultCols");
#endif

	rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(rcol->rescol.num_cols, sizeof (XmNlRCL_Property_Row));

	prop = rcol->rescol.prop_data;

	rcol->rescol.PublicColCount = rcol->rescol.num_cols;

	if (rcol->rescol.col_sharp_width) 
		XtFree((char*)rcol->rescol.col_sharp_width);
	if (rcol->rescol.col_cur_width) 
		XtFree((char*)rcol->rescol.col_cur_width);
	if (rcol->rescol.col_new_width) 
		XtFree((char*)rcol->rescol.col_new_width);

	rcol->rescol.col_sharp_width = (int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_cur_width = (int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));
	rcol->rescol.col_new_width = (int *) XtCalloc(rcol->rescol.num_cols, sizeof (int));

	gcv.background = rcol->core.background_pixel;
	gcv.foreground = rcol->rescol.foreground_pixel;
	gcv.function = GXcopy;

	cdt = rcol->rescol.colDesc;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (cdt && i < cdt->descriptors_count)
		{
			rec = cdt->descriptors[i];
			prop[i].info_type = rec->type;
			if (rec->type == XmPIXMAP_AND_STRING)
				prop[i].info_type = XmSTRING;

			if (rec->background == XmUNSPECIFIED_PIXEL)
				prop[i].background = ((XmPrimitiveWidget)rcol)->core.background_pixel;
			else
				prop[i].background = rec->background;

			if (rec->foreground == XmUNSPECIFIED_PIXEL)
				prop[i].foreground = ((XmPrimitiveWidget)rcol)->primitive.foreground;
			else
				prop[i].foreground = rec->foreground;

			prop[i].align_type = rec->alignment;
		}
		else
		{
			prop[i].info_type = rcol->rescol.default_type;
			prop[i].align_type = rcol->rescol.default_align;
			prop[i].background = ((XmPrimitiveWidget)rcol)->core.background_pixel;
			prop[i].foreground = ((XmPrimitiveWidget)rcol)->primitive.foreground;
		}
		prop[i].pix_buf = XmUNSPECIFIED_PIXMAP;
		prop[i].current_width = 0;
		prop[i].drawable_width = 0;
		prop[i].real_width = DEFAULT_EMPTY_WIDTH + 2*rcol->rescol.margin_w;
		prop[i].drawable_width_changed = True;
		prop[i].redraw_need = False;
		prop[i].gc = XCreateGC(XtDisplay((Widget) rcol), RootWindowOfScreen(XtScreen((Widget) rcol)),
									GCForeground | GCBackground | GCFunction, &gcv);

		prop[i].CacheBufIndex = NULL;
		prop[i].CacheBufNum = 0;
		prop[i].CacheBufPosition = -1;
	}
#ifdef DEBUG
	printf("\n RCCreateDefaultCols completed");
#endif
	return ;
}
*/


static Boolean ChekParentIsList(Widget w)
{
	WidgetClass class;
	CoreClassPart core;

	class = XtClass(w);
	core = (CoreClassPart) class->core_class;

	if (strcmp("XmNlList", core.class_name) ==  0)
		return True;
	else 
		return False;
}

/*
void RCSetStructure(Widget w, int col_count, RCStructureElement * data)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i;
	XmNlRCL_Property_Row * prop;
	Widget parent;
	XGCValues gcv;
#ifdef DEBUG
	printf("\n Prop started");
#endif

	if (rcol->rescol.num_cols !=0 && (rcol->rescol.ItemData || rcol->rescol.first))
	{
	    if (rcol->rescol.TreeMode)
		{
			XmNlRCTreeDeleteAllItems(w);
		}
		else
			XmNlResColDeleteAllRows(w);
	}

	RCFreePixBufNew(w);

	if (rcol->rescol.prop_data != NULL)
	{
		prop = rcol->rescol.prop_data;
		for (i=0; i<rcol->rescol.num_cols; i++)
		{
			if (prop[i].gc)
				XFreeGC(XtDisplay(w), prop[i].gc);
			prop[i].gc = NULL;
		}
		XtFree((char*)rcol->rescol.prop_data);
		rcol->rescol.prop_data = NULL;
	}

	rcol->rescol.prop_data = (XmNlRCL_Property_Row *) XtCalloc(col_count, sizeof (XmNlRCL_Property_Row));

	prop=rcol->rescol.prop_data;
	rcol->rescol.num_cols = col_count;
	rcol->rescol.num_rows = 0;

	rcol->rescol.PublicColCount = col_count;
	rcol->rescol.PublicRowCount = 0;

	if (rcol->rescol.col_sharp_width) XtFree((char*)rcol->rescol.col_sharp_width);
	if (rcol->rescol.col_cur_width) XtFree((char*)rcol->rescol.col_cur_width);
	if (rcol->rescol.col_new_width) XtFree((char*)rcol->rescol.col_new_width);

	rcol->rescol.col_sharp_width=(int *) XtCalloc(col_count, sizeof (int));
	rcol->rescol.col_cur_width=(int *) XtCalloc(col_count, sizeof (int));
	rcol->rescol.col_new_width=(int *) XtCalloc(col_count, sizeof (int));

	gcv.background = rcol->core.background_pixel;
	gcv.foreground = rcol->rescol.foreground_pixel;
	gcv.function = GXcopy;

	for (i=0; i<rcol->rescol.num_cols; i++)
	{
		prop[i].info_type=data[i].column_type;
		prop[i].align_type=data[i].column_alignement;
		prop[i].pix_buf=XmUNSPECIFIED_PIXMAP;
		prop[i].current_width=0;
		prop[i].drawable_width=0;
		prop[i].real_width=0;
		prop[i].drawable_width_changed=True;
		prop[i].redraw_need = False;
		prop[i].gc = XCreateGC(XtDisplay(w), RootWindowOfScreen(XtScreen(w)),
									GCForeground | GCBackground | GCFunction, &gcv);

		prop[i].CacheBufIndex = NULL;
		prop[i].CacheBufNum = 0;
		prop[i].CacheBufPosition = -1;
	}
	rcol->rescol.num_items=0;
	rcol->rescol.cell_height=0;
	
	parent = XtParent(w);
	if (ChekParentIsList(parent))
	{
		int col_num;
		
		XtVaGetValues(parent, XmNnumCols, &col_num, NULL);
		
		if (col_num == rcol->rescol.num_cols)
		{
			rcol->rescol.PropConsistency = True;
			
			printf("ResColListWidget consistency changed to True\n");
		}
	}
	
#ifdef DEBUG
	printf("\n Prop complet");
#endif
	return ;
}
*/
/*
void RCSetListStructure(Widget w, RCStructureElement * data)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i;
	XmNlRCL_Property_Row * prop;
#ifdef DEBUG
	printf("\n Prop List started");
#endif


	prop = rcol->rescol.prop_data;



	for (i=0; i<rcol->rescol.num_cols; i++)
	{
		prop[i].info_type = data[i].column_type;
		prop[i].align_type = data[i].column_alignement;
	}
#ifdef DEBUG
	printf("\n Prop List complet");
#endif
	return ;
}
*/

/**************************************************************/

/*
int RCGetHorShift(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int i;
	return rcol->rescol.global_h_shift;
}
*/

void RCGetColsWidth(Widget w, Dimension * size)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int i;
	prow = rcol->rescol.prop_data;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		size[i] = prow[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf("\n RCGetColsWidth: %d col size = %d\n", i, size[i]);
#endif
	}
	return ;
}


#ifdef TreeManagementDEBUG
static void 
PrintNodePath(XmNlListTreeItem * item, char * message)
{
	int i;
	size_t len;
	char seqtext[1024], buf[20];
	XmNlListTreeItem * parent;

	memset(seqtext, 0, 1024);
	len = 0;
	sprintf(seqtext, "-%d", item->sequence);
	i = strlen(seqtext);
	parent = item->parent;
	while (parent)
	{
		memset(buf, 0, 20);
		sprintf(buf, "-%d", parent->sequence);
		len = strlen(buf);
		memmove(seqtext + len, seqtext, i);
		i = i + len;
		strncpy(seqtext, (const char *) buf, len);
		parent = parent->parent;
	}
	printf("%s: %s\n", message, seqtext);
}
#endif

static void DeleteCell(XmNlResColListWidget rcol, XmNlRCL_Cell * cell)
{
	IconInfo * ptr1, * ptr2;
	CacheBufElement * pp1;

	if (cell->xmlabel) XmStringFree(cell->xmlabel);
	cell->xmlabel = NULL;
//	if (cell->text) printf("Cleared cell %s\n", cell->text);

#ifdef FAST_XMSTRING_RENDERING
	if (cell->complabel) DestroySegmentedXmString(cell->complabel);
	cell->complabel = NULL;
#endif

/** Clear text pixbuf **/
	if (cell->buf)
	{
		pp1 = (CacheBufElement *) cell->buf;
		pp1->cell = NULL;
	}

/** Clear icon **/
	if (cell->icon)
		DelIconFromList((Widget) rcol, cell->icon);
}


static void 
RCDeleteAllRows(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int row, col;

#ifdef DEBUG
	printf("\n RCRemoveAllRows started\n\n");
#endif


	for (row = 0; row < rcol->rescol.num_rows; row++)
	{
		cell = rcol->rescol.ItemData[row];
		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
#ifdef DEBUG
			if (cell[COL_MAPPED(col)].textbuf) printf("\n RCRemoveAllRows:  XFreePixmap\n");
			else printf("\n RCRemoveAllRows:  Not XFreePixmap\n");
#endif
			DeleteCell(rcol, cell + COL_MAPPED(col));
			if ((cell + COL_MAPPED(col))->buf) 
				RCFreeCacheNode(rcol, cell + COL_MAPPED(col), COL_MAPPED(col));
		}
		if (cell) 
			XtFree((char *) cell);
	}
	
	if (rcol->rescol.ItemData) 
	{
		XtFree((char *) (rcol->rescol.ItemData));
		rcol->rescol.ItemData = NULL;
	}

//	printf("\n RCRemoveAllRows IconList %p\n", rcol->rescol.IconList);

#ifdef DEBUG
	printf("\n RCRemoveAllRows stage 1\n\n");
#endif

	rcol->rescol.num_rows = 0;
	rcol->rescol.num_items = 0;
	rcol->rescol.PublicRowCount = 0;

	if (rcol->rescol.selected_rows != NULL) 
		XtFree((char*)rcol->rescol.selected_rows);

	rcol->rescol.selected_rows = NULL;

	if (rcol->rescol.cur_sel_massiv != NULL) 
		XtFree((char*)rcol->rescol.cur_sel_massiv);

	ClearSelectedPositions(rcol);

	rcol->rescol.cur_sel_massiv = NULL;
/*	rcol->rescol.PublicSelectedCount = 0;*/
	rcol->rescol.global_v_shift = 0;
	rcol->rescol.v_shift_in_pix = 0;
	rcol->rescol.pix_shift = 0;
	rcol->rescol.cell_height = 0;
	rcol->rescol.full_height = 0;

#ifdef DEBUG
	printf("\n RCRemoveAllRows complete");
#endif
	return ;
}

static void ClearSelectedPositions(XmNlResColListWidget rcol)
{
	if (!(rcol->rescol.selectedPositions && rcol->rescol.selectedPositionsCount))
		return;

	XtFree((char*) rcol->rescol.selectedPositions);

	rcol->rescol.selectedPositionsCount = 0;
	rcol->rescol.selectedPositions = NULL;
}

static void CopySelectedPositions(XmNlResColListWidget rcol)
{
	if (rcol->rescol.selectedPositions && rcol->rescol.selectedPositionsCount)
	{
		int size = sizeof(int) * rcol->rescol.selectedPositionsCount;
		int * sl = (int *) XtMalloc(size);

		memcpy((char *)sl, (char *) rcol->rescol.selectedPositions, size);
		rcol->rescol.selectedPositions = sl;
	}
}


static void CleanPropertyRow(Widget w)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop;
	int i;


	if (rcol->rescol.prop_data != NULL)
	{
		prop = rcol->rescol.prop_data;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prop[i].gc)
				XFreeGC(XtDisplay(w), prop[i].gc);
			prop[i].gc = NULL;

			if (prop[i].column_tag)
				XtFree(prop[i].column_tag);
			prop[i].column_tag = NULL;

#ifdef USE_XFT
			if (prop[i].xftdraw)
				XftDrawDestroy(prop[i].xftdraw);
			prop[i].xftdraw = NULL;
#endif
		}
		XtFree((char*)rcol->rescol.prop_data);
		rcol->rescol.prop_data = NULL;
	}
}



void XmNlResColDeleteAllRows(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prop = rcol->rescol.prop_data;
	int col;


#ifdef DEBUG
	printf("\n XmNlResColDeleteAllRows started\n\n");
#endif
	prop = rcol->rescol.prop_data;

	RCDeleteAllRows(w);

	for (col = 0; col < rcol->rescol.num_cols; col++)
	{
		prop[col].real_width = DEFAULT_EMPTY_WIDTH + 2*rcol->rescol.margin_w;
		prop[col].new_real_width = 0;
		prop[col].current_width = 0;
		prop[col].drawable_width = 0;
	}

//	RecalcParam(w, TRUE, 0, 0);
//	CalcGeomAfterChangeCells(w);
//	AdjustGlobalShift(w);

	ResizeSliders(w, VerticalScroll);
#ifdef DEBUG
	printf("\n XmNlResColDeleteAllRows complete");
#endif

	rcol->rescol.current_row = -1;

	if (!XtIsRealized(w)) 
		return;
//	RCInternRedisplay(w);
	RCRedrawAllWindow(w);
	return ;
}


void RCRemoveAllRowsListOnly(XmNlResColListWidget rcol)
{
#ifdef DEBUG
	printf("\n RCRemoveAllRowsListOnly started\n\n");
#endif

	if (rcol->rescol.ItemData!=NULL) XtFree((char*)rcol->rescol.ItemData);

#ifdef DEBUG
	printf("\n RCRemoveAllRowsListOnly completed\n");
#endif
	return ;
}



void XmNlResColDeleteRows(Widget w, int position, int rows_num)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell, **new_cell_massiv;
	int row, col;
	int new_row_num;
	Boolean * new_sel_rows;

#ifdef DEBUG
	printf("\n RCRemoveRows started\n\n");
#endif

	if (!rcol->rescol.ItemData || rcol->rescol.num_rows == 0)
		return;
		
	if ((position + rows_num) > rcol->rescol.num_rows)
		return;

	new_row_num = rcol->rescol.num_rows - rows_num;
	for (row = position; row < position + rows_num; row++)
	{
		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
			cell = RCgetCell(w, row, col);
			DeleteCell(rcol, cell);
			if (cell->buf) 
			{
				RCFreeCacheNode(rcol, cell, COL_MAPPED(col));
#ifdef DEBUG
				if (col == 1) 
				{
					printf("---AFTER DELETING\n");
					fflush(stdout);
					CheckCacheChunk(rcol->rescol.prop_data + COL_MAPPED(col));
				}
#endif
			}
		}
		XtFree((char *) rcol->rescol.ItemData[row]);
	}
#ifdef DEBUG
	printf("\n RCRemoveRows stage 1\n\n");
#endif
	new_cell_massiv =(XmNlRCL_Cell **) XtMalloc(new_row_num * sizeof(XmNlRCL_Cell *));
	new_sel_rows = (Boolean *) XtMalloc(new_row_num * sizeof(Boolean));

#ifdef DEBUG
	printf("\n RCRemoveRows stage 2\n\n");
#endif

	if (position > 0)
	{
		memcpy((void *)new_cell_massiv, (void *)rcol->rescol.ItemData,
				position * sizeof(XmNlRCL_Cell *));
		memcpy((void *)new_sel_rows, (void *)rcol->rescol.selected_rows,
				position * sizeof(Boolean));
	}

#ifdef DEBUG
	printf("\n RCRemoveRows stage 3\n\n");
#endif

	if ((rcol->rescol.num_rows - position - rows_num) > 0)
	{
		memcpy((void *) (new_cell_massiv + position),
				(void *) (rcol->rescol.ItemData + position + rows_num),
				(rcol->rescol.num_rows - position - rows_num) * sizeof(XmNlRCL_Cell *));
		memcpy((void *) (new_sel_rows + position),
				(void *) (rcol->rescol.selected_rows + position + rows_num),
				(rcol->rescol.num_rows - position - rows_num) * sizeof(Boolean));
	}

#ifdef DEBUG
	printf("\n RCRemoveRows stage 4\n\n");
#endif

	rcol->rescol.num_items = new_row_num * rcol->rescol.num_cols;
	rcol->rescol.num_rows = new_row_num;
	rcol->rescol.PublicRowCount = new_row_num;

	if (rcol->rescol.ItemData != NULL) 
		XtFree((char*)rcol->rescol.ItemData);
	rcol->rescol.ItemData = new_cell_massiv;

	if (rcol->rescol.selected_rows)
		free(rcol->rescol.selected_rows);
	rcol->rescol.selected_rows = new_sel_rows;	

	RebuildSelectedPositionsOnly(rcol);

#ifdef DEBUG
	printf("\n RCRemoveRows complet");
#endif

	RecalcParam(w, 0, rcol->rescol.num_rows, False, NULL, NULL);
	CalcGeomAfterChangeCells(w);
	AdjustGlobalShift(w);

	rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;
	rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;
	
	ResizeSliders(w, AllScroll);

	if (rcol->rescol.current_row >= rcol->rescol.num_rows)
		rcol->rescol.current_row = rcol->rescol.num_rows - 1;

	RCRedrawAllWindow(w);

	if (rcol->rescol.current_row >= rcol->rescol.TopLine && rcol->rescol.current_row <= rcol->rescol.BotomLine 
			&& rcol->rescol.HasFocus)
		CurrentFrameDraw(w);

	return ;
}

/*
void RCSetPropertyRow(Widget w, int * data)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i;
	XmNlRCL_Property_Row * prop;
#ifdef DEBUG
	printf("\n Prop started");
#endif
	prop=rcol->rescol.prop_data;

	for (i=0; i<rcol->rescol.num_cols; i++)
	{
		prop[i].info_type=data[i];
	}
#ifdef DEBUG
	printf("\n Prop complet");
#endif
	return ;
}
*/

void RCSetAutoresCol(Widget w, int n)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i;
	XmNlRCL_Property_Row * prop;
#ifdef DEBUG
	printf("\n AutoRes started num cols = %d\n", rcol->rescol.num_cols);
#endif
	prop = rcol->rescol.prop_data;
	rcol->rescol.autoresize_col = n;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (i != n) prop[COL_MAPPED(i)].autoresize = False;
		if (i == n) prop[COL_MAPPED(i)].autoresize = True;
	}
#ifdef DEBUG
	printf("\n AutoRes complet\n");
#endif
	return ;
}

/*
void RCSetColSeparator(Widget w, int pos)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col_nums;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * prow;
	int i;
	prow=rcol->rescol.prop_data;
	rcol->rescol.ColumnSeparatorOn=TRUE;
	rcol->rescol.separator_position=pos;

	XSetFunction(XtDisplay(w), rcol->rescol.drawGC, GXinvert);

	ResizeStuff(rcol);

	XDrawLine(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC,
		rcol->rescol.separator_position+rcol->rescol.viewX, rcol->rescol.viewY,
		rcol->rescol.separator_position+rcol->rescol.viewX,
		rcol->rescol.viewY+rcol->rescol.viewHeight);

	XSetFunction(XtDisplay(w), rcol->rescol.drawGC, GXcopy);
	return ;
}

void RCMoveColSeparator(Widget w, int pos)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col_nums;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * prow;
	int i;
	prow=rcol->rescol.prop_data;

	ResizeStuff(rcol);


	XSetFunction(XtDisplay(w), rcol->rescol.drawGC, GXinvert);

	XDrawLine(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC,
		rcol->rescol.separator_position+rcol->rescol.viewX, rcol->rescol.viewY,
		rcol->rescol.separator_position+rcol->rescol.viewX,
		rcol->rescol.viewY+rcol->rescol.viewHeight);

	rcol->rescol.separator_position=pos;

	XDrawLine(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC,
		rcol->rescol.separator_position+rcol->rescol.viewX, rcol->rescol.viewY,
		rcol->rescol.separator_position+rcol->rescol.viewX,
		rcol->rescol.viewY+rcol->rescol.viewHeight);

	XSetFunction(XtDisplay(w), rcol->rescol.drawGC, GXcopy);

	return ;
}


void RCEraseColSeparator(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col_nums;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * prow;
	int i;
	prow=rcol->rescol.prop_data;


	ResizeStuff(rcol);


	rcol->rescol.separator_position=-1;
	rcol->rescol.ColumnSeparatorOn=FALSE;


	return ;
}
*/


void RCSetColSize(Widget w, Dimension * size)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int col_nums, delta = 0;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * prow;
	int i, ChangedCol = -1, NewWidth = 0;
	Boolean ColIncremented, OnlyOneColChanged = True, ShiftChanged = False;

	prow = rcol->rescol.prop_data;


	col_nums = rcol->rescol.num_cols;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (size[i] != 0)
		{
			if (size[i] >= prow[COL_MAPPED(i)].current_width)
			{
				ColIncremented = True;
				delta = size[i] - prow[COL_MAPPED(i)].current_width;
			}
			else
			{
				ColIncremented = False;
				delta = prow[COL_MAPPED(i)].current_width - size[i];
			}
			prow[COL_MAPPED(i)].current_width = size[i];
			if (ChangedCol != -1)
				OnlyOneColChanged = False;
			ChangedCol = i;
		}
		NewWidth = NewWidth + prow[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf(">>>>>>>RCSetColSize: col %d width = %d - %d\n", i, prow[COL_MAPPED(i)].current_width, size[i]);
#endif
	}
	if (rcol->rescol.global_h_shift + rcol->rescol.viewWidth > NewWidth)
	{
		rcol->rescol.global_h_shift = NewWidth - rcol->rescol.viewWidth;
		if (rcol->rescol.global_h_shift < 0)
			rcol->rescol.global_h_shift = 0;
		ShiftChanged = True;
	}

	ResizeStuff(rcol);
	CalcGeomAfterResize(w);
	CalcColParam(w);
	ResizeSliders(w, HorizontalScroll);
	
	if (rcol->rescol.VisibilityState != VisibilityUnobscured ||
		OnlyOneColChanged == False || ShiftChanged)
	{
		RCRedrawAllWindow(w);
		CurrentFrameDraw(w);
		return ;
	}

	if (ColIncremented)
	{
		if (rcol->rescol.render_order == LtoR_render)
		{
			if (ChangedCol + 1 < rcol->rescol.num_cols && 
				prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
			{
				XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
							prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift - delta, 0, 
							rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift) - delta,
							rcol->rescol.viewHeight,
							prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift, 0);
			}
			RCRedrawColRegion(w, prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift, prow[COL_MAPPED(ChangedCol)].current_width);
		}
		else
		{
			if (ChangedCol + 1 < rcol->rescol.num_cols && 
				rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift) > 0) 
			{
				XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
							delta, 0,
							rcol->rescol.viewWidth - 
							(prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift) -
							delta,
							rcol->rescol.viewHeight,
							0, 0);
			}
			RCRedrawColRegion(w, prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift, prow[COL_MAPPED(ChangedCol)].current_width);
		}
	}
	else
	{
		if(prow[COL_MAPPED(ChangedCol)].info_type == XmPIXMAP)
		{
			if (rcol->rescol.render_order == LtoR_render)
			{
				if (ChangedCol + 1 < rcol->rescol.num_cols && 
					prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
						XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
								prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift + delta, 0, 
								rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift),
								rcol->rescol.viewHeight,
								prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift, 0);
				RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				RCRedrawColRegion(w, prow[COL_MAPPED(ChangedCol)].x, delta);
			}
			else
			{
				if (ChangedCol + 1 < rcol->rescol.num_cols && 
					prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
						XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
									0, 0,
									rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift) - delta,
									rcol->rescol.viewHeight,
									delta, 0);
				RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				RCRedrawColRegion(w, prow[COL_MAPPED(ChangedCol)].x, delta);
			}
		}
		else
		{
			if (rcol->rescol.render_order == LtoR_render)
			{
				if (prow[COL_MAPPED(ChangedCol)].align_type==XmALIGNMENT_BEGINNING)
				{	
					if (ChangedCol + 1 < rcol->rescol.num_cols && 
						prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
									prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.margin_w - rcol->rescol.global_h_shift + delta, 0, 
									rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.margin_w - rcol->rescol.global_h_shift),
									rcol->rescol.viewHeight,
									prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.margin_w - rcol->rescol.global_h_shift, 0);
					RCRedrawColRegion(w, rcol->rescol.viewWidth - rcol->rescol.margin_w - delta, delta);
				}
				else
				{
					if (ChangedCol + 1 < rcol->rescol.num_cols && 
						prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
					{
							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
									prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift + delta, 0, 
									rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol)].x - delta - rcol->rescol.global_h_shift),
									rcol->rescol.viewHeight,
									prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift, 0);

							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
									prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift + prow[COL_MAPPED(ChangedCol)].current_width + delta - rcol->rescol.margin_w, 0, 
									delta,
									rcol->rescol.viewHeight,
									prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift, 0);

					}
					RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				}
			}
			else
			{
				if (prow[COL_MAPPED(ChangedCol)].align_type==XmALIGNMENT_BEGINNING)
				{	
					if (ChangedCol + 1 < rcol->rescol.num_cols && 
						prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
					{
							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
										0, 0,
										rcol->rescol.viewWidth - 
										(prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift) -
										delta,
										rcol->rescol.viewHeight,
										delta, 0);
							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
										rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift) - rcol->rescol.margin_w, 0,
										rcol->rescol.margin_w, rcol->rescol.viewHeight,
										rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift), 0);
					}

					RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				}
				else
				{
					if (ChangedCol + 1 < rcol->rescol.num_cols && 
						prow[COL_MAPPED(ChangedCol + 1)].x - rcol->rescol.global_h_shift < rcol->rescol.viewWidth) 
					{
							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
										0, 0,
										rcol->rescol.viewWidth - 
										(prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift) -
										delta,
										rcol->rescol.viewHeight,
										delta, 0);

							XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC, 
										rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift) - rcol->rescol.margin_w, 0,
										rcol->rescol.margin_w, rcol->rescol.viewHeight,
										rcol->rescol.viewWidth - (prow[COL_MAPPED(ChangedCol)].x - rcol->rescol.global_h_shift) - rcol->rescol.margin_w, 0);
					}

					RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				}
			}
		}
	}

	CurrentFrameDraw(w);
	return ;
}



void RCSetCell(Widget w, int row, int col, XmNlCell * cell_data, unsigned char valuemask)
{

	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row * prow = rcol->rescol.prop_data;
	XmNlRCL_Cell  * cell;
	CacheBufElement * pp;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean ColChange = False;
	Boolean HeightChange = False;
	IconInfo * icon;

#ifdef DEBUG
	printf("\n RCSeCell started");
	fflush(stdout);
#endif
	cell = RCgetCell(w, row, col);
	if (!cell) return;
#ifdef DEBUG
	printf("\n RCSetCell row=%i col=%i", row, col);
	fflush(stdout);
	printf("SETCELL0 %d %d %s\n", col, row, cell->text);
	printf("SETCELL %s\n", cell_data->text);
#endif

	if (prow[COL_MAPPED(col)].info_type == XmPIXMAP)
	{
/** Pixmap column **/
		if (valuemask & CellPixmap)
		{
			if (PIX_FOUND(cell_data->pixmap))
			{
				if (PIX_FOUND(cell_data->mask)) icon = AddIconToList(w, cell_data->pixmap, cell_data->mask);
				else icon = AddIconToList(w, cell_data->pixmap, XmUNSPECIFIED_PIXMAP);
				if (icon)
				{
					cell->icon = icon;
					icon->use_counter ++;
				}
			}
			else cell->icon = NULL;
		}
	}
	else
	{
/** Text column **/
		if (valuemask & CellCharString) cell->text = cell_data->text;
		if (valuemask & CellXmString)
		{
			if (cell_data->xmlabel)
			{
				if (cell->xmlabel)
					XmStringFree(cell->xmlabel);
				cell->xmlabel = XmStringCopy(cell_data->xmlabel);
#ifdef FAST_XMSTRING_RENDERING
				if (cell->complabel) 
					DestroySegmentedXmString(cell->complabel);
				cell->complabel = CreateSegmentedXmString(cell_data->xmlabel);
#endif
			}
			else
			{
				cell->xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
				cell->complabel = NULL;
#endif
			}
//			cell[j].label_h = XmStringHeight(rcol->rescol.font_list, cell[j].xmlabel);
//			cell[j].label_w = XmStringWidth(rcol->rescol.font_list, cell[j].xmlabel);
			if (cell->buf)
			{
				pp = (CacheBufElement *) cell->buf;
				pp->cell = NULL;
				cell->buf = NULL;
			}
		}
	}

	if (valuemask & CellSelection)
	{
		if (cell_data->selected)
			cell->selected = True;
		else
			cell->selected = True;
	}


	if (valuemask & CellAlignment) cell->alignment = cell_data->alignment;
	else cell->alignment = XmALIGNMENT_UNSPECIFIED;

	if (valuemask & CellUserData) cell->UserDataPointer = cell_data->UserDataPointer;


#ifdef DEBUG
	printf("\n RCSetCell complet");
	fflush(stdout);
#endif
	RecalcParam(w, row, row+1, False, &HeightChange, &ColChange);
	if (ColChange) GeomChanged = CalcGeomPostInit(w);

	if (HeightChange || GeomChanged)
	{
		AdjustGlobalShift(w);
		RedrawNeed = True;
	}

	CalcColParam(w);

	if (row >= rcol->rescol.TopLine && row <= rcol->rescol.BotomLine)
		RedrawNeed=TRUE;
	ResizeSliders(w, AllScroll);
/* !!!!!!!!!!!!!!!!!! Need any action */
//	if ( GeomChanged ) 	RefreshTitleBar(rcol);
	if (!XtIsRealized(w))
		return ;
	if (RedrawNeed || GeomChanged) RCRedrawAllWindow(w);

	return ;
}

void RCSetSelectedItems(Widget w, int num, int * data)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int rows_num, i;
	XmNlRCL_Cell  * cell;

	rows_num = rcol->rescol.num_rows;
	for (i = 0; i < rows_num; i++)
	{
		rcol->rescol.selected_rows[i] = False;
		cell = rcol->rescol.ItemData[i];
		cell[COL_MAPPED(0)].selected = True;
	}
	for (i = 0; i < num; i++)
	{
		if (data[i] >= 0 &&  data[i] < rcol->rescol.num_rows)
		{
			rcol->rescol.selected_rows[data[i]] = True;
			cell = rcol->rescol.ItemData[data[i]];
			cell[COL_MAPPED(0)].selected = True;
		}
	}
//	if (rcol->rescol.item_data!=NULL) PutToPixFullRedraw(w);
//	if (XtIsRealized(w) && rcol->rescol.buffering) RCInternRedisplay(w);
	if (XtIsRealized(w) && !rcol->rescol.buffering) RCRedrawAllWindow(w);
	return ;
}

void XmNlresColGetSelectedRows(Widget w, int * count, int ** select_numbers)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i, n, *selected;

	*count = 0;

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i])
			(*count)++;
	}

	if (*count)
	{
		selected = malloc(sizeof(int) * *count);
		n = 0;
		for (i = 0; i < rcol->rescol.num_rows; i++)
		{
			if (rcol->rescol.selected_rows[i])
			{
				selected[n] = i;
				n++;
			}
		}
		*select_numbers = selected;
	}
	else
		*select_numbers = NULL;	 

	return ;
}


XmNlCell * RCGetSelectedCells(Widget w, int *count)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	XmNlCell *SelectedCells;
	int i, j, counter=0;
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i] == True) counter++;
	}
	*count = counter;

	if (counter == 0)
	{
//		Cells = NULL;
		return NULL;
	}
	if (rcol->rescol.selected_item != NULL) free(rcol->rescol.selected_item);
	rcol->rescol.selected_item = (XmNlCell *)malloc(rcol->rescol.num_cols*counter*sizeof(XmNlCell));

//	cell=rcol->rescol.item_data;
	SelectedCells = rcol->rescol.selected_item;
	counter = 0;
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i]==True)
		{
			for(j = 0; j < rcol->rescol.num_cols; j++)
			{
				cell = RCgetCell(w, i, j);
//				SelectedCells[counter]=malloc(sizeof(XmNl_Cell));
				SelectedCells[counter].pixmap=cell->pixmap;
				SelectedCells[counter].mask=cell->mask;
				SelectedCells[counter].text=cell->text;
				SelectedCells[counter].UserDataPointer=cell->UserDataPointer;
				counter++;
			}
		}
	}

//	Cells=rcol->rescol.selected_item;
//				printf("----------sel text %s", Cells[0].UserDataPointer);
//				fflush(stdout);
	return rcol->rescol.selected_item;
}



static void CalcColParam(Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i, j, y, k;
	XRectangle clip;
	int width;

    rw = rcol->rescol.prop_data;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		rw[COL_MAPPED(i)].clip.y = rcol->rescol.viewY;
		rw[COL_MAPPED(i)].clip.height = rcol->rescol.viewHeight;

		if (rcol->rescol.render_order == LtoR_render)
			rw[COL_MAPPED(i)].xx1 = rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rcol->rescol.viewX + rcol->rescol.margin_w;
		else
			rw[COL_MAPPED(i)].xx1 = rcol->rescol.viewWidth - (rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift)
						+ rcol->rescol.viewX + rcol->rescol.margin_w - rw[COL_MAPPED(i)].current_width;

		width = rw[COL_MAPPED(i)].current_width - 2 * rcol->rescol.margin_w;
		rw[COL_MAPPED(i)].xx2 = rw[COL_MAPPED(i)].xx1 + width;

		if (rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift > rcol->rescol.viewX + rcol->rescol.viewWidth
				|| rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rw[COL_MAPPED(i)].current_width < rcol->rescol.viewX)
/* Column completely not viewed */
			rw[COL_MAPPED(i)].col_displayed = False ;
		else
			rw[COL_MAPPED(i)].col_displayed = True;

		if (rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rcol->rescol.margin_w > rcol->rescol.viewX + rcol->rescol.viewWidth
				|| rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rw[COL_MAPPED(i)].current_width - rcol->rescol.margin_w < rcol->rescol.viewX)
		{
/* Info area of column completely not viewed */
			rw[COL_MAPPED(i)].clip_displayed = False ;

			rw[COL_MAPPED(i)].clip.x = 0;
			rw[COL_MAPPED(i)].clip.width = 0;
			continue ;
		}
		else
			rw[COL_MAPPED(i)].clip_displayed = True;



		if (rw[COL_MAPPED(i)].xx1 > rcol->rescol.viewX) 
			rw[COL_MAPPED(i)].clip.x = rw[COL_MAPPED(i)].xx1;
		else 
			rw[COL_MAPPED(i)].clip.x = rcol->rescol.viewX;

		if (rw[COL_MAPPED(i)].xx2 < (rcol->rescol.viewX + rcol->rescol.viewWidth))
			rw[COL_MAPPED(i)].clip.width = rw[COL_MAPPED(i)].xx2 - rw[COL_MAPPED(i)].clip.x;
		else
			rw[COL_MAPPED(i)].clip.width = rcol->rescol.viewX + rcol->rescol.viewWidth - rw[COL_MAPPED(i)].clip.x;

		XSetClipRectangles(XtDisplay(w), rw[COL_MAPPED(i)].gc,
				0, 0, &((rw + COL_MAPPED(i))->clip), 1, Unsorted);

#ifdef USE_XFT
		if (rw[COL_MAPPED(i)].xftdraw)
		{
			XftDrawSetClip(rw[COL_MAPPED(i)].xftdraw, NULL);
			XftDrawSetClipRectangles(rw[COL_MAPPED(i)].xftdraw, 0, 0, &((rw + COL_MAPPED(i))->clip), 1);
		}
#endif
				
	}

#ifdef CalcColParamDEBUG
	printf("CalcColParam: ViewWidth %d shift %d \n", rcol->rescol.viewWidth, rcol->rescol.global_h_shift);
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		printf("CalcColParam: col %d clip.x %d clip.w %d xx1 %d xx2 %d\n", i, rw[COL_MAPPED(i)].clip.x, rw[COL_MAPPED(i)].clip.width, rw[COL_MAPPED(i)].xx1, rw[COL_MAPPED(i)].xx2);
	}
#endif

	return ;
}


static void RecalcParam(Widget w, int start, int end, Boolean font_change, Boolean * h_change, Boolean * col_change)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	unsigned int width, height, bw, depth;
	int tmp_w, tmp_h;
	int i;
	int string_h=0;
	int string_w=0;
	int j=0;
	IconInfo * icon;

#ifdef DEBUG
	printf("\n RecalcParam +\n");
	printf("\n Num items %d Num cols %d\n", rcol->rescol.num_items, rcol->rescol.num_cols);
#endif


	if (rcol->rescol.num_items == 0 || rcol->rescol.num_cols == 0) return;

	rcol->rescol.full_selection_w=rcol->rescol.select_line_w+rcol->rescol.select_line_margin;
	rcol->rescol.full_margin_h=rcol->rescol.margin_h;
	rcol->rescol.full_margin_w=rcol->rescol.margin_w;
	rcol->rescol.full_pl_margin=rcol->rescol.margin_w + rcol->rescol.full_selection_w;


	if (h_change) *h_change = False;
	if (col_change) *col_change = False;

	if (start = 0 && end == rcol->rescol.num_rows) tmp_h = 0;
	else tmp_h = rcol->rescol.cell_height;

	rw = rcol->rescol.prop_data;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (rcol->rescol.TreeMode && i == 0)
			continue ;
		if (start = 0 && end == rcol->rescol.num_rows) tmp_w = 0;
		else tmp_w = rw[COL_MAPPED(i)].real_width;

/* In column pixmaps */

		if (rw[COL_MAPPED(i)].info_type == XmPIXMAP)
		{
			for (j = start; j < end; j++)
			{
				cell = RCgetCell(w, j, i);
				icon = cell->icon;
				if (icon)
				{
					width = icon->width;
					height = icon->height;
				}
				else
				{
					width = 0;
					height = 0;
				}
				if ((width + 2*rcol->rescol.margin_w) > tmp_w) tmp_w = width + 2*rcol->rescol.margin_w;
				if ((height + 2*rcol->rescol.full_margin_h) > tmp_h) tmp_h = height + 2*rcol->rescol.full_margin_h;

			}
			if (start = 0 && end == rcol->rescol.num_rows)
			{
				rw[i].real_width = tmp_w;
			}
			else
			{
				if (tmp_w > rw[COL_MAPPED(i)].real_width)
				{
					rw[COL_MAPPED(i)].real_width = tmp_w;
					if (col_change) *col_change = True;
				}
			}
		}
/* In column text   */
		if (rw[COL_MAPPED(i)].info_type == XmSTRING)
		{
			for (j = start; j < end; j++)
			{
				cell = RCgetCell(w, j, i);
				if (font_change) 
				{
					cell->label_w = XmStringWidth(rcol->rescol.font_list, cell->xmlabel);
					cell->label_h = XmStringHeight(rcol->rescol.font_list, cell->xmlabel);
#ifdef FAST_XMSTRING_RENDERING
/*					SegmentedXmStringExtent2(XtDisplay(w), rcol->rescol.font_list, 
										cell->complabel, 
										&(cell->label_w), &(cell->label_h));*/
					SegmentedXmStringExtent3(XtDisplay(w), rcol->rescol.font_list, 
										cell->complabel, 
										&(cell->label_w), &(cell->label_h), rcol->rescol.idxRend);
#endif
				}
				if ((cell->label_w + 2*rcol->rescol.margin_w) > tmp_w) tmp_w = cell->label_w + 2*rcol->rescol.margin_w;
				if ((cell->label_h + 2*rcol->rescol.full_margin_h) > tmp_h) tmp_h = cell->label_h + 2*rcol->rescol.full_margin_h;
			}
			if (start = 0 && end == rcol->rescol.num_rows)
			{
				rw[COL_MAPPED(i)].real_width=tmp_w;
			}
			else
			{
				if (tmp_w > rw[COL_MAPPED(i)].real_width)
				{
					rw[COL_MAPPED(i)].real_width=tmp_w;
					if (col_change) *col_change = True;
				}
			}
		}
	}

	if (start = 0 && end == rcol->rescol.num_rows)
	{
		rcol->rescol.cell_height = tmp_h;
		if (rcol->rescol.TreeMode)
			CreateLinePix(rcol);
	}
	else
	{
		if (tmp_h > rcol->rescol.cell_height)
		{
			rcol->rescol.cell_height = tmp_h;
			if (rcol->rescol.TreeMode)
				CreateLinePix(rcol);
			if (h_change) *h_change = True;
		}
	}
#ifdef DEBUG
	printf("\n cell_recalc\n");
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
	printf("\n Column=%d w=%d\n", i, rw[COL_MAPPED(i)].real_width);
	}
#endif
}

Boolean CalcGeomInit( Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int i, delta, delta2, n, m;
	Dimension tmp_w;
	int res=NO_ACTION_NEEDED;
	Boolean Redraw=FALSE;
	tmp_w=0;
	delta=0;

#ifdef DEBUG
	printf("\n XmResColList: CalcGeom started\n");
#endif

	if (rcol->rescol.num_cols == 0) return False;

	rw = rcol->rescol.prop_data;


	/* Calculate horizontal offset for all columns and full width*/

	n = rcol->rescol.autoresize_col;
	m = rcol->rescol.num_cols - 1;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (rw[COL_MAPPED(i)].current_width != rw[COL_MAPPED(i)].real_width)
		{
			rw[COL_MAPPED(i)].current_width = rw[COL_MAPPED(i)].real_width;
			Redraw = TRUE;
		}
		tmp_w = tmp_w+rw[COL_MAPPED(i)].current_width;
		rw[COL_MAPPED(i)].x = delta;
		delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf("\nCalcGeom(1): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
	}
#ifdef DEBUG
	printf("\nCalcGeom: full_width=%d\n", tmp_w);
	printf("\nCalcGeom: viewWidth=%d\n", rcol->rescol.viewWidth);
#endif
	rcol->rescol.full_width=tmp_w;

	/* Adjust size of autoresize & last column for current viewable size */

	if (rcol->rescol.TreeMode && rcol->rescol.num_cols == 1)
	{
		if (rw[COL_MAPPED(0)].current_width < rcol->rescol.viewWidth)
		{
			rw[COL_MAPPED(0)].current_width = rcol->rescol.viewWidth;
			rcol->rescol.full_width = rcol->rescol.viewWidth;
		}
		rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;

#ifdef DEBUG
	printf("++++SuperCalcGeom: full_width=%d 1 row = %d\n", rcol->rescol.full_width, rw[0].current_width);
#endif


		rcol->rescol.full_height=rcol->rescol.cell_height*rcol->rescol.num_rows;

		rcol->rescol.scroll_height=rcol->rescol.full_height-rcol->rescol.viewHeight;
		
		rcol->rescol.pix_buf_row=rcol->rescol.viewHeight/rcol->rescol.cell_height+4;
		rcol->rescol.pix_buf_h=rcol->rescol.pix_buf_row*rcol->rescol.cell_height;
		return False;
	}

	if (tmp_w < rcol->rescol.viewWidth)
	{
		rw[COL_MAPPED(n)].current_width = rw[COL_MAPPED(n)].current_width+(rcol->rescol.viewWidth-tmp_w);
		Redraw = TRUE;
		tmp_w = 0;
		delta = 0;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
			rw[COL_MAPPED(i)].x = delta;
			delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
		}
		rcol->rescol.full_width=tmp_w;

	}
	rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;


	rcol->rescol.full_height=rcol->rescol.cell_height*rcol->rescol.num_rows;

	rcol->rescol.scroll_height=rcol->rescol.full_height-rcol->rescol.viewHeight;


	return Redraw;
}


Boolean CalcGeomPostInit( Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int i, delta, delta2, n, m;
	Dimension tmp_w;
	int res=NO_ACTION_NEEDED;
	Boolean Redraw=FALSE;
	tmp_w=0;
	delta=0;

#ifdef DEBUG
	printf("\n XmResColList: CalcGeom started\n");
#endif

	if (rcol->rescol.num_cols == 0) 
		return False;

	rw = rcol->rescol.prop_data;


	/* Calculate horizontal offset for all columns and full width*/

	if (rcol->rescol.autoresize_col != XmNlastColumn && rcol->rescol.autoresize_col < rcol->rescol.num_cols)
		n = rcol->rescol.autoresize_col;
	else
		n = rcol->rescol.num_cols - 1;

	m = rcol->rescol.num_cols - 1;



	if (rcol->rescol.TreeMode && rcol->rescol.num_cols == 1)
	{
		if (rw[COL_MAPPED(0)].real_width != rcol->rescol.viewWidth)
		{
			if (rw[COL_MAPPED(0)].real_width >= rcol->rescol.viewWidth) 
				rw[COL_MAPPED(0)].current_width = rw[COL_MAPPED(0)].real_width;
			else
				rw[COL_MAPPED(0)].current_width = rcol->rescol.viewWidth;

			rcol->rescol.full_width = rw[COL_MAPPED(0)].current_width;
			Redraw = TRUE;
		}
		rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;

#ifdef DEBUG
	printf("++++SuperCalcGeom: real_width = %d full_width=%d 1 view = %d\n", rw[COL_MAPPED(0)].real_width, rcol->rescol.full_width, rcol->rescol.viewWidth);
#endif

		rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
		rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
		return Redraw;
	}


	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
//		if ((rw[i].current_width != rw[i].real_width) && (rw[i].info_type == XmPIXMAP || rw[i].info_type == XmSTRING))
		if (rw[COL_MAPPED(i)].current_width != rw[COL_MAPPED(i)].real_width)
		{
			rw[COL_MAPPED(i)].current_width = rw[COL_MAPPED(i)].real_width;
			Redraw = TRUE;
		}
		tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
		rw[COL_MAPPED(i)].x = delta;
		delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf("\nCalcGeom(1): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
	}
#ifdef DEBUG
	printf("\nCalcGeom: full_width=%d\n", tmp_w);
	printf("\nCalcGeom: viewWidth=%d\n", rcol->rescol.viewWidth);
#endif
	rcol->rescol.full_width = tmp_w;

	/* Adjust size of autoresize & last column for current viewable size */


	if (tmp_w < rcol->rescol.viewWidth)
	{
		rw[COL_MAPPED(n)].current_width = rw[COL_MAPPED(n)].current_width + (rcol->rescol.viewWidth - tmp_w);
		Redraw = TRUE;
		tmp_w = 0;
		delta = 0;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
			rw[COL_MAPPED(i)].x = delta;
			delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d mapped from %d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width, COL_MAPPED(i));
#endif
		}
		rcol->rescol.full_width = tmp_w;
	}
	rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;

	rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;

	rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;

	return Redraw;
}




Boolean SuperCalcGeom( Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int i, delta, delta2, n, m;
	Dimension tmp_w;
	int res=NO_ACTION_NEEDED;
	Boolean Redraw=FALSE;
	tmp_w=0;
	delta=0;

#ifdef DEBUG
	printf("\n XmResColList: CalcGeom started\n");
#endif

//	if (rcol->rescol.num_items==0 || rcol->rescol.num_cols==0) return False;
	if (rcol->rescol.num_cols == 0) return False;

	rw =rcol->rescol.prop_data;

//	ResizeStuff(rcol);

	if (rcol->rescol.TreeMode && rcol->rescol.num_cols == 1)
	{
		if (rw[COL_MAPPED(0)].current_width < rcol->rescol.viewWidth)
		{
			rw[COL_MAPPED(0)].current_width = rcol->rescol.viewWidth;
			rcol->rescol.full_width = rcol->rescol.viewWidth;
		}
		rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;

#ifdef DEBUG
	printf("++++SuperCalcGeom: full_width=%d 1 row = %d\n", rcol->rescol.full_width, rw[COL_MAPPED(0)].current_width);
#endif


		rcol->rescol.full_height=rcol->rescol.cell_height*rcol->rescol.num_rows;

		rcol->rescol.scroll_height=rcol->rescol.full_height-rcol->rescol.viewHeight;
		rcol->rescol.pix_buf_row=rcol->rescol.viewHeight/rcol->rescol.cell_height+4;
		rcol->rescol.pix_buf_h=rcol->rescol.pix_buf_row*rcol->rescol.cell_height;
		return False;
	}

	/* Calculate horizontal offset for all columns and full width*/

	n = rcol->rescol.autoresize_col;
	m = rcol->rescol.num_cols - 1;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (rw[COL_MAPPED(i)].current_width != rw[COL_MAPPED(i)].real_width)
		{
			rw[COL_MAPPED(i)].current_width = rw[COL_MAPPED(i)].real_width;
			Redraw = TRUE;
		}
		tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
		rw[COL_MAPPED(i)].x = delta;
		delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf("\nCalcGeom(1): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
	}
#ifdef DEBUG
	printf("\nCalcGeom: full_width=%d\n", tmp_w);
	printf("\nCalcGeom: viewWidth=%d\n", rcol->rescol.viewWidth);
#endif
	rcol->rescol.full_width = tmp_w;

	/* Adjust size of autoresize & last column for current viewable size */

	if (tmp_w < rcol->rescol.viewWidth)
	{
		rw[COL_MAPPED(n)].current_width = rw[COL_MAPPED(n)].current_width + (rcol->rescol.viewWidth-tmp_w);
		Redraw = TRUE;
		tmp_w = 0;
		delta = 0;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
			rw[COL_MAPPED(i)].x = delta;
			delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
		}
		rcol->rescol.full_width=tmp_w;

	}
	rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;


	rcol->rescol.full_height=rcol->rescol.cell_height*rcol->rescol.num_rows;

	rcol->rescol.scroll_height=rcol->rescol.full_height-rcol->rescol.viewHeight;


	return Redraw;
}




static Boolean CalcGeomAfterChangeCells( Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int i, delta, delta2, n, m;
	Dimension tmp_w;
	Boolean res = False;
	tmp_w=0;
	delta=0;

#ifdef DEBUG
	printf("\n XmResColList: CalcGeom started\n");
#endif

	if (rcol->rescol.num_items == 0 || rcol->rescol.num_cols == 0) return res;

	rw = rcol->rescol.prop_data;

	ResizeStuff(rcol);

	rcol->rescol.full_height = rcol->rescol.cell_height*rcol->rescol.num_rows;

	rcol->rescol.scroll_height = rcol->rescol.full_height-rcol->rescol.viewHeight;
	rcol->rescol.pix_buf_row = rcol->rescol.viewHeight/rcol->rescol.cell_height + 4;
	rcol->rescol.pix_buf_h = rcol->rescol.pix_buf_row*rcol->rescol.cell_height;

	if (rcol->rescol.pix_buf_h != rcol->rescol.drawable_height)
	{
		res=True;
		rcol->rescol.drawable_height_changed=True;
	}

	/* Calculate horizontal offset for all columns and full width*/

	if (rcol->rescol.autoresize_col >= 0 && (rcol->rescol.autoresize_col < (rcol->rescol.num_cols - 1)))
		n = rcol->rescol.autoresize_col;
	else
		n = rcol->rescol.num_cols - 1;

	m = rcol->rescol.num_cols - 1;

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if (rw[COL_MAPPED(i)].current_width < rw[COL_MAPPED(i)].real_width)
			/*if(rw[i].current_width==0 || i==m)*/ rw[i].current_width=rw[i].real_width;
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
		rw[COL_MAPPED(i)].x = delta;
		delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
			printf("\nCalcGeom(1): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
			}
#ifdef DEBUG
	printf("\nCalcGeom: full_width=%d\n", tmp_w);
	printf("\nCalcGeom: viewWidth=%d\n", rcol->rescol.viewWidth);
#endif
	rcol->rescol.full_width=tmp_w;

	/* Adjust size of autoresize & last column for current viewable size */

	if (tmp_w < rcol->rescol.viewWidth)
	{
		rw[COL_MAPPED(n)].current_width = rw[COL_MAPPED(n)].current_width + rcol->rescol.viewWidth - tmp_w;
		res = TRUE;
		tmp_w = 0;
		delta = 0;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
			rw[COL_MAPPED(i)].x = delta;
			delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
		}
		rcol->rescol.full_width = tmp_w;

	}
	rcol->rescol.scroll_width = rcol->rescol.full_width-rcol->rescol.viewWidth;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		if(rw[COL_MAPPED(i)].current_width > rw[COL_MAPPED(i)].drawable_width)
		{
			res = True;
			rw[COL_MAPPED(i)].drawable_width_changed = True;
			rcol->rescol.drawable_width_changed = True;
		}
		rw[COL_MAPPED(i)].col_displayed = False;
		rw[COL_MAPPED(i)].clip_displayed = False;
		if (rw[COL_MAPPED(i)].x < rcol->rescol.viewX + rcol->rescol.viewWidth &&
			rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width > rcol->rescol.viewX)
		{
			rw[COL_MAPPED(i)].col_displayed = True;
			rw[COL_MAPPED(i)].clip_displayed = True;
			if (rw[COL_MAPPED(i)].x + rcol->rescol.margin_w > rcol->rescol.viewX) 
				rw[COL_MAPPED(i)].clip.x = rw[COL_MAPPED(i)].x;
			else 
				rw[COL_MAPPED(i)].clip.x = rcol->rescol.viewX;
			rw[COL_MAPPED(i)].clip.y = rcol->rescol.viewY;
			if ((rw[COL_MAPPED(i)].clip.x+rw[COL_MAPPED(i)].current_width) < (rcol->rescol.viewX+rcol->rescol.viewWidth))
				rw[COL_MAPPED(i)].clip.width = rw[i].current_width;
			else 
				rw[COL_MAPPED(i)].clip.width = rcol->rescol.viewX + rcol->rescol.viewWidth - rw[COL_MAPPED(i)].clip.x;
			if (rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width < rw[COL_MAPPED(i)].clip.x + rw[COL_MAPPED(i)].clip.width)
				rw[COL_MAPPED(i)].clip.width = rw[COL_MAPPED(i)].x + rw[COL_MAPPED(i)].current_width - rw[COL_MAPPED(i)].clip.x - rcol->rescol.margin_w;
			rw[i].clip.height = rcol->rescol.viewHeight;
			if (rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rcol->rescol.margin_w > rcol->rescol.viewWidth ||
				rw[COL_MAPPED(i)].x - rcol->rescol.global_h_shift + rw[COL_MAPPED(i)].current_width - rcol->rescol.margin_w < 0)
								rw[COL_MAPPED(i)].clip_displayed = FALSE;
		}
	}

	return res;
}



static Boolean CalcGeomAfterResize( Widget w)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int i, delta, delta2, n, m;
	Dimension tmp_w;
	Boolean res = False;
	tmp_w = 0;
	delta = 0;

#ifdef DEBUG
	printf("\n XmResColList: CalcGeom started\n");
#endif

//	if (rcol->rescol.num_items==0 || rcol->rescol.num_cols==0) return res;
	if (rcol->rescol.num_cols == 0 || rcol->rescol.num_rows == 0) return res;

	rw=rcol->rescol.prop_data;

	ResizeStuff(rcol);

	rcol->rescol.full_height=rcol->rescol.cell_height*rcol->rescol.num_rows;

	rcol->rescol.scroll_height=rcol->rescol.full_height-rcol->rescol.viewHeight;
	rcol->rescol.pix_buf_row=rcol->rescol.viewHeight/rcol->rescol.cell_height+4;
	rcol->rescol.pix_buf_h=rcol->rescol.pix_buf_row*rcol->rescol.cell_height;


	/* Calculate horizontal offset for all columns and full width*/

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{

		if(rw[COL_MAPPED(i)].current_width == 0) rw[COL_MAPPED(i)].current_width = rw[COL_MAPPED(i)].real_width;
		tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
		rw[COL_MAPPED(i)].x = delta;
		delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
		printf("\nCalcGeom(1): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
	}
#ifdef DEBUG
	printf("\nCalcGeom: full_width=%d\n", tmp_w);
	printf("\nCalcGeom: viewWidth=%d\n", rcol->rescol.viewWidth);
#endif
	rcol->rescol.full_width=tmp_w;

	/* Adjust size of autoresize column for current viewable size */
/*
	if (tmp_w >= rcol->rescol.viewWidth)
	{
		n = rcol->rescol.autoresize_col;
		m = rcol->rescol.num_cols - 1;
		if ( rw[n].current_width > rw[n].real_width)
		{
			delta2 = rw[n].current_width - rw[n].real_width;
			delta = tmp_w - rcol->rescol.viewWidth;
			if (delta2 >= delta) delta2 = delta;
			delta=0;
			tmp_w=0;
			for (i=0; i<rcol->rescol.num_cols; i++)
			{
				if(rw[i].autoresize==True) rw[i].current_width=rw[i].current_width-delta2;
				tmp_w=tmp_w+rw[i].current_width;
				rw[i].x=delta;
				delta=delta+rw[i].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d\n", i, rw[i].x, i, rw[i].current_width);
#endif
			}
			rcol->rescol.full_width=tmp_w;
		}
		rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;
	}
	else
	{
		delta2=rcol->rescol.viewWidth-tmp_w;
		delta=0;
		tmp_w=0;
		rcol->rescol.scroll_width=rcol->rescol.viewWidth;
		for (i=0; i<rcol->rescol.num_cols; i++)
		{
			if(rw[i].autoresize==True) rw[i].current_width=rw[i].current_width+delta2;
			tmp_w=tmp_w+rw[i].current_width;
			rw[i].x=delta;
			delta=delta+rw[i].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(2): x%d=%d \t width%d=%d\n", i, rw[i].x, i, rw[i].current_width);
#endif
		}
		rcol->rescol.full_width=tmp_w;

	}
*/

	if (tmp_w < rcol->rescol.viewWidth)
	{
		n = rcol->rescol.autoresize_col;
		m = rcol->rescol.num_cols - 1;

		rw[COL_MAPPED(n)].current_width = rw[COL_MAPPED(n)].current_width + rcol->rescol.viewWidth - tmp_w;

		delta = 0;
		tmp_w = 0;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			tmp_w = tmp_w + rw[COL_MAPPED(i)].current_width;
			rw[i].x = delta;
			delta = delta + rw[COL_MAPPED(i)].current_width;
#ifdef DEBUG
	printf("\nCalcGeom(3): x%d=%d \t width%d=%d\n", i, rw[COL_MAPPED(i)].x, i, rw[COL_MAPPED(i)].current_width);
#endif
		}
		rcol->rescol.full_width=tmp_w;
	}
	rcol->rescol.scroll_width=rcol->rescol.full_width-rcol->rescol.viewWidth;


	return res;
}



/************************************************************
 *
 * Internal routines.
 *
 ************************************************************/
int SetHorShift (Widget w, int newshift, Boolean change_select)
{
    XmNlRCL_Property_Row * prw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int limit_up, limit_down, rw;
	int delta;
	Boolean freshed=False;
	if (newshift+rcol->rescol.viewWidth > rcol->rescol.full_width)
		newshift=rcol->rescol.full_width-rcol->rescol.viewWidth;
	if (newshift < 0) newshift=0;
//	limit_up=newshift;
//	limit_down=newshift+rcol->rescol.viewWidth;
	/* tmp hack */
	delta = newshift - rcol->rescol.global_h_shift;
	rcol->rescol.global_h_shift=newshift;

	AdjustGlobalHorShift(w);
	CalcColParam(w);

    if (rcol->rescol.VisibilityState == VisibilityUnobscured)
    {
		if (delta < 0)
		{
			if (rcol->rescol.viewWidth + delta > 0)
			{
				if (rcol->rescol.render_order == LtoR_render)
				{
					XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
							0, 0, rcol->rescol.viewWidth + delta, rcol->rescol.viewHeight,
							0 - delta, 0);
					RCRedrawColRegion(w, 0, 0 - delta);
				}
				else
				{
					XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
							0 - delta, 0, rcol->rescol.viewWidth + delta, rcol->rescol.viewHeight,
							0, 0);
					RCRedrawColRegion(w, 0, 0 - delta);
				}
			}
		}
		if (delta > 0)
		{
			if (rcol->rescol.viewWidth - delta > 0)
			{
				if (rcol->rescol.render_order == LtoR_render)
				{
					XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
						0 + delta, 0, rcol->rescol.viewWidth - delta, rcol->rescol.viewHeight,
						0, 0);
	//			XClearArea(XtDisplay(w), XtWindow(w), 0, rcol->rescol.viewHeight - delta, rcol->rescol.viewWidth, delta, FALSE);
					RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				}
				else
				{
					XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
						0, 0, rcol->rescol.viewWidth - delta, rcol->rescol.viewHeight,
						0 + delta, 0);
					RCRedrawColRegion(w, rcol->rescol.viewWidth - delta, delta);
				}
			}
		}
	}
	else

		RCRedrawAllWindow(w);

}


static int SetVerShift (Widget w, int newshift, Boolean change_select)
{
    XmNlRCL_Property_Row * prw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int limit_up, limit_down, rw;
	Boolean freshed = False;
	int old_shift;
	int delta, delta2;

#ifdef DEBUG
	printf("\nSetVerShift: Shift=%d Height=%d FullHeight=%d\n",newshift,  rcol->rescol.viewHeight, rcol->rescol.full_height);
#endif
	old_shift = rcol->rescol.global_v_shift;
	if (newshift + rcol->rescol.viewHeight > rcol->rescol.full_height)
		newshift = rcol->rescol.full_height - rcol->rescol.viewHeight;
	if (newshift < 0) newshift = 0;
	limit_up = newshift;
	limit_down = newshift + rcol->rescol.viewHeight;
	/* tmp hack */
	rcol->rescol.global_v_shift = newshift;
	rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;


	rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;

	delta = newshift - old_shift;

	if (delta < 0) 
		delta2 = delta * -1;
	else 
		delta2 = delta;

//printf("Delta shift %d\n", delta2 / rcol->rescol.cell_height);

//	XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
//	XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);

    if (rcol->rescol.VisibilityState == VisibilityUnobscured && delta2 < rcol->rescol.viewHeight /*&& !change_select*/)
    {
//		printf("Partial redraw\n");
		if (delta < 0)
		{
			if (rcol->rescol.viewHeight + delta > 0)
				XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
					0, 0, rcol->rescol.viewWidth, rcol->rescol.viewHeight - delta,
					0, 0-delta);
//			XClearArea(XtDisplay(w), XtWindow(w), 0, 0, rcol->rescol.viewWidth, 0-delta, FALSE);
			RCRedrawRowRegion(w, 0, 0-delta, -1);
		}
		if (delta > 0)
		{
			if (rcol->rescol.viewHeight - delta > 0)
				XCopyArea(XtDisplay(w), XtWindow(w), XtWindow(w), rcol->rescol.drawGC,
					0, 0+delta, rcol->rescol.viewWidth, rcol->rescol.viewHeight - delta,
					0, 0);
//			XClearArea(XtDisplay(w), XtWindow(w), 0, rcol->rescol.viewHeight - delta, rcol->rescol.viewWidth, delta, FALSE);
			RCRedrawRowRegion(w, rcol->rescol.viewHeight - delta, delta, 1);
		}

	}
	else
	{
//		printf("Full redraw\n");
		RCRedrawRowRegion(w, 0, rcol->rescol.viewHeight, 1);
//		RCRedrawAllWindow(w);
	}
//	CurrentFrameDraw(w);
/*	if (freshed==False && change_select==True)
	{
		PutToOffScreenPix(w);
	}*/
	return 0;
}

/************************************************************
 *
 * Callbacks and Action Routines.
 *
 ************************************************************/


static void 
ScrollTimeout(XtPointer client_data, XtIntervalId *timer)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) client_data;
    Widget w = (Widget) client_data;
    XmNlRCL_Cell * cell;
    XmNlRCL_Property_Row * prw;
    Pixmap pixmap, mask;
    register int col;
    int row;
    int y, h_margin, sel_x1, sel_x2, sel_delta, sel_wd;
    int height, width, y1, l_width, l_height;
    int col_w;
	Display *dpy;
	Screen *scrn;
	Window win;
    GC gc;
    XRectangle * clip;
	unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;
    XmString label;
#ifdef FAST_XMSTRING_RENDERING
	SegmentedXmString * complabel;
#endif
	CacheBufElement* CachePtr;
	VisibleItem Element;
	Pixmap pbuf;
	IconInfo * icon;
	int delta_row = 2;
	int start_row, end_row;
		
	start_row = rcol->rescol.firstInterleavedRow + 1;
	end_row = rcol->rescol.lastInterleavedRow + 1;
		
	if (start_row > rcol->rescol.BotomLine || start_row > rcol->rescol.num_rows || 
			end_row < rcol->rescol.TopLine || end_row > start_row > rcol->rescol.num_rows)
	{
		rcol->rescol.scrollRefreshTimeoutFound = False;
		return ;
	}

    int x1; /* left coordinate of text with margin_w if XmALIGNMENT_BEGINNING */
    int x2; /* right coordinate of text with margin_w if XmALIGNMENT_END */

	dpy = XtDisplay(w);
	scrn = XtScreen(w);
	win = XtWindow(w);

	background_color = rcol->rescol.background_pixel;
	foreground_color = rcol->rescol.foreground_pixel;
	sel_fg_color = rcol->rescol.select_foreground_pixel;


	if (rcol->rescol.select_background_pixel == XmREVERSED_GROUND_COLORS)
		sel_bg_color = rcol->primitive.foreground;
	else
		sel_bg_color = rcol->rescol.select_background_pixel;


	height = rcol->rescol.cell_height;
	h_margin = rcol->rescol.margin_w;


	rcol->rescol.firstInterleavedRow = 0;
	rcol->rescol.lastInterleavedRow = 0;
	for (row = start_row; row < end_row; row = row + delta_row)
	{

		y = row * rcol->rescol.cell_height - rcol->rescol.global_v_shift;

		if(rcol->rescol.selected_rows[row] == True)
		{
			sel_x1 = rcol->rescol.margin_w;
			if (sel_x1 - rcol->rescol.global_h_shift < 0) sel_x1 = 0;

			sel_x2 = rcol->rescol.full_width - rcol->rescol.margin_w;
			if (sel_x2 - rcol->rescol.global_h_shift > rcol->rescol.viewWidth) sel_x2 = rcol->rescol.viewWidth;

			sel_wd = sel_x2 - sel_x1;

			XSetForeground(dpy, rcol->rescol.drawGC, sel_bg_color);

			XFillRectangle(dpy, win, rcol->rescol.drawGC, sel_x1, y + rcol->rescol.margin_h,
							sel_wd, height - 2* rcol->rescol.margin_h);
		}

		for (col = 0; col < rcol->rescol.num_cols; col++)
		{
			prw = rcol->rescol.prop_data + COL_MAPPED(col);
			if (!prw->clip_displayed)
							continue ;

			if (rcol->rescol.TreeMode && col == 0)
			{
				Element.element = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);
				Element.y = y + rcol->rescol.viewY;
				Element.x = prw->x - rcol->rescol.global_h_shift + rcol->rescol.viewX;
				Element.width = prw->current_width;
				Element.height = rcol->rescol.cell_height;
				Element.num = row * rcol->rescol.num_cols + col;
				if(rcol->rescol.selected_rows[row] == True) 
					RCDrawItemTreeSelected(w, &Element, False);
				else
					RCDrawItemTree(w, &Element);
				continue ;
			}

			cell = *(rcol->rescol.ItemData + row) + COL_MAPPED(col);

			gc = prw->gc;
			
			clip = &(prw->clip);

			width = prw->current_width;
			l_width = cell->label_w;
			l_height = cell->label_h;
			col_w = prw->current_width - 2 * rcol->rescol.margin_w;


			if (rcol->rescol.render_order == LtoR_render)
			{
				x2 = prw->xx1;
				if (prw->align_type == XmALIGNMENT_BEGINNING)
					x1 = prw->xx1;
				else
					x1 = prw->xx2 - l_width;
			}
			else
			{
				x2 =  prw->xx1;

				if (prw->align_type == XmALIGNMENT_BEGINNING)
					x1 = prw->xx2 - l_width;
				else
					x1 = prw->xx1;
			}


			if(rcol->rescol.selected_rows[row] == True)  
				goto l1; /* This row is selected */


/********** This row is not selected **********************************************/

/********** This is pixmap ********************************************************/
			if(prw->info_type == XmPIXMAP)
			{
				if (cell->icon)
				{
					icon = cell->icon;
//					pixmap = icon->pix;
//					mask = icon->mask;
					y1 = y + (rcol->rescol.cell_height - icon->height)/2;
					if (PIX_FOUND(icon->pix))
					{
						int pix_x, pix_w;
						if (col_w < icon->width)
						{
							pix_x = (icon->width - col_w) / 2;
							pix_w = icon->width - pix_x - pix_x;
							XCopyArea(dpy, icon->pix, win, gc,
									pix_x, 0, pix_w, icon->height, x2, y1);
						}
						else
						{
							XCopyArea(dpy, icon->pix, win, gc,
									0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2, y1);
						}
//						XSetClipOrigin(dpy, rcol->rescol.drawGC, 0, 0);
//						XSetClipMask(dpy, rcol->rescol.drawGC, None);
					}
				}
#ifdef DEBUG_SHIFTING
					printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
			}


/********* This is text **********************************************************/
			if(prw->info_type == XmSTRING)
			{
				label = cell->xmlabel;
				if (!label)
					continue ;

#ifdef FAST_XMSTRING_RENDERING
				complabel = cell->complabel;
				if (!complabel)
					continue ;
#endif
				
#ifdef DEBUG
				printf("RCDrawItem: label %s\n", cell->text);
#endif

				if (rcol->rescol.buffering)
				{
					if (cell->buf)
					{
						pbuf = (((CacheBufElement*) (cell->buf))->id);
					}
					else
					{
						CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), 1);
						if (!CachePtr)
						{
							return ;
						}
						pbuf = CachePtr->id;
						cell->buf = CachePtr;
					}
				}

				y1 = y + (rcol->rescol.cell_height - l_height)/2;


//				XSetForeground(dpy, gc, foreground_color);
//				XSetBackground(dpy, gc, background_color);

				if (rcol->rescol.buffering)
				{
					XCopyArea(dpy, pbuf, win, gc,
									0, 0, l_width, l_height,
									x1, y1);
				}
				else
				{
					if (rcol->rescol.xft)
					{
/*						if (!CHECK_CLIP_CORRECT)
						{
							XSetClipRectangles(XtDisplay(w), gc,
											0, 0, clip, 1, Unsorted);
											
						printf(">>>>>>>> Clip %d %d\n", clip->y, clip->height);
					}	*/

#ifdef FAST_XMSTRING_RENDERING
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
								y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif
/*						if (!CHECK_CLIP_CORRECT)*/
#if XmVERSION < 2 && XmREVISION < 3 && XmUPDATE_LEVEL < 4
							XSetClipRectangles(XtDisplay(w), gc,
											0, 0, clip, 1, Unsorted);
#endif
					}
					else
#ifdef FAST_XMSTRING_RENDERING
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, foreground_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
								y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
				}

			}

			continue ;


l1:

/*********** This row is selected *********************************************/


/************ This is pixmap **********************************************/
			if(prw->info_type == XmPIXMAP)
			{
				if (cell->icon)
				{
					icon = cell->icon;
					y1 = y + (rcol->rescol.cell_height - icon->height)/2;
					if (PIX_FOUND(icon->highlighted))
					{
						int pix_x, pix_w;
						if (col_w < icon->width)
						{
							pix_x = (icon->width - col_w) / 2;
							pix_w = icon->width - pix_x - pix_x;
							XCopyArea(dpy, icon->highlighted, win, gc,
									pix_x, 0, pix_w, icon->height, x2, y1);
						}
						else
						{
							XCopyArea(dpy, icon->highlighted, win, gc,
									0, 0, icon->width, icon->height, x2 + (col_w - icon->width) / 2, y1);
						}
					}
#ifdef DEBUG_SHIFTING
					printf("\nPutToPix: Pixmap for col=%d row=%d copyed\n", col, row);
#endif
				}
			}

/**************** This is text ******************************************/
			if(prw->info_type == XmSTRING)
			{
#ifdef DEBUG_SHIFTING
				printf("Draw cell %d XmSTRING w = %d %p\n", col, prw->current_width, cell->xmlabel);
#endif

				label = cell->xmlabel;
				if (!label)
					continue ;

				if (rcol->rescol.buffering)
				{
					if (cell->buf)
					{
						pbuf = (((CacheBufElement*) (cell->buf))->id);
					}
					else
					{
						CachePtr = RCGetPixBufNew((Widget) w, cell, prw, row, COL_MAPPED(col), 1);
						if (!CachePtr)
						{
							return ;
						}
						pbuf = CachePtr->id;
						cell->buf = CachePtr;
					}
				}

//				XSetForeground(dpy, gc, sel_fg_color);
//				XSetBackground(dpy, gc, sel_bg_color);


#ifdef DEBUG
				printf("RCDrawItem: label %s\n", cell->text);
#endif


				y1 = y + (rcol->rescol.cell_height - l_height)/2;

				if (rcol->rescol.buffering)
				{
#ifdef DEBUG
					if (col == 6)
					{
						CheckCacheChunk(prw);
					}
#endif
					XCopyArea(dpy, pbuf, win, gc,
								0, 0, l_width, l_height,
								x1, y1);
				}
				else
				{
					if (rcol->rescol.xft)
					{
#ifdef FAST_XMSTRING_RENDERING
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, sel_fg_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
									y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, clip);
#endif
/*						if (!CHECK_CLIP_CORRECT)*/
#if XmVERSION < 2 && XmREVISION < 3 && XmUPDATE_LEVEL < 4
							XSetClipRectangles(XtDisplay(w), gc, 0, 0, clip, 1, Unsorted);
#endif
					}
					else
#ifdef FAST_XMSTRING_RENDERING
						DrawComplexString3(dpy, win, gc, rcol->rescol.font_list, complabel, 
#ifdef	USE_XFT
										prw->xftdraw, 
#endif
										x1, y1, rcol->rescol.idxRend, sel_fg_color, clip);
#else
						XmStringDraw(dpy, win, rcol->rescol.font_list, label, gc, x1,
									y1, width, XmALIGNMENT_BEGINNING, XmSTRING_DIRECTION_DEFAULT, NULL);
#endif
				}

			}
		}

		if (row == rcol->rescol.current_row)
			CurrentFrameDraw(w);
	}
	
	rcol->rescol.scrollRefreshTimeoutFound = False;
	return ;
}


static void
VScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) client_data;
    XmScrollBarCallbackStruct * scroll_info;
	int newshift;
	
    scroll_info = (XmScrollBarCallbackStruct *) call_data;

	if (rcol->rescol.num_rows <= MAXIMUM_ROW_SHIFT_MODE)
	{
		newshift = (int) scroll_info->value;
		SetVerShift ((Widget) rcol, newshift, False);
		CurrentFrameDraw((Widget) rcol);
	}
	else
	{
		newshift = ((int) scroll_info->value) * rcol->rescol.cell_height;
		SetVerShift ((Widget) rcol, newshift, False);
		CurrentFrameDraw((Widget) rcol);
	}

#ifdef DEBUG
	printf("\n Vscrolled\n ");
#endif
}

static void
HScrollCallback(Widget w, XtPointer client_data, XtPointer call_data)
{
   XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) client_data;
	XmNlRCL_Cell  * cell;
//    XmItemBoxWidget it = (XmItemBoxWidget) client_data;
    XmScrollBarCallbackStruct * scroll_info;
    int newshift;
//printf("\n Vscrolled v_h=%d\n ", rcol->rescol.viewHeight);
//return ;
    scroll_info = (XmScrollBarCallbackStruct *) call_data;

    newshift = (int) scroll_info->value;
    SetHorShift ( (Widget) rcol, newshift, False);
    CurrentFrameDraw((Widget) rcol);

//	if (rcol->rescol.title_bar != NULL)
//	{
//		PRSetShift(rcol->rescol.title_bar, rcol->rescol.global_h_shift);
//	}
#ifdef DEBUG
	printf("\n XmNlResColListWidget Hscrolled\n ");
#endif
}

/*	Function Name: ResizeSliders
 *	Description:   Resizes the thumbs of the v and h scrollbars.
 *	Arguments:     w - the RC List widget.
 *	Returns:       none
 *
 */

static void
ResizeSliders(Widget w, int mask)
{
    XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
    Arg args[5];
    Cardinal num_args=0;
    register int i, height, max_width, rows_per_screen;
    register int slide_pos, slide_size, col_width=0, min=0;
    Widget scroll;
    scroll=rcol->rescol.v_bar;
    if (scroll != NULL && (mask & VerticalScroll))
    {
		if (rcol->rescol.full_height > rcol->rescol.viewHeight)
		{
			if (rcol->rescol.num_rows <=MAXIMUM_ROW_SHIFT_MODE)
			{
				XtVaSetValues(scroll, XmNmaximum, rcol->rescol.full_height,
							XmNsliderSize, rcol->rescol.viewHeight, XmNvalue, rcol->rescol.global_v_shift, NULL);
			}
			else
				{
					XtVaSetValues(scroll, XmNmaximum, rcol->rescol.num_rows,
								XmNsliderSize, rcol->rescol.viewHeight / rcol->rescol.cell_height, XmNvalue, rcol->rescol.TopLine, NULL);
				}
		}
		else
			XtVaSetValues(scroll, XmNmaximum, 1,
							XmNsliderSize, 1, XmNvalue, 0, NULL);

#ifdef DEBUG
		printf("\n !! maximum1=%d \n !! sliderSize1=%d", rcol->rescol.full_height, rcol->rescol.viewHeight);
#endif
    }

	if (ChekParentIsList(XtParent(w)) && rcol->rescol.num_rows == 0)
		return ;

    scroll = rcol->rescol.h_bar;
	if (scroll != NULL && (mask & HorizontalScroll))
    {
		if (rcol->rescol.full_width > rcol->rescol.viewWidth)
			XtVaSetValues(scroll, XmNmaximum, rcol->rescol.full_width,
							XmNsliderSize, rcol->rescol.viewWidth, XmNvalue, rcol->rescol.global_h_shift, NULL);
		else
			XtVaSetValues(scroll, XmNmaximum, rcol->rescol.viewWidth,
							XmNsliderSize, rcol->rescol.viewWidth, XmNvalue, rcol->rescol.global_h_shift, NULL);

#ifdef DEBUG
		printf("\n !! maximum2=%d \n !! sliderSize2=%d", rcol->rescol.full_width, rcol->rescol.viewWidth);
#endif
    }

}



static void AdjustGlobalHorShift(Widget w)
{
    XmNlRCL_Property_Row * prw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
//	XmNlRCL_Cell  * cell;
	int /*limit_up, limit_down, rw,*/ newshift;
	Boolean freshed=False;
	int i, view_right_limit, x1, x2;
//	int newshift;

	prw = rcol->rescol.prop_data;
	newshift = rcol->rescol.global_h_shift;


	if (newshift+rcol->rescol.viewWidth > rcol->rescol.full_width)
		newshift=rcol->rescol.full_width-rcol->rescol.viewWidth;
	if (newshift < 0) newshift=0;


/*	view_right_limit = rcol->rescol.global_h_shift + rcol->rescol.viewWidth;

#ifdef DEBUG_SHIFTING
	printf("\n AdjustGlobalHorShift: global_h_shift=%d\n ", rcol->rescol.global_h_shift);
#endif
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
#ifdef DEBUG_SHIFTING
	printf("\n AdjustGlobalHorShift: x=%d\n ", prw[i].x);
#endif
		prw[i].col_displayed = TRUE;
		prw[i].clip_displayed = TRUE;
		x1 = prw[i].x;
		x2 = prw[i].x + prw[i].current_width;
		if(x1 > view_right_limit || x2 < rcol->rescol.global_h_shift) 
									prw[i].col_displayed = FALSE;
		if(x1 + rcol->rescol.margin_w > view_right_limit || 
			x2 - rcol->rescol.margin_w < rcol->rescol.global_h_shift) 
									prw[i].clip_displayed = FALSE;
#ifdef DEBUG_SHIFTING
	printf("\n AdjustGlobalHorShift: x1=%d x2=%d view_right_limit=%d\n ", x1, x2, view_right_limit);
	if (prw[i].col_displayed) printf("\n AdjustGlobalHorShift: col=%d redisplay\n ", i);
	if (prw[i].col_displayed == False) printf("\n AdjustGlobalHorShift: col=%d not redisplay\n ", i);
#endif
	}*/
	rcol->rescol.global_h_shift = newshift;

	return ;
}


static void AdjustGlobalShift(Widget w)
{
    XmNlRCL_Property_Row * prw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;
	int limit_up, limit_down, rw, newshift;
	Boolean freshed=False;
	int i, view_right_limit, x1, x2;

	/* Adjust vertical shift */
	prw=rcol->rescol.prop_data;
	newshift=rcol->rescol.global_v_shift;
	if (rcol->rescol.num_items==0) return;
	if (newshift+rcol->rescol.viewHeight > rcol->rescol.full_height)
		newshift=rcol->rescol.full_height-rcol->rescol.viewHeight;
	if (newshift < 0) newshift=0;
	limit_up=newshift;
	limit_down=newshift+rcol->rescol.viewHeight;
	/* tmp hack */
	rcol->rescol.global_v_shift=newshift;
	if (rcol->rescol.pix_shift > limit_up || rcol->rescol.pix_shift+rcol->rescol.pix_buf_h < limit_down )
	{
		rcol->rescol.pix_shift=rcol->rescol.global_v_shift-rcol->rescol.cell_height*2;
		if (rcol->rescol.pix_shift < 0)
		{
			rcol->rescol.pix_shift=0;
		}
		else
		{
			rw=rcol->rescol.pix_shift/rcol->rescol.cell_height;
			rcol->rescol.pix_shift=rw*rcol->rescol.cell_height;
		}
		rcol->rescol.v_shift_in_pix=rcol->rescol.global_v_shift-rcol->rescol.pix_shift;
		rcol->rescol.drawable_height_changed=True;
//		PutToOffScreenPix(w);
		freshed=True;
	}
//	it->itbox.global_shift=newshift;
	rcol->rescol.v_shift_in_pix=rcol->rescol.global_v_shift-rcol->rescol.pix_shift;

	AdjustGlobalHorShift(w);
	CalcColParam(w);
/*	view_right_limit=rcol->rescol.global_h_shift+rcol->rescol.viewWidth;

		for (i=0; i<rcol->rescol.num_cols; i++)
			{
			x1=prw[i].x;
			x2=prw[i].x+prw[i].current_width;
			if(x1 > view_right_limit || x2 < rcol->rescol.global_h_shift) prw[i].displayed=False;
			else prw[i].displayed=True;
			}
*/


	/*	if (freshed==False && change_select==True)
	{
		PutToOffScreenPix(w);
	}*/
/*	if (freshed==False && change_select==True)
	{
		PutToOffScreenPix(w);
	}*/

/*	XCopyArea(XtDisplay(w), it->itbox.pix, XtWindow(w), it->itbox.drawGC,
		0, it->itbox.shift_in_pix, it->itbox.viewWidth, it->itbox.viewHeight,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness,
		it->primitive.highlight_thickness+it->primitive.shadow_thickness);*/
	return;
}



static int ClickInRow(unsigned long x, unsigned long y, Widget w)
{
	int cur_row;
	unsigned long global_y;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	global_y = y + rcol->rescol.global_v_shift;
//	printf("ResCol cell height %d\n", rcol->rescol.cell_height);
	cur_row = global_y/rcol->rescol.cell_height;
    if (cur_row >= rcol->rescol.num_rows) return -1;
	return cur_row;

}

int RCXYtoRow(Widget w, unsigned long x, unsigned long y)
{
	return ClickInRow(x, y, w);
}


static void SyncSelectedOne(XmNlResColListWidget rcol, int new_selected_row)
{
	int i, y;
	XmNlRCL_Cell *cell;

	
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i] == True && i != new_selected_row)
		{
			if (rcol->rescol.buffering)
				RefreshCachePix((Widget) rcol, i, False);
			rcol->rescol.selected_rows[i] = False;
/*			rcol->rescol.PublicSelectedCount--;*/
			if (i >= rcol->rescol.TopLine && i <= rcol->rescol.BotomLine)
			{
				y = i*rcol->rescol.cell_height - rcol->rescol.global_v_shift;
				XClearArea(XtDisplay((Widget) rcol), XtWindow((Widget) rcol), rcol->rescol.viewX, y,
							rcol->rescol.viewWidth, rcol->rescol.cell_height, False);
				RCDrawRows((Widget) rcol, i, i + 1, 0);
			}
			cell = rcol->rescol.ItemData[i];
			cell[COL_MAPPED(0)].selected = False;
		}

		if (rcol->rescol.selected_rows[i] == False && i == new_selected_row)
		{
			if (rcol->rescol.buffering)
				RefreshCachePix((Widget) rcol, i, True);
			rcol->rescol.selected_rows[i] = True;
/*			rcol->rescol.PublicSelectedCount++;*/
			if (i >= rcol->rescol.TopLine && i <= rcol->rescol.BotomLine)
			{
				y = i*rcol->rescol.cell_height - rcol->rescol.global_v_shift;
				XClearArea(XtDisplay((Widget) rcol), XtWindow((Widget) rcol), rcol->rescol.viewX, y,
							rcol->rescol.viewWidth, rcol->rescol.cell_height, False);
				RCDrawRows((Widget) rcol, i, i + 1, 0);
			}
			cell = rcol->rescol.ItemData[i];
			cell[COL_MAPPED(0)].selected = True;
		}
	}
	
	if (rcol->rescol.selectedPositionsCount == 1)
	{
		rcol->rescol.selectedPositions[0] = new_selected_row;
		return ;
	}
	else
	{
		if (rcol->rescol.selectedPositions)
			XtFree((char *) rcol->rescol.selectedPositions);
		
		rcol->rescol.selectedPositionsCount = 1;
		rcol->rescol.selectedPositions = (int *) XtMalloc(sizeof(int));
		rcol->rescol.selectedPositions[0] = new_selected_row;
	}
}

static void DeselctAll(Widget w, int with_redraw)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int rows_num, i, j, p, y;
	Display * display = XtDisplay(w);
	XmNlRCL_Cell *cell;

	p = 0;

	rows_num = rcol->rescol.num_rows;
//	cell=rcol->rescol.item_data;
	for (i = 0; i < rows_num; i++)
	{
		if (rcol->rescol.selected_rows[i] == True)
		{
			RefreshCachePix(w, i, False);
			rcol->rescol.selected_rows[i] = False;
/*			rcol->rescol.PublicSelectedCount--;*/
			if (with_redraw)
			{
				if (i >= rcol->rescol.TopLine && i <= rcol->rescol.BotomLine)
				{
					y = i*rcol->rescol.cell_height - rcol->rescol.global_v_shift;
					XClearArea(XtDisplay(w), XtWindow(w), rcol->rescol.viewX, y,
								rcol->rescol.viewWidth, rcol->rescol.cell_height, False);
					RCDrawRows(w, i, i + 1, 0);
				}
			}
			cell = rcol->rescol.ItemData[i];
			cell[COL_MAPPED(0)].selected = False;
		}
	}
	return;
}

XmNlListTreeItem * ListTreeClickInItem(XmNlResColListWidget rcol, char * pos, int row, Position x, Position y)
{

	int n, xtext, xpix;
	Dimension wd, ht;
//	InternList * row;
	XmNlRCL_Cell  * cell;
	XmNlListTreeItem * item;
	Pixinfo *pix;
//	XmString xmstring;
    XmNlRCL_Property_Row * prw;

	/* Adjust vertical shift */

	if (row < 0) return NULL;

	prw = rcol->rescol.prop_data;
	y = y - rcol->rescol.viewY + rcol->rescol.global_v_shift;

	if (row > rcol->rescol.num_rows) return NULL;

	cell = rcol->rescol.ItemData[row];

	item = cell[COL_MAPPED(0)].node;

//	pix=RCGetItemPix(rcol, item);
	wd = XmStringWidth(rcol->rescol.font_list, cell->xmlabel);

#ifdef FAST_XMSTRING_RENDERING
/*	SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell->complabel, 
										&(wd), &(ht));*/
	SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell->complabel, 
										&wd, &ht, rcol->rescol.idxRend);
#endif

	if (rcol->rescol.render_order == LtoR_render)
	{
		xtext = item->x + rcol->rescol.ctrlWidth + rcol->rescol.margin_w;
		x = x - rcol->rescol.viewX + rcol->rescol.global_h_shift;

#ifdef DEBUG
		printf("ListTreeClivInItem: wd %d Xtext %d\n", wd, xtext);
#endif

		if (x < prw[COL_MAPPED(0)].x - rcol->rescol.viewX + rcol->rescol.global_h_shift || x > prw[COL_MAPPED(0)].x + prw[COL_MAPPED(0)].current_width - rcol->rescol.viewX + rcol->rescol.global_h_shift) return NULL;
		if (x >= (item->x + rcol->rescol.ctrlWidth) && x <= (xtext+wd))
		{
			*pos = ClickInBody;
			return item;
		}
		if (item->firstchild)
		{
#ifdef DEBUG
			printf("Item is expandable\n");
#endif
	//		xpix=xtext - 2*rcol->rescol.margin_h - pix->width - rcol->rescol.ctrlWidth;
			if (x >= item->x && x <= (item->x + rcol->rescol.ctrlWidth))
			{
				*pos = ClickInControl;
#ifdef DEBUG
				printf("ClickInControl\n");
#endif
				return item;
			}
			if (x < item->x)
			{
				return NULL;
			}
		}
	}
	else
	{
		xtext = item->x + rcol->rescol.ctrlWidth + rcol->rescol.margin_w;
		x = rcol->rescol.viewWidth - (x + rcol->rescol.global_h_shift);

#ifdef DEBUG
		printf("ListTreeClivInItem: wd %d Xtext %d\n", wd, xtext);
#endif

		if (x < prw[COL_MAPPED(0)].x - rcol->rescol.viewX + rcol->rescol.global_h_shift || x > prw[COL_MAPPED(0)].x + prw[COL_MAPPED(0)].current_width - rcol->rescol.viewX + rcol->rescol.global_h_shift) return NULL;
		if (x >= (item->x + rcol->rescol.ctrlWidth) && x <= (xtext+wd))
		{
			*pos = ClickInBody;
			return item;
		}
		if (item->firstchild)
		{
#ifdef DEBUG
			printf("Item is expandable\n");
#endif
	//		xpix=xtext - 2*rcol->rescol.margin_h - pix->width - rcol->rescol.ctrlWidth;
			if (x >= item->x && x <= (item->x + rcol->rescol.ctrlWidth))
			{
				*pos = ClickInControl;
#ifdef DEBUG
				printf("ClickInControl\n");
#endif
				return item;
			}
			if (x < item->x)
			{
				return NULL;
			}
		}
	}

	return NULL;
}

void CollectSelectItem(XmNlResColListWidget rcol, XmNlListTreeItem ** item)
{
	int i;

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i])
			item[i] = rcol->rescol.ItemData[i][COL_MAPPED(0)].node;
		else
			item[i] = NULL;
	}
}

void RestoreSelectItem(XmNlResColListWidget rcol, XmNlListTreeItem ** item, int num)
{
	int i, j;

	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		for (j = 0; j < num; j++)
		{
			if (item[j] == rcol->rescol.ItemData[i][COL_MAPPED(0)].node)
				rcol->rescol.selected_rows[i] = True;
		}
	}
}


static void ButtonDownActionBackup(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, i, num;
    XButtonEvent * bevent = (XButtonEvent *) event;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Boolean SelectWithCtrl = False;
	Time tm;
	XmNlListTreeItem * item, ** sel_item, *current_item;
	char pos;
	int delta;

	if (!rcol->rescol.HasFocus) {
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		rcol->rescol.HasFocus = True;
	}

	if (rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
		return ;

	x = bevent->x;
	y = bevent->y;


	res = ClickInRow ((unsigned long) x, (unsigned long) y, w);
#ifdef DEBUG
	printf("\n ++++++++++++++++  Clicked to: %d\n", res);
#endif

	if (rcol->rescol.TreeMode)
	{
		rw = rcol->rescol.prop_data;
		item = ListTreeClickInItem(rcol, &pos, res, x, y);
		if (item && pos == ClickInControl)
		{
			if (item && item->firstchild && item->open)
			{
				XmNlRCL_Property_Row * rw = rcol->rescol.prop_data;
#ifdef DEBUG
				printf("--Close real_width %d\n", rw->real_width);
#endif
				item->open = False;
				UnselectBranch(rcol, item);
				current_item = NULL;
				if (rcol->rescol.current_row != -1 && rcol->rescol.current_row < rcol->rescol.num_rows)
				{
					current_item = rcol->rescol.ItemData[rcol->rescol.current_row][COL_MAPPED(0)].node;
					cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//					cell->selected = cell->selected & NotThisCurrentMask;
				}
				sel_item = (XmNlListTreeItem **) XtCalloc(rcol->rescol.num_rows, sizeof(XmNlListTreeItem *));
				num = rcol->rescol.num_rows;
				CollectSelectItem(rcol, sel_item);
				RCCountAll(rcol);
				rcol->rescol.current_row = -1;
				if (current_item)
				{
					for (i = 0; i < rcol->rescol.num_rows; i++)
					{
						if (current_item == rcol->rescol.ItemData[i][COL_MAPPED(0)].node)
						{
							rcol->rescol.current_row = i;
							cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
//							cell->selected = cell->selected | ThisCurrentMask;
						}
					}
				}
				RestoreSelectItem(rcol, sel_item, num);
				XtFree((char *) sel_item);
				RebuildSelectedPositionsOnly(rcol);

				if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
				{
					ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

					delta = 0;

					for (i = 0; i < rcol->rescol.num_cols; i++)
					{
						rw[COL_MAPPED(i)].x = delta;
						rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
						delta = delta + rw[COL_MAPPED(i)].current_width;
					}

					rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
					rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
					rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
				}
				
				if (!rcol->rescol.resizeCallback) 
					CalcGeomPostInit(w);

				AdjustGlobalHorShift(w);
				if (rcol->rescol.global_v_shift + rcol->rescol.viewHeight > rcol->rescol.full_height)
					rcol->rescol.global_v_shift = rcol->rescol.full_height - rcol->rescol.viewHeight;
				if (rcol->rescol.global_v_shift < 0) 
					rcol->rescol.global_v_shift = 0;
				rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;
				rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;
				ResizeSliders(w, AllScroll);
				CalcColParam(w);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(rcol);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(rcol, event, item);
				return;
			}
			if (item && item->firstchild && !(item->open))
			{
#ifdef DEBUG
				printf("--Open\n");
#endif
				item->open = True;
				current_item = NULL;
				if (rcol->rescol.current_row != -1 && rcol->rescol.current_row < rcol->rescol.num_rows)
				{
					current_item = rcol->rescol.ItemData[rcol->rescol.current_row][COL_MAPPED(0)].node;
					cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//					cell->selected = cell->selected & NotThisCurrentMask;
				}
				sel_item = (XmNlListTreeItem **) XtCalloc(rcol->rescol.num_rows, sizeof(XmNlListTreeItem *));
				num = rcol->rescol.num_rows;
				CollectSelectItem(rcol, sel_item);

				RCCountAll(rcol);
				rcol->rescol.current_row = -1;
				if (current_item)
				{
					for (i = 0; i < rcol->rescol.num_rows; i++)
					{
						if (current_item == rcol->rescol.ItemData[i][COL_MAPPED(0)].node)
						{
							rcol->rescol.current_row = i;
							cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
//							cell->selected = cell->selected | ThisCurrentMask;
						}
					}
				}
				RestoreSelectItem(rcol, sel_item, num);
				XtFree((char *) sel_item);
				RebuildSelectedPositionsOnly(rcol);


				if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
				{
					ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

					delta = 0;

					for (i = 0; i < rcol->rescol.num_cols; i++)
					{
						rw[COL_MAPPED(i)].x = delta;
						rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
						delta = delta + rw[COL_MAPPED(i)].current_width;
					}

					rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
					rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
					rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
				}
				
				if (!rcol->rescol.resizeCallback) 
					CalcGeomPostInit(w);

				AdjustGlobalHorShift(w);
				ResizeSliders(w, AllScroll);
				CalcColParam(w);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(lt);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(lt, event, item);
				return;
			}
		}
		if (item && pos == ClickInBody)
		{

//			UnselectAllItem(rcol);

//			item->highlighted = True;
#ifdef DEBUG
				printf("ClicInBody\n");
#endif
//			return ;
		}

	}
/*** End TreeList ***/
	if (res != -1 && rcol->rescol.current_row >= 0 && rcol->rescol.current_row != res)
	{
		CurrentFrameRemoveDraw(w);
		if (rcol->rescol.current_row < rcol->rescol.num_rows)
		{
			cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//			cell->selected = cell->selected & NotThisCurrentMask;
		}
	}

	if (res >=0)
		rcol->rescol.current_row = res;

	if (rcol->rescol.current_row < rcol->rescol.num_rows && rcol->rescol.current_row >= 0)
	{
		cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//		cell->selected = cell->selected | ThisCurrentMask;
	}

	DeselctAll(w, 1);
	if (res != -1)
	{
		rcol->rescol.selected_rows[res] = True;
		if (res < rcol->rescol.num_rows)
		{
			cell = rcol->rescol.ItemData[res] + COL_MAPPED(0);
//			cell->selected = cell->selected | InSelectMask;
		}

		if (rcol->rescol.buffering) RefreshCachePix(w, res, True);
		tm = bevent->time;
		if ((tm-rcol->rescol.sm_tm) < rcol->rescol.multiclick) rcol->rescol.DblClicked=True;
		else rcol->rescol.sm_tm=tm;
		RCDrawRows(w, res, res + 1, 0);
	}
	rcol->rescol.clicked_item = res;

//	RCRedrawAllWindow(w);
	RebuildSelectedPositionsOnly(rcol);
//	CurrentFrameDraw(w);
	HighlightDoCallback(w);

	return;
}

Boolean HitToSelected(XmNlResColListWidget rcol, int row_number)
{
	int i, lim_min = 0, lim_max = rcol->rescol.num_rows;
	
	if (rcol->rescol.TopLine > lim_min)
		lim_min = rcol->rescol.TopLine;
		
	if (rcol->rescol.BotomLine < lim_max)
		lim_max = rcol->rescol.BotomLine + 1;
	


	for (i = lim_min; i < lim_max; i++)
	{
		if (rcol->rescol.selected_rows[i] == True && i == row_number)
			return True;
	}
	
	return False;
}

static void ButtonDownAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, i, num, current_r;
    XButtonEvent * bevent = (XButtonEvent *) event;
	XmNlRCL_Cell  * cell;
	XmNlRCL_Property_Row * rw;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Boolean SelectWithCtrl = False;
	Time tm;
	XmNlListTreeItem * item, ** sel_item, *current_item, *current_parent_item;
	char pos;
	int delta;

	if (!rcol->rescol.HasFocus) {
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		rcol->rescol.HasFocus = True;
	}

	if (rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
		return ;

	x = bevent->x;
	y = bevent->y;


	res = ClickInRow ((unsigned long) x, (unsigned long) y, w);
#ifdef DEBUG
	printf("\n ++++++++++++++++  Clicked to: %d at %ld\n", res, event->xbutton.time);
#endif

	if (res < 0)
		return ;

	if (rcol->rescol.TreeMode)
	{
		rw = rcol->rescol.prop_data;
		item = ListTreeClickInItem(rcol, &pos, res, x, y);
		if (item && pos == ClickInControl)
		{
			if (item && item->firstchild && item->open)
			{
#ifdef DEBUG
				printf("--Close real_width %d\n", rw->real_width);
				PrintNodePath(item, "Collapsed");
#endif
				item->open = False;
				if (FoundCurrentInBranch(rcol, item))
					rcol->rescol.currentVisibleParentTreeNode = item;
				
				num = rcol->rescol.num_rows;
				RCCountAll(rcol);
#ifdef DEBUG
				if (((XmNlRCL_Cell  *)(item->cell))->selected)
					printf("Collapsed item is selected\n");
				else
					printf("Collapsed item is not selected\n");
#endif
//				rcol->rescol.current_row = -1;

				rcol->rescol.current_row = FindCurrentTreeNodeInRowList(rcol);
//				RebuildSelectedPositions(rcol);
				RebuildSelectedRows(rcol, 1);

				if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
				{
					ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

					delta = 0;

					for (i = 0; i < rcol->rescol.num_cols; i++)
					{
						rw[COL_MAPPED(i)].x = delta;
						rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
						delta = delta + rw[COL_MAPPED(i)].current_width;
					}

					rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
					rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
					rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
				}
				
				if (!rcol->rescol.resizeCallback) 
					CalcGeomPostInit(w);

				AdjustGlobalHorShift(w);
				if (rcol->rescol.global_v_shift + rcol->rescol.viewHeight > rcol->rescol.full_height)
					rcol->rescol.global_v_shift = rcol->rescol.full_height - rcol->rescol.viewHeight;
				if (rcol->rescol.global_v_shift < 0) 
					rcol->rescol.global_v_shift = 0;
				rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;
				rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;
				ResizeSliders(w, AllScroll);
				CalcColParam(w);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(rcol);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(rcol, event, item);
				return;
			}
			if (item && item->firstchild && !(item->open))
			{
#ifdef DEBUG
				printf("--Open\n");
#endif
				item->open = True;
				current_item = NULL;


				RCCountAll(rcol);
#ifdef DEBUG
				if (((XmNlRCL_Cell  *)(item->cell))->selected)
					printf("Expanded item is selected\n");
				else
					printf("Expanded item is not selected\n");
#endif
				if (FoundCurrentInBranch(rcol, item))
				{
					int finded_row;
					
					current_r = FindCurrentTreeNodeInRowList(rcol);
					if (current_r >= 0)
					{
						rcol->rescol.current_row = current_r;
						cell = rcol->rescol.ItemData[current_r] + COL_MAPPED(0);
						rcol->rescol.currentVisibleParentTreeNode = cell->node;
					}
					else
					{
						current_parent_item = FindFirstVisibleParentForCurrentTreeNode(rcol, &finded_row);
						if (current_parent_item)
						{
							rcol->rescol.current_row = -1;
							rcol->rescol.currentVisibleParentTreeNode = current_parent_item;
						}
						else
						{
							rcol->rescol.current_row = -1;
							rcol->rescol.currentVisibleParentTreeNode = NULL;
						}
					}
				}

//				RebuildSelectedPositions(rcol);
				RebuildSelectedRows(rcol, 1);


				if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
				{
					ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

					delta = 0;

					for (i = 0; i < rcol->rescol.num_cols; i++)
					{
						rw[COL_MAPPED(i)].x = delta;
						rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
						delta = delta + rw[COL_MAPPED(i)].current_width;
					}

					rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
					rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
					rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
				}
				
				if (!rcol->rescol.resizeCallback) 
					CalcGeomPostInit(w);

				AdjustGlobalHorShift(w);
				ResizeSliders(w, AllScroll);
				CalcColParam(w);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(lt);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(lt, event, item);
				return;
			}
		}
		if (item && pos == ClickInBody)
		{

//			UnselectAllItem(rcol);

//			item->highlighted = True;
#ifdef DEBUG
				printf("ClicInBody\n");
#endif
//			return ;
		}

	}
/*** End TreeList ***/


	tm = bevent->time;
#ifdef DEBUG
	printf("size long = %ld int = %ld time = %ld\n", sizeof(long), sizeof(int), sizeof(Time));
	printf("=========OK========= %ld %ld %d\n", rcol->rescol.sm_tm, tm, rcol->rescol.multiclick);
#endif
	if ((tm - rcol->rescol.sm_tm) < rcol->rescol.multiclick) 
	{
		if (res == rcol->rescol.clicked_item)
		{
			rcol->rescol.DblClicked = True;
#ifdef DEBUG
			printf("DblClicked=True\n");
#endif
		}
	}
	else 
		rcol->rescol.sm_tm = tm;

	rcol->rescol.sm_tm = tm;
	rcol->rescol.clicked_item = res;

#ifdef DEBUG
	printf("ButtonDownAction flat list\n");
#endif

/*
	if (res != -1 && HitToSelected(rcol, res))
	{
printf("ButtonDownAction hit to selected\n");
		if (rcol->rescol.current_row != res && rcol->rescol.ItemData[res] != rcol->rescol.currentItem)
		{
printf("ButtonDownAction redrawing current frame\n");
			CurrentFrameRemoveDraw(w);
			rcol->rescol.current_row = res;
			rcol->rescol.currentItem = rcol->rescol.ItemData[res];
			if (rcol->rescol.TreeMode)
			{
				cell = rcol->rescol.ItemData[res];
				rcol->rescol.currentTreeNode = cell->node;
			}
			CurrentFrameDraw(w);
		}
		return ;
	}
*/	
	CurrentFrameRemoveDraw(w);
	rcol->rescol.current_row = res;
	rcol->rescol.currentItem = rcol->rescol.ItemData[res];
	if (rcol->rescol.TreeMode)
	{
		cell = rcol->rescol.ItemData[res];
		rcol->rescol.currentTreeNode = cell->node;
		rcol->rescol.currentVisibleParentTreeNode = cell->node;
	}


	SyncSelectedOne(rcol, res);
	CurrentFrameDraw(w);

//	if (res != -1)
//	{
//		tm = bevent->time;
//		tm = event->xbutton.time;
//		printf("size long = %ld int = %ld time = %ld\n", sizeof(long), sizeof(int), sizeof(Time));
//		printf("=========OK========= %ld %ld %d\n", rcol->rescol.sm_tm, tm, rcol->rescol.multiclick);
//		if ((tm-rcol->rescol.sm_tm) < rcol->rescol.multiclick) 
//		{
//			rcol->rescol.DblClicked=True;
//			printf("DblClicked=True\n");
//		}
//		else rcol->rescol.sm_tm=tm;
//		RCDrawRows(w, res, res + 1, 0);
//	}
//	rcol->rescol.clicked_item = res;

//	RCRedrawAllWindow(w);
//	RebuildSelectedPositions(rcol);
//	CurrentFrameDraw(w);
	HighlightDoCallback(w);

	return;
}

static void ButtonDownActionExtendedBackup(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, i, num;
    XButtonEvent * bevent = (XButtonEvent *) event;
	XmNlRCL_Cell  * cell;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Boolean SelectWithCtrl = False;
	Time tm;
	XmNlListTreeItem * item, ** sel_item, *current_item;
	char pos;

	if (!rcol->rescol.HasFocus) {
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		rcol->rescol.HasFocus = True;
	}

	if (rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
		return ;


	x = bevent->x;
	y = bevent->y;

	res = ClickInRow ((unsigned long) x, (unsigned long) y, w);
#ifdef DEBUG
	printf("\n ++++++++++++++++  Clicked to: %d\n", res);
#endif

	if (rcol->rescol.TreeMode)
	{
		item = ListTreeClickInItem(rcol, &pos, res, x, y);
		if (item && pos == ClickInControl)
		{
			if (item && item->firstchild && item->open)
			{
#ifdef DEBUG
				printf("--Close\n");
#endif
				item->open = False;
				UnselectBranch(rcol, item);
				current_item = NULL;
				if (rcol->rescol.current_row != -1 && rcol->rescol.current_row < rcol->rescol.num_rows)
				{
					current_item = rcol->rescol.ItemData[rcol->rescol.current_row][COL_MAPPED(0)].node;
					cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//					cell->selected = cell->selected & NotThisCurrentMask;
				}
				sel_item = (XmNlListTreeItem **) XtCalloc(rcol->rescol.num_rows, sizeof(XmNlListTreeItem *));
				num = rcol->rescol.num_rows;
				CollectSelectItem(rcol, sel_item);
				RCCountAll(rcol);
				rcol->rescol.current_row = -1;
				if (current_item)
				{
					for (i = 0; i < rcol->rescol.num_rows; i++)
					{
						if (current_item == rcol->rescol.ItemData[i][COL_MAPPED(0)].node)
						{
							cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
//							cell->selected = cell->selected | ThisCurrentMask;
							rcol->rescol.current_row = i;
						}
					}
				}
				RestoreSelectItem(rcol, sel_item, num);
				XtFree((char *) sel_item);
				RebuildSelectedPositionsOnly(rcol);
				CalcGeomPostInit(w);
				AdjustGlobalHorShift(w);
				CalcColParam(w);
				if (rcol->rescol.global_v_shift+rcol->rescol.viewHeight > rcol->rescol.full_height)
					rcol->rescol.global_v_shift=rcol->rescol.full_height-rcol->rescol.viewHeight;
				if (rcol->rescol.global_v_shift < 0) rcol->rescol.global_v_shift=0;
				rcol->rescol.TopLine=rcol->rescol.global_v_shift/rcol->rescol.cell_height;
				rcol->rescol.BotomLine=rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;
				ResizeSliders(w, AllScroll);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(rcol);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(rcol, event, item);
				return;
			}
			if (item && item->firstchild && !(item->open))
			{
#ifdef DEBUG
				printf("--Open\n");
#endif
				item->open=True;
				current_item = NULL;
				if (rcol->rescol.current_row != -1 && rcol->rescol.current_row < rcol->rescol.num_rows)
				{
					current_item = rcol->rescol.ItemData[rcol->rescol.current_row][COL_MAPPED(0)].node;
					cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//					cell->selected = cell->selected & NotThisCurrentMask;
				}
				sel_item = (XmNlListTreeItem **) XtCalloc(rcol->rescol.num_rows, sizeof(XmNlListTreeItem *));
				num = rcol->rescol.num_rows;
				CollectSelectItem(rcol, sel_item);

				RCCountAll(rcol);
				rcol->rescol.current_row = -1;
				if (current_item)
				{
					for (i=0; i<rcol->rescol.num_rows; i++)
					{
						if (current_item == rcol->rescol.ItemData[i][COL_MAPPED(0)].node)
						{
							rcol->rescol.current_row = i;
							cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
//							cell->selected = cell->selected | ThisCurrentMask;
						}
					}
				}
				RestoreSelectItem(rcol, sel_item, num);
				XtFree((char *) sel_item);
				RebuildSelectedPositionsOnly(rcol);

				CalcGeomPostInit(w);
				AdjustGlobalHorShift(w);
				CalcColParam(w);
				ResizeSliders(w, AllScroll);
				if (XtIsRealized(w) )
				{
					RCRedrawAllWindow(w);
					CurrentFrameDraw(w);
				}
//				RefreshTitleBar(rcol);
//				CalcViewPosition(lt);
//				ResizeSliders(w);
//				InternRedisplay(w);
//				BranchActionDoCallback(lt, event, item);
				return;
			}

		}
		if (item && pos == ClickInBody)
		{

//			UnselectAllItem(rcol);

//			item->highlighted = True;
#ifdef DEBUG
				printf("ClicInBody\n");
#endif
//			return ;
		}
	}

	if (res != -1 && rcol->rescol.current_row >= 0 && rcol->rescol.current_row != res)
	{
		CurrentFrameRemoveDraw(w);
		if (rcol->rescol.current_row < rcol->rescol.num_rows)
		{
			cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//			cell->selected = cell->selected & NotThisCurrentMask;
		}
	}
	
	if (res != -1)
	{
		if (rcol->rescol.selected_rows[res] != True)
		{
			rcol->rescol.selected_rows[res] = True;
			if (res < rcol->rescol.num_rows)
			{
				cell = rcol->rescol.ItemData[res] + COL_MAPPED(0);
//				cell->selected = cell->selected | InSelectMask;
			}
			if (rcol->rescol.buffering) RefreshCachePix(w, res, True);
			RCDrawRows(w, res, res + 1, 0);
		}
	}

	RebuildSelectedPositionsOnly(rcol);

	rcol->rescol.sm_tm = 0;
	rcol->rescol.clicked_item = res;

	if (res >=0) rcol->rescol.current_row = res;

	if (rcol->rescol.current_row < rcol->rescol.num_rows && rcol->rescol.current_row >= 0)
	{
		cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
//		cell->selected = cell->selected | ThisCurrentMask;
	}

	CurrentFrameDraw(w);
	HighlightDoCallback(w);

	return;
}

static void ButtonDownActionExtended(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    static Position x, y;
    int res, i, num;
    XButtonEvent * bevent = (XButtonEvent *) event;
	XmNlRCL_Cell  * cell;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Boolean SelectWithCtrl = False;
	Time tm;
	XmNlListTreeItem * item, ** sel_item, *current_item;
	char pos;

	if (rcol->rescol.TreeMode)
	{
		ButtonDownAction(w, event, params, num_params);
		return ;
	}
	

	if (!rcol->rescol.HasFocus) {
		XmProcessTraversal(w, XmTRAVERSE_CURRENT);
		rcol->rescol.HasFocus = True;
	}

	if (rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
		return ;


	x = bevent->x;
	y = bevent->y;

	res = ClickInRow ((unsigned long) x, (unsigned long) y, w);
#ifdef DEBUG
	printf("\n ++++++++++++++++  Clicked to: %d\n", res);
#endif

	if (res != -1 && HitToSelected(rcol, res))
	{
#ifdef DEBUG
		printf("ButtonDownAction hit to selected\n");
#endif
		if (rcol->rescol.current_row != res && rcol->rescol.ItemData[res] != rcol->rescol.currentItem)
		{
#ifdef DEBUG
			printf("ButtonDownAction redrawing current frame\n");
#endif
			CurrentFrameRemoveDraw(w);
			rcol->rescol.current_row = res;
			rcol->rescol.currentItem = rcol->rescol.ItemData[res];
			if (rcol->rescol.TreeMode)
			{
				cell = rcol->rescol.ItemData[res] + COL_MAPPED(0);
				rcol->rescol.currentTreeNode = cell->node;
			}
			CurrentFrameDraw(w);
		}
		return ;
	}

	if (res != -1 && rcol->rescol.current_row >= 0 && rcol->rescol.current_row != res)
	{
		CurrentFrameRemoveDraw(w);
	}
	
	if (res != -1)
	{
		if (rcol->rescol.selected_rows[res] != True)
		{
			rcol->rescol.selected_rows[res] = True;
			if (res < rcol->rescol.num_rows)
			{
				cell = rcol->rescol.ItemData[res] + COL_MAPPED(0);
				cell->selected = True;
			}
			RebuildSelectedPositionsOnly(rcol);
			HighlightDoCallback(w);
			if (rcol->rescol.buffering) RefreshCachePix(w, res, True);
			RCDrawRows(w, res, res + 1, 0);
		}
	}


	rcol->rescol.sm_tm = 0;
	rcol->rescol.clicked_item = res;

	if (res >= 0) rcol->rescol.current_row = res;

	CurrentFrameDraw(w);
//	HighlightDoCallback(w);

	return;
}



static void ButtonUpAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XButtonEvent * bevent = (XButtonEvent *) event;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    Position x, y;
    int res;
	Time tm;

    if (*num_params > 1) return;
	if (bevent->button == 1)
	{
		if (rcol->rescol.DblClicked == True)
		{
//			x = bevent->x;
//			y = bevent->y;
#ifdef DEBUG
			  printf("\n ++++++++++DoubleClick Action++++++++++ !\n");
#endif
			rcol->rescol.DblClicked = False;
			DoubleClickDoCallback(w, rcol->rescol.clicked_item);
			rcol->rescol.sm_tm = rcol->rescol.sm_tm - rcol->rescol.multiclick;
		}
	}
	return;
}


static void MotionAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
//    XButtonEvent * bevent = (XButtonEvent *) event;


}


static void ScrollAction(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
//    XAnyEvent * any_event = (XAnyEvent *) event;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    int shift = rcol->rescol.global_v_shift;
#ifdef DEBUG
    printf("\n  Scroll action\n");
#endif



    if (*num_params > 1) return;

	if (*num_params == 1) {
	    switch (params[0][0]) {
	    case 'u':
	    case 'U':
#ifdef DEBUG
		printf("\n  Scroll up\n");
#endif
			shift = shift - ScrollStep;
			SetVerShift(w, shift, False);
			ResizeSliders(w, VerticalScroll);
			break;
	    case 'd':
	    case 'D':
#ifdef DEBUG
		printf("\n  Scroll down\n");
#endif
			shift = shift + ScrollStep;
			SetVerShift(w, shift, False);
			ResizeSliders(w, VerticalScroll);
			break;
	    default:
			return;
		}
	}
}

static Boolean
SelectChanged(XmNlResColListWidget it)
{

}


void MakeResizeCallbackStruct(XmNlResColListWidget rcol, ListResizeReturnStruct *ret)
{
	int i;
    XmNlRCL_Property_Row * prw;

	/* Adjust vertical shift */
	prw=rcol->rescol.prop_data;

	if (!rcol->rescol.col_sharp_width)
		rcol->rescol.col_sharp_width = (int *)XtMalloc(rcol->rescol.num_cols*sizeof(int));
	if (!rcol->rescol.col_cur_width)
		rcol->rescol.col_cur_width = (int *)XtMalloc(rcol->rescol.num_cols*sizeof(int));
	if (!rcol->rescol.col_new_width)
		rcol->rescol.col_new_width = (int *)XtMalloc(rcol->rescol.num_cols*sizeof(int));

	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		*(rcol->rescol.col_sharp_width + i) = (prw+COL_MAPPED(i))->real_width;
		*(rcol->rescol.col_cur_width + i) = (prw+COL_MAPPED(i))->current_width;
		*(rcol->rescol.col_new_width + i) = 0;
	}

	ret->cols_num = rcol->rescol.num_cols;
	ret->wid_width = rcol->rescol.viewWidth;
	ret->last_wid_width = rcol->rescol.lastViewWidth;
	ret->col_sharp_width = rcol->rescol.col_sharp_width;
	ret->col_cur_width = rcol->rescol.col_cur_width;
	ret->col_new_width = rcol->rescol.col_new_width;
	ret->list_full_width = rcol->rescol.full_width;
	ret->cur_h_shift = rcol->rescol.global_h_shift;
	ret->new_h_shift = 0;
}


static void
MakeHighlightCallbackStruct(XmNlResColListWidget rcol, ListItemReturnStruct * ret)
{
	int i, counter;
//	XmNlRCL_Cell  * cell;
//	cell=rcol->rescol.item_data;
	counter=0;
#ifdef DEBUG
	printf("\nMakeHighlightCallbackStruct called\n");
#endif
/*	if (ret->number!=NULL)
	{
#ifdef DEBUG
	printf("\nMakeHighlightCallbackStruct: free called\n");
#endif
	free(ret->number);
	}*/
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i] == True) counter++;
	}
#ifdef DEBUG
	printf("\nMakeHighlightCallbackStruct: Counter=%d\n", counter);
#endif
	ret->count = counter;
	if (counter == 0) return;

	ret->number = (int *)XtRealloc((char *) ret->number, counter*sizeof(int));
	ret->pointers = (void *)XtRealloc((char *) ret->pointers, counter*sizeof(void *));
	counter = 0;
	for (i = 0; i<rcol->rescol.num_rows; i++)
	{
		if (rcol->rescol.selected_rows[i] == True)
		{
//		counter++;
			ret->number[counter] = i;
//		ret->pointers[counter]=cell[i].UserDataPointer;
			ret->pointers[counter] = RCgetCell((Widget)rcol, i, 0)->UserDataPointer;
#ifdef DEBUG
		printf("\nItem_number=%d\n", ret->number[counter]);
//		printf("\nMakeHighlightCallbackStruct: Item_number=%d\n", ret->number[i]);
#endif
			counter++;
		}

	}

}

static void
ResizeDoCallback(Widget w, char mode, int source)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
//    ListResizeReturnStruct ret;
    static ListResizeReturnStruct ret;
//    ItemActivateReturnStruct ret;
//    XmNlRCL_Cell  * cell;
//    cell=rcol->rescol.item_data+number;
	int i;
	ret.reason = source;
	ret.state = mode;


	if (rcol->rescol.resizeCallback) {

		MakeResizeCallbackStruct(rcol, &ret);

		XtCallCallbacks(w, XmNlrcResizeCallback, (XtPointer) &ret);

#ifdef DEBUG
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			printf("ResCol new width%d = %d\n", i, ret.col_new_width[i]);
		}
#endif
		rcol->rescol.full_width = ret.list_full_width;
		rcol->rescol.new_global_h_shift = ret.new_h_shift;
	}
}

static void
DoubleClickDoCallback(Widget w, int number)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    ItemActivateReturnStruct ret;
//    XmNlRCL_Cell  * cell;
//    cell=rcol->rescol.item_data+number;

	if (rcol->rescol.double_click) {
		ret.item_number = number;
//    ret.pointer=cell->UserDataPointer;
		ret.pointer = RCgetCell((Widget)rcol, number, 0)->UserDataPointer;
		XtCallCallbacks(w, XmNdoubleClickCallback, (XtPointer) &ret);
	}

}

static void
HighlightDoCallback(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    static ListItemReturnStruct ret;
#ifdef DEBUG
		printf("\n HighlightDoCallback called\n");
#endif

	if (rcol->rescol.highlightCallback) {
		MakeHighlightCallbackStruct(rcol, &ret);
		XtCallCallbacks(w, XtNhighlightCallback, (XtPointer) &ret);
#ifdef DEBUG
		printf("\n HighlightDoCallback: callbacks transfered\n");
#endif
//    if (ret.number) XtFree(ret.number);
//    if (ret.number!=NULL) free(ret.number);
#ifdef DEBUG
		printf("\n HighlightDoCallback complet\n");
#endif
	}
}

static void PressUp(Widget w, XEvent *event, String *params, Cardinal *num_params)

{
	int shift, delta, i;
	XmNlRCL_Cell * cell;
	XmNlListTreeItem * item;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	if (rcol->rescol.num_rows == 0)
		return;

	if (rcol->rescol.current_row == 0) return;

	if (rcol->rescol.TreeMode && rcol->rescol.currentVisibleParentTreeNode != NULL 
		&& rcol->rescol.currentVisibleParentTreeNode != rcol->rescol.currentTreeNode && rcol->rescol.current_row == -1)
	{
		int finded_row;
		XmNlRCL_Property_Row * rw = rcol->rescol.prop_data;;

#ifdef DEBUG
		PrintNodePath(rcol->rescol.currentVisibleParentTreeNode, "Next expanded to");
#endif
//		ExpandFromCurrentToParent(rcol, rcol->rescol.first);
		ExpandFromCurrentToParent(rcol, rcol->rescol.currentVisibleParentTreeNode);
		RCCountAll(rcol);
		finded_row = FindCurrentTreeNodeInRowList(rcol);
		if (finded_row >= 0)
		{
			rcol->rescol.current_row = finded_row;
			cell = rcol->rescol.ItemData[finded_row] + COL_MAPPED(0);
			rcol->rescol.currentVisibleParentTreeNode = cell->node;
			rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
		}
		else
		{
			rcol->rescol.current_row = -1;
			rcol->rescol.currentVisibleParentTreeNode = NULL;
			return ;
		}

//				RebuildSelectedPositions(rcol);
//		RebuildSelectedRows(rcol);

		if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
		{
			ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

			delta = 0;

			for (i = 0; i < rcol->rescol.num_cols; i++)
			{
				rw[COL_MAPPED(i)].x = delta;
				rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
				delta = delta + rw[COL_MAPPED(i)].current_width;
			}

			rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
			rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
			rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
		}
				
		if (!rcol->rescol.resizeCallback) 
			CalcGeomPostInit(w);

		AdjustGlobalHorShift(w);
		ResizeSliders(w, AllScroll);
		CalcColParam(w);

		if (rcol->rescol.current_row != -1 && rcol->rescol.current_row != 0)
		{
		DeselctAll(w, 0);

			rcol->rescol.current_row--;
			cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
			cell->selected = True;
			rcol->rescol.currentVisibleParentTreeNode = cell->node;
			rcol->rescol.currentTreeNode = cell->node;
			rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
			if (rcol->rescol.current_row != 0)
				rcol->rescol.selected_rows[rcol->rescol.current_row + 1] = False;
		}

		if (rcol->rescol.buffering) RefreshCachePix(w, rcol->rescol.current_row, True);

		shift = CheckCurrentVisible(w);
		if (shift >= 0)
		{
			SetVerShift(w, shift, True);
			ResizeSliders(w, AllScroll);
		}

		RCRedrawAllWindow(w);
		CurrentFrameDraw(w);
		RebuildSelectedPositionsOnly(rcol);
		HighlightDoCallback(w);

		return ;
	}


	CurrentFrameRemoveDraw(w);
	rcol->rescol.current_row--;
	DeselctAll(w, 1);
	rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
	RebuildSelectedPositionsOnly(rcol);
	if (rcol->rescol.buffering) RefreshCachePix(w, rcol->rescol.current_row, True);
	if (rcol->rescol.TreeMode)
	{
		cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
		item = cell->node;
		item->highlighted = True;
		rcol->rescol.currentVisibleParentTreeNode = item;
		rcol->rescol.currentTreeNode = item;
	}
	cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
	cell->selected = True;
	rcol->rescol.currentItem = cell;
//	if (rcol->rescol.current_row)
	shift = CheckCurrentVisible(w);
	if (shift >= 0)
	{
		SetVerShift (w, shift, True);
		CurrentFrameDraw(w);
		ResizeSliders(w, AllScroll);
	}
	else
	{
		RCDrawRows(w, rcol->rescol.current_row, rcol->rescol.current_row + 1, 0);
		CurrentFrameDraw(w);
	}
	HighlightDoCallback(w);
}

static void PressDown(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	int shift, delta, i;
	XmNlRCL_Cell * cell;
	XmNlListTreeItem * item;
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	if (rcol->rescol.num_rows == 0)
		return;

	if (rcol->rescol.current_row == rcol->rescol.num_rows - 1) 
		return;
		
	
	if (rcol->rescol.TreeMode && rcol->rescol.currentVisibleParentTreeNode != NULL 
		&& rcol->rescol.currentVisibleParentTreeNode != rcol->rescol.currentTreeNode && rcol->rescol.current_row == -1)
	{
		int finded_row;
		XmNlRCL_Property_Row * rw = rcol->rescol.prop_data;;

#ifdef DEBUG
		PrintNodePath(rcol->rescol.currentVisibleParentTreeNode, "Next expanded to");
#endif
//		ExpandFromCurrentToParent(rcol, rcol->rescol.first);
		ExpandFromCurrentToParent(rcol, rcol->rescol.currentVisibleParentTreeNode);
		RCCountAll(rcol);
		finded_row = FindCurrentTreeNodeInRowList(rcol);
		if (finded_row >= 0)
		{
			rcol->rescol.current_row = finded_row;
			cell = rcol->rescol.ItemData[finded_row] + COL_MAPPED(0);
			rcol->rescol.currentVisibleParentTreeNode = cell->node;
			rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
		}
		else
		{
			rcol->rescol.current_row = -1;
			rcol->rescol.currentVisibleParentTreeNode = NULL;
			return ;
		}

//				RebuildSelectedPositions(rcol);
//		RebuildSelectedRows(rcol);

		if (rcol->rescol.num_cols > 1 && rcol->rescol.treeColAutoResize && rcol->rescol.resizeCallback)
		{
			ResizeDoCallback(w, XmNlItemsFound, XmNlTreeSizeChange);

			delta = 0;

			for (i = 0; i < rcol->rescol.num_cols; i++)
			{
				rw[COL_MAPPED(i)].x = delta;
				rw[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
				delta = delta + rw[COL_MAPPED(i)].current_width;
			}

			rcol->rescol.scroll_width = rcol->rescol.full_width - rcol->rescol.viewWidth;
			rcol->rescol.full_height = rcol->rescol.cell_height * rcol->rescol.num_rows;
			rcol->rescol.scroll_height = rcol->rescol.full_height - rcol->rescol.viewHeight;
		}
				
		if (!rcol->rescol.resizeCallback) 
			CalcGeomPostInit(w);

		AdjustGlobalHorShift(w);
		ResizeSliders(w, AllScroll);
		CalcColParam(w);

		if (rcol->rescol.current_row != -1 && rcol->rescol.current_row != (rcol->rescol.num_rows - 1))
		{
			DeselctAll(w, 0);

			rcol->rescol.current_row++;
			cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
			cell->selected = True;
			rcol->rescol.currentVisibleParentTreeNode = cell->node;
			rcol->rescol.currentTreeNode = cell->node;
			rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
			if (rcol->rescol.current_row != 0)
				rcol->rescol.selected_rows[rcol->rescol.current_row - 1] = False;
		}

		if (rcol->rescol.buffering) RefreshCachePix(w, rcol->rescol.current_row, True);

		shift = CheckCurrentVisible(w);
		if (shift >= 0)
		{
			SetVerShift(w, shift, True);
			ResizeSliders(w, AllScroll);
		}

		RCRedrawAllWindow(w);
		CurrentFrameDraw(w);
		RebuildSelectedPositionsOnly(rcol);
		HighlightDoCallback(w);

		return ;
	}
	
	CurrentFrameRemoveDraw(w);
	rcol->rescol.current_row++;
	DeselctAll(w, 1);
	rcol->rescol.selected_rows[rcol->rescol.current_row] = True;
	RebuildSelectedPositionsOnly(rcol);
	if (rcol->rescol.buffering) RefreshCachePix(w, rcol->rescol.current_row, True);
	if (rcol->rescol.TreeMode)
	{
		cell = rcol->rescol.ItemData[rcol->rescol.current_row] + COL_MAPPED(0);
		item = cell->node;
		item->highlighted = True;
		rcol->rescol.currentVisibleParentTreeNode = item;
		rcol->rescol.currentTreeNode = item;
	}
	cell = rcol->rescol.ItemData[rcol->rescol.current_row];
	cell->selected = True;
	rcol->rescol.currentItem = cell;
//	if (rcol->rescol.current_row)
	shift = CheckCurrentVisible(w);
	if (shift >= 0)
	{
		SetVerShift(w, shift, True);
		CurrentFrameDraw(w);
		ResizeSliders(w, AllScroll);
	}
	else
	{
		RCDrawRows(w, rcol->rescol.current_row, rcol->rescol.current_row + 1, 0);
		CurrentFrameDraw(w);
	}
	HighlightDoCallback(w);
}

static void PressLeft(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	SetHorShift(w, rcol->rescol.global_h_shift - 10, True);
	CurrentFrameDraw(w);
	ResizeSliders(w, AllScroll);
	if (rcol->rescol.title_bar != NULL)
	{
		PRSetShift(rcol->rescol.title_bar, rcol->rescol.global_h_shift);
	}
}

static void PressRight(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	SetHorShift(w, rcol->rescol.global_h_shift + 10, True);
	CurrentFrameDraw(w);
	ResizeSliders(w, AllScroll);
	if (rcol->rescol.title_bar != NULL)
	{
		PRSetShift(rcol->rescol.title_bar, rcol->rescol.global_h_shift);
	}
}

static void PressSpace(Widget w, XEvent *event, String *params, Cardinal *num_params)
{

}

static void PressEnter(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

	if (rcol->rescol.num_rows == 0) return;

	if (rcol->rescol.current_row >= 0 && rcol->rescol.selected_rows[rcol->rescol.current_row] == True)
	{
#ifdef DEBUG
		printf("\n PressEnter Action !\n");
#endif
		DoubleClickDoCallback(w, rcol->rescol.current_row);
	}
}

static void PressPrevTab(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

#ifdef DEBUG
	printf("\n KeyPressAction: Prev Tab\n");
#endif
	XtCallActionProc(w, "PrimitivePrevTabGroup", event, params, *num_params);
}

static void PressNextTab(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

#ifdef DEBUG
	printf("\n KeyPressAction: Next Tab\n");
#endif
	XtCallActionProc(w, "PrimitiveNextTabGroup", event, params, *num_params);
	return;
}


static int CheckCurrentVisible(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    int y1, y2, viewY1, viewY2;



//	if (!rcol->rescol.FocusFound || rcol->rescol.num_rows==0) return;


/* Check: selected row in viewed area */
	y1 = rcol->rescol.cell_height * rcol->rescol.current_row;
	y2 = y1 + rcol->rescol.cell_height;
	viewY1 = rcol->rescol.global_v_shift;
	viewY2 = viewY1 + rcol->rescol.viewHeight;

//	printf("\n CheckCurrentVisible: y1 %d y2 %d v1 %d v2 %d\n", y1, y2, viewY1, viewY2);

	if (y1 >= viewY2)
		return y2-rcol->rescol.viewHeight;
	if (y2 <= viewY1)
		return y1;

	return -1;
}


static void CurrentFrameDraw(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    int x, y, wi, hi, y1, y2, viewY1, viewY2;

    unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;


	XGCValues values;
	unsigned long mask;
	mask = GCLineStyle | GCLineWidth | GCFillStyle;
	XPoint points[5];

	if (!rcol->rescol.HasFocus || rcol->rescol.num_rows == 0) return;

    background_color = rcol->rescol.background_pixel;
    foreground_color = rcol->rescol.foreground_pixel;
    sel_bg_color = rcol->rescol.select_background_pixel;
    sel_fg_color = rcol->rescol.select_foreground_pixel;

/* Check: selected row in viewed area */
	y1 = rcol->rescol.cell_height * rcol->rescol.current_row;
	y2 = y1 + rcol->rescol.cell_height;
	viewY1 = rcol->rescol.global_v_shift;
	viewY2 = viewY1 + rcol->rescol.viewHeight;
	if (y1 > viewY2 || y2 < viewY1) 
		return;


/*	XSetForeground(XtDisplay(w), rcol->rescol.drawGC, background_color);
	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);

	x=rcol->rescol.viewX;
	wi=rcol->rescol.viewWidth;
	y=y1-viewY1+rcol->rescol.margin_h+rcol->rescol.viewY;
	hi=rcol->rescol.full_selection_w;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	y=y2-viewY1-rcol->rescol.margin_h-rcol->rescol.full_selection_w+rcol->rescol.viewY;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	wi=rcol->rescol.full_selection_w;
	y=y1-viewY1+rcol->rescol.margin_h+rcol->rescol.viewY;
	hi=rcol->rescol.cell_height - 2*rcol->rescol.margin_h;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	x=rcol->rescol.viewX + rcol->rescol.viewWidth - rcol->rescol.full_selection_w;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);
*/

/* Prepare drawGC to draw selection frame */

	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);
	XSetForeground(XtDisplay(w), rcol->rescol.drawGC,
					((XmPrimitiveWidget)w)->primitive.highlight_color);
	values.line_style = LineSolid;
//  values.line_style = LineOnOffDash;
	values.line_width = rcol->rescol.select_line_w;
	values.fill_style = FillSolid;
//  values.fill_style =   FillOpaqueStippled;
	XChangeGC(XtDisplay(w), rcol->rescol.drawGC, mask, &values);

//	points[0].x=rcol->rescol.viewX + rcol->rescol.select_line_margin
//				+ rcol->rescol.select_line_w/2 - rcol->rescol.global_h_shift;
	if (rcol->rescol.render_order == LtoR_render)
		points[0].x = rcol->rescol.viewX + rcol->rescol.select_line_w/2 - rcol->rescol.global_h_shift;
	else
		points[0].x = rcol->rescol.viewWidth - rcol->rescol.select_line_w/2 + rcol->rescol.global_h_shift;
	
//	points[0].y=y1-viewY1+rcol->rescol.viewY
//				+ rcol->rescol.select_line_margin + rcol->rescol.select_line_w/2;
	points[0].y = y1-viewY1+rcol->rescol.viewY + rcol->rescol.select_line_w/2;
//	points[1].x=rcol->rescol.viewX+rcol->rescol.full_width - rcol->rescol.global_h_shift
//				- rcol->rescol.select_line_margin - rcol->rescol.select_line_w/2;
	if (rcol->rescol.render_order == LtoR_render)
		points[1].x = rcol->rescol.viewX+rcol->rescol.full_width - rcol->rescol.global_h_shift
					- rcol->rescol.select_line_w/2;
	else
		points[1].x = rcol->rescol.viewWidth - rcol->rescol.full_width + rcol->rescol.global_h_shift
					+ rcol->rescol.select_line_w/2;
	points[1].y = points[0].y;
	points[2].x = points[1].x;
//	points[2].y=y2-viewY1-rcol->rescol.select_line_margin
//				- rcol->rescol.select_line_w/2 + rcol->rescol.viewY;
	points[2].y = y2 - viewY1 - rcol->rescol.select_line_w/2 + rcol->rescol.viewY;
	points[3].x=points[0].x;
	points[3].y=points[2].y;
	points[4].x=points[0].x;
	points[4].y=points[0].y;

	XSetClipOrigin(XtDisplay(w), rcol->rescol.drawGC, 0, 0);
	XSetClipMask(XtDisplay(w), rcol->rescol.drawGC, None);

	XDrawLines(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC, points, 5, CoordModeOrigin);

/* Restoring drawGC */
	XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);
	values.line_style = LineSolid;
//  values.line_style = LineOnOffDash;
	values.line_width = 1;
	values.fill_style = FillSolid;
//  values.fill_style =   FillOpaqueStippled;

	XChangeGC(XtDisplay(w), rcol->rescol.drawGC, mask, &values);

}

static void CurrentFrameRemoveDraw(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
    int x, y, wi, hi, y1, y2, viewY1, viewY2;

    unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;


	XGCValues values;
	unsigned long mask;
	mask = GCLineStyle | GCLineWidth | GCFillStyle;
	XPoint points[5];


//	if (/*rcol->rescol.HasFocus ||*/ rcol->rescol.num_rows==0) return;
    background_color = rcol->rescol.background_pixel;
    foreground_color = rcol->rescol.foreground_pixel;
    sel_bg_color = rcol->rescol.select_background_pixel;
    sel_fg_color = rcol->rescol.select_foreground_pixel;

/* Check: selected row in viewed area */
	y1 = rcol->rescol.cell_height * rcol->rescol.current_row;
	y2 = y1 + rcol->rescol.cell_height;
	viewY1 = rcol->rescol.global_v_shift;
	viewY2 = viewY1+rcol->rescol.viewHeight;
	if (y1 > viewY2 || y2 < viewY1) return;


/*	XSetForeground(XtDisplay(w), rcol->rescol.drawGC, background_color);
	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);

	x=rcol->rescol.viewX;
	wi=rcol->rescol.viewWidth;
	y=y1-viewY1+rcol->rescol.margin_h+rcol->rescol.viewY;
	hi=rcol->rescol.full_selection_w;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	y=y2-viewY1-rcol->rescol.margin_h-rcol->rescol.full_selection_w+rcol->rescol.viewY;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	wi=rcol->rescol.full_selection_w;
	y=y1-viewY1+rcol->rescol.margin_h+rcol->rescol.viewY;
	hi=rcol->rescol.cell_height - 2*rcol->rescol.margin_h;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);

	x=rcol->rescol.viewX + rcol->rescol.viewWidth - rcol->rescol.full_selection_w;
	XFillRectangle(XtDisplay(w),XtWindow (w), rcol->rescol.drawGC, x, y, wi, hi);
*/

/* Prepare drawGC to draw selection frame */

	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);
//	if (rcol->rescol.selected_rows[rcol->rescol.current_row]==True)
//		XSetForeground(XtDisplay(w), rcol->rescol.drawGC, sel_bg_color);
//	else
	XSetForeground(XtDisplay(w), rcol->rescol.drawGC, background_color);

	values.line_style = LineSolid;
//  values.line_style = LineOnOffDash;
	values.line_width = rcol->rescol.select_line_w;
	values.fill_style = FillSolid;
//  values.fill_style =   FillOpaqueStippled;

	XChangeGC(XtDisplay(w), rcol->rescol.drawGC, mask, &values);

//	points[0].x=rcol->rescol.viewX + rcol->rescol.select_line_margin
//				+ rcol->rescol.select_line_w/2 - rcol->rescol.global_h_shift;

	if (rcol->rescol.render_order == LtoR_render)
		points[0].x = rcol->rescol.viewX + rcol->rescol.select_line_w/2 - rcol->rescol.global_h_shift;
	else
		points[0].x = rcol->rescol.viewWidth - rcol->rescol.select_line_w/2 + rcol->rescol.global_h_shift;

//	points[0].y=y1-viewY1+rcol->rescol.viewY
//				+ rcol->rescol.select_line_margin + rcol->rescol.select_line_w/2;
	points[0].y = y1-viewY1+rcol->rescol.viewY + rcol->rescol.select_line_w/2;
//	points[1].x=rcol->rescol.viewX+rcol->rescol.full_width - rcol->rescol.global_h_shift
//				- rcol->rescol.select_line_margin - rcol->rescol.select_line_w/2;
	if (rcol->rescol.render_order == LtoR_render)
		points[1].x = rcol->rescol.viewX+rcol->rescol.full_width - rcol->rescol.global_h_shift
					- rcol->rescol.select_line_w/2;
	else
		points[1].x = rcol->rescol.viewWidth - rcol->rescol.full_width + rcol->rescol.global_h_shift
					+ rcol->rescol.select_line_w/2;

	points[1].y = points[0].y;
	points[2].x = points[1].x;
//	points[2].y=y2-viewY1-rcol->rescol.select_line_margin
//				- rcol->rescol.select_line_w/2 + rcol->rescol.viewY;
	points[2].y = y2 - viewY1 - rcol->rescol.select_line_w/2 + rcol->rescol.viewY;
	points[3].x = points[0].x;
	points[3].y = points[2].y;
	points[4].x = points[0].x;
	points[4].y = points[0].y;
	XDrawLines(XtDisplay(w), XtWindow(w), rcol->rescol.drawGC, points, 5, CoordModeOrigin);

/* Restoring drawGC */
	XSetForeground(XtDisplay(w), rcol->rescol.drawGC, foreground_color);
	XSetBackground(XtDisplay(w), rcol->rescol.drawGC, background_color);
	values.line_style = LineSolid;
//  values.line_style = LineOnOffDash;
	values.line_width = 1;
	values.fill_style = FillSolid;
//  values.fill_style =   FillOpaqueStippled;

	XChangeGC(XtDisplay(w), rcol->rescol.drawGC, mask, &values);

}



static void Focus_In(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell * cell;
/*    int x, y, wi, hi, y1, y2, viewY1, viewY2;

    unsigned long background_color, foreground_color, sel_bg_color, sel_fg_color;

    background_color=rcol->rescol.background_pixel;
    foreground_color=rcol->rescol.foreground_pixel;
    sel_bg_color=rcol->rescol.select_background_pixel;
    sel_fg_color=rcol->rescol.select_foreground_pixel;*/

#ifdef DEBUG
	printf("\nFOCUS IN current row = %d\n", rcol->rescol.current_row);
#endif

	if (!rcol->rescol.HasFocus)
	{

//    XtCallActionProc(w, "PrimitiveFocusIn", event, params, *num_params);

		rcol->rescol.HasFocus = True;
		if (rcol->rescol.current_row < 0 && rcol->rescol.num_rows > 0) 
		{
			rcol->rescol.current_row = 0;
//			cell = rcol->rescol.ItemData[0];
//			cell->selected = cell->selected | ThisCurrentMask;
		}

		CurrentFrameDraw(w);

//	RCInternRedisplay(w);
		return;
	}
}

static void Focus_Out(Widget w, XEvent *event, String *params, Cardinal *num_params)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;

    int y1, y2, viewY1, viewY2;

#ifdef DEBUG
	printf("\nFOCUS OUT\n");
#endif

	if (rcol->rescol.HasFocus) {
//    XtCallActionProc(w, "PrimitiveFocusOut", event, params, *num_params);

		rcol->rescol.HasFocus = False;

		CurrentFrameRemoveDraw(w);

		return ;

		if (rcol->rescol.current_row < 0) rcol->rescol.current_row = 0;
		y1 = rcol->rescol.cell_height * rcol->rescol.current_row;
		y2 = y1 + rcol->rescol.cell_height;
		viewY1 = rcol->rescol.global_v_shift;
		viewY2 = viewY1+rcol->rescol.viewHeight;
		if (y1 > viewY2 || y2 < viewY1) return;

//	if (rcol->rescol.current_row > -1) rcol->rescol.current_row=-1;
//	PutToPixFullRedraw(w);
/*	if (rcol->rescol.buffering) RCInternRedisplay(w);
	if (!rcol->rescol.buffering)
			{
			RCRedrawAllWindow(w);
			}
*/
	}
}

static Pixinfo *
RCGetItemPix(XmNlResColListWidget rcol, XmNlListTreeItem *item, Boolean selected)
{
	Pixinfo *pix;
	XRectangle clip;

	pix = NULL;
	clip.x = rcol->rescol.viewX;
	clip.y = rcol->rescol.viewY;
	clip.width = rcol->rescol.viewWidth;
	clip.height = rcol->rescol.viewHeight;

	if (item->openPixmap || item->closedPixmap) {
		Pixmap pixmap = item->closedPixmap;
		Pixmap mask = item->closedMask;

		Window       root;
		unsigned int pixwidth, pixheight, pixbw, pixdepth;
		int pixx, pixy;

		if (item->open && item->openPixmap) {
			pixmap = item->openPixmap;
			mask = item->openMask;
		}

		if (PIX_FOUND(pixmap)) {
          /* Get the geometry of the pixmap. */
			XGetGeometry(XtDisplay((Widget) rcol), pixmap, &root, &pixx, &pixy,
                       &pixwidth, &pixheight, &pixbw, &pixdepth);

			rcol->rescol.ItemPix.width  = (int) pixwidth;
			rcol->rescol.ItemPix.height = (int) pixheight;
			rcol->rescol.ItemPix.xoff   = 0;
			rcol->rescol.ItemPix.pix   = pixmap;
			rcol->rescol.ItemPix.mask   = mask;
			pix = &rcol->rescol.ItemPix;
		}
	}

	if (!pix) {
		if (item->firstchild || item->type == RCItemBranchType) {
			if (item->open)
			{
				if (selected) pix = &rcol->rescol.OpenSelected;
				else pix = &rcol->rescol.Open;
			}
			else
			{
				if (selected) pix = &rcol->rescol.ClosedSelected;
				else pix = &rcol->rescol.Closed;
			}
		}
		else {
			if (item->open)
			{
				if (selected) pix = &rcol->rescol.LeafOpenSelected;
				else pix = &rcol->rescol.LeafOpen;
			}
			else
			{
				if (selected) pix = &rcol->rescol.LeafSelected;
				else pix = &rcol->rescol.Leaf;
			}
		}
	}

	return pix;
}


static int
RCCountItem(XmNlResColListWidget rcol, XmNlListTreeItem *item, int x, int y)
{
	int height, xpix, xtext, width, clh, clw;
	char * ptr;
	Pixinfo *pix;
	XmNlRCL_Cell * cell = (XmNlRCL_Cell *) item->cell;
	XmNlRCL_Cell * buff;
//	XmString xmlabel;
	XmNlRCL_Property_Row *prow = rcol->rescol.prop_data;

#ifdef DEBUG
	printf("Enter to CountItem: cell text-> %s level: %d\n", cell->text, item->level);
#endif
//  item->count=lt->list.itemCount;
//  lt->list.itemCount++;

	pix = RCGetItemPix(rcol, item, False);

#ifdef TreeManagementDEBUG
	PrintNodePath(item, "CountItem scan: sequence number");
#endif

	if (rcol->rescol.ItemData != NULL)
	{
#ifdef DEBUG
		printf("CountItem: reallocation of %d rows\n", rcol->rescol.num_rows+1);
#endif
//		rcol->rescol.ItemData=(XmNlRCL_Cell *) XtRealloc((char *) *(rcol->rescol.ItemData),
//			(rcol->rescol.num_rows+1) * sizeof (XmNlRCL_Cell *));

//		buff = (XmNlRCL_Cell *) XtMalloc((rcol->rescol.num_rows+1) * sizeof (XmNlRCL_Cell *));
//		memcpy(*(rcol->rescol.ItemData), buff, (rcol->rescol.num_rows+1) * sizeof (XmNlRCL_Cell *));
		buff = (XmNlRCL_Cell *) XtMalloc((rcol->rescol.num_rows+1) * sizeof (XmNlRCL_Cell *));
		memcpy(buff, rcol->rescol.ItemData, (rcol->rescol.num_rows) * sizeof (XmNlRCL_Cell *));
		XtFree((char *) rcol->rescol.ItemData);
		rcol->rescol.ItemData = (XmNlRCL_Cell **) buff;

#ifdef DEBUG
		printf("CountItem: reallocation ok\n");
#endif
	}
	else
	{
#ifdef DEBUG
		printf("CountItem: allocation of 1 row\n");
#endif
		rcol->rescol.ItemData=(XmNlRCL_Cell **) XtMalloc(sizeof (XmNlRCL_Cell *));
#ifdef DEBUG
		printf("CountItem: allocation ok\n");
#endif
	}


#ifdef DEBUG
	printf("CountItem: adding item to %d row\n", rcol->rescol.num_rows);
#endif
	rcol->rescol.ItemData[rcol->rescol.num_rows] = cell;

	item->row = rcol->rescol.num_rows;
	rcol->rescol.num_rows++;
/*	if (rcol->rescol.selected_rows)
	{
		ptr = XtRealloc((char *) rcol->rescol.selected_rows, sizeof(Boolean) * rcol->rescol.num_rows);
		rcol->rescol.selected_rows = (Boolean *) ptr;
	}
	else
	{
		rcol->rescol.selected_rows = (Boolean *) XtCalloc(rcol->rescol.num_rows, sizeof(Boolean));
	}

	rcol->rescol.selected_rows[item->row]=item->highlighted;
*/
#ifdef DEBUG
	printf("CountItem:  %d row\n", rcol->rescol.num_rows);
	int i;
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
		printf("CountItem: allocated cell %d with text-> %s row %d\n", i, cell[COL_MAPPED(0)].text, cell[COL_MAPPED(0)].node->row);
//		if (cell->node->highlighted) printf(" -- selected\n");
//		if (!cell->node->highlighted) printf(" -- not selected\n");
	}
#endif


/* Compute the height of this line */
	height = cell->label_h;
	width = cell->label_w;
#ifdef DEBUG
	printf("CountItem:  calc geom1 \n");
#endif
	if (item->firstchild)
	{
//		xtext = x + rcol->rescol.ctrlWidth + 2 * ((int) rcol->rescol.margin_w) +
//		rcol->rescol.pixWidth;
		xtext = x + rcol->rescol.ctrlWidth + 2 * ((int) rcol->rescol.margin_w) +
		pix->width;
	}
	else
		xtext = x + 2*((int) rcol->rescol.margin_w) + rcol->rescol.pixWidth;
//		xtext = x + (int) rcol->rescol.margin_w + pix->width;
#ifdef DEBUG
	printf("CountItem:  calc geom2 \n");
#endif
#ifdef DEBUG
	printf("\t %s PixWidth=%d xtext=%d xof=%d\n", cell[0].text, pix->width, xtext, pix->xoff);
#endif
/*  if (pix && pix->height > height) {
    height = pix->height;
  }

  if (lt->list.ControlClosed.height > height) {
    height = lt->list.ControlClosed.height;
  }

  if (lt->list.ControlOpen.height > height) {
    height = lt->list.ControlOpen.height;
  }
*/
	item->x = x;
	item->y = item->ytext = -1;
//	if ((item->x + width + rcol->rescol.margin_w) > prow->new_real_width)
//		prow->new_real_width = item->x + width + rcol->rescol.margin_w;
	if ((xtext + width + rcol->rescol.margin_w) > prow->real_width)
		prow->real_width = xtext + width + rcol->rescol.margin_w;

  /* Calc option columns */

#ifdef DEBUG
	printf("CountItem cmplete real width %d\n", prow->real_width);
#endif
	return 0;
}


//static XmNlListTreeItem *
static void RCCountChildren(XmNlResColListWidget rcol, XmNlListTreeItem *item, int x, int y)
{
	XmNlListTreeItem *lastchild, *self = item;
	Boolean opened = False;
	int height, i;
	XmNlRCL_Cell * cell;
	char * lines = item->lines;
#ifdef DEBUG
	printf("CountChildren start\n");
#endif


	lastchild = NULL;
	if (self) self->lastchild = NULL;
	if (item->parent)
		x = x + (int) rcol->rescol.margin_w + rcol->rescol.ctrlWidth;


	while (item)
	{
		height = RCCountItem(rcol, item, x, y);

		y += rcol->rescol.cell_height;
#ifdef DEBUG
		printf("CountChildren: next call RCCountChildren if firstchild found\n");
#endif
		if ((item->firstchild) && (item->open))
		{
#ifdef DEBUG
			printf("CountChildren: next call RCCountChildren -> firstchild found\n");
#endif
			opened = True;

			if (lines)
			{
				memcpy(item->firstchild->lines + 1, lines, sizeof(char) * item->level);
			}

			if (item->nextsibling)
			{
				*(item->firstchild->lines) = 1;
			}
			else
			{
				*(item->firstchild->lines) = 0;
			}

			RCCountChildren(rcol, item->firstchild, x, y);
		}

		item = item->nextsibling;
		if (lines && item)
		{
			memcpy(item->lines, lines, sizeof(char) * item->level);
		}
	}

/*	if (opened)
	{
		for (i = self->row; i < rcol->rescol.num_rows; i++)
		{
			cell = rcol->rescol.ItemData[i];
			lastchild = cell[0].node;
			if (lastchild->parent==self) self->lastchild = lastchild;
		}
	}*/
#ifdef DEBUG
	printf(">>>>>>>>CountChildren complet row %d\n", self->row);
#endif
	return ;
}




void
RCCountAll(XmNlResColListWidget rcol)
{
	int x, y, i, j;
	XmNlRCL_Property_Row *prow;
	Dimension *sizes;
	XmNlListTreeItem * item, * item2;
	XmNlRCL_Cell * cell;
	prow=rcol->rescol.prop_data;


/* Cleaning list of visible rows */

	if (rcol->rescol.ItemData) 
		RCRemoveAllRowsListOnly(rcol);

	rcol->rescol.ItemData = NULL;
	if (rcol->rescol.selected_rows)
	{
		XtFree(rcol->rescol.selected_rows);
		rcol->rescol.selected_rows = NULL;
	}

	rcol->rescol.num_rows = 0;
	rcol->rescol.PublicRowCount = 0;
	prow->new_real_width = 0;
	prow->real_width = 0;
	
	if (!rcol->rescol.first)
		return ;

	x = (int)rcol->rescol.viewX + (int) rcol->rescol.margin_w;
	y = (int)rcol->rescol.viewY + (int) rcol->rescol.margin_h;

	RCCountChildren(rcol, rcol->rescol.first, x, y);

	if (rcol->rescol.selected_rows) XtFree(rcol->rescol.selected_rows);

	rcol->rescol.selected_rows = (Boolean *) XtCalloc(rcol->rescol.num_rows, sizeof(Boolean));

	for (i = 0; i<rcol->rescol.num_rows; i++)
	{
		rcol->rescol.selected_rows[i] = False;
	}

	rcol->rescol.PublicRowCount = rcol->rescol.num_rows;
	rcol->rescol.full_height = rcol->rescol.num_rows * rcol->rescol.cell_height;
#ifdef DEBUG
	printf("Item height=%d\n", rcol->rescol.cell_height);
#endif
}



static void
UnselectChildren(XmNlResColListWidget rcol, XmNlListTreeItem *item)
{
	XmNlListTreeItem *sibling;
	XmNlRCL_Cell * cell;
	int i;
	while (item)
	{
		if (item->firstchild)
		{
			UnselectChildren(rcol, item->firstchild);
		}
		sibling = item->nextsibling;
		item->highlighted = False;

		cell = (XmNlRCL_Cell *) item->cell;
		cell->selected = False;

		RefreshCachePixItemTree((Widget) rcol, cell, False);

/*		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (cell[i].textbuf)
			{
				XFreePixmap(XtDisplay((Widget) rcol), cell[i].textbuf);
				cell[i].textbuf = XmUNSPECIFIED_PIXMAP;
			}
		}*/
		item = sibling;
	}
}


static void
UnselectBranch(XmNlResColListWidget rcol, XmNlListTreeItem *item)
{
	if (item->firstchild) UnselectChildren(rcol, item->firstchild);
}


static void
UnselectAllItem(XmNlResColListWidget rcol)
{
	XmNlListTreeItem *sibling, *item;
	XmNlRCL_Cell * cell;
	int i;

	item = rcol->rescol.first;
	if (item)
	{
		UnselectChildren(rcol, item);
	}
/*	while (item)
	{
		if (item->firstchild)
		{
			UnselectChildren(rcol, item->firstchild);
		}
		sibling = item->nextsibling;
		item->highlighted = False;

		cell = (XmNlRCL_Cell *) item->cell;

		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (cell[i].textbuf)
			{
				XFreePixmap(XtDisplay((Widget) rcol), cell[i].textbuf);
				cell[i].textbuf = NULL;
			}
		}
		item = sibling;
	}*/
}

static Boolean FoundCurrentInBranch(XmNlResColListWidget rcol, XmNlListTreeItem * branch)
{
	XmNlListTreeItem * item = rcol->rescol.currentTreeNode;
	
	if (!item)
		return False;
		
	item = item->parent;
	while (item)
	{
		if (item == branch)
			return True;
		else
			item = item->parent;
	}
	
	return False;
}

static int FindCurrentTreeNodeInRowList(XmNlResColListWidget rcol)
{
	XmNlListTreeItem * item = rcol->rescol.currentTreeNode;
	XmNlRCL_Cell * cell;
	int i;
	
	if (!item || rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
		return -1;
		
	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
		if (item == cell->node)
			return i;
	}
	
	return -1;
}

static XmNlListTreeItem * FindFirstVisibleParentForCurrentTreeNode(XmNlResColListWidget rcol, int * row_num)
{
	XmNlListTreeItem * item = rcol->rescol.currentTreeNode;
	XmNlRCL_Cell * cell;
	int i;
	
	if (!item || rcol->rescol.num_items == 0 || rcol->rescol.num_rows == 0)
	{
		*row_num = -1;
		return NULL;
	}

	item = item->parent;
	while (item)
	{
		for (i = 0; i < rcol->rescol.num_rows; i++)
		{
			cell = rcol->rescol.ItemData[i] + COL_MAPPED(0);
			if (item == cell->node)
			{
				*row_num = i;
				return item;
			}
		}
		item = item->parent;
	}
		
	*row_num = -1;	
	return NULL;
}


static void ExpandFromCurrentToParent(XmNlResColListWidget rcol, XmNlListTreeItem * parent)
{
	XmNlListTreeItem *item = rcol->rescol.currentTreeNode;

	if (!item)
		return ;
		
	item = item->parent;
	while (item && item != parent)
	{
		item->open = True;
		item = item->parent;
	}
	
	if (item)
		item->open = True;

#ifdef DEBUG
	PrintNodePath(item, "Expansion stoped at");
#endif
}

static void
RCDeleteChildren(XmNlResColListWidget rcol, XmNlListTreeItem *item)
{
	XmNlListTreeItem *sibling;
	XmNlRCL_Cell * cell;
	int i;

	while (item) {
		if (item->firstchild) {
		RCDeleteChildren(rcol, item->firstchild);
		item->firstchild = NULL;
    }
    sibling = item->nextsibling;

/*    if (rcol->rescol.DestroyItemCallback) {
      ret.reason = XmNlDESTROY;
      ret.item = item;
      ret.event = NULL;
      XtCallCallbacks((Widget) rcol, XmNlNdestroyItemCallback, &ret);
    }
*/

    cell = (XmNlRCL_Cell *) item->cell;

    for (i = 0; i < rcol->rescol.num_cols; i++)
    {
		DeleteCell(rcol, cell + COL_MAPPED(i));
		if ((cell + COL_MAPPED(i))->buf) 
			RCFreeCacheNode(rcol, cell + COL_MAPPED(i), COL_MAPPED(i));
	}
	XtFree((char *) cell);
	if (item->lines) 
		free(item->lines);


#ifdef TreeManagementDEBUG
	PrintNodePath(item, "Delete item with sequence number");
#endif

    XtFree((char *) item);
    item = sibling;
  }
}

static void
RCInsertChildAtPos(XmNlResColListWidget rcol, XmNlListTreeItem * pos, XmNlListTreeItem *item)
{
	XmNlListTreeItem *i;
	int seq;

	item->parent = pos->parent;
	item->firstchild = item->nextsibling = item->prevsibling = NULL;
	if (item->parent) {
		item->level = item->parent->level + 1;

		if (item->level > 0)
		{
			char * ptr;
			ptr = malloc(sizeof(char) * item->level);
			item->lines = ptr;
		}

		if (pos->prevsibling) {
			i = pos->prevsibling;
			item->prevsibling = i;
			i->nextsibling = item;
			item->nextsibling = pos;
			pos->prevsibling = item;
//			if ()parent->firstchild = item;
		}
		else {
			item->parent->firstchild = item;
			item->nextsibling = pos;
			pos->prevsibling = item;
		}
	}
	else {			/* if parent==NULL, this is a top level entry */

		if (pos->prevsibling) {
			i = pos->prevsibling;
			item->prevsibling = i;
			i->nextsibling = item;
			item->nextsibling = pos;
			pos->prevsibling = item;
//			if ()parent->firstchild = item;
		}
		else {
			rcol->rescol.first = item;
			item->nextsibling = pos;
			pos->prevsibling = item;
		}


/*		if (rcol->rescol.first) {
			i = rcol->rescol.first;
			item->nextsibling = i;
			i->prevsibling = item;
			rcol->rescol.first = item;
		}
		else {
			rcol->rescol.first = rcol->rescol.topItem = item;
		}*/
	}

	if (item->prevsibling)
		item->sequence = item->prevsibling->sequence + 1;
	else
		item->sequence = 0;

	seq = item->sequence + 1;
	i = item->nextsibling;
	while(i)
	{
		i->sequence = seq;
		seq++;
		i = i->nextsibling;
	}

	rcol->rescol.recount = True;
}


static void
RCAddChildAtPos(XmNlResColListWidget rcol, XmNlListTreeItem * pos, XmNlListTreeItem *item)
{
	XmNlListTreeItem *i;
	int seq;

	item->parent = pos->parent;
	item->firstchild = item->nextsibling = item->prevsibling = NULL;

	if (item->parent) {
		item->level = item->parent->level + 1;

		if (item->level > 0)
		{
			char * ptr;
			ptr = malloc(sizeof(char) * item->level);
			item->lines = ptr;
		}
	}

	if (pos->nextsibling) {
		i = pos->nextsibling;
		pos->nextsibling = item;
		item->prevsibling = pos;
		item->nextsibling = i;
	}
	else {
		pos->nextsibling = item;
		item->prevsibling = pos;
	}

	if (item->prevsibling)
		item->sequence = item->prevsibling->sequence + 1;
	else
		item->sequence = 0;

	seq = item->sequence + 1;
	i = item->nextsibling;
	while(i)
	{
		i->sequence = seq;
		seq++;
		i = i->nextsibling;
	}

	rcol->rescol.recount = True;
}



static void
RCInsertChild(XmNlResColListWidget rcol, XmNlListTreeItem *parent, XmNlListTreeItem *item)
{
	XmNlListTreeItem *i;
	int seq;

	item->parent = parent;
	item->firstchild = item->nextsibling = item->prevsibling = NULL;
	if (parent) {
		item->level = parent->level + 1;

		if (item->level > 0)
		{
			char * ptr;
			ptr = malloc(sizeof(char) * item->level);
			item->lines = ptr;
		}

		if (parent->firstchild) {
			i = parent->firstchild;
			item->nextsibling = i;
			i->prevsibling = item;
			parent->firstchild = item;
		}
		else {
			parent->firstchild = item;
		}
	}
	else {			/* if parent==NULL, this is a top level entry */
		if (rcol->rescol.first) {
			i = rcol->rescol.first;
			item->nextsibling = i;
			i->prevsibling = item;
			rcol->rescol.first = item;
		}
		else {
			rcol->rescol.first = rcol->rescol.topItem = item;
		}
	}
	
	if (item->prevsibling)
		item->sequence = item->prevsibling->sequence + 1;
	else
		item->sequence = 0;

	seq = item->sequence + 1;
	i = item->nextsibling;
	while(i)
	{
		i->sequence = seq;
		seq++;
		i = i->nextsibling;
	}
	
	rcol->rescol.recount = True;
}

static void
RCAddChild(XmNlResColListWidget rcol, XmNlListTreeItem *parent, XmNlListTreeItem *item)
{
	XmNlListTreeItem * i;

	item->parent = parent;
	item->firstchild = item->nextsibling = item->prevsibling = NULL;
	if (parent) {
		item->level = parent->level + 1;

		if (item->level > 0)
		{
			char * ptr;
			ptr = malloc(sizeof(char) * item->level);
			item->lines = ptr;
		}

		if (parent->firstchild) {
			i = parent->firstchild;
			while (i->nextsibling) {
				i = i->nextsibling;
			}
			i->nextsibling = item;
			item->prevsibling = i;
			item->sequence = item->prevsibling->sequence + 1;
		}
		else {
			parent->firstchild = item;
			item->sequence = 0;
		}

	}
	else {			/* if parent==NULL, this is a top level entry */
		if (rcol->rescol.first) {
			i = rcol->rescol.first;
			while (i->nextsibling) {
				i = i->nextsibling;
			}
			i->nextsibling = item;
			item->prevsibling = i;
			item->sequence = item->prevsibling->sequence + 1;
		}
		else {
			rcol->rescol.first = rcol->rescol.topItem = item;
			item->sequence = 0;
		}
	}
	rcol->rescol.recount = True;
}

static void 
RCTreeDeleteAllItems(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlListTreeItem *item, *sibling;
	XmNlRCL_Cell * cell;
	int i;

	if (!rcol->rescol.TreeMode)
		return ;

	item = rcol->rescol.first;
	while (item)
	{
		if (item->firstchild)
		{
			RCDeleteChildren(rcol, item->firstchild);
		}
		sibling = item->nextsibling;

		cell = (XmNlRCL_Cell *) item->cell;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			DeleteCell(rcol, cell + COL_MAPPED(i));
			if ((cell + COL_MAPPED(i))->buf) 
				RCFreeCacheNode(rcol, cell + COL_MAPPED(i), COL_MAPPED(i));
		}
		XtFree((char *) cell);

		if (item->lines) free(item->lines);

#ifdef TreeManagementDEBUG
		PrintNodePath(item, "Deleting node");
#endif

		XtFree((char *) item);

		item = sibling;
	}

	if (rcol->rescol.ItemData) 
	{
		XtFree((char *) (rcol->rescol.ItemData));
		rcol->rescol.ItemData = NULL;
	}

	rcol->rescol.first = NULL;
	rcol->rescol.row_num = 0;
	rcol->rescol.PublicRowCount = 0;


/*********************************************/
	if (rcol->rescol.selected_rows != NULL) 
		XtFree((char*)rcol->rescol.selected_rows);

	rcol->rescol.selected_rows = NULL;

	if (rcol->rescol.cur_sel_massiv != NULL) 
		XtFree((char*)rcol->rescol.cur_sel_massiv);

	ClearSelectedPositions(rcol);

	rcol->rescol.cur_sel_massiv = NULL;
/*	rcol->rescol.PublicSelectedCount = 0;*/
	rcol->rescol.global_v_shift = 0;
	rcol->rescol.v_shift_in_pix = 0;
	rcol->rescol.pix_shift = 0;
	rcol->rescol.cell_height = 0;
	rcol->rescol.full_height = 0;
/*********************************************/


}


/**********/
/* Public */
/**********/


void
XmNlRCTreeRefresh(Widget w)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Property_Row *prow;
	Boolean ActionStatus;
	int i, j, StartRow=0, b_row, end_row, l, k;
	int x, y;
	Boolean AddToFoundedMassiv = False;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean HeightChanged = False;
	int new_cell_h=0;

	RCCountAll(rcol);
	prow = rcol->rescol.prop_data;
	
	rcol->rescol.num_items = rcol->rescol.num_rows * rcol->rescol.num_cols;

	RecalcParam(w, 0, rcol->rescol.num_rows, False, NULL, NULL);

	if (rcol->rescol.resizeCallback && rcol->rescol.num_cols > 1)
	{
		int delta = 0;
		ResizeDoCallback(w, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
				prow[COL_MAPPED(i)].x = delta;
				delta = delta + prow[COL_MAPPED(i)].current_width;
			}
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}

	if (!rcol->rescol.resizeCallback)
		ActionStatus = CalcGeomInit(w);

//	CalcColParam(w);
//printf("XmNlRCTreeRefresh CalcColParam ok\n");

	rcol->rescol.TopLine = rcol->rescol.global_v_shift/rcol->rescol.cell_height;

	rcol->rescol.BotomLine = rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;


#ifdef DEBUG
		printf("\n XmNlRCTreeRefresh");
		fflush(stdout);
		
//		CheckCacheChunk(prow);
#endif
	AdjustGlobalHorShift(w);
	CalcColParam(w);
	ResizeSliders(w, AllScroll);
	if (XtIsRealized(w) )
	{
		RCRedrawAllWindow(w);
	}
//	RefreshTitleBar(rcol);
//printf("XmNlRCTreeRefresh ok\n");
	return ;
}


void
XmNlRCTreeRefreshOff(Widget w)
{
	((XmNlResColListWidget)w)->rescol.Refresh = False;
}


void
XmNlRCTreeRefreshOn(Widget w)
{
	((XmNlResColListWidget)w)->rescol.Refresh = True;
	XmNlRCTreeRefresh(w);
}

void XmNlRCTreeDeleteAllItems(Widget w)
{
    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	int i;

	RCTreeDeleteAllItems(w);
//	XmNlRCTreeRefresh(w);


	RCCountAll(rcol);
	
	rcol->rescol.num_items = 0;


	rcol->rescol.TopLine = 0;

	rcol->rescol.BotomLine = 0;


#ifdef DEBUG
		printf("\n XmNlRCTreeRefresh");
		fflush(stdout);
		
//		CheckCacheChunk(prow);
#endif
	AdjustGlobalHorShift(w);
	CalcColParam(w);
	ResizeSliders(w, AllScroll);
	if (XtIsRealized(w) )
	{
		RCRedrawAllWindow(w);
	}
//	RefreshTitleBar(rcol);
//printf("XmNlRCTreeRefresh ok\n");


}


void RCDeleteItem(XmNlResColListWidget rcol, XmNlListTreeItem *item)
{
//    XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlListTreeItem * child, * sibling;
	XmNlRCL_Cell * cell;
	XmNlRCL_Property_Row *prow;
	int i, j, StartRow=0, b_row, end_row, l, k;
	int x, y;
	int seq;
	Boolean AddToFoundedMassiv = False;
	Boolean RedrawNeed = False;
	Boolean GeomChanged = False;
	Boolean HeightChanged = False;
	Boolean ActionStatus;
	int new_cell_h = 0;

	if (!rcol->rescol.TreeMode)
		return ;

/** First delete all childrens **/

/*	child = item->firstchild;
	if (child)
	{
		if (child->firstchild)
		{
			RCDeleteChildren(rcol, child->firstchild);
		}
		sibling = child->nextsibling;

		cell = (XmNlRCL_Cell *) child->cell;
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			DeleteCell(rcol, cell + i);
		}
		XtFree((char *) cell);

		if (child->lines) 
			free(child->lines);

		XtFree((char *) child);
		child = sibling;
	}
*/

	if (item->firstchild)
		RCDeleteChildren(rcol, item->firstchild);
		
/** Delete cells of item **/

	cell = (XmNlRCL_Cell *) item->cell;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		DeleteCell(rcol, cell + COL_MAPPED(i));
		if ((cell + COL_MAPPED(i))->buf) 
			RCFreeCacheNode(rcol, cell + COL_MAPPED(i), COL_MAPPED(i));
	}
	XtFree((char *) cell);

	if (item->lines) 
		free(item->lines);


#ifdef TreeManagementDEBUG
	PrintNodePath(item, "Deleting node");
#endif

	if (!item->parent)
	{
		if (item->prevsibling)
		{
			item->prevsibling->nextsibling = item->nextsibling;
			if (item->nextsibling)
				item->nextsibling->prevsibling = item->prevsibling;
			
/** Refresh sequence number for all node after deleted node **/
			sibling = item->prevsibling;
			seq = sibling->sequence + 1;
			sibling = sibling->nextsibling;
			while (sibling)
			{
				sibling->sequence = seq;
				seq++;
				sibling = sibling->nextsibling;
			}
		}
		else
		{
			rcol->rescol.first = item->nextsibling;
			if (item->nextsibling)
				item->nextsibling->prevsibling = NULL;

/** Refresh sequence number for all node after deleted node **/
			seq = 0;
			sibling = item->nextsibling;
			while (sibling)
			{
				sibling->sequence = seq;
				seq++;
				sibling = sibling->nextsibling;
			}
		}
	}
	else
	{
		if (item->prevsibling)
		{
			item->prevsibling->nextsibling = item->nextsibling;
			if (item->nextsibling)
				item->nextsibling->prevsibling = item->prevsibling;

/** Refresh sequence number for all node after deleted node **/
			sibling = item->prevsibling;
			seq = sibling->sequence + 1;
			sibling = sibling->nextsibling;
			while (sibling)
			{
				sibling->sequence = seq;
				seq++;
				sibling = sibling->nextsibling;
			}
		}
		else
		{
			item->parent->firstchild = item->nextsibling;
			if (item->nextsibling)
				item->nextsibling->prevsibling = item->prevsibling;

/** Refresh sequence number for all node after deleted node **/
			seq = 0;
			sibling = item->nextsibling;
			while (sibling)
			{
				sibling->sequence = seq;
				seq++;
				sibling = sibling->nextsibling;
			}
		}
	}

	XtFree((char *) item);

	RCCountAll(rcol);
	
//	rcol->rescol.PublicRowCount = rcol->rescol.num_rows;
	
	prow = rcol->rescol.prop_data;
	
	rcol->rescol.num_items = rcol->rescol.num_rows * rcol->rescol.num_cols;

	RecalcParam((Widget) rcol, 0, rcol->rescol.num_rows, False, NULL, NULL);

	if (rcol->rescol.resizeCallback && rcol->rescol.num_cols > 1)
	{
		int delta = 0;
		ResizeDoCallback((Widget) rcol, XmNlItemsFound, XmNlContentChange);
		for (i = 0; i < rcol->rescol.num_cols; i++)
		{
			if (prow[COL_MAPPED(i)].current_width != rcol->rescol.col_new_width[i])
			{
				ActionStatus = True;
				prow[COL_MAPPED(i)].current_width = rcol->rescol.col_new_width[i];
				prow[COL_MAPPED(i)].x = delta;
				delta = delta + prow[COL_MAPPED(i)].current_width;
			}
//			printf("Rescol: returned for col %d %d\n", i, prow[i].current_width);
		}
		if (rcol->rescol.new_global_h_shift != rcol->rescol.global_h_shift)
		{
			RedrawNeed = True;
			rcol->rescol.global_h_shift = rcol->rescol.new_global_h_shift;
		}
	}

	if (!rcol->rescol.resizeCallback)
		ActionStatus = CalcGeomInit((Widget) rcol);


	rcol->rescol.TopLine=rcol->rescol.global_v_shift/rcol->rescol.cell_height;

	rcol->rescol.BotomLine=rcol->rescol.TopLine + rcol->rescol.viewHeight/rcol->rescol.cell_height + 2;


#ifdef DEBUG
		printf("\n XmNlRCTreeRefresh");
		fflush(stdout);
#endif
	AdjustGlobalHorShift((Widget) rcol);
	CalcColParam((Widget) rcol);
	ResizeSliders((Widget) rcol, AllScroll);
	if (XtIsRealized((Widget) rcol))
	{
		RCRedrawAllWindow((Widget) rcol);
	}

//	if (rcol->rescol.title_bar) 
//		RefreshTitleBar(rcol);

	return ;
}


static XmNlListTreeItem *
RCAddItem(XmNlResColListWidget rcol, XmNlListTreeItem * parent,
			XmNlRCListTreeItemType type, XmNlCell * data, unsigned char valuemask, char adding)
{
	XmNlListTreeItem *item;
	int len, i, k;
	char *copy;
	XmNlRCL_Cell * cell;
	XmNlRCL_Property_Row *prow;
	Display *dpy = XtDisplay((Widget) rcol);
	unsigned int width, height, bw, depth;
	int new_cell_h = 0;
	int x, y;
	Window root;
	IconInfo * icon;

#ifdef DEBUG
	printf("RCAddItem col num %d\n", rcol->rescol.num_cols);
	fflush(stdout);
#endif

	item = (XmNlListTreeItem *) XtMalloc(sizeof(XmNlListTreeItem));
	item->type = type;
	item->parent = parent;
	item->open = rcol->rescol.default_mode;
//	if (parent == NULL) item->open = TRUE;
	item->highlighted = False;
	item->openPixmap = item->closedPixmap = XmUNSPECIFIED_PIXMAP;
	item->openMask = item->closedMask = XmUNSPECIFIED_PIXMAP;
	item->firstchild = item->prevsibling = item->nextsibling = NULL;
	item->level = 0;
	item->lines = NULL;

/****************************/
/** Create options columns **/
/****************************/

	rcol->rescol.full_selection_w = rcol->rescol.select_line_w+rcol->rescol.select_line_margin;

	rcol->rescol.full_margin_h = rcol->rescol.margin_h + rcol->rescol.full_selection_w;
	rcol->rescol.full_margin_w = rcol->rescol.margin_w;
	rcol->rescol.full_pl_margin = rcol->rescol.margin_w + rcol->rescol.full_selection_w;;


	cell = (XmNlRCL_Cell * )XtMalloc(rcol->rescol.num_cols * sizeof (XmNlRCL_Cell));
	item->cell = (XtPointer) cell;

	prow = rcol->rescol.prop_data;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		cell[COL_MAPPED(i)].textbuf = XmUNSPECIFIED_PIXMAP;
		cell[COL_MAPPED(i)].node = item;
		cell[COL_MAPPED(i)].buf = NULL;

/*********** In column pixmaps *************/

	 	if (prow[COL_MAPPED(i)].info_type == XmPIXMAP)
		{
			cell[COL_MAPPED(i)].text = NULL;
			cell[COL_MAPPED(i)].xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
			cell[COL_MAPPED(i)].complabel = NULL;
#endif
			if ((valuemask & CellPixmap) && PIX_FOUND(data[i].pixmap))
			{
				if (PIX_FOUND(data[i].mask)) icon = AddIconToList((Widget) rcol, data[i].pixmap, data[i].mask);
				else icon = AddIconToList((Widget) rcol, data[i].pixmap, XmUNSPECIFIED_PIXMAP);
				if (icon)
				{
					cell[COL_MAPPED(i)].icon = icon;
					icon->use_counter ++;

					width = icon->width;
					height = icon->height;
				}
				else
				{
					cell[COL_MAPPED(i)].icon = NULL;
					width = 0;
					height = 0;
				}
			}
			else
			{
				cell[COL_MAPPED(i)].icon = NULL;
				width = 0;
				height = 0;
			}

			if (height > new_cell_h) new_cell_h = height;

			if (width + 2*rcol->rescol.margin_w > prow[i].real_width)
					prow[i].real_width = width + 2*rcol->rescol.margin_w;

		}
/* In column text   */
		if (prow[COL_MAPPED(i)].info_type == XmSTRING)
		{
			cell[COL_MAPPED(i)].buf = NULL;
			cell[COL_MAPPED(i)].icon = NULL;

			if (valuemask & CellCharString) cell[COL_MAPPED(i)].text = data[i].text;
			else cell[COL_MAPPED(i)].text = NULL;
			if (valuemask & CellXmString)
			{
				cell[COL_MAPPED(i)].xmlabel = XmStringCopy(data[i].xmlabel);
				cell[COL_MAPPED(i)].label_w = XmStringWidth(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
				cell[COL_MAPPED(i)].label_h = XmStringHeight(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = CreateSegmentedXmString(data[i].xmlabel);
/*				SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[i].complabel, 
										&(cell[i].label_w), &(cell[i].label_h));*/
				SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[COL_MAPPED(i)].complabel, 
										&(cell[COL_MAPPED(i)].label_w), &(cell[COL_MAPPED(i)].label_h), rcol->rescol.idxRend);
#endif
			}
			else
			{
				cell[COL_MAPPED(i)].xmlabel = NULL;
				cell[COL_MAPPED(i)].label_w = 0;
				cell[COL_MAPPED(i)].label_h = 0;
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = NULL;
#endif
			}

			if (cell[COL_MAPPED(i)].label_h > new_cell_h) new_cell_h = cell[COL_MAPPED(i)].label_h;

			if (cell[COL_MAPPED(i)].label_w + 2*rcol->rescol.margin_w > prow[COL_MAPPED(i)].real_width)
					prow[COL_MAPPED(i)].real_width = cell[COL_MAPPED(i)].label_w + 2*rcol->rescol.margin_w;
		}


		if (valuemask & CellSelection)
		{
			cell[COL_MAPPED(i)].selected = data[i].selected;
		}
		else
			cell[COL_MAPPED(i)].selected = 0;

		cell[COL_MAPPED(i)].buf = NULL;

		if (valuemask & CellAlignment) cell[COL_MAPPED(i)].alignment = data[i].alignment;
		else cell[COL_MAPPED(i)].alignment = XmALIGNMENT_UNSPECIFIED;

		if (valuemask & CellUserData) cell[COL_MAPPED(i)].UserDataPointer = data[i].UserDataPointer;
		else cell[COL_MAPPED(i)].UserDataPointer = NULL;

#ifdef DEBUG
			printf("|| %d, %d ", prow[COL_MAPPED(i)].new_real_width, cell[COL_MAPPED(i)].label_w);
#endif
	}

#ifdef DEBUG
	printf("\n");
#endif

	if (rcol->rescol.maxPixHeight > new_cell_h) new_cell_h = rcol->rescol.maxPixHeight;

	if ((new_cell_h + 2*rcol->rescol.margin_h) > rcol->rescol.cell_height)
	{
		rcol->rescol.cell_height = new_cell_h + 2*rcol->rescol.margin_h;
		CreateLinePix(rcol);
//		HeightChanged = True;
	}

	if ((rcol->rescol.maxPixHeight + 2*rcol->rescol.margin_h) > rcol->rescol.cell_height)
	{
		rcol->rescol.cell_height = rcol->rescol.maxPixHeight + 2*rcol->rescol.margin_h;
		CreateLinePix(rcol);
//		HeightChanged = True;
	}

	if (adding)
		RCAddChild(rcol, parent, item);
	else
		RCInsertChild(rcol, parent, item);

	if (parent)
		parent->type = XmNlBRANCH;
	RCSetCacheBufLimit((Widget) rcol);

#ifdef DEBUG
	printf("RCAddItem: cell -> %s\n", ((XmNlRCL_Cell *) item->cell)->text);
#endif
	return item;
}


static XmNlListTreeItem *
RCAddItemAtPos(XmNlResColListWidget rcol, XmNlListTreeItem * pos,
			XmNlRCListTreeItemType type, XmNlCell * data, unsigned char valuemask, char adding)
{
	XmNlListTreeItem *item;
	int len, i, k;
	char *copy;
	XmNlRCL_Cell * cell;
	XmNlRCL_Property_Row *prow;
	Display *dpy = XtDisplay((Widget) rcol);
	unsigned int width, height, bw, depth;
	int new_cell_h=0;
	int x, y;
	Window root;
	IconInfo * icon;
#ifdef DEBUG
	printf("RCAddItem\n");
	fflush(stdout);
#endif

	item = (XmNlListTreeItem *) XtMalloc(sizeof(XmNlListTreeItem));
	item->type = type;
	item->parent = pos->parent;
	item->open = rcol->rescol.default_mode;
//	if (parent == NULL) item->open = TRUE;
	item->highlighted = False;
	item->openPixmap = item->closedPixmap = XmUNSPECIFIED_PIXMAP;
	item->openMask = item->closedMask = XmUNSPECIFIED_PIXMAP;
	item->firstchild = item->prevsibling = item->nextsibling = NULL;
	item->level = 0;
	item->lines = NULL;

/****************************/
/** Create options columns **/
/****************************/

	rcol->rescol.full_selection_w = rcol->rescol.select_line_w+rcol->rescol.select_line_margin;

	rcol->rescol.full_margin_h = rcol->rescol.margin_h + rcol->rescol.full_selection_w;
	rcol->rescol.full_margin_w = rcol->rescol.margin_w;
	rcol->rescol.full_pl_margin = rcol->rescol.margin_w + rcol->rescol.full_selection_w;;


	cell = (XmNlRCL_Cell * )XtMalloc(rcol->rescol.num_cols * sizeof (XmNlRCL_Cell));
	item->cell = (XtPointer) cell;

	prow = rcol->rescol.prop_data;
	for (i = 0; i < rcol->rescol.num_cols; i++)
	{
		cell[COL_MAPPED(i)].textbuf = XmUNSPECIFIED_PIXMAP;
		cell[COL_MAPPED(i)].node = item;
		cell[COL_MAPPED(i)].buf = NULL;

/*********** In column pixmaps *************/

	 	if (prow[COL_MAPPED(i)].info_type == XmPIXMAP)
		{
			cell[COL_MAPPED(i)].text = NULL;
			cell[COL_MAPPED(i)].xmlabel = NULL;
#ifdef FAST_XMSTRING_RENDERING
			cell[COL_MAPPED(i)].complabel = NULL;
#endif

			if ((valuemask & CellPixmap) && PIX_FOUND(data[i].pixmap))
			{
				if (PIX_FOUND(data[i].mask)) icon = AddIconToList((Widget) rcol, data[i].pixmap, data[i].mask);
				else icon = AddIconToList((Widget) rcol, data[i].pixmap, XmUNSPECIFIED_PIXMAP);
				if (icon)
				{
					cell[COL_MAPPED(i)].icon = icon;
					icon->use_counter ++;

					width = icon->width;
					height = icon->height;
				}
				else
				{
					cell[COL_MAPPED(i)].icon = NULL;
					width = 0;
					height = 0;
				}
			}
			else
			{
				cell[COL_MAPPED(i)].icon = NULL;
				width = 0;
				height = 0;
			}

			if (height > new_cell_h) new_cell_h = height;

			if (width + 2*rcol->rescol.margin_w > prow[COL_MAPPED(i)].real_width)
					prow[COL_MAPPED(i)].real_width = width + 2*rcol->rescol.margin_w;

		}
/* In column text   */
		if (prow[COL_MAPPED(i)].info_type == XmSTRING)
		{
			cell[COL_MAPPED(i)].buf = NULL;
			cell[COL_MAPPED(i)].icon = NULL;

			if (valuemask & CellCharString) cell[COL_MAPPED(i)].text = data[i].text;
			else cell[COL_MAPPED(i)].text = NULL;
			if (valuemask & CellXmString)
			{
				cell[COL_MAPPED(i)].xmlabel = XmStringCopy(data[i].xmlabel);
				cell[COL_MAPPED(i)].label_w = XmStringWidth(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
				cell[COL_MAPPED(i)].label_h = XmStringHeight(rcol->rescol.font_list, cell[COL_MAPPED(i)].xmlabel);
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = CreateSegmentedXmString(data[i].xmlabel);
/*				SegmentedXmStringExtent2(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[i].complabel, 
										&(cell[i].label_w), &(cell[i].label_h));*/
				SegmentedXmStringExtent3(XtDisplay((Widget) rcol), rcol->rescol.font_list, 
										cell[COL_MAPPED(i)].complabel, 
										&(cell[COL_MAPPED(i)].label_w), &(cell[COL_MAPPED(i)].label_h), rcol->rescol.idxRend);
#endif
			}
			else
			{
				cell[COL_MAPPED(i)].xmlabel = NULL;
				cell[COL_MAPPED(i)].label_w = 0;
				cell[COL_MAPPED(i)].label_h = 0;
#ifdef FAST_XMSTRING_RENDERING
				cell[COL_MAPPED(i)].complabel = NULL;
#endif
			}

			if (cell[COL_MAPPED(i)].label_h > new_cell_h) new_cell_h = cell[COL_MAPPED(i)].label_h;

			if (cell[COL_MAPPED(i)].label_w + 2*rcol->rescol.margin_w > prow[COL_MAPPED(i)].real_width)
					prow[COL_MAPPED(i)].real_width = cell[COL_MAPPED(i)].label_w + 2*rcol->rescol.margin_w;
		}


		if (valuemask & CellSelection)
			cell[COL_MAPPED(i)].selected = data[i].selected;
		else
			cell[COL_MAPPED(i)].selected = 0;

		cell[COL_MAPPED(i)].buf = NULL;

		if (valuemask & CellAlignment) cell[COL_MAPPED(i)].alignment = data[i].alignment;
		else cell[COL_MAPPED(i)].alignment = XmALIGNMENT_UNSPECIFIED;

		if (valuemask & CellUserData) cell[COL_MAPPED(i)].UserDataPointer = data[i].UserDataPointer;
		else cell[COL_MAPPED(i)].UserDataPointer = NULL;

#ifdef DEBUG
			printf("|| %d, %d ", prow[COL_MAPPED(i)].new_real_width, cell[COL_MAPPED(i)].label_w);
#endif
	}

#ifdef DEBUG
	printf("\n");
#endif

	if (rcol->rescol.maxPixHeight > new_cell_h) new_cell_h = rcol->rescol.maxPixHeight;

	if ((new_cell_h + 2*rcol->rescol.margin_h) > rcol->rescol.cell_height)
	{
		rcol->rescol.cell_height = new_cell_h + 2*rcol->rescol.margin_h;
		CreateLinePix(rcol);
//		HeightChanged = True;
	}

	if ((rcol->rescol.maxPixHeight + 2*rcol->rescol.margin_h) > rcol->rescol.cell_height)
	{
		rcol->rescol.cell_height = rcol->rescol.maxPixHeight + 2*rcol->rescol.margin_h;
		CreateLinePix(rcol);
//		HeightChanged = True;
	}

	if (adding)
		RCAddChildAtPos(rcol, pos, item);
	else
		RCInsertChildAtPos(rcol, pos, item);

	RCSetCacheBufLimit((Widget) rcol);

#ifdef DEBUG
	printf("RCAddItem: cell -> %s\n", ((XmNlRCL_Cell *) item->cell)->text);
#endif
	return item;
}

int RCAppendColumn(XmNlResColListWidget rcol)
{
	XmNlRCL_Property_Row * prow;
	XmNlRCL_Cell  * cell;
	int i, j;
	IconInfo * icon;

	if (rcol->rescol.TreeMode) return -1;

	prow = rcol->rescol.prop_data;

#ifdef DEBUG
	printf("\n RCAppendColumn started");
	fflush(stdout);
#endif

	


	for (i = 0; i < rcol->rescol.num_rows; i++)
	{
		cell = (XmNlRCL_Cell *) XtRealloc((char *) rcol->rescol.ItemData[i], sizeof(XmNlRCL_Cell) * rcol->rescol.num_cols);
		if (!cell)
			return -1;
			
		rcol->rescol.ItemData[i] = cell;
		j = rcol->rescol.num_cols - 1;

		cell[COL_MAPPED(j)].buf = NULL;

		cell[COL_MAPPED(j)].icon = NULL;
		cell[COL_MAPPED(j)].xmlabel = NULL;
		cell[COL_MAPPED(j)].label_h = 0;
		cell[COL_MAPPED(j)].label_w = 0;
#ifdef FAST_XMSTRING_RENDERING
		cell[COL_MAPPED(j)].complabel = NULL;
#endif

		cell[COL_MAPPED(j)].selected = 0;

		cell[COL_MAPPED(j)].alignment = XmALIGNMENT_UNSPECIFIED;

		cell[COL_MAPPED(j)].UserDataPointer = NULL;
	}

#ifdef DEBUG
	printf("\n RCAppendColumn complete\n");
#endif

	return 0;
}




XmNlListTreeItem *
XmNlRCTreeAdd(Widget w, XmNlListTreeItem *parent, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItem ((XmNlResColListWidget)w, parent, RCItemDetermineType, data, valuemask, 1));
}

XmNlListTreeItem *
XmNlRCTreeInsert(Widget w, XmNlListTreeItem *parent, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItem ((XmNlResColListWidget)w, parent, RCItemDetermineType, data, valuemask, 0));
}

XmNlListTreeItem *
XmNlRCTreeAddType(Widget w, XmNlListTreeItem *parent,
                XmNlRCListTreeItemType type, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItem((XmNlResColListWidget)w, parent, type, data, valuemask, 1));
}


XmNlListTreeItem *
XmNlRCTreeAddBranch(Widget w, XmNlListTreeItem *parent, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItem((XmNlResColListWidget)w, parent, RCItemBranchType, data, valuemask, 1));
}


XmNlListTreeItem *
XmNlRCTreeAddLeaf(Widget w, XmNlListTreeItem *parent,  XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItem((XmNlResColListWidget)w, parent, RCItemLeafType, data, valuemask, 1));
}

XmNlListTreeItem *
XmNlRCTreeDeleteItem(Widget w, XmNlListTreeItem * item)
{
#ifdef TreeManagementDEBUG
	PrintNodePath(item, "XmNlRCTreeDeleteItem: dlete item with sequence number");
#endif

    RCDeleteItem((XmNlResColListWidget)w, item);
}

XmNlListTreeItem *
XmNlRCTreeInsertBeforeItem(Widget w, XmNlListTreeItem * item, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItemAtPos ((XmNlResColListWidget)w, item, RCItemDetermineType, data, valuemask, 0));
}

XmNlListTreeItem *
XmNlRCTreeAddAfterItem(Widget w, XmNlListTreeItem * item, XmNlCell * data, unsigned char valuemask)
{
    return (RCAddItemAtPos ((XmNlResColListWidget)w, item, RCItemDetermineType, data, valuemask, 1));
}

void
XmNlTreeSetItemPixmaps (Widget w, XmNlListTreeItem *item,
                        Pixmap openPixmap, Pixmap closedPixmap, Pixmap openMask, Pixmap closedMask)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	Window root;
	unsigned int pixwidth, pixheight, pixbw, pixdepth;
	int pixx, pixy;

	item->openPixmap   = openPixmap;
	item->closedPixmap = closedPixmap;
	item->openMask   = openMask;
	item->closedMask = closedMask;

	XGetGeometry(XtDisplay((Widget) rcol), openPixmap, &root, &pixx, &pixy,
					&pixwidth, &pixheight, &pixbw, &pixdepth);
	if (pixheight > rcol->rescol.maxPixHeight) 
		rcol->rescol.maxPixHeight = pixheight;

	if (pixwidth > rcol->rescol.pixWidth) 
		rcol->rescol.pixWidth = pixwidth;

	XGetGeometry(XtDisplay((Widget) rcol), closedPixmap, &root, &pixx, &pixy,
					&pixwidth, &pixheight, &pixbw, &pixdepth);

	if (pixwidth > rcol->rescol.pixWidth) 
		rcol->rescol.pixWidth = pixwidth;

	if (pixheight > rcol->rescol.maxPixHeight) 
		rcol->rescol.maxPixHeight = pixheight;
}

XmNlListTreeItem *
XmNlRCTreeGetItemByRow (Widget w, int row)
{
	XmNlResColListWidget rcol = (XmNlResColListWidget) w;
	XmNlRCL_Cell  * cell;

	if (row < 0 || row > rcol->rescol.num_rows || rcol->rescol.num_rows == 0 || !rcol->rescol.ItemData) 
		return NULL;

	cell = rcol->rescol.ItemData[row] + COL_MAPPED(0);

#ifdef TreeManagementDEBUG
	PrintNodePath(cell->node, "Path to node");
#endif

	return cell->node;
}

