/*
 *    Copyright 2004, Sergey Sharashkin.
 *
 *		       All Rights Reserved.
 *
 * AUTHOR: Sergey Sharashkin
 *
 */

#ifndef _XmNlPartResP_h
#define _XmNlPartResP_h

#if defined(VMS) || defined(__VMS)
#include <X11/apienvset.h>
#endif

/************************************************************
*	INCLUDE FILES
*************************************************************/
#include <Xm/PrimitiveP.h>

#include "XmNlPartRes.h"

/************************************************************
*	TYPEDEFS AND DEFINES
*************************************************************/

#if defined(__cplusplus)
extern "C" {
#endif


#define XmNlPartRes (XmPrimitiveIndex + 1)

#define RtoL_render 1
#define LtoR_render 2

/************************************************************
*	GLOBAL DECLARATIONS
*************************************************************/




typedef struct _XmNlPR_Cell {
Pixmap pixmap;
Pixmap mask;
Dimension pix_w;
Dimension pix_h;
String text;
XmString xmlabel;
Dimension label_w;
Dimension label_h;
Pixmap pixbuf;
Dimension pixbuf_w;
Dimension pixbuf_h;
Dimension real_width;
Dimension current_width;
unsigned char info_type;
//Pixmap pix_buf;
Boolean resizible;
Boolean autoresize;
int align_type;
Boolean displayed;
unsigned char alignment;
unsigned char priority;
int x;
void * UserDataPointer;
int value;
} XmNlPR_Cell;


typedef struct _PartResClassPart {
    XtPointer extension;	/* Just in case we need it later. */
} PartResClassPart;

typedef struct _XmNlPartResClassRec {
    CoreClassPart		core_class;
    XmPrimitiveClassPart	primitive;
    PartResClassPart		pres_class;
} XmNlPartResClassRec;

typedef struct _XmNlPartResPart {
    /*
     * Resources
     */

  XFontStruct *font;
  Dimension viewX;
  Dimension viewY;
  Dimension viewWidth;
  Dimension viewHeight;
  Dimension lastViewWidth;
  Dimension lastViewHeight;
  Dimension prefferedHeight;
  GC pixGC;
  GC drawGC;
  GC eraseGC;
  GC eorGC;
  GC highlightGC;
  GC top_GC;
  GC bottom_GC;
  XmNlPR_Cell * item_data;
  char ResizeMode;
  Boolean buffering;
//  int count_cell;
  int num_items;
  int MaxSize; /* Full size of all partitions, needed in auto resize mode */
  int *PartitionsSize; /* Personal partition size, needed in auto resize mode */
//  int num_rows; /* number of rows in the list. */
//  int num_cols;
  Pixmap pix;		/* Off screen pixmap bufer		*/
  unsigned int cell_width;
  unsigned int cell_height;
  Boolean MouseMoved;
  Boolean LayoutFrozen;
  Boolean ChangeInFrozen;
  Boolean ResizeState;
  Boolean RepartingOn;
  Cursor hResizeCursor;
  Position CurrentResizerPos;
  Position StartResizerPos;
  Position LastResizerPos;
	unsigned char render_order;
	int * ElSharpSize;
	int * ElCurSize;
	int * ElNewSize;
  int * RealW;
  int CurrentResizedPos;
//  int pix_buf_w;		/* Off screen pixmap bufer width	*/
//  int pix_buf_h;		/* Off screen pixmap bufer height	*/
  int col_num;		/* Column number in file view win	*/
  int row_num;		/* Row number in file view win		*/
	unsigned char default_type;
	unsigned char default_align;
	unsigned char default_priority;
  int max_icon_height;
  int max_icon_width;
  int full_height;
  int full_width;
  int scroll_height;
  int scroll_width;
//  int pix_buf_row;
//  int pix_shift;
  int global_v_shift;
  int global_h_shift;
//  int v_shift_in_pix;
//  Time sm_tm;
//  Time multiclick;
    XmFontList font_list;	/* This widget's font list. */

    /*Widget v_bar, h_bar;*/	/* Scrollbars that may be used
				   to scroll this widget. */


    XtCallbackList changeCallback; /* The resize callback list for widget. */

    XtCallbackList changeStructPartCallback; /* The resize callback list for parts of widget. */

    XtCallbackList double_click; /* The double click callback list. */
//    XtCallbackList single_select; /*The single click callback list. */
    XtCallbackList highlightCallback;

    XtCallbackList startMoveCallback; /* The start resize callback list for parts of widget. */
    XtCallbackList moveCallback; /* The resize in progress callback list for parts of widget. */
    XtCallbackList resizeCallback; /* The resize callback for all widget. */


    /* 
     * Private State
     */


    unsigned short state;	/* The state of this widget. */
    XtIntervalId timeout;	/* The mulit - click timout. */

    Time time;			/*The server time of the last button click. */


    Pixel background_pixel;
    Pixel foreground_pixel;
/*    Pixel select_background_pixel;
    Pixel select_foreground_pixel;
	int	m_select;
	int	m_x1;
	int	m_x2;
	int	m_y1;
	int	m_y2;
	int	m_last_x1;
	int	m_last_x2;
	int	m_last_y1;
	int	m_last_y2;
	int	m_cur_x;
	int	m_cur_y;
	int	m_b_x;
	int	m_b_y;
	int	auto_scroll;
	int	interval;
	int	delta_shift;
	XtIntervalId motion_timer;
	int 	old_sel_count;
	int *	old_sel_massiv;
	int	cur_sel_count;
	int *	cur_sel_massiv;
*/
} XmNlPartResPart;

typedef struct _XmNlPartResRec {
    CorePart		core;
    XmPrimitivePart	primitive;
    XmNlPartResPart	partres;
} XmNlPartResRec;


/************************************************************
*	EXTERNAL DECLARATIONS
*************************************************************/





extern XmNlPartResClassRec xmNlPartResClassRec;
extern WidgetClass xmNlPartResWidgetClass; 

#if defined(__cplusplus)
}
#endif

/************************************************************
*	STATIC DECLARATIONS
*************************************************************/

#if defined(VMS) || defined(__VMS)
#include <X11/apienvrst.h>
#endif

#endif /* _XmPartResP_h */
